/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.tablesegment.dataaggregate;

import com.ibm.pdp.engine.IEngineFactory;
import com.ibm.pdp.engine.IGeneratedInfoFactory;
import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.framework.util.PdpUtil;
import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.pacbase.generate.DefaultPacbaseGenerationImplementation;
import com.ibm.pdp.pacbase.generate.util.PacbaseLinksEntitiesService;
import com.ibm.pdp.pacbase.tablesegment.dataaggregate.TableSegmentGenerationDA;
import com.ibm.pdp.util.Util;

public class TableSegmentGeneration
extends DefaultPacbaseGenerationImplementation {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015, 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String project;
    private DataAggregate dataAggregate;
    private TableSegmentGenerationDA w1Model = null;

    public TableSegmentGeneration(DataAggregate bb, String patternName) {
        this.dataAggregate = bb;
        this.project = bb.getProject();
        this.patternName = patternName;
        int resolMode = PTEditorService.getResolvingMode();
        PTEditorService.setResolvingMode((int)3);
        this.initTableSegment();
        PTEditorService.setResolvingMode((int)resolMode);
    }

    private void initTableSegment() {
        try {
            this.findAndGetW1File();
            this.transformToGeneratedInfo();
        }
        catch (Exception e) {
            e.printStackTrace();
            Util.rethrow((Throwable)e);
        }
    }

    private void findAndGetW1File() {
        this.w1Model = new TableSegmentGenerationDA(this.getProject(), this.getTableSegment(), this.patternName);
    }

    private String getProject() {
        return this.project;
    }

    public DataAggregate getTableSegment() {
        return this.dataAggregate;
    }

    private void transformToGeneratedInfo() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.w1Model.getformatedLines().getExtractLines().size()) {
            sb.append(this.w1Model.getformatedLines().getExtractLines().get(i) + System.getProperty("line.separator"));
            ++i;
        }
        IEngineFactory engineFactory = PdpUtil.newEngineFactory();
        IGeneratedInfoFactory genInfoFactory = engineFactory.newGeneratedInfoFactory();
        genInfoFactory.beginTag(this.dataAggregate.getName());
        genInfoFactory.appendText((CharSequence)sb);
        genInfoFactory.endTag();
        this.generatedInfo = genInfoFactory.createGeneratedInfo();
        this.generatedInfo.setProperty("pattern", "com.ibm.pdp.pacbase.tablesegment");
        this.generatedInfo.setProperty("ReconcileMode", "NoReconcile");
    }

    public PacbaseLinksEntitiesService getReferencedEntities() {
        return this.w1Model.getPacLinksEntitiesService();
    }

    protected String[] getCommandLineForgenerator() {
        return null;
    }

    protected void vapCobolGeneration() {
    }
}

