/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.tablesegment.dataaggregate;

import com.ibm.pdp.explorer.nature.PTNature;
import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.kernel.DataAggregateDescription;
import com.ibm.pdp.mdl.kernel.DataCall;
import com.ibm.pdp.mdl.kernel.DataComponent;
import com.ibm.pdp.mdl.kernel.DataElement;
import com.ibm.pdp.mdl.kernel.DataElementDescription;
import com.ibm.pdp.mdl.kernel.DataUnion;
import com.ibm.pdp.mdl.kernel.DataUnionDescription;
import com.ibm.pdp.mdl.kernel.Filler;
import com.ibm.pdp.mdl.kernel.KernelPackage;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacDataAggregate;
import com.ibm.pdp.mdl.pacbase.PacDataCall;
import com.ibm.pdp.mdl.pacbase.PacDataCallMore;
import com.ibm.pdp.mdl.pacbase.PacDataElement;
import com.ibm.pdp.mdl.pacbase.PacbasePackage;
import com.ibm.pdp.mdl.pacbase.impl.PacDLineImpl;
import com.ibm.pdp.mdl.pacbase.impl.PacDataElementImpl;
import com.ibm.pdp.mdl.pacbase.lal.util.GenerationContext;
import com.ibm.pdp.mdl.pacbase.lal.util.LengthAndPositionVisitor;
import com.ibm.pdp.mdl.pacbase.lal.util.PacbaseLalDescription;
import com.ibm.pdp.pacbase.generate.util.PacbaseLinksEntitiesService;
import com.ibm.pdp.pacbase.generate.util.PacbaseModelService;
import com.ibm.pdp.pacbase.tablesegment.model.A833;
import com.ibm.pdp.pacbase.tablesegment.model.EY12;
import com.ibm.pdp.pacbase.tablesegment.model.PacbaseSegment;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class SegmentCompositionPacbaseAndKernelVisitor {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2019.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final PacbasePackage modelPackagePB = PacbasePackage.eINSTANCE;
    protected static final KernelPackage modelPackageKernel = KernelPackage.eINSTANCE;
    protected String borne = "BORNE=DE ";
    protected String notCoded = "-NC-";
    protected String nbVal = "NBVAL=";
    private String redefines = "R*";
    private String segmentCodeToUse;
    private int nuligToUse;
    private int numer;
    private ArrayList<PacbaseSegment> segmentCompositionLines = new ArrayList();
    private DataCall currentDataCall;
    private int numberOfCorub = 0;
    private boolean firstTime = true;
    private boolean firstTimeForDataAggregate = true;
    private boolean writeLengthRecord = false;
    private char variant;
    private String libName;
    private String subSchema;
    private ArrayList<PacbaseLalDescription> lalList = new ArrayList();
    private DataUnionDescription _currentDataUnionDescription = null;
    private boolean dataForRedefines = false;
    private DataElement dataElt;
    private PacbaseLinksEntitiesService ples;
    private RadicalEntity generationEntryPoint;
    private String SEGSEL;
    private ArrayList<String> listOfSelectedSeg;
    public String segmentCodefromCSLine;
    private String currentSegmentCode;

    public SegmentCompositionPacbaseAndKernelVisitor(PacbaseLinksEntitiesService ples, RadicalEntity re) {
        this.ples = ples;
        this.generationEntryPoint = re;
    }

    public void doSwitch(EObject theEObject) {
        this.doSwitch(theEObject.eClass(), theEObject);
    }

    protected void doSwitch(EClass theEClass, EObject theEObject) {
        if (theEObject instanceof RadicalEntity) {
            this.getPacLinksEntitiesService().registerReference((RadicalEntity)theEObject);
        }
        if (theEClass.eContainer() == modelPackagePB) {
            this.doSwitchPB(theEClass.getClassifierID(), theEObject);
        } else if (theEClass.eContainer() == modelPackageKernel) {
            this.doSwitchKernel(theEClass.getClassifierID(), theEObject);
        }
    }

    protected void doSwitchKernel(int classifierID, EObject theEObject) {
        switch (classifierID) {
            case 37: {
                DataCall kernelObject = (DataCall)theEObject;
                this.caseDataCall(kernelObject);
                break;
            }
            case 45: {
                DataAggregate kernelObject = (DataAggregate)theEObject;
                this.caseDataAggregate(kernelObject);
                break;
            }
            case 18: {
                DataAggregateDescription kernelObject = (DataAggregateDescription)theEObject;
                this.caseDataAggregateDescription(kernelObject);
                break;
            }
            case 44: {
                DataElement kernelObject = (DataElement)theEObject;
                this.caseDataElement(kernelObject);
                break;
            }
            case 33: {
                DataElementDescription kernelObject = (DataElementDescription)theEObject;
                this.caseDataElementDescription(kernelObject);
                break;
            }
            case 43: {
                Filler kernelObject = (Filler)theEObject;
                this.caseFiller(kernelObject);
                break;
            }
            case 46: {
                DataUnion kernelObject = (DataUnion)theEObject;
                this.caseDataUnion(kernelObject);
                break;
            }
            case 35: {
                DataUnionDescription kernelObject = (DataUnionDescription)theEObject;
                this.caseDataUnionDescription(kernelObject);
                break;
            }
            default: {
                System.out.println("Kernel case not defined: " + theEObject.getClass().toString());
            }
        }
    }

    protected void doSwitchPB(int classifierID, EObject theEObject) {
        switch (classifierID) {
            case 59: {
                PacDataCall pacbaseObject = (PacDataCall)theEObject;
                this.casePacDataCall(pacbaseObject);
                break;
            }
            case 56: {
                PacDataElement pacbaseObject = (PacDataElement)theEObject;
                this.casePacDataElement(pacbaseObject);
                break;
            }
            default: {
                System.out.println("Pacbase case not defined: " + theEObject.getClass().toString());
            }
        }
    }

    public void caseDataCall(DataCall kDataCall) {
        this.currentDataCall = kDataCall;
        if (kDataCall.getDataDefinition() != null) {
            if (kDataCall.getDataDefinition() instanceof DataElement) {
                this.doSwitch((EObject)kDataCall.getDataDefinition());
            }
            if (kDataCall.getDataDefinition() instanceof DataAggregate) {
                this.doSwitch((EObject)kDataCall.getDataDefinition());
            }
            if (kDataCall.getDataDefinition() instanceof DataUnion) {
                this.doSwitch((EObject)kDataCall.getDataDefinition());
            }
        } else if (kDataCall.getDataDescription() != null) {
            if (kDataCall.getDataDescription() instanceof DataElementDescription) {
                this.doSwitch((EObject)kDataCall.getDataDescription());
            } else {
                this.doSwitch((EObject)kDataCall.getDataDescription());
            }
        }
    }

    public void caseDataAggregate(DataAggregate kDataAggregate) {
        boolean writeLine = false;
        boolean firstTimeForDABefore = this.firstTimeForDataAggregate;
        if (this.getSegSel().length() < 1) {
            writeLine = true;
        } else if (this.firstTimeForDataAggregate) {
            int i = 0;
            while (i < this.listOfSelectedSeg.size()) {
                String codSeg = this.listOfSelectedSeg.get(i);
                if (codSeg.equals(kDataAggregate.getName().substring(2))) {
                    writeLine = true;
                    break;
                }
                ++i;
            }
        } else {
            writeLine = true;
        }
        if (!writeLine) {
            this.getPacLinksEntitiesService().deleteReference((RadicalEntity)kDataAggregate);
            return;
        }
        this.segmentCodeToUse = this.segmentCodeToUse == null ? this.segmentCodefromCSLine : (this.currentSegmentCode == null ? String.valueOf(this.segmentCodeToUse.substring(0, 2)) + kDataAggregate.getName().substring(2) : this.currentSegmentCode);
        if (!this.firstTimeForDataAggregate) {
            if (this.lalList.size() == this.numberOfCorub) {
                return;
            }
            A833 el13DataAggregateC = this.InstanciateA833();
            if (this.currentDataCall != null) {
                EList extensions = this.currentDataCall.getExtensions();
                this.updateDataCall((List)extensions, el13DataAggregateC, kDataAggregate.getName());
            }
            this.initFromLalDescription(el13DataAggregateC);
            el13DataAggregateC.get_GRPR13_Groupe_Value().get_GRI13_Groupe_Value().get_GRNULI8_Groupe_Value().set_NULIG_Value(this.getNumberCorubDigit());
            el13DataAggregateC.get_GRPR13_Groupe_Value().get_GR3LORUS_Groupe_Value().set_LORUBS_Value(0);
            el13DataAggregateC.get_GRPR13_Groupe_Value().set_LORUBI_Value(0);
            el13DataAggregateC.get_GRPR13_Groupe_Value().set_LORUBE_Value(0);
            el13DataAggregateC.get_GRPR13_Groupe_Value().get_GRNRURE_Groupe_Value().set_NRUR9_Value("**");
            el13DataAggregateC.get_GRPR13_Groupe_Value().set_TYAPP_Value("A");
            this.segmentCompositionLines.add(el13DataAggregateC);
        } else {
            LengthAndPositionVisitor lpvisitor = new LengthAndPositionVisitor(PTNature.getPaths((String)this.generationEntryPoint.getProject()), new GenerationContext(this.getVariant()));
            lpvisitor.doSwitch((EObject)kDataAggregate);
            this.lalList = lpvisitor.defineMatchingArray(lpvisitor.getTopParentLal());
            this.numberOfCorub = 0;
            this.firstTimeForDataAggregate = false;
            this.writeLengthRecord = true;
            EY12 ey12ForDataAggregate = new EY12();
            this.currentSegmentCode = this.segmentCodeToUse;
            if (kDataAggregate != null && kDataAggregate.getLabel() != null) {
                ey12ForDataAggregate.set_LIBSEG_Value(kDataAggregate.getLabel());
            }
            Iterator extensions = kDataAggregate.getExtensions().iterator();
            while (extensions.hasNext()) {
                try {
                    PacDataAggregate pacDag = (PacDataAggregate)extensions.next();
                    ey12ForDataAggregate.set_NBENR_Value(pacDag.getTableSize());
                    ey12ForDataAggregate.set_VALST_Value(pacDag.getStructureCodeValue());
                    ey12ForDataAggregate.set_COMOU_Value(pacDag.getActionCode());
                    ey12ForDataAggregate.set_NBRUB1_Value(0);
                    ey12ForDataAggregate.set_LOENR_Value(lpvisitor.getTopParentLal().getTotalInternalLength());
                    ey12ForDataAggregate.set_LOENR1_Value(lpvisitor.getTopParentLal().getTotalInputLength());
                    ey12ForDataAggregate.set_LOENR2_Value(lpvisitor.getTopParentLal().getTotalOutputLength());
                    ey12ForDataAggregate.set_LOENR3_Value(0);
                    if (pacDag.getTableAttributes() == null) continue;
                    ey12ForDataAggregate.set_VALST_Value(pacDag.getTableAttributes().getTableNumber());
                }
                catch (Exception exception) {}
            }
            this.segmentCompositionLines.add(ey12ForDataAggregate);
        }
        this.doSwitch((EObject)kDataAggregate.getDataDescription());
        this.firstTimeForDataAggregate = firstTimeForDABefore;
    }

    public void caseDataAggregateDescription(DataAggregateDescription kDataAggregateDescription) {
        if (this.firstTime) {
            this.firstTime = false;
            for (EObject da : kDataAggregateDescription.getComponents()) {
                this.doSwitch(da);
            }
            return;
        }
        if (kDataAggregateDescription.getName() != null && kDataAggregateDescription.getName().length() > 0) {
            A833 detailForDataElt = this.InstanciateA833();
            detailForDataElt = this.initFromLalDescription(detailForDataElt);
            detailForDataElt.get_GRPR13_Groupe_Value().get_GRI13_Groupe_Value().get_GRNULI8_Groupe_Value().set_NULIG_Value(this.getNumberCorubDigit());
            detailForDataElt.get_GRPR13_Groupe_Value().set_TYAPP_Value("C");
            EList extCDC = this.currentDataCall.getExtensions();
            this.updateDataCall((List)extCDC, detailForDataElt, kDataAggregateDescription.getName());
            RadicalEntity re = PacbaseModelService.SearchRadicalEntityDuringGeneration((RadicalEntity)this.generationEntryPoint, (String)kDataAggregateDescription.getName(), (String)"dataelement", (PacbaseLinksEntitiesService)this.ples);
            Boolean isValidData = true;
            if (re == null && isValidData.booleanValue()) {
                detailForDataElt.get_GRPR13_Groupe_Value().set_PICTUI_Value("");
                detailForDataElt.set_PICTUE_Value("");
                detailForDataElt.get_GRPR13_Groupe_Value().set_USAGEI_Value("");
                detailForDataElt.get_GRPR13_Groupe_Value().get_GR3LORUS_Groupe_Value().set_LORUBS_Value(0);
                detailForDataElt.get_GRPR13_Groupe_Value().set_LORUBI_Value(0);
                detailForDataElt.get_GRPR13_Groupe_Value().set_LORUBE_Value(0);
            }
            this.segmentCompositionLines.add(detailForDataElt);
        }
        for (EObject da : kDataAggregateDescription.getComponents()) {
            this.doSwitch(da);
        }
    }

    public void caseDataElement(DataElement kDataElement) {
        A833 linesForDataElt = this.InstanciateA833();
        linesForDataElt = this.prepLineDataElt(linesForDataElt, kDataElement);
        linesForDataElt.get_GRPR13_Groupe_Value().get_GRI13_Groupe_Value().get_GRNULI8_Groupe_Value().set_NULIG_Value(this.getNumberCorubDigit());
        this.segmentCompositionLines.add(linesForDataElt);
    }

    public void caseDataElementDescription(DataElementDescription kDataElementDescription) {
        A833 linesForDataElt = this.InstanciateA833();
        linesForDataElt = this.prepLineDataEltNODefined(linesForDataElt, kDataElementDescription);
        linesForDataElt.get_GRPR13_Groupe_Value().get_GRI13_Groupe_Value().get_GRNULI8_Groupe_Value().set_NULIG_Value(this.getNumberCorubDigit());
        this.segmentCompositionLines.add(linesForDataElt);
    }

    public void caseDataUnion(DataUnion kDataUnion) {
        this.doSwitch((EObject)kDataUnion.getDataDescription());
    }

    public void caseDataUnionDescription(DataUnionDescription kDataUnionDescription) {
        Iterator dataComponents = kDataUnionDescription.getRedefines().iterator();
        this._currentDataUnionDescription = kDataUnionDescription;
        this.dataForRedefines = false;
        while (dataComponents.hasNext()) {
            DataComponent aDataComponent = (DataComponent)dataComponents.next();
            this.doSwitch((EObject)aDataComponent);
            this.dataForRedefines = true;
        }
        this._currentDataUnionDescription = null;
    }

    public void caseFiller(Filler kDataFiller) {
        A833 linesForDataElt = this.InstanciateA833();
        linesForDataElt = this.prepLineFillerDataElt(linesForDataElt, kDataFiller);
        linesForDataElt.get_GRPR13_Groupe_Value().get_GRI13_Groupe_Value().get_GRNULI8_Groupe_Value().set_NULIG_Value(this.getNumberCorubDigit());
        this.segmentCompositionLines.add(linesForDataElt);
        ++this.numberOfCorub;
    }

    public void casePacDataCall(PacDataCall pPacDataCall) {
        Iterator moreLines = pPacDataCall.getMoreLines().iterator();
        if (moreLines != null) {
            while (moreLines.hasNext()) {
                try {
                    this.doSwitch((EObject)moreLines.next());
                }
                catch (Exception exception) {}
            }
        }
    }

    public void casePacDataElement(PacDataElement pPacDataElement) {
    }

    private A833 InstanciateA833() {
        A833 aEL13 = new A833();
        ++this.numberOfCorub;
        this.getNumberCorubDigit();
        aEL13.get_GRPR13_Groupe_Value().get_GRI13_Groupe_Value().get_GRNOMSEG_Groupe_Value().get_GRFIENR_Groupe_Value().set_COFIC_Value(this.segmentCodeToUse.substring(0, 2));
        aEL13.get_GRPR13_Groupe_Value().get_GRI13_Groupe_Value().get_GRNOMSEG_Groupe_Value().get_GRFIENR_Groupe_Value().set_NUENR_Value(this.segmentCodeToUse.substring(2));
        return aEL13;
    }

    private A833 initFromLalDescription(A833 outputLine) {
        if (this.numberOfCorub != 0) {
            PacbaseLalDescription lal = this.lalList.get(this.numberOfCorub - 1);
            int nivru = lal.getLevel();
            lal.calculateNumbers();
            outputLine.set_NIVRU_Value(nivru);
            outputLine.get_GRPR13_Groupe_Value().get_GRI13_Groupe_Value().set_CORUB_Value(lal.getName());
            outputLine.get_GRPR13_Groupe_Value().set_REPET_Value(lal.getOccurs());
            outputLine.get_GRPR13_Groupe_Value().get_GRNRURE_Groupe_Value().set_NRUR9_Value(lal.getNbElementaryFields());
            String[] labels = SegmentCompositionPacbaseAndKernelVisitor.getLabelsFromDataLabel(lal.getLabel());
            outputLine.get_GRPR13_Groupe_Value().set_GRLIRUB_Value(labels[0]);
            outputLine.get_GRPR13_Groupe_Value().set_LIRUBC_Value(labels[1]);
            outputLine.get_GRPR13_Groupe_Value().set_PICTUI_Value(lal.getInternalFormat());
            outputLine.set_PICTUE_Value(lal.getInputFormat());
            outputLine.get_GRPR13_Groupe_Value().get_GR3LORUS_Groupe_Value().set_LORUBS_Value(lal.getOutputLength());
            outputLine.get_GRPR13_Groupe_Value().set_USAGEI_Value(lal.getUsage());
            outputLine.get_GRPR13_Groupe_Value().set_LORUBI_Value(lal.getInternalLength());
            outputLine.get_GRPR13_Groupe_Value().set_LORUBE_Value(lal.getInputLength());
            outputLine.set_TYRUB_Value(lal.getTyrub());
            if (lal.getRedefines() && this._currentDataUnionDescription != null) {
                DataCall dc = (DataCall)this._currentDataUnionDescription.getRedefines().get(0);
                String name = "";
                if (dc.getDataDefinition() != null) {
                    name = dc.getDataDefinition().getName();
                } else if (dc.getDataDescription() != null) {
                    name = dc.getDataDescription().getName();
                }
                outputLine.get_GRPR13_Groupe_Value().get_GRCOFIM3_Groupe_Value().set_CORUM_Value(name);
            }
        }
        return outputLine;
    }

    private String getLibName() {
        return this.libName;
    }

    private DataElement getMotherData() {
        return this.dataElt;
    }

    private static String[] getLabelsFromDataLabel(String label) {
        String[] labels = new String[]{"", ""};
        if (label.trim() != null && label.trim().length() > 0) {
            int end = label.length() < 19 ? label.length() : 18;
            labels[0] = label.substring(0, end);
            if (label.length() > 18) {
                labels[1] = label.substring(18, label.length());
            }
        }
        return labels;
    }

    private String getNumberCorubDigit() {
        String nbCorubValue = String.valueOf(this.numberOfCorub);
        String str = "000" + nbCorubValue;
        return str.substring(str.length() - 3);
    }

    private PacbaseLinksEntitiesService getPacLinksEntitiesService() {
        return this.ples;
    }

    public String getSubSchema() {
        return this.subSchema;
    }

    private char getVariant() {
        return this.variant;
    }

    public List<PacbaseSegment> getSegmentCompositionLines() {
        return this.segmentCompositionLines;
    }

    void setLibName(String libName) {
        this.libName = libName;
    }

    private void setMotherData(DataElement dataElt) {
        this.dataElt = dataElt;
    }

    public void setNuligToUse(int nuligToUse) {
        this.nuligToUse = nuligToUse;
    }

    public void setNumer(int numer) {
        this.numer = numer;
    }

    public void setSubSchema(String subSchema) {
        this.subSchema = subSchema;
    }

    void setSegmentCode(String segmentCode) {
        this.segmentCodeToUse = segmentCode;
    }

    public void setVariant(char variant) {
        this.variant = variant;
    }

    private A833 prepLineDataElt(A833 lineForDataElt, DataElement kDataElement) {
        A833 detailForDataElt = this.initFromLalDescription(lineForDataElt);
        detailForDataElt.get_GRPR13_Groupe_Value().set_TYAPP_Value("C");
        if (this.currentDataCall != null) {
            EList extensions = this.currentDataCall.getExtensions();
            this.updateDataCall((List)extensions, detailForDataElt, kDataElement.getName());
        }
        return detailForDataElt;
    }

    private A833 prepLineDataEltNODefined(A833 lineForDataElt, DataElementDescription DEDescription) {
        A833 detailForDataElt = this.initFromLalDescription(lineForDataElt);
        detailForDataElt.get_GRPR13_Groupe_Value().get_GRI13_Groupe_Value().set_CORUB_Value(DEDescription.getName());
        detailForDataElt.get_GRPR13_Groupe_Value().get_GRNRURE_Groupe_Value().set_NRUR9_Value("00");
        detailForDataElt.get_GRPR13_Groupe_Value().set_TYAPP_Value("C");
        if (this.currentDataCall != null) {
            EList extensions = this.currentDataCall.getExtensions();
            this.updateDataCall((List)extensions, detailForDataElt, DEDescription.getName());
        }
        return detailForDataElt;
    }

    private A833 prepLineFillerDataElt(A833 lineForDataElt, Filler kDataFiller) {
        A833 detailForDataElt = this.initFromLalDescription(lineForDataElt);
        detailForDataElt.get_GRPR13_Groupe_Value().get_GRI13_Groupe_Value().set_CORUB_Value("FILLER");
        detailForDataElt.get_GRPR13_Groupe_Value().get_GRNRURE_Groupe_Value().set_NRUR9_Value("00");
        detailForDataElt.get_GRPR13_Groupe_Value().set_TYAPP_Value("F");
        if (this.currentDataCall != null) {
            EList extensions = this.currentDataCall.getExtensions();
            this.updateDataCall((List)extensions, detailForDataElt, "FILLER");
        }
        return detailForDataElt;
    }

    private List getDLines(Iterator extensionsElt) {
        while (extensionsElt.hasNext()) {
            Object obj = extensionsElt.next();
            if (!(obj instanceof PacDataElementImpl)) continue;
            return ((PacDataElementImpl)obj).getDLines();
        }
        return null;
    }

    private String searchForColumnLabel(List dLines) {
        String label = "";
        if (dLines != null) {
            int i = 0;
            while (i < dLines.size()) {
                if (((PacDLineImpl)dLines.get(i)).getLineType().equals("C")) {
                    label = ((PacDLineImpl)dLines.get(i)).getDescription();
                }
                ++i;
            }
        }
        return label;
    }

    private void updateDataCall(List extensions, A833 detailForDataElt, String kDataElementName) {
        block15: {
            PacDataCall pacDataCall = null;
            int i = 0;
            while (i < extensions.size()) {
                Object object = extensions.get(i);
                if (object instanceof PacDataCall) {
                    pacDataCall = (PacDataCall)object;
                    break;
                }
                ++i;
            }
            if (pacDataCall == null) break block15;
            if (pacDataCall.getSortKey() != null) {
                detailForDataElt.get_GRPR13_Groupe_Value().set_INDIC_Value(pacDataCall.getSortKey());
            }
            if (pacDataCall.getClassControl() != null && pacDataCall.getClassControl().getValue() > 0) {
                detailForDataElt.get_GRPR13_Groupe_Value().get_GRCONT_Groupe_Value().get_GRCONTR_Groupe_Value().get_GRCONTC_Groupe_Value().set_CLASC_Value(pacDataCall.getClassControl().getLiteral().substring(1));
            }
            if (pacDataCall.getPresenceCheck() != null) {
                String ctlCreat = pacDataCall.getPresenceCheck().getInCreation().toString().substring(1);
                String ctlModi = pacDataCall.getPresenceCheck().getInModification().toString().substring(1);
                String ctlDele = pacDataCall.getPresenceCheck().getInDeletion().toString().substring(1);
                String ctlTyp4 = pacDataCall.getPresenceCheck().getInType4().toString().substring(1);
                String ctlTyp5 = pacDataCall.getPresenceCheck().getInType5().toString().substring(1);
                String ctlTyp6 = pacDataCall.getPresenceCheck().getInType6().toString().substring(1);
                if (String.valueOf(ctlCreat).equals("F")) {
                    ctlCreat = " ";
                }
                if (String.valueOf(ctlModi).equals("F")) {
                    ctlModi = " ";
                }
                if (String.valueOf(ctlDele).equals("F")) {
                    ctlDele = " ";
                }
                if (String.valueOf(ctlTyp4).equals("F")) {
                    ctlTyp4 = " ";
                }
                if (String.valueOf(ctlTyp5).equals("F")) {
                    ctlTyp5 = " ";
                }
                if (String.valueOf(ctlTyp6).equals("F")) {
                    ctlTyp6 = " ";
                }
                detailForDataElt.get_GRPR13_Groupe_Value().get_GRCONT_Groupe_Value().get_GRSTRCO_Groupe_Value().set_STRCO1_Value(ctlCreat);
                detailForDataElt.get_GRPR13_Groupe_Value().get_GRCONT_Groupe_Value().get_GRSTRCO_Groupe_Value().set_STRCO2_Value(ctlModi);
                detailForDataElt.get_GRPR13_Groupe_Value().get_GRCONT_Groupe_Value().get_GRSTRCO_Groupe_Value().set_STRCO3_Value(ctlDele);
                detailForDataElt.get_GRPR13_Groupe_Value().get_GRCONT_Groupe_Value().get_GRSTRCO_Groupe_Value().set_STRCO4_Value(ctlTyp4);
                detailForDataElt.get_GRPR13_Groupe_Value().get_GRCONT_Groupe_Value().get_GRSTRCO_Groupe_Value().set_STRCO5_Value(ctlTyp5);
                detailForDataElt.get_GRPR13_Groupe_Value().get_GRCONT_Groupe_Value().get_GRSTRCO_Groupe_Value().set_STRCO6_Value(ctlTyp6);
            }
            PacDataCallMore pacDataCallMor2 = null;
            EList extensMoreLine = pacDataCall.getMoreLines();
            int nb = 0;
            if (extensMoreLine == null) break block15;
            if (extensMoreLine.isEmpty() && this._currentDataUnionDescription != null && this.dataForRedefines) {
                String uptTarget = this.redefines;
                this.dataForRedefines = false;
                detailForDataElt.get_GRPR13_Groupe_Value().get_GRCOFIM3_Groupe_Value().set_COFIM_Value(uptTarget.substring(0, 2));
            }
            for (PacDataCallMore pacDataCallMor2 : extensMoreLine) {
                block17: {
                    block16: {
                        block18: {
                            if (++nb != 1) break block16;
                            detailForDataElt.get_GRPR13_Groupe_Value().get_GRCONT_Groupe_Value().get_GRCONTR_Groupe_Value().set_SCONT_Value(pacDataCallMor2.getControlType().toString());
                            detailForDataElt.get_GRPR13_Groupe_Value().get_GRCONT_Groupe_Value().set_VCONT_Value(pacDataCallMor2.getControlValue().toString());
                            if (pacDataCallMor2.getUpdateTarget().trim().length() <= 0) break block17;
                            String uptTarget = pacDataCallMor2.getUpdateTarget().trim();
                            if (this._currentDataUnionDescription != null && !this.dataForRedefines && uptTarget.trim().length() == 0) {
                                uptTarget = this.redefines;
                            }
                            this.dataForRedefines = false;
                            detailForDataElt.get_GRPR13_Groupe_Value().get_GRCOFIM3_Groupe_Value().set_COFIM_Value(uptTarget.substring(0, 2));
                            if (pacDataCallMor2.getUpdateTarget().trim().length() <= 3) break block17;
                            detailForDataElt.get_GRPR13_Groupe_Value().get_GRCOFIM3_Groupe_Value().set_NUENM_Value(uptTarget.substring(2, 4));
                            if (pacDataCallMor2.getUpdateTarget().trim().length() <= 4) break block18;
                            detailForDataElt.get_GRPR13_Groupe_Value().get_GRCOFIM3_Groupe_Value().set_CORUM_Value(uptTarget.substring(4, uptTarget.length()));
                            break block17;
                        }
                        if (kDataElementName == null) break block17;
                        detailForDataElt.get_GRPR13_Groupe_Value().get_GRCOFIM3_Groupe_Value().set_CORUM_Value(kDataElementName);
                        break block17;
                    }
                    if (nb == 2) {
                        detailForDataElt.set_LCONT2_Value(pacDataCallMor2.getOperator());
                        detailForDataElt.set_NEGAT2_Value(pacDataCallMor2.getNegation());
                        detailForDataElt.set_SCONT2_Value(pacDataCallMor2.getControlType());
                        detailForDataElt.set_VCONT2_Value(pacDataCallMor2.getControlValue());
                        break;
                    }
                }
                if (nb > 2) break;
            }
        }
    }

    public void setSegSel(String segSel) {
        this.SEGSEL = segSel != null ? segSel.trim() : "";
    }

    String getSegSel() {
        if (this.SEGSEL == null) {
            this.SEGSEL = "";
        }
        return this.SEGSEL;
    }
}

