/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.tablesegment.dataaggregate;

import com.ibm.icu.util.GregorianCalendar;
import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.kernel.DataAggregateDescription;
import com.ibm.pdp.mdl.kernel.DataCall;
import com.ibm.pdp.mdl.kernel.DataElement;
import com.ibm.pdp.mdl.kernel.DataElementDescription;
import com.ibm.pdp.mdl.kernel.DataUnit;
import com.ibm.pdp.mdl.kernel.KernelPackage;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacDLine;
import com.ibm.pdp.mdl.pacbase.PacDataAggregate;
import com.ibm.pdp.mdl.pacbase.PacDataCall;
import com.ibm.pdp.mdl.pacbase.PacDataCallMore;
import com.ibm.pdp.mdl.pacbase.PacDataElement;
import com.ibm.pdp.mdl.pacbase.PacDataElementDescription;
import com.ibm.pdp.mdl.pacbase.PacDataUnit;
import com.ibm.pdp.mdl.pacbase.PacGLine;
import com.ibm.pdp.mdl.pacbase.PacGeneratedSkeletonLanguageValues;
import com.ibm.pdp.mdl.pacbase.PacLibrary;
import com.ibm.pdp.mdl.pacbase.PacSubSchemaSubSystemDefinition;
import com.ibm.pdp.mdl.pacbase.PacTableLineTypeValues;
import com.ibm.pdp.mdl.pacbase.PacText;
import com.ibm.pdp.mdl.pacbase.PacTextLineTypeValues;
import com.ibm.pdp.mdl.pacbase.PacTextSection;
import com.ibm.pdp.mdl.pacbase.PacbasePackage;
import com.ibm.pdp.mdl.pacbase.converter.PacTextConverter;
import com.ibm.pdp.mdl.pacbase.impl.PacGLineImpl;
import com.ibm.pdp.pacbase.generate.util.PacbaseLinksEntitiesService;
import com.ibm.pdp.pacbase.generate.util.PacbaseModelService;
import com.ibm.pdp.pacbase.tablesegment.dataaggregate.SegmentCompositionPacbaseAndKernelVisitor;
import com.ibm.pdp.pacbase.tablesegment.model.A801;
import com.ibm.pdp.pacbase.tablesegment.model.A812;
import com.ibm.pdp.pacbase.tablesegment.model.A820;
import com.ibm.pdp.pacbase.tablesegment.model.A82G;
import com.ibm.pdp.pacbase.tablesegment.model.A833;
import com.ibm.pdp.pacbase.tablesegment.model.DT80;
import com.ibm.pdp.pacbase.tablesegment.model.EY12;
import com.ibm.pdp.pacbase.tablesegment.model.NR00;
import com.ibm.pdp.pacbase.tablesegment.model.PacbaseSegment;
import com.ibm.pdp.trace.PTTraceManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class DT00PacbaseAndKernelVisitor {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015, 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private PacbaseLinksEntitiesService ples;
    private RadicalEntity generationEntryPoint;
    protected static final PacbasePackage modelPackagePB = PacbasePackage.eINSTANCE;
    protected static final KernelPackage modelPackageKernel = KernelPackage.eINSTANCE;
    private ArrayList<String> extractLines = new ArrayList();
    private String currentGenerateLibrary;
    public static final String SIGN = "S";
    public static final String CLASNUM = "9";
    public static final String CLASNOTNUM = "X";
    public static final String INTERNAL_FORMAT = "I";
    public static final String INPUT_FORMAT = "E";
    public static final String OUTPUT_FORMAT = "S";
    public static final char VARIANT = 'X';
    public static final char DISPLAY_USAGE = 'D';
    protected String nameOfProject;
    private String nameDataAggregate;
    private int numberOfCorub = 0;
    private String tableNumber;
    private String tableNumber06;
    private int nuligDescDE = 0;
    private int nuligCommentDA = 0;
    private String nameDataElement;
    private int nuligSs = 0;
    int WPR22NBLTC = 0;
    int WPR22LONTC = 0;
    int[] WPR22ADRC = new int[3];

    public DT00PacbaseAndKernelVisitor(PacbaseLinksEntitiesService ples, DataAggregate da) {
        this.ples = ples;
        this.generationEntryPoint = da;
    }

    public void doSwitch(EObject theEObject) {
        this.doSwitch(theEObject.eClass(), theEObject);
    }

    protected void doSwitch(EClass theEClass, EObject theEObject) {
        if (theEObject instanceof RadicalEntity) {
            this.getPacLinksEntitiesService().registerReference((RadicalEntity)theEObject);
        }
        if (theEClass.eContainer() == modelPackagePB) {
            this.doSwitchPB(theEClass.getClassifierID(), theEObject);
        } else if (theEClass.eContainer() == modelPackageKernel) {
            this.doSwitchKernel(theEClass.getClassifierID(), theEObject);
        }
    }

    protected void doSwitchPB(int classifierID, EObject theEObject) {
        switch (classifierID) {
            case 31: {
                PacLibrary pacbaseObject = (PacLibrary)theEObject;
                this.casePacLibrary(pacbaseObject);
                break;
            }
            case 59: {
                PacDataCall pacbaseObject = (PacDataCall)theEObject;
                this.casePacDataCall(pacbaseObject);
                break;
            }
            case 12: {
                PacGLineImpl pacbaseObject = (PacGLineImpl)theEObject;
                this.casePacGLineImpl(pacbaseObject);
                break;
            }
            case 61: {
                PacDataCallMore pacbaseObject = (PacDataCallMore)theEObject;
                this.casePacDataCallMore(pacbaseObject);
                break;
            }
            case 3: {
                PacDataCallMore pacbaseObject = (PacDataCallMore)theEObject;
                this.casePacDataCallMore(pacbaseObject);
                break;
            }
            default: {
                PTTraceManager traceManager = PTTraceManager.getInstance();
                int engineTraceLevel = traceManager.getTraceLevel("com.ibm.pdp.pac");
                if (engineTraceLevel <= 0) break;
                String message = "Pacbase case not defined: " + theEObject.getClass().toString() + " " + new Date();
                traceManager.trace(DT00PacbaseAndKernelVisitor.class, "com.ibm.pdp.pac", 1, message);
            }
        }
    }

    protected void doSwitchKernel(int classifierID, EObject theEObject) {
        switch (classifierID) {
            case 37: {
                DataCall kernelObject = (DataCall)theEObject;
                this.caseDataCall(kernelObject);
                break;
            }
            case 45: {
                DataAggregate kernelObject = (DataAggregate)theEObject;
                this.caseDataAggregate(kernelObject);
                break;
            }
            case 18: {
                DataAggregateDescription kernelObject = (DataAggregateDescription)theEObject;
                this.caseDataAggregateDescription(kernelObject);
                break;
            }
            case 44: {
                DataElement kernelObject = (DataElement)theEObject;
                this.caseDataElement(kernelObject);
                break;
            }
            case 33: {
                DataElementDescription kernelObject = (DataElementDescription)theEObject;
                this.caseDataElementDescription(kernelObject);
                break;
            }
            case 43: {
                break;
            }
            default: {
                PTTraceManager traceManager = PTTraceManager.getInstance();
                int engineTraceLevel = traceManager.getTraceLevel("com.ibm.pdp.pac");
                if (engineTraceLevel <= 0) break;
                String message = "Kernel case not defined: " + theEObject.getClass().toString() + " " + new Date();
                traceManager.trace(DT00PacbaseAndKernelVisitor.class, "com.ibm.pdp.pac", 1, message);
            }
        }
    }

    private PacbaseLinksEntitiesService getPacLinksEntitiesService() {
        return this.ples;
    }

    private void casePacLibrary(PacLibrary aPacLibrary) {
        if (this.currentGenerateLibrary == null) {
            this.currentGenerateLibrary = aPacLibrary.getName();
        }
        this.formatLibraryLine(aPacLibrary);
    }

    public void caseDataCall(DataCall kDataCall) {
        if (kDataCall.getDataDefinition() != null) {
            if (kDataCall.getDataDefinition() instanceof DataElement) {
                this.doSwitch((EObject)kDataCall.getDataDefinition());
            } else {
                this.doSwitch((EObject)kDataCall.getDataDefinition());
            }
        } else if (kDataCall.getDataDescription() != null) {
            this.doSwitch((EObject)kDataCall.getDataDescription());
        }
    }

    public void caseDataAggregate(DataAggregate kDataAggregate) {
        this.nameDataAggregate = kDataAggregate.getName();
        SegmentCompositionPacbaseAndKernelVisitor v = new SegmentCompositionPacbaseAndKernelVisitor(this.getPacLinksEntitiesService(), (RadicalEntity)kDataAggregate);
        v.setVariant(this.searchVariant(kDataAggregate));
        v.setSegmentCode(kDataAggregate.getName());
        PacDataAggregate pacdag = null;
        if (kDataAggregate != null) {
            Iterator geLines;
            Iterator extensionsDA = kDataAggregate.getExtensions().iterator();
            while (extensionsDA.hasNext()) {
                try {
                    pacdag = (PacDataAggregate)extensionsDA.next();
                }
                catch (Exception exception) {}
            }
            this.tableNumber = pacdag.getTableAttributes().getTableNumber();
            this.tableNumber06 = String.valueOf(this.tableNumber) + "      ";
            this.tableNumber06 = this.tableNumber06.substring(0, 6);
            String nameOfDataUnit = kDataAggregate.getName().substring(0, 2);
            RadicalEntity objRA = PacbaseModelService.SearchRadicalEntityDuringGeneration((RadicalEntity)this.generationEntryPoint, (String)nameOfDataUnit, (String)"dataunit", (PacbaseLinksEntitiesService)this.ples);
            DataUnit du = null;
            PacLibrary lib = null;
            PacDataUnit pdu2 = null;
            if (objRA != null && objRA instanceof DataUnit) {
                du = (DataUnit)objRA;
                for (PacDataUnit pdu2 : du.getExtensions()) {
                    lib = pdu2.getGenerationParameter();
                }
                String variantForBibPda = lib.getCobolType().getLiteral().substring(1);
                v.doSwitch((EObject)kDataAggregate);
                for (PacbaseSegment ps : v.getSegmentCompositionLines()) {
                    if (ps instanceof EY12) {
                        this.formatDefinitionDataUnit(kDataAggregate);
                        this.formatDefinitionDataAggregate(kDataAggregate, pacdag);
                        continue;
                    }
                    if (!(ps instanceof A833)) continue;
                    A833 ey13Obj = (A833)ps;
                    ey13Obj.set_VARIA_Value(variantForBibPda);
                    this.formatEY13(ps);
                    this.nameDataElement = ey13Obj.get_GRPR13_Groupe_Value().get_GRI13_Groupe_Value().get_CORUB_Value();
                    String newCorub = ((A833)ps).get_GRPR13_Groupe_Value().get_GRI13_Groupe_Value().get_CORUB_Value();
                    RadicalEntity objNewDE = null;
                    objNewDE = PacbaseModelService.SearchRadicalEntityDuringGeneration((RadicalEntity)this.generationEntryPoint, (String)newCorub, (String)"dataelement", (PacbaseLinksEntitiesService)this.ples);
                    if (!(objNewDE instanceof DataElement)) continue;
                    DataElement kDataElement = (DataElement)objNewDE;
                    this.initLabelForDataElt(kDataElement);
                }
            }
            if (!pacdag.getGELines().isEmpty() && (geLines = pacdag.getGELines().iterator()) != null) {
                while (geLines.hasNext()) {
                    PacGLine geLine = (PacGLine)geLines.next();
                    if (String.valueOf(geLine.getLineType()).equals("C")) {
                        this.formatCommentDataAgg(geLine);
                    }
                    if (!String.valueOf(geLine.getLineType()).equals("T")) continue;
                    this.treatmentTextDataAgg(geLine);
                }
            }
            if (!pacdag.getSsLines().isEmpty()) {
                Iterator SsLines = pacdag.getSsLines().iterator();
                this.nuligSs = 0;
                if (SsLines != null) {
                    while (SsLines.hasNext()) {
                        PacSubSchemaSubSystemDefinition ssLine = (PacSubSchemaSubSystemDefinition)SsLines.next();
                        if (!ssLine.getTableLineType().equals(PacTableLineTypeValues._S_LITERAL) && !ssLine.getTableLineType().equals(PacTableLineTypeValues._Y_LITERAL)) continue;
                        this.formatSsLines(ssLine);
                    }
                }
            }
        }
    }

    public void caseDataAggregateDescription(DataAggregateDescription kDataAggregateDescription) {
    }

    public void caseDataElementDescription(DataElementDescription kDataElementDescription) {
    }

    public void casePacDataCall(PacDataCall pPacDataCall) {
    }

    public void casePacDataCallMore(PacDataCallMore pPacDataCallMore) {
    }

    public void casePacGLineImpl(PacGLineImpl pPacGLineMore) {
    }

    public void caseDataElement(DataElement kDataElement) {
    }

    public void formatLibraryLine(PacLibrary aPacLibrary) {
        NR00 prefixLine = new NR00();
        prefixLine.set_GRNULI8_Value("000");
        prefixLine.set_COSNM_Value(CLASNOTNUM);
        prefixLine.get_GRDT00_Groupe_Value().get_GRCLEDT_Groupe_Value().get_GRCLEDTP_Groupe_Value().get_GRRANR_Groupe_Value().set_RANRU_Value("00");
        A801 libraryLine = new A801();
        A801.GRKY01.GRPR01.GRNOBIB7 ky01NOBIB7 = libraryLine.get_GRKY01_Groupe_Value().get_GRPR01_Groupe_Value().get_GRNOBIB7_Groupe_Value();
        ky01NOBIB7.set_APPLI_Value(aPacLibrary.getName());
        ky01NOBIB7.set_LIBIB_Value(aPacLibrary.getLabel());
        ky01NOBIB7.set_INVDA_Value(" ");
        ky01NOBIB7.set_CARVE_Value(aPacLibrary.getCobolType().getName().substring(1));
        ky01NOBIB7.set_OPTET_Value("*");
        ky01NOBIB7.set_OPTET_Value(" ");
        ky01NOBIB7.set_NLPAG_Value("60");
        ky01NOBIB7.set_SUPSA_Value("O");
        ky01NOBIB7.set_SUPCO_Value("O");
        ky01NOBIB7.set_R7_Value("N");
        ky01NOBIB7.set_OPAVP_Value(" ");
        ky01NOBIB7.set_OPAPR_Value(" ");
        ky01NOBIB7.set_LANGA_Value(String.valueOf(aPacLibrary.getGeneratedLanguage()).substring(1));
        ky01NOBIB7.set_VARIA_Value(String.valueOf(aPacLibrary.getCobolType().getName().substring(1)));
        ky01NOBIB7.set_TYPRO_Value("P");
        ky01NOBIB7.set_APPLIC_Value(aPacLibrary.getName());
        ky01NOBIB7.set_R8_Value("N");
        ky01NOBIB7.set_NIVEAU_Value("3");
        ky01NOBIB7.set_ETABI_Value("1");
        ky01NOBIB7.set_BIPOR_Value("A0A1");
        ky01NOBIB7.set_CVEXT_Value("1");
        ky01NOBIB7.set_QUOTE_Value(String.valueOf(aPacLibrary.getAlphanumericDelimiter()));
        ky01NOBIB7.set_FORDA_Value(String.valueOf(aPacLibrary.getGeneratedDateFormat()).substring(1));
        ky01NOBIB7.set_DECPO_Value(String.valueOf(aPacLibrary.getDecimalPointDelimiter()));
        ky01NOBIB7.set_VARIB_Value(String.valueOf(aPacLibrary.getMapType()).substring(1));
        ky01NOBIB7.set_COFOR_Value(" ");
        ky01NOBIB7.set_SECUR_Value(" ");
        ky01NOBIB7.set_CARHO_Value(" ");
        ky01NOBIB7.set_FILLER0_Value(" ");
        ky01NOBIB7.set_DACTYR_Value("N");
        ky01NOBIB7.set_DACTYV_Value(String.valueOf(aPacLibrary.getCenturyReferenceYear()));
        String day = "00" + String.valueOf(GregorianCalendar.getInstance().get(5));
        String month = "00" + String.valueOf(GregorianCalendar.getInstance().get(2) + 1);
        String year = "0000" + String.valueOf(GregorianCalendar.getInstance().get(1));
        String todayDate = String.valueOf(day.substring(day.length() - 2)) + "/" + month.substring(month.length() - 2) + "/" + year.substring(year.length() - 4);
        A801.GRKY01.GRSESSI ky01SESSI = libraryLine.get_GRKY01_Groupe_Value().get_GRSESSI_Groupe_Value();
        ky01SESSI.set_NUSES_Value("9999");
        ky01SESSI.set_NSVER_Value("000");
        ky01SESSI.set_ETSES_Value(" ");
        PacGeneratedSkeletonLanguageValues generationLang = aPacLibrary.getSkeletonLanguage();
        libraryLine.get_GRKY01_Groupe_Value().set_XLANG_Value(generationLang == PacGeneratedSkeletonLanguageValues._EN_LITERAL ? INPUT_FORMAT : "F");
        libraryLine.get_GRKY01_Groupe_Value().set_CODUTI_Value("ADMIN   ");
        libraryLine.get_GRKY01_Groupe_Value().set_DATEC_Value(todayDate);
        libraryLine.get_GRKY01_Groupe_Value().set_PASUTI_Value("ADMIN   ");
        libraryLine.get_GRKY01_Groupe_Value().set_CTRAN_Value("BVAP");
        if (System.getProperty("pactableGeneration.W1.junit.process") != null) {
            libraryLine.get_GRKY01_Groupe_Value().set_DATEC_Value("JUNIT ");
            libraryLine.get_GRKY01_Groupe_Value().set_XLANG_Value(INPUT_FORMAT);
        }
        this.extractLines.add(prefixLine.getCompleteContentForSegment().substring(0, 26).concat(libraryLine.getCompleteContentForSegment()));
    }

    protected void formatEY13(PacbaseSegment ps) {
        NR00 prefixLine = new NR00();
        prefixLine.set_GRNULI8_Value("000");
        prefixLine.set_COSNM_Value("3");
        prefixLine.get_GRDT00_Groupe_Value().get_GRCLEDT_Groupe_Value().get_GRCLEDTP_Groupe_Value().get_GRRANR_Groupe_Value().set_RANRU_Value("00");
        String nbCorubValue = String.valueOf(++this.numberOfCorub);
        String str = "000" + nbCorubValue;
        String nbCorubDigit = str.substring(str.length() - 3);
        prefixLine.get_GRDT00_Groupe_Value().get_GRCLEDT_Groupe_Value().get_GRNULDTX_Groupe_Value().set_NULDT_Value(nbCorubDigit);
        String A8332 = ((A833)ps).getCompleteContentForSegment();
        this.extractLines.add(prefixLine.getCompleteContentForSegment().substring(0, 26).concat(A8332));
    }

    public void formatDefinitionDataUnit(DataAggregate kDataAggregate) {
        NR00 prefixLine = new NR00();
        prefixLine.set_GRNULI8_Value("000");
        prefixLine.set_COSNM_Value("A");
        prefixLine.get_GRDT00_Groupe_Value().get_GRCLEDT_Groupe_Value().get_GRCLEDTP_Groupe_Value().get_GRRANR_Groupe_Value().set_RANRU_Value("00");
        A820 definitionForSD = new A820();
        definitionForSD.get_GRPR20_Groupe_Value().set_COFIC_Value(this.nameDataAggregate.substring(0, 2));
        RadicalEntity obj = PacbaseModelService.SearchRadicalEntityDuringGeneration((RadicalEntity)this.generationEntryPoint, (String)this.nameDataAggregate.substring(0, 2), (String)"dataUnit", (PacbaseLinksEntitiesService)this.ples);
        if (obj instanceof DataUnit) {
            DataUnit du = (DataUnit)obj;
            definitionForSD.get_GRPR20_Groupe_Value().set_LIFIC_Value(du.getLabel());
            Iterator extensionsDU = du.getExtensions().iterator();
            PacDataUnit pacdu = null;
            while (extensionsDU.hasNext()) {
                try {
                    pacdu = (PacDataUnit)extensionsDU.next();
                    definitionForSD.get_GRPR20_Groupe_Value().get_GRCARTEA_Groupe_Value().set_FICOM_Value(pacdu.getComments());
                    String natec = pacdu.getDataStructureType().getLiteral().substring(1);
                    definitionForSD.get_GRPR20_Groupe_Value().get_GRCARTEA_Groupe_Value().set_NATEC_Value(natec);
                }
                catch (Exception exception) {}
            }
        }
        this.extractLines.add(prefixLine.getCompleteContentForSegment().substring(0, 26).concat(definitionForSD.getCompleteContentForSegment()));
    }

    public void formatDefinitionDataAggregate(DataAggregate kDataAggregate, PacDataAggregate pacdag) {
        NR00 prefixLine = new NR00();
        prefixLine.set_GRNULI8_Value("000");
        prefixLine.set_COSNM_Value("2");
        prefixLine.get_GRDT00_Groupe_Value().get_GRCLEDT_Groupe_Value().get_GRCLEDTP_Groupe_Value().get_GRRANR_Groupe_Value().set_RANRU_Value("00");
        A812 definitionForDA = new A812();
        definitionForDA.get_GRPR12_Groupe_Value().set_GRNOMSEG_Value(kDataAggregate.getName());
        if (!pacdag.getTableAttributes().equals(null)) {
            String tableNumber = pacdag.getTableAttributes().getTableNumber();
            String tableNumber06 = String.valueOf(tableNumber) + "      ";
            tableNumber06 = tableNumber06.substring(0, 6);
            definitionForDA.get_GRPR12_Groupe_Value().get_GRLOLIB2_Groupe_Value().set_VALST_Value(tableNumber06);
        }
        definitionForDA.get_GRPR12_Groupe_Value().get_GRLOLIB2_Groupe_Value().set_COMOU_Value(pacdag.getActionCode());
        A812.GRPR12.GRLOLIB2.GRVALMO GRVALMO2 = definitionForDA.get_GRPR12_Groupe_Value().get_GRLOLIB2_Groupe_Value().get_GRVALMO_Groupe_Value();
        if (pacdag.getCreationCode().trim().length() > 0) {
            GRVALMO2.set_VALMO1_Value("'".concat(pacdag.getCreationCode()).concat("'"));
        }
        if (pacdag.getModificationCode().trim().length() > 0) {
            GRVALMO2.set_VALMO2_Value("'".concat(pacdag.getModificationCode()).concat("'"));
        }
        if (pacdag.getDeletionCode().trim().length() > 0) {
            GRVALMO2.set_VALMO3_Value("'".concat(pacdag.getDeletionCode()).concat("'"));
        }
        if (pacdag.getInType4Code().trim().length() > 0) {
            GRVALMO2.set_VALMO4_Value("'".concat(pacdag.getInType4Code()).concat("'"));
        }
        if (pacdag.getInType5Code().trim().length() > 0) {
            GRVALMO2.set_VALMO5_Value("'".concat(pacdag.getInType5Code()).concat("'"));
        }
        if (pacdag.getInType6Code().trim().length() > 0) {
            GRVALMO2.set_VALMO6_Value("'".concat(pacdag.getInType6Code()).concat("'"));
        }
        A812.GRPR12.GRLOLIB2.GRSTECO GRSTECO2 = definitionForDA.get_GRPR12_Groupe_Value().get_GRLOLIB2_Groupe_Value().get_GRSTECO_Groupe_Value();
        if (pacdag.getPresenceCheck() != null) {
            GRSTECO2.set_STECO1_Value(pacdag.getPresenceCheck().getInCreation().getName().substring(1));
            GRSTECO2.set_STECO2_Value(pacdag.getPresenceCheck().getInModification().getName().substring(1));
            GRSTECO2.set_STECO3_Value(pacdag.getPresenceCheck().getInDeletion().getName().substring(1));
            GRSTECO2.set_STECO4_Value(pacdag.getPresenceCheck().getInType4().getName().substring(1));
            GRSTECO2.set_STECO5_Value(pacdag.getPresenceCheck().getInType5().getName().substring(1));
            GRSTECO2.set_STECO6_Value(pacdag.getPresenceCheck().getInType6().getName().substring(1));
        }
        if (pacdag.getTableSize() > 0) {
            String tableSizeValue = String.valueOf(pacdag.getTableSize());
            String str = "0000" + tableSizeValue;
            String tableSizeDigit = str.substring(str.length() - 4);
            definitionForDA.get_GRPR12_Groupe_Value().get_GRLOLIB2_Groupe_Value().set_NBENR_Value(tableSizeDigit);
        } else {
            definitionForDA.get_GRPR12_Groupe_Value().get_GRLOLIB2_Groupe_Value().set_NBENR_Value("0000");
        }
        if (pacdag.getOccurencesNumber() > 0) {
            String occNumber = String.valueOf(pacdag.getOccurencesNumber());
            String str9 = "0000000000" + occNumber;
            String occurenceNumber = str9.substring(str9.length() - 9);
            definitionForDA.get_GRPR12_Groupe_Value().get_GRLOLIB2_Groupe_Value().set_NBOCC_Value(occurenceNumber);
        } else {
            definitionForDA.get_GRPR12_Groupe_Value().get_GRLOLIB2_Groupe_Value().set_NBOCC_Value("0000000000");
        }
        definitionForDA.get_GRPR12_Groupe_Value().get_GRLOLIB2_Groupe_Value().set_GRLIBSEG_Value(kDataAggregate.getLabel());
        this.extractLines.add(prefixLine.getCompleteContentForSegment().substring(0, 26).concat(definitionForDA.getCompleteContentForSegment()));
    }

    private void initLabelForDataElt(DataElement kDataElement) {
        DT80 labelForDataElement = new DT80();
        PacDataElement pdelt = null;
        PacDataElementDescription pacded = null;
        String lirub = "";
        String delim = null;
        boolean lirubCFound = false;
        boolean lirubLFound = false;
        this.nuligDescDE = 0;
        if (kDataElement instanceof DataElement) {
            Iterator extensionsElt = kDataElement.getExtensions().iterator();
            while (extensionsElt.hasNext()) {
                try {
                    pdelt = (PacDataElement)extensionsElt.next();
                }
                catch (Exception exception) {}
            }
            Iterator extensions = kDataElement.getDataDescription().getExtensions().iterator();
            while (extensions.hasNext()) {
                try {
                    pacded = (PacDataElementDescription)extensions.next();
                }
                catch (Exception exception) {}
            }
            Iterator DLines = pdelt.getDLines().iterator();
            String aliasDE = pdelt.getAlias();
            if (DLines != null) {
                while (DLines.hasNext()) {
                    PacDLine pPacDLine = (PacDLine)DLines.next();
                    if (pPacDLine.getLineType().equals("L") || pPacDLine.getLineType().equals("C")) {
                        labelForDataElement.set_ENTITE_Value(aliasDE);
                        lirub = pPacDLine.getDescription();
                        delim = pPacDLine.getAllowedValues().trim();
                        labelForDataElement.set_SYNGR_Value(lirub);
                        labelForDataElement.set_VALRU_Value(delim);
                        if (pPacDLine.getLineType().equals("L")) {
                            lirubLFound = true;
                        } else {
                            lirubCFound = true;
                        }
                        this.formatLine3L3C(labelForDataElement, pPacDLine.getLineType());
                    }
                    if (!pPacDLine.getLineType().equals(" ")) continue;
                    this.formatDescriptionDE(pPacDLine);
                }
            }
            if (!lirubCFound || !lirubLFound) {
                this.searchForMotherDataElement(pacded, kDataElement, aliasDE, lirubLFound, lirubCFound);
            }
        }
    }

    public void formatLine3L3C(DT80 labelForDataElement, String lineType) {
        NR00 prefixLine = new NR00();
        prefixLine.set_GRNULI8_Value("000");
        prefixLine.set_COSNM_Value("3");
        if (lineType.equals("L")) {
            prefixLine.get_GRDT00_Groupe_Value().get_GRCLEDT_Groupe_Value().get_GRCLEDTP_Groupe_Value().set_COSDT_Value("L");
        } else {
            prefixLine.get_GRDT00_Groupe_Value().get_GRCLEDT_Groupe_Value().get_GRCLEDTP_Groupe_Value().set_COSDT_Value("C");
        }
        prefixLine.get_GRDT00_Groupe_Value().get_GRCLEDT_Groupe_Value().get_GRCLEDTP_Groupe_Value().get_GRRANR_Groupe_Value().set_RANRU_Value("00");
        String nbCorubValue = String.valueOf(this.numberOfCorub);
        String str = "000" + nbCorubValue;
        String nbCorubDigit = str.substring(str.length() - 3);
        prefixLine.get_GRDT00_Groupe_Value().get_GRCLEDT_Groupe_Value().get_GRNULDTX_Groupe_Value().set_NULDT_Value(nbCorubDigit);
        this.extractLines.add(prefixLine.getCompleteContentForSegment().substring(0, 26).concat(labelForDataElement.getCompleteContentForSegment().substring(22)));
    }

    public void searchForMotherDataElement(PacDataElementDescription pacded, DataElement kDataElement, String aliasDE, boolean lirubLFound, boolean lirubCFound) {
        DataElement parentDataElement = null;
        String lirub = "";
        String delim = "";
        String lineType = "";
        if (pacded.getParent() != null) {
            parentDataElement = pacded.getParent();
            Iterator extensionsPar = parentDataElement.getDataDescription().getExtensions().iterator();
            while (extensionsPar.hasNext()) {
                try {
                    PacDataElementDescription cfr_ignored_0 = (PacDataElementDescription)extensionsPar.next();
                }
                catch (Exception exception) {}
            }
            PacDataElement pdeltP = null;
            if (parentDataElement instanceof DataElement) {
                Iterator extensionsEltP = parentDataElement.getExtensions().iterator();
                while (extensionsEltP.hasNext()) {
                    try {
                        pdeltP = (PacDataElement)extensionsEltP.next();
                    }
                    catch (Exception exception) {}
                }
                Iterator DLines = pdeltP.getDLines().iterator();
                if (DLines != null) {
                    while (DLines.hasNext()) {
                        PacDLine pPacDLine = (PacDLine)DLines.next();
                        if ((lirubLFound || !pPacDLine.getLineType().equals("L")) && (lirubCFound || !pPacDLine.getLineType().equals("C"))) continue;
                        lirub = pPacDLine.getDescription();
                        delim = pPacDLine.getAllowedValues().trim();
                        lineType = pPacDLine.getLineType();
                        DT80 labelForDataElement = new DT80();
                        labelForDataElement.set_ENTITE_Value(aliasDE);
                        labelForDataElement.set_SYNGR_Value(lirub);
                        labelForDataElement.set_VALRU_Value(delim);
                        this.formatLine3L3C(labelForDataElement, lineType);
                    }
                }
            }
        }
    }

    public void formatDescriptionDE(PacDLine pPacDLine) {
        DT80 descriptionDE = new DT80();
        String rangDataAggregate03 = "002";
        String debEnreg = rangDataAggregate03.concat("G");
        descriptionDE.get_GRCLEDT_Groupe_Value().get_GRCLEDTP_Groupe_Value().set_COSDT_Value(CLASNOTNUM);
        descriptionDE.get_GRCLEDT_Groupe_Value().get_GRCLEDTP_Groupe_Value().set_NUTAB_Value(this.tableNumber06);
        String nbCorubValue = String.valueOf(this.numberOfCorub);
        String nurub02 = "00" + nbCorubValue;
        String nuligrub = nurub02.substring(nurub02.length() - 2);
        descriptionDE.get_GRCLEDT_Groupe_Value().get_GRCLEDTP_Groupe_Value().get_GRRANR_Groupe_Value().set_RANRU_Value(nuligrub);
        descriptionDE.get_GRCLEDT_Groupe_Value().set_CLHTA_Value("99999999");
        ++this.nuligDescDE;
        String nuldt = "0000" + this.nuligDescDE;
        String nuldtx = nuldt.substring(nuldt.length() - 2);
        descriptionDE.get_GRCLEDT_Groupe_Value().get_GRNULDTX_Groupe_Value().set_NULDT_Value(nuldtx);
        descriptionDE.set_CODDT_Value("C");
        descriptionDE.set_ENTITE_Value(this.nameDataElement);
        descriptionDE.set_SAVED_Value(pPacDLine.getMore());
        descriptionDE.set_SYNGR_Value(pPacDLine.getDescription());
        descriptionDE.set_VALRU_Value(pPacDLine.getAllowedValues());
        String alldescriptionDE = debEnreg.concat(descriptionDE.getCompleteContentForSegment());
        this.extractLines.add(alldescriptionDE);
    }

    public void formatCommentDataAgg(PacGLine geLine) {
        String rangDataAggregate03 = "002";
        String debEnreg = rangDataAggregate03.concat("G");
        DT80 descriptionDA = new DT80();
        descriptionDA.get_GRCLEDT_Groupe_Value().get_GRCLEDTP_Groupe_Value().set_COSDT_Value(CLASNOTNUM);
        descriptionDA.get_GRCLEDT_Groupe_Value().get_GRCLEDTP_Groupe_Value().set_NUTAB_Value(this.tableNumber06);
        descriptionDA.get_GRCLEDT_Groupe_Value().get_GRCLEDTP_Groupe_Value().get_GRRANR_Groupe_Value().set_RANRU_Value("00");
        descriptionDA.get_GRCLEDT_Groupe_Value().set_CLHTA_Value("99999999");
        ++this.nuligCommentDA;
        String nuldt = "0000" + this.nuligCommentDA;
        String nuldtx = nuldt.substring(nuldt.length() - 2);
        descriptionDA.get_GRCLEDT_Groupe_Value().get_GRNULDTX_Groupe_Value().set_NULDT_Value(nuldtx);
        descriptionDA.set_CODDT_Value("C");
        descriptionDA.set_SYNGR_Value(geLine.getDescription());
        String alldescriptionDA = debEnreg.concat(descriptionDA.getCompleteContentForSegment());
        this.extractLines.add(alldescriptionDA);
    }

    public void treatmentTextDataAgg(PacGLine geLine) {
        String geLineDescription = geLine.getDescription().trim();
        String codParag = geLineDescription.substring(6);
        RadicalEntity re = geLine.getLinkedEntity();
        if (re instanceof PacText) {
            PacText currentText = (PacText)re;
            for (Object objSC : currentText.getSections()) {
                PacTextSection parag;
                if (!(objSC instanceof PacTextSection) || !codParag.equals((parag = (PacTextSection)objSC).getSectionCode()) && !codParag.equals("**")) continue;
                for (PacTextConverter.PacTextLineCommonModel textLine : PacTextConverter.CutSectionToLine((PacTextSection)parag, (PacText)currentText)) {
                    if (textLine.getLineType().equals(PacTextLineTypeValues._I_LITERAL) || textLine.getLineType().equals(PacTextLineTypeValues._J_LITERAL)) continue;
                    this.formatTextLine(textLine);
                }
            }
        }
    }

    public void formatTextLine(PacTextConverter.PacTextLineCommonModel textLine) {
        String rangDataAggregate03 = "002";
        String debEnreg = rangDataAggregate03.concat("G");
        DT80 textLineDA = new DT80();
        textLineDA.get_GRCLEDT_Groupe_Value().get_GRCLEDTP_Groupe_Value().set_COSDT_Value(CLASNOTNUM);
        textLineDA.get_GRCLEDT_Groupe_Value().get_GRCLEDTP_Groupe_Value().set_NUTAB_Value(this.tableNumber06);
        textLineDA.get_GRCLEDT_Groupe_Value().get_GRCLEDTP_Groupe_Value().get_GRRANR_Groupe_Value().set_RANRU_Value("00");
        textLineDA.get_GRCLEDT_Groupe_Value().set_CLHTA_Value("99999999");
        ++this.nuligCommentDA;
        String nuldt = "0000" + this.nuligCommentDA;
        String nuldtx = nuldt.substring(nuldt.length() - 2);
        textLineDA.get_GRCLEDT_Groupe_Value().get_GRNULDTX_Groupe_Value().set_NULDT_Value(nuldtx);
        textLineDA.set_CODDT_Value("C");
        if (textLine.getLineText() != null) {
            textLineDA.set_SYNGR_Value(textLine.getLineText());
        } else {
            textLineDA.set_SYNGR_Value("");
        }
        if (textLine.getLineType().equals(PacTextLineTypeValues._1_LITERAL) || textLine.getLineType().equals(PacTextLineTypeValues._2_LITERAL) || textLine.getLineType().equals(PacTextLineTypeValues._3_LITERAL) || textLine.getLineType().equals(PacTextLineTypeValues._4_LITERAL) || textLine.getLineType().equals(PacTextLineTypeValues._5_LITERAL) || textLine.getLineType().equals(PacTextLineTypeValues._6_LITERAL) || textLine.getLineType().equals(PacTextLineTypeValues._7_LITERAL) || textLine.getLineType().equals(PacTextLineTypeValues._8_LITERAL) || textLine.getLineType().equals(PacTextLineTypeValues._9_LITERAL)) {
            textLineDA.set_SAVED_Value(textLine.getLineType().getLiteral().substring(1, 2));
        }
        String alltextLineDA = debEnreg.concat(textLineDA.getCompleteContentForSegment());
        this.extractLines.add(alltextLineDA);
    }

    public void formatSsLines(PacSubSchemaSubSystemDefinition ssLine) {
        NR00 prefixLine = new NR00();
        prefixLine.set_GRNULI8_Value("000");
        prefixLine.set_COSNM_Value("2");
        prefixLine.get_GRDT00_Groupe_Value().get_GRCLEDT_Groupe_Value().get_GRCLEDTP_Groupe_Value().set_COSDT_Value("1");
        prefixLine.get_GRDT00_Groupe_Value().get_GRCLEDT_Groupe_Value().get_GRCLEDTP_Groupe_Value().get_GRRANR_Groupe_Value().set_RANRU_Value("00");
        String nbCorubValue = String.valueOf(++this.nuligSs);
        String str = "0000" + nbCorubValue;
        String nbCorubDigit = str.substring(str.length() - 4);
        prefixLine.get_GRDT00_Groupe_Value().get_GRCLEDT_Groupe_Value().get_GRNULDTX_Groupe_Value().set_NULDT_Value(nbCorubDigit);
        A82G ssline = new A82G();
        ssline.get_GRPR2G_Groupe_Value().set_GRFIENR_Value(this.nameDataAggregate);
        ssline.get_GRPR2G_Groupe_Value().set_TYDSD_Value(ssLine.getTableLineType().getLiteral().substring(1));
        ssline.get_GRPR2G_Groupe_Value().set_NUSCY_Value(String.valueOf(ssLine.getNumber()));
        ssline.get_GRPR2G_Groupe_Value().set_LISTD_Value(ssLine.getSubSchemaOrSystemName());
        ssline.get_GRPR2G_Groupe_Value().set_NBENR_Value(ssLine.getMaxOccurrencesNumber());
        this.extractLines.add(prefixLine.getCompleteContentForSegment().substring(0, 26).concat(ssline.getCompleteContentForSegment()));
    }

    public List getExtractLines() {
        return this.extractLines;
    }

    public void setNameOfProject(String projectName) {
        this.nameOfProject = projectName;
    }

    public String getNameOfProject() {
        return this.nameOfProject;
    }

    public char searchVariant(DataAggregate da) {
        char var = 'X';
        PacLibrary lib = PacbaseModelService.getInstance().searchForGenerationParameter(da, this.nameOfProject);
        lib.getAlphanumericDelimiter();
        String variantForEntity = lib.getCobolType().getLiteral().substring(1);
        var = variantForEntity.charAt(0);
        return var;
    }
}

