/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.snippets;

import com.ibm.etools.webtools.flatui.FlatEditor;
import com.ibm.pdp.mdl.pacbase.editor.MacroFlatEditor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.common.snippets.core.ISnippetItem;
import org.eclipse.wst.common.snippets.ui.DefaultSnippetInsertion;

public class SnippetInsertion
extends DefaultSnippetInsertion {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String mpRppinfoId = "com.ibm.rpp.snippet.mprppinfo";
    private static String indId = "com.ibm.rpp.snippet.indices";
    private static String loopId = "com.ibm.rpp.snippet.loop";
    private static String wiId = "com.ibm.rpp.snippet.mpwi";
    private static String weId = "com.ibm.rpp.snippet.mpwe";
    private static String wsId = "com.ibm.rpp.snippet.mpws";
    private static String schId = "com.ibm.rpp.snippet.search";
    private static String evalId = "com.ibm.rpp.snippet.evaluate";
    private ISnippetItem item;
    boolean isNewLineNeeded = true;

    public void dragSetData(DragSourceEvent event, ISnippetItem item) {
        super.dragSetData(event, item);
        if (event.data.equals(" ")) {
            event.data = null;
        }
        if (event.data != null) {
            event.data = this.formatCobolLine(event.data.toString(), item);
        }
    }

    private String formatCobolLine(String data, ISnippetItem item) {
        StringBuilder paramLine = new StringBuilder();
        if (this.isNewLineNeeded) {
            paramLine = paramLine.append(System.getProperty("line.separator"));
        }
        data = paramLine.append("      ").append(data).toString();
        StringBuilder result = new StringBuilder();
        String snippetId = item.getId();
        if (!wiId.equals(snippetId) & !weId.equals(snippetId) & !wsId.equals(snippetId) & !schId.equals(snippetId) & !evalId.equals(snippetId)) {
            data = this.removeUnvalorizedParameters(data, result);
        }
        if (indId.equals(snippetId)) {
            data = this.getDataForInd(data);
        } else {
            if (evalId.equals(snippetId)) {
                data = this.getDataForCall(data);
            }
            if (wiId.equals(snippetId) | weId.equals(snippetId) | wsId.equals(snippetId)) {
                data = this.getDataForMpWIES(data);
                data = this.removeUnvalorizedParameterIDT(data, result);
            } else if (schId.equals(snippetId)) {
                IEditorPart editor;
                IWorkbenchPage wbPage;
                String coa = "coa";
                IWorkbenchWindow wbWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (wbWindow != null && (wbPage = wbWindow.getActivePage()) != null && (editor = wbPage.getActiveEditor()) != null && editor instanceof FlatEditor) {
                    coa = "COA";
                }
                data = data.toUpperCase();
                data = this.getDataForSearch(data, coa);
            } else if (evalId.equals(snippetId)) {
                data = this.getDataForEval(data);
            }
        }
        if (!(mpRppinfoId.equals(snippetId) || loopId.equals(snippetId) || wiId.equals(snippetId) || weId.equals(snippetId) || wsId.equals(snippetId) || evalId.equals(snippetId) || schId.equals(snippetId))) {
            data = data.toUpperCase();
        }
        return data;
    }

    private String getDataForInd(String data) {
        return String.valueOf(data.substring(0, 3)) + "      " + data.substring(3);
    }

    private String getDataForCall(String data) {
        data = String.valueOf(data.substring(0, 3)) + "     " + data.substring(3);
        return data;
    }

    private String getDataForSearch(String data, String coa) {
        String systemEOL = System.getProperty("line.separator");
        String[] lines = data.split(systemEOL);
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < lines.length) {
            if (lines[i].length() > 8 && lines[i].substring(0, 7).trim().length() == 0 && lines[i].charAt(7) != ' ') {
                StringBuilder sb = new StringBuilder(lines[i]);
                while (sb.length() < 72) {
                    sb.append(" ");
                }
                sb.append(coa);
                result.append(sb.toString());
            } else {
                result.append(lines[i]);
            }
            result.append(systemEOL);
            ++i;
        }
        return result.toString();
    }

    private String getDataForMpWIES(String data) {
        String[] tab = data.split("\r\n");
        String line = tab[3].trim();
        boolean valueToWrite = !"VALUE".equals(line);
        boolean valueToUppercase = true;
        if (valueToWrite) {
            String afterValue = line.substring(5).trim();
            valueToUppercase = afterValue.charAt(0) != '\"' & afterValue.charAt(0) != '\'';
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\r\n");
        sb.append(tab[1]);
        sb.append("\r\n");
        sb.append(tab[2].toUpperCase());
        if (valueToWrite) {
            sb.append("\r\n");
            if (valueToUppercase) {
                sb.append(tab[3].toUpperCase());
            } else {
                sb.append(tab[3]);
            }
        }
        return sb.toString();
    }

    private String getDataForEval(String data) {
        StringBuilder sb = new StringBuilder();
        String[] lines = data.split("\r\n");
        int i = 0;
        while (i < lines.length) {
            char[] car = lines[i].toCharArray();
            boolean valueToUppercase = true;
            char[] cArray = car;
            int n = car.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (c == '\"' || c == '\'') {
                    valueToUppercase = !valueToUppercase;
                }
                if (valueToUppercase) {
                    sb.append(String.valueOf(c).toUpperCase());
                } else {
                    sb.append(c);
                }
                ++n2;
            }
            if (i < lines.length - 1) {
                sb.append("\r\n");
            }
            ++i;
        }
        return sb.toString();
    }

    private String removeUnvalorizedParameterIDT(String data, StringBuilder result) {
        int pos = data.indexOf("IDT=\r\n");
        if (pos == -1) {
            result.append(data);
        } else {
            String before = data.substring(0, pos);
            String end = data.substring(pos + 4);
            result.append(before);
            result.append(end);
        }
        return result.toString();
    }

    private String removeUnvalorizedParameters(String data, StringBuilder result) {
        int pos = data.indexOf("=");
        if (pos == -1) {
            result.append(data);
        } else if (pos != data.length() - 1) {
            if (data.charAt(pos + 1) != ' ') {
                String following = data.substring(pos + 1);
                int nextpos = following.indexOf(32);
                if (nextpos != -1 && (following.substring(0, nextpos).equals("=") || following.substring(0, nextpos).equals("<=") || following.substring(0, nextpos).equals(">=") || following.substring(0, nextpos).equals("NOT="))) {
                    result.append(data.substring(0, pos + nextpos + 1));
                    this.removeUnvalorizedParameters(data.substring(pos + nextpos + 1), result);
                } else {
                    result.append(data.substring(0, pos + 1));
                    this.removeUnvalorizedParameters(data.substring(pos + 1), result);
                }
            } else {
                String before = data.substring(0, pos);
                result.append(before.substring(0, before.lastIndexOf(" ")));
                this.removeUnvalorizedParameters(data.substring(pos + 1), result);
            }
        } else {
            String before = data.substring(0, pos);
            int end = before.lastIndexOf(32);
            result.append(before.substring(0, end));
        }
        return result.toString();
    }

    protected String getInsertString(Shell host) {
        String text = super.getInsertString(host);
        return text.trim().length() > 0 ? this.formatCobolLine(text, this.item) : "";
    }

    public void insert(IEditorPart editorPart) {
        if (editorPart instanceof FlatEditor) {
            editorPart = this.searchEditorPart(editorPart);
        }
        super.insert(editorPart);
    }

    public void setItem(ISnippetItem item) {
        super.setItem(item);
        this.item = item;
    }

    private IEditorPart searchEditorPart(IEditorPart editorPart) {
        IEditorPart[] parts;
        ISelectionProvider selectionP;
        this.isNewLineNeeded = true;
        if (editorPart.getClass().getName().equals(MacroFlatEditor._EDITOR_ID) && (selectionP = ((ITextEditor)(editorPart = (parts = ((FlatEditor)editorPart).findEditors(editorPart.getEditorInput()))[0])).getSelectionProvider()) != null && selectionP.getSelection() instanceof ITextSelection && ((ITextSelection)selectionP.getSelection()).getOffset() == 0) {
            this.isNewLineNeeded = false;
        }
        return editorPart;
    }
}

