/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.micropattern.rtc;

import com.ibm.pdp.engine.IBuilderTag;
import com.ibm.pdp.engine.IGenInfoBuilder;
import com.ibm.pdp.engine.IMicroPattern;
import com.ibm.pdp.mdl.kernel.AggregateValue;
import com.ibm.pdp.mdl.kernel.Field;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.StringValue;
import com.ibm.pdp.mdl.kernel.UserEntity;
import com.ibm.pdp.pacbase.design.EMFBatchModelLoaderSaver;
import com.ibm.pdp.pacbase.extension.micropattern.AbstractCommonMicroPatternHandler;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class RPPinfoMicroPatternHandler
extends AbstractCommonMicroPatternHandler {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String ID = "RPPinfo";
    private static final String SUB_TYPE = ".NDVLM";
    private static final String UE_TYPE = "userentity";
    private static final String ENDEVOR = "Endevor";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String DESIGN_FILE = "DESIGN_FILE_IN_CONTEXT";

    public String getId() {
        return ID;
    }

    public String getNamespace() {
        return null;
    }

    public void init() {
        super.init();
    }

    public void internalProcess(IMicroPattern microPattern, IGenInfoBuilder genInfoBuilder) {
        String design;
        Object obj = microPattern.getProcessingContext().getData(DESIGN_FILE);
        if (obj == null && (design = microPattern.getProcessingContext().getGenerationProperties().getProperty("DESIGN_PATH")) != null) {
            obj = EMFBatchModelLoaderSaver.loadResource((IPath)new Path(design));
        }
        if (obj instanceof RadicalEntity) {
            UserEntity userEntity;
            IBuilderTag tag;
            String user = "";
            RadicalEntity radicalEntity = (RadicalEntity)obj;
            IPath path = radicalEntity.getPath(radicalEntity.getProject());
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            IShareable target = (IShareable)resource.getAdapter(IShareable.class);
            if (target != null) {
                try {
                    IShare share = target.getShare(null);
                    if (share != null) {
                        ISharingDescriptor sharingDescriptor = share.getSharingDescriptor();
                        ITeamRepositoryService teamRepositoryService = TeamPlatform.getTeamRepositoryService();
                        ITeamRepository teamRepository = teamRepositoryService.getTeamRepository(sharingDescriptor.getRepositoryId());
                        if (teamRepository != null) {
                            user = teamRepository.getLoginInfo().getLoginProperties().getProperty("username");
                        }
                    }
                }
                catch (FileSystemException exception) {
                    user = exception.getLocalizedMessage();
                }
            }
            if ((tag = genInfoBuilder.tagFromName(this.getId())) == null) {
                tag = genInfoBuilder.addTag(microPattern.getLocation().getEndIndex(), microPattern.getLocation().getEndIndex(), this.getId());
            }
            Date date = new Date();
            StringBuilder builder = new StringBuilder();
            builder.append("      *USER=" + user + NEW_LINE);
            builder.append("      *PROJECT=" + radicalEntity.getProject() + NEW_LINE);
            builder.append("      *ENTITY=" + radicalEntity.getName() + NEW_LINE);
            builder.append("      *TYPE=" + path.getFileExtension() + NEW_LINE);
            builder.append("      *DATE=" + new SimpleDateFormat("yyyy/MM/dd").format(date) + NEW_LINE);
            builder.append("      *TIME=" + new SimpleDateFormat("HH:mm:ss").format(date) + NEW_LINE);
            tag.setText((CharSequence)builder.toString());
            if (("true".equals(microPattern.getAttribute(ENDEVOR)) || microPattern.getOriginalHeaderDeclaration().contains(ENDEVOR)) && (userEntity = (UserEntity)this.searchRadicalEntity(radicalEntity.getProject(), radicalEntity.getPackage(), radicalEntity.getName(), SUB_TYPE, UE_TYPE, microPattern.getProcessingContext())) != null && userEntity.getField() != null && userEntity.getField().getValue() instanceof AggregateValue) {
                Field field;
                AggregateValue aggregateValue = (AggregateValue)userEntity.getField().getValue();
                if (userEntity.getField().getValue() instanceof AggregateValue && (field = aggregateValue.getField("00")) != null && field.getValue() instanceof AggregateValue) {
                    aggregateValue = (AggregateValue)field.getValue();
                    IBuilderTag endevorTag = genInfoBuilder.tagFromName(ENDEVOR);
                    if (endevorTag == null) {
                        endevorTag = genInfoBuilder.addTag(tag.getEndIndex(), tag.getEndIndex(), ENDEVOR, this.getId());
                    }
                    builder = new StringBuilder();
                    builder.append("      *ENVIRONMENT=" + this.getFieldValue(aggregateValue, ".PN010") + NEW_LINE);
                    builder.append("      *SYSTEM=" + this.getFieldValue(aggregateValue, ".PN020") + NEW_LINE);
                    builder.append("      *SUBSYSTEM=" + this.getFieldValue(aggregateValue, ".PN030") + NEW_LINE);
                    builder.append("      *TYPEPAC=" + this.getFieldValue(aggregateValue, ".PN040") + NEW_LINE);
                    builder.append("      *COMMENT=" + this.getFieldValue(aggregateValue, ".PN092") + NEW_LINE);
                    builder.append("      *CCID=" + this.getFieldValue(aggregateValue, ".PN091") + NEW_LINE);
                    endevorTag.setText((CharSequence)builder.toString());
                }
            }
        }
    }

    private String getFieldValue(AggregateValue aggregateValue, String fieldName) {
        if (aggregateValue.getField(fieldName) != null) {
            return ((StringValue)aggregateValue.getField(fieldName).getValue()).getValue();
        }
        return "";
    }

    protected String handleLocalFragment(IMicroPattern microPattern, IGenInfoBuilder genInfoBuilder) {
        return null;
    }

    protected void addOtherFragments(IMicroPattern microPattern, IGenInfoBuilder genInfoBuilder) {
    }
}

