/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.generate.util;

import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacDialog;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.pacbase.generate.util.Field;
import com.ibm.pdp.pacbase.generate.util.Messages;
import com.ibm.pdp.pacbase.generate.util.PacbaseModelService;
import com.ibm.pdp.pacbase.generate.util.ScreenPositions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ScreenAddress {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static boolean hasErrorFields(PacScreen screen) {
        for (Field field : ScreenAddress.getAllFields(screen)) {
            if (!field.isInError()) continue;
            return true;
        }
        return false;
    }

    public static List<Field> getAllFields(PacScreen screen) {
        RadicalEntity obj;
        List<Field> addressFields = new ArrayList<Field>();
        addressFields = ScreenAddress.InitializeFields(screen, addressFields);
        int rows = 0;
        int columns = 0;
        if (screen.getScreenLineNumber() > 0) {
            rows = screen.getScreenLineNumber();
        }
        if (screen.getScreenColumnNumber() > 0) {
            columns = screen.getScreenColumnNumber();
        }
        if ((rows == 0 || columns == 0) && (obj = PacbaseModelService.SearchRadicalEntityDuringGeneration((RadicalEntity)screen, screen.getName().substring(0, 2), "pacdialog")) instanceof PacDialog) {
            PacDialog dialog = (PacDialog)obj;
            if (rows == 0) {
                rows = dialog.getScreenLineNumber();
            }
            if (columns == 0) {
                columns = dialog.getScreenColumnNumber();
            }
        }
        ScreenAddress.validate(addressFields, rows, columns);
        ScreenAddress.sortAddressFields(addressFields);
        return addressFields;
    }

    public static List<Field> InitializeFields(PacScreen screen, List<Field> fields) {
        ScreenPositions positions = new ScreenPositions();
        positions.analyse(screen, screen.getGenerationParameter());
        ScreenPositions.ScreenStructure[] tab = positions.getAllFieldsBeforeSort();
        return ScreenAddress.ConvertScreenStructure(tab, fields);
    }

    public static List<Field> ConvertScreenStructure(ScreenPositions.ScreenStructure[] tab, List<Field> fields) {
        int tabLength = tab.length;
        int i = 0;
        while (i < tabLength) {
            ScreenPositions.ScreenStructure element = tab[i];
            if (element != null) {
                Field field = new Field();
                field.setLine(element.getPOLEC9());
                field.setColumn(element.getPOCEC9());
                field.setLength(element.getLOLIB());
                field.setFieldType(element.getTLIB());
                field.setCode(element.getCORUB());
                if (element.getREPET91() > 0) {
                    field.setCategoryRepeat(String.valueOf(element.getREPET91()));
                }
                if (element.getREPET92_ADR() > 0) {
                    field.setFieldHorizontalRepeat(String.valueOf(element.getREPET92_ADR()));
                }
                if (element.getREPET93_ADR() > 0) {
                    field.setFieldVerticalRepeat(String.valueOf(element.getREPET93_ADR()));
                }
                field.setToken(element.getTOKEN());
                fields.add(field);
            }
            ++i;
        }
        return fields;
    }

    public static void validate(List<Field> fields, int rows, int columns) {
        int[][] overlap = new int[rows][columns];
        int k = 0;
        while (k < fields.size()) {
            StringBuilder message = new StringBuilder();
            Field field = fields.get(k);
            int length = field.getLength();
            if (length < 0) {
                message.append(Messages._WRONG_FIELD_LENGTH + ScreenAddress.formatMessage(field, null));
                field.setInError(true);
                field.setErrorMessage(message);
            } else if (field.getLine() > rows) {
                message.append(Messages._WRONG_FIELD_ROW + ScreenAddress.formatMessage(field, null));
                field.setInError(true);
                field.setErrorMessage(message);
            } else if (field.getColumn() > columns) {
                message.append(Messages._WRONG_FIELD_COLUMN + ScreenAddress.formatMessage(field, null));
                field.setInError(true);
                field.setErrorMessage(message);
            } else {
                if (field.getColumn() + length - 1 > columns) {
                    message.append(Messages._WRONG_FIELD_COLUMN_LENGTH + ScreenAddress.formatMessage(field, null));
                }
                if (field.getToken().equals("<")) {
                    message.append(Messages._WRONG_ADR_MESSAGE + ScreenAddress.formatMessage(field, null));
                    field.setInError(true);
                    field.setErrorMessage(message);
                    message = new StringBuilder();
                }
                int i = 0;
                while (i < length) {
                    block13: {
                        try {
                            if (overlap[field.getLine() - 1][field.getColumn() - 1 + i] == 0) {
                                overlap[field.getLine() - 1][field.getColumn() - 1 + i] = k + 1;
                                break block13;
                            }
                            Field fieldOverlap = fields.get(overlap[field.getLine() - 1][field.getColumn() - 1 + i] - 1);
                            message.append(Messages._WRONG_FIELD_OVERLAP + ScreenAddress.formatMessage(field, fieldOverlap));
                            field.setInError(true);
                            field.setErrorMessage(message);
                            break;
                        }
                        catch (Exception exception) {}
                    }
                    ++i;
                }
            }
            ++k;
        }
    }

    private static String formatMessage(Field current, Field overlap) {
        StringBuilder message = new StringBuilder("\n\t");
        message.append(Messages._LINE + " : " + current.getLine());
        message.append(" - " + Messages._COLUMN + " : " + current.getColumn());
        message.append(" - " + Messages._LENGTH + " : " + current.getLength());
        message.append(" - " + Messages._LABEL + " : " + current.getFieldCode());
        if (overlap != null) {
            message.append("\n\t");
            message.append(Messages._LINE + " : " + overlap.getLine());
            message.append(" - " + Messages._COLUMN + " : " + overlap.getColumn());
            message.append(" - " + Messages._LENGTH + " : " + overlap.getLength());
            message.append(" - " + Messages._LABEL + " : " + overlap.getFieldCode());
        }
        return message.toString();
    }

    private static void sortAddressFields(List<Field> fields) {
        Collections.sort(fields, new Comparator<Field>(){

            @Override
            public int compare(Field arg0, Field arg1) {
                if (arg0.getLine() != arg1.getLine()) {
                    return arg0.getLine() - arg1.getLine();
                }
                return arg0.getColumn() - arg1.getColumn();
            }
        });
    }
}

