/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.generate.util;

import com.ibm.pdp.util.performance.PerformanceManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class PacbaseProcessBuilder {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2024.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String DOS_TOTAL_TIME = "DOS_TOTAL_TIME";
    ProcessBuilder processBuilder = null;
    Process process = null;
    private long start = 0L;
    PerformanceManager performanceManager = PerformanceManager.getInstance();

    protected PacbaseProcessBuilder(ProcessBuilder processBuilder) {
        this.processBuilder = processBuilder;
    }

    public void start() throws IOException {
        if (this.performanceManager.isEnabled()) {
            this.start = System.currentTimeMillis();
        }
        this.process = this.processBuilder.start();
    }

    public void waitFor() throws InterruptedException {
        this.process.waitFor();
        if (this.performanceManager.isEnabled()) {
            this.performanceManager.addTotalTimeMillis(DOS_TOTAL_TIME, System.currentTimeMillis() - this.start);
        }
    }

    public InputStream getInputStream() {
        return this.process.getInputStream();
    }

    public InputStream getErrorStream() {
        return this.process.getErrorStream();
    }

    public Process getProcess() {
        return this.process;
    }

    public Map<String, String> environment() {
        return this.processBuilder.environment();
    }

    public void directory(File directory) {
        this.processBuilder.directory(directory);
    }

    public ProcessBuilder getProcessBuilder() {
        return this.processBuilder;
    }
}

