/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.generate.util;

import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.explorer.model.PTMessageManager;
import com.ibm.pdp.explorer.model.service.PTModelService;
import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.kernel.DataDescriptionExtension;
import com.ibm.pdp.mdl.kernel.DataElement;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.RadicalEntityExtension;
import com.ibm.pdp.mdl.pacbase.PacCPLine;
import com.ibm.pdp.mdl.pacbase.PacDataElementDescription;
import com.ibm.pdp.mdl.pacbase.PacDataElementInternalUsageValues;
import com.ibm.pdp.mdl.pacbase.PacLibrary;
import com.ibm.pdp.mdl.pacbase.PacMacroParameter;
import com.ibm.pdp.mdl.pacbase.PacRadicalEntity;
import com.ibm.pdp.pacbase.generate.Activator;
import com.ibm.pdp.pacbase.generate.util.Messages;
import com.ibm.pdp.pacbase.generate.util.PacbaseLinksEntitiesService;
import com.ibm.pdp.pacbase.generate.util.PacbaseProcessBuilder;
import com.ibm.pdp.trace.PTTraceManager;
import com.ibm.pdp.util.PdpConstants;
import com.ibm.pdp.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class PacbaseModelService {
    private static PacbaseModelService _instance = null;
    private static final String RPP_WINDOW_HOME = System.getenv("RPP_WINDOW_HOME") != null ? System.getenv("RPP_WINDOW_HOME") : "z:" + System.getProperty("user.home") + "/tmp";
    private static final String RPP_DATA_HOME = System.getenv("RPP_DATA_HOME") != null ? System.getenv("RPP_DATA_HOME") : "DEFAULT";
    private static final String RPP_DRIVE = RPP_WINDOW_HOME.substring(0, 2);
    private static final String RPP_DATA_DRIVE = RPP_DATA_HOME.substring(0, 2);
    private static boolean dllChecked = false;
    private static boolean isUnix = PdpConstants.IS_UNIX_OS;
    private static final String DLL_NAME = "msvcr71.dll";
    private static File tmpDir = null;
    private Map<String, File> allGenerators = new HashMap<String, File>();
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static PacbaseModelService getInstance() {
        if (_instance == null) {
            _instance = new PacbaseModelService();
        }
        return _instance;
    }

    public String getCPLineIdentifier(PacCPLine cpLine) {
        StringBuilder sb = new StringBuilder();
        sb.append(cpLine.getMacro().getPath(cpLine.getMacro().getProject()).removeFileExtension().toString());
        String str = "00" + String.valueOf(cpLine.getLineNumber());
        String lengthWithZero = str.substring(str.length() - 2);
        sb.append(lengthWithZero);
        return sb.toString();
    }

    public static String getRunningProcess(String processName) throws IOException {
        String line;
        String process = null;
        Process p = Runtime.getRuntime().exec("tasklist.exe /fo csv /nh");
        BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
        while ((line = input.readLine()) != null) {
            int idx;
            if (line.trim().equals("") || !(line = line.substring(1)).contains(processName) || (idx = line.indexOf("\",\"")) <= 0 || (idx = (line = line.substring(idx + 3)).indexOf("\",\"")) <= 0) continue;
            process = line.substring(0, idx);
            break;
        }
        input.close();
        return process;
    }

    public List<String> formatCallCP(PacCPLine cpLine) {
        Iterator parameterForLine = cpLine.getParameters().iterator();
        ArrayList<String> params = new ArrayList<String>();
        while (parameterForLine.hasNext()) {
            StringBuilder sb = null;
            PacMacroParameter param = (PacMacroParameter)parameterForLine.next();
            if (param.getValue() != null) {
                sb = new StringBuilder(param.getValue());
            } else if (param.isCallingElement()) {
                sb = new StringBuilder();
                if (param.getDataAggregate() != null) {
                    sb.append(param.getDataAggregate().getName());
                } else if (param.getDataElement() != null) {
                    sb.append(param.getDataElement().getName());
                } else if (param.getDataUnit() != null) {
                    sb.append(param.getDataUnit().getName());
                }
            }
            params.add(sb.toString());
        }
        return params;
    }

    public PacbaseProcessBuilder instanciateProcess(String[] command, Map<String, String> environment, String workingDirectory) throws IOException {
        PTTraceManager traceManager;
        int engineTraceLevel;
        PacbaseProcessBuilder processBuilder = this._instanciateProcess(command);
        Map<String, String> env = processBuilder.environment();
        String rdzCobolRuntimeDir = PacbaseModelService.getCobolRuntimeFolder();
        Object newPath = rdzCobolRuntimeDir + "/bin";
        if (isUnix) {
            env.put("RPP_PATH", (String)newPath);
            env.put("RPP_TIMESTAMP", Long.toString(System.currentTimeMillis()));
            env.put("RPP_DRIVE", RPP_DRIVE);
            env.put("RPP_DATA_DRIVE", RPP_DATA_DRIVE);
            env.put("RPP_WINDOW_HOME", RPP_WINDOW_HOME);
            env.put("RPP_DATA_HOME", RPP_DATA_HOME);
        }
        boolean pathDone = false;
        String newNlsPath = rdzCobolRuntimeDir + "/messages/%L/%N";
        boolean nlsDone = false;
        for (String tmpKey : env.keySet()) {
            String tmpKeyToLC = tmpKey.toLowerCase();
            Object path = null;
            if (tmpKeyToLC.equals("path")) {
                path = env.get(tmpKey);
                path = path != null && ((String)path).trim().length() > 0 ? (String)newPath + (isUnix ? (char)':' : ';') + (String)path : newPath;
                newPath = path;
                env.put(tmpKey, (String)path);
                pathDone = true;
                continue;
            }
            if (!tmpKeyToLC.equals("nlspath")) continue;
            path = env.get(tmpKey);
            path = path != null && ((String)path).trim().length() > 0 ? newNlsPath + ";" + (String)path : newNlsPath;
            env.put(tmpKey, (String)path);
            nlsDone = true;
        }
        this.checkWindowsDLL((String)newPath);
        if (!pathDone) {
            env.put("PATH", (String)newPath);
        }
        if (!nlsDone) {
            env.put("NLSPATH", newNlsPath);
        }
        if (environment != null) {
            processBuilder.environment().putAll(environment);
        }
        if (workingDirectory != null) {
            processBuilder.directory(new File(workingDirectory));
        }
        if ((engineTraceLevel = (traceManager = PTTraceManager.getInstance()).getTraceLevel("com.ibm.pdp.pac")) > 0) {
            Object cmd = "";
            String[] stringArray = command;
            int n = command.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                cmd = (String)cmd + " " + arg;
                ++n2;
            }
            traceManager.trace(PacbaseModelService.class, "com.ibm.pdp.pac", 1, " Process command Line\t" + (String)cmd);
            if (environment != null) {
                traceManager.trace(PacbaseModelService.class, "com.ibm.pdp.pac", 1, "Environments : " + String.valueOf(environment));
            }
            if (workingDirectory != null) {
                traceManager.trace(PacbaseModelService.class, "com.ibm.pdp.pac", 1, "Working Directory : " + workingDirectory);
            }
            if (!isUnix) {
                StringBuilder builder = new StringBuilder();
                if (environment != null) {
                    for (String key : environment.keySet()) {
                        builder.append(key).append("=").append(environment.get(key)).append("\r\n");
                    }
                }
                if (workingDirectory != null) {
                    builder.append("CD").append(" ").append(workingDirectory).append("\r\n");
                }
                builder.append("SET PATH=").append(((String)newPath).replace('/', '\\')).append(";%PATH%").append("\r\n");
                builder.append("SET NLSPATH=").append(newNlsPath.replace('/', '\\')).append(";%NLSPATH%").append("\r\n");
                builder.append("CALL " + (String)cmd).append("\r\n");
                builder.append("CD C:\\Temp").append("\r\n");
                builder.append("C:").append("\r\n");
                try {
                    new File("c:/temp").mkdir();
                    FileOutputStream outputStream = new FileOutputStream("c:/temp/generate.bat");
                    outputStream.write(builder.toString().getBytes());
                    outputStream.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return processBuilder;
    }

    private void checkWindowsDLL(String paths) {
        if (!dllChecked) {
            if (!isUnix) {
                boolean found = false;
                if (paths != null) {
                    String[] stringArray = paths.split(";");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String path = stringArray[n2];
                        if (new File(path + "/msvcr71.dll").exists()) {
                            found = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!found) {
                        found = new File("C:/Windows/SysWOW64/msvcr71.dll").exists();
                    }
                }
                if (!found) {
                    if (PlatformUI.isWorkbenchRunning()) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                PTMessageManager.handleError((String)Messages._MISSING_MSVCR71_DLL_MESG);
                            }
                        });
                    }
                    throw new RuntimeException(Messages._MISSING_MSVCR71_DLL_MESG);
                }
                dllChecked = true;
            } else {
                dllChecked = true;
            }
        }
    }

    public PacbaseProcessBuilder instanciateProcess(String[] command) throws IOException {
        return this.instanciateProcess(command, null, null);
    }

    private PacbaseProcessBuilder _instanciateProcess(String[] command) throws IOException {
        ProcessBuilder pb = null;
        if (!isUnix) {
            pb = new ProcessBuilder(command);
        } else {
            String[] linuxCommand = new String[command.length + 1];
            System.arraycopy(command, 0, linuxCommand, 1, command.length);
            linuxCommand[0] = "sh";
            if (System.getProperty("rpp.unix.scripts") != null) {
                String commandName = linuxCommand[1];
                int idx = commandName.indexOf("script_linux");
                linuxCommand[1] = System.getProperty("rpp.unix.scripts") + commandName.substring(idx + "script_linux".length());
            }
            pb = new ProcessBuilder(linuxCommand);
        }
        return new PacbaseProcessBuilder(pb);
    }

    public static String getCobolRuntimeFolder() throws IOException {
        Object rdzCobolRuntimeDir = PdpConstants.COBOL_RUNTIME;
        if (rdzCobolRuntimeDir == null) {
            String launcher = System.getProperty("eclipse.launcher");
            if (launcher != null) {
                File launcherFile = new File(launcher);
                rdzCobolRuntimeDir = launcherFile.getParentFile().getCanonicalPath();
            } else {
                rdzCobolRuntimeDir = new File(".").getCanonicalPath();
            }
            rdzCobolRuntimeDir = (String)rdzCobolRuntimeDir + "/rpp";
        }
        return rdzCobolRuntimeDir;
    }

    public static RadicalEntity SearchRadicalEntityDuringGeneration(RadicalEntity generationEntryPoint, String entityCodeToSearch, String entityTypeToSearch, PacbaseLinksEntitiesService ples) {
        RadicalEntity re = PacbaseModelService.SearchRadicalEntityDuringGeneration(generationEntryPoint, entityCodeToSearch, entityTypeToSearch);
        if (re != null && ples != null) {
            ples.registerReference(re);
        }
        return re;
    }

    public static RadicalEntity SearchRadicalEntityDuringGeneration(RadicalEntity generationEntryPoint, String entityCodeToSearch, String entityTypeToSearch) {
        return PacbaseModelService.getInstance().searchRadicalEntity(generationEntryPoint.getProject(), generationEntryPoint.getPackage(), entityCodeToSearch, entityTypeToSearch);
    }

    public RadicalEntity searchRadicalEntity(String fromProject, String packageName, String entityCodeToSearch, String entityTypeToSearch) {
        Stack<String> packages = new Stack<String>();
        int i = 0;
        while (i < packageName.length()) {
            if (packageName.charAt(i) == '.') {
                packages.push(packageName.substring(0, i));
            }
            ++i;
        }
        packages.push(packageName);
        while (!packages.empty()) {
            String pkg = (String)packages.pop();
            RadicalEntity re = PTEditorService.resolveSharedResource((String)fromProject, (String)pkg, (String)entityCodeToSearch.trim(), (String)entityTypeToSearch);
            if (re == null) continue;
            return re;
        }
        return null;
    }

    public File createTmpFileForGeneration(String fileName, String extension, boolean deleteOnExit) {
        File temp = null;
        try {
            temp = File.createTempFile(fileName, extension, PacbaseModelService.GetTemporaryDirectory());
            if (deleteOnExit) {
                temp.deleteOnExit();
            }
        }
        catch (IOException ioex) {
            Util.rethrow((Throwable)ioex);
        }
        return temp;
    }

    public File createTmpFileForGeneration(String fileName, boolean deleteOnExit) {
        return this.createTmpFileForGeneration(fileName, null, deleteOnExit);
    }

    public static File GetTemporaryDirectory() {
        if (tmpDir == null) {
            tmpDir = new File(System.getProperty("java.io.tmpdir"));
        }
        return tmpDir;
    }

    public File getCommandFileForGeneration(String fileName) {
        if (this.allGenerators.containsKey(fileName)) {
            return this.allGenerators.get(fileName);
        }
        Path path = new Path(fileName);
        URL url32 = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)path, null);
        File file = null;
        try {
            url32 = FileLocator.resolve((URL)url32);
            file = new File(url32.getFile());
        }
        catch (IOException ioex) {
            Util.rethrow((Throwable)ioex);
        }
        if (file != null) {
            this.allGenerators.put(fileName, file);
        }
        return file;
    }

    public static PacDataElementInternalUsageValues GetUsage(DataElement dataElement) {
        Iterator extensions = dataElement.getDataDescription().getExtensions().iterator();
        PacDataElementDescription pded = null;
        while (extensions.hasNext() && pded == null) {
            DataDescriptionExtension dde = (DataDescriptionExtension)extensions.next();
            if (!(dde instanceof PacDataElementDescription)) continue;
            pded = (PacDataElementDescription)dde;
        }
        if (pded != null) {
            if (pded.getInternalUsage().equals(PacDataElementInternalUsageValues._INHERITED_LITERAL)) {
                DataElement parentDataElement = pded.getParent();
                if (parentDataElement != null) {
                    parentDataElement = (DataElement)PTModelService.resolveResource((String)dataElement.getProject(), (String)parentDataElement.getPackage(), (String)parentDataElement.getName(), (String)"dataelement");
                    extensions = parentDataElement.getDataDescription().getExtensions().iterator();
                    pded = null;
                    while (extensions.hasNext() && pded == null) {
                        DataDescriptionExtension dde = (DataDescriptionExtension)extensions.next();
                        if (!(dde instanceof PacDataElementDescription)) continue;
                        pded = (PacDataElementDescription)dde;
                    }
                    if (pded != null) {
                        return pded.getInternalUsage();
                    }
                }
            } else {
                return pded.getInternalUsage();
            }
        }
        return null;
    }

    public PacLibrary searchForGenerationParameter(DataAggregate dataAgg, String project) {
        String typeEntite = "dataunit";
        String nameOfDataUnit = dataAgg.getName().substring(0, 2);
        RadicalEntity obj = PacbaseModelService.getInstance().searchRadicalEntity(project, "", nameOfDataUnit, typeEntite);
        PacLibrary lib = null;
        for (RadicalEntityExtension ree : obj.getExtensions()) {
            if (!(ree instanceof PacRadicalEntity)) continue;
            lib = ((PacRadicalEntity)ree).getGenerationParameter();
        }
        return lib;
    }
}

