/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.generate.util;

import com.ibm.pdp.explorer.model.marker.PTMarkerManager;
import com.ibm.pdp.explorer.nature.PTNature;
import com.ibm.pdp.framework.pattern.PdpPatternGenStatesExceptions;
import com.ibm.pdp.mdl.kernel.KernelPackage;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacAbstractDialog;
import com.ibm.pdp.mdl.pacbase.PacAbstractDialogCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacAbstractDialogFolder;
import com.ibm.pdp.mdl.pacbase.PacAbstractDialogServer;
import com.ibm.pdp.mdl.pacbase.PacBlockBase;
import com.ibm.pdp.mdl.pacbase.PacCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacCopybook;
import com.ibm.pdp.mdl.pacbase.PacDialog;
import com.ibm.pdp.mdl.pacbase.PacDialogCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacDialogFolder;
import com.ibm.pdp.mdl.pacbase.PacDialogServer;
import com.ibm.pdp.mdl.pacbase.PacFolder;
import com.ibm.pdp.mdl.pacbase.PacMacro;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.mdl.pacbase.PacServer;
import com.ibm.pdp.mdl.pacbase.PacbasePackage;
import com.ibm.pdp.mdl.pacbase.util.PacGenerationValidityChecking;
import com.ibm.pdp.mdl.pacbase.util.PacbaseLabel;
import com.ibm.pdp.mdl.pacbase.util.RadicalEntityWrapper;
import com.ibm.pdp.pacbase.generate.util.InterruptedGeneratorException;
import com.ibm.pdp.pacbase.generate.util.PacbaseGeneratorLabels;
import com.ibm.pdp.util.Util;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class PacbaseLinksEntitiesService {
    public Map<String, States> linksResult = new HashMap<String, States>();
    public static final int GENERATION_OK = 0;
    public static final int GENERATION_FAILED_INTERRUPTED = 1;
    public static final int GENERATION_FAILED_OTHERS = 2;
    protected static final PacbasePackage modelPackagePB = PacbasePackage.eINSTANCE;
    protected static final KernelPackage modelPackageKernel = KernelPackage.eINSTANCE;
    public Map<String, States> linksMapResult = new HashMap<String, States>();
    private boolean referencesForMap = false;
    private String patternName = null;
    private static Map<String, String> genStateIds = null;
    private static Map<String, String> stateIds = null;
    private static Map<String, Integer> errorCodes = null;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2022.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public Map<String, States> getReferencesResult() {
        Iterator<String> it = this.linksResult.keySet().iterator();
        HashMap<String, States> links = new HashMap<String, States>();
        while (it.hasNext()) {
            String key = it.next();
            if (links.containsKey(key)) continue;
            links.put(key, this.linksResult.get(key));
        }
        return links;
    }

    public Map<String, States> getReferencesResultForMap() {
        Iterator<String> it = this.linksMapResult.keySet().iterator();
        HashMap<String, States> links = new HashMap<String, States>();
        while (it.hasNext()) {
            String key = it.next();
            if (links.containsKey(key)) continue;
            links.put(key, this.linksMapResult.get(key));
        }
        return links;
    }

    public void deleteReference(RadicalEntity obj) {
        String key;
        if (obj.getDesignURI() != null && this.linksResult.containsKey(key = PacbaseLinksEntitiesService.getKey(obj))) {
            this.linksResult.remove(key);
        }
    }

    public void checkValidityEntity(RadicalEntity obj) {
        String key;
        if (this.linksResult != null && (key = PacbaseLinksEntitiesService.getKey(obj)) != null && this.linksResult.get(key) != null) {
            return;
        }
        List paths = PTNature.getPaths((String)obj.getProject());
        int maxError = 0;
        maxError = paths.isEmpty() ? 2 : PacbaseLinksEntitiesService.getErrorCode(obj, paths);
        if (maxError > 1) {
            if (obj.eClass().eContainer() == modelPackagePB) {
                this.doSwitchPB(obj);
            } else if (obj.eClass().eContainer() == modelPackageKernel) {
                this.doSwitchKernel(obj);
            }
        }
    }

    protected void doSwitchKernel(RadicalEntity obj) {
        String entity = "";
        switch (obj.eClass().getClassifierID()) {
            case 36: {
                entity = PacbaseLabel._PAC_DATA_UNIT_TYPE;
                break;
            }
            case 44: {
                entity = PacbaseLabel._PAC_DATA_ELEMENT_TYPE;
                break;
            }
            case 45: {
                entity = PacbaseLabel._PAC_DATA_AGGREGATE_TYPE;
            }
        }
        String mess = NLS.bind((String)PacbaseGeneratorLabels.ERROR_MESS, (Object[])new Object[]{entity + " " + obj.getDesignId(obj.getProject())});
        InterruptedGeneratorException ie = new InterruptedGeneratorException(mess);
        Util.rethrow((Throwable)ie);
    }

    protected void doSwitchPB(RadicalEntity obj) {
        String entity = "";
        switch (obj.eClass().getClassifierID()) {
            case 31: {
                entity = PacbaseLabel._PAC_LIBRARY_TYPE;
                break;
            }
            case 48: {
                entity = PacbaseLabel._PAC_DATA_AGGREGATE_TYPE;
                break;
            }
            case 58: {
                entity = PacbaseLabel._PAC_DATA_UNIT_TYPE;
                break;
            }
            case 39: {
                entity = PacbaseLabel._PAC_PROGRAM_TYPE;
                break;
            }
            case 37: {
                entity = PacbaseLabel._PAC_MACRO_TYPE;
                break;
            }
            case 22: {
                entity = PacbaseLabel._PAC_REPORT_TYPE;
                break;
            }
            case 42: {
                entity = PacbaseLabel._PAC_BLOCK_BASE_TYPE;
                break;
            }
            case 72: {
                entity = PacbaseLabel._PAC_DIALOG_TYPE;
                break;
            }
            case 70: {
                entity = PacbaseLabel._PAC_SCREEN_TYPE;
                break;
            }
            case 99: {
                entity = PacbaseLabel._PAC_DIALOG_SERVER_TYPE;
                break;
            }
            case 101: {
                entity = PacbaseLabel._PAC_SERVER_TYPE;
                break;
            }
            case 83: {
                entity = PacbaseLabel._PAC_TEXT_TYPE;
                break;
            }
            case 56: {
                entity = PacbaseLabel._PAC_DATA_ELEMENT_TYPE;
            }
        }
        String mess = NLS.bind((String)PacbaseGeneratorLabels.ERROR_MESS, (Object[])new Object[]{entity + " " + obj.getDesignId(obj.getProject())});
        InterruptedGeneratorException ie = new InterruptedGeneratorException(mess);
        Util.rethrow((Throwable)ie);
    }

    public void checkValidityVariant(RadicalEntity re) {
        PacDialog dialog = null;
        switch (re.eClass().getClassifierID()) {
            case 39: {
                String message = PacGenerationValidityChecking.CheckProgramVariantValidity((PacProgram)((PacProgram)re));
                if (message.trim().length() <= 0) break;
                InterruptedGeneratorException ie = new InterruptedGeneratorException(PacbaseGeneratorLabels.NO_GENERATION_PROCESS + " " + message);
                Util.rethrow((Throwable)ie);
                break;
            }
            case 70: {
                dialog = ((PacScreen)re).getDialog();
            }
            case 72: {
                String message = PacGenerationValidityChecking.CheckScreenVariantValidity((PacAbstractDialog)((PacAbstractDialog)re), (PacDialog)dialog);
                if (message.trim().length() <= 0) break;
                InterruptedGeneratorException ie = new InterruptedGeneratorException(PacbaseGeneratorLabels.NO_GENERATION_PROCESS + " " + message);
                Util.rethrow((Throwable)ie);
                break;
            }
            case 101: {
                String message = PacGenerationValidityChecking.CheckServerVariantValidity((PacAbstractDialogServer)((PacAbstractDialogServer)re), (PacDialogServer)((PacServer)re).getDialog());
                if (message.trim().length() <= 0) break;
                InterruptedGeneratorException ie = new InterruptedGeneratorException(PacbaseGeneratorLabels.NO_GENERATION_PROCESS + " " + message);
                Util.rethrow((Throwable)ie);
                break;
            }
            case 120: {
                String message = PacGenerationValidityChecking.CheckFolderVariantValidity((PacAbstractDialogFolder)((PacAbstractDialogFolder)re), (PacDialogFolder)((PacFolder)re).getPacDialogFolder());
                if (message.trim().length() <= 0) break;
                InterruptedGeneratorException ie = new InterruptedGeneratorException(PacbaseGeneratorLabels.NO_GENERATION_PROCESS + " " + message);
                Util.rethrow((Throwable)ie);
                break;
            }
            case 127: {
                String message = "";
                if (((PacCommunicationMonitor)re).getPacDialogCommunicationMonitor() != null) {
                    message = PacGenerationValidityChecking.CheckCommunicationMonitorVariantValidityCom((PacAbstractDialogCommunicationMonitor)((PacAbstractDialogCommunicationMonitor)re), (PacDialogCommunicationMonitor)((PacCommunicationMonitor)re).getPacDialogCommunicationMonitor());
                }
                if (((PacCommunicationMonitor)re).getPacDialogServer() != null) {
                    message = PacGenerationValidityChecking.CheckCommunicationMonitorVariantValiditySrv((PacAbstractDialogCommunicationMonitor)((PacAbstractDialogCommunicationMonitor)re), (PacDialogServer)((PacCommunicationMonitor)re).getPacDialogServer());
                }
                if (message.trim().length() <= 0) break;
                InterruptedGeneratorException ie = new InterruptedGeneratorException(PacbaseGeneratorLabels.NO_GENERATION_PROCESS + " " + message);
                Util.rethrow((Throwable)ie);
                break;
            }
            case 115: {
                String message = PacGenerationValidityChecking.CheckProgramVariantValidity((PacCopybook)((PacCopybook)re));
                if (message.trim().length() <= 0) break;
                InterruptedGeneratorException ie = new InterruptedGeneratorException(PacbaseGeneratorLabels.NO_GENERATION_PROCESS + " " + message);
                Util.rethrow((Throwable)ie);
            }
        }
    }

    public void checkValidityType(RadicalEntity re) {
        switch (re.eClass().getClassifierID()) {
            case 39: {
                break;
            }
            case 70: {
                break;
            }
            case 72: {
                break;
            }
            case 101: {
                String message = PacGenerationValidityChecking.checkServerTypeValidity((PacAbstractDialogServer)((PacAbstractDialogServer)re), (PacDialogServer)((PacServer)re).getDialog());
                if (message.trim().length() <= 0) break;
                InterruptedGeneratorException ie = new InterruptedGeneratorException(PacbaseGeneratorLabels.NO_GENERATION_PROCESS + " " + message);
                Util.rethrow((Throwable)ie);
                break;
            }
            case 42: {
                String message = PacGenerationValidityChecking.checkBlockBaseTypeValidity((PacBlockBase)((PacBlockBase)re));
                if (message.trim().length() <= 0) break;
                InterruptedGeneratorException ie = new InterruptedGeneratorException(PacbaseGeneratorLabels.NO_GENERATION_PROCESS + " " + message);
                Util.rethrow((Throwable)ie);
            }
        }
    }

    public void registerReference(RadicalEntity obj) {
        RadicalEntity header;
        RadicalEntityWrapper rew;
        RadicalEntity parent;
        if (obj instanceof RadicalEntityWrapper && !(parent = (rew = (RadicalEntityWrapper)obj).getReferencedRadicalEntity()).equals(header = rew.getHeaderRadicalEntity())) {
            String key = PacbaseLinksEntitiesService.getKey(parent);
            this.checkValidityEntity(parent);
            this.linksResult.put(key, new States(PacbaseLinksEntitiesService.getStateId(key, parent), PacbaseLinksEntitiesService.getGenStateId(this.patternName, "1", key, parent)));
            if (this.isReferencesForMap()) {
                this.linksMapResult.put(key, new States(PacbaseLinksEntitiesService.getStateId(key, parent), PacbaseLinksEntitiesService.getGenStateId(this.patternName, "2", key, parent)));
            }
        }
        if (obj.getDesignURI() != null) {
            String key = PacbaseLinksEntitiesService.getKey(obj);
            this.checkValidityEntity(obj);
            this.linksResult.put(key, new States(PacbaseLinksEntitiesService.getStateId(key, obj), PacbaseLinksEntitiesService.getGenStateId(this.patternName, "1", key, obj)));
            if (this.isReferencesForMap()) {
                this.linksMapResult.put(key, new States(PacbaseLinksEntitiesService.getStateId(key, obj), PacbaseLinksEntitiesService.getGenStateId(this.patternName, "2", key, obj)));
            }
        }
    }

    public boolean isReferencesForMap() {
        return this.referencesForMap;
    }

    public void setReferencesForMap(boolean referencesForMap) {
        this.referencesForMap = referencesForMap;
    }

    private static String getKey(RadicalEntity radicalEntity) {
        if (radicalEntity != null) {
            return radicalEntity.getDesignId(radicalEntity.getProject());
        }
        return null;
    }

    private static String getGenStateId(String patternName, String rank, String key, RadicalEntity radicalEntity) {
        if (PacbaseLinksEntitiesService.isRPPModelStateIdCacheEnable()) {
            String _key;
            String genStateId;
            if (genStateIds == null) {
                genStateIds = new HashMap<String, String>();
            }
            if ((genStateId = genStateIds.get(_key = ((String)(key = (String)key + patternName + rank)).intern())) == null) {
                genStateId = PdpPatternGenStatesExceptions.getGenStateId((RadicalEntity)radicalEntity, (String)patternName, (boolean)true, null, (String)rank);
                genStateIds.put(_key, genStateId);
            }
            return genStateId;
        }
        return PdpPatternGenStatesExceptions.getGenStateId((RadicalEntity)radicalEntity, (String)patternName, (boolean)true, null, (String)rank);
    }

    private static String getStateId(String key, RadicalEntity radicalEntity) {
        if (PacbaseLinksEntitiesService.isRPPModelStateIdCacheEnable()) {
            String _key;
            String stateId;
            if (stateIds == null) {
                stateIds = new HashMap<String, String>();
            }
            if ((stateId = stateIds.get(_key = key.intern())) == null) {
                stateId = radicalEntity.getStateId();
                stateIds.put(_key, stateId);
            }
            return stateId;
        }
        return radicalEntity.getStateId();
    }

    private static int getErrorCode(RadicalEntity radicalEntity, List<String> paths) {
        if (PacbaseLinksEntitiesService.isRPPModelErrorCodeCacheEnable()) {
            String _key;
            Integer errorCode;
            if (errorCodes == null) {
                errorCodes = new HashMap<String, Integer>();
            }
            if ((errorCode = errorCodes.get(_key = PacbaseLinksEntitiesService.getKey(radicalEntity).intern())) == null) {
                errorCode = PTMarkerManager.checkMarkers((RadicalEntity)radicalEntity, (boolean)false, paths);
                if (errorCode < 1 && radicalEntity instanceof PacMacro) {
                    errorCode = radicalEntity.findMaxProblemSeverity("com.ibm.pdp.pdpeditor.macroeditor.problem_identification_marker", false, 0);
                }
                errorCodes.put(_key, errorCode);
            }
            return errorCode;
        }
        int maxError = PTMarkerManager.checkMarkers((RadicalEntity)radicalEntity, (boolean)false, paths);
        if (maxError < 1 && radicalEntity instanceof PacMacro) {
            maxError = radicalEntity.findMaxProblemSeverity("com.ibm.pdp.pdpeditor.macroeditor.problem_identification_marker", false, 0);
        }
        return maxError;
    }

    private static boolean isRPPModelErrorCodeCacheEnable() {
        return "true".equals(System.getProperty("rppModelErrorCodeCacheEnable"));
    }

    private static boolean isRPPModelStateIdCacheEnable() {
        return "true".equals(System.getProperty("rppModelStateIdCacheEnable"));
    }

    public PacbaseLinksEntitiesService(String patternName) {
        this.patternName = patternName;
    }

    public PacbaseLinksEntitiesService() {
    }

    public class States {
        private String _stateId;
        private String _genStateId;

        public States(String stateId, String genStateId) {
            this._stateId = stateId;
            this._genStateId = genStateId;
        }

        public String getStateId() {
            return this._stateId;
        }

        public String getGenStateId() {
            return this._genStateId;
        }
    }
}

