/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.generate.util;

import com.ibm.pdp.mdl.pacbase.PacDataElementDescription;
import com.ibm.pdp.mdl.pacbase.PacTimestampFractionValues;
import com.ibm.pdp.mdl.pacbase.PacTimezoneValues;
import com.ibm.pdp.mdl.pacbase.converter.PacPictureParser;
import com.ibm.pdp.mdl.pacbase.lal.util.converter.PacDateFormat;
import com.ibm.pdp.mdl.pacbase.lal.util.converter.PacNumericFormat;
import com.ibm.pdp.trace.PTTraceManager;
import java.util.Date;

public class ExtractUtil {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2019.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String INTERNAL_FORMAT = "I";
    public static final String INPUT_FORMAT = "E";
    public static final String OUTPUT_FORMAT = "S";
    public static final char VARIANT = 'X';
    public static final char DISPLAY_USAGE = 'D';

    public static int GetCobolLength(PacDataElementDescription kde, String formattype, char usage) {
        int len = 0;
        PacPictureParser pictureparser = null;
        if (formattype.equalsIgnoreCase(INTERNAL_FORMAT)) {
            pictureparser = kde != null && kde.getInternalFormat() != null && kde.getInternalFormat().equals("TS") && kde.getInternalTimestamp() != null ? new PacPictureParser(kde.getInternalFormat(), kde.getInternalTimestamp().getFraction(), kde.getInternalTimestamp().getTimezone()) : new PacPictureParser(kde.getInternalFormat());
            len = ExtractUtil.GetLength(pictureparser, usage, 'X');
        } else if (formattype.equalsIgnoreCase(INPUT_FORMAT)) {
            pictureparser = kde != null && kde.getInputFormat() != null && kde.getInputFormat().equals("TS") && kde.getInputTimestamp() != null ? new PacPictureParser(kde.getInputFormat(), kde.getInputTimestamp().getFraction(), kde.getInputTimestamp().getTimezone()) : new PacPictureParser(kde.getInputFormat());
            len = ExtractUtil.GetLength(pictureparser, 'D', 'X');
        } else if (kde.getOutputFormat().trim().length() > 0) {
            pictureparser = kde != null && kde.getOutputTimestamp() != null && kde.getOutputFormat().equals("TS") && kde.getOutputTimestamp() != null ? new PacPictureParser(kde.getOutputFormat(), kde.getOutputTimestamp().getFraction(), kde.getOutputTimestamp().getTimezone()) : new PacPictureParser(kde.getOutputFormat());
            len = ExtractUtil.GetLength(pictureparser, 'D', 'X');
        } else {
            PTTraceManager traceManager = PTTraceManager.getInstance();
            int engineTraceLevel = traceManager.getTraceLevel("com.ibm.pdp.pac");
            if (engineTraceLevel > 0) {
                String message = "AUCUN FORMAT" + kde.getOwner().getName() + " " + String.valueOf(new Date());
                traceManager.trace(ExtractUtil.class, "com.ibm.pdp.pac", 1, message);
            }
        }
        return len;
    }

    public static int GetLength(PacPictureParser pictureparser, char usg, char varia) {
        String usageStri = new String(new StringBuffer().append(usg));
        if (usageStri.equals("F") || usageStri.equals("W") || usageStri.equals("Y") || usageStri.equals("J") || usageStri.equals("U") || usageStri.equals("0") || usageStri.equals("5") || usageStri.equals("6")) {
            PacNumericFormat nf = new PacNumericFormat(pictureparser.getCapacity(), pictureparser.getDecimals(), pictureparser.hasSign(), usg, varia);
            return nf.getTotalLength();
        }
        if (pictureparser.isNumeric()) {
            PacNumericFormat nf = new PacNumericFormat(pictureparser.getCapacity(), pictureparser.getDecimals(), pictureparser.hasSign(), usg, varia);
            return nf.getTotalLength();
        }
        if (pictureparser.isDate()) {
            PacDateFormat df = null;
            df = pictureparser.getDateFormat() == 'X' ? new PacDateFormat(pictureparser.getDateFormat(), pictureparser.getDateSeparator(), varia, pictureparser.getNbSec(), pictureparser.getTimezone()) : new PacDateFormat(pictureparser.getDateFormat(), pictureparser.getDateSeparator(), varia);
            return df.getTotalLength();
        }
        if (pictureparser.isAlphanumeric()) {
            return pictureparser.getCapacity();
        }
        if (pictureparser.isAlphabetic()) {
            return pictureparser.getCapacity();
        }
        return 0;
    }

    public static String GetCobolPicture(PacDataElementDescription kde, String formattype, char usage) {
        int len = 0;
        PacPictureParser pictureparser = null;
        String realFormat = "";
        PacTimestampFractionValues nbSec = PacTimestampFractionValues._6_LITERAL;
        PacTimezoneValues timezone = PacTimezoneValues._FALSE_LITERAL;
        if (formattype.equalsIgnoreCase(INTERNAL_FORMAT)) {
            realFormat = kde.getInternalFormat();
            if (kde.getInternalTimestamp() != null) {
                nbSec = kde.getInternalTimestamp().getFraction();
                timezone = kde.getInternalTimestamp().getTimezone();
            }
        } else if (formattype.equalsIgnoreCase(INPUT_FORMAT)) {
            realFormat = kde.getInputFormat();
            if (kde.getInputTimestamp() != null) {
                nbSec = kde.getInputTimestamp().getFraction();
                timezone = kde.getInputTimestamp().getTimezone();
            }
        } else {
            realFormat = kde.getOutputFormat();
            if (kde.getOutputTimestamp() != null) {
                nbSec = kde.getOutputTimestamp().getFraction();
                timezone = kde.getOutputTimestamp().getTimezone();
            }
        }
        if ((pictureparser = !realFormat.trim().equals("TS") ? new PacPictureParser(realFormat) : new PacPictureParser(realFormat, nbSec, timezone)).isDate()) {
            usage = (char)68;
            len = ExtractUtil.GetLength(pictureparser, usage, 'X');
            return "X(" + len + ")";
        }
        return realFormat;
    }
}

