/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.generate.util;

import com.ibm.pdp.util.PdpConstants;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;

public class Commands {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2011, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String JUNIT_PROPERTY_DIALOG_W1 = "DialogGeneration.w1.junit.process";
    public static final String JUNIT_PROPERTY_DIALOG_SERVER_W1 = "DialogServerGeneration.w1.junit.process";
    public static final String JUNIT_PROPERTY_COMMUNICATION_MONITOR_W1 = "CommunicationMonitorGeneration.w1.junit.process";
    public static final String JUNIT_PROPERTY_FOLDER_W1 = "FolderGeneration.w1.junit.process";
    public static final String JUNIT_PROPERTY_PROGRAM_W1 = "ProgramGeneration.W1.junit.process";
    public static final String JUNIT_PROPERTY_PROGRAM_W2 = "ProgramGeneration.W2.junit.process";
    public static final String JUNIT_PROPERTY_EXTRACTION = "Extraction.junit.process";
    public static final String JUNIT_PROPERTY_IMPORT = "Import.junit.process";
    public static final String JUNIT_PROPERTY_DBD_SQL = "DbdSQL.junit.process";
    public static final String JUNIT_PROPERTY_WFMICROPATTERN = "WFMicroPattern.junit.process";
    public static final String JUNIT_PROPERTY_SQLMICROPATTERN = "SQLMicroPattern.junit.process";
    public static final String JUNIT_PROPERTY_COPYBOOK_W1 = "CopyBookGeneration.W1.junit.process";
    public static final String JUNIT_PROPERTY_COPYBOOK_W2 = "CopyBookGeneration.W2.junit.process";
    public static final String JUNIT_PROPERTY_COPYBOOK_CPY = "CopyBookGeneration.CPY.junit.process";
    public static final String JUNIT_PROPERTY_LABELERROR_W1 = "labelErrorGeneration.W1.junit.process";
    public static final String JUNIT_PROPERTY_LABELERROR_TXT = "labelErrorGeneration.TXT.junit.process";
    public static final String JUNIT_PROPERTY_PACTABLE_W1 = "pactableGeneration.W1.junit.process";
    public static final String JUNIT_TEST_IN_PROGRESS = "JUNIT_TEST_IN_PROGRESS";
    public static final String IMPORT_TA2 = "ta2";
    public static final String IMPORT_XMI = "xmi";
    public static final String ZIP = "zip";
    public static final String CBLGEN = "cblgen";
    public static final String _cpyFILE_EXTENSION = ".cpy";
    public static final String _txtFILE_EXTENSION = ".txt";
    public static final String PACSCREEN_GENERATION_TYPE = "pacscreen";
    public static final String PACPROGRAM_GENERATION_TYPE = "pacprogram";
    public static final String PACSERVER_GENERATION_TYPE = "pacserver";
    public static final String PACDIALOG_GENERATION_TYPE = "pacdialog";
    public static final String DATAUNIT_GENERATION_TYPE = "dataunit";
    public static final String PACBLOCBASE_GENERATION_TYPE = "pacblockbase";
    public static final String PACERRORLABEL_GENERATION_TYPE = "pacerrorlabel";
    public static final String PACCOPYBOOK_GENERATION_TYPE = "paccopybook";
    public static final String PACTABLE_GENERATION_TYPE = "dataaggregate";
    public static final String EN_LANGUAGE = "EN";
    public static final String FR_LANGUAGE = "FR";
    public static final String C1_OPTION = "C1";
    public static final String C2_OPTION = "C2";
    public static final String C3_OPTION = "C3";
    public static final String C4_OPTION = "C4";

    public static String getGenerateCommand(String workspace, String logFileName, String projectName, String packageName, String entityName, String generationType, String generationPattern, String destProject, String destFolder) {
        Object wks = "";
        wks = workspace.length() > 0 ? " --data " + workspace : " --data " + Commands.getWorkpaceFolder() + " ";
        Object log = "";
        if (logFileName.length() > 0) {
            log = " --log " + logFileName;
        }
        Object destP = "";
        if (destProject.length() > 0) {
            destP = " --destProject " + destProject;
        }
        Object destF = "";
        if (destFolder.length() > 0) {
            destF = " --destFolder " + destFolder;
        }
        Object pattern = "";
        if (generationPattern.length() > 0) {
            pattern = " --pattern " + generationPattern;
        }
        return "--generate " + (String)wks + (String)log + " --project " + projectName + (String)(packageName.isEmpty() ? "" : " --package " + packageName) + " --name " + entityName + " --type " + generationType + (String)pattern + (String)destP + (String)destF;
    }

    public static String getGenerateCommand(String projectName, String packageName, String entityName, String generationType) {
        return Commands.getGenerateCommand("", "logFileName", projectName, packageName, entityName, generationType, "", "", "");
    }

    public static String getGenerateCommand(String projectName, String packageName, String entityName, String generationType, String generationPattern) {
        return Commands.getGenerateCommand("", "logFileName", projectName, packageName, entityName, generationType, generationPattern, "", "");
    }

    public static String getImportCommand(String workspace, String logFileName, String filename, String location, String importType, boolean overwrite, String generatedFileForJournal) {
        Object wks = "";
        wks = workspace.length() > 0 ? " --data " + workspace : " --data " + Commands.getWorkpaceFolder() + " ";
        Object log = "";
        if (logFileName.length() > 0) {
            log = " --log " + logFileName;
        }
        Object genFileForJournal = "";
        if (generatedFileForJournal != null && generatedFileForJournal.length() > 0) {
            genFileForJournal = " --generatedDataFile " + generatedFileForJournal;
        }
        return "--import " + (String)wks + (String)log + " --fromFile " + filename + " --location " + location + " --importType " + importType + (overwrite ? " --overwrite " : "") + (String)genFileForJournal;
    }

    public static String getImportCommand(String workspace, String logFileName, String filename, String location, String importType, boolean overwrite) {
        return Commands.getImportCommand(workspace, logFileName, filename, location, importType, overwrite, null);
    }

    public static String getImportCommand(String filename, String location, String importType, boolean overwrite) {
        return Commands.getImportCommand("", "logFileName", filename, location, importType, overwrite);
    }

    public static String getImportJournalCommand(String workspace, String logFileName, String filename, String dataFileName, String location, String generatedFileForJournal) {
        Object wks = "";
        wks = workspace.length() > 0 ? " --data " + workspace : " --data " + Commands.getWorkpaceFolder() + " ";
        Object log = "";
        if (logFileName.length() > 0) {
            log = " --log " + logFileName;
        }
        Object genFileForJournal = "";
        if (generatedFileForJournal != null && generatedFileForJournal.length() > 0) {
            genFileForJournal = " --generatedDataFile " + generatedFileForJournal;
        }
        return "--importJournal " + (String)wks + (String)log + " --fromFile " + filename + " --fromDataFile " + dataFileName + " --location " + location + (String)genFileForJournal;
    }

    public static String getDispatchMacroCommand(String workspace, String logFileName, String filename, String location, String reportFileName) {
        Object wks = "";
        wks = workspace.length() > 0 ? " --data " + workspace : " --data " + Commands.getWorkpaceFolder() + " ";
        Object log = "";
        if (logFileName.length() > 0) {
            log = " --log " + logFileName;
        }
        String report = null;
        if (reportFileName != null && reportFileName.length() > 0) {
            report = " --report " + reportFileName;
            return "--dispatchMacro " + (String)wks + (String)log + " --fromFile " + filename + " --location " + location + report;
        }
        return "--dispatchMacro " + (String)wks + (String)log + " --fromFile " + filename + " --location " + location;
    }

    public static String getDispatchMacroCommand(String filename, String location, String reportFileName) {
        return Commands.getDispatchMacroCommand("", "logFileName", filename, location, reportFileName);
    }

    public static String getMigrationHelpCommand(String workspace, String logFileName, String projectName, String packageName, String entityName, String generationType, String cobolFileName, String cobolControlFileName, String constantsAndDate, String reportFileName, boolean append) {
        Object wks = "";
        wks = workspace.length() > 0 ? " --data " + workspace : " --data " + Commands.getWorkpaceFolder() + " ";
        Object log = "";
        if (logFileName.length() > 0) {
            log = " --log " + logFileName;
        }
        return "--generate " + (String)wks + (String)log + " --project " + projectName + " --package " + packageName + " --name " + entityName + " --type " + generationType + " --cobolFile " + cobolFileName + " --controlCobolFile " + cobolControlFileName + " --constantsAndDate " + constantsAndDate + " --report " + reportFileName + (append ? " --append " : "");
    }

    public static String getGenerateDataBlockBaseCommand(String workspace, String logFileName, String projectName, String packageName, String entityName, String destinationFileName, String destinationProjectName, String destinationPackageName) {
        Object wks = "";
        wks = workspace.length() > 0 ? " --data " + workspace : " --data " + Commands.getWorkpaceFolder() + " ";
        Object log = "";
        if (logFileName.length() > 0) {
            log = " --log " + logFileName;
        }
        Object destProj = "";
        if (destinationProjectName.length() > 0) {
            destProj = " --destProject " + destinationProjectName;
        }
        Object destPack = "";
        if (destinationPackageName.length() > 0) {
            destPack = " --destPackage " + destinationPackageName;
        }
        Object destFile = "";
        if (destinationFileName.length() > 0) {
            destFile = " --destination " + destinationFileName;
        }
        return "--generate " + (String)wks + (String)log + " --project " + projectName + (String)(packageName.isEmpty() ? "" : " --package " + packageName) + " --name " + entityName + (String)destFile + (String)destProj + (String)destPack;
    }

    public static String getGenerateDataBlockBaseCommand(String projectName, String packageName, String entityName, String destinationFileName, String destinationProjectName, String destinationPackageName) {
        return Commands.getGenerateDataBlockBaseCommand("", "logFileName", projectName, packageName, entityName, destinationFileName, destinationProjectName, destinationPackageName);
    }

    public static String getZCompCreationCommand(String workspace, String logFileName, String projectName, String folderName) {
        Object wks = "";
        wks = workspace.length() > 0 ? " --data " + workspace : " --data " + Commands.getWorkpaceFolder() + " ";
        Object log = "";
        if (logFileName.length() > 0) {
            log = " --log " + logFileName;
        }
        return "--zCompCreation " + (String)wks + (String)log + " --zProject " + projectName + " --zFolder " + folderName;
    }

    public static String getCopyCommand(String workspace, String logFileName, String source, String destProject, String destFolder, String destination, boolean depth, boolean overwrite) {
        Object wks = "";
        wks = workspace.length() > 0 ? " --data " + workspace : " --data " + Commands.getWorkpaceFolder() + " ";
        Object log = "";
        if (logFileName.length() > 0) {
            log = " --log " + logFileName;
        }
        return "--copy " + (String)wks + (String)log + " --source " + source + " --destProject " + destProject + " --destFolder " + destFolder + " --destination " + destination + (depth ? " --depth " : "") + (overwrite ? " --overwrite " : "");
    }

    private static String getWorkpaceFolder() {
        Location instanceLoc = Platform.getInstanceLocation();
        if (instanceLoc.getURL() == null) {
            return null;
        }
        if (!PdpConstants.IS_UNIX_OS) {
            return instanceLoc.getURL().getPath().substring(1);
        }
        return instanceLoc.getURL().getPath();
    }
}

