/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.generate;

import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.pacbase.generate.util.IPacbaseGeneration;
import com.ibm.pdp.pacbase.generate.util.NodeInformations;
import com.ibm.pdp.pacbase.generate.util.PacbaseModelService;
import com.ibm.pdp.pacbase.generate.util.PacbaseProcessBuilder;
import com.ibm.pdp.pacbase.util.GenerationProblem;
import com.ibm.pdp.trace.PTTraceManager;
import com.ibm.pdp.util.PdpConstants;
import com.ibm.pdp.util.Util;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class DefaultPacbaseGenerationImplementation
implements IPacbaseGeneration {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016, 2024.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String GeneratorDirectory = "/data/generator";
    public static final String PATTERN_PROP = "pattern";
    public static boolean isUnix = PdpConstants.IS_UNIX_OS;
    protected String secondGeneratedFileName;
    protected String cblgenFileName = "";
    protected String virtualMacroSource = null;
    protected String macroSP_name = null;
    protected String patternName;
    protected IGeneratedInfo generatedInfo;
    protected List<GenerationProblem> genericProblems = new ArrayList<GenerationProblem>();
    protected List<NodeInformations> ntiList = new ArrayList<NodeInformations>();

    public static String ReadFileContents(String fileName) throws Exception {
        String content = "";
        File file = new File(fileName);
        FileInputStream is = new FileInputStream(file);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[100000];
        int read = -1;
        while ((read = ((InputStream)is).read(buffer)) != -1) {
            baos.write(buffer, 0, read);
        }
        content = baos.toString();
        ((InputStream)is).close();
        baos.flush();
        baos.close();
        if (isUnix && content.indexOf("\r\n") < 0) {
            return content.replace("\n", "\r\n");
        }
        return content;
    }

    @Override
    public String getSecondGeneratedFileName() {
        return this.secondGeneratedFileName;
    }

    @Override
    public IGeneratedInfo getGeneratedInfo() {
        return this.generatedInfo;
    }

    @Override
    public boolean getOptionForGeneratedMap() {
        return false;
    }

    @Override
    public List<GenerationProblem> getGenericProblems() {
        return this.genericProblems;
    }

    @Override
    public List<NodeInformations> getNodeTagsInformations() {
        return this.ntiList;
    }

    protected void writeClbgenAfterMacroCalls(String result) {
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter(new FileOutputStream(this.cblgenFileName));
            osw.write(result);
            osw.close();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace(System.err);
        }
        catch (IOException ioex) {
            ioex.printStackTrace(System.err);
        }
    }

    protected abstract String[] getCommandLineForgenerator();

    protected void vapCobolGeneration() {
        try {
            String[] command = this.getCommandLineForgenerator();
            PacbaseProcessBuilder pb = PacbaseModelService.getInstance().instanciateProcess(command);
            PTTraceManager traceManager = PTTraceManager.getInstance();
            int engineTraceLevel = traceManager.getTraceLevel("com.ibm.pdp.pac");
            if (engineTraceLevel > 0) {
                pb.start();
                Thread out = new Thread(new Threader(pb.getInputStream(), "output stream "));
                Thread err = new Thread(new Threader(pb.getErrorStream(), "error stream "));
                out.start();
                err.start();
            } else {
                pb.getProcessBuilder().redirectErrorStream(true);
                File errorFile = File.createTempFile("error", ".log");
                errorFile.deleteOnExit();
                pb.getProcessBuilder().redirectError(errorFile);
                File outputFile = File.createTempFile("output", ".log");
                outputFile.deleteOnExit();
                pb.getProcessBuilder().redirectOutput(outputFile);
                pb.start();
            }
            pb.waitFor();
        }
        catch (Exception exception) {
            Util.rethrow((Throwable)exception);
        }
    }

    public static class Threader
    implements Runnable {
        BufferedReader br;
        String ss;

        public Threader(InputStream is, String s) {
            this.ss = s;
            this.br = new BufferedReader(new InputStreamReader(is));
        }

        @Override
        public void run() {
            try {
                String line;
                while ((line = this.br.readLine()) != null) {
                    PTTraceManager traceManager = PTTraceManager.getInstance();
                    int engineTraceLevel = traceManager.getTraceLevel("com.ibm.pdp.pac");
                    if (engineTraceLevel <= 0) continue;
                    String message = " " + String.valueOf(new Date()) + this.ss + "\t" + line;
                    traceManager.trace((Object)"Generator", "com.ibm.pdp.pac", 1, message);
                }
            }
            catch (Exception e) {
                Util.rethrow((Throwable)e);
            }
        }
    }
}

