/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.generate.folderView.generate;

import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacAbstractNode;
import com.ibm.pdp.mdl.pacbase.PacChildNode;
import com.ibm.pdp.mdl.pacbase.PacDialogFolderView;
import com.ibm.pdp.mdl.pacbase.PacFolder;
import com.ibm.pdp.mdl.pacbase.PacFolderView;
import com.ibm.pdp.mdl.pacbase.PacGenerationHeader;
import com.ibm.pdp.mdl.pacbase.PacLibrary;
import com.ibm.pdp.mdl.pacbase.PacLibrarySubstitutionGenerationHeader;
import com.ibm.pdp.mdl.pacbase.PacRootNode;
import com.ibm.pdp.pacbase.generate.folder.generate.EY00PacbaseAndKernelFolderVisitor;
import com.ibm.pdp.pacbase.generate.folderView.generate.EY00PacbaseAndKernelFolderViewVisitor;
import com.ibm.pdp.pacbase.generate.util.PacbaseLinksEntitiesService;
import com.ibm.pdp.pacbase.generate.util.PacbaseModelService;
import com.ibm.pdp.pacbase.util.EBCDICCompare;
import com.ibm.pdp.pacbase.util.extraction.dialog.model.PacbaseSegment;
import com.ibm.pdp.util.Util;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class PacToW1ModelFolderView {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private PacFolderView generationFolderView;
    private PacFolderView referencedFolderView;
    private PacFolder generationFolderProxy;
    private PacFolder referencedFolderProxy;
    private RadicalEntity generationEntity;
    private String priorHierarchicalNodeCode = "";
    private PacLibrary library;
    private boolean isFolderView = false;
    private File w1ResultFile;
    private EY00PacbaseAndKernelFolderViewVisitor w1pkvisitor;
    private EY00PacbaseAndKernelFolderVisitor w1pkvisitorFP;
    final Map<String, String> listNodeForFolder = new HashMap<String, String>();
    Map<String, PacAbstractNode> allFolderNodesMap = new HashMap<String, PacAbstractNode>();
    private PacbaseLinksEntitiesService ples;
    private String patternName;
    final Comparator<PacbaseSegment> ebcdicCmp = new Comparator<PacbaseSegment>(){

        @Override
        public int compare(PacbaseSegment object1, PacbaseSegment object2) {
            return EBCDICCompare.stringCompare((String)object1.toString().substring(0, 36), (String)object2.toString().substring(0, 36));
        }
    };

    public PacToW1ModelFolderView(RadicalEntity re, String patternName) {
        this.generationEntity = re;
        this.patternName = patternName;
        this.initReferencedProgram();
        this.transformToW1Model();
    }

    private void transformToW1Model() {
        this.scanPacbaseModel();
        this.writeTempFile();
    }

    private void scanPacbaseModel() {
        block6: {
            block5: {
                if (!(this.generationEntity instanceof PacFolderView)) break block5;
                this.w1pkvisitor = new EY00PacbaseAndKernelFolderViewVisitor(this.getPacLinksEntitiesService(), this.generationEntity);
                this.w1pkvisitor.doSwitch((EObject)this.library);
                this.w1pkvisitor.doSwitch((EObject)this.generationEntity);
                this.setListNodeForFolder();
                for (String selectedNodeForFolderView : this.generationFolderView.getComposition()) {
                    PacAbstractNode node = this.allFolderNodesMap.get(selectedNodeForFolderView);
                    if (!(node instanceof PacRootNode)) continue;
                    this.w1pkvisitor.doSwitch((EObject)((PacRootNode)node));
                }
                for (String selectedNodeForFolderView : this.generationFolderView.getComposition()) {
                    PacAbstractNode node = this.allFolderNodesMap.get(selectedNodeForFolderView);
                    if (!(node instanceof PacChildNode)) continue;
                    PacChildNode nodeC = (PacChildNode)node;
                    this.priorHierarchicalNodeCode = nodeC.getNodeCode();
                    this.w1pkvisitor.setPriorHierarchicalNodeCode(this.priorHierarchicalNodeCode);
                    this.w1pkvisitor.doSwitch((EObject)nodeC);
                    for (PacChildNode nodeCProxy_Level2 : nodeC.getChildNodes()) {
                        EList ls = this.generationFolderView.getComposition();
                        if (!ls.contains((Object)nodeCProxy_Level2.getNodeCode())) continue;
                        this.priorHierarchicalNodeCode = nodeC.getNodeCode();
                        this.w1pkvisitor.setPriorHierarchicalNodeCode(this.priorHierarchicalNodeCode);
                        this.w1pkvisitor.doSwitch((EObject)nodeCProxy_Level2);
                    }
                }
                break block6;
            }
            if (!(this.generationEntity instanceof PacFolder)) break block6;
            this.w1pkvisitorFP = new EY00PacbaseAndKernelFolderVisitor(this.getPacLinksEntitiesService(), this.generationEntity, true);
            this.w1pkvisitorFP.doSwitch((EObject)this.library);
            this.w1pkvisitorFP.doSwitch((EObject)this.generationEntity);
            PacRootNode nodeRProxy = this.generationFolderProxy.getPacRootNode();
            this.w1pkvisitorFP.doSwitch((EObject)nodeRProxy);
            Iterator allChildNodeProxy = nodeRProxy.getChildNodes().iterator();
            while (allChildNodeProxy.hasNext()) {
                this.priorHierarchicalNodeCode = nodeRProxy.getNodeCode();
                this.w1pkvisitorFP.setPriorHierarchicalNodeCode(this.priorHierarchicalNodeCode);
                PacChildNode nodeCProxy = (PacChildNode)allChildNodeProxy.next();
                this.w1pkvisitorFP.doSwitch((EObject)nodeCProxy);
                Iterator allChildNodeProxy_Level2 = nodeCProxy.getChildNodes().iterator();
                while (allChildNodeProxy_Level2.hasNext()) {
                    this.priorHierarchicalNodeCode = nodeCProxy.getNodeCode();
                    this.w1pkvisitorFP.setPriorHierarchicalNodeCode(this.priorHierarchicalNodeCode);
                    PacChildNode nodeCProxy_Level2 = (PacChildNode)allChildNodeProxy_Level2.next();
                    this.w1pkvisitorFP.doSwitch((EObject)nodeCProxy_Level2);
                }
            }
        }
    }

    public PacbaseLinksEntitiesService getPacLinksEntitiesService() {
        if (this.ples == null) {
            this.ples = new PacbaseLinksEntitiesService(this.patternName);
        }
        return this.ples;
    }

    protected void setListNodeForFolder() {
        PacFolder folder = null;
        if (this.generationFolderView.getFolder() != null) {
            folder = this.generationFolderView.getFolder();
        } else {
            PacDialogFolderView pdfv = this.generationFolderView.getPacDialogFolderView();
            folder = pdfv.getFolder();
        }
        PacRootNode node = folder.getPacRootNode();
        this.allFolderNodesMap.put(node.getNodeCode(), (PacAbstractNode)node);
        for (PacAbstractNode child : node.getChildNodes()) {
            this.allFolderNodesMap.put(child.getNodeCode(), child);
        }
    }

    protected File getW1ResultFile() {
        return this.w1ResultFile;
    }

    private void writeTempFile() {
        List<PacbaseSegment> l = null;
        if (this.isFolderView) {
            this.w1ResultFile = PacbaseModelService.getInstance().createTmpFileForGeneration("folderWiewW1", true);
            l = this.w1pkvisitor.getEntityLines();
        } else {
            this.w1ResultFile = PacbaseModelService.getInstance().createTmpFileForGeneration("folderProxyW1", true);
            l = this.w1pkvisitorFP.getEntityLines();
        }
        if (System.getProperty("FolderGeneration.w1.junit.process") != null) {
            System.setProperty("FolderGeneration.w1.junit.process", this.w1ResultFile.getAbsolutePath());
        }
        try {
            FileWriter fileOutStream1 = new FileWriter(this.w1ResultFile);
            PrintWriter w1OutStream = new PrintWriter(fileOutStream1);
            Collections.sort(l, this.ebcdicCmp);
            for (PacbaseSegment lineX : l) {
                String lineS = lineX.getCompleteContentForSegment().trim();
                w1OutStream.write(String.valueOf(lineS) + System.getProperty("line.separator"));
            }
            w1OutStream.close();
        }
        catch (Exception e) {
            Util.rethrow((Throwable)e);
        }
    }

    private void initReferencedProgram() {
        if (this.generationEntity instanceof PacFolderView) {
            this.generationFolderView = (PacFolderView)this.generationEntity;
            this.isFolderView = true;
            PacGenerationHeader generationHeader = this.generationFolderView.getGenerationHeader();
            if (generationHeader != null) {
                if (generationHeader instanceof PacLibrarySubstitutionGenerationHeader) {
                    PacLibrarySubstitutionGenerationHeader libSubstHeader = (PacLibrarySubstitutionGenerationHeader)generationHeader;
                    this.referencedFolderView = (PacFolderView)libSubstHeader.getGeneratedRadicalEntity();
                    this.library = libSubstHeader.getGenerationParameter();
                }
            } else {
                this.referencedFolderView = this.generationFolderView;
                this.library = this.referencedFolderView.getGenerationParameter();
            }
        } else if (this.generationEntity instanceof PacFolder) {
            this.generationFolderProxy = (PacFolder)this.generationEntity;
            PacGenerationHeader generationHeader = this.generationFolderProxy.getGenerationHeader();
            if (generationHeader != null) {
                if (generationHeader instanceof PacLibrarySubstitutionGenerationHeader) {
                    PacLibrarySubstitutionGenerationHeader libSubstHeader = (PacLibrarySubstitutionGenerationHeader)generationHeader;
                    this.referencedFolderProxy = (PacFolder)libSubstHeader.getGeneratedRadicalEntity();
                    this.library = libSubstHeader.getGenerationParameter();
                }
            } else {
                this.referencedFolderProxy = this.generationFolderProxy;
                this.library = this.referencedFolderProxy.getGenerationParameter();
            }
        }
    }
}

