/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.generate.folderView.generate;

import com.ibm.pdp.engine.IEngineFactory;
import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedInfoFactory;
import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.framework.util.PdpUtil;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacFolder;
import com.ibm.pdp.mdl.pacbase.PacFolderView;
import com.ibm.pdp.mdl.pacbase.util.PacFolderViewWrapper;
import com.ibm.pdp.mdl.pacbase.util.PacFolderWrapper;
import com.ibm.pdp.pacbase.generate.DefaultPacbaseGenerationImplementation;
import com.ibm.pdp.pacbase.generate.folderView.generate.PacToW1ModelFolderView;
import com.ibm.pdp.pacbase.generate.util.PacbaseLinksEntitiesService;
import com.ibm.pdp.pacbase.generate.util.PacbaseModelService;
import com.ibm.pdp.util.Util;
import java.io.File;

public class FolderViewGeneration
extends DefaultPacbaseGenerationImplementation {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected RadicalEntity _re;
    protected PacFolderView _pacFolderView;
    protected PacFolder _pacFolder;
    protected boolean _canHaveUserCode;
    public boolean isFolder = false;
    public PacToW1ModelFolderView w1Model = null;
    protected String cblFileName;
    private static String w3CmdFile = isUnix ? "/../../script_linux/GVC35.sh" : "/GVC35.cmd";

    public FolderViewGeneration(RadicalEntity reW, String patternName, boolean canHaveUserCode, String macroSource) {
        this._re = reW;
        this.patternName = patternName;
        if (reW instanceof PacFolder) {
            this._pacFolder = new PacFolderWrapper((PacFolder)reW);
            this.isFolder = true;
        } else if (reW instanceof PacFolderView) {
            this._pacFolderView = new PacFolderViewWrapper((PacFolderView)reW);
        }
        this._canHaveUserCode = canHaveUserCode;
        this.virtualMacroSource = macroSource;
        int resolMode = PTEditorService.getResolvingMode();
        PTEditorService.setResolvingMode((int)3);
        this.init();
        PTEditorService.setResolvingMode((int)resolMode);
    }

    public PacbaseLinksEntitiesService getReferencedEntities() {
        return this.w1Model.getPacLinksEntitiesService();
    }

    private void transformToGeneratedInfo() {
        String generated = "";
        try {
            generated = FolderViewGeneration.ReadFileContents((String)this.cblFileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            Util.rethrow((Throwable)e);
        }
        IEngineFactory engineFactory = PdpUtil.newEngineFactory();
        IGeneratedInfoFactory genInfoFactory = engineFactory.newGeneratedInfoFactory();
        if (this.isFolder) {
            genInfoFactory.beginTag(this._pacFolder.getName());
        } else {
            genInfoFactory.beginTag(this._pacFolderView.getName());
        }
        genInfoFactory.appendText((CharSequence)generated);
        genInfoFactory.endTag();
        this.generatedInfo = genInfoFactory.createGeneratedInfo();
        this.finalizeGeneratedInfo(this.generatedInfo);
    }

    protected void finalizeGeneratedInfo(IGeneratedInfo generatedInfo) {
        generatedInfo.setProperty("pattern", "com.ibm.pdp.pacbase.folderview.proxy");
        if (!this._canHaveUserCode) {
            generatedInfo.setProperty("Reconcile", "false");
        }
    }

    private void init() {
        this.findAndGetW1File();
        this.vapCobolGeneration();
        this.transformToGeneratedInfo();
    }

    private void findAndGetW1File() {
        if (this._re instanceof PacFolder) {
            this.w1Model = new PacToW1ModelFolderView((RadicalEntity)this._pacFolder, this.patternName);
        } else if (this._re instanceof PacFolderView) {
            this.w1Model = new PacToW1ModelFolderView((RadicalEntity)this._pacFolderView, this.patternName);
        }
    }

    protected String[] getCommandLineForgenerator() {
        String squelLang;
        String[] cmd = new String[]{"", "", "", "", "", "", "", ""};
        String userdir1 = PacbaseModelService.getInstance().getCommandFileForGeneration("/data/generator").getAbsolutePath();
        cmd[0] = String.valueOf(userdir1) + File.separator + w3CmdFile;
        cmd[1] = userdir1;
        cmd[2] = Util.GetRandomString((int)6);
        String tempdir = System.getProperty("java.io.tmpdir");
        int end = tempdir.length();
        cmd[3] = isUnix ? tempdir : tempdir.substring(0, --end);
        this.cblFileName = this.isFolder ? PacbaseModelService.getInstance().createTmpFileForGeneration("folderProxy", ".txt", true).getAbsolutePath() : PacbaseModelService.getInstance().createTmpFileForGeneration("folderView", ".txt", true).getAbsolutePath();
        cmd[4] = this.cblFileName;
        cmd[5] = this.w1Model.getW1ResultFile().getAbsolutePath();
        cmd[6] = squelLang = "FR";
        cmd[7] = userdir1.substring(0, 2);
        return cmd;
    }
}

