/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.generate.folder.generate;

import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.explorer.model.service.IPTReference;
import com.ibm.pdp.explorer.model.service.IPTRelation;
import com.ibm.pdp.explorer.model.service.PTModelService;
import com.ibm.pdp.macro.pacbase.merge.Merge;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacCPLine;
import com.ibm.pdp.mdl.pacbase.PacDialogServer;
import com.ibm.pdp.mdl.pacbase.PacFolder;
import com.ibm.pdp.mdl.pacbase.PacServer;
import com.ibm.pdp.pacbase.generate.DefaultPacbaseGenerationImplementation;
import com.ibm.pdp.pacbase.generate.folder.generate.FolderGeneration;
import com.ibm.pdp.pacbase.generate.folder.generate.PacToW1ModelServerIT;
import com.ibm.pdp.pacbase.generate.util.PacbaseLinksEntitiesService;
import com.ibm.pdp.pacbase.generate.util.PacbaseModelService;
import com.ibm.pdp.pacbase.util.extraction.dialog.model.EY1H;
import com.ibm.pdp.pacbase.util.extraction.dialog.model.PacbaseSegment;
import com.ibm.pdp.trace.PTTraceManager;
import com.ibm.pdp.util.PdpConstants;
import com.ibm.pdp.util.Util;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

public class ServerITGeneration
extends DefaultPacbaseGenerationImplementation {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected PacServer _pacServerIT;
    protected PacFolder _pacFolder;
    protected boolean _canHaveUserCode;
    protected static PacFolder pacFolder = null;
    FolderGeneration folderW1;
    protected int numberForRoot;
    protected String cblFileName;
    protected String cblITFileName;
    public PacToW1ModelServerIT w1ModelIT = null;
    List<PacbaseSegment> w1LinesFolder;
    TreeMap<String, List<String>> paramsTable;
    public PacServer server;
    public static final boolean isUnix = PdpConstants.IS_UNIX_OS;
    private static String w3CmdFile = isUnix ? "/../../script_linux/GGS35.sh" : "/GGS35.cmd";

    public ServerITGeneration(PacServer pacServer, String destination, boolean canHaveUserCode, String macroSource, String patternName, String macroSP) {
        this._pacServerIT = pacServer;
        this._canHaveUserCode = canHaveUserCode;
        this.virtualMacroSource = macroSource;
        this.macroSP_name = macroSP;
        this.patternName = patternName;
        int resolMode = PTEditorService.getResolvingMode();
        PTEditorService.setResolvingMode((int)3);
        this._pacFolder = this.searchForFirstFolderForServer(this._pacServerIT);
        if (this._pacFolder != null) {
            this.folderW1 = new FolderGeneration(this._pacFolder, destination, canHaveUserCode, true, this.virtualMacroSource);
            this.w1LinesFolder = this.folderW1.getFolderW1Lines();
            this.modifyW1LinesFromFolder();
        }
        this.init();
        PTEditorService.setResolvingMode((int)resolMode);
    }

    public List<PacbaseSegment> getW1LinesFolder() {
        return this.w1LinesFolder;
    }

    public PacbaseLinksEntitiesService getReferencedEntities() {
        return this.w1ModelIT.getPacLinksEntitiesService();
    }

    private PacFolder searchForFirstFolderForServer(PacServer pacServer) {
        List superReferences = PTModelService.getReferences((String)pacServer.getDesignId(pacServer.getProject()), (int)1);
        Collections.sort(superReferences, new GestionnaireCompare());
        PacFolder folder = null;
        for (IPTReference reference : superReferences) {
            String ref;
            IPath path;
            RadicalEntity re;
            IPTRelation relation = (IPTRelation)reference.getRelations().get("PacFolder(GOLines[])/PacGLine#GOLines");
            if (relation == null || !((re = PTModelService.getResource((IPath)(path = PTModelService.getPath((String)(ref = reference.getSourceId()))))) instanceof PacFolder)) continue;
            folder = (PacFolder)re;
            return folder;
        }
        return folder;
    }

    private void init() {
        this.findAndGetW1File();
        this.vapCobolGeneration();
        this.paramsTable = new TreeMap();
        for (Object obj : this._pacServerIT.getCPLines()) {
            PacCPLine cpLine;
            if (!(obj instanceof PacCPLine) || (cpLine = (PacCPLine)obj).getMacro().getName().equals(this.macroSP_name)) continue;
            this.paramsTable.put(PacbaseModelService.getInstance().getCPLineIdentifier(cpLine), PacbaseModelService.getInstance().formatCallCP(cpLine));
            this.w1ModelIT.getPacLinksEntitiesService().registerReference((RadicalEntity)cpLine.getMacro());
        }
        PTTraceManager traceManager = PTTraceManager.getInstance();
        int engineTraceLevel = traceManager.getTraceLevel("com.ibm.pdp.pac");
        if (engineTraceLevel > 0) {
            String message = "cblgenFileNAme:" + this.cblgenFileName + " " + new Date();
            traceManager.trace(ServerITGeneration.class, "com.ibm.pdp.pac", 1, message);
        }
        String path = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
        Merge merge = new Merge();
        merge.mergeFromFiles(this.cblgenFileName, this.paramsTable, path, "server_ITtyp", (RadicalEntity)this.server, this.w1ModelIT.getPacLinksEntitiesService(), this.virtualMacroSource);
        if (PTTraceManager.getInstance().getTraceLevel("com.ibm.pdp.pac") > 0) {
            this.writeClbgenAfterMacroCalls(merge.getPublicationResult());
        }
        this.generatedInfo = merge.getNodeTreeConverter((RadicalEntity)this.server);
        this.genericProblems = merge.getMergeProblems();
        this.ntiList = merge.getNodeTagInformations();
    }

    private void findAndGetW1File() {
        this.w1ModelIT = new PacToW1ModelServerIT(this._pacServerIT, this.w1LinesFolder, this.numberForRoot, this.patternName);
    }

    private void modifyW1LinesFromFolder() {
        Iterator<PacbaseSegment> allLineFolder = this.w1LinesFolder.iterator();
        PacbaseSegment w1LineFolder = null;
        while (allLineFolder.hasNext()) {
            w1LineFolder = allLineFolder.next();
            if (w1LineFolder.get_GRCLEEY_Groupe_Value().get_G1_Value().equals("M") && w1LineFolder.get_GRCLEEY_Groupe_Value().get_GRG3BIS_Groupe_Value().get_G3_Value().equals("B")) {
                allLineFolder.remove();
                continue;
            }
            w1LineFolder.get_GRCLEEY_Groupe_Value().set_G2_Value(this._pacServerIT.getName());
            w1LineFolder.get_GRCLEEY_Groupe_Value().set_G1_Value("W");
            if (!w1LineFolder.get_GRCLEEY_Groupe_Value().get_COCA_Value().equals("H ")) continue;
            EY1H w1LineDef = (EY1H)w1LineFolder;
            EY1H.GRPR1H ey1HPR1H = w1LineDef.get_GRPR1H_Groupe_Value();
            PacDialogServer dialogSrv = this._pacServerIT.getDialog();
            ey1HPR1H.set_GRCOECR_Value(this._pacServerIT.getName());
            ey1HPR1H.set_LIECR_Value(this._pacServerIT.getLabel());
            if (String.valueOf(this._pacServerIT.getDialogType()).equals("_None")) {
                if (!String.valueOf(dialogSrv.getDialogType()).equals("_None")) {
                    ey1HPR1H.set_TECR_Value(String.valueOf(dialogSrv.getDialogType()).substring(1));
                } else {
                    ey1HPR1H.set_TECR_Value("  ");
                }
            } else {
                ey1HPR1H.set_TECR_Value(String.valueOf(this._pacServerIT.getDialogType()).substring(1));
            }
            if (String.valueOf(this._pacServerIT.getCobolType()).equals("_None")) {
                ey1HPR1H.get_GRVARI_Groupe_Value().set_VARIA_Value(String.valueOf(dialogSrv.getCobolType()).substring(1));
            } else {
                ey1HPR1H.get_GRVARI_Groupe_Value().set_VARIA_Value(String.valueOf(this._pacServerIT.getCobolType()).substring(1));
            }
            if (String.valueOf(this._pacServerIT.getMapType()).equals("_None")) {
                ey1HPR1H.get_GRVARI_Groupe_Value().set_VARIB_Value(String.valueOf(dialogSrv.getMapType()).substring(1));
            } else {
                ey1HPR1H.get_GRVARI_Groupe_Value().set_VARIB_Value(String.valueOf(this._pacServerIT.getMapType()).substring(1));
            }
            if (this._pacServerIT.getProgramExternalName().trim().length() > 0) {
                ey1HPR1H.set_CPCOB1_Value(this._pacServerIT.getProgramExternalName());
            }
            ey1HPR1H.set_CPCOBM_Value(this._pacServerIT.getServerExternalName());
            if (this._pacServerIT.getTransactionCode().length() < 1) {
                ey1HPR1H.set_CPCOBT_Value(dialogSrv.getTransactionCode());
            } else {
                ey1HPR1H.set_CPCOBT_Value(this._pacServerIT.getTransactionCode());
            }
            w1LineDef.set_TYENT_Value("");
        }
        if (w1LineFolder != null && w1LineFolder.get_GRCLEEY_Groupe_Value() != null && w1LineFolder.get_GRCLEEY_Groupe_Value().get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_GRG5A6_Groupe_Value().toString().trim().length() > 19) {
            this.numberForRoot = Integer.parseInt(w1LineFolder.get_GRCLEEY_Groupe_Value().get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_GRG5A6_Groupe_Value().get_G5_Value());
        }
    }

    protected String[] getCommandLineForgenerator() {
        String[] cmd = new String[]{"", "", "", "", "", "", "", "", "", ""};
        String userdir1 = PacbaseModelService.getInstance().getCommandFileForGeneration("/data/generator").getAbsolutePath();
        cmd[0] = String.valueOf(userdir1) + File.separator + w3CmdFile;
        cmd[1] = userdir1;
        cmd[2] = Util.GetRandomString((int)6);
        String tempdir = System.getProperty("java.io.tmpdir");
        int end = tempdir.length();
        cmd[3] = isUnix ? tempdir : tempdir.substring(0, --end);
        cmd[4] = this.cblFileName = PacbaseModelService.getInstance().createTmpFileForGeneration("serverIT", ".cbl", true).getAbsolutePath();
        cmd[5] = this.cblgenFileName = PacbaseModelService.getInstance().createTmpFileForGeneration("serverIT", ".cblgen", true).getAbsolutePath();
        cmd[6] = this.w1ModelIT.getW1ResultFile().getAbsolutePath();
        String squelLang = "EN";
        if (this._pacServerIT != null) {
            squelLang = this._pacServerIT.getSkeletonLanguage().getLiteral().substring(1);
        }
        cmd[7] = squelLang;
        cmd[8] = userdir1.substring(0, 2);
        cmd[9] = "";
        return cmd;
    }

    class GestionnaireCompare
    implements Comparator<IPTReference> {
        GestionnaireCompare() {
        }

        @Override
        public int compare(IPTReference o1, IPTReference o2) {
            return o1.getSourceId().compareTo(o2.getSourceId());
        }
    }
}

