/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.generate.folder.generate;

import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacGenerationHeader;
import com.ibm.pdp.mdl.pacbase.PacLibrary;
import com.ibm.pdp.mdl.pacbase.PacLibrarySubstitutionGenerationHeader;
import com.ibm.pdp.mdl.pacbase.PacServer;
import com.ibm.pdp.pacbase.generate.folder.generate.EY00PacbaseAndKernelServerITVisitor;
import com.ibm.pdp.pacbase.generate.util.PacbaseLinksEntitiesService;
import com.ibm.pdp.pacbase.generate.util.PacbaseModelService;
import com.ibm.pdp.pacbase.util.EBCDICCompare;
import com.ibm.pdp.pacbase.util.extraction.dialog.model.PacbaseSegment;
import com.ibm.pdp.util.Util;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

public class PacToW1ModelServerIT {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private PacServer generationServerIT;
    private PacServer referencedServerIT;
    private PacLibrary library;
    List<PacbaseSegment> w1LinesFolder;
    int numberLastRoot;
    private File w1ResultFile;
    private EY00PacbaseAndKernelServerITVisitor w1pkvisitorIT;
    private PacbaseLinksEntitiesService ples;
    private String patternName;
    final Comparator<PacbaseSegment> ebcdicCmp = new Comparator<PacbaseSegment>(){

        @Override
        public int compare(PacbaseSegment object1, PacbaseSegment object2) {
            return EBCDICCompare.stringCompare((String)object1.toString().substring(0, 36), (String)object2.toString().substring(0, 36));
        }
    };

    public PacToW1ModelServerIT(PacServer server, List w1LinesFolder, int numberOfLastRoot, String patternName) {
        this.generationServerIT = server;
        this.numberLastRoot = numberOfLastRoot;
        this.patternName = patternName;
        this.initReferencedProgram();
        this.transformToW1Model(w1LinesFolder);
    }

    private void transformToW1Model(List w1LinesFolder) {
        this.scanPacbaseModel(w1LinesFolder);
        this.writeTempFile();
    }

    private void scanPacbaseModel(List w1LinesFolder) {
        this.w1pkvisitorIT = new EY00PacbaseAndKernelServerITVisitor(this.getPacLinksEntitiesService(), (RadicalEntity)this.generationServerIT, w1LinesFolder, this.numberLastRoot);
        if (w1LinesFolder == null) {
            this.w1pkvisitorIT.doSwitch((EObject)this.library);
        }
        this.w1pkvisitorIT.doSwitch((EObject)this.generationServerIT);
    }

    public PacbaseLinksEntitiesService getPacLinksEntitiesService() {
        if (this.ples == null) {
            this.ples = new PacbaseLinksEntitiesService(this.patternName);
        }
        return this.ples;
    }

    protected File getW1ResultFile() {
        return this.w1ResultFile;
    }

    private void writeTempFile() {
        this.w1ResultFile = PacbaseModelService.getInstance().createTmpFileForGeneration("serverITW1", true);
        if (System.getProperty("FolderGeneration.w1.junit.process") != null) {
            System.setProperty("FolderGeneration.w1.junit.process", this.w1ResultFile.getAbsolutePath());
        }
        try {
            FileWriter fileOutStream1 = new FileWriter(this.w1ResultFile);
            PrintWriter w1OutStream = new PrintWriter(fileOutStream1);
            List<PacbaseSegment> l = this.w1pkvisitorIT.getEntityLines();
            Collections.sort(l, this.ebcdicCmp);
            for (PacbaseSegment lineX : l) {
                String lineS = lineX.getCompleteContentForSegment().trim();
                w1OutStream.write(String.valueOf(lineS) + System.getProperty("line.separator"));
            }
            w1OutStream.close();
        }
        catch (Exception e) {
            Util.rethrow((Throwable)e);
        }
    }

    private void initReferencedProgram() {
        PacGenerationHeader generationHeader = this.generationServerIT.getGenerationHeader();
        if (generationHeader != null) {
            if (generationHeader instanceof PacLibrarySubstitutionGenerationHeader) {
                PacLibrarySubstitutionGenerationHeader libSubstHeader = (PacLibrarySubstitutionGenerationHeader)generationHeader;
                this.referencedServerIT = (PacServer)libSubstHeader.getGeneratedRadicalEntity();
                this.library = libSubstHeader.getGenerationParameter();
            }
        } else {
            this.referencedServerIT = this.generationServerIT;
            this.library = this.referencedServerIT.getGenerationParameter();
        }
    }
}

