/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.generate.folder.generate;

import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacChildNode;
import com.ibm.pdp.mdl.pacbase.PacFolder;
import com.ibm.pdp.mdl.pacbase.PacGenerationHeader;
import com.ibm.pdp.mdl.pacbase.PacLibrary;
import com.ibm.pdp.mdl.pacbase.PacLibrarySubstitutionGenerationHeader;
import com.ibm.pdp.mdl.pacbase.PacRootNode;
import com.ibm.pdp.pacbase.generate.folder.generate.EY00PacbaseAndKernelFolderVisitor;
import com.ibm.pdp.pacbase.generate.util.PacbaseLinksEntitiesService;
import com.ibm.pdp.pacbase.generate.util.PacbaseModelService;
import com.ibm.pdp.pacbase.util.EBCDICCompare;
import com.ibm.pdp.pacbase.util.extraction.dialog.model.PacbaseSegment;
import com.ibm.pdp.util.Util;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

public class PacToW1ModelFolder {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private PacFolder generationFolder;
    private PacFolder referencedFolder;
    private PacLibrary library;
    private boolean isServeurIT;
    private String priorHierarchicalNodeCode = "";
    private String patternName;
    private File w1ResultFile;
    private EY00PacbaseAndKernelFolderVisitor w1pkvisitor;
    private PacbaseLinksEntitiesService ples;
    final Comparator<PacbaseSegment> ebcdicCmp = new Comparator<PacbaseSegment>(){

        @Override
        public int compare(PacbaseSegment object1, PacbaseSegment object2) {
            return EBCDICCompare.stringCompare((String)object1.toString().substring(0, 36), (String)object2.toString().substring(0, 36));
        }
    };

    public PacToW1ModelFolder(PacFolder folder, boolean isServIT, String patternName) {
        this.generationFolder = folder;
        this.isServeurIT = isServIT;
        this.patternName = patternName;
        this.initReferencedProgram();
        this.transformToW1Model();
    }

    private void transformToW1Model() {
        this.scanPacbaseModel();
        if (!this.isServeurIT) {
            this.writeTempFile();
        }
    }

    public List<PacbaseSegment> getlines() {
        return this.w1pkvisitor.getEntityLines();
    }

    private void scanPacbaseModel() {
        this.w1pkvisitor = new EY00PacbaseAndKernelFolderVisitor(this.getPacLinksEntitiesService(), (RadicalEntity)this.generationFolder, false);
        this.w1pkvisitor.doSwitch((EObject)this.library);
        this.w1pkvisitor.doSwitch((EObject)this.generationFolder);
        PacRootNode node = this.generationFolder.getPacRootNode();
        this.w1pkvisitor.doSwitch((EObject)node);
        Iterator childNodesIterator = node.getChildNodes().iterator();
        while (childNodesIterator.hasNext()) {
            this.priorHierarchicalNodeCode = node.getNodeCode();
            this.w1pkvisitor.setPriorHierarchicalNodeCode(this.priorHierarchicalNodeCode);
            PacChildNode nodeCProxy = (PacChildNode)childNodesIterator.next();
            this.w1pkvisitor.doSwitch((EObject)nodeCProxy);
            Iterator allChildNodeProxy_Level2 = nodeCProxy.getChildNodes().iterator();
            while (allChildNodeProxy_Level2.hasNext()) {
                this.priorHierarchicalNodeCode = nodeCProxy.getNodeCode();
                this.w1pkvisitor.setPriorHierarchicalNodeCode(this.priorHierarchicalNodeCode);
                PacChildNode nodeCProxy_Level2 = (PacChildNode)allChildNodeProxy_Level2.next();
                this.w1pkvisitor.doSwitch((EObject)nodeCProxy_Level2);
            }
        }
    }

    public PacbaseLinksEntitiesService getPacLinksEntitiesService() {
        if (this.ples == null) {
            this.ples = new PacbaseLinksEntitiesService(this.patternName);
        }
        return this.ples;
    }

    protected File getW1ResultFile() {
        return this.w1ResultFile;
    }

    private void writeTempFile() {
        this.w1ResultFile = PacbaseModelService.getInstance().createTmpFileForGeneration("folderW1", true);
        if (System.getProperty("FolderGeneration.w1.junit.process") != null) {
            System.setProperty("FolderGeneration.w1.junit.process", this.w1ResultFile.getAbsolutePath());
        }
        try {
            FileWriter fileOutStream1 = new FileWriter(this.w1ResultFile);
            PrintWriter w1OutStream = new PrintWriter(fileOutStream1);
            List<PacbaseSegment> l = this.w1pkvisitor.getEntityLines();
            Collections.sort(l, this.ebcdicCmp);
            for (PacbaseSegment lineX : l) {
                String lineS = lineX.getCompleteContentForSegment().trim();
                w1OutStream.write(String.valueOf(lineS) + System.getProperty("line.separator"));
            }
            w1OutStream.close();
        }
        catch (Exception e) {
            Util.rethrow((Throwable)e);
        }
    }

    private void initReferencedProgram() {
        PacGenerationHeader generationHeader = this.generationFolder.getGenerationHeader();
        if (generationHeader != null) {
            if (generationHeader instanceof PacLibrarySubstitutionGenerationHeader) {
                PacLibrarySubstitutionGenerationHeader libSubstHeader = (PacLibrarySubstitutionGenerationHeader)generationHeader;
                this.referencedFolder = (PacFolder)libSubstHeader.getGeneratedRadicalEntity();
                this.library = libSubstHeader.getGenerationParameter();
            }
        } else {
            this.referencedFolder = this.generationFolder;
            this.library = this.referencedFolder.getGenerationParameter();
        }
    }
}

