/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.generate.ebusiness.model;

import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacCommunicationTypeValues;
import com.ibm.pdp.mdl.pacbase.PacDialogCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacDialogFolder;
import com.ibm.pdp.mdl.pacbase.PacDialogServer;
import com.ibm.pdp.mdl.pacbase.PacDialogServerTypeValues;
import com.ibm.pdp.mdl.pacbase.PacFolder;
import com.ibm.pdp.mdl.pacbase.PacFolderView;
import com.ibm.pdp.mdl.pacbase.PacGLine;
import com.ibm.pdp.mdl.pacbase.PacLibrary;
import com.ibm.pdp.mdl.pacbase.PacServer;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class EntityEbusinessDefinition {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private RadicalEntity radicalEntity;
    private PacServer errorServer;
    private Boolean generationProxy = false;

    public EntityEbusinessDefinition(RadicalEntity re, boolean generationProxy) {
        this.radicalEntity = re;
        this.generationProxy = generationProxy;
    }

    public String getName() {
        String name = "";
        if (this.radicalEntity instanceof PacCommunicationMonitor) {
            name = ((PacCommunicationMonitor)this.radicalEntity).getName();
        } else if (this.radicalEntity instanceof PacFolder) {
            name = ((PacFolder)this.radicalEntity).getName();
        } else if (this.radicalEntity instanceof PacFolderView) {
            name = ((PacFolderView)this.radicalEntity).getName();
        } else if (this.radicalEntity instanceof PacServer) {
            name = ((PacServer)this.radicalEntity).getName();
        }
        return name;
    }

    public String getExternalName() {
        String extName = "";
        if (this.radicalEntity instanceof PacCommunicationMonitor) {
            extName = ((PacCommunicationMonitor)this.radicalEntity).getExternalName();
        } else if (this.radicalEntity instanceof PacFolder) {
            extName = ((PacFolder)this.radicalEntity).getExternalName();
        } else if (this.radicalEntity instanceof PacFolderView) {
            extName = ((PacFolderView)this.radicalEntity).getName();
        } else if (this.radicalEntity instanceof PacServer) {
            extName = ((PacServer)this.radicalEntity).getServerExternalName();
        }
        return extName;
    }

    public String getLabel() {
        String label = "";
        if (this.radicalEntity instanceof PacCommunicationMonitor) {
            label = ((PacCommunicationMonitor)this.radicalEntity).getLabel();
        } else if (this.radicalEntity instanceof PacFolder) {
            label = ((PacFolder)this.radicalEntity).getLabel();
        } else if (this.radicalEntity instanceof PacFolderView) {
            label = ((PacFolderView)this.radicalEntity).getLabel();
        }
        return label;
    }

    public String getMessageSize() {
        String mesSize = "";
        if (this.radicalEntity instanceof PacCommunicationMonitor) {
            mesSize = String.valueOf(((PacCommunicationMonitor)this.radicalEntity).getMessageSize());
        }
        return mesSize;
    }

    public String getCobolType(PacDialogCommunicationMonitor dcm, PacDialogServer ds, PacDialogFolder df) {
        String cobolType = "N";
        if (this.radicalEntity instanceof PacCommunicationMonitor) {
            cobolType = ((PacCommunicationMonitor)this.radicalEntity).getCobolType().getLiteral().substring(1);
            if (cobolType.equals("None") && dcm != null) {
                cobolType = String.valueOf(dcm.getCobolType()).substring(1);
            } else if (cobolType.equals("None") && ds != null) {
                cobolType = String.valueOf(ds.getCobolType()).substring(1);
            }
        } else if (this.radicalEntity instanceof PacFolder && (cobolType = ((PacFolder)this.radicalEntity).getCobolType().getLiteral().substring(1)).equals("None") && df != null) {
            cobolType = String.valueOf(df.getCobolType()).substring(1);
        }
        return cobolType;
    }

    public String getMapType(PacDialogCommunicationMonitor dcm, PacDialogServer ds, PacDialogFolder df) {
        String mapType = "N";
        if (this.radicalEntity instanceof PacCommunicationMonitor) {
            mapType = ((PacCommunicationMonitor)this.radicalEntity).getMapType().getLiteral().substring(1);
            if (mapType.equals("None") && dcm != null) {
                mapType = String.valueOf(dcm.getMapType()).substring(1);
            } else if (mapType.equals("None") && ds != null) {
                mapType = String.valueOf(ds.getMapType()).substring(1);
            }
        } else if (this.radicalEntity instanceof PacFolder && (mapType = ((PacFolder)this.radicalEntity).getMapType().getLiteral().substring(1)).equals("None") && df != null) {
            mapType = String.valueOf(df.getMapType()).substring(1);
        }
        return mapType;
    }

    public String getCommunicationType() {
        String comTyp = "";
        if (this.radicalEntity instanceof PacCommunicationMonitor && !((PacCommunicationMonitor)this.radicalEntity).getCommunicationType().equals(PacCommunicationTypeValues._NONE_LITERAL)) {
            comTyp = ((PacCommunicationMonitor)this.radicalEntity).getCommunicationType().getLiteral().substring(1);
        }
        return comTyp;
    }

    public String getTransactionCode(PacDialogCommunicationMonitor dcm, PacDialogServer ds, PacDialogFolder df) {
        String transCode = "";
        if (this.radicalEntity instanceof PacCommunicationMonitor) {
            transCode = ((PacCommunicationMonitor)this.radicalEntity).getTransactionCode();
            if (transCode.trim().length() < 1 && dcm != null) {
                transCode = dcm.getTransactionCode();
            } else if (transCode.trim().length() < 1 && ds != null) {
                transCode = ds.getTransactionCode();
            }
        } else if (this.radicalEntity instanceof PacFolder) {
            this.errorServer = ((PacFolder)this.radicalEntity).getErrorServer();
            if (this.errorServer != null && (transCode = ((PacFolder)this.radicalEntity).getErrorServer().getName()).trim().length() < 1 && df != null) {
                transCode = df.getErrorServer().getName();
            }
        }
        return transCode;
    }

    public String getTecr() {
        String tecr = "";
        if (this.radicalEntity instanceof PacCommunicationMonitor) {
            tecr = "FM";
        } else if (this.radicalEntity instanceof PacFolder) {
            tecr = "F";
        } else if (this.radicalEntity instanceof PacFolderView) {
            tecr = "FV";
        }
        return tecr;
    }

    public String getG1() {
        String g1 = "";
        if (this.radicalEntity instanceof PacCommunicationMonitor) {
            g1 = "W";
        } else if (this.radicalEntity instanceof PacFolder) {
            g1 = "M";
            if (this.generationProxy.booleanValue()) {
                g1 = "W";
            }
        } else if (this.radicalEntity instanceof PacServer) {
            g1 = "M";
            if (((PacServer)this.radicalEntity).getDialogType().equals(PacDialogServerTypeValues._IT_LITERAL)) {
                g1 = "W";
            }
        } else if (this.radicalEntity instanceof PacFolderView) {
            g1 = "W";
        }
        return g1;
    }

    public List<PacGLine> getGOLines() {
        EList pacGolinesList = null;
        if (this.radicalEntity instanceof PacCommunicationMonitor) {
            pacGolinesList = ((PacCommunicationMonitor)this.radicalEntity).getGOLines();
        } else if (this.radicalEntity instanceof PacFolder) {
            pacGolinesList = ((PacFolder)this.radicalEntity).getGOLines();
        }
        return pacGolinesList;
    }

    public PacServer getErrorServer() {
        return this.errorServer;
    }

    public PacLibrary getGenerationParameter() {
        PacLibrary li = null;
        if (this.radicalEntity instanceof PacCommunicationMonitor) {
            li = ((PacCommunicationMonitor)this.radicalEntity).getGenerationParameter();
        } else if (this.radicalEntity instanceof PacFolder) {
            li = ((PacFolder)this.radicalEntity).getGenerationParameter();
        } else if (this.radicalEntity instanceof PacServer) {
            li = ((PacServer)this.radicalEntity).getGenerationParameter();
        } else if (this.radicalEntity instanceof PacFolderView) {
            li = ((PacFolderView)this.radicalEntity).getGenerationParameter();
        }
        return li;
    }

    public String getPrefClass() {
        String prefClass = "";
        if (this.radicalEntity instanceof PacFolderView) {
            prefClass = ((PacFolderView)this.radicalEntity).getPrefixClass();
        }
        return prefClass;
    }

    public RadicalEntity getRadicalEntity() {
        return this.radicalEntity;
    }
}

