/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.generate.communicationMonitor.generate;

import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacGenerationHeader;
import com.ibm.pdp.mdl.pacbase.PacLibrary;
import com.ibm.pdp.mdl.pacbase.PacLibrarySubstitutionGenerationHeader;
import com.ibm.pdp.pacbase.generate.communicationMonitor.generate.EY00PacbaseAndKernelCommunicationMonitorVisitor;
import com.ibm.pdp.pacbase.generate.util.PacbaseLinksEntitiesService;
import com.ibm.pdp.pacbase.generate.util.PacbaseModelService;
import com.ibm.pdp.pacbase.util.EBCDICCompare;
import com.ibm.pdp.pacbase.util.extraction.dialog.model.PacbaseSegment;
import com.ibm.pdp.util.Util;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

public class PacToW1ModelDialogCM {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private PacCommunicationMonitor referencedCommunicationMonitor;
    private PacCommunicationMonitor generationCommunicationMonitor;
    private PacLibrary library;
    private File w1ResultFile;
    private EY00PacbaseAndKernelCommunicationMonitorVisitor w1pkvisitor;
    private PacbaseLinksEntitiesService ples;
    private String pattern;
    final Comparator<PacbaseSegment> ebcdicCmp = new Comparator<PacbaseSegment>(){

        @Override
        public int compare(PacbaseSegment object1, PacbaseSegment object2) {
            return EBCDICCompare.stringCompare((String)object1.toString().substring(0, 42), (String)object2.toString().substring(0, 42));
        }
    };

    public PacToW1ModelDialogCM(PacCommunicationMonitor comMonitor, String pattern) {
        this.pattern = pattern;
        this.generationCommunicationMonitor = comMonitor;
        this.initReferencedProgram();
        this.transformToW1Model();
    }

    private void transformToW1Model() {
        this.scanPacbaseModel();
        this.writeTempFile();
    }

    private void scanPacbaseModel() {
        this.w1pkvisitor = new EY00PacbaseAndKernelCommunicationMonitorVisitor(this.getPacLinksEntitiesService(), (RadicalEntity)this.generationCommunicationMonitor);
        this.w1pkvisitor.doSwitch((EObject)this.library);
        this.w1pkvisitor.doSwitch((EObject)this.generationCommunicationMonitor);
    }

    public PacbaseLinksEntitiesService getPacLinksEntitiesService() {
        if (this.ples == null) {
            this.ples = new PacbaseLinksEntitiesService(this.pattern);
        }
        return this.ples;
    }

    protected File getW1ResultFile() {
        return this.w1ResultFile;
    }

    private void writeTempFile() {
        this.w1ResultFile = PacbaseModelService.getInstance().createTmpFileForGeneration("communicationMonitorw1", true);
        if (System.getProperty("CommunicationMonitorGeneration.w1.junit.process") != null) {
            System.setProperty("CommunicationMonitorGeneration.w1.junit.process", this.w1ResultFile.getAbsolutePath());
        }
        try {
            FileWriter fileOutStream1 = new FileWriter(this.w1ResultFile);
            PrintWriter w1OutStream = new PrintWriter(fileOutStream1);
            List<PacbaseSegment> l = this.w1pkvisitor.getEntityLines();
            Collections.sort(l, this.ebcdicCmp);
            for (PacbaseSegment lineX : l) {
                String lineS = lineX.getCompleteContentForSegment().trim();
                w1OutStream.write(String.valueOf(lineS) + System.getProperty("line.separator"));
            }
            w1OutStream.close();
        }
        catch (Exception e) {
            Util.rethrow((Throwable)e);
        }
    }

    private void initReferencedProgram() {
        PacGenerationHeader generationHeader = this.generationCommunicationMonitor.getGenerationHeader();
        if (generationHeader != null) {
            if (generationHeader instanceof PacLibrarySubstitutionGenerationHeader) {
                PacLibrarySubstitutionGenerationHeader libSubstHeader = (PacLibrarySubstitutionGenerationHeader)generationHeader;
                this.referencedCommunicationMonitor = (PacCommunicationMonitor)libSubstHeader.getGeneratedRadicalEntity();
                this.library = libSubstHeader.getGenerationParameter();
            }
        } else {
            this.referencedCommunicationMonitor = this.generationCommunicationMonitor;
            this.library = this.referencedCommunicationMonitor.getGenerationParameter();
        }
    }
}

