/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.generate.communicationMonitor.generate;

import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.macro.pacbase.merge.Merge;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacCPLine;
import com.ibm.pdp.mdl.pacbase.PacCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacGenerationHeader;
import com.ibm.pdp.mdl.pacbase.PacLibrarySubstitutionGenerationHeader;
import com.ibm.pdp.mdl.pacbase.util.PacCommunicationMonitorWrapper;
import com.ibm.pdp.pacbase.generate.DefaultPacbaseGenerationImplementation;
import com.ibm.pdp.pacbase.generate.communicationMonitor.generate.PacToW1ModelDialogCM;
import com.ibm.pdp.pacbase.generate.util.PacbaseLinksEntitiesService;
import com.ibm.pdp.pacbase.generate.util.PacbaseModelService;
import com.ibm.pdp.trace.PTTraceManager;
import com.ibm.pdp.util.Util;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.core.resources.ResourcesPlugin;

public class CommunicationMonitorGeneration
extends DefaultPacbaseGenerationImplementation {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected PacCommunicationMonitor comMonitor;
    protected boolean _canHaveUserCode;
    TreeMap<String, List<String>> paramsTable;
    protected String cblFileName;
    public PacToW1ModelDialogCM w1Model = null;
    private static String w3CmdFile = isUnix ? "/../../script_linux/GGS35.sh" : "/GGS35.cmd";

    public CommunicationMonitorGeneration(PacCommunicationMonitor reW, String pattern, boolean canHaveUserCode, String macroSource) {
        this.patternName = pattern;
        this.comMonitor = new PacCommunicationMonitorWrapper(reW);
        this._canHaveUserCode = canHaveUserCode;
        this.virtualMacroSource = macroSource;
        int resolMode = PTEditorService.getResolvingMode();
        PTEditorService.setResolvingMode((int)3);
        this.init();
        PTEditorService.setResolvingMode((int)resolMode);
    }

    public PacbaseLinksEntitiesService getReferencedEntities() {
        return this.w1Model.getPacLinksEntitiesService();
    }

    private void init() {
        this.findAndGetW1File();
        this.vapCobolGeneration();
        this.paramsTable = new TreeMap();
        for (Object obj : this.getCPLinesContainerScreen(this.comMonitor).getCPLines()) {
            if (!(obj instanceof PacCPLine)) continue;
            PacCPLine cpLine = (PacCPLine)obj;
            this.paramsTable.put(PacbaseModelService.getInstance().getCPLineIdentifier(cpLine), PacbaseModelService.getInstance().formatCallCP(cpLine));
            this.w1Model.getPacLinksEntitiesService().registerReference((RadicalEntity)cpLine.getMacro());
        }
        PTTraceManager traceManager = PTTraceManager.getInstance();
        int engineTraceLevel = traceManager.getTraceLevel("com.ibm.pdp.pac");
        if (engineTraceLevel > 0) {
            String message = "cblgenFileNAme:" + this.cblgenFileName + " " + this.comMonitor + " " + new Date();
            traceManager.trace(CommunicationMonitorGeneration.class, "com.ibm.pdp.pac", 1, message);
        }
        String path = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
        Merge merge = new Merge();
        merge.mergeFromFiles(this.cblgenFileName, this.paramsTable, path, "folder_monit", (RadicalEntity)this.comMonitor, this.w1Model.getPacLinksEntitiesService(), this.virtualMacroSource);
        if (PTTraceManager.getInstance().getTraceLevel("com.ibm.pdp.pac") > 0) {
            this.writeClbgenAfterMacroCalls(merge.getPublicationResult());
        }
        this.generatedInfo = merge.getNodeTreeConverter((RadicalEntity)this.comMonitor);
        this.genericProblems = merge.getMergeProblems();
        this.ntiList = merge.getNodeTagInformations();
    }

    private PacCommunicationMonitor getCPLinesContainerScreen(PacCommunicationMonitor _pacFolder) {
        if (_pacFolder == null) {
            return null;
        }
        PacGenerationHeader generationHeader = _pacFolder.getGenerationHeader();
        if (generationHeader == null) {
            return _pacFolder;
        }
        if (generationHeader instanceof PacLibrarySubstitutionGenerationHeader) {
            PacLibrarySubstitutionGenerationHeader libSubstHeader = (PacLibrarySubstitutionGenerationHeader)generationHeader;
            return (PacCommunicationMonitor)libSubstHeader.getGeneratedRadicalEntity();
        }
        return null;
    }

    private void findAndGetW1File() {
        this.w1Model = new PacToW1ModelDialogCM(this.comMonitor, this.patternName);
    }

    protected String[] getCommandLineForgenerator() {
        String[] cmd = new String[]{"", "", "", "", "", "", "", "", "", ""};
        String userdir1 = PacbaseModelService.getInstance().getCommandFileForGeneration("/data/generator").getAbsolutePath();
        cmd[0] = String.valueOf(userdir1) + File.separator + w3CmdFile;
        cmd[1] = userdir1;
        cmd[2] = Util.GetRandomString((int)6);
        String tempdir = System.getProperty("java.io.tmpdir");
        int end = tempdir.length();
        cmd[3] = isUnix ? tempdir : tempdir.substring(0, --end);
        cmd[4] = this.cblFileName = PacbaseModelService.getInstance().createTmpFileForGeneration("communicationMonitor", ".cbl", true).getAbsolutePath();
        cmd[5] = this.cblgenFileName = PacbaseModelService.getInstance().createTmpFileForGeneration("communicationMonitor", ".cblgen", true).getAbsolutePath();
        cmd[6] = this.w1Model.getW1ResultFile().getAbsolutePath();
        String squelLang = "EN";
        if (this.comMonitor != null) {
            squelLang = this.comMonitor.getSkeletonLanguage().getLiteral().substring(1);
        }
        cmd[7] = squelLang;
        cmd[8] = userdir1.substring(0, 2);
        cmd[9] = "";
        return cmd;
    }
}

