/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.generate.dialogcs.generate;

import com.ibm.pdp.explorer.nature.PTNature;
import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.kernel.DataAggregateDescription;
import com.ibm.pdp.mdl.kernel.DataCall;
import com.ibm.pdp.mdl.kernel.DataComponent;
import com.ibm.pdp.mdl.kernel.DataDescription;
import com.ibm.pdp.mdl.kernel.DataElement;
import com.ibm.pdp.mdl.kernel.DataElementDescription;
import com.ibm.pdp.mdl.kernel.DataUnion;
import com.ibm.pdp.mdl.kernel.DataUnionDescription;
import com.ibm.pdp.mdl.kernel.DataUnit;
import com.ibm.pdp.mdl.kernel.Filler;
import com.ibm.pdp.mdl.kernel.KernelPackage;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.impl.DataCallImpl;
import com.ibm.pdp.mdl.pacbase.PacBlankWhenZeroValues;
import com.ibm.pdp.mdl.pacbase.PacDataAggregate;
import com.ibm.pdp.mdl.pacbase.PacDataCall;
import com.ibm.pdp.mdl.pacbase.PacDataCallMore;
import com.ibm.pdp.mdl.pacbase.PacDataElement;
import com.ibm.pdp.mdl.pacbase.PacDataElementDescription;
import com.ibm.pdp.mdl.pacbase.PacDataElementInternalUsageValues;
import com.ibm.pdp.mdl.pacbase.PacDataElementTypeValues;
import com.ibm.pdp.mdl.pacbase.PacFiller;
import com.ibm.pdp.mdl.pacbase.PacLVPresenceCheckValues;
import com.ibm.pdp.mdl.pacbase.PacLogicalViewCall;
import com.ibm.pdp.mdl.pacbase.PacLogicalViewDataTypeValues;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.mdl.pacbase.PacTransferDirectionValues;
import com.ibm.pdp.mdl.pacbase.PacbasePackage;
import com.ibm.pdp.mdl.pacbase.converter.PacPictureParser;
import com.ibm.pdp.mdl.pacbase.impl.PacDLineImpl;
import com.ibm.pdp.mdl.pacbase.impl.PacDataElementImpl;
import com.ibm.pdp.mdl.pacbase.lal.util.GenerationContext;
import com.ibm.pdp.mdl.pacbase.lal.util.LengthAndPositionVisitor;
import com.ibm.pdp.mdl.pacbase.lal.util.PacbaseLalDescription;
import com.ibm.pdp.mdl.pacbase.util.PacTransformationDataElementType;
import com.ibm.pdp.pacbase.generate.util.ExtractUtil;
import com.ibm.pdp.pacbase.generate.util.PacbaseLinksEntitiesService;
import com.ibm.pdp.pacbase.generate.util.PacbaseModelService;
import com.ibm.pdp.pacbase.util.PacQuoteConverter;
import com.ibm.pdp.pacbase.util.extraction.dialog.model.EY12;
import com.ibm.pdp.pacbase.util.extraction.dialog.model.EY13;
import com.ibm.pdp.pacbase.util.extraction.dialog.model.PacbaseSegment;
import com.ibm.pdp.pacbase.util.segment.PacbaseSegmentType;
import com.ibm.pdp.trace.PTTraceManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class SegmentCompositionPacbaseAndKernelVisitor {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final PacbasePackage modelPackagePB = PacbasePackage.eINSTANCE;
    private RadicalEntity generationEntryPoint;
    protected static final KernelPackage modelPackageKernel = KernelPackage.eINSTANCE;
    private String redefines = "R*";
    private String screenCodeToGenerate;
    private String segmentCodeToUse;
    public String segmentCodefromCSLine;
    private String currentSegmentCode;
    private PacScreen currentScreen;
    private char variant;
    private ArrayList<PacbaseSegment> segmentCompositionLines = new ArrayList();
    private ArrayList<String> listOfSelectedSeg;
    private DataCall currentDataCall;
    private Filler currentFiller;
    private int numberOfCorub = 0;
    private boolean firstTime = true;
    private boolean firstTimeForDataAggregate = true;
    private boolean writeLengthRecord = false;
    private ArrayList<PacbaseLalDescription> lalList = new ArrayList();
    private Stack<DataUnionDescription> dataUnionDescriptionStack = new Stack();
    private DataUnionDescription _currentDataUnionDescription = null;
    private boolean isManagingSetOfRedefines = false;
    private boolean isfirstinSetOfRedefines = false;
    private DataAggregate currentda;
    private String variantGenerateBib;
    private String delimGenerateBib;
    private String variantForEntity;
    private String delimForEntity;
    protected boolean isServer;
    private DataElement dataElt;
    private String SEGSEL;
    public static final String INTERNAL_FORMAT = "I";
    public static final String INPUT_FORMAT = "E";
    public static final String OUTPUT_FORMAT = "S";
    public static final char DISPLAY_USAGE = 'D';
    private PacbaseLinksEntitiesService ples;

    public SegmentCompositionPacbaseAndKernelVisitor(PacbaseLinksEntitiesService ples, RadicalEntity re) {
        this.ples = ples;
        this.generationEntryPoint = re;
    }

    public void doSwitch(EObject theEObject) {
        this.doSwitch(theEObject.eClass(), theEObject);
    }

    protected void doSwitch(EClass theEClass, EObject theEObject) {
        if (theEObject instanceof RadicalEntity) {
            this.getPacLinksEntitiesService().registerReference((RadicalEntity)theEObject);
        }
        if (theEClass.eContainer() == modelPackagePB) {
            this.doSwitchPB(theEClass.getClassifierID(), theEObject);
        } else if (theEClass.eContainer() == modelPackageKernel) {
            this.doSwitchKernel(theEClass.getClassifierID(), theEObject);
        }
    }

    protected void doSwitchKernel(int classifierID, EObject theEObject) {
        switch (classifierID) {
            case 2: {
                DataUnit kernelObject = (DataUnit)theEObject;
                this.caseDataUnit(kernelObject);
                break;
            }
            case 36: {
                DataUnit kernelObject = (DataUnit)theEObject;
                this.caseDataUnit(kernelObject);
                break;
            }
            case 37: {
                DataCall kernelObject = (DataCall)theEObject;
                this.caseDataCall(kernelObject);
                break;
            }
            case 45: {
                DataAggregate kernelObject = (DataAggregate)theEObject;
                this.caseDataAggregate(kernelObject);
                break;
            }
            case 18: {
                DataAggregateDescription kernelObject = (DataAggregateDescription)theEObject;
                this.caseDataAggregateDescription(kernelObject);
                break;
            }
            case 44: {
                DataElement kernelObject = (DataElement)theEObject;
                this.caseDataElement(kernelObject);
                break;
            }
            case 33: {
                DataElementDescription kernelObject = (DataElementDescription)theEObject;
                this.caseDataElementDescription(kernelObject);
                break;
            }
            case 43: {
                Filler kernelObject = (Filler)theEObject;
                this.caseFiller(kernelObject);
                break;
            }
            case 46: {
                DataUnion kernelObject = (DataUnion)theEObject;
                this.caseDataUnion(kernelObject);
                break;
            }
            case 35: {
                DataUnionDescription kernelObject = (DataUnionDescription)theEObject;
                this.caseDataUnionDescription(kernelObject);
                break;
            }
            default: {
                PTTraceManager traceManager = PTTraceManager.getInstance();
                int engineTraceLevel = traceManager.getTraceLevel("com.ibm.pdp.pac");
                if (engineTraceLevel <= 0) break;
                String message = "Kernel case not defined: " + theEObject.getClass().toString() + " " + String.valueOf(new Date());
                traceManager.trace(SegmentCompositionPacbaseAndKernelVisitor.class, "com.ibm.pdp.pac", 1, message);
            }
        }
    }

    protected void doSwitchPB(int classifierID, EObject theEObject) {
        switch (classifierID) {
            case 59: {
                PacDataCall pacbaseObject = (PacDataCall)theEObject;
                this.casePacDataCall(pacbaseObject);
                break;
            }
            case 56: {
                PacDataElement pacbaseObject = (PacDataElement)theEObject;
                this.casePacDataElement(pacbaseObject);
                break;
            }
            default: {
                PTTraceManager traceManager = PTTraceManager.getInstance();
                int engineTraceLevel = traceManager.getTraceLevel("com.ibm.pdp.pac");
                if (engineTraceLevel <= 0) break;
                String message = "Pacbase case not defined: " + theEObject.getClass().toString() + " " + String.valueOf(new Date());
                traceManager.trace(SegmentCompositionPacbaseAndKernelVisitor.class, "com.ibm.pdp.pac", 1, message);
            }
        }
    }

    public void caseDataCall(DataCall kDataCall) {
        this.currentDataCall = kDataCall;
        if (kDataCall.getDataDefinition() != null) {
            if (kDataCall.getDataDefinition() instanceof DataElement) {
                this.doSwitch((EObject)kDataCall.getDataDefinition());
            }
            if (kDataCall.getDataDefinition() instanceof DataAggregate) {
                this.doSwitch((EObject)kDataCall.getDataDefinition());
            }
            if (kDataCall.getDataDefinition() instanceof DataUnion) {
                this.doSwitch((EObject)kDataCall.getDataDefinition());
            }
        } else if (kDataCall.getDataDescription() != null) {
            this.doSwitch((EObject)kDataCall.getDataDescription());
        }
    }

    public void caseDataAggregate(DataAggregate kDataAggregate) {
        boolean firstTimeForDABefore = this.firstTimeForDataAggregate;
        boolean writeLine = false;
        if (this.getSegSel().length() < 1) {
            writeLine = true;
        } else if (this.firstTimeForDataAggregate) {
            int i = 0;
            while (i < this.listOfSelectedSeg.size()) {
                String codSeg = this.listOfSelectedSeg.get(i);
                if (codSeg.equals(kDataAggregate.getName().substring(2))) {
                    writeLine = true;
                    break;
                }
                ++i;
            }
        } else {
            writeLine = true;
        }
        if (!writeLine) {
            this.getPacLinksEntitiesService().deleteReference((RadicalEntity)kDataAggregate);
            return;
        }
        this.segmentCodeToUse = this.segmentCodeToUse == null ? this.segmentCodefromCSLine : (this.currentSegmentCode == null ? this.segmentCodeToUse.substring(0, 2) + kDataAggregate.getName().substring(2) : this.currentSegmentCode);
        if (this.firstTimeForDataAggregate) {
            LengthAndPositionVisitor lpvisitor = new LengthAndPositionVisitor(PTNature.getPaths((String)this.generationEntryPoint.getProject()), new GenerationContext(this.getVariant()));
            lpvisitor.doSwitch((EObject)kDataAggregate);
            this.lalList = lpvisitor.defineMatchingArray(lpvisitor.getTopParentLal());
            this.numberOfCorub = 0;
            this.writeLengthRecord = true;
            EY12 ey12ForDataAggregate = this.InstanciateEY12();
            this.currentSegmentCode = this.segmentCodeToUse;
            if (kDataAggregate != null && kDataAggregate.getLabel() != null) {
                ey12ForDataAggregate.set_LIBSEG_Value(kDataAggregate.getLabel());
            }
            Iterator extensions = kDataAggregate.getExtensions().iterator();
            while (extensions.hasNext()) {
                try {
                    PacDataAggregate pacDag = (PacDataAggregate)extensions.next();
                    ey12ForDataAggregate.set_NBENR_Value(pacDag.getTableSize());
                    ey12ForDataAggregate.set_VALST_Value(pacDag.getStructureCodeValue());
                    ey12ForDataAggregate.set_COMOU_Value(pacDag.getActionCode());
                    ey12ForDataAggregate.set_NBRUB1_Value(0);
                    ey12ForDataAggregate.set_LOENR_Value(lpvisitor.getTopParentLal().getTotalInternalLength());
                    ey12ForDataAggregate.set_LOENR1_Value(lpvisitor.getTopParentLal().getTotalInputLength());
                    ey12ForDataAggregate.set_LOENR2_Value(lpvisitor.getTopParentLal().getTotalOutputLength());
                    ey12ForDataAggregate.set_LOENR3_Value(0);
                    if (pacDag.getTableAttributes() == null) continue;
                    ey12ForDataAggregate.set_VALST_Value(pacDag.getTableAttributes().getTableNumber());
                }
                catch (Exception exception) {}
            }
            this.segmentCompositionLines.add((PacbaseSegment)ey12ForDataAggregate);
            ey12ForDataAggregate = new EY12(ey12ForDataAggregate.getCompleteContentForSegment());
            ey12ForDataAggregate.get_GRCLEEY_Groupe_Value().set_G8_Value("2");
            this.segmentCompositionLines.add((PacbaseSegment)ey12ForDataAggregate);
            this.firstTimeForDataAggregate = false;
        } else {
            if (this.lalList.size() == this.numberOfCorub) {
                return;
            }
            EY13 ey13DataAggregateC = this.InstanciateEY13();
            ey13DataAggregateC.setPstype(PacbaseSegmentType.DATA_AGGREGATE);
            if (this.currentDataCall != null) {
                EList extensions = this.currentDataCall.getExtensions();
                this.updateDataCall((List)extensions, ey13DataAggregateC, kDataAggregate.getName(), true);
            }
            this.initFromLalDescription(ey13DataAggregateC);
            this.segmentCompositionLines.add((PacbaseSegment)ey13DataAggregateC);
        }
        this.doSwitch((EObject)kDataAggregate.getDataDescription());
        this.firstTimeForDataAggregate = firstTimeForDABefore;
    }

    public void caseDataAggregateDescription(DataAggregateDescription kDataAggregateDescription) {
        if (this.firstTime) {
            this.firstTime = false;
            for (EObject da : kDataAggregateDescription.getComponents()) {
                this.doSwitch(da);
            }
            return;
        }
        if (kDataAggregateDescription.getName() != null && kDataAggregateDescription.getName().length() > 0) {
            EY13 detailForDataElt = this.InstanciateEY13();
            detailForDataElt.setPstype(PacbaseSegmentType.DATA_AGGREGATE_DESCRIPTION);
            detailForDataElt = this.initFromLalDescription(detailForDataElt);
            detailForDataElt.set_TYRUB_Value("R");
            EY13.GRLIRUB.GRCORTOT lirub = detailForDataElt.get_GRLIRUB_Groupe_Value().get_GRCORTOT_Groupe_Value();
            if (kDataAggregateDescription.getLabel().length() > 1) {
                lirub.set_CORADA_Value(kDataAggregateDescription.getLabel().substring(0, 2));
            }
            if (kDataAggregateDescription.getLabel().length() > 3) {
                lirub.set_FILLER1_Value(kDataAggregateDescription.getLabel().substring(2, 4));
            }
            int internalLengthOfDataEltForThisDAD = Integer.parseInt(detailForDataElt.get_LORUBI_Value());
            String groupFormatInternal = "X(" + String.valueOf(internalLengthOfDataEltForThisDAD) + ")";
            int inputLengthOfDataEltForThisDAD = Integer.parseInt(detailForDataElt.get_LORUBE_Value());
            String groupFormatInput = "X(" + String.valueOf(inputLengthOfDataEltForThisDAD) + ")";
            int outputLengthOfDataEltForThisDAD = Integer.parseInt(detailForDataElt.get_LORUBS_Value());
            String groupFormatOutput = "X(" + String.valueOf(outputLengthOfDataEltForThisDAD) + ")";
            DataElement de = (DataElement)PacbaseModelService.SearchRadicalEntityDuringGeneration((RadicalEntity)this.generationEntryPoint, (String)kDataAggregateDescription.getName(), (String)"dataelement", (PacbaseLinksEntitiesService)this.ples);
            if (de != null) {
                Iterator extensionsA = de.getDataDescription().getExtensions().iterator();
                while (extensionsA.hasNext()) {
                    try {
                        PacDataElementDescription pded = (PacDataElementDescription)extensionsA.next();
                        if (groupFormatInternal.equals(pded.getInternalFormat())) {
                            detailForDataElt.set_PICTUI_Value(groupFormatInternal);
                        } else {
                            detailForDataElt.set_PICTUI_Value("X(" + detailForDataElt.get_LORUBI_Value() + ")");
                        }
                        if (groupFormatInput.equals(pded.getInputFormat())) {
                            detailForDataElt.set_PICTUE_Value(groupFormatInput);
                        } else {
                            detailForDataElt.set_PICTUE_Value("X(" + detailForDataElt.get_LORUBE_Value() + ")");
                        }
                        if (groupFormatOutput.equals(pded.getOutputFormat())) {
                            detailForDataElt.set_GRPICTU_Value(groupFormatOutput);
                            continue;
                        }
                        detailForDataElt.set_GRPICTU_Value("X(" + detailForDataElt.get_LORUBS_Value() + ")");
                    }
                    catch (Exception exception) {}
                }
            } else {
                detailForDataElt.set_PICTUI_Value("X(" + detailForDataElt.get_LORUBI_Value() + ")");
                detailForDataElt.set_PICTUE_Value("X(" + detailForDataElt.get_LORUBE_Value() + ")");
                detailForDataElt.set_GRPICTU_Value("X(" + detailForDataElt.get_LORUBS_Value() + ")");
            }
            detailForDataElt.set_USAGEI_Value("D");
            EList extCDC = this.currentDataCall.getExtensions();
            this.updateDataCall((List)extCDC, detailForDataElt, kDataAggregateDescription.getName(), false);
            this.segmentCompositionLines.add((PacbaseSegment)detailForDataElt);
        }
        for (EObject da : kDataAggregateDescription.getComponents()) {
            this.doSwitch(da);
        }
    }

    public void caseDataElement(DataElement kDataElement) {
        EY13 linesForDataElt = this.InstanciateEY13();
        linesForDataElt.setPstype(PacbaseSegmentType.DATA_ELEMENT);
        linesForDataElt = this.prepLineDataElt(linesForDataElt, kDataElement);
        this.segmentCompositionLines.add((PacbaseSegment)linesForDataElt);
    }

    public void caseDataElementDescription(DataElementDescription kDataElementDescription) {
        EY13 linesForDataElt = this.InstanciateEY13();
        linesForDataElt.setPstype(PacbaseSegmentType.DATA_ELEMENT_DESCRIPTION);
        linesForDataElt = this.prepLineDataEltNODefined(linesForDataElt, kDataElementDescription);
        this.segmentCompositionLines.add((PacbaseSegment)linesForDataElt);
    }

    public void caseDataUnion(DataUnion kDataUnion) {
        this.doSwitch((EObject)kDataUnion.getDataDescription());
    }

    public void caseDataUnionDescription(DataUnionDescription kDataUnionDescription) {
        Iterator dataComponents = kDataUnionDescription.getRedefines().iterator();
        DataUnionDescription oldDataUnionDescription = null;
        oldDataUnionDescription = this._currentDataUnionDescription;
        boolean isManagingSetOfRedefinesBefore = this.isManagingSetOfRedefines;
        this.isManagingSetOfRedefines = true;
        this.isfirstinSetOfRedefines = true;
        this._currentDataUnionDescription = kDataUnionDescription;
        this.dataUnionDescriptionStack.push(kDataUnionDescription);
        while (dataComponents.hasNext()) {
            DataComponent aDataComponent = (DataComponent)dataComponents.next();
            this.doSwitch((EObject)aDataComponent);
            this.isfirstinSetOfRedefines = false;
            this.isManagingSetOfRedefines = true;
        }
        this.dataUnionDescriptionStack.pop();
        this._currentDataUnionDescription = oldDataUnionDescription;
        this.isManagingSetOfRedefines = this.dataUnionDescriptionStack.isEmpty() ? false : isManagingSetOfRedefinesBefore;
    }

    public void caseDataUnit(DataUnit kDataUnit) {
        int segSelLength = this.getSegSel().length();
        int beg = 0;
        this.listOfSelectedSeg = new ArrayList();
        while (beg < segSelLength) {
            this.listOfSelectedSeg.add(this.getSegSel().substring(beg, beg + 2));
            if (segSelLength <= (beg += 2) || this.getSegSel().charAt(beg) != '=') continue;
            beg += 3;
        }
        for (DataCallImpl aDataCall : kDataUnit.getComponents()) {
            this.doSwitch((EObject)aDataCall);
        }
    }

    public void caseFiller(Filler kDataFiller) {
        this.currentFiller = kDataFiller;
        EY13 linesForDataElt = this.InstanciateEY13();
        linesForDataElt.setPstype(PacbaseSegmentType.FILLER);
        linesForDataElt = this.prepLineFillerDataElt(linesForDataElt, kDataFiller);
        this.segmentCompositionLines.add((PacbaseSegment)linesForDataElt);
    }

    public void casePacDataCall(PacDataCall pPacDataCall) {
        Iterator moreLines = pPacDataCall.getMoreLines().iterator();
        if (moreLines != null) {
            while (moreLines.hasNext()) {
                try {
                    this.doSwitch((EObject)moreLines.next());
                }
                catch (Exception exception) {}
            }
        }
    }

    public void casePacDataElement(PacDataElement pPacDataElement) {
    }

    private EY12 InstanciateEY12() {
        EY12 aEY12 = new EY12();
        PacbaseSegment.GRCLEEY cleEY12 = aEY12.get_GRCLEEY_Groupe_Value();
        cleEY12.set_GRNUTIL_Value("0101");
        cleEY12.set_G2_Value(this.screenCodeToGenerate);
        cleEY12.set_G1_Value("W");
        cleEY12.set_GRG3BIS_Value("A   ");
        cleEY12.set_COCA_Value("H2");
        cleEY12.set_G8_Value("3");
        cleEY12.get_GRG4A7_Groupe_Value().set_G7_Value(this.segmentCodeToUse.substring(0, 2));
        cleEY12.get_GRG9AB_Groupe_Value().set_GRG9_Value(this.segmentCodeToUse.substring(2));
        return aEY12;
    }

    private EY13 InstanciateEY13() {
        EY13 aEY13 = new EY13();
        PacbaseSegment.GRCLEEY cleEY13 = aEY13.get_GRCLEEY_Groupe_Value();
        cleEY13.set_GRNUTIL_Value("0101");
        cleEY13.set_G2_Value(this.screenCodeToGenerate);
        cleEY13.set_G1_Value("W");
        cleEY13.set_GRG3BIS_Value("A   ");
        cleEY13.set_COCA_Value("H2");
        cleEY13.set_G8_Value("3");
        cleEY13.get_GRG4A7_Groupe_Value().set_G7_Value(this.segmentCodeToUse.substring(0, 2));
        cleEY13.get_GRG9AB_Groupe_Value().set_GRG9_Value(this.segmentCodeToUse.substring(2));
        String nbCorubValue = String.valueOf(++this.numberOfCorub);
        String str = "000" + nbCorubValue;
        String nbCorubDigit = str.substring(str.length() - 3);
        cleEY13.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GB_Value(nbCorubDigit);
        return aEY13;
    }

    private EY13 initFromLalDescription(EY13 outputLine) {
        PacbaseLalDescription lal = this.lalList.get(this.numberOfCorub - 1);
        int nivru = lal.getLevel();
        lal.calculateNumbers();
        outputLine.set_CORUB_Value(lal.getName());
        outputLine.set_USAGEI_Value(lal.getUsage());
        outputLine.set_REPET_Value(lal.getOccurs());
        outputLine.get_GRNRURE_Groupe_Value().set_NRUR9_Value(lal.getNbDataElementsInGroup());
        outputLine.set_LORUBI_Value(lal.getInternalLength());
        outputLine.set_LORUBE_Value(lal.getInputLength());
        outputLine.set_PICTUI_Value(lal.getInternalFormat());
        outputLine.set_PICTUE_Value(lal.getInputFormat());
        outputLine.set_NIVRU_Value(nivru);
        outputLine.set_NUMER_Value(outputLine.get_GRCLEEY_Groupe_Value().get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().get_GB_Value());
        outputLine.set_ADRUBI_Value(lal.getInternalAddress());
        outputLine.set_ADRUBE_Value(lal.getInputAddress());
        outputLine.set_GRPICTU_Value(lal.getOutputFormat());
        outputLine.set_LORUBS_Value(lal.getOutputLength());
        outputLine.set_ADRUBS_Value(lal.getOutputAddress());
        outputLine.set_NIVRUR_Value(nivru);
        outputLine.set_GRLIRUB_Value(lal.getLabel());
        outputLine.set_LIRUBC_Value("");
        if (this.isIsServer()) {
            outputLine.set_LIRUBC_Value(lal.getLabel());
        }
        outputLine.set_TYRUB_Value(lal.getTyrub());
        if (this.currentDataCall != null) {
            PacLogicalViewCall pacLogicalViewCall = null;
            EList extensions = this.currentDataCall.getExtensions();
            int i = 0;
            while (i < extensions.size()) {
                Object object = extensions.get(i);
                if (object instanceof PacLogicalViewCall) {
                    pacLogicalViewCall = (PacLogicalViewCall)object;
                    break;
                }
                ++i;
            }
            if (pacLogicalViewCall != null && pacLogicalViewCall.getDataType() != null && !pacLogicalViewCall.getDataType().equals(PacLogicalViewDataTypeValues._NONE_LITERAL)) {
                outputLine.set_INDIC_Value(pacLogicalViewCall.getDataType().getLiteral().substring(1));
            }
        }
        if (lal.getRedefines() && !this.dataUnionDescriptionStack.isEmpty()) {
            DataUnionDescription currentdud = this.dataUnionDescriptionStack.peek();
            DataCall dc = (DataCall)currentdud.getRedefines().get(0);
            String name = "";
            if (dc.getDataDefinition() != null) {
                name = dc.getDataDefinition().getName();
            } else if (dc.getDataDescription() != null) {
                name = dc.getDataDescription().getName();
            }
            outputLine.get_GRCOFIM3_Groupe_Value().get_GRCOLRUB_Groupe_Value().set_CORUM_Value(name);
        }
        this.traitLineDateDataElt(outputLine, lal.getInternalFormat(), lal.getInputFormat());
        return outputLine;
    }

    public void InitDataDescriptionFromDE(DataDescription deDesc, EY13 copyBookDetailForDataElt) {
        char usageDEChar;
        PacPictureParser pp;
        PacDataElementDescription pacded = null;
        Iterator extensions = deDesc.getExtensions().iterator();
        while (extensions.hasNext()) {
            try {
                pacded = (PacDataElementDescription)extensions.next();
            }
            catch (Exception exception) {}
        }
        PacDataElementDescription pacdedPar = null;
        if (pacded.getParent() != null) {
            DataElement parentDataElement = pacded.getParent();
            Iterator extensionsPar = parentDataElement.getDataDescription().getExtensions().iterator();
            while (extensionsPar.hasNext()) {
                try {
                    pacdedPar = (PacDataElementDescription)extensionsPar.next();
                }
                catch (Exception exception) {}
            }
        }
        EY13.GRLIRUB.GRCORTOT lirub = copyBookDetailForDataElt.get_GRLIRUB_Groupe_Value().get_GRCORTOT_Groupe_Value();
        String label = "";
        label = deDesc.getLabel() != null && deDesc.getLabel().trim().length() > 0 ? deDesc.getLabel() : deDesc.getOwner().getLabel();
        if (label.trim() != null && label.trim().length() > 0) {
            if (label.length() > 1) {
                lirub.set_CORADA_Value(label.substring(0, 2));
            }
            if (label.length() > 3) {
                lirub.set_FILLER1_Value(label.substring(2, 4));
            }
        } else if (pacded.getParent() != null && pacded.getParent().getLabel() != null && pacded.getParent().getLabel().trim().length() > 0) {
            if (pacded.getParent().getLabel().trim().length() > 1) {
                lirub.set_CORADA_Value(pacded.getParent().getLabel().substring(0, 2));
            }
            if (pacded.getParent().getLabel().trim().length() > 3) {
                lirub.set_FILLER1_Value(pacded.getParent().getLabel().substring(2, 4));
            }
        }
        EY13.GRPICTU grPictu = copyBookDetailForDataElt.get_GRPICTU_Groupe_Value();
        EY13.GRPICTU.GRPICTUA grPictuA = grPictu.get_GRPICTUA_Groupe_Value();
        String editionFormat = null;
        String format = null;
        if (pacded.getOutputFormat().length() > 0) {
            editionFormat = ExtractUtil.GetCobolPicture((PacDataElementDescription)pacded, (String)OUTPUT_FORMAT, (char)'D');
            format = pacded.getOutputFormat();
        } else if (pacdedPar != null && pacdedPar.getOutputFormat().length() > 0) {
            editionFormat = ExtractUtil.GetCobolPicture((PacDataElementDescription)pacdedPar, (String)OUTPUT_FORMAT, (char)'D');
            format = pacdedPar.getOutputFormat();
        } else {
            char usageDEChar2 = pacded.getInternalUsage().getLiteral().charAt(1);
            editionFormat = ExtractUtil.GetCobolPicture((PacDataElementDescription)pacded, (String)INTERNAL_FORMAT, (char)usageDEChar2);
            format = pacded.getInternalFormat();
        }
        grPictuA.set_PICTUS_Value(editionFormat);
        if (editionFormat.length() > 14) {
            grPictuA.set_PICTUC_Value(editionFormat.substring(14));
        }
        if ((pp = new PacPictureParser(format)).isDate()) {
            copyBookDetailForDataElt.set_DASEPS_Value(format.length() > 1 ? format.substring(1, 2) : " ");
            copyBookDetailForDataElt.set_TYDATS_Value(format.substring(0, 1));
        }
        if (pacded.getInternalFormat().length() > 0) {
            usageDEChar = pacded.getInternalUsage().getLiteral().charAt(1);
            copyBookDetailForDataElt.set_PICTUI_Value(ExtractUtil.GetCobolPicture((PacDataElementDescription)pacded, (String)INTERNAL_FORMAT, (char)usageDEChar));
            format = pacded.getInternalFormat();
        } else if (pacdedPar != null && pacdedPar.getInternalFormat().length() > 0) {
            char usageDECharF = pacded.getInternalUsage().equals(PacDataElementInternalUsageValues._INHERITED_LITERAL) ? pacdedPar.getInternalUsage().getLiteral().charAt(1) : pacded.getInternalUsage().getLiteral().charAt(1);
            copyBookDetailForDataElt.set_PICTUI_Value(ExtractUtil.GetCobolPicture((PacDataElementDescription)pacdedPar, (String)INTERNAL_FORMAT, (char)usageDECharF));
            format = pacdedPar.getInternalFormat();
        }
        pp = new PacPictureParser(format);
        if (pp.isDate()) {
            copyBookDetailForDataElt.set_DASEPI_Value(format.length() > 1 ? format.substring(1, 2) : " ");
            if (!format.substring(0, 1).equals("T")) {
                copyBookDetailForDataElt.set_TYDAT_Value(format.substring(0, 1));
            }
            copyBookDetailForDataElt.set_PICTU2_Value(format.length() < 3 ? format : format.substring(0, 2));
        }
        if (pacded.getInputFormat().length() > 0) {
            copyBookDetailForDataElt.set_PICTUE_Value(ExtractUtil.GetCobolPicture((PacDataElementDescription)pacded, (String)INPUT_FORMAT, (char)'D'));
            format = pacded.getInputFormat();
        } else if (pacdedPar != null && pacdedPar.getInputFormat().length() > 0) {
            copyBookDetailForDataElt.set_PICTUE_Value(ExtractUtil.GetCobolPicture((PacDataElementDescription)pacdedPar, (String)INPUT_FORMAT, (char)'D'));
            format = pacdedPar.getInputFormat();
        } else {
            usageDEChar = pacded.getInternalUsage().getLiteral().charAt(1);
            copyBookDetailForDataElt.set_PICTUE_Value(ExtractUtil.GetCobolPicture((PacDataElementDescription)pacded, (String)INTERNAL_FORMAT, (char)usageDEChar));
            format = pacded.getInternalFormat();
        }
        pp = new PacPictureParser(format);
        if (pp.isDate()) {
            copyBookDetailForDataElt.set_DASEPE_Value(format.length() > 1 ? format.substring(1, 2) : " ");
            copyBookDetailForDataElt.set_TYDATE_Value(format.substring(0, 1));
        }
        copyBookDetailForDataElt.set_LORUBS_Value(String.valueOf(ExtractUtil.GetCobolLength((PacDataElementDescription)pacded, (String)OUTPUT_FORMAT, (char)'D')));
        usageDEChar = pacded.getInternalUsage().getLiteral().charAt(1);
        copyBookDetailForDataElt.set_USAGEI_Value(pacded.getInternalUsage().getLiteral().substring(1));
        copyBookDetailForDataElt.set_LORUBI_Value(String.valueOf(ExtractUtil.GetCobolLength((PacDataElementDescription)pacded, (String)INTERNAL_FORMAT, (char)usageDEChar)));
        copyBookDetailForDataElt.set_LORUBE_Value(String.valueOf(ExtractUtil.GetCobolLength((PacDataElementDescription)pacded, (String)INPUT_FORMAT, (char)'D')));
        String type = PacTransformationDataElementType.transformDataElementType((PacDataElementTypeValues)pacded.getType());
        copyBookDetailForDataElt.set_TYRUB_Value(type);
        if (pacded.getBlkWhenZero().equals(PacBlankWhenZeroValues._TRUE_LITERAL)) {
            copyBookDetailForDataElt.get_GRPICTU_Groupe_Value().set_SUPIC_Value("Z");
        }
        if (pacdedPar != null) {
            if (pacded.getOutputFormat().length() < 1) {
                copyBookDetailForDataElt.set_LORUBS_Value(String.valueOf(ExtractUtil.GetCobolLength((PacDataElementDescription)pacdedPar, (String)OUTPUT_FORMAT, (char)'D')));
            }
            if (pacded.getInternalUsage().equals(PacDataElementInternalUsageValues._INHERITED_LITERAL)) {
                copyBookDetailForDataElt.set_USAGEI_Value(String.valueOf(pacdedPar.getInternalUsage().getLiteral().substring(1)));
            }
            if (pacded.getInternalFormat().length() < 1) {
                char usage = copyBookDetailForDataElt.get_USAGEI_Value().charAt(0);
                copyBookDetailForDataElt.set_LORUBI_Value(String.valueOf(ExtractUtil.GetCobolLength((PacDataElementDescription)pacdedPar, (String)INTERNAL_FORMAT, (char)usage)));
            }
            if (pacded.getInputFormat().length() < 1) {
                copyBookDetailForDataElt.set_LORUBE_Value(String.valueOf(ExtractUtil.GetCobolLength((PacDataElementDescription)pacdedPar, (String)INPUT_FORMAT, (char)'D')));
            }
            type = PacTransformationDataElementType.transformDataElementType((PacDataElementTypeValues)pacdedPar.getType());
            copyBookDetailForDataElt.set_TYRUB_Value(type);
            if (pacded.getBlkWhenZero().equals(PacBlankWhenZeroValues._INHERITED_LITERAL) && pacdedPar.getBlkWhenZero().equals(PacBlankWhenZeroValues._TRUE_LITERAL)) {
                copyBookDetailForDataElt.get_GRPICTU_Groupe_Value().set_SUPIC_Value("Z");
            }
        }
    }

    public ArrayList<PacbaseLalDescription> getLaLList() {
        return this.lalList;
    }

    private DataElement getMotherData() {
        return this.dataElt;
    }

    private static String[] getLabelsFromDataLabel(String label) {
        String[] labels = new String[]{"", ""};
        if (label.trim() != null && label.trim().length() > 0) {
            int end = label.length() < 19 ? label.length() : 18;
            labels[0] = label.substring(0, end);
            if (label.length() > 18) {
                labels[1] = label.substring(18, label.length());
            }
        }
        return labels;
    }

    private PacbaseLinksEntitiesService getPacLinksEntitiesService() {
        return this.ples;
    }

    private char getVariant() {
        return this.variant;
    }

    public List<PacbaseSegment> getSegmentCompositionLines() {
        return this.segmentCompositionLines;
    }

    public void setScreenCodeToGenerate(String screenCode) {
        this.screenCodeToGenerate = screenCode;
    }

    public void setVariantGenerateBibForScreen(String var) {
        this.variantGenerateBib = var;
    }

    public void setDelimGenerateBibForScreen(String del) {
        this.delimGenerateBib = del;
    }

    public void setVariantForEntity(String varE) {
        this.variantForEntity = varE;
    }

    public void setDelimForEntity(String delE) {
        this.delimForEntity = delE;
    }

    public void setSegmentCode(String segmentCode) {
        this.segmentCodeToUse = segmentCode;
    }

    private EY13 prepLineDataElt(EY13 lineForDataElt, DataElement kDataElement) {
        EY13 detailForDataElt = this.initFromLalDescription(lineForDataElt);
        Iterator extensionsA = kDataElement.getExtensions().iterator();
        while (extensionsA.hasNext()) {
            try {
                PacDataElement pde = (PacDataElement)extensionsA.next();
                String variant = pde.getGenerationParameter().getCobolType().getName().substring(1);
                lineForDataElt.set_VARIA_Value(variant);
            }
            catch (Exception exception) {}
        }
        if (this.currentDataCall != null) {
            EList extensions = this.currentDataCall.getExtensions();
            this.updateDataCall((List)extensions, detailForDataElt, kDataElement.getName(), false);
        }
        return detailForDataElt;
    }

    private void traitLineDateDataElt(EY13 lineForDataElt, String internalformat, String inputformat) {
        PacPictureParser pp2;
        PacPictureParser pp1 = new PacPictureParser(internalformat);
        if (pp1.isDate()) {
            lineForDataElt.set_DASEPI_Value(internalformat.length() > 1 ? internalformat.substring(1, 2) : " ");
            if (!internalformat.substring(0, 1).equals("T")) {
                lineForDataElt.set_TYDAT_Value(internalformat.substring(0, 1));
            }
            lineForDataElt.set_PICTU2_Value(internalformat.length() < 3 ? internalformat : internalformat.substring(0, 2));
        }
        if ((pp2 = new PacPictureParser(inputformat)).isDate()) {
            lineForDataElt.set_DASEPE_Value(inputformat.length() > 1 ? inputformat.substring(1, 2) : " ");
            lineForDataElt.set_TYDATE_Value(inputformat.substring(0, 1));
        }
    }

    private EY13 prepLineDataEltNODefined(EY13 lineForDataElt, DataElementDescription DEDescription) {
        EY13 detailForDataElt = this.initFromLalDescription(lineForDataElt);
        detailForDataElt.set_VARIA_Value(String.valueOf(this.getVariant()));
        detailForDataElt.set_GRPICTU_Value(detailForDataElt.get_PICTUI_Value());
        detailForDataElt.set_PICTUE_Value(detailForDataElt.get_PICTUI_Value());
        if (this.currentDataCall != null) {
            EList extensions = this.currentDataCall.getExtensions();
            this.updateDataCall((List)extensions, detailForDataElt, DEDescription.getName(), false);
        }
        return detailForDataElt;
    }

    private EY13 prepLineFillerDataElt(EY13 lineForDataElt, Filler kDataFiller) {
        EY13 detailForDataElt = this.initFromLalDescription(lineForDataElt);
        detailForDataElt.set_VARIA_Value(String.valueOf(this.getVariant()));
        if (this.currentFiller != null && !(this.currentFiller.eContainer().eContainer() instanceof DataAggregate)) {
            EList extensions = this.currentDataCall.getExtensions();
            this.updateDataCall((List)extensions, detailForDataElt, "FILLER", false);
        } else {
            EList extensions = this.currentFiller.getExtensions();
            this.updateFiller((List)extensions, detailForDataElt);
        }
        return detailForDataElt;
    }

    private List getDLines(Iterator extensionsElt) {
        while (extensionsElt.hasNext()) {
            Object obj = extensionsElt.next();
            if (!(obj instanceof PacDataElementImpl)) continue;
            return ((PacDataElementImpl)obj).getDLines();
        }
        return null;
    }

    public void setSegSel(String segSel) {
        this.SEGSEL = segSel != null ? segSel.trim() : "";
    }

    String getSegSel() {
        if (this.SEGSEL == null) {
            this.SEGSEL = "";
        }
        return this.SEGSEL;
    }

    private String searchForColumnLabel(List dLines) {
        String label = "";
        if (dLines != null) {
            int i = 0;
            while (i < dLines.size()) {
                if (((PacDLineImpl)dLines.get(i)).getLineType().equals("C")) {
                    label = ((PacDLineImpl)dLines.get(i)).getDescription();
                }
                ++i;
            }
        }
        return label;
    }

    private void updateDataCall(List extensions, EY13 detailForDataElt, String kDataElementName, boolean isSegmentCalled) {
        String scont;
        String cofim;
        String uptTarget;
        EList extensMoreLine;
        PacDataCall pacDataCall = null;
        PacLogicalViewCall pacLogicalViewCall = null;
        int i = 0;
        while (i < extensions.size()) {
            Object object = extensions.get(i);
            if (object instanceof PacDataCall) {
                pacDataCall = (PacDataCall)object;
                break;
            }
            if (object instanceof PacLogicalViewCall) {
                pacLogicalViewCall = (PacLogicalViewCall)object;
                break;
            }
            ++i;
        }
        if (pacDataCall != null) {
            if (pacDataCall.getSortKey() != null) {
                detailForDataElt.set_INDIC_Value(pacDataCall.getSortKey());
            }
            if (pacDataCall.getPresenceCheck() != null) {
                String ctlCreat = pacDataCall.getPresenceCheck().getInCreation().toString().substring(1);
                String ctlModi = pacDataCall.getPresenceCheck().getInModification().toString().substring(1);
                String ctlDele = pacDataCall.getPresenceCheck().getInDeletion().toString().substring(1);
                String ctlTyp4 = pacDataCall.getPresenceCheck().getInType4().toString().substring(1);
                String ctlTyp5 = pacDataCall.getPresenceCheck().getInType5().toString().substring(1);
                String ctlTyp6 = pacDataCall.getPresenceCheck().getInType6().toString().substring(1);
                if (String.valueOf(ctlCreat).equals("F")) {
                    ctlCreat = " ";
                }
                if (String.valueOf(ctlModi).equals("F")) {
                    ctlModi = " ";
                }
                if (String.valueOf(ctlDele).equals("F")) {
                    ctlDele = " ";
                }
                if (String.valueOf(ctlTyp4).equals("F")) {
                    ctlTyp4 = " ";
                }
                if (String.valueOf(ctlTyp5).equals("F")) {
                    ctlTyp5 = " ";
                }
                if (String.valueOf(ctlTyp6).equals("F")) {
                    ctlTyp6 = " ";
                }
                detailForDataElt.set_STRCO1_Value(ctlCreat);
                detailForDataElt.set_STRCO2_Value(ctlModi);
            }
            PacDataCallMore pacDataCallMor = null;
            extensMoreLine = pacDataCall.getMoreLines();
            if (extensMoreLine != null) {
                boolean isCurrentDataUnion;
                if (extensMoreLine.isEmpty() && !this.dataUnionDescriptionStack.isEmpty() && this.isManagingSetOfRedefines && !this.isfirstinSetOfRedefines && (isCurrentDataUnion = this.verifyNameOfDataUnion(detailForDataElt.get_CORUB_Value(), this._currentDataUnionDescription))) {
                    uptTarget = this.redefines;
                    this.isManagingSetOfRedefines = false;
                    detailForDataElt.get_GRCOFIM3_Groupe_Value().set_COFIM_Value(uptTarget.substring(0, 2));
                }
                Iterator it = extensMoreLine.iterator();
                String originalCopyBookDetail = detailForDataElt.getCompleteContentForSegment();
                boolean firstLine = true;
                if (it.hasNext()) {
                    String result;
                    pacDataCallMor = (PacDataCallMore)it.next();
                    if (this.currentScreen == null) {
                        if (!firstLine) {
                            detailForDataElt = new EY13(originalCopyBookDetail);
                            String numOrdreCS = String.valueOf(this.numberOfCorub);
                            String str = "000" + numOrdreCS;
                            String numOrdreCSDigit = str.substring(str.length() - 3);
                            detailForDataElt.get_GRCLEEY_Groupe_Value().get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GB_Value(numOrdreCSDigit);
                            detailForDataElt.set_NUMER_Value(numOrdreCSDigit);
                            detailForDataElt.set_CORUB_Value("");
                            detailForDataElt.set_PICTUI_Value("");
                            detailForDataElt.set_USAGEI_Value("");
                            detailForDataElt.set_REPET_Value(0);
                            detailForDataElt.set_GRNRURE_Value("00");
                            detailForDataElt.set_LORUBI_Value(0);
                            detailForDataElt.set_LORUBE_Value(0);
                            detailForDataElt.set_LORUBS_Value(0);
                            this.segmentCompositionLines.add((PacbaseSegment)detailForDataElt);
                        } else {
                            firstLine = false;
                        }
                    }
                    detailForDataElt.set_SCONT_Value(pacDataCallMor.getControlType());
                    String VCONCT = pacDataCallMor.getControlValue();
                    detailForDataElt.get_GRVCONT_Groupe_Value().set_CA_Value(VCONCT);
                    if (VCONCT.trim().length() > 0 && (result = this.convertDelimiter(this.delimForEntity, this.variantForEntity, VCONCT)).trim().length() > 0) {
                        detailForDataElt.get_GRVCONT_Groupe_Value().set_CA_Value(result);
                    }
                    String COFIM3 = "";
                    if (pacDataCallMor.getUpdateTarget().trim().length() > 0) {
                        String uptTarget2 = pacDataCallMor.getUpdateTarget().trim();
                        if (!this.dataUnionDescriptionStack.isEmpty() && this.isManagingSetOfRedefines && !this.isfirstinSetOfRedefines && uptTarget2.trim().length() == 0) {
                            uptTarget2 = this.redefines;
                        }
                        this.isManagingSetOfRedefines = false;
                        COFIM3 = this.convertDelimiter(this.delimForEntity, this.variantForEntity, pacDataCallMor.getUpdateTarget());
                        detailForDataElt.get_GRCOFIM3_Groupe_Value().set_COFIM_Value(COFIM3.substring(0, 2));
                        if (pacDataCallMor.getUpdateTarget().trim().length() > 2) {
                            if (pacDataCallMor.getUpdateTarget().trim().length() > 4) {
                                detailForDataElt.get_GRCOFIM3_Groupe_Value().get_GRCOLRUB_Groupe_Value().set_NUENM_Value(COFIM3.substring(2, 4));
                            } else {
                                detailForDataElt.get_GRCOFIM3_Groupe_Value().get_GRCOLRUB_Groupe_Value().set_NUENM_Value(COFIM3.substring(2));
                            }
                            if (pacDataCallMor.getUpdateTarget().trim().length() > 4) {
                                detailForDataElt.get_GRCOFIM3_Groupe_Value().get_GRCOLRUB_Groupe_Value().set_CORUM_Value(COFIM3.substring(4));
                            } else {
                                cofim = detailForDataElt.get_GRCOFIM3_Groupe_Value().get_COFIM_Value();
                                scont = detailForDataElt.get_SCONT_Value();
                                if (!(cofim.equals("Y*") || cofim.equals("C*") || cofim.equals("A*") || scont.equals("W") || scont.equals("C") || scont.equals("R") || scont.equals(INTERNAL_FORMAT) || kDataElementName == null)) {
                                    detailForDataElt.get_GRCOFIM3_Groupe_Value().get_GRCOLRUB_Groupe_Value().set_CORUM_Value(kDataElementName);
                                }
                            }
                        }
                    }
                }
            }
        }
        if (pacLogicalViewCall != null) {
            if (pacLogicalViewCall.getDataType() != null) {
                detailForDataElt.set_INDIC_Value(pacLogicalViewCall.getDataType().getLiteral().substring(1));
                if (pacLogicalViewCall.getDataType().equals(PacLogicalViewDataTypeValues._NONE_LITERAL)) {
                    detailForDataElt.set_INDIC_Value(" ");
                }
            }
            if (pacLogicalViewCall.getPresence() != null) {
                detailForDataElt.set_STRCO2_Value(pacLogicalViewCall.getPresence().getLiteral().substring(1, 2));
                if (pacLogicalViewCall.getPresence().equals(PacLVPresenceCheckValues._NONE_LITERAL)) {
                    detailForDataElt.set_STRCO2_Value(" ");
                }
            }
            PacDataCallMore pacDataCallMor = null;
            extensMoreLine = pacLogicalViewCall.getMoreLines();
            if (extensMoreLine != null) {
                Boolean extensMoreLinesNotUsed = false;
                if (!this.currentDataCall.getExtensions().isEmpty()) {
                    block1: for (Object obj : this.currentDataCall.getExtensions()) {
                        if (!(obj instanceof PacLogicalViewCall)) continue;
                        PacLogicalViewCall lvc = (PacLogicalViewCall)obj;
                        for (PacDataCallMore pacDCallMor : lvc.getMoreLines()) {
                            if (pacDCallMor.getOperator().trim().length() >= 1 || pacDCallMor.getNegation().trim().length() >= 1 || pacDCallMor.getControlType().trim().length() >= 1 || pacDCallMor.getControlValue().trim().length() >= 1 || pacDCallMor.getUpdateTarget().trim().length() >= 1 || !pacDCallMor.getTransferDirection().equals(PacTransferDirectionValues._NONE_LITERAL)) continue;
                            extensMoreLinesNotUsed = true;
                            continue block1;
                        }
                    }
                }
                if ((extensMoreLine.isEmpty() || extensMoreLinesNotUsed.booleanValue()) && !this.dataUnionDescriptionStack.isEmpty() && this.isManagingSetOfRedefines && !this.isfirstinSetOfRedefines) {
                    uptTarget = this.redefines;
                    this.isManagingSetOfRedefines = false;
                    detailForDataElt.get_GRCOFIM3_Groupe_Value().set_COFIM_Value(uptTarget.substring(0, 2));
                }
                Iterator it = extensMoreLine.iterator();
                String originalCopyBookDetail = detailForDataElt.getCompleteContentForSegment();
                boolean firstLine = true;
                while (it.hasNext()) {
                    String result;
                    pacDataCallMor = (PacDataCallMore)it.next();
                    if (this.currentScreen == null) {
                        if (!firstLine) {
                            detailForDataElt = new EY13(originalCopyBookDetail);
                            String numOrdreCS = String.valueOf(this.numberOfCorub);
                            String str = "000" + numOrdreCS;
                            String numOrdreCSDigit = str.substring(str.length() - 3);
                            detailForDataElt.get_GRCLEEY_Groupe_Value().get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GB_Value(numOrdreCSDigit);
                            detailForDataElt.set_NUMER_Value(numOrdreCSDigit);
                            detailForDataElt.set_PICTUI_Value("");
                            detailForDataElt.set_USAGEI_Value("");
                            detailForDataElt.set_REPET_Value(0);
                            detailForDataElt.set_GRNRURE_Value("00");
                            detailForDataElt.set_LORUBI_Value(0);
                            detailForDataElt.set_LORUBE_Value(0);
                            detailForDataElt.set_LORUBS_Value(0);
                            this.segmentCompositionLines.add((PacbaseSegment)detailForDataElt);
                        } else {
                            firstLine = false;
                        }
                    }
                    if (pacDataCallMor.getTransferDirection() != null) {
                        detailForDataElt.set_STRCO1_Value(pacDataCallMor.getTransferDirection().getLiteral().substring(1, 2));
                    }
                    detailForDataElt.set_SCONT_Value(pacDataCallMor.getControlType());
                    String VCONCT = pacDataCallMor.getControlValue();
                    detailForDataElt.get_GRVCONT_Groupe_Value().set_CA_Value(VCONCT);
                    if (VCONCT.trim().length() > 0 && (result = this.convertDelimiter(this.delimForEntity, this.variantForEntity, VCONCT)).trim().length() > 0) {
                        detailForDataElt.get_GRVCONT_Groupe_Value().set_CA_Value(result);
                    }
                    if (pacDataCallMor.getUpdateTarget().trim().length() > 2) {
                        String COFIM3 = "";
                        COFIM3 = this.convertDelimiter(this.delimForEntity, this.variantForEntity, pacDataCallMor.getUpdateTarget());
                        detailForDataElt.get_GRCOFIM3_Groupe_Value().set_COFIM_Value(COFIM3.substring(0, 2));
                        if (pacDataCallMor.getUpdateTarget().trim().length() > 4) {
                            detailForDataElt.get_GRCOFIM3_Groupe_Value().get_GRCOLRUB_Groupe_Value().set_NUENM_Value(COFIM3.substring(2, 4));
                        } else {
                            detailForDataElt.get_GRCOFIM3_Groupe_Value().get_GRCOLRUB_Groupe_Value().set_NUENM_Value(COFIM3.substring(2));
                        }
                        if (pacDataCallMor.getUpdateTarget().trim().length() > 4) {
                            detailForDataElt.get_GRCOFIM3_Groupe_Value().get_GRCOLRUB_Groupe_Value().set_CORUM_Value(COFIM3.substring(4));
                        } else {
                            cofim = detailForDataElt.get_GRCOFIM3_Groupe_Value().get_COFIM_Value();
                            scont = detailForDataElt.get_SCONT_Value();
                            if (!(cofim.equals("Y*") || cofim.equals("C*") || cofim.equals("A*") || scont.equals("W") || scont.equals("C") || scont.equals("R") || scont.equals(INTERNAL_FORMAT) || kDataElementName == null)) {
                                detailForDataElt.get_GRCOFIM3_Groupe_Value().get_GRCOLRUB_Groupe_Value().set_CORUM_Value(kDataElementName);
                            }
                        }
                    }
                    if (this.currentScreen == null || !firstLine || isSegmentCalled) continue;
                    EY13 detailForDataElt1 = new EY13(detailForDataElt.getCompleteContentForSegment());
                    detailForDataElt1.setPstype(detailForDataElt.getPstype());
                    this.segmentCompositionLines.add((PacbaseSegment)detailForDataElt1);
                    firstLine = false;
                }
            }
        }
    }

    public boolean verifyNameOfDataUnion(String nameOfDE, DataUnionDescription kDUDescription) {
        boolean isCurrentDataUnion = false;
        String nameOfDataUnion = "";
        for (Object o : kDUDescription.getRedefines()) {
            if (!(o instanceof DataCall)) {
                if (!(o instanceof Filler) || !"FILLER".equals(nameOfDE.trim())) continue;
                return true;
            }
            DataCall dataCall = (DataCall)o;
            if (dataCall.getDataDescription() != null) {
                nameOfDataUnion = dataCall.getDataDescription().getName();
            } else if (dataCall.getDataDefinition() != null) {
                nameOfDataUnion = dataCall.getDataDefinition().getName();
            }
            if (!nameOfDE.trim().equals(nameOfDataUnion.trim())) continue;
            isCurrentDataUnion = true;
            break;
        }
        return isCurrentDataUnion;
    }

    public void setVariant(char variant) {
        this.variant = variant;
    }

    public void setCurrentScreen(PacScreen currentScreen) {
        this.currentScreen = currentScreen;
    }

    public PacScreen getCurrentScreen() {
        return this.currentScreen;
    }

    public void setCurrentda(DataAggregate currentda) {
        this.currentda = currentda;
    }

    public DataAggregate getCurrentda() {
        return this.currentda;
    }

    private String convertDelimiter(String delimEntity, String variantEntity, String inputField) {
        return PacQuoteConverter.ConvertTextWithTargetDelimiter((String)inputField, (String)delimEntity, (String)variantEntity, (String)this.delimGenerateBib, (String)this.variantGenerateBib);
    }

    private void updateFiller(List extensions, EY13 detailForDataElt) {
        PacFiller pacFiller = null;
        int i = 0;
        while (i < extensions.size()) {
            Object object = extensions.get(i);
            if (object instanceof PacFiller) {
                pacFiller = (PacFiller)object;
                break;
            }
            ++i;
        }
        if (pacFiller != null && pacFiller.getSortKey() != null) {
            detailForDataElt.set_INDIC_Value(pacFiller.getSortKey());
        }
    }

    public void setIsServer(boolean isSvr) {
        this.isServer = isSvr;
    }

    boolean isIsServer() {
        return this.isServer;
    }
}

