/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.generate.dialogclient.generate;

import com.ibm.pdp.mdl.pacbase.PacCELineCategory;
import com.ibm.pdp.mdl.pacbase.PacCELineField;
import com.ibm.pdp.mdl.pacbase.PacCELineLabel;
import com.ibm.pdp.mdl.pacbase.PacCELineScreenCall;
import com.ibm.pdp.mdl.pacbase.PacCSLineDataElementCall;
import com.ibm.pdp.mdl.pacbase.PacCSLineLogicalViewCall;
import com.ibm.pdp.mdl.pacbase.PacCSLineSegmentCall;
import com.ibm.pdp.mdl.pacbase.PacCSLineServerCall;
import com.ibm.pdp.mdl.pacbase.PacGenerationHeader;
import com.ibm.pdp.mdl.pacbase.PacLibrary;
import com.ibm.pdp.mdl.pacbase.PacLibrarySubstitutionGenerationHeader;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.pacbase.generate.dialogServer.generate.PacToW1ModelDialogS;
import com.ibm.pdp.pacbase.generate.dialogclient.generate.EY00PacbaseAndKernelClientVisitor;
import com.ibm.pdp.pacbase.generate.util.PacbaseLinksEntitiesService;
import com.ibm.pdp.pacbase.generate.util.PacbaseModelService;
import com.ibm.pdp.pacbase.util.EBCDICCompare;
import com.ibm.pdp.pacbase.util.extraction.dialog.model.PacbaseSegment;
import com.ibm.pdp.trace.PTTraceManager;
import com.ibm.pdp.util.Util;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

public class PacToW1ModelDialogClient {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private PacScreen referencedScreen;
    private PacScreen generationHeaderScreen;
    private PacLibrary library;
    private String project;
    private File w1ResultFile;
    private EY00PacbaseAndKernelClientVisitor w1pkvisitor;
    private PacbaseLinksEntitiesService ples;
    private String patternName;
    final Comparator<PacbaseSegment> ebcdicCmp = new Comparator<PacbaseSegment>(){

        @Override
        public int compare(PacbaseSegment object1, PacbaseSegment object2) {
            return EBCDICCompare.stringCompare((String)object1.toString().substring(0, 36), (String)object2.toString().substring(0, 36));
        }
    };

    public PacToW1ModelDialogClient(String proj, PacScreen ecran, String patternName) {
        this.project = proj;
        this.patternName = patternName;
        this.generationHeaderScreen = ecran;
        this.initReferencedProgram();
        this.transformToW1Model();
    }

    private void transformToW1Model() {
        this.scanPacbaseModel();
        this.writeTempFile();
    }

    private void scanPacbaseModel() {
        this.w1pkvisitor = new EY00PacbaseAndKernelClientVisitor(this.getPacLinksEntitiesService(), this.generationHeaderScreen);
        this.w1pkvisitor.setNameOfProject(this.project);
        this.w1pkvisitor.doSwitch((EObject)this.library);
        this.w1pkvisitor.doSwitch((EObject)this.generationHeaderScreen);
        this.getPacLinksEntitiesService().setReferencesForMap(true);
        for (Object obj : this.referencedScreen.getCELines()) {
            if (obj instanceof PacCELineCategory) {
                this.w1pkvisitor.doSwitch((EObject)((PacCELineCategory)obj));
                continue;
            }
            if (obj instanceof PacCELineField) {
                this.w1pkvisitor.doSwitch((EObject)((PacCELineField)obj));
                continue;
            }
            if (obj instanceof PacCELineLabel) {
                this.w1pkvisitor.doSwitch((EObject)((PacCELineLabel)obj));
                continue;
            }
            if (obj instanceof PacCELineScreenCall) {
                this.w1pkvisitor.doSwitch((EObject)((PacCELineScreenCall)obj));
                continue;
            }
            PTTraceManager traceManager = PTTraceManager.getInstance();
            int engineTraceLevel = traceManager.getTraceLevel("com.ibm.pdp.pac");
            if (engineTraceLevel <= 0) continue;
            String message = "PacToW1ModelDialogS scanPacbaseModel CEline non d\u00e9finie" + obj.getClass().toString() + " " + String.valueOf(new Date());
            traceManager.trace(PacToW1ModelDialogS.class, "com.ibm.pdp.pac", 1, message);
        }
        this.getPacLinksEntitiesService().setReferencesForMap(false);
        this.w1pkvisitor.writeHCLine();
        this.w1pkvisitor.initializeDatasForCsLines(this.referencedScreen.getCSLines().iterator());
        this.w1pkvisitor.beforeVisitingCSLines();
        for (Object obj : this.referencedScreen.getCSLines()) {
            if (!(obj instanceof PacCSLineServerCall) && !(obj instanceof PacCSLineSegmentCall)) continue;
            if (obj instanceof PacCSLineServerCall) {
                this.w1pkvisitor.doSwitch((EObject)((PacCSLineServerCall)obj));
            }
            if (!(obj instanceof PacCSLineSegmentCall)) continue;
            this.w1pkvisitor.doSwitch((EObject)((PacCSLineSegmentCall)obj));
        }
        this.w1pkvisitor.beforeVisitingCSLines();
        for (Object obj : this.referencedScreen.getCSLines()) {
            if (obj instanceof PacCSLineSegmentCall) {
                this.w1pkvisitor.doSwitch((EObject)((PacCSLineSegmentCall)obj));
                continue;
            }
            if (obj instanceof PacCSLineDataElementCall) {
                this.w1pkvisitor.doSwitch((EObject)((PacCSLineDataElementCall)obj));
                continue;
            }
            if (obj instanceof PacCSLineServerCall) {
                this.w1pkvisitor.doSwitch((EObject)((PacCSLineServerCall)obj));
                continue;
            }
            if (obj instanceof PacCSLineLogicalViewCall) {
                this.w1pkvisitor.doSwitch((EObject)((PacCSLineLogicalViewCall)obj));
                continue;
            }
            PTTraceManager traceManager = PTTraceManager.getInstance();
            int engineTraceLevel = traceManager.getTraceLevel("com.ibm.pdp.pac");
            if (engineTraceLevel <= 0) continue;
            String message = "PacToW1ModelDialogS scanPacbaseModel CSline non d\u00e9finie" + obj.getClass().toString() + " " + String.valueOf(new Date());
            traceManager.trace(PacToW1ModelDialogS.class, "com.ibm.pdp.pac", 1, message);
        }
        this.w1pkvisitor.afterVisitingCSLines();
    }

    public PacbaseLinksEntitiesService getPacLinksEntitiesService() {
        if (this.ples == null) {
            this.ples = new PacbaseLinksEntitiesService(this.patternName);
        }
        return this.ples;
    }

    protected File getW1ResultFile() {
        return this.w1ResultFile;
    }

    private void writeTempFile() {
        this.w1ResultFile = PacbaseModelService.getInstance().createTmpFileForGeneration("clientw1", true);
        if (System.getProperty("DialogGeneration.w1.junit.process") != null) {
            System.setProperty("DialogGeneration.w1.junit.process", this.w1ResultFile.getAbsolutePath());
        }
        try {
            FileWriter fileOutStream1 = new FileWriter(this.w1ResultFile);
            PrintWriter w1OutStream = new PrintWriter(fileOutStream1);
            List<PacbaseSegment> l = this.w1pkvisitor.getScreenLines();
            Collections.sort(l, this.ebcdicCmp);
            for (PacbaseSegment lineX : l) {
                String lineS = lineX.getCompleteContentForSegment().trim();
                w1OutStream.write(lineS + System.getProperty("line.separator"));
            }
            w1OutStream.close();
        }
        catch (Exception e) {
            Util.rethrow((Throwable)e);
        }
    }

    private void initReferencedProgram() {
        PacGenerationHeader generationHeader = this.generationHeaderScreen.getGenerationHeader();
        if (generationHeader != null) {
            if (generationHeader instanceof PacLibrarySubstitutionGenerationHeader) {
                PacLibrarySubstitutionGenerationHeader libSubstHeader = (PacLibrarySubstitutionGenerationHeader)generationHeader;
                this.referencedScreen = (PacScreen)libSubstHeader.getGeneratedRadicalEntity();
                this.library = libSubstHeader.getGenerationParameter();
            }
        } else {
            this.referencedScreen = this.generationHeaderScreen;
            this.library = this.referencedScreen.getGenerationParameter();
        }
    }

    protected boolean getW1OptionForGeneratedMap() {
        return this.w1pkvisitor.getOptionForGeneratedMap();
    }
}

