/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.generate.dialogclient.generate;

import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.macro.pacbase.merge.Merge;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacCPLine;
import com.ibm.pdp.mdl.pacbase.PacGenerationHeader;
import com.ibm.pdp.mdl.pacbase.PacLibrarySubstitutionGenerationHeader;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.mdl.pacbase.util.PacScreenWrapper;
import com.ibm.pdp.pacbase.generate.DefaultPacbaseGenerationImplementation;
import com.ibm.pdp.pacbase.generate.dialogclient.generate.PacToW1ModelDialogClient;
import com.ibm.pdp.pacbase.generate.util.PacbaseLinksEntitiesService;
import com.ibm.pdp.pacbase.generate.util.PacbaseModelService;
import com.ibm.pdp.trace.PTTraceManager;
import com.ibm.pdp.util.Util;
import java.io.File;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.core.resources.ResourcesPlugin;

public class ClientGeneration
extends DefaultPacbaseGenerationImplementation {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String destination;
    private PacScreen screen;
    private PacToW1ModelDialogClient w1Model = null;
    private static String w3CmdFile = isUnix ? "/../../script_linux/GGC35.sh" : "/GGC35.cmd";
    TreeMap<String, List<String>> paramsTable;

    public ClientGeneration(PacScreen ecran, String dest, String macroSource, String patternName, String macroSP) {
        this.screen = new PacScreenWrapper(ecran);
        this.destination = dest;
        this.patternName = patternName;
        this.virtualMacroSource = macroSource;
        this.macroSP_name = macroSP;
        int resolMode = PTEditorService.getResolvingMode();
        PTEditorService.setResolvingMode((int)3);
        this.init();
        PTEditorService.setResolvingMode((int)resolMode);
    }

    private void init() {
        try {
            this.findAndGetW1File();
            this.vapCobolGeneration();
            this.paramsTable = new TreeMap();
            for (Object obj : this.getCPLinesContainerScreen(this.screen).getCPLines()) {
                PacCPLine cpLine;
                if (!(obj instanceof PacCPLine) || (cpLine = (PacCPLine)obj).getMacro().getName().equals(this.macroSP_name)) continue;
                this.paramsTable.put(PacbaseModelService.getInstance().getCPLineIdentifier(cpLine), PacbaseModelService.getInstance().formatCallCP(cpLine));
                this.w1Model.getPacLinksEntitiesService().registerReference((RadicalEntity)cpLine.getMacro());
            }
            String path = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
            Merge merge = new Merge();
            merge.mergeFromFiles(this.cblgenFileName, this.paramsTable, path, "client", (RadicalEntity)this.screen, this.w1Model.getPacLinksEntitiesService(), this.virtualMacroSource);
            if (PTTraceManager.getInstance().getTraceLevel("com.ibm.pdp.pac") > 0) {
                this.writeClbgenAfterMacroCalls(merge.getPublicationResult());
            }
            this.generatedInfo = merge.getNodeTreeConverter((RadicalEntity)this.screen);
            this.genericProblems = merge.getMergeProblems();
            this.ntiList = merge.getNodeTagInformations();
        }
        catch (Exception e) {
            Util.rethrow((Throwable)e);
        }
    }

    private void findAndGetW1File() {
        this.w1Model = new PacToW1ModelDialogClient(this.getProject(), this.getScreen(), this.patternName);
    }

    private String getProject() {
        return this.destination;
    }

    public PacScreen getScreen() {
        return this.screen;
    }

    protected String[] getCommandLineForgenerator() {
        String cblmapFileName;
        String cblFileName;
        String[] cmd = new String[]{"", "", "", "", "", "", "", "", "", ""};
        String userdir1 = PacbaseModelService.getInstance().getCommandFileForGeneration("/data/generator").getAbsolutePath();
        cmd[0] = userdir1 + File.separator + w3CmdFile;
        cmd[1] = userdir1;
        cmd[2] = Util.GetRandomString((int)6);
        String tempdir = System.getProperty("java.io.tmpdir");
        int end = tempdir.length();
        cmd[3] = isUnix ? tempdir : tempdir.substring(0, --end);
        cmd[4] = cblFileName = PacbaseModelService.getInstance().createTmpFileForGeneration("client", ".cbl", true).getAbsolutePath();
        cmd[5] = this.cblgenFileName = PacbaseModelService.getInstance().createTmpFileForGeneration("client", ".cblgen", true).getAbsolutePath();
        this.secondGeneratedFileName = cblmapFileName = PacbaseModelService.getInstance().createTmpFileForGeneration("client", ".map", true).getAbsolutePath();
        cmd[6] = cblmapFileName;
        cmd[7] = this.w1Model.getW1ResultFile().getAbsolutePath();
        String squelLang = "EN";
        if (this.screen != null) {
            squelLang = this.screen.getSkeletonLanguage().getLiteral().substring(1);
        }
        cmd[8] = squelLang;
        cmd[9] = userdir1.substring(0, 2);
        return cmd;
    }

    private PacScreen getCPLinesContainerScreen(PacScreen screen) {
        if (screen == null) {
            return null;
        }
        PacGenerationHeader generationHeader = screen.getGenerationHeader();
        if (generationHeader == null) {
            return screen;
        }
        if (generationHeader instanceof PacLibrarySubstitutionGenerationHeader) {
            PacLibrarySubstitutionGenerationHeader libSubstHeader = (PacLibrarySubstitutionGenerationHeader)generationHeader;
            return (PacScreen)libSubstHeader.getGeneratedRadicalEntity();
        }
        return null;
    }

    public PacbaseLinksEntitiesService getReferencedEntities() {
        return this.w1Model.getPacLinksEntitiesService();
    }

    public boolean getOptionForGeneratedMap() {
        return this.w1Model.getW1OptionForGeneratedMap();
    }
}

