/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.generate.dialogServer.generate;

import com.ibm.pdp.engine.IEngineFactory;
import com.ibm.pdp.engine.IGeneratedInfoFactory;
import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.framework.util.PdpUtil;
import com.ibm.pdp.macro.pacbase.merge.Merge;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacCPLine;
import com.ibm.pdp.mdl.pacbase.PacGenerationHeader;
import com.ibm.pdp.mdl.pacbase.PacLibrarySubstitutionGenerationHeader;
import com.ibm.pdp.mdl.pacbase.PacServer;
import com.ibm.pdp.mdl.pacbase.util.PacServerWrapper;
import com.ibm.pdp.pacbase.generate.DefaultPacbaseGenerationImplementation;
import com.ibm.pdp.pacbase.generate.dialogServer.generate.PacToW1ModelDialogS;
import com.ibm.pdp.pacbase.generate.util.PacbaseLinksEntitiesService;
import com.ibm.pdp.pacbase.generate.util.PacbaseModelService;
import com.ibm.pdp.trace.PTTraceManager;
import com.ibm.pdp.util.PdpConstants;
import com.ibm.pdp.util.Util;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.core.resources.ResourcesPlugin;

public class ServerGeneration
extends DefaultPacbaseGenerationImplementation {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String destination;
    public PacServer server;
    public boolean isProxy = false;
    public PacToW1ModelDialogS w1Model = null;
    protected String cblFileName;
    public static final boolean isUnix = PdpConstants.IS_UNIX_OS;
    private static String w3CmdFile = isUnix ? "/../../script_linux/GGS35.sh" : "/GGS35.cmd";
    TreeMap<String, List<String>> paramsTable;

    public ServerGeneration(PacServer serveur, String dest, boolean isProxy, String macroSource, String patternName, String macroSP) {
        this.isProxy = isProxy;
        this.patternName = patternName;
        this.server = new PacServerWrapper(serveur);
        this.destination = dest;
        this.virtualMacroSource = macroSource;
        this.macroSP_name = macroSP;
        int resolMode = PTEditorService.getResolvingMode();
        PTEditorService.setResolvingMode((int)3);
        this.init();
        PTEditorService.setResolvingMode((int)resolMode);
    }

    private void init() {
        this.findAndGetW1File();
        this.vapCobolGeneration();
        if (!this.isProxy()) {
            this.paramsTable = new TreeMap();
            for (Object obj : this.getCPLinesContainerScreen(this.server).getCPLines()) {
                PacCPLine cpLine;
                if (!(obj instanceof PacCPLine) || (cpLine = (PacCPLine)obj).getMacro().getName().equals(this.macroSP_name)) continue;
                this.paramsTable.put(PacbaseModelService.getInstance().getCPLineIdentifier(cpLine), PacbaseModelService.getInstance().formatCallCP(cpLine));
                this.w1Model.getPacLinksEntitiesService().registerReference((RadicalEntity)cpLine.getMacro());
            }
            PTTraceManager traceManager = PTTraceManager.getInstance();
            int engineTraceLevel = traceManager.getTraceLevel("com.ibm.pdp.pac");
            if (engineTraceLevel > 0) {
                String message = "cblgenFileNAme:" + this.cblgenFileName + "secondGeneratedFileName:" + this.secondGeneratedFileName + "destination:" + this.destination + "package:" + this.server.getPackage() + " " + String.valueOf(new Date());
                traceManager.trace(ServerGeneration.class, "com.ibm.pdp.pac", 1, message);
            }
            String path = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
            Merge merge = new Merge();
            merge.mergeFromFiles(this.cblgenFileName, this.paramsTable, path, "server", (RadicalEntity)this.server, this.w1Model.getPacLinksEntitiesService(), this.virtualMacroSource);
            if (PTTraceManager.getInstance().getTraceLevel("com.ibm.pdp.pac") > 0) {
                this.writeClbgenAfterMacroCalls(merge.getPublicationResult());
            }
            this.generatedInfo = merge.getNodeTreeConverter((RadicalEntity)this.server);
            this.genericProblems = merge.getMergeProblems();
            this.ntiList = merge.getNodeTagInformations();
        } else {
            this.transformToGeneratedInfo();
        }
    }

    private void transformToGeneratedInfo() {
        try {
            String generated = ServerGeneration.ReadFileContents((String)this.cblFileName);
            IEngineFactory engineFactory = PdpUtil.newEngineFactory();
            IGeneratedInfoFactory genInfoFactory = engineFactory.newGeneratedInfoFactory();
            genInfoFactory.beginTag(this.server.getName());
            genInfoFactory.appendText((CharSequence)generated);
            genInfoFactory.endTag();
            this.generatedInfo = genInfoFactory.createGeneratedInfo();
            this.generatedInfo.setProperty("pattern", "com.ibm.pdp.pacbase.csproxy");
            this.generatedInfo.setProperty("Reconcile", "false");
        }
        catch (Exception e) {
            e.printStackTrace();
            Util.rethrow((Throwable)e);
        }
    }

    private void findAndGetW1File() {
        this.w1Model = new PacToW1ModelDialogS(this.getProject(), this.getServer(), this.isProxy(), this.patternName);
    }

    private String getProject() {
        return this.destination;
    }

    public PacServer getServer() {
        return this.server;
    }

    public PacbaseLinksEntitiesService getReferencedEntities() {
        return this.w1Model.getPacLinksEntitiesService();
    }

    protected String[] getCommandLineForgenerator() {
        String[] cmd = new String[]{"", "", "", "", "", "", "", "", "", ""};
        String userdir1 = PacbaseModelService.getInstance().getCommandFileForGeneration("/data/generator").getAbsolutePath();
        cmd[0] = userdir1 + File.separator + w3CmdFile;
        cmd[1] = userdir1;
        cmd[2] = Util.GetRandomString((int)6);
        String tempdir = System.getProperty("java.io.tmpdir");
        int end = tempdir.length();
        cmd[3] = isUnix ? tempdir : tempdir.substring(0, --end);
        cmd[4] = this.cblFileName = PacbaseModelService.getInstance().createTmpFileForGeneration("server", ".cbl", true).getAbsolutePath();
        cmd[5] = this.cblgenFileName = PacbaseModelService.getInstance().createTmpFileForGeneration("server", ".cblgen", true).getAbsolutePath();
        cmd[6] = this.w1Model.getW1ResultFile().getAbsolutePath();
        String squelLang = "EN";
        if (this.server != null) {
            squelLang = this.server.getSkeletonLanguage().getLiteral().substring(1);
        }
        cmd[7] = squelLang;
        cmd[8] = userdir1.substring(0, 2);
        cmd[9] = this.secondGeneratedFileName = PacbaseModelService.getInstance().createTmpFileForGeneration("serverGS", ".cbl", true).getAbsolutePath();
        return cmd;
    }

    private PacServer getCPLinesContainerScreen(PacServer server) {
        if (server == null) {
            return null;
        }
        PacGenerationHeader generationHeader = server.getGenerationHeader();
        if (generationHeader == null) {
            return server;
        }
        if (generationHeader instanceof PacLibrarySubstitutionGenerationHeader) {
            PacLibrarySubstitutionGenerationHeader libSubstHeader = (PacLibrarySubstitutionGenerationHeader)generationHeader;
            return (PacServer)libSubstHeader.getGeneratedRadicalEntity();
        }
        return null;
    }

    boolean isProxy() {
        return this.isProxy;
    }

    void setIsProxy(boolean isProxy) {
        this.isProxy = isProxy;
    }
}

