/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.generate.dialogServer.generate;

import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacAbstractCSLine;
import com.ibm.pdp.mdl.pacbase.PacCSLineDataElementCall;
import com.ibm.pdp.mdl.pacbase.PacCSLineLogicalViewCall;
import com.ibm.pdp.mdl.pacbase.PacCSLineSegmentCall;
import com.ibm.pdp.mdl.pacbase.PacCSLineServerCall;
import com.ibm.pdp.mdl.pacbase.PacGenerationHeader;
import com.ibm.pdp.mdl.pacbase.PacLibrary;
import com.ibm.pdp.mdl.pacbase.PacLibrarySubstitutionGenerationHeader;
import com.ibm.pdp.mdl.pacbase.PacServer;
import com.ibm.pdp.pacbase.generate.dialogServer.generate.EY00PacbaseAndKernelServerVisitor;
import com.ibm.pdp.pacbase.generate.util.PacbaseLinksEntitiesService;
import com.ibm.pdp.pacbase.generate.util.PacbaseModelService;
import com.ibm.pdp.pacbase.util.EBCDICCompare;
import com.ibm.pdp.pacbase.util.extraction.dialog.model.PacbaseSegment;
import com.ibm.pdp.trace.PTTraceManager;
import com.ibm.pdp.util.Util;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

public class PacToW1ModelDialogS {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private PacServer referencedServer;
    private PacServer generationHeaderServer;
    private boolean isProxy;
    private PacLibrary library;
    private String project;
    private File w1ResultFile;
    private EY00PacbaseAndKernelServerVisitor w1pkvisitor;
    private PacbaseLinksEntitiesService ples;
    private String patternName;
    final Comparator<PacbaseSegment> ebcdicCmp = new Comparator<PacbaseSegment>(){

        @Override
        public int compare(PacbaseSegment object1, PacbaseSegment object2) {
            return EBCDICCompare.stringCompare((String)object1.toString().substring(0, 36), (String)object2.toString().substring(0, 36));
        }
    };

    public PacToW1ModelDialogS(String proj, PacServer serveur, boolean isProx, String patternName) {
        this.generationHeaderServer = serveur;
        this.isProxy = isProx;
        this.patternName = patternName;
        this.initReferencedProgram();
        this.transformToW1Model();
    }

    private void transformToW1Model() {
        this.scanPacbaseModel();
        this.writeTempFile();
    }

    private void scanPacbaseModel() {
        this.w1pkvisitor = new EY00PacbaseAndKernelServerVisitor(this.getPacLinksEntitiesService(), (RadicalEntity)this.generationHeaderServer);
        this.w1pkvisitor.setNameOfProject(this.project);
        this.w1pkvisitor.setIsProxy(this.isProxy);
        this.w1pkvisitor.doSwitch((EObject)this.library);
        this.w1pkvisitor.initializeDatasForCsLines(this.referencedServer.getCSLines().iterator());
        this.w1pkvisitor.doSwitch((EObject)this.generationHeaderServer);
        this.w1pkvisitor.beforeVisitingCSLines();
        for (Object obj : this.referencedServer.getCSLines()) {
            if (obj instanceof PacCSLineServerCall || obj instanceof PacCSLineSegmentCall || obj instanceof PacCSLineLogicalViewCall) {
                if (obj instanceof PacCSLineServerCall) {
                    this.w1pkvisitor.doSwitch((EObject)((PacCSLineServerCall)obj));
                    if (((PacCSLineServerCall)obj).getPreviousSegmentCode() != null && ((PacCSLineServerCall)obj).getPreviousSegmentCode().trim().length() > 0) {
                        this.w1pkvisitor.initializeAllCSLinesWithPriorSegm((PacAbstractCSLine)((PacCSLineServerCall)obj));
                    }
                }
                if (obj instanceof PacCSLineSegmentCall) {
                    this.w1pkvisitor.doSwitch((EObject)((PacCSLineSegmentCall)obj));
                    if (((PacCSLineSegmentCall)obj).getPreviousSegmentCode() != null && ((PacCSLineSegmentCall)obj).getPreviousSegmentCode().trim().length() > 0) {
                        this.w1pkvisitor.initializeAllCSLinesWithPriorSegm((PacAbstractCSLine)((PacCSLineSegmentCall)obj));
                    }
                }
                if (obj instanceof PacCSLineLogicalViewCall) {
                    this.w1pkvisitor.doSwitch((EObject)((PacCSLineLogicalViewCall)obj));
                    if (((PacCSLineLogicalViewCall)obj).getPreviousSegmentCode() != null && ((PacCSLineLogicalViewCall)obj).getPreviousSegmentCode().trim().length() > 0) {
                        this.w1pkvisitor.initializeAllCSLinesWithPriorSegm((PacAbstractCSLine)((PacCSLineLogicalViewCall)obj));
                    }
                }
            }
            if (!(obj instanceof PacCSLineDataElementCall)) continue;
            if (((PacCSLineDataElementCall)obj).getPreviousSegmentCode() != null && ((PacCSLineDataElementCall)obj).getPreviousSegmentCode().trim().length() > 0) {
                this.w1pkvisitor.initializeAllCSLinesWithPriorSegm((PacAbstractCSLine)((PacCSLineDataElementCall)obj));
            }
            this.w1pkvisitor.initializePacbaseSegmtLines((PacAbstractCSLine)((PacCSLineDataElementCall)obj));
        }
        this.w1pkvisitor.beforeVisitingCSLines();
        for (Object objCS : this.referencedServer.getCSLines()) {
            if (objCS instanceof PacCSLineDataElementCall) {
                this.w1pkvisitor.doSwitch((EObject)((PacCSLineDataElementCall)objCS));
                continue;
            }
            if (objCS instanceof PacCSLineLogicalViewCall) {
                this.w1pkvisitor.doSwitch((EObject)((PacCSLineLogicalViewCall)objCS));
                continue;
            }
            if (objCS instanceof PacCSLineSegmentCall) {
                this.w1pkvisitor.doSwitch((EObject)((PacCSLineSegmentCall)objCS));
                continue;
            }
            if (objCS instanceof PacCSLineServerCall) {
                this.w1pkvisitor.doSwitch((EObject)((PacCSLineServerCall)objCS));
                continue;
            }
            PTTraceManager traceManager = PTTraceManager.getInstance();
            int engineTraceLevel = traceManager.getTraceLevel("com.ibm.pdp.pac");
            if (engineTraceLevel <= 0) continue;
            String message = "PacToW1ModelDialogS scanPacbaseModel CSline non d\u00e9finie" + objCS.getClass().toString() + " " + String.valueOf(new Date());
            traceManager.trace(PacToW1ModelDialogS.class, "com.ibm.pdp.pac", 1, message);
        }
        this.w1pkvisitor.afterVisitingCSLines();
    }

    public PacbaseLinksEntitiesService getPacLinksEntitiesService() {
        if (this.ples == null) {
            this.ples = new PacbaseLinksEntitiesService(this.patternName);
        }
        return this.ples;
    }

    protected File getW1ResultFile() {
        return this.w1ResultFile;
    }

    private void writeTempFile() {
        this.w1ResultFile = PacbaseModelService.getInstance().createTmpFileForGeneration("serverw1", true);
        if (System.getProperty("DialogServerGeneration.w1.junit.process") != null) {
            System.setProperty("DialogServerGeneration.w1.junit.process", this.w1ResultFile.getAbsolutePath());
        }
        try {
            FileWriter fileOutStream1 = new FileWriter(this.w1ResultFile);
            PrintWriter w1OutStream = new PrintWriter(fileOutStream1);
            List<PacbaseSegment> l = this.w1pkvisitor.getScreenLines();
            Collections.sort(l, this.ebcdicCmp);
            for (PacbaseSegment lineX : l) {
                String lineS = lineX.getCompleteContentForSegment().trim();
                w1OutStream.write(lineS + System.getProperty("line.separator"));
            }
            w1OutStream.close();
        }
        catch (Exception e) {
            Util.rethrow((Throwable)e);
        }
    }

    private void initReferencedProgram() {
        PacGenerationHeader generationHeader = this.generationHeaderServer.getGenerationHeader();
        if (generationHeader != null) {
            if (generationHeader instanceof PacLibrarySubstitutionGenerationHeader) {
                PacLibrarySubstitutionGenerationHeader libSubstHeader = (PacLibrarySubstitutionGenerationHeader)generationHeader;
                this.referencedServer = (PacServer)libSubstHeader.getGeneratedRadicalEntity();
                this.library = libSubstHeader.getGenerationParameter();
            }
        } else {
            this.referencedServer = this.generationHeaderServer;
            this.library = this.referencedServer.getGenerationParameter();
        }
    }
}

