/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.generate.dialog.generate;

import com.ibm.pdp.mdl.pacbase.PacAbstractCSLine;
import com.ibm.pdp.mdl.pacbase.PacCELineCategory;
import com.ibm.pdp.mdl.pacbase.PacCELineField;
import com.ibm.pdp.mdl.pacbase.PacCELineLabel;
import com.ibm.pdp.mdl.pacbase.PacCELineScreenCall;
import com.ibm.pdp.mdl.pacbase.PacCSLineDataElementCall;
import com.ibm.pdp.mdl.pacbase.PacCSLineSegmentCall;
import com.ibm.pdp.mdl.pacbase.PacDialog;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.mdl.pacbase.PacWLineDataElement;
import com.ibm.pdp.mdl.pacbase.PacWLineF;
import com.ibm.pdp.mdl.pacbase.PacWLineText;
import com.ibm.pdp.pacbase.generate.dialog.generate.EY00PacbaseAndKernelVisitor;
import com.ibm.pdp.pacbase.generate.util.PacbaseLinksEntitiesService;
import com.ibm.pdp.pacbase.generate.util.PacbaseModelService;
import com.ibm.pdp.pacbase.util.EBCDICCompare;
import com.ibm.pdp.pacbase.util.extraction.dialog.model.EY2H;
import com.ibm.pdp.pacbase.util.extraction.dialog.model.PacbaseSegment;
import com.ibm.pdp.trace.PTTraceManager;
import com.ibm.pdp.util.Util;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

public class PacToW1ModelDialog {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private PacScreen screen;
    private PacDialog dialog;
    private String project;
    private String _patternName;
    private File w1ResultFile;
    private EY00PacbaseAndKernelVisitor w1pkvisitor;
    private PacbaseLinksEntitiesService ples;
    final Comparator<PacbaseSegment> ebcdicCmp = new Comparator<PacbaseSegment>(){

        @Override
        public int compare(PacbaseSegment object1, PacbaseSegment object2) {
            return EBCDICCompare.stringCompare((String)object1.toString().substring(0, 36), (String)object2.toString().substring(0, 36));
        }
    };

    public PacToW1ModelDialog(String proj, PacScreen ecran, String patternName) {
        this.project = proj;
        this._patternName = patternName;
        this.screen = ecran;
        this.transformToW1Model();
    }

    public PacToW1ModelDialog(String proj, PacDialog dialogue, String patternName) {
        this.project = proj;
        this._patternName = patternName;
        this.dialog = dialogue;
        this.transformToW1ModelDial();
    }

    private void transformToW1Model() {
        this.scanPacbaseModel();
        this.writeTempFile();
    }

    private void transformToW1ModelDial() {
        this.scanPacbaseModelDial();
        this.writeTempFile();
    }

    private void scanPacbaseModel() {
        this.w1pkvisitor = new EY00PacbaseAndKernelVisitor(this.getPacLinksEntitiesService(), this.screen);
        this.w1pkvisitor.setNameOfProject(this.project);
        this.w1pkvisitor.doSwitch((EObject)this.screen.getGenerationParameter());
        this.w1pkvisitor.doSwitch((EObject)this.screen);
        for (Object obj : this.screen.getWLines()) {
            if (obj instanceof PacWLineText) {
                this.w1pkvisitor.doSwitch((EObject)((PacWLineText)obj));
                continue;
            }
            if (obj instanceof PacWLineDataElement) {
                this.w1pkvisitor.doSwitch((EObject)((PacWLineDataElement)obj));
                continue;
            }
            if (!(obj instanceof PacWLineF)) continue;
            this.w1pkvisitor.doSwitch((EObject)((PacWLineF)obj));
        }
        this.getPacLinksEntitiesService().setReferencesForMap(true);
        for (Object obj : this.screen.getCELines()) {
            if (obj instanceof PacCELineCategory) {
                this.w1pkvisitor.doSwitch((EObject)((PacCELineCategory)obj));
                continue;
            }
            if (obj instanceof PacCELineField) {
                this.w1pkvisitor.doSwitch((EObject)((PacCELineField)obj));
                continue;
            }
            if (obj instanceof PacCELineLabel) {
                this.w1pkvisitor.doSwitch((EObject)((PacCELineLabel)obj));
                continue;
            }
            if (obj instanceof PacCELineScreenCall) {
                this.w1pkvisitor.doSwitch((EObject)((PacCELineScreenCall)obj));
                continue;
            }
            PTTraceManager traceManager = PTTraceManager.getInstance();
            int engineTraceLevel = traceManager.getTraceLevel("com.ibm.pdp.pac");
            if (engineTraceLevel <= 0) continue;
            String message = "PacToW1ModelDialog scanPacbaseModel CEline non d\u00e9finie" + obj.getClass().toString() + " " + String.valueOf(new Date());
            traceManager.trace(PacToW1ModelDialog.class, "com.ibm.pdp.pac", 1, message);
        }
        this.getPacLinksEntitiesService().setReferencesForMap(false);
        this.w1pkvisitor.initializeDatasForCsLines(this.screen.getCSLines().iterator());
        this.w1pkvisitor.beforeVisitingCSLines();
        for (Object obj : this.screen.getCSLines()) {
            if (obj instanceof PacCSLineSegmentCall) {
                this.w1pkvisitor.doSwitch((EObject)((PacCSLineSegmentCall)obj));
                this.w1pkvisitor.initializeAllPacCSLine((PacAbstractCSLine)((PacCSLineSegmentCall)obj));
                this.w1pkvisitor.initializeAllCSLines((PacAbstractCSLine)((PacCSLineSegmentCall)obj));
            }
            if (!(obj instanceof PacCSLineDataElementCall)) continue;
            this.w1pkvisitor.initializeAllPacCSLine((PacAbstractCSLine)((PacCSLineDataElementCall)obj));
            this.w1pkvisitor.initializeAllCSLines((PacAbstractCSLine)((PacCSLineDataElementCall)obj));
        }
        this.w1pkvisitor.beforeVisitingCSLines();
        for (Object obj : this.screen.getCSLines()) {
            if (obj instanceof PacCSLineSegmentCall) {
                this.w1pkvisitor.doSwitch((EObject)((PacCSLineSegmentCall)obj));
                continue;
            }
            if (obj instanceof PacCSLineDataElementCall) {
                this.w1pkvisitor.doSwitch((EObject)((PacCSLineDataElementCall)obj));
                continue;
            }
            PTTraceManager traceManager = PTTraceManager.getInstance();
            int engineTraceLevel = traceManager.getTraceLevel("com.ibm.pdp.pac");
            if (engineTraceLevel <= 0) continue;
            String message = "PacToW1ModelDialog scanPacbaseModel CSline non d\u00e9finie" + obj.getClass().toString() + " " + String.valueOf(new Date());
            traceManager.trace(PacToW1ModelDialog.class, "com.ibm.pdp.pac", 1, message);
        }
        this.w1pkvisitor.afterVisitingCSLines();
    }

    private void scanPacbaseModelDial() {
        this.w1pkvisitor = new EY00PacbaseAndKernelVisitor(this.getPacLinksEntitiesService(), this.dialog);
        this.w1pkvisitor.setNameOfProject(this.project);
        this.w1pkvisitor.doSwitch((EObject)this.dialog.getGenerationParameter());
        this.w1pkvisitor.doSwitch((EObject)this.dialog);
        this.w1pkvisitor.initializeDatasForCsLines(this.dialog.getCSLines().iterator());
        this.w1pkvisitor.beforeVisitingCSLines();
        for (Object obj : this.dialog.getCSLines()) {
            if (!(obj instanceof PacCSLineSegmentCall)) continue;
            this.w1pkvisitor.doSwitch((EObject)((PacCSLineSegmentCall)obj));
        }
        this.w1pkvisitor.beforeVisitingCSLines();
        for (Object obj : this.dialog.getCSLines()) {
            if (obj instanceof PacCSLineSegmentCall) {
                this.w1pkvisitor.doSwitch((EObject)((PacCSLineSegmentCall)obj));
                continue;
            }
            if (obj instanceof PacCSLineDataElementCall) {
                this.w1pkvisitor.doSwitch((EObject)((PacCSLineDataElementCall)obj));
                continue;
            }
            PTTraceManager traceManager = PTTraceManager.getInstance();
            int engineTraceLevel = traceManager.getTraceLevel("com.ibm.pdp.pac");
            if (engineTraceLevel <= 0) continue;
            String message = "PacToW1ModelDialog scanPacbaseModelDial CSline non d\u00e9finie" + obj.getClass().toString() + " " + String.valueOf(new Date());
            traceManager.trace(PacToW1ModelDialog.class, "com.ibm.pdp.pac", 1, message);
        }
        this.w1pkvisitor.afterVisitingCSLines();
    }

    public PacbaseLinksEntitiesService getPacLinksEntitiesService() {
        if (this.ples == null) {
            this.ples = new PacbaseLinksEntitiesService(this._patternName);
        }
        return this.ples;
    }

    protected File getW1ResultFile() {
        return this.w1ResultFile;
    }

    protected boolean getW1OptionForGeneratedMap() {
        return this.w1pkvisitor.getOptionForGeneratedMap();
    }

    private void writeTempFile() {
        this.w1ResultFile = PacbaseModelService.getInstance().createTmpFileForGeneration("screenw1", true);
        if (System.getProperty("DialogGeneration.w1.junit.process") != null) {
            System.setProperty("DialogGeneration.w1.junit.process", this.w1ResultFile.getAbsolutePath());
        }
        try {
            FileWriter fileOutStream1 = new FileWriter(this.w1ResultFile);
            PrintWriter w1OutStream = new PrintWriter(fileOutStream1);
            List<PacbaseSegment> l = this.w1pkvisitor.getScreenLines();
            Collections.sort(l, this.ebcdicCmp);
            Iterator<PacbaseSegment> listToWrite = l.iterator();
            String previousLine = "";
            while (listToWrite.hasNext()) {
                PacbaseSegment lineX = listToWrite.next();
                String lineS = lineX.getCompleteContentForSegment().trim();
                if (!previousLine.equals(lineS) || this.isLineToWriteInAllCases(lineX)) {
                    w1OutStream.write(lineS + System.getProperty("line.separator"));
                }
                previousLine = lineS;
            }
            w1OutStream.close();
        }
        catch (Exception e) {
            Util.rethrow((Throwable)e);
        }
    }

    private boolean isLineToWriteInAllCases(PacbaseSegment line) {
        if (line instanceof EY2H) {
            EY2H ey2hLine = (EY2H)line;
            return ey2hLine.get_GRCLEEY_Groupe_Value().get_COCA_Value().equals("H2") && ey2hLine.get_GRCLEEY_Groupe_Value().get_G1_Value().equals("W");
        }
        return false;
    }
}

