/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.generate.dialog.generate;

import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.macro.pacbase.merge.Merge;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacCPLine;
import com.ibm.pdp.mdl.pacbase.PacDialog;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.mdl.pacbase.util.PacDialogWrapper;
import com.ibm.pdp.mdl.pacbase.util.PacScreenWrapper;
import com.ibm.pdp.pacbase.generate.DefaultPacbaseGenerationImplementation;
import com.ibm.pdp.pacbase.generate.dialog.generate.PacToW1ModelDialog;
import com.ibm.pdp.pacbase.generate.util.PacbaseLinksEntitiesService;
import com.ibm.pdp.pacbase.generate.util.PacbaseModelService;
import com.ibm.pdp.trace.PTTraceManager;
import com.ibm.pdp.util.Util;
import java.io.File;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.core.resources.ResourcesPlugin;

public class DialogGeneration
extends DefaultPacbaseGenerationImplementation {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String destination;
    private PacScreen screen;
    private PacDialog dialog;
    private PacToW1ModelDialog w1Model = null;
    private static String w3CmdFile = isUnix ? "/../../script_linux/GCO35.sh" : "/GCO35.cmd";
    TreeMap<String, List<String>> paramsTable;

    public DialogGeneration(PacScreen ecran, String dest, String macroSource, String patternName, String macroSP) {
        this.screen = new PacScreenWrapper(ecran);
        this.destination = dest;
        this.patternName = patternName;
        this.virtualMacroSource = macroSource;
        this.macroSP_name = macroSP;
        int resolMode = PTEditorService.getResolvingMode();
        PTEditorService.setResolvingMode((int)3);
        this.init();
        PTEditorService.setResolvingMode((int)resolMode);
    }

    public DialogGeneration(PacDialog dialogue, String dest, String macroSource, String patternName, String macroSPname) {
        this.dialog = new PacDialogWrapper(dialogue);
        this.destination = dest;
        this.patternName = patternName;
        this.virtualMacroSource = macroSource;
        int resolMode = PTEditorService.getResolvingMode();
        PTEditorService.setResolvingMode((int)3);
        this.init();
        PTEditorService.setResolvingMode((int)resolMode);
    }

    private void init() {
        this.findAndGetW1File();
        this.vapCobolGeneration();
        if (this.screen != null || this.dialog != null) {
            this.paramsTable = new TreeMap();
            Iterator cpLinesIterator = null;
            cpLinesIterator = this.screen != null ? this.screen.getCPLines().iterator() : this.dialog.getCPLines().iterator();
            while (cpLinesIterator.hasNext()) {
                PacCPLine cpLine;
                Object obj = cpLinesIterator.next();
                if (!(obj instanceof PacCPLine) || (cpLine = (PacCPLine)obj).getMacro().getName().equals(this.macroSP_name)) continue;
                this.paramsTable.put(PacbaseModelService.getInstance().getCPLineIdentifier(cpLine), PacbaseModelService.getInstance().formatCallCP(cpLine));
                this.w1Model.getPacLinksEntitiesService().registerReference((RadicalEntity)cpLine.getMacro());
            }
            PTTraceManager traceManager = PTTraceManager.getInstance();
            int engineTraceLevel = traceManager.getTraceLevel("com.ibm.pdp.pac");
            if (engineTraceLevel > 0 && this.screen != null) {
                String message = "cblgenFileNAme:" + this.cblgenFileName + "secondGeneratedFileName:" + this.secondGeneratedFileName + "destination:" + this.destination + "package:" + this.screen.getPackage() + " " + String.valueOf(new Date());
                traceManager.trace(DialogGeneration.class, "com.ibm.pdp.pac", 1, message);
            }
            String path = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
            Merge merge = new Merge();
            if (this.screen != null) {
                merge.mergeFromFiles(this.cblgenFileName, this.paramsTable, path, "dialog", (RadicalEntity)this.screen, this.w1Model.getPacLinksEntitiesService(), this.virtualMacroSource);
            } else {
                merge.mergeFromFiles(this.cblgenFileName, this.paramsTable, path, "dialog", (RadicalEntity)this.dialog, this.w1Model.getPacLinksEntitiesService(), this.virtualMacroSource);
            }
            if (PTTraceManager.getInstance().getTraceLevel("com.ibm.pdp.pac") > 0) {
                this.writeClbgenAfterMacroCalls(merge.getPublicationResult());
            }
            this.generatedInfo = merge.getNodeTreeConverter((RadicalEntity)(this.screen != null ? this.screen : this.dialog));
            this.genericProblems = merge.getMergeProblems();
            this.ntiList = merge.getNodeTagInformations();
        }
    }

    private void findAndGetW1File() {
        this.w1Model = this.getScreen() != null ? new PacToW1ModelDialog(this.getProject(), this.getScreen(), this.patternName) : new PacToW1ModelDialog(this.getProject(), this.getDialog(), this.patternName);
    }

    public PacbaseLinksEntitiesService getReferencedEntities() {
        return this.w1Model.getPacLinksEntitiesService();
    }

    private String getProject() {
        return this.destination;
    }

    public PacScreen getScreen() {
        return this.screen;
    }

    public PacDialog getDialog() {
        return this.dialog;
    }

    protected String[] getCommandLineForgenerator() {
        String cblFileName;
        String[] cmd = new String[]{"", "", "", "", "", "", "", "", "", ""};
        String userdir1 = PacbaseModelService.getInstance().getCommandFileForGeneration("/data/generator").getAbsolutePath();
        cmd[0] = userdir1 + File.separator + w3CmdFile;
        cmd[1] = userdir1;
        cmd[2] = Util.GetRandomString((int)6);
        String tempdir = System.getProperty("java.io.tmpdir");
        int end = tempdir.length();
        cmd[3] = isUnix ? tempdir : tempdir.substring(0, --end);
        cmd[4] = cblFileName = PacbaseModelService.getInstance().createTmpFileForGeneration("screen", ".cbl", true).getAbsolutePath();
        cmd[5] = this.cblgenFileName = PacbaseModelService.getInstance().createTmpFileForGeneration("screen", ".cblgen", true).getAbsolutePath();
        cmd[6] = this.secondGeneratedFileName = PacbaseModelService.getInstance().createTmpFileForGeneration("screen", ".map", true).getAbsolutePath();
        cmd[7] = this.w1Model.getW1ResultFile().getAbsolutePath();
        String squelLang = "EN";
        squelLang = this.screen != null ? this.screen.getSkeletonLanguage().getLiteral().substring(1) : this.dialog.getSkeletonLanguage().getLiteral().substring(1);
        cmd[8] = squelLang;
        cmd[9] = userdir1.substring(0, 2);
        return cmd;
    }

    public boolean getOptionForGeneratedMap() {
        return this.w1Model.getW1OptionForGeneratedMap();
    }
}

