/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.generate.CELine;

import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.kernel.DataElement;
import com.ibm.pdp.mdl.kernel.DataUnit;
import com.ibm.pdp.mdl.kernel.KernelPackage;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacAbstractCELine;
import com.ibm.pdp.mdl.pacbase.PacCELineCategory;
import com.ibm.pdp.mdl.pacbase.PacCELineField;
import com.ibm.pdp.mdl.pacbase.PacCELineFieldComplement;
import com.ibm.pdp.mdl.pacbase.PacCELineFieldIndicator;
import com.ibm.pdp.mdl.pacbase.PacCELineLabel;
import com.ibm.pdp.mdl.pacbase.PacCELineScreenCall;
import com.ibm.pdp.mdl.pacbase.PacCobolTypeValues;
import com.ibm.pdp.mdl.pacbase.PacColorAttributeValues;
import com.ibm.pdp.mdl.pacbase.PacDLine;
import com.ibm.pdp.mdl.pacbase.PacDataAggregate;
import com.ibm.pdp.mdl.pacbase.PacDataElement;
import com.ibm.pdp.mdl.pacbase.PacDataElementDescription;
import com.ibm.pdp.mdl.pacbase.PacDataElementInternalUsageValues;
import com.ibm.pdp.mdl.pacbase.PacDataUnit;
import com.ibm.pdp.mdl.pacbase.PacDialog;
import com.ibm.pdp.mdl.pacbase.PacDialogTypeValues;
import com.ibm.pdp.mdl.pacbase.PacIntensityAttributeValues;
import com.ibm.pdp.mdl.pacbase.PacLabelPresentationValues;
import com.ibm.pdp.mdl.pacbase.PacLibrary;
import com.ibm.pdp.mdl.pacbase.PacMapTypeValues;
import com.ibm.pdp.mdl.pacbase.PacPresentationAttributeValues;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.mdl.pacbase.PacScreenActionCodeValues;
import com.ibm.pdp.mdl.pacbase.PacScreenFieldNatureValues;
import com.ibm.pdp.mdl.pacbase.PacScreenFieldTypeValues;
import com.ibm.pdp.mdl.pacbase.PacScreenLabelNatureValues;
import com.ibm.pdp.mdl.pacbase.PacScreenPositionTypeValues;
import com.ibm.pdp.mdl.pacbase.PacScreenPresenceCheckValues;
import com.ibm.pdp.mdl.pacbase.PacScreenSourceTypeValues;
import com.ibm.pdp.mdl.pacbase.PacScreenUpdateOptionValues;
import com.ibm.pdp.mdl.pacbase.PacbasePackage;
import com.ibm.pdp.mdl.pacbase.lal.util.converter.PacDateFormat;
import com.ibm.pdp.mdl.pacbase.lal.util.converter.PacNumericFormat;
import com.ibm.pdp.pacbase.generate.CELine.CELineFieldIM;
import com.ibm.pdp.pacbase.generate.CELine.VariableForCELine;
import com.ibm.pdp.pacbase.generate.dialog.generate.EY00PacbaseAndKernelVisitor;
import com.ibm.pdp.pacbase.generate.dialog.generate.PictureParserForCELines;
import com.ibm.pdp.pacbase.generate.dialogcs.generate.SegmentCompositionPacbaseAndKernelVisitor;
import com.ibm.pdp.pacbase.generate.util.PacbaseLinksEntitiesService;
import com.ibm.pdp.pacbase.generate.util.PacbaseModelService;
import com.ibm.pdp.pacbase.util.PacQuoteConverter;
import com.ibm.pdp.pacbase.util.extraction.dialog.model.EY13;
import com.ibm.pdp.pacbase.util.extraction.dialog.model.EY1I;
import com.ibm.pdp.pacbase.util.extraction.dialog.model.EY22;
import com.ibm.pdp.pacbase.util.extraction.dialog.model.PacbaseSegment;
import com.ibm.pdp.trace.PTTraceManager;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class CELineVisitor {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final PacbasePackage modelPackagePB = PacbasePackage.eINSTANCE;
    protected static final KernelPackage modelPackageKernel = KernelPackage.eINSTANCE;
    private VariableForCELine varCELine;
    public static final char DISPLAY_USAGE = 'D';
    public static final String INTERNAL_FORMAT = "I";
    public static final String INPUT_FORMAT = "E";
    public static final String OUTPUT_FORMAT = "S";
    public static final char VARIANT = 'X';
    public static final String S_PRESENCECHECK = "_S";
    public static final String F_PRESENCECHECK = "_F";
    public static final String N_PRESENCECHECK = "_N";
    public static final String O_PRESENCECHECK = "O";
    public static final String P_PRESENCECHECK = "P";
    public PacScreen currentScreen;
    public PacDialog currentDialog;
    public PacbaseLinksEntitiesService ples;

    public CELineVisitor(VariableForCELine varCEline, PacbaseLinksEntitiesService pl, RadicalEntity re) {
        this.varCELine = varCEline;
        this.ples = pl;
    }

    public void doSwitch(EObject theEObject) {
        this.doSwitch(theEObject.eClass(), theEObject);
    }

    protected void doSwitch(EClass theEClass, EObject theEObject) {
        if (theEObject instanceof RadicalEntity) {
            this.getPacLinksEntitiesService().registerReference((RadicalEntity)theEObject);
        }
        if (theEClass.eContainer() == modelPackagePB) {
            this.doSwitchPB(theEClass.getClassifierID(), theEObject);
        } else if (theEClass.eContainer() == modelPackageKernel) {
            this.doSwitchKernel(theEClass.getClassifierID(), theEObject);
        }
    }

    protected void doSwitchKernel(int classifierID, EObject theEObject) {
        PTTraceManager traceManager = PTTraceManager.getInstance();
        int engineTraceLevel = traceManager.getTraceLevel("com.ibm.pdp.pac");
        if (engineTraceLevel > 0) {
            String message = "Kernel case not defined: " + theEObject.getClass().toString() + " " + String.valueOf(new Date());
            traceManager.trace(EY00PacbaseAndKernelVisitor.class, "com.ibm.pdp.pac", 1, message);
        }
    }

    protected void doSwitchPB(int classifierID, EObject theEObject) {
        switch (classifierID) {
            case 76: {
                PacCELineCategory pacbaseObject = (PacCELineCategory)theEObject;
                this.casePacCELineCategory(pacbaseObject);
                break;
            }
            case 78: {
                PacCELineField pacbaseObject = (PacCELineField)theEObject;
                if (pacbaseObject.getDataElement() != null) {
                    this.getPacLinksEntitiesService().registerReference((RadicalEntity)pacbaseObject.getDataElement());
                }
                this.casePacCELineField(pacbaseObject);
                break;
            }
            case 75: {
                PacCELineLabel pacbaseObject = (PacCELineLabel)theEObject;
                if (pacbaseObject.getDataElement() != null) {
                    this.getPacLinksEntitiesService().registerReference((RadicalEntity)pacbaseObject.getDataElement());
                } else if (pacbaseObject.getScreen() != null && pacbaseObject.getScreen() != this.currentScreen) {
                    this.getPacLinksEntitiesService().registerReference((RadicalEntity)pacbaseObject.getScreen());
                }
                this.casePacCELineLabel(pacbaseObject);
                break;
            }
            case 77: {
                PacCELineScreenCall pacbaseObject = (PacCELineScreenCall)theEObject;
                if (pacbaseObject.getScreen() != null && pacbaseObject.getScreen() != this.currentScreen) {
                    this.getPacLinksEntitiesService().registerReference((RadicalEntity)pacbaseObject.getScreen());
                }
                this.casePacCELineScreenCall(pacbaseObject);
                break;
            }
            default: {
                PTTraceManager traceManager = PTTraceManager.getInstance();
                int engineTraceLevel = traceManager.getTraceLevel("com.ibm.pdp.pac");
                if (engineTraceLevel <= 0) break;
                String message = "Pacbase case not defined: " + theEObject.getClass().toString() + " " + String.valueOf(new Date());
                traceManager.trace(EY00PacbaseAndKernelVisitor.class, "com.ibm.pdp.pac", 1, message);
            }
        }
    }

    private void casePacCELineCategory(PacCELineCategory aPacCElineCat) {
        this.varCELine.priorDELength = 0;
        this.varCELine.priorDELengthLabel = 0;
        boolean noIncrementNulig = false;
        this.varCELine.absolutePositionForCateg = false;
        this.varCELine.numLineForAbsoluteLabelInCategR = 0;
        this.varCELine.currentPacCELineCategory = aPacCElineCat;
        this.varCELine.currentCategory = String.valueOf(aPacCElineCat.getCategoryNature()).substring(1);
        this.varCELine.currentLabelPresentationCategory = String.valueOf(aPacCElineCat.getLabelPresentation()).substring(1);
        this.varCELine.currentLabelPresentationCategoryValue = String.valueOf(aPacCElineCat.getLabelPresentation());
        this.varCELine.firstCELineIsField = false;
        this.varCELine.firstCELineIsLabel = false;
        try {
            this.varCELine.numLabel = this.isColumnLabelNeeded(aPacCElineCat) ? Integer.parseInt(this.varCELine.currentLabelPresentationCategory) : 0;
        }
        catch (NumberFormatException numberFormatException) {
            this.varCELine.numLabel = 0;
        }
        if (aPacCElineCat.getVerticalRepetition() > 1 && this.varCELine.currentCategory.equals("R")) {
            this.varCELine.nbVerticalRepet = aPacCElineCat.getVerticalRepetition();
            if (this.varCELine.currentCategory.equals("R")) {
                this.varCELine.repetVerticalCateg = true;
            }
        } else {
            this.varCELine.nbVerticalRepet = 1;
        }
        this.varCELine.nbHorizontalRepet = aPacCElineCat.getHorizontalRepetition() > 1 && this.varCELine.currentCategory.equals("R") ? aPacCElineCat.getHorizontalRepetition() : 1;
        if (this.varCELine.screenCalled && this.varCELine.currentCategory.equals("R") && this.varCELine.repetVerticalCateg) {
            this.varCELine.incrementNuligAfterCategRinScrenCalled = true;
            this.varCELine.screenCalledForCategR = this.varCELine.currentNameForCalledScreen;
        }
        if (this.varCELine.screenCalled && this.varCELine.currentCategory.equals("Z") && this.varCELine.screenCalledForCategR != null && this.varCELine.currentNameForCalledScreen.equals(this.varCELine.screenCalledForCategR)) {
            this.varCELine.incrementNuligAfterCategRinScrenCalled = false;
        }
        if (this.varCELine.currentCategory.equals("Z") && this.varCELine.priorCategory != null && this.varCELine.priorCategory.equals("R") && this.varCELine.repetVerticalCateg && !this.varCELine.incrementNuligAfterCategRinScrenCalled) {
            noIncrementNulig = true;
            if (this.varCELine.incrementNuligForPFKEY) {
                --this.varCELine.currentNulig;
            }
        }
        if (!noIncrementNulig) {
            ++this.varCELine.currentNulig;
        }
        if (this.varCELine.currentCategory.equals("R") && this.varCELine.nbHorizontalRepet > 1 && aPacCElineCat.getLinePosition() > 0) {
            ++this.varCELine.currentNBHorizontalLine;
        }
        boolean lineNumberForScreenCalledModified = false;
        if (String.valueOf(aPacCElineCat.getPositionType()).substring(1).equals("A")) {
            this.varCELine.absolutePositionForCateg = true;
            String linePosValue = String.valueOf(aPacCElineCat.getLinePosition());
            String strLine = "00" + linePosValue;
            String linePos = strLine.substring(strLine.length() - 2);
            this.varCELine.linePositionASave = String.valueOf(linePos);
            String columnPosValue = String.valueOf(aPacCElineCat.getColumnPosition());
            String strColumn = "000" + columnPosValue;
            String columnPos = strColumn.substring(strColumn.length() - 3);
            this.varCELine.columnPositionASave = String.valueOf(columnPos);
            if (this.varCELine.screenCalled && this.varCELine.currentCategory.equals("R") && this.varCELine.lineNumberForScreenCalled > 1) {
                int numLinecategR = Integer.parseInt(this.varCELine.linePositionASave);
                int numLinecategRInScreenCalled = this.varCELine.lineNumberForScreenCalled + numLinecategR - 1;
                String linePosValue1 = String.valueOf(numLinecategRInScreenCalled);
                String strLine1 = "00" + linePosValue1;
                String numLinecategRInScreenCalledS = strLine1.substring(strLine1.length() - 2);
                this.varCELine.linePositionASave = String.valueOf(numLinecategRInScreenCalledS);
                lineNumberForScreenCalledModified = true;
            }
        } else if (String.valueOf(aPacCElineCat.getPositionType()).equals("_None")) {
            if (aPacCElineCat.getLinePosition() > 0) {
                this.varCELine.columnPositionASave = "000";
                if (this.varCELine.currentLabelPresentationCategory != null && !this.varCELine.currentLabelPresentationCategory.equals("None") && (this.varCELine.currentLabelPresentationCategory.trim().equals("1") || this.varCELine.currentLabelPresentationCategory.trim().equals("2") || this.varCELine.currentLabelPresentationCategory.trim().equals("3"))) {
                    this.varCELine.linePositionASave = String.valueOf(Integer.parseInt(this.varCELine.linePositionASave) + Integer.parseInt(this.varCELine.currentLabelPresentationCategory));
                }
            }
            if (this.varCELine.currentCategory.equals("Z")) {
                int nblineToAdd;
                int linePositionASaveNew;
                if (!(this.varCELine.priorCategory == null && this.varCELine.firstCELineFieldForCateg && aPacCElineCat.getLinePosition() <= 0 && aPacCElineCat.getColumnPosition() <= 0 || Integer.parseInt(this.varCELine.currentLine) <= Integer.parseInt(this.varCELine.linePositionASave))) {
                    this.varCELine.linePositionASave = this.varCELine.currentLine;
                }
                if (this.varCELine.repetHorizontalCateg && (linePositionASaveNew = (nblineToAdd = this.varCELine.maxNumberOfVerticalLineForRepetCateg * this.varCELine.numberOfRepeatForRepetCateg) + Integer.parseInt(this.varCELine.linePositionASaveCateg) - 1) > Integer.parseInt(this.varCELine.linePositionASave)) {
                    this.varCELine.linePositionASave = String.valueOf(linePositionASaveNew);
                }
                if (this.varCELine.firstLineForScreenCalled) {
                    this.varCELine.columnPositionASave = "000";
                }
            }
            String linePosValueNew = String.valueOf(Integer.parseInt(this.varCELine.linePositionASave) + aPacCElineCat.getLinePosition());
            String strLineNew = "00" + linePosValueNew;
            String linePosNew = strLineNew.substring(strLineNew.length() - 2);
            String colPosValueNew = String.valueOf(Integer.parseInt(this.varCELine.columnPositionASave) + aPacCElineCat.getColumnPosition());
            String strColNew = "000" + colPosValueNew;
            String colPosNew = strColNew.substring(strColNew.length() - 3);
            this.varCELine.linePositionASave = String.valueOf(linePosNew);
            this.varCELine.columnPositionASave = String.valueOf(colPosNew);
        }
        this.varCELine.linePositionASaveCategInitial = Integer.parseInt(this.varCELine.linePositionASave);
        if (this.varCELine.currentCategory.equals("R")) {
            this.varCELine.linePositionASaveCategRInitial = this.varCELine.linePositionASaveCategInitial;
        }
        if (this.varCELine.currentCategory.equals("Z")) {
            this.varCELine.linePositionASaveCategZInitial = this.varCELine.linePositionASaveCategInitial;
        }
        if (this.varCELine.currentCategory.equals("R") && this.varCELine.numLabel > 0) {
            this.varCELine.numLineSave = this.varCELine.linePositionASave = String.valueOf(Integer.parseInt(this.varCELine.linePositionASave) - this.varCELine.numLabel);
            this.varCELine.firstNumLineSave = this.varCELine.linePositionASave;
        }
        if (Integer.parseInt(this.varCELine.linePositionASave) >= Integer.parseInt(this.varCELine.maxiLineNumberForScreen)) {
            this.varCELine.linePositionASave = this.varCELine.maxiLineNumberForScreen;
        }
        if (this.varCELine.currentCategory.equals("R") && this.varCELine.numLabel == 0) {
            this.varCELine.numLineSave = this.varCELine.linePositionASave;
        }
        this.varCELine.initialColumnASaveCateg = aPacCElineCat.getColumnPosition();
        EY1I CELineCat = new EY1I();
        PacbaseSegment.GRCLEEY cleEY1I = CELineCat.get_GRCLEEY_Groupe_Value();
        cleEY1I.set_GRNUTIL_Value("0101");
        cleEY1I.set_G2_Value(this.currentScreen.getName());
        cleEY1I.set_G1_Value("W");
        cleEY1I.set_COCA_Value("I ");
        String linePosValueCat = this.varCELine.linePositionASave;
        if (String.valueOf(aPacCElineCat.getPositionType()).substring(1).equals("A") && !lineNumberForScreenCalledModified) {
            linePosValueCat = String.valueOf(aPacCElineCat.getLinePosition());
        }
        if (this.varCELine.currentCategory.equals("R") && !this.varCELine.absolutePositionForCateg && this.varCELine.currentLabelPresentationCategory != null && !this.varCELine.currentLabelPresentationCategory.equals("None") && (this.varCELine.currentLabelPresentationCategory.trim().equals("1") || this.varCELine.currentLabelPresentationCategory.trim().equals("2") || this.varCELine.currentLabelPresentationCategory.trim().equals("3"))) {
            linePosValueCat = String.valueOf(this.varCELine.linePositionASaveCategInitial);
        }
        String strLineCat = "00" + linePosValueCat;
        String linePosCat = strLineCat.substring(strLineCat.length() - 2);
        if (this.varCELine.currentCategory.equals("Z")) {
            if (aPacCElineCat.getLinePosition() == 0 && aPacCElineCat.getColumnPosition() == 0) {
                String linePosValueNew = String.valueOf(this.varCELine.linePositionASaveCategInitial);
                String strLineNew = "00" + linePosValueNew;
                String linePosNew = strLineNew.substring(strLineNew.length() - 2);
                linePosCat = String.valueOf(linePosNew);
            } else {
                linePosCat = this.varCELine.linePositionASave;
            }
        }
        String colPosValueCat = this.varCELine.columnPositionASave;
        String strColCat = "000" + colPosValueCat;
        String colPosCat = strColCat.substring(strColCat.length() - 3);
        if (this.varCELine.currentCategory.equals("R") || this.varCELine.currentCategory.equals("Z")) {
            if (aPacCElineCat.getColumnPosition() == 0) {
                this.varCELine.columnPositionASave = colPosCat = "001";
            } else {
                int col = Integer.parseInt(this.varCELine.columnPositionASave) - 1;
                String ScolPosCat = "000" + String.valueOf(col);
                colPosCat = ScolPosCat.substring(ScolPosCat.length() - 3);
            }
            if (this.varCELine.currentCategory.equals("Z") && aPacCElineCat.getLinePosition() == 0 && aPacCElineCat.getColumnPosition() == 0) {
                colPosCat = "080";
                this.varCELine.columnPositionASave = "000";
            }
        }
        this.varCELine.currentColumnPositionASaveCateg = colPosCat;
        cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_G4_Value(linePosCat);
        cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_GRG5A6_Groupe_Value().set_G5_Value(colPosCat);
        cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_GRG5A6_Groupe_Value().set_G6BIS_Value(this.varCELine.currentCategory);
        cleEY1I.get_GRG4A7_Groupe_Value().set_G7_Value("00");
        String strNulig = "000" + this.varCELine.currentNulig;
        String Nulig3 = strNulig.substring(strNulig.length() - 3);
        cleEY1I.get_GRG9AB_Groupe_Value().set_GRG9_Value(Nulig3);
        CELineCat.set_NARUE_Value(this.varCELine.currentCategory);
        CELineCat.set_TLIB_Value("R");
        CELineCat.set_CORUB_Value(aPacCElineCat.getCategoryName());
        if (aPacCElineCat.getHorizontalRepetition() < 1) {
            CELineCat.set_REPETH_Value("01");
        } else {
            CELineCat.set_REPETH_Value(aPacCElineCat.getHorizontalRepetition());
        }
        if (aPacCElineCat.getVerticalRepetition() < 1) {
            CELineCat.set_REPETV_Value("01");
        } else {
            CELineCat.set_REPETV_Value(aPacCElineCat.getVerticalRepetition());
        }
        CELineCat.set_REPET9_Value("000000");
        CELineCat.set_NIVST_Value("00");
        CELineCat.set_ICAT_Value(this.varCELine.currentCategory);
        CELineCat.set_NULIG_Value(this.varCELine.currentNulig);
        this.varCELine.screenLines.add((PacbaseSegment)CELineCat);
        CELineCat = new EY1I(CELineCat.getCompleteContentForSegment());
        cleEY1I = CELineCat.get_GRCLEEY_Groupe_Value();
        cleEY1I.set_COCA_Value("I1");
        cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_G4_Value("  ");
        cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_GRG5A6_Groupe_Value().set_G5_Value("   ");
        this.varCELine.screenLines.add((PacbaseSegment)CELineCat);
        CELineCat = new EY1I(CELineCat.getCompleteContentForSegment());
        cleEY1I = CELineCat.get_GRCLEEY_Groupe_Value();
        cleEY1I.get_GRG3BIS_Groupe_Value().set_G3_Value("D");
        cleEY1I.set_COCA_Value("H4");
        cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_G4_Value(this.varCELine.currentCategory);
        String cosega = String.valueOf(CELineCat.get_GRZSOURA_Groupe_Value().get_GRCOSEGA_Groupe_Value());
        cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_GRG5A6_Value(cosega);
        if (this.currentScreen.getDialogType().equals(PacDialogTypeValues._NONE_LITERAL) && (this.varCELine.currentCategory.equals("Z") || this.varCELine.currentCategory.equals("R")) && (this.varCELine.dialogComplement.get_GROPTION_Groupe_Value().get_XNOREP_Value().equals("0") || aPacCElineCat.getVerticalRepetition() <= 1 && aPacCElineCat.getHorizontalRepetition() <= 1)) {
            this.varCELine.screenLines.add((PacbaseSegment)CELineCat);
        }
        this.varCELine.linePositionASaveCateg = this.varCELine.linePositionASave;
        this.varCELine.columnPositionASaveCateg = this.varCELine.columnPositionASave;
        this.varCELine.firstCELineFieldForCateg = false;
        this.varCELine.rankCELineLabelForCateg = 0;
        this.varCELine.maxNumberOfVerticalLineForRepetCateg = 1;
        if (this.varCELine.currentCategory.equals("R")) {
            int numberOfLineToRepet = 1;
            Iterator ceLinesIterator = this.currentScreen.getCELines().iterator();
            if (this.varCELine.screenCalled && this.varCELine.calledScreen.getName().equals(this.varCELine.currentNameForCalledScreen)) {
                ceLinesIterator = this.varCELine.calledScreen.getCELines().iterator();
            }
            String categForVerif = "";
            this.varCELine.changeLineWithColumnLabel = false;
            while (ceLinesIterator.hasNext()) {
                PacCELineCategory SPacCElineCategory;
                String categBasEcran;
                Object obj = ceLinesIterator.next();
                if (obj instanceof PacCELineCategory) {
                    PacCELineCategory BPacCElineCategory = (PacCELineCategory)obj;
                    categForVerif = String.valueOf(BPacCElineCategory.getCategoryNature()).substring(1);
                    if (aPacCElineCat.getHorizontalRepetition() > 0 && categForVerif.equals("R")) {
                        this.varCELine.maxNumberOfVerticalLine1 = this.varCELine.maxNumberOfVerticalLine = aPacCElineCat.getHorizontalRepetition();
                        this.varCELine.maxNumberOfVerticalLineForRepetCateg = this.varCELine.maxNumberOfVerticalLine;
                        this.varCELine.numberOfRepeatForRepetCateg = aPacCElineCat.getVerticalRepetition();
                        this.varCELine.repetHorizontalCateg = true;
                    }
                    if (categForVerif.equals("Z")) break;
                }
                if (!categForVerif.equals("R")) continue;
                if (obj instanceof PacCELineField) {
                    PacCELineField SPacCElineField = (PacCELineField)obj;
                    if (String.valueOf(SPacCElineField.getPositionType()).substring(1).equals("A") && SPacCElineField.getLinePosition() < Integer.parseInt(this.varCELine.linePositionASaveCateg)) break;
                    if (!String.valueOf(SPacCElineField.getPositionType()).substring(1).equals("A")) {
                        numberOfLineToRepet += SPacCElineField.getLinePosition();
                    }
                    if (!this.varCELine.repetHorizontalCateg || this.varCELine.repetHorizontalCateg && numberOfLineToRepet > this.varCELine.maxNumberOfVerticalLine || String.valueOf(SPacCElineField.getPositionType()).substring(1).equals("A")) {
                        this.searchForVerticalRepetition(SPacCElineField);
                        numberOfLineToRepet = this.varCELine.maxNumberOfVerticalLine;
                    }
                }
                if (obj instanceof PacCELineLabel) {
                    PacCELineLabel SPacCElineLabel = (PacCELineLabel)obj;
                    if (String.valueOf(SPacCElineLabel.getPositionType()).substring(1).equals("A") && SPacCElineLabel.getLinePosition() < Integer.parseInt(this.varCELine.linePositionASaveCateg)) break;
                    if (!String.valueOf(SPacCElineLabel.getPositionType()).substring(1).equals("A")) {
                        numberOfLineToRepet += SPacCElineLabel.getLinePosition();
                    }
                    if (!this.varCELine.repetHorizontalCateg || this.varCELine.repetHorizontalCateg && numberOfLineToRepet > this.varCELine.maxNumberOfVerticalLine || String.valueOf(SPacCElineLabel.getPositionType()).substring(1).equals("A")) {
                        this.searchForVerticalRepetition(SPacCElineLabel);
                        numberOfLineToRepet = this.varCELine.maxNumberOfVerticalLine;
                    }
                }
                if (obj instanceof PacCELineCategory && (categBasEcran = String.valueOf((SPacCElineCategory = (PacCELineCategory)obj).getCategoryNature()).substring(1)).equals("Z") || obj instanceof PacCELineScreenCall) break;
            }
            if (this.varCELine.maxNumberOfVerticalLine1 > this.varCELine.maxNumberOfVerticalLine) {
                this.varCELine.maxNumberOfVerticalLine = this.varCELine.maxNumberOfVerticalLine1;
            }
            if (this.varCELine.repetHorizontalCateg && this.varCELine.maxNumberOfVerticalLineForRepetCateg > this.varCELine.maxNumberOfVerticalLine) {
                this.varCELine.maxNumberOfVerticalLine = this.varCELine.maxNumberOfVerticalLineForRepetCateg;
            }
        }
        if (this.varCELine.currentCategory.equals("Z")) {
            this.varCELine.firstCELineLabelForCategZ = true;
            this.varCELine.firstCELineFieldOrLabelForCategZ = 1;
        }
        this.varCELine.priorCategory = this.varCELine.currentCategory;
        this.varCELine.firstCElineForScreen = false;
        this.varCELine.incrementNuligForPFKEY = false;
    }

    private void casePacCELineScreenCall(PacCELineScreenCall aPacCElineScreen) {
        boolean noIncrementNuligSC = false;
        if (this.varCELine.priorCategory != null && this.varCELine.priorCategory.equals("R") && this.varCELine.repetVerticalCateg && !this.varCELine.incrementNuligAfterCategRinScrenCalled) {
            noIncrementNuligSC = true;
        }
        if (!noIncrementNuligSC) {
            ++this.varCELine.currentNulig;
        }
        this.varCELine.calledScreen = aPacCElineScreen.getScreen();
        this.varCELine.currentNameForCalledScreen = this.varCELine.calledScreen.getName();
        this.varCELine.linePositionASaveScreen = "001";
        this.varCELine.columnPositionASaveScreen = "00";
        this.varCELine.firstLineLabelForScreenCalled = true;
        this.varCELine.firstLineForScreenCalled = true;
        this.varCELine.screenCalled = true;
        this.varCELine.positionmentTypeForScreenCalled = "";
        String saveLabelPresentationScreen = this.varCELine.currentLabelPresentationScreen;
        String saveLabelPresentationDialog = this.varCELine.currentLabelPresentationDialog;
        RadicalEntity objD = PacbaseModelService.SearchRadicalEntityDuringGeneration((RadicalEntity)this.varCELine.getGenerationEntryPoint(), (String)this.varCELine.calledScreen.getName().substring(0, 2), (String)"pacdialog", (PacbaseLinksEntitiesService)this.ples);
        if (objD instanceof PacDialog) {
            this.varCELine.calledDialog = (PacDialog)objD;
            this.varCELine.currentLabelPresentationDialog = String.valueOf(this.varCELine.calledDialog.getLabelPresentation());
        }
        this.varCELine.currentLabelPresentationScreen = String.valueOf(this.varCELine.calledScreen.getLabelPresentation());
        if (String.valueOf(aPacCElineScreen.getPositionType()).substring(1).equals("A")) {
            this.varCELine.positionmentTypeForScreenCalled = "A";
            this.varCELine.currentTabulPoint = 1;
            String linePosValue = String.valueOf(aPacCElineScreen.getLinePosition());
            String strLine = "00" + linePosValue;
            String linePos = strLine.substring(strLine.length() - 2);
            this.varCELine.linePositionASave = String.valueOf(linePos);
            String columnPosValue = String.valueOf(aPacCElineScreen.getColumnPosition());
            String strColumn = "000" + columnPosValue;
            String columnPos = strColumn.substring(strColumn.length() - 3);
            this.varCELine.columnPositionASave = String.valueOf(columnPos);
            if (aPacCElineScreen.getColumnPosition() == 0) {
                this.varCELine.columnPositionASave = "002";
            }
        } else {
            String strColNew;
            int numLineC;
            int numLine = Integer.parseInt(this.varCELine.linePositionASave);
            String strLineNew = "00" + (numLine += aPacCElineScreen.getLinePosition());
            this.varCELine.linePositionASave = strLineNew.substring(strLineNew.length() - 2);
            if (aPacCElineScreen.getLinePosition() == 0 && (this.varCELine.firstScreenCalledHandled || Integer.parseInt(this.varCELine.linePositionASave) > 1) && !this.varCELine.absolutePositionForCateg) {
                int numLineA = Integer.parseInt(this.varCELine.linePositionASave);
                String strLineNewA = "00" + ++numLineA;
                this.varCELine.linePositionASave = strLineNewA.substring(strLineNewA.length() - 2);
            }
            if (aPacCElineScreen.getColumnPosition() > 0) {
                if (Integer.parseInt(this.varCELine.columnPositionASaveCateg) > 1 && !String.valueOf(aPacCElineScreen.getColumnPosition()).equals(this.varCELine.columnPositionASaveCateg)) {
                    numLineC = Integer.parseInt(this.varCELine.columnPositionASave);
                    strColNew = "00" + (numLineC += aPacCElineScreen.getColumnPosition());
                    this.varCELine.columnPositionASave = strColNew.substring(strColNew.length() - 2);
                }
            } else {
                this.varCELine.columnPositionASave = Integer.parseInt(this.varCELine.columnPositionASave) > 1 ? "002" : "001";
                if (aPacCElineScreen.getLinePosition() == 0 && aPacCElineScreen.getColumnPosition() == 0) {
                    this.varCELine.columnPositionASave = "001";
                }
            }
            if (aPacCElineScreen.getLinePosition() > 0 && aPacCElineScreen.getColumnPosition() > 0) {
                numLineC = aPacCElineScreen.getColumnPosition();
                strColNew = "00" + numLineC;
                this.varCELine.columnPositionASave = strColNew.substring(strColNew.length() - 2);
            }
        }
        this.varCELine.absoluteNumberLine = Integer.parseInt(this.varCELine.linePositionASave);
        this.varCELine.currentLine = this.varCELine.linePositionASave;
        this.varCELine.linePositionASaveScreen = this.varCELine.linePositionASave;
        this.varCELine.columnPositionASaveScreen = this.varCELine.columnPositionASave;
        if (this.varCELine.currentCategory != null && this.varCELine.currentCategory.equals("R") && this.varCELine.repetVerticalCateg && Integer.parseInt(this.varCELine.linePositionASaveScreen) >= Integer.parseInt(this.varCELine.linePositionASaveCateg)) {
            ++this.varCELine.currentNulig;
        }
        this.varCELine.lineNumberForScreenCalled = aPacCElineScreen.getLinePosition();
        this.varCELine.columnNumberForScreenCalled = aPacCElineScreen.getColumnPosition();
        for (Object obj : this.varCELine.calledScreen.getCELines()) {
            if (obj instanceof PacCELineCategory) {
                this.doSwitch((EObject)((PacCELineCategory)obj));
            } else if (obj instanceof PacCELineField) {
                this.doSwitch((EObject)((PacCELineField)obj));
                PacCELineField aPacCElineField = (PacCELineField)obj;
                if (this.currentScreen.getDialogType().equals(PacDialogTypeValues._NONE_LITERAL)) {
                    this.formatCElineFieldSpecificStandartScreen(aPacCElineField);
                } else {
                    this.formatCElineFieldSpecificClientScreen(aPacCElineField, this.varCELine.currentCategory);
                }
            } else if (obj instanceof PacCELineLabel) {
                this.doSwitch((EObject)((PacCELineLabel)obj));
                this.varCELine.firstLineLabelForScreenCalled = false;
            } else if (obj instanceof PacCELineScreenCall) {
                ++this.varCELine.currentNulig;
            }
            this.varCELine.firstLineForScreenCalled = false;
        }
        this.varCELine.nbVerticalRepet = 1;
        this.varCELine.numberOfRepeatForRepetCateg = 1;
        this.varCELine.repetVerticalCateg = false;
        this.varCELine.screenCalled = false;
        this.varCELine.firstLineLabelForScreenCalled = false;
        this.varCELine.firstLineForScreenCalled = false;
        this.varCELine.firstScreenCalledHandled = true;
        this.varCELine.currentLabelPresentationScreen = saveLabelPresentationScreen;
        this.varCELine.currentLabelPresentationDialog = saveLabelPresentationDialog;
        this.varCELine.firstCElineForScreen = false;
    }

    private void casePacCELineField(PacCELineField aPacCElineField) {
        if (this.varCELine.currentCategory.equals("R") && aPacCElineField.getPositionType().equals(PacScreenPositionTypeValues._A_LITERAL) && Integer.parseInt(this.varCELine.linePositionASaveCateg) > aPacCElineField.getLinePosition()) {
            this.varCELine.endRepeatCateg = true;
        }
        if (this.varCELine.currentCategory.equals("R") && this.varCELine.firstCELineFieldForCateg && !this.varCELine.firstCELineIsLabel) {
            this.varCELine.firstCELineIsField = true;
        }
        if (this.varCELine.currentCategory.equals("R") && this.varCELine.absolutePositionForCateg && Integer.parseInt(this.varCELine.columnPositionASaveCateg) > 1 && aPacCElineField.getLinePosition() > 0) {
            this.varCELine.columnPositionASave = this.varCELine.columnPositionASaveCateg;
        }
        if (this.varCELine.currentCategory.equals("R") && this.varCELine.absolutePositionForCateg && Integer.parseInt(this.varCELine.columnPositionASaveCateg) > 1 && aPacCElineField.getLinePosition() > 0 && aPacCElineField.getColumnPosition() == 0) {
            this.varCELine.columnPositionASave = String.valueOf(Integer.parseInt(this.varCELine.columnPositionASaveCateg) + 1);
        }
        this.varCELine.currentLabelPresentationField = aPacCElineField.getLabelPresentation().getLiteral();
        this.varCELine.modifyValue = false;
        this.varCELine.endRepeatCategS = this.varCELine.endRepeatCateg;
        this.varCELine.maxNumberOfVerticalLineForRepetCategS = this.varCELine.maxNumberOfVerticalLineForRepetCateg;
        this.varCELine.maxNumberOfVerticalLineS = this.varCELine.maxNumberOfVerticalLine;
        this.varCELine.repetHorizontalCategS = this.varCELine.repetHorizontalCateg;
        this.varCELine.currentCategoryS = this.varCELine.currentCategory;
        this.varCELine.numLabelS = this.varCELine.numLabel;
        this.varCELine.currentLabelPresentationFieldS = this.varCELine.currentLabelPresentationField;
        if (this.varCELine.repetHorizontalCateg && this.varCELine.nbHorizontalRepet == 1 && this.varCELine.nbVerticalRepet == 1) {
            int linePositionASaveCategI = Integer.parseInt(this.varCELine.linePositionASaveCateg);
            if (!this.varCELine.endRepeatCateg && aPacCElineField.getLinePosition() == linePositionASaveCategI) {
                this.varCELine.modifyValue = true;
                this.varCELine.endRepeatCateg = true;
                this.varCELine.maxNumberOfVerticalLineForRepetCateg = 1;
                this.varCELine.maxNumberOfVerticalLine = 1;
                this.varCELine.repetHorizontalCateg = false;
                this.varCELine.numLabel = 0;
                this.varCELine.currentLabelPresentationField = aPacCElineField.getLabelPresentation().getLiteral();
            }
        }
        CELineFieldIM psCELine = new CELineFieldIM(aPacCElineField, this.varCELine);
        this.varCELine.screenLines = psCELine.instantiateIM_Line(this.varCELine.screenLines, this.currentDialog, this.currentScreen, this.ples);
        this.varCELine.CELine = psCELine.getCELine();
        this.varCELine.currentLine = this.varCELine.CELine.get_GRCLEEY_Groupe_Value().get_GRG4A7_Groupe_Value().get_G7_Value();
        int valueToTestSpecificForClient = 0;
        if (this.currentScreen.getDialogType().equals(PacDialogTypeValues._NONE_LITERAL)) {
            valueToTestSpecificForClient = 1;
        }
        if (this.varCELine.currentCategory.equals("R") && this.varCELine.maxNumberOfVerticalLine > valueToTestSpecificForClient) {
            this.varCELine.currentLineInTheFirstVerticalGroup = Integer.parseInt(this.varCELine.G7IM);
            if (aPacCElineField.getLinePosition() > 0) {
                this.varCELine.linePositionASave = String.valueOf(this.varCELine.currentLineInTheFirstVerticalGroup);
                if (this.varCELine.firstNumLineSave != null && this.varCELine.numLabel > 1 && !this.varCELine.currentLabelPresentationField.equals("_U")) {
                    this.varCELine.linePositionASave = String.valueOf(this.varCELine.firstNumLineSave);
                }
                this.varCELine.numLineSave = this.varCELine.linePositionASave;
            }
        }
        if (Integer.parseInt(this.varCELine.linePositionASave) >= Integer.parseInt(this.varCELine.maxiLineNumberForScreen)) {
            this.varCELine.linePositionASave = this.varCELine.maxiLineNumberForScreen;
        }
        if (this.varCELine.currentLabelPresentationField.equals(F_PRESENCECHECK)) {
            this.varCELine.priorDELengthLabel = 0;
        }
        if (this.varCELine.currentCategory.equals("RepetOnDataElt")) {
            this.varCELine.currentCategory = "";
            this.varCELine.nbVerticalRepet = 1;
        }
        this.varCELine.IMSPASWD = false;
        this.varCELine.CELine = this.instantiateW_I1(this.varCELine.CELine, this.varCELine.G7IM, this.varCELine.G91IM, this.varCELine.EY1IICAT, this.varCELine.EY1INULIG, aPacCElineField);
        this.varCELine.incrementNuligForPFKEY = false;
    }

    private void casePacCELineLabel(PacCELineLabel aPacCElineLab) {
        ++this.varCELine.rankCELineLabelForCateg;
        String columnSaveBeforeVerticalLabelRep = "0";
        int currentLineLabelInTheFirstVerticalGroup = 0;
        String linePosValueNewSave = null;
        if (this.varCELine.currentCategory.equals("Z") && !this.varCELine.firstCELineForCategZ) {
            this.varCELine.firstCELineForCategZ = true;
        }
        EY1I CELine = new EY1I();
        ++this.varCELine.currentNulig;
        PacbaseSegment.GRCLEEY cleEY1I = CELine.get_GRCLEEY_Groupe_Value();
        cleEY1I.set_GRNUTIL_Value("0101");
        cleEY1I.set_G2_Value(this.currentScreen.getName());
        cleEY1I.set_G1_Value("M");
        cleEY1I.set_COCA_Value("I ");
        if (this.varCELine.currentCategory.equals("R") && aPacCElineLab.getLinePosition() > 0) {
            this.varCELine.priorDELengthLabel = 0;
        }
        if (this.varCELine.currentCategory.equals("R") && !this.varCELine.firstCELineFieldForCateg && !this.varCELine.firstCELineIsField) {
            this.varCELine.firstCELineIsLabel = true;
        }
        if (String.valueOf(aPacCElineLab.getPositionType()).substring(1).equals("A")) {
            this.varCELine.priorDELength = 0;
            this.varCELine.priorDELengthLabel = 0;
            String linePosValue = "00";
            this.varCELine.currentTabulPoint = 1;
            linePosValue = String.valueOf(aPacCElineLab.getLinePosition());
            if (this.varCELine.screenCalled) {
                int ajoutLigneSC = aPacCElineLab.getLinePosition();
                if (ajoutLigneSC > 0 && Integer.parseInt(this.varCELine.linePositionASaveScreen) > 0) {
                    --ajoutLigneSC;
                }
                linePosValue = String.valueOf(Integer.parseInt(this.varCELine.linePositionASaveScreen) + ajoutLigneSC);
            }
            int intLinePositionASave = Integer.parseInt(this.varCELine.linePositionASave);
            if (Integer.parseInt(linePosValue) != intLinePositionASave) {
                this.varCELine.oldLinePosition = intLinePositionASave;
            }
            String strLine = "00" + linePosValue;
            String linePos = strLine.substring(strLine.length() - 2);
            this.varCELine.linePositionASave = String.valueOf(linePos);
            if ((String.valueOf(aPacCElineLab.getLabelPresentation()).equals("_1") || String.valueOf(aPacCElineLab.getLabelPresentation()).equals("_2") || String.valueOf(aPacCElineLab.getLabelPresentation()).equals("_3")) && (this.varCELine.currentCategory.trim().length() > 0 || !aPacCElineLab.getLabelNature().equals(PacScreenLabelNatureValues._L_LITERAL))) {
                this.varCELine.numLabel = Integer.parseInt(String.valueOf(aPacCElineLab.getLabelPresentation()).substring(1));
                this.varCELine.linePositionASave = String.valueOf(Integer.parseInt(this.varCELine.linePositionASave) - this.varCELine.numLabel);
                String strLineA = "00" + this.varCELine.linePositionASave;
                String linePosA = strLineA.substring(strLineA.length() - 2);
                this.varCELine.linePositionASave = String.valueOf(linePosA);
            }
            if (!this.varCELine.currentCategory.equals(null) && this.varCELine.currentCategory.equals("R") && (this.varCELine.currentLabelPresentationCategory.equals("1") || this.varCELine.currentLabelPresentationCategory.equals("2") || this.varCELine.currentLabelPresentationCategory.equals("3")) && aPacCElineLab.getLabelNature().equals(PacScreenLabelNatureValues._L_LITERAL)) {
                this.varCELine.numLineForAbsoluteLabelInCategR = aPacCElineLab.getLinePosition();
            }
            if (Integer.parseInt(this.varCELine.linePositionASave) >= Integer.parseInt(this.varCELine.maxiLineNumberForScreen)) {
                this.varCELine.linePositionASave = this.varCELine.maxiLineNumberForScreen;
            }
            cleEY1I.get_GRG4A7_Groupe_Value().set_G7_Value(this.varCELine.linePositionASave);
            this.varCELine.absoluteNumberLine = Integer.parseInt(this.varCELine.linePositionASave);
            String columnPosValue = "0";
            if (this.varCELine.firstLineLabelForScreenCalled) {
                if (aPacCElineLab.getColumnPosition() > 0 && aPacCElineLab.getLinePosition() > 0 && this.varCELine.lineNumberForScreenCalled == 0 && this.varCELine.columnNumberForScreenCalled == 0) {
                    columnPosValue = String.valueOf(aPacCElineLab.getColumnPosition());
                    this.varCELine.columnPositionASaveScreen = "001";
                } else {
                    columnPosValue = aPacCElineLab.getColumnPosition() > 0 ? String.valueOf(Integer.parseInt(this.varCELine.columnPositionASaveScreen) + aPacCElineLab.getColumnPosition() - 1) : this.varCELine.columnPositionASaveScreen;
                }
            } else {
                columnPosValue = String.valueOf(aPacCElineLab.getColumnPosition());
            }
            String strColumn = "000" + columnPosValue;
            String columnPos = strColumn.substring(strColumn.length() - 3);
            if (aPacCElineLab.getColumnPosition() == 0) {
                columnPos = "002";
                columnPosValue = "002";
            }
            cleEY1I.get_GRG9AB_Groupe_Value().set_GRG9_Value(columnPos);
            int lpas = Integer.parseInt(this.varCELine.linePositionASave);
            int lpasCateg = Integer.parseInt(this.varCELine.linePositionASaveCateg);
            int cpv = Integer.parseInt(columnPosValue);
            if (this.varCELine.currentCategory.equals("R") && this.varCELine.oldLinePosition != lpas && lpas != lpasCateg) {
                cpv = cpv > this.varCELine.priorDELength ? (cpv -= this.varCELine.priorDELength) : 0;
                this.varCELine.oldLinePosition = lpas;
            }
            String cpv3 = "000" + cpv;
            String cpvNew = cpv3.substring(cpv3.length() - 3);
            this.varCELine.columnPositionASave = String.valueOf(cpvNew);
            if ((String.valueOf(aPacCElineLab.getLabelPresentation()).equals("_None") || String.valueOf(aPacCElineLab.getLabelPresentation()).equals(F_PRESENCECHECK)) && this.varCELine.currentCategory.equals("R") && this.varCELine.nbVerticalRepet > 0 && this.varCELine.nbHorizontalRepet > 0) {
                currentLineLabelInTheFirstVerticalGroup = this.varCELine.absoluteNumberLine;
            }
        } else if (String.valueOf(aPacCElineLab.getPositionType()).equals("_None")) {
            String linePosNew;
            String strLineNew;
            if (aPacCElineLab.getLinePosition() == 0 && aPacCElineLab.getColumnPosition() == 0) {
                if (this.varCELine.currentScreenTab < 2) {
                    if (!(this.varCELine.firstLineLabelForScreenCalled && this.varCELine.positionmentTypeForScreenCalled.equals("A") || this.varCELine.firstCElineForScreen || aPacCElineLab.getLabelNature().equals(PacScreenLabelNatureValues._L_LITERAL) && this.varCELine.currentCategory.equals("R") || (this.varCELine.firstCELineFieldOrLabelForCategZ == 1 || this.varCELine.firstCELineLabelForCategZ) && (this.varCELine.currentPacCELineCategory.getColumnPosition() != 0 || this.varCELine.currentPacCELineCategory.getLinePosition() != 0))) {
                        numLine = Integer.parseInt(this.varCELine.linePositionASave);
                        strLineNew = "00" + ++numLine;
                        this.varCELine.linePositionASave = strLineNew.substring(strLineNew.length() - 2);
                        if (Integer.parseInt(this.varCELine.linePositionASave) >= Integer.parseInt(this.varCELine.maxiLineNumberForScreen)) {
                            this.varCELine.linePositionASave = this.varCELine.maxiLineNumberForScreen;
                        }
                    }
                    if (!aPacCElineLab.getLabelNature().equals(PacScreenLabelNatureValues._L_LITERAL) && Integer.parseInt(this.varCELine.columnPositionASave) > 0 || aPacCElineLab.getLabelNature().equals(PacScreenLabelNatureValues._L_LITERAL) && !this.varCELine.currentCategory.equals("R")) {
                        this.varCELine.columnPositionASave = "002";
                    }
                } else {
                    this.varCELine.currentTabulPoint = Integer.parseInt(this.varCELine.columnPositionASave) / this.varCELine.pasForTabulPoint;
                    this.varCELine.nextTabulValue = this.varCELine.pasForTabulPoint * this.varCELine.currentTabulPoint + 1;
                    if (Integer.parseInt(this.varCELine.columnPositionASave) > this.varCELine.nextTabulValue) {
                        this.varCELine.nextTabulValue = this.varCELine.pasForTabulPoint * (this.varCELine.currentTabulPoint + 1) + 1;
                    }
                    if (this.varCELine.nextTabulValue < this.varCELine.currentScreenColumnNumber && this.varCELine.currentTabulPoint < this.varCELine.currentScreenTab && Integer.parseInt(this.varCELine.columnPositionASave) <= this.varCELine.nextTabulValue) {
                        if (this.varCELine.firstCELineFieldOrLabelForCategZ != 1 && !this.varCELine.firstCELineLabelForCategZ) {
                            if (this.varCELine.nextTabulValue + aPacCElineLab.getLabel().length() < this.varCELine.currentScreenColumnNumber) {
                                this.varCELine.columnPositionASave = String.valueOf(this.varCELine.nextTabulValue);
                            } else {
                                numLine = Integer.parseInt(this.varCELine.linePositionASave);
                                strLineNew = "00" + ++numLine;
                                this.varCELine.linePositionASave = strLineNew.substring(strLineNew.length() - 2);
                                this.varCELine.columnPositionASave = "002";
                            }
                        } else {
                            this.varCELine.columnPositionASave = "002";
                        }
                    } else {
                        numLine = Integer.parseInt(this.varCELine.linePositionASave);
                        strLineNew = "00" + ++numLine;
                        this.varCELine.linePositionASave = strLineNew.substring(strLineNew.length() - 2);
                        if (Integer.parseInt(this.varCELine.linePositionASave) >= Integer.parseInt(this.varCELine.maxiLineNumberForScreen)) {
                            this.varCELine.linePositionASave = this.varCELine.maxiLineNumberForScreen;
                        }
                        this.varCELine.columnPositionASave = "002";
                    }
                    this.varCELine.currentTabulPoint = this.varCELine.columnPositionASave != "002" && this.varCELine.currentTabulPoint < this.varCELine.currentScreenTab ? ++this.varCELine.currentTabulPoint : 1;
                }
            }
            if (this.varCELine.currentScreenTab > 1) {
                if (aPacCElineLab.getLinePosition() > 0 && aPacCElineLab.getColumnPosition() > 0) {
                    if (aPacCElineLab.getColumnPosition() <= this.varCELine.pasForTabulPoint) {
                        this.varCELine.currentTabulPoint = 1;
                    }
                    if (aPacCElineLab.getColumnPosition() > this.varCELine.pasForTabulPoint) {
                        this.varCELine.currentTabulPoint = 0;
                        int j = 0;
                        while (j < this.varCELine.currentScreenTab) {
                            if (aPacCElineLab.getColumnPosition() > this.varCELine.pasForTabulPoint * j) {
                                ++this.varCELine.currentTabulPoint;
                            }
                            ++j;
                        }
                    }
                }
                if (aPacCElineLab.getLinePosition() > 0 && aPacCElineLab.getColumnPosition() < 1) {
                    this.varCELine.currentTabulPoint = 1;
                }
            }
            String linePosValueNew = String.valueOf(Integer.parseInt(this.varCELine.linePositionASave) + aPacCElineLab.getLinePosition());
            if ((!this.varCELine.currentCategory.equals("R") && String.valueOf(aPacCElineLab.getLabelPresentation()).equals("_1") || String.valueOf(aPacCElineLab.getLabelPresentation()).equals("_2") || String.valueOf(aPacCElineLab.getLabelPresentation()).equals("_3")) && (this.varCELine.currentCategory.trim().length() > 0 || !aPacCElineLab.getLabelNature().equals(PacScreenLabelNatureValues._L_LITERAL))) {
                this.varCELine.numLabel = Integer.parseInt(String.valueOf(aPacCElineLab.getLabelPresentation()).substring(1));
                this.varCELine.linePositionASave = String.valueOf(Integer.parseInt(this.varCELine.linePositionASave) - this.varCELine.numLabel);
                String strLineA = "00" + this.varCELine.linePositionASave;
                String linePosA = strLineA.substring(strLineA.length() - 2);
                linePosValueNew = this.varCELine.linePositionASave = String.valueOf(linePosA);
            }
            if (this.varCELine.currentCategory.equals("R") && this.varCELine.nbVerticalRepet > 0 && this.varCELine.nbHorizontalRepet < 2 && this.varCELine.currentLabelPresentationCategory != null && (this.varCELine.currentLabelPresentationCategory.equals("1") || this.varCELine.currentLabelPresentationCategory.equals("2") || this.varCELine.currentLabelPresentationCategory.equals("3"))) {
                if (!aPacCElineLab.getLabelNature().equals(PacScreenLabelNatureValues._L_LITERAL)) {
                    if (aPacCElineLab.getLinePosition() > 0 || this.varCELine.firstCELineFieldForCateg && !this.varCELine.noRepeatLabel) {
                        linePosValueNewSave = linePosValueNew;
                        linePosValueNew = String.valueOf(Integer.parseInt(this.varCELine.currentLabelPresentationCategory) + Integer.parseInt(this.varCELine.linePositionASaveCateg));
                    }
                } else if (aPacCElineLab.getLinePosition() > 0 && aPacCElineLab.getLabelPresentation() == PacLabelPresentationValues._NONE_LITERAL) {
                    linePosValueNewSave = linePosValueNew;
                    linePosValueNew = String.valueOf(Integer.parseInt(this.varCELine.currentLabelPresentationCategory) + Integer.parseInt(linePosValueNew));
                } else {
                    linePosValueNewSave = linePosValueNew;
                    linePosValueNew = String.valueOf(this.varCELine.linePositionASaveCategRInitial);
                    if (this.varCELine.numLineForAbsoluteLabelInCategR > 0) {
                        linePosValueNew = String.valueOf(this.varCELine.numLineForAbsoluteLabelInCategR);
                    }
                }
            }
            if (this.varCELine.currentCategory.equals("R") && this.varCELine.currentLineInTheFirstVerticalGroup > 0) {
                linePosValueNew = String.valueOf(this.varCELine.currentLineInTheFirstVerticalGroup + aPacCElineLab.getLinePosition());
                if (aPacCElineLab.getLinePosition() > 0 && this.varCELine.currentLabelPresentationCategory != null && (this.varCELine.currentLabelPresentationCategory.equals("1") || this.varCELine.currentLabelPresentationCategory.equals("2") || this.varCELine.currentLabelPresentationCategory.equals("3")) && aPacCElineLab.getLabelPresentation() == PacLabelPresentationValues._NONE_LITERAL) {
                    linePosValueNew = String.valueOf(Integer.parseInt(this.varCELine.currentLabelPresentationCategory) + Integer.parseInt(linePosValueNew));
                }
            }
            if (Integer.parseInt(linePosNew = (strLineNew = "00" + linePosValueNew).substring(strLineNew.length() - 2)) >= Integer.parseInt(this.varCELine.maxiLineNumberForScreen)) {
                linePosNew = this.varCELine.maxiLineNumberForScreen;
            }
            cleEY1I.get_GRG4A7_Groupe_Value().set_G7_Value(linePosNew);
            String colPosValueNew = "0";
            if (this.varCELine.screenCalled) {
                if (aPacCElineLab.getLinePosition() > 0 || this.varCELine.firstLineForScreenCalled) {
                    if (aPacCElineLab.getColumnPosition() > 0) {
                        if (aPacCElineLab.getLinePosition() > 0 && this.varCELine.lineNumberForScreenCalled == 0 && this.varCELine.columnNumberForScreenCalled == 0) {
                            colPosValueNew = String.valueOf(aPacCElineLab.getColumnPosition());
                        } else {
                            colPosValueNew = String.valueOf(Integer.parseInt(this.varCELine.columnPositionASaveScreen) + aPacCElineLab.getColumnPosition() - 1);
                            if (this.varCELine.initialColumnASaveCateg != 0 && this.varCELine.currentCategory.equals("R")) {
                                colPosValueNew = String.valueOf(aPacCElineLab.getColumnPosition() + (Integer.parseInt(this.varCELine.columnPositionASaveCateg) - 1));
                            }
                        }
                    } else {
                        colPosValueNew = String.valueOf(Integer.parseInt(this.varCELine.columnPositionASaveScreen) + 1);
                    }
                } else {
                    colPosValueNew = String.valueOf(Integer.parseInt(this.varCELine.columnPositionASave) + aPacCElineLab.getColumnPosition());
                    if (this.varCELine.firstCELineLabelForCategZ && this.varCELine.firstCELineFieldOrLabelForCategZ < 2 && aPacCElineLab.getColumnPosition() > 0 && Integer.parseInt(this.varCELine.columnPositionASaveCateg) > 0) {
                        colPosValueNew = String.valueOf(Integer.parseInt(this.varCELine.columnPositionASaveCateg) + (aPacCElineLab.getColumnPosition() - 1));
                    } else if (this.varCELine.priorDELengthLabel < this.varCELine.priorDELength) {
                        colPosValueNew = String.valueOf(Integer.parseInt(this.varCELine.columnPositionASave) + aPacCElineLab.getColumnPosition() + this.varCELine.priorDELength);
                    }
                }
            } else if (this.varCELine.currentCategory.equals("R")) {
                if (aPacCElineLab.getLinePosition() < 1) {
                    if (this.varCELine.rankCELineLabelForCateg == 1 && this.varCELine.priorDELength < 1) {
                        colPosValueNew = String.valueOf(Integer.parseInt(this.varCELine.columnPositionASave));
                        if (aPacCElineLab.getColumnPosition() > 0) {
                            colPosValueNew = String.valueOf(aPacCElineLab.getColumnPosition() + (Integer.parseInt(this.varCELine.columnPositionASaveCateg) - 1));
                        }
                        if (this.varCELine.currentPacCELineCategory.getPositionType().equals(PacScreenPositionTypeValues._NONE_LITERAL) && this.varCELine.currentPacCELineCategory.getColumnPosition() == 0 && aPacCElineLab.getColumnPosition() > 0) {
                            colPosValueNew = String.valueOf(aPacCElineLab.getColumnPosition() + Integer.parseInt(this.varCELine.columnPositionASaveCateg));
                        }
                    } else {
                        colPosValueNew = this.varCELine.priorDELengthLabel < this.varCELine.priorDELength ? String.valueOf(Integer.parseInt(this.varCELine.columnPositionASave) + aPacCElineLab.getColumnPosition() + this.varCELine.priorDELength) : String.valueOf(Integer.parseInt(this.varCELine.columnPositionASave) + aPacCElineLab.getColumnPosition() + this.varCELine.priorDELengthLabel);
                    }
                } else if (aPacCElineLab.getColumnPosition() > 0) {
                    colPosValueNew = this.varCELine.initialColumnASaveCateg != 0 ? String.valueOf(aPacCElineLab.getColumnPosition() + (Integer.parseInt(this.varCELine.columnPositionASaveCateg) - 1)) : String.valueOf(aPacCElineLab.getColumnPosition() + 1);
                } else {
                    colPosValueNew = "001";
                    if (aPacCElineLab.getLinePosition() > 0) {
                        colPosValueNew = "002";
                    }
                }
            } else if (aPacCElineLab.getLinePosition() < 1) {
                colPosValueNew = String.valueOf(Integer.parseInt(this.varCELine.columnPositionASave) + aPacCElineLab.getColumnPosition());
                if (this.varCELine.firstCELineFieldOrLabelForCategZ == 1 && this.varCELine.firstCELineLabelForCategZ && aPacCElineLab.getColumnPosition() > 0) {
                    int ajoutLigneColBasEcran = 0;
                    if (Integer.parseInt(this.varCELine.columnPositionASaveCateg) > 1) {
                        ajoutLigneColBasEcran = Integer.parseInt(this.varCELine.columnPositionASaveCateg) - 1;
                    }
                    if (this.varCELine.currentPacCELineCategory.getColumnPosition() > 0) {
                        colPosValueNew = String.valueOf(aPacCElineLab.getColumnPosition() + ajoutLigneColBasEcran);
                    }
                } else if (this.varCELine.firstCELineFieldOrLabelForCategZ > 1) {
                    colPosValueNew = String.valueOf(aPacCElineLab.getColumnPosition() + Integer.parseInt(this.varCELine.columnPositionASave));
                }
            } else {
                colPosValueNew = aPacCElineLab.getColumnPosition() > 0 ? String.valueOf(aPacCElineLab.getColumnPosition()) : "002";
            }
            String strColNew = "000" + colPosValueNew;
            String colPosNew = strColNew.substring(strColNew.length() - 3);
            cleEY1I.get_GRG9AB_Groupe_Value().set_GRG9_Value(colPosNew);
            int position = Integer.parseInt(colPosValueNew);
            this.varCELine.linePositionASave = String.valueOf(linePosNew);
            if (Integer.parseInt(this.varCELine.linePositionASave) >= Integer.parseInt(this.varCELine.maxiLineNumberForScreen)) {
                this.varCELine.linePositionASave = this.varCELine.maxiLineNumberForScreen;
            }
            this.varCELine.columnPositionASave = String.valueOf(position);
            this.varCELine.absoluteNumberLine = Integer.parseInt(this.varCELine.linePositionASave);
            columnSaveBeforeVerticalLabelRep = this.varCELine.columnPositionASave;
        }
        int indLabel = 0;
        CELine = this.prepLineForCELineLabelIM(CELine, aPacCElineLab, indLabel);
        if (this.varCELine.currentCategory.equals("R") && this.varCELine.nbVerticalRepet > 0 && this.varCELine.nbHorizontalRepet > 0) {
            String repet91 = String.valueOf(indLabel + 1);
            CELine.set_REPET9_Value(repet91 + "0101");
        }
        EY1I CELineIMLab = CELine;
        this.varCELine.screenLines.add((PacbaseSegment)CELine);
        if (this.varCELine.writeMI2) {
            EY1I CELineMI2 = new EY1I(CELine.getCompleteContentForSegment());
            CELineMI2.get_GRCLEEY_Groupe_Value().set_G1_Value("W");
            CELineMI2.get_GRCLEEY_Groupe_Value().set_COCA_Value("I2");
            this.varCELine.screenLines.add((PacbaseSegment)CELineMI2);
        }
        if (aPacCElineLab.getLabelNature().equals(PacScreenLabelNatureValues._O_LITERAL)) {
            this.varCELine.noRepeatLabel = false;
        }
        if (String.valueOf(aPacCElineLab.getPositionType()).substring(1).equals("A")) {
            this.varCELine.noRepeatLabel = false;
        }
        if (String.valueOf(aPacCElineLab.getPositionType()).substring(1).equals("A") && aPacCElineLab.getLinePosition() < this.varCELine.linePositionASaveCategInitial) {
            this.varCELine.noRepeatLabel = true;
        }
        boolean repeatLabelInCateg = true;
        if (aPacCElineLab.getLabelNature().equals(PacScreenLabelNatureValues._O_LITERAL) && this.varCELine.currentCategory.equals("R") && (aPacCElineLab.getLabelPresentation().equals(PacLabelPresentationValues._1_LITERAL) || aPacCElineLab.getLabelPresentation().equals(PacLabelPresentationValues._2_LITERAL) || aPacCElineLab.getLabelPresentation().equals(PacLabelPresentationValues._3_LITERAL))) {
            repeatLabelInCateg = false;
        }
        int numberLineToInit = 0;
        if (!this.varCELine.noRepeatLabel && repeatLabelInCateg && (String.valueOf(aPacCElineLab.getLabelPresentation()).equals("_None") || String.valueOf(aPacCElineLab.getLabelPresentation()).equals(F_PRESENCECHECK) || aPacCElineLab.getLabelNature().equals(PacScreenLabelNatureValues._O_LITERAL)) && this.varCELine.currentCategory.equals("R") && this.varCELine.nbVerticalRepet > 0 && this.varCELine.nbHorizontalRepet > 0) {
            int ajoutLine = this.varCELine.maxNumberOfVerticalLine;
            String lineSaveBeforeVerticalLabelRep = "0";
            indLabel = 1;
            while (indLabel < this.varCELine.nbVerticalRepet) {
                if (indLabel == 1) {
                    lineSaveBeforeVerticalLabelRep = this.varCELine.linePositionASave;
                    numberLineToInit = Integer.parseInt(lineSaveBeforeVerticalLabelRep) + (this.varCELine.nbVerticalRepet - 1) * ajoutLine;
                }
                this.varCELine.linePositionASave = String.valueOf(Integer.parseInt(this.varCELine.linePositionASave) + ajoutLine);
                String strLineNew = "00" + this.varCELine.linePositionASave;
                this.varCELine.linePositionASave = strLineNew.substring(strLineNew.length() - 2);
                CELine = new EY1I(CELine.getCompleteContentForSegment());
                cleEY1I = CELine.get_GRCLEEY_Groupe_Value();
                if (Integer.parseInt(this.varCELine.linePositionASave) >= Integer.parseInt(this.varCELine.maxiLineNumberForScreen)) {
                    this.varCELine.linePositionASave = this.varCELine.maxiLineNumberForScreen;
                }
                cleEY1I.get_GRG4A7_Groupe_Value().set_G7_Value(this.varCELine.linePositionASave);
                if (this.varCELine.currentCategory.equals("R") && this.varCELine.nbVerticalRepet > 0 && this.varCELine.nbHorizontalRepet > 0) {
                    String repet91 = String.valueOf(indLabel + 1);
                    CELine.set_REPET9_Value(repet91 + "0101");
                }
                this.varCELine.screenLines.add((PacbaseSegment)CELine);
                if (this.varCELine.writeMI2) {
                    EY1I CELineMI2 = new EY1I(CELine.getCompleteContentForSegment());
                    CELineMI2.get_GRCLEEY_Groupe_Value().set_G1_Value("W");
                    CELineMI2.get_GRCLEEY_Groupe_Value().set_COCA_Value("I2");
                    this.varCELine.screenLines.add((PacbaseSegment)CELineMI2);
                }
                if (indLabel >= this.varCELine.nbVerticalRepet - ajoutLine && Integer.parseInt(this.varCELine.linePositionASave) == numberLineToInit) {
                    this.varCELine.linePositionASave = lineSaveBeforeVerticalLabelRep;
                    if (Integer.parseInt(columnSaveBeforeVerticalLabelRep) > 0 && !aPacCElineLab.getLabelNature().equals(PacScreenLabelNatureValues._O_LITERAL)) {
                        this.varCELine.priorDELength = 0;
                        this.varCELine.priorDELengthLabel = CELine.get_LOLIB_Int_Value();
                        this.varCELine.columnPositionASave = columnSaveBeforeVerticalLabelRep;
                    }
                }
                ++indLabel;
            }
        } else if (!this.varCELine.noRepeatLabel && (String.valueOf(aPacCElineLab.getLabelPresentation()).equals("_None") && this.varCELine.currentCategory.equals("R") || String.valueOf(aPacCElineLab.getLabelPresentation()).equals("_1") || String.valueOf(aPacCElineLab.getLabelPresentation()).equals("_2") || String.valueOf(aPacCElineLab.getLabelPresentation()).equals("_3"))) {
            indLabel = 0;
            while (indLabel < this.varCELine.numLabel) {
                CELine = new EY1I(CELine.getCompleteContentForSegment());
                cleEY1I = CELine.get_GRCLEEY_Groupe_Value();
                if (indLabel > 0) {
                    cleEY1I.get_GRG4A7_Groupe_Value().set_G7_Value(this.varCELine.linePositionASave);
                    CELine = this.prepLineForCELineLabelIM(CELine, aPacCElineLab, indLabel);
                }
                if (!String.valueOf(CELine).equals(String.valueOf(CELineIMLab))) {
                    this.varCELine.screenLines.add((PacbaseSegment)CELine);
                    if (this.varCELine.writeMI2) {
                        EY1I CELineMI2 = new EY1I(CELine.getCompleteContentForSegment());
                        CELineMI2.get_GRCLEEY_Groupe_Value().set_G1_Value("W");
                        CELineMI2.get_GRCLEEY_Groupe_Value().set_COCA_Value("I2");
                        this.varCELine.screenLines.add((PacbaseSegment)CELineMI2);
                    }
                }
                int numLine = Integer.parseInt(this.varCELine.linePositionASave);
                String strLineNew = "00" + ++numLine;
                this.varCELine.linePositionASave = strLineNew.substring(strLineNew.length() - 2);
                if (Integer.parseInt(this.varCELine.linePositionASave) >= Integer.parseInt(this.varCELine.maxiLineNumberForScreen)) {
                    this.varCELine.linePositionASave = this.varCELine.maxiLineNumberForScreen;
                }
                ++indLabel;
            }
        }
        if (this.varCELine.currentCategory.equals("R") && this.varCELine.maxNumberOfVerticalLine > 1) {
            this.varCELine.currentLineInTheFirstVerticalGroup = Integer.parseInt(this.varCELine.linePositionASave);
            if (currentLineLabelInTheFirstVerticalGroup > 0) {
                this.varCELine.currentLineInTheFirstVerticalGroup = currentLineLabelInTheFirstVerticalGroup;
            }
        }
        this.varCELine.firstCELineFieldForCateg = true;
        this.varCELine.priorDELength = 0;
        this.varCELine.firstCELineLabelForCategZ = false;
        this.varCELine.firstCELineFieldOrLabelForCategZ = 2;
        this.varCELine.lastNumberTitleLine = Integer.parseInt(this.varCELine.linePositionASave) - 1;
        if (numberLineToInit > 0) {
            this.varCELine.currentLine = String.valueOf(numberLineToInit);
        }
        if (linePosValueNewSave != null) {
            String strLineNewSave = "00" + linePosValueNewSave;
            this.varCELine.linePositionASave = strLineNewSave.substring(strLineNewSave.length() - 2);
        }
        this.varCELine.firstCElineForScreen = false;
        this.varCELine.incrementNuligForPFKEY = false;
    }

    private boolean isColumnLabelNeeded(PacCELineCategory aPacCElineCat) {
        boolean insideCateg = false;
        for (PacAbstractCELine celine : ((PacScreen)aPacCElineCat.getOwner()).getCELines()) {
            if (celine instanceof PacCELineCategory) {
                if (celine == aPacCElineCat) {
                    insideCateg = true;
                    continue;
                }
                insideCateg = false;
                continue;
            }
            if (!insideCateg || !(celine instanceof PacCELineField) || (aPacCElineCat.getLabelPresentation() != PacLabelPresentationValues._1_LITERAL && aPacCElineCat.getLabelPresentation() != PacLabelPresentationValues._2_LITERAL && aPacCElineCat.getLabelPresentation() != PacLabelPresentationValues._3_LITERAL || celine.getLabelPresentation() != PacLabelPresentationValues._NONE_LITERAL && celine.getLabelPresentation() != PacLabelPresentationValues._N_LITERAL) && celine.getLabelPresentation() != PacLabelPresentationValues._1_LITERAL && celine.getLabelPresentation() != PacLabelPresentationValues._2_LITERAL && celine.getLabelPresentation() != PacLabelPresentationValues._3_LITERAL) continue;
            return true;
        }
        return false;
    }

    private void searchForVerticalRepetition(PacCELineField SPacCElineField) {
        if (SPacCElineField.getVerticalRepetition() > this.varCELine.maxNumberOfVerticalLine) {
            this.varCELine.maxNumberOfVerticalLine = SPacCElineField.getVerticalRepetition();
        }
        if (SPacCElineField.getLinePosition() > 0 && !String.valueOf(SPacCElineField.getPositionType()).substring(1).equals("A")) {
            this.varCELine.maxNumberOfVerticalLine += SPacCElineField.getLinePosition();
            int nbLineForDebCol = 0;
            if (SPacCElineField.getLabelPresentation() != null && (SPacCElineField.getLabelPresentation().equals(PacLabelPresentationValues._1_LITERAL) || SPacCElineField.getLabelPresentation().equals(PacLabelPresentationValues._2_LITERAL) || SPacCElineField.getLabelPresentation().equals(PacLabelPresentationValues._3_LITERAL))) {
                nbLineForDebCol = Integer.parseInt(SPacCElineField.getLabelPresentation().getLiteral().substring(1, 2));
                this.varCELine.changeLineWithColumnLabel = true;
                this.varCELine.numLabelModified = false;
            }
            this.varCELine.maxNumberOfVerticalLine += nbLineForDebCol;
        }
        if (SPacCElineField.getPositionType().equals(PacScreenPositionTypeValues._A_LITERAL) && SPacCElineField.getLinePosition() >= Integer.parseInt(this.varCELine.linePositionASaveCateg) + this.varCELine.numLabel) {
            if (SPacCElineField.getLinePosition() == Integer.parseInt(this.varCELine.linePositionASaveCateg) + this.varCELine.numLabel && this.varCELine.maxNumberOfVerticalLine > this.varCELine.maxNumberOfVerticalLine1) {
                this.varCELine.maxNumberOfVerticalLine1 = this.varCELine.maxNumberOfVerticalLine;
            }
            if (SPacCElineField.getVerticalRepetition() > 0 && SPacCElineField.getLinePosition() > 0) {
                int ligneHV = SPacCElineField.getLinePosition() + SPacCElineField.getVerticalRepetition();
                if (ligneHV > Integer.parseInt(this.varCELine.linePositionASaveCateg) + this.varCELine.maxNumberOfVerticalLine) {
                    this.varCELine.maxNumberOfVerticalLine += SPacCElineField.getVerticalRepetition();
                }
            } else {
                int addLigne = SPacCElineField.getLinePosition() - (Integer.parseInt(this.varCELine.linePositionASaveCateg) + this.varCELine.numLabel);
                this.varCELine.maxNumberOfVerticalLine = addLigne + 1;
            }
        }
    }

    private void searchForVerticalRepetition(PacCELineLabel SPacCElineLabel) {
        if (SPacCElineLabel.getLinePosition() > 0 && !String.valueOf(SPacCElineLabel.getPositionType()).substring(1).equals("A")) {
            this.varCELine.maxNumberOfVerticalLine = this.varCELine.currentLabelPresentationCategory != null && (this.varCELine.currentLabelPresentationCategory.equals("1") || this.varCELine.currentLabelPresentationCategory.equals("2") || this.varCELine.currentLabelPresentationCategory.equals("3")) && SPacCElineLabel.getLabelPresentation() == PacLabelPresentationValues._NONE_LITERAL ? this.varCELine.maxNumberOfVerticalLine + SPacCElineLabel.getLinePosition() + Integer.parseInt(this.varCELine.currentLabelPresentationCategory) : (this.varCELine.maxNumberOfVerticalLine += SPacCElineLabel.getLinePosition());
        }
        int nbLineForDebCol = 0;
        if (!this.varCELine.repetHorizontalCateg && this.varCELine.currentLabelPresentationCategory != null && (this.varCELine.currentLabelPresentationCategory.equals("1") || this.varCELine.currentLabelPresentationCategory.equals("2") || this.varCELine.currentLabelPresentationCategory.equals("3"))) {
            nbLineForDebCol = Integer.parseInt(this.varCELine.currentLabelPresentationCategory);
        }
        if (this.varCELine.currentCategory.equals("R") && String.valueOf(SPacCElineLabel.getPositionType()).substring(1).equals("A")) {
            if (!this.varCELine.absolutePositionForCateg && SPacCElineLabel.getLinePosition() > Integer.parseInt(this.varCELine.linePositionASaveCateg) + nbLineForDebCol) {
                int addLigne = SPacCElineLabel.getLinePosition() - Integer.parseInt(this.varCELine.linePositionASaveCateg);
                this.varCELine.maxNumberOfVerticalLine = addLigne + 1;
            } else if (this.varCELine.absolutePositionForCateg && SPacCElineLabel.getLinePosition() > this.varCELine.linePositionASaveCategInitial) {
                int addLigne = SPacCElineLabel.getLinePosition() - this.varCELine.linePositionASaveCategInitial;
                this.varCELine.maxNumberOfVerticalLine = addLigne + 1;
            }
        }
    }

    private EY1I instantiateW_I1(EY1I CELine, String G7IM, String G91IM, String EY1IICAT, String EY1INULIG, PacCELineField aPacCElineField) {
        CELine = new EY1I(CELine.getCompleteContentForSegment());
        PacbaseSegment.GRCLEEY cleEY1I = CELine.get_GRCLEEY_Groupe_Value();
        cleEY1I.set_G1_Value("W");
        cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_G4_Value(G7IM);
        cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_GRG5A6_Groupe_Value().set_G5_Value(G91IM);
        cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_GRG5A6_Groupe_Value().set_G6BIS_Value(EY1IICAT);
        cleEY1I.get_GRG4A7_Groupe_Value().set_G7_Value("00");
        cleEY1I.get_GRG9AB_Groupe_Value().set_GRG9_Value(EY1INULIG);
        CELine.set_REPET9_Value("000101");
        if ((this.varCELine.currentVari.equals("X1") || this.varCELine.currentVari.equals("X3")) && aPacCElineField.getFieldType().equals(PacScreenFieldTypeValues._PASSWORD_LITERAL)) {
            this.varCELine.IMSPASWD = true;
        }
        if (!String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") && !this.varCELine.IMSPASWD) {
            this.varCELine.screenLines.add((PacbaseSegment)CELine);
        }
        CELine = new EY1I(CELine.getCompleteContentForSegment());
        cleEY1I = CELine.get_GRCLEEY_Groupe_Value();
        cleEY1I.set_COCA_Value("I1");
        cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_G4_Value("  ");
        cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_GRG5A6_Groupe_Value().set_G5_Value("   ");
        if (!String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") && !this.varCELine.IMSPASWD) {
            this.varCELine.screenLines.add((PacbaseSegment)CELine);
        }
        return CELine;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private EY1I prepLineForCELineLabelIM(EY1I CELineLabel, PacCELineLabel aPacCEline, int numLabel) {
        block104: {
            block102: {
                block103: {
                    block99: {
                        block100: {
                            block101: {
                                block98: {
                                    block97: {
                                        block95: {
                                            block96: {
                                                block92: {
                                                    block93: {
                                                        block94: {
                                                            block91: {
                                                                block90: {
                                                                    block88: {
                                                                        block89: {
                                                                            block85: {
                                                                                block86: {
                                                                                    block87: {
                                                                                        block84: {
                                                                                            block75: {
                                                                                                block78: {
                                                                                                    block83: {
                                                                                                        block82: {
                                                                                                            block81: {
                                                                                                                block79: {
                                                                                                                    block80: {
                                                                                                                        block76: {
                                                                                                                            block77: {
                                                                                                                                narue = String.valueOf(aPacCEline.getLabelNature()).substring(1, 2);
                                                                                                                                CELineLabel.set_NARUE_Value(narue);
                                                                                                                                pacded = null;
                                                                                                                                lirub = "";
                                                                                                                                if (narue.equals("T")) {
                                                                                                                                    CELineLabel.set_NARUE_Value("L");
                                                                                                                                }
                                                                                                                                CELineLabel.set_TLIB_Value("L");
                                                                                                                                if (aPacCEline.getDataElement() == null) break block76;
                                                                                                                                DataElementForCELine = aPacCEline.getDataElement();
                                                                                                                                CELineLabel.set_CORUB_Value(DataElementForCELine.getName());
                                                                                                                                if (!narue.equals("O")) break block75;
                                                                                                                                this.varCELine.currentLabelPresentationField = String.valueOf(aPacCEline.getLabelPresentation());
                                                                                                                                if (this.varCELine.currentLabelPresentationField.equals(null) || this.varCELine.currentLabelPresentationField.equals("_None")) {
                                                                                                                                    if (this.varCELine.currentLabelPresentationCategory != null && !this.varCELine.currentLabelPresentationCategory.equals("None") && Integer.parseInt(this.varCELine.currentLabelPresentationCategory) > 0) {
                                                                                                                                        this.varCELine.currentLabelPresentationField = this.varCELine.currentLabelPresentationCategory;
                                                                                                                                    } else if (!this.varCELine.currentLabelPresentationScreen.equals(null) && !this.varCELine.currentLabelPresentationScreen.equals("_None")) {
                                                                                                                                        this.varCELine.currentLabelPresentationField = this.varCELine.currentLabelPresentationScreen;
                                                                                                                                    } else if (!this.varCELine.currentLabelPresentationDialog.equals(null) && !this.varCELine.currentLabelPresentationDialog.equals("_None")) {
                                                                                                                                        this.varCELine.currentLabelPresentationField = this.varCELine.currentLabelPresentationDialog;
                                                                                                                                    }
                                                                                                                                }
                                                                                                                                pdelt = null;
                                                                                                                                if (!this.varCELine.currentLabelPresentationField.equals("_S") && !this.varCELine.currentLabelPresentationField.equals("_T") && !this.varCELine.currentLabelPresentationField.equals("_U") && !this.varCELine.currentLabelPresentationField.equals("_R")) break block77;
                                                                                                                                this.setLOLIBLIRUE(CELineLabel, DataElementForCELine, this.varCELine.currentLabelPresentationField, narue);
                                                                                                                                break block78;
                                                                                                                            }
                                                                                                                            lirub = DataElementForCELine.getLabel();
                                                                                                                            if (lirub.trim().length() >= 1) break block79;
                                                                                                                            extensions = DataElementForCELine.getDataDescription().getExtensions().iterator();
                                                                                                                            if (true) ** GOTO lbl76
                                                                                                                        }
                                                                                                                        if (aPacCEline.getScreen() == null) break block80;
                                                                                                                        screenForCELine = aPacCEline.getScreen();
                                                                                                                        CELineLabel.set_CORUB_Value(screenForCELine.getName());
                                                                                                                        CELineLabel.set_LIRUE_Value(screenForCELine.getLabel());
                                                                                                                        CELineLabel.set_LOLIB_Value("030");
                                                                                                                        this.varCELine.columnPositionASave = String.valueOf(Integer.parseInt(this.varCELine.columnPositionASave) + 30);
                                                                                                                        if (Integer.parseInt(this.varCELine.columnPositionASave) > this.varCELine.pasForTabulPoint) {
                                                                                                                            this.varCELine.currentTabulPoint = Integer.parseInt(this.varCELine.columnPositionASave) / this.varCELine.pasForTabulPoint + 1;
                                                                                                                        }
                                                                                                                        break block75;
                                                                                                                    }
                                                                                                                    CELineLabel.set_CORUB_Value("999999");
                                                                                                                    if (aPacCEline.getLabel() != null) {
                                                                                                                        CELineLabel.set_LIRUE_Value(aPacCEline.getLabel());
                                                                                                                        if (aPacCEline.getLabel().length() > 0) {
                                                                                                                            if (aPacCEline.getLabel().endsWith("/")) {
                                                                                                                                CELineLabel.set_LOLIB_Value(aPacCEline.getLabel().length() - 1);
                                                                                                                                this.varCELine.columnPositionASave = String.valueOf(Integer.parseInt(this.varCELine.columnPositionASave) + aPacCEline.getLabel().length() - 1);
                                                                                                                            } else {
                                                                                                                                CELineLabel.set_LOLIB_Value("030");
                                                                                                                                this.varCELine.columnPositionASave = String.valueOf(Integer.parseInt(this.varCELine.columnPositionASave) + 30);
                                                                                                                            }
                                                                                                                        } else if (String.valueOf(aPacCEline.getRepetition()) != null && aPacCEline.getRepetition() == 0) {
                                                                                                                            CELineLabel.set_LOLIB_Value("000");
                                                                                                                        }
                                                                                                                    }
                                                                                                                    if (String.valueOf(aPacCEline.getRepetition()) == null || aPacCEline.getRepetition() <= 0) break block75;
                                                                                                                    CELineLabel.set_LOLIB_Value(aPacCEline.getRepetition());
                                                                                                                    i = 0;
                                                                                                                    if (true) ** GOTO lbl145
                                                                                                                    do {
                                                                                                                        if (!((extNext = extensions.next()) instanceof PacDataElementDescription)) continue;
                                                                                                                        pacded = (PacDataElementDescription)extNext;
lbl76:
                                                                                                                        // 3 sources

                                                                                                                    } while (extensions.hasNext());
                                                                                                                    if (pacded.getParent() != null) {
                                                                                                                        parentDataElement = pacded.getParent();
                                                                                                                        lirub = parentDataElement.getLabel();
                                                                                                                    }
                                                                                                                }
                                                                                                                CELineLabel.set_LOLIB_Value("036");
                                                                                                                if (!this.varCELine.currentLabelPresentationField.equals("_M")) break block81;
                                                                                                                lengthLibel = lirub.length();
                                                                                                                if (lengthLibel >= 36) break block82;
                                                                                                                nbBlanc = 36 - lengthLibel;
                                                                                                                lirubBlanc = "";
                                                                                                                i = 0;
                                                                                                                if (true) ** GOTO lbl97
                                                                                                            }
                                                                                                            CELineLabel.set_LIRUE_Value(lirub);
                                                                                                            break block83;
                                                                                                            do {
                                                                                                                lirubBlanc = lirubBlanc.concat(" ");
                                                                                                                ++i;
lbl97:
                                                                                                                // 2 sources

                                                                                                            } while (i < nbBlanc);
                                                                                                            lirub = lirubBlanc.concat(lirub);
                                                                                                        }
                                                                                                        CELineLabel.set_LIRUE_Value(lirub);
                                                                                                    }
                                                                                                    if (this.varCELine.currentLabelPresentationField.equals("_N")) {
                                                                                                        CELineLabel.set_LOLIB_Value(lirub.length());
                                                                                                        this.varCELine.columnPositionASave = String.valueOf(Integer.parseInt(this.varCELine.columnPositionASave) + lirub.length() + 1);
                                                                                                    } else if (!(this.varCELine.currentLabelPresentationField == null || this.varCELine.currentLabelPresentationField.trim().equals("_1") || this.varCELine.currentLabelPresentationField.trim().equals("_2") || this.varCELine.currentLabelPresentationField.trim().equals("_3"))) {
                                                                                                        this.varCELine.columnPositionASave = String.valueOf(Integer.parseInt(this.varCELine.columnPositionASave) + 37);
                                                                                                    }
                                                                                                }
                                                                                                if (DataElementForCELine instanceof DataElement) {
                                                                                                    for (E extEltNext : DataElementForCELine.getExtensions()) {
                                                                                                        if (!(extEltNext instanceof PacDataElement)) continue;
                                                                                                        pdelt = (PacDataElement)extEltNext;
                                                                                                    }
                                                                                                    for (E extNext : DataElementForCELine.getDataDescription().getExtensions()) {
                                                                                                        if (!(extNext instanceof PacDataElementDescription)) continue;
                                                                                                        pacded = (PacDataElementDescription)extNext;
                                                                                                    }
                                                                                                }
                                                                                                if (String.valueOf(aPacCEline.getLabelPresentation()).equals("_None") && this.varCELine.currentLabelPresentationCategory != null && (this.varCELine.currentLabelPresentationCategory.trim().equals("1") || this.varCELine.currentLabelPresentationCategory.trim().equals("2") || this.varCELine.currentLabelPresentationCategory.trim().equals("3")) || this.varCELine.currentLabelPresentationField.trim().equals("_1") || this.varCELine.currentLabelPresentationField.trim().equals("_2") || this.varCELine.currentLabelPresentationField.trim().equals("_3")) {
                                                                                                    try {
                                                                                                        labelLineNumber = 0;
                                                                                                        if (this.varCELine.currentLabelPresentationCategory != null && !this.varCELine.currentLabelPresentationCategory.equals("None") && Integer.parseInt(this.varCELine.currentLabelPresentationCategory) > 0) {
                                                                                                            labelLineNumber = Integer.parseInt(this.varCELine.currentLabelPresentationCategory);
                                                                                                        } else if (Integer.parseInt(this.varCELine.currentLabelPresentationField.substring(1)) > 0) {
                                                                                                            labelLineNumber = Integer.parseInt(this.varCELine.currentLabelPresentationField.substring(1));
                                                                                                        }
                                                                                                        if (labelLineNumber > 0) {
                                                                                                            this.formatLabelColumn(CELineLabel, DataElementForCELine, pdelt, pacded, numLabel, labelLineNumber);
                                                                                                        }
                                                                                                        break block75;
                                                                                                    }
                                                                                                    catch (Exception v0) {
                                                                                                        traceManager = PTTraceManager.getInstance();
                                                                                                        engineTraceLevel = traceManager.getTraceLevel("com.ibm.pdp.pac");
                                                                                                        if (engineTraceLevel > 0) {
                                                                                                            message = "LABEL PRESENTATION NON NUMERIC: " + this.varCELine.currentLabelPresentationCategory + " " + String.valueOf(new Date());
                                                                                                            traceManager.trace(EY00PacbaseAndKernelVisitor.class, "com.ibm.pdp.pac", 1, message);
                                                                                                        }
                                                                                                        break block75;
                                                                                                    }
                                                                                                }
                                                                                                break block75;
                                                                                                do {
                                                                                                    lirue = CELineLabel.get_LIRUE_Value().trim();
                                                                                                    CELineLabel.set_LIRUE_Value(lirue.concat(aPacCEline.getRepeatedCharacter()));
                                                                                                    ++i;
lbl145:
                                                                                                    // 2 sources

                                                                                                } while (i < aPacCEline.getRepetition());
                                                                                                this.varCELine.columnPositionASave = String.valueOf(Integer.parseInt(this.varCELine.columnPositionASave) + aPacCEline.getRepetition());
                                                                                                CELineLabel.set_VAREC_Value("A");
                                                                                            }
                                                                                            CELineLabel.set_REPETH_Value("01");
                                                                                            CELineLabel.set_REPETV_Value("00");
                                                                                            CELineLabel.set_TIPE1_Value("X");
                                                                                            CELineLabel.get_GRFORMAT_Groupe_Value().set_NBCHA_Value("00");
                                                                                            CELineLabel.get_GRFORMAT_Groupe_Value().set_NBCHP_Value("00");
                                                                                            if (aPacCEline.getIntensityAtt().equals(PacIntensityAttributeValues._NONE_LITERAL)) break block84;
                                                                                            CELineLabel.set_ATTRIL_Value(String.valueOf(aPacCEline.getIntensityAtt()).substring(1));
                                                                                            break block85;
                                                                                        }
                                                                                        if (!this.varCELine.screenCalled || this.varCELine.calledScreen == null) break block86;
                                                                                        if (this.varCELine.calledScreen.getLabelIntensityAtt().equals(PacIntensityAttributeValues._NONE_LITERAL)) break block87;
                                                                                        CELineLabel.set_ATTRIL_Value(this.varCELine.calledScreen.getLabelIntensityAtt().getLiteral().substring(1));
                                                                                        break block85;
                                                                                    }
                                                                                    if (this.varCELine.calledScreen.getLabelIntensityAtt().equals(PacIntensityAttributeValues._NONE_LITERAL) || this.varCELine.calledScreen.getLabelIntensityAtt().equals(this.varCELine.calledDialog.getLabelIntensityAtt())) {
                                                                                        CELineLabel.set_ATTRIL_Value(this.varCELine.calledDialog.getLabelIntensityAtt().getLiteral().substring(1));
                                                                                        if (this.varCELine.currentPacCELineCategory != null && !this.varCELine.currentPacCELineCategory.getLabelIntensityAtt().equals(PacIntensityAttributeValues._NONE_LITERAL)) {
                                                                                            CELineLabel.set_ATTRIL_Value(String.valueOf(this.varCELine.currentPacCELineCategory.getLabelIntensityAtt()).substring(1));
                                                                                        }
                                                                                    }
                                                                                    break block85;
                                                                                }
                                                                                if (this.varCELine.currentPacCELineCategory != null && !this.varCELine.currentPacCELineCategory.getLabelIntensityAtt().equals(PacIntensityAttributeValues._NONE_LITERAL)) {
                                                                                    CELineLabel.set_ATTRIL_Value(String.valueOf(this.varCELine.currentPacCELineCategory.getLabelIntensityAtt()).substring(1));
                                                                                } else if (!this.currentScreen.getLabelIntensityAtt().equals(PacIntensityAttributeValues._NONE_LITERAL)) {
                                                                                    CELineLabel.set_ATTRIL_Value(String.valueOf(this.currentScreen.getLabelIntensityAtt()).substring(1));
                                                                                } else if (!this.currentDialog.getLabelIntensityAtt().equals(PacIntensityAttributeValues._NONE_LITERAL)) {
                                                                                    CELineLabel.set_ATTRIL_Value(String.valueOf(this.currentDialog.getLabelIntensityAtt()).substring(1));
                                                                                }
                                                                            }
                                                                            if (!this.varCELine.screenCalled || this.varCELine.calledScreen == null) break block88;
                                                                            if (this.varCELine.calledScreen.getDisplayIntensityAtt().equals(PacIntensityAttributeValues._NONE_LITERAL)) break block89;
                                                                            CELineLabel.set_ATTRIR_Value(this.varCELine.calledScreen.getDisplayIntensityAtt().getLiteral().substring(1));
                                                                            break block90;
                                                                        }
                                                                        if (this.varCELine.calledScreen.getDisplayIntensityAtt().equals(PacIntensityAttributeValues._NONE_LITERAL) || this.varCELine.calledScreen.getDisplayIntensityAtt().equals(this.varCELine.calledDialog.getDisplayIntensityAtt())) {
                                                                            CELineLabel.set_ATTRIR_Value(this.varCELine.calledDialog.getDisplayIntensityAtt().getLiteral().substring(1));
                                                                            if (this.varCELine.currentPacCELineCategory != null && !this.varCELine.currentPacCELineCategory.getFieldIntensityAtt().equals(PacIntensityAttributeValues._NONE_LITERAL)) {
                                                                                CELineLabel.set_ATTRIR_Value(this.varCELine.currentPacCELineCategory.getFieldIntensityAtt().getLiteral().substring(1));
                                                                            }
                                                                        }
                                                                        break block90;
                                                                    }
                                                                    if (this.varCELine.currentPacCELineCategory != null && !this.varCELine.currentPacCELineCategory.getFieldIntensityAtt().equals(PacIntensityAttributeValues._NONE_LITERAL)) {
                                                                        CELineLabel.set_ATTRIR_Value(this.varCELine.currentPacCELineCategory.getFieldIntensityAtt().getLiteral().substring(1));
                                                                    } else if (!this.currentScreen.getDisplayIntensityAtt().equals(PacIntensityAttributeValues._NONE_LITERAL)) {
                                                                        CELineLabel.set_ATTRIR_Value(this.currentScreen.getDisplayIntensityAtt().getLiteral().substring(1));
                                                                    } else if (!this.currentDialog.getDisplayIntensityAtt().equals(PacIntensityAttributeValues._NONE_LITERAL)) {
                                                                        CELineLabel.set_ATTRIR_Value(this.currentDialog.getDisplayIntensityAtt().getLiteral().substring(1));
                                                                    }
                                                                }
                                                                if (aPacCEline.getPresentationAtt().equals(PacPresentationAttributeValues._NONE_LITERAL)) break block91;
                                                                CELineLabel.set_ATTRPL_Value(String.valueOf(aPacCEline.getPresentationAtt()).substring(1));
                                                                break block92;
                                                            }
                                                            if (!this.varCELine.screenCalled || this.varCELine.calledScreen == null) break block93;
                                                            if (this.varCELine.calledScreen.getLabelPresentationAtt().equals(PacPresentationAttributeValues._NONE_LITERAL)) break block94;
                                                            CELineLabel.set_ATTRPL_Value(this.varCELine.calledScreen.getLabelPresentationAtt().getLiteral().substring(1));
                                                            break block92;
                                                        }
                                                        if (this.varCELine.calledScreen.getLabelPresentationAtt().equals(PacPresentationAttributeValues._NONE_LITERAL) || this.varCELine.calledScreen.getLabelPresentationAtt().equals(this.varCELine.calledDialog.getLabelPresentationAtt())) {
                                                            CELineLabel.set_ATTRPL_Value(this.varCELine.calledDialog.getLabelPresentationAtt().getLiteral().substring(1));
                                                            if (this.varCELine.currentPacCELineCategory != null && !this.varCELine.currentPacCELineCategory.getLabelPresentationAtt().equals(PacPresentationAttributeValues._NONE_LITERAL)) {
                                                                CELineLabel.set_ATTRPL_Value(String.valueOf(this.varCELine.currentPacCELineCategory.getLabelPresentationAtt()).substring(1));
                                                            }
                                                        }
                                                        break block92;
                                                    }
                                                    if (this.varCELine.currentPacCELineCategory != null && !this.varCELine.currentPacCELineCategory.getLabelPresentationAtt().equals(PacPresentationAttributeValues._NONE_LITERAL)) {
                                                        CELineLabel.set_ATTRPL_Value(String.valueOf(this.varCELine.currentPacCELineCategory.getLabelPresentationAtt()).substring(1));
                                                    } else if (!this.currentScreen.getLabelPresentationAtt().equals(PacPresentationAttributeValues._NONE_LITERAL)) {
                                                        CELineLabel.set_ATTRPL_Value(String.valueOf(this.currentScreen.getLabelPresentationAtt()).substring(1));
                                                    } else if (!this.currentDialog.getLabelPresentationAtt().equals(PacPresentationAttributeValues._NONE_LITERAL)) {
                                                        CELineLabel.set_ATTRPL_Value(String.valueOf(this.currentDialog.getLabelPresentationAtt()).substring(1));
                                                    }
                                                }
                                                if (!this.varCELine.screenCalled || this.varCELine.calledScreen == null) break block95;
                                                if (this.varCELine.calledScreen.getDisplayPresentationAtt().equals(PacPresentationAttributeValues._NONE_LITERAL)) break block96;
                                                CELineLabel.set_ATTRPR_Value(this.varCELine.calledScreen.getDisplayPresentationAtt().getLiteral().substring(1));
                                                break block97;
                                            }
                                            if (this.varCELine.calledScreen.getDisplayPresentationAtt().equals(PacPresentationAttributeValues._NONE_LITERAL) || this.varCELine.calledScreen.getDisplayPresentationAtt().equals(this.varCELine.calledDialog.getDisplayPresentationAtt())) {
                                                CELineLabel.set_ATTRPR_Value(this.varCELine.calledDialog.getDisplayPresentationAtt().getLiteral().substring(1));
                                                if (this.varCELine.currentPacCELineCategory != null && !this.varCELine.currentPacCELineCategory.getFieldPresentationAtt().equals(PacPresentationAttributeValues._NONE_LITERAL)) {
                                                    CELineLabel.set_ATTRPR_Value(this.varCELine.currentPacCELineCategory.getFieldPresentationAtt().getLiteral().substring(1));
                                                }
                                            }
                                            break block97;
                                        }
                                        if (this.varCELine.currentPacCELineCategory != null && !this.varCELine.currentPacCELineCategory.getFieldPresentationAtt().equals(PacPresentationAttributeValues._NONE_LITERAL)) {
                                            CELineLabel.set_ATTRPR_Value(this.varCELine.currentPacCELineCategory.getFieldPresentationAtt().getLiteral().substring(1));
                                        } else if (!this.currentScreen.getDisplayPresentationAtt().equals(PacPresentationAttributeValues._NONE_LITERAL)) {
                                            CELineLabel.set_ATTRPR_Value(this.currentScreen.getDisplayPresentationAtt().getLiteral().substring(1));
                                        } else if (!this.currentDialog.getDisplayPresentationAtt().equals(PacPresentationAttributeValues._NONE_LITERAL)) {
                                            CELineLabel.set_ATTRPR_Value(this.currentDialog.getDisplayPresentationAtt().getLiteral().substring(1));
                                        }
                                    }
                                    if (aPacCEline.getColorAtt().equals(PacColorAttributeValues._NONE_LITERAL)) break block98;
                                    CELineLabel.set_ATTRCL_Value(String.valueOf(aPacCEline.getColorAtt()).substring(1));
                                    break block99;
                                }
                                if (!this.varCELine.screenCalled || this.varCELine.calledScreen == null) break block100;
                                if (this.varCELine.calledScreen.getLabelColorAtt().equals(PacColorAttributeValues._NONE_LITERAL)) break block101;
                                CELineLabel.set_ATTRCL_Value(this.varCELine.calledScreen.getLabelColorAtt().getLiteral().substring(1));
                                break block99;
                            }
                            if (this.varCELine.calledScreen.getLabelColorAtt().equals(PacColorAttributeValues._NONE_LITERAL) || this.varCELine.calledScreen.getLabelColorAtt().equals(this.varCELine.calledDialog.getLabelColorAtt())) {
                                CELineLabel.set_ATTRCL_Value(this.varCELine.calledDialog.getLabelColorAtt().getLiteral().substring(1));
                                if (this.varCELine.currentPacCELineCategory != null && !this.varCELine.currentPacCELineCategory.getLabelColorAtt().equals(PacColorAttributeValues._NONE_LITERAL)) {
                                    CELineLabel.set_ATTRCL_Value(String.valueOf(this.currentScreen.getLabelColorAtt()).substring(1));
                                }
                            }
                            break block99;
                        }
                        if (this.varCELine.currentPacCELineCategory != null && !this.varCELine.currentPacCELineCategory.getLabelColorAtt().equals(PacColorAttributeValues._NONE_LITERAL)) {
                            CELineLabel.set_ATTRCL_Value(String.valueOf(this.currentScreen.getLabelColorAtt()).substring(1));
                        } else if (!this.currentScreen.getLabelColorAtt().equals(PacColorAttributeValues._NONE_LITERAL)) {
                            CELineLabel.set_ATTRCL_Value(String.valueOf(this.currentScreen.getLabelColorAtt()).substring(1));
                        } else if (!this.currentDialog.getLabelColorAtt().equals(PacIntensityAttributeValues._NONE_LITERAL)) {
                            CELineLabel.set_ATTRCL_Value(String.valueOf(this.currentDialog.getLabelColorAtt()).substring(1));
                        }
                    }
                    if (!this.varCELine.screenCalled || this.varCELine.calledScreen == null) break block102;
                    if (this.varCELine.calledScreen.getDisplayColorAtt().equals(PacColorAttributeValues._NONE_LITERAL)) break block103;
                    CELineLabel.set_ATTRCR_Value(this.varCELine.calledScreen.getDisplayColorAtt().getLiteral().substring(1));
                    break block104;
                }
                if (this.varCELine.calledScreen.getDisplayColorAtt().equals(PacColorAttributeValues._NONE_LITERAL) || this.varCELine.calledScreen.getDisplayColorAtt().equals(this.varCELine.calledDialog.getDisplayColorAtt())) {
                    CELineLabel.set_ATTRCR_Value(this.varCELine.calledDialog.getDisplayColorAtt().getLiteral().substring(1));
                    if (this.varCELine.currentPacCELineCategory != null && !this.varCELine.currentPacCELineCategory.getFieldColorAtt().equals(PacColorAttributeValues._NONE_LITERAL)) {
                        CELineLabel.set_ATTRCR_Value(this.varCELine.currentPacCELineCategory.getFieldColorAtt().getLiteral().substring(1));
                    }
                }
                break block104;
            }
            if (this.varCELine.currentPacCELineCategory != null && !this.varCELine.currentPacCELineCategory.getFieldColorAtt().equals(PacColorAttributeValues._NONE_LITERAL)) {
                CELineLabel.set_ATTRCR_Value(this.varCELine.currentPacCELineCategory.getFieldColorAtt().getLiteral().substring(1));
            } else if (!this.currentScreen.getDisplayColorAtt().equals(PacColorAttributeValues._NONE_LITERAL)) {
                CELineLabel.set_ATTRCR_Value(this.currentScreen.getDisplayColorAtt().getLiteral().substring(1));
            } else if (!this.currentDialog.getDisplayColorAtt().equals(PacColorAttributeValues._NONE_LITERAL)) {
                CELineLabel.set_ATTRCR_Value(this.currentDialog.getDisplayColorAtt().getLiteral().substring(1));
            }
        }
        CELineLabel.set_REPET9_Value("000101");
        CELineLabel.set_NIVST_Value("00");
        CELineLabel.set_ICAT_Value(this.varCELine.currentCategory);
        str = "000" + this.varCELine.currentNulig;
        nbCorubDigit = str.substring(str.length() - 3);
        CELineLabel.set_NULIG_Value(nbCorubDigit);
        return CELineLabel;
    }

    private void formatLabelColumn(EY1I CELine, DataElement DataElementForCELine, PacDataElement pdelt, PacDataElementDescription pacded, int numLabel, int labelLineNumber) {
        String lirub = "";
        this.varCELine.typeCFound = false;
        if (DataElementForCELine != null) {
            String formatDE;
            CELine.set_CORUB_Value(DataElementForCELine.getName());
            int maxLengthLabel = 0;
            if (DataElementForCELine instanceof DataElement) {
                Iterator extensionsElt = DataElementForCELine.getExtensions().iterator();
                while (extensionsElt.hasNext()) {
                    try {
                        pdelt = (PacDataElement)extensionsElt.next();
                    }
                    catch (Exception exception) {}
                }
                Iterator extensions = DataElementForCELine.getDataDescription().getExtensions().iterator();
                while (extensions.hasNext()) {
                    try {
                        pacded = (PacDataElementDescription)extensions.next();
                    }
                    catch (Exception exception) {}
                }
                Iterator DLines = pdelt.getDLines().iterator();
                if (DLines != null) {
                    String[] label = this.findLabelColumn(DLines, numLabel, labelLineNumber, CELine, DataElementForCELine);
                    lirub = label[0];
                    maxLengthLabel = Integer.parseInt(label[1]);
                }
                DataElement parentDataElement = pacded.getParent();
                if (!this.varCELine.typeCFound && lirub.trim().length() < 1) {
                    if (lirub.trim().length() < 1 && pacded.getParent() != null) {
                        Iterator extensionsEltP = parentDataElement.getExtensions().iterator();
                        PacDataElement pdeltP = null;
                        while (extensionsEltP.hasNext()) {
                            try {
                                pdeltP = (PacDataElement)extensionsEltP.next();
                            }
                            catch (Exception exception) {}
                        }
                        Iterator DLinesP = pdeltP.getDLines().iterator();
                        if (DLinesP != null) {
                            String[] label = this.findLabelColumn(DLinesP, numLabel, labelLineNumber, CELine, parentDataElement);
                            lirub = label[0];
                            maxLengthLabel = Integer.parseInt(label[1]);
                        }
                    }
                    CELine.set_LIRUE_Value(lirub);
                }
                if (!this.varCELine.typeCFound && lirub.trim().length() < 1 && numLabel == labelLineNumber - 1) {
                    lirub = DataElementForCELine.getLabel().length() > 1 ? DataElementForCELine.getLabel() : parentDataElement.getLabel();
                }
            }
            int lengthRub = 0;
            String narue = CELine.get_NARUE_Value();
            String[] formLength = this.getFormat(pdelt, pacded, narue);
            String formatL = formLength[0];
            String lengthL = formLength[1];
            int lengthWithCaract = 0;
            int iformat = formatL.length();
            char[] c = new char[iformat];
            formatL.getChars(0, iformat, c, 0);
            int i = 0;
            while (i < iformat) {
                if (c[i] == 'S' || c[i] == '.' || c[i] == '+' || c[i] == '-' || c[i] == 'B' || c[i] == 'V' || c[i] == ',') {
                    ++lengthWithCaract;
                }
                ++i;
            }
            if (lengthL.trim().length() > 0) {
                lengthWithCaract += Integer.parseInt(lengthL);
            }
            CELine.set_LOLIB_Value(String.valueOf(lengthWithCaract));
            lengthRub = lengthWithCaract;
            int lengthLabel = lirub.length();
            if (maxLengthLabel > lengthLabel) {
                lengthLabel = maxLengthLabel;
            }
            if (!this.varCELine.formatIML && this.varCELine.priorLengthLabel > lengthLabel) {
                lengthLabel = this.varCELine.priorLengthLabel;
            }
            if (this.varCELine.typeCFound && lengthRub > lengthLabel && !narue.equals(O_PRESENCECHECK)) {
                lengthLabel = lengthRub;
            }
            if (!this.varCELine.typeCFound) {
                if (lengthLabel > lengthRub) {
                    CELine.set_LIRUE_Value(lirub.substring(0, lengthRub));
                }
                lengthLabel = lengthRub;
            }
            CELine.set_LOLIB_Value(lengthLabel);
            this.varCELine.priorLengthLabel = lengthLabel;
            if (!(this.varCELine.formatIML || this.varCELine.firstIML && this.varCELine.firstIMLLabel)) {
                this.varCELine.priorDELengthLabel = lengthLabel;
                if (CELine.get_LIRUE_Value().trim().length() > 0) {
                    this.varCELine.firstIMLLabel = true;
                }
            }
            if ((formatDE = formLength[0]).substring(0, 1).equals("+") || formatDE.substring(0, 1).equals("-") || formatDE.substring(0, 1).equals("Z") || formatDE.substring(0, 1).equals("9") || formatDE.substring(0, 1).equals(OUTPUT_FORMAT) || formatDE.substring(0, 1).equals("$")) {
                CELine.set_TIPE1_Value("9");
            } else {
                CELine.set_TIPE1_Value("X");
            }
        }
    }

    public void setLOLIBLIRUE(EY1I CELine, DataElement DataElementForCELine, String currentLabelPresentationField, String narue) {
        PacDataElement pdelt = null;
        PacDataElementDescription pacded = null;
        if (currentLabelPresentationField.equals(S_PRESENCECHECK) || currentLabelPresentationField.equals("_T") || currentLabelPresentationField.equals("_U") || currentLabelPresentationField.equals("_R")) {
            String lirub = "";
            String lirubL = "";
            String delim = null;
            if (DataElementForCELine instanceof DataElement) {
                Iterator extensionsElt = DataElementForCELine.getExtensions().iterator();
                while (extensionsElt.hasNext()) {
                    try {
                        pdelt = (PacDataElement)extensionsElt.next();
                    }
                    catch (Exception exception) {}
                }
                Iterator extensions = DataElementForCELine.getDataDescription().getExtensions().iterator();
                while (extensions.hasNext()) {
                    try {
                        pacded = (PacDataElementDescription)extensions.next();
                    }
                    catch (Exception exception) {}
                }
                Iterator DLines = pdelt.getDLines().iterator();
                boolean relationalLirub = false;
                if (DLines != null) {
                    while (DLines.hasNext() && lirub.length() < 1) {
                        int i;
                        PacDLine pPacDLine = (PacDLine)DLines.next();
                        if (pPacDLine.getLineType().equals("L") && !currentLabelPresentationField.equals("_R")) {
                            lirub = pPacDLine.getDescription();
                            delim = pPacDLine.getAllowedValues().trim();
                            if (delim == null || delim.trim().length() <= 0) continue;
                            i = lirub.indexOf(delim);
                            lirub = lirub.substring(0, i);
                            continue;
                        }
                        if (pPacDLine.getLineType().equals("R") && currentLabelPresentationField.equals("_R")) {
                            lirub = pPacDLine.getDescription();
                            relationalLirub = true;
                            continue;
                        }
                        if (!pPacDLine.getLineType().equals("L") || !currentLabelPresentationField.equals("_R")) continue;
                        lirubL = pPacDLine.getDescription();
                        delim = pPacDLine.getAllowedValues().trim();
                        if (delim == null || delim.trim().length() <= 0) continue;
                        i = lirubL.indexOf(delim);
                        lirub = lirubL.substring(0, i);
                    }
                    if (lirub.length() < 1 && currentLabelPresentationField.equals("_R") && !relationalLirub && lirubL.length() > 0) {
                        lirub = lirubL;
                    }
                    if (lirub.length() < 1) {
                        DataElement parentDataElement = null;
                        if (pacded.getParent() != null) {
                            parentDataElement = pacded.getParent();
                            Iterator extensionsPar = parentDataElement.getDataDescription().getExtensions().iterator();
                            while (extensionsPar.hasNext()) {
                                try {
                                    PacDataElementDescription cfr_ignored_0 = (PacDataElementDescription)extensionsPar.next();
                                }
                                catch (Exception exception) {}
                            }
                            PacDataElement pdeltP = null;
                            if (parentDataElement instanceof DataElement) {
                                Iterator extensionsEltP = parentDataElement.getExtensions().iterator();
                                while (extensionsEltP.hasNext()) {
                                    try {
                                        pdeltP = (PacDataElement)extensionsEltP.next();
                                    }
                                    catch (Exception exception) {}
                                }
                                DLines = pdeltP.getDLines().iterator();
                                if (DLines != null) {
                                    while (DLines.hasNext()) {
                                        PacDLine pPacDLine = (PacDLine)DLines.next();
                                        if (!pPacDLine.getLineType().equals("L") || currentLabelPresentationField.equals("_R")) continue;
                                        lirub = pPacDLine.getDescription();
                                    }
                                }
                            }
                        }
                        if (lirub.trim().length() < 1) {
                            lirub = DataElementForCELine.getLabel();
                        }
                        if (lirub.trim().length() < 1 && parentDataElement != null) {
                            lirub = parentDataElement.getLabel();
                        }
                        if (lirub.trim().length() < 1 && parentDataElement != null) {
                            lirub = parentDataElement.getLabel();
                        }
                    }
                    if (!narue.equals(O_PRESENCECHECK)) {
                        if (currentLabelPresentationField.equals("_U")) {
                            if ((lirub = CELineVisitor.CleanEndOfField(lirub)).length() > 18) {
                                lirub = CELineVisitor.CleanEndOfField(lirub.substring(0, 18));
                            }
                            int length = lirub.length() + 1;
                            CELine.set_LOLIB_Value(length);
                            CELine.set_LIRUE_Value(lirub + ":");
                            this.varCELine.columnPositionASave = String.valueOf(Integer.parseInt(this.varCELine.columnPositionASave) + length + 1);
                        } else if (currentLabelPresentationField.equals(S_PRESENCECHECK) || currentLabelPresentationField.equals("_R")) {
                            String initialLirub = "..................:...................";
                            if (lirub.length() > 18) {
                                lirub = lirub.substring(0, 18);
                            }
                            String lirubToAffich = lirub + initialLirub.substring(initialLirub.length() - (initialLirub.length() - lirub.length()));
                            CELine.set_LIRUE_Value(lirubToAffich);
                            CELine.set_LOLIB_Value("019");
                            this.varCELine.columnPositionASave = String.valueOf(Integer.parseInt(this.varCELine.columnPositionASave) + 20);
                        } else if (currentLabelPresentationField.equals("_T")) {
                            int lengthLibel = lirub.length();
                            if (lengthLibel < 19) {
                                int nbBlanc = 18 - lengthLibel;
                                lirubBlanc = "";
                                int i = 0;
                                while (i < nbBlanc) {
                                    lirubBlanc = lirubBlanc.concat(" ");
                                    ++i;
                                }
                                lirub = lirubBlanc.concat(lirub).concat(":");
                            } else {
                                lirub = lirub.substring(0, 19).concat(":");
                            }
                            CELine.set_LIRUE_Value(lirub);
                            CELine.set_LOLIB_Value("019");
                            this.varCELine.columnPositionASave = String.valueOf(Integer.parseInt(this.varCELine.columnPositionASave) + 20);
                        }
                    } else {
                        if (lirub.trim().length() > 19) {
                            lirub = lirub.substring(0, 19);
                        }
                        if (currentLabelPresentationField.equals("_T")) {
                            int lengthLibel = lirub.length();
                            if (lengthLibel < 19) {
                                int nbBlanc = 18 - lengthLibel;
                                lirubBlanc = "";
                                int i = 0;
                                while (i < nbBlanc) {
                                    lirubBlanc = lirubBlanc.concat(" ");
                                    ++i;
                                }
                                lirub = lirubBlanc.concat(lirub);
                            } else {
                                lirub = lirub.substring(0, 19);
                            }
                            CELine.set_LIRUE_Value(lirub);
                            CELine.set_LOLIB_Value("018");
                            this.varCELine.columnPositionASave = String.valueOf(Integer.parseInt(this.varCELine.columnPositionASave) + 19);
                        } else {
                            CELine.set_LIRUE_Value(lirub);
                            if (currentLabelPresentationField.equals("_U") || narue.equals(O_PRESENCECHECK) && delim != null && delim.trim().length() > 0) {
                                if ((lirub = CELineVisitor.CleanEndOfField(lirub)).length() > 18) {
                                    lirub = CELineVisitor.CleanEndOfField(lirub.substring(0, 18));
                                }
                                CELine.set_LOLIB_Value(lirub.length());
                                this.varCELine.columnPositionASave = String.valueOf(Integer.parseInt(this.varCELine.columnPositionASave) + CELine.get_LOLIB_Int_Value() + 1);
                            } else {
                                CELine.set_LOLIB_Value("018");
                                this.varCELine.columnPositionASave = String.valueOf(Integer.parseInt(this.varCELine.columnPositionASave) + 19);
                            }
                        }
                    }
                }
            }
        }
    }

    private String[] findLabelColumn(Iterator<EObject> DLines, int numLabel, int labelLineNumber, EY1I CELine, DataElement DataElementForCELine) {
        String lirub = "";
        int maxLengthLabelI = 0;
        String[] labelAndLength = new String[2];
        while (DLines.hasNext()) {
            PacDLine pPacDLine = (PacDLine)DLines.next();
            if (!pPacDLine.getLineType().equals("C") || this.varCELine.typeCFound) continue;
            this.varCELine.typeCFound = true;
            String labelDelim = "/";
            if (pPacDLine.getAllowedValues().trim().length() > 0) {
                labelDelim = pPacDLine.getAllowedValues().substring(0, 1);
            }
            String completLirub = pPacDLine.getDescription();
            String label1 = "";
            String label2 = "";
            String label3 = "";
            int labelFound = 0;
            StringTokenizer st = new StringTokenizer(completLirub, labelDelim);
            if (st.hasMoreTokens()) {
                label1 = st.nextToken();
                labelFound = 1;
                maxLengthLabelI = label1.length();
                if (numLabel == 0 && label1.length() > 0) {
                    lirub = label1;
                }
            }
            if (st.hasMoreTokens()) {
                label2 = st.nextToken();
                labelFound = 2;
                if (numLabel < labelLineNumber && label2.length() > maxLengthLabelI) {
                    maxLengthLabelI = label2.length();
                }
                if (numLabel == 1 && label2.length() > 0) {
                    lirub = label2;
                }
            }
            if (st.hasMoreTokens()) {
                label3 = st.nextToken();
                labelFound = 3;
                if (numLabel < labelLineNumber && label3.length() > maxLengthLabelI) {
                    maxLengthLabelI = label3.length();
                }
                if (numLabel == 2 && label3.length() > 0) {
                    lirub = label3;
                }
            }
            if (labelFound >= labelLineNumber) continue;
            if (labelFound > 0) {
                if (numLabel == 2) {
                    if (label3.length() >= 1) continue;
                    if (label2.length() > 0) {
                        lirub = label2;
                        continue;
                    }
                    if (label1.length() <= 0) continue;
                    lirub = label1;
                    continue;
                }
                if (numLabel == 1) {
                    if (label2.length() < 1) {
                        lirub = "";
                    } else if (label1.length() > 0) {
                        lirub = label1;
                    }
                    int lastLine = numLabel + 1;
                    if (labelFound != 1 || labelLineNumber != lastLine) continue;
                    lirub = label1;
                    continue;
                }
                if (numLabel != 0) continue;
                lirub = "";
                continue;
            }
            if (numLabel == labelLineNumber) {
                int lgLabel = CELine.get_LOLIB_Int_Value();
                lirub = DataElementForCELine.getLabel().substring(0, lgLabel - 1);
                labelFound = 1;
            } else {
                lirub = "";
            }
            if (labelFound >= labelLineNumber || labelFound <= 0) continue;
            if (numLabel == 2) {
                if (label3.length() >= 1) continue;
                if (label2.length() > 0) {
                    lirub = label2;
                    continue;
                }
                if (label1.length() <= 0) continue;
                lirub = label1;
                continue;
            }
            if (numLabel == 1) {
                if (label2.length() >= 1 || label1.length() <= 0) continue;
                lirub = label1;
                continue;
            }
            if (numLabel != 0) continue;
            lirub = "";
        }
        CELine.set_LIRUE_Value(lirub);
        labelAndLength[0] = lirub;
        labelAndLength[1] = String.valueOf(maxLengthLabelI);
        return labelAndLength;
    }

    public String[] getFormat(PacDataElement pdelt, PacDataElementDescription pacded, String narue) {
        String[] formLen = new String[4];
        String format = "";
        String length = "";
        String decimal = "";
        String formatConversational = "0";
        boolean DlineF = false;
        this.varCELine.caracDelim = pdelt.getGenerationParameter().getDecimalPointDelimiter();
        Iterator DLines = pdelt.getDLines().iterator();
        if (DLines != null) {
            while (DLines.hasNext()) {
                PictureParserForCELines pictureparser;
                PacDLine pPacDLine = (PacDLine)DLines.next();
                if (!pPacDLine.getLineType().equals("F") || DlineF) continue;
                formatConversational = "1";
                DlineF = true;
                if (!(pPacDLine.getAllowedValues().equals(INTERNAL_FORMAT) || pPacDLine.getAllowedValues().equals(OUTPUT_FORMAT) || pPacDLine.getAllowedValues().equals("D") || pPacDLine.getAllowedValues().equals("C") || pPacDLine.getAllowedValues().equals("G") || pPacDLine.getAllowedValues().equals(INPUT_FORMAT) || pPacDLine.getAllowedValues().equals("M") || pPacDLine.getAllowedValues().equals("T") || pPacDLine.getAllowedValues().equals("TS"))) {
                    format = pPacDLine.getDescription();
                    if (format != null && format.length() > 28 && format.substring(29).equals("Z : BLANK WHEN ZERO")) {
                        format = format.substring(0, 28).trim();
                        formatConversational = "Z";
                    }
                    pictureparser = new PictureParserForCELines(format, this.varCELine.caracDelim);
                    length = String.valueOf(CELineVisitor.getLength(pictureparser, 'D', 'X'));
                    decimal = String.valueOf(pictureparser.getDecimals());
                    continue;
                }
                format = pPacDLine.getAllowedValues();
                pictureparser = new PictureParserForCELines(format, this.varCELine.caracDelim);
                length = String.valueOf(CELineVisitor.getLength(pictureparser, 'D', 'X'));
            }
        }
        if (pacded != null && format.length() < 1) {
            if (pacded.getParent() == null) {
                if (!narue.equals("V")) {
                    format = pacded.getOutputFormat();
                    length = String.valueOf(this.getCobolLength(pacded, OUTPUT_FORMAT, 'D'));
                    decimal = String.valueOf(this.getDecimal(pacded, OUTPUT_FORMAT));
                } else {
                    format = pacded.getInternalFormat();
                    char usage = pacded.getInternalUsage().getLiteral().charAt(1);
                    length = String.valueOf(usage).equals("3") ? String.valueOf(this.getCobolLength(pacded, INTERNAL_FORMAT, 'D')) : String.valueOf(this.getCobolLength(pacded, INTERNAL_FORMAT, usage));
                    decimal = String.valueOf(this.getDecimal(pacded, INTERNAL_FORMAT));
                }
            } else {
                DataElement parentDataElement = pacded.getParent();
                PacDataElementDescription pacdedPar = null;
                Iterator extensionsPar = parentDataElement.getDataDescription().getExtensions().iterator();
                while (extensionsPar.hasNext()) {
                    try {
                        pacdedPar = (PacDataElementDescription)extensionsPar.next();
                    }
                    catch (Exception exception) {}
                }
                PacDataElement pdeltP = null;
                if (parentDataElement instanceof DataElement) {
                    Iterator extensionsElt = parentDataElement.getExtensions().iterator();
                    while (extensionsElt.hasNext()) {
                        try {
                            pdeltP = (PacDataElement)extensionsElt.next();
                        }
                        catch (Exception exception) {}
                    }
                    DLines = pdeltP.getDLines().iterator();
                    DlineF = false;
                    if (DLines != null) {
                        while (DLines.hasNext()) {
                            PictureParserForCELines pictureparser;
                            PacDLine pPacDLine = (PacDLine)DLines.next();
                            if (!pPacDLine.getLineType().equals("F") || DlineF) continue;
                            formatConversational = "1";
                            DlineF = true;
                            if (!(pPacDLine.getAllowedValues().equals(INTERNAL_FORMAT) || pPacDLine.getAllowedValues().equals(OUTPUT_FORMAT) || pPacDLine.getAllowedValues().equals("D") || pPacDLine.getAllowedValues().equals("C") || pPacDLine.getAllowedValues().equals("G") || pPacDLine.getAllowedValues().equals(INPUT_FORMAT) || pPacDLine.getAllowedValues().equals("M") || pPacDLine.getAllowedValues().equals("T") || pPacDLine.getAllowedValues().equals("TS"))) {
                                format = pPacDLine.getDescription();
                                if (format != null && format.length() > 28 && format.substring(29).equals("Z : BLANK WHEN ZERO")) {
                                    format = format.substring(0, 28).trim();
                                    formatConversational = "Z";
                                }
                                pictureparser = new PictureParserForCELines(format, this.varCELine.caracDelim);
                                length = String.valueOf(CELineVisitor.getLength(pictureparser, 'D', 'X'));
                                decimal = String.valueOf(pictureparser.getDecimals());
                                continue;
                            }
                            format = pPacDLine.getAllowedValues();
                            pictureparser = new PictureParserForCELines(format, this.varCELine.caracDelim);
                            length = String.valueOf(CELineVisitor.getLength(pictureparser, 'D', 'X'));
                        }
                    }
                }
                if (format.length() < 1) {
                    if (!narue.equals("V")) {
                        if (pacded.getOutputFormat().length() > 0) {
                            format = pacded.getOutputFormat();
                            length = String.valueOf(this.getCobolLength(pacded, OUTPUT_FORMAT, 'D'));
                            decimal = String.valueOf(this.getDecimal(pacded, OUTPUT_FORMAT));
                        } else if (pacdedPar != null && pacdedPar.getOutputFormat() != null) {
                            format = pacdedPar.getOutputFormat();
                            length = String.valueOf(this.getCobolLength(pacdedPar, OUTPUT_FORMAT, 'D'));
                            decimal = String.valueOf(this.getDecimal(pacdedPar, OUTPUT_FORMAT));
                        }
                    } else if (narue.equals("V")) {
                        char usage = 'D';
                        usage = pacded.getInternalUsage().equals(PacDataElementInternalUsageValues._INHERITED_LITERAL) ? (char)pacdedPar.getInternalUsage().getLiteral().charAt(1) : (char)pacded.getInternalUsage().getLiteral().charAt(1);
                        if (pacded.getInternalFormat().length() > 0) {
                            format = pacded.getInternalFormat();
                            length = String.valueOf(usage).equals("3") ? String.valueOf(this.getCobolLength(pacded, INTERNAL_FORMAT, 'D')) : String.valueOf(this.getCobolLength(pacded, INTERNAL_FORMAT, usage));
                            decimal = String.valueOf(this.getDecimal(pacded, INTERNAL_FORMAT));
                        } else if (pacdedPar != null && pacdedPar.getInternalFormat() != null) {
                            format = pacdedPar.getInternalFormat();
                            length = String.valueOf(usage).equals("3") ? String.valueOf(this.getCobolLength(pacdedPar, INTERNAL_FORMAT, 'D')) : String.valueOf(this.getCobolLength(pacdedPar, INTERNAL_FORMAT, usage));
                            decimal = String.valueOf(this.getDecimal(pacdedPar, INTERNAL_FORMAT));
                        }
                    }
                }
            }
        }
        formLen[0] = format;
        formLen[1] = length;
        formLen[2] = formatConversational;
        formLen[3] = decimal;
        return formLen;
    }

    public static String CleanEndOfField(String name) {
        int end = name.length() - 1;
        char[] value = name.toCharArray();
        while (end >= 0 && value[end] <= ' ') {
            --end;
        }
        return new String(value, 0, end + 1);
    }

    public static int getLength(PictureParserForCELines pictureparser, char usg, char varia) {
        if (pictureparser.isNumeric()) {
            PacNumericFormat nf = new PacNumericFormat(pictureparser.getCapacity(), pictureparser.getDecimals(), pictureparser.hasSign(), usg, varia);
            return nf.getTotalLength();
        }
        if (pictureparser.isDate()) {
            PacDateFormat df = null;
            df = pictureparser.getDateFormat() != 'X' ? new PacDateFormat(pictureparser.getDateFormat(), pictureparser.getDateSeparator(), varia) : new PacDateFormat(pictureparser.getDateFormat(), pictureparser.getDateSeparator(), varia, pictureparser.getNbSec(), pictureparser.getTimezone());
            return df.getTotalLength();
        }
        if (pictureparser.isAlphabetic() || pictureparser.isAlphanumeric()) {
            return pictureparser.getCapacity();
        }
        return 0;
    }

    public int getDecimal(PacDataElementDescription kde, String formattype) {
        int dec = 0;
        PictureParserForCELines pictureparser = null;
        if (formattype.equalsIgnoreCase(INTERNAL_FORMAT)) {
            pictureparser = new PictureParserForCELines(kde.getInternalFormat(), this.varCELine.caracDelim);
            dec = pictureparser.getDecimals();
        } else if (formattype.equalsIgnoreCase(INPUT_FORMAT)) {
            pictureparser = new PictureParserForCELines(kde.getInputFormat(), this.varCELine.caracDelim);
            dec = pictureparser.getDecimals();
        } else {
            pictureparser = new PictureParserForCELines(kde.getOutputFormat(), this.varCELine.caracDelim);
            dec = pictureparser.getDecimals();
        }
        return dec;
    }

    private int getCobolLength(PacDataElementDescription kde, String formattype, char usage) {
        int len = 0;
        PictureParserForCELines pictureparser = null;
        if (formattype.equalsIgnoreCase(INTERNAL_FORMAT)) {
            pictureparser = new PictureParserForCELines(kde.getInternalFormat(), this.varCELine.caracDelim);
            if (this.varCELine.formatInterneEtendu) {
                usage = (char)68;
            }
            len = CELineVisitor.getLength(pictureparser, usage, 'X');
        } else if (formattype.equalsIgnoreCase(INPUT_FORMAT)) {
            pictureparser = new PictureParserForCELines(kde.getInputFormat(), this.varCELine.caracDelim);
            len = CELineVisitor.getLength(pictureparser, 'D', 'X');
        } else if (kde.getOutputFormat().trim().length() > 0) {
            pictureparser = new PictureParserForCELines(kde.getOutputFormat(), this.varCELine.caracDelim);
            len = CELineVisitor.getLength(pictureparser, 'D', 'X');
        } else {
            PTTraceManager traceManager = PTTraceManager.getInstance();
            int engineTraceLevel = traceManager.getTraceLevel("com.ibm.pdp.pac");
            if (engineTraceLevel > 0) {
                String message = "AUCUN FORMAT: " + kde.getOwner().getName() + " " + String.valueOf(new Date());
                traceManager.trace(EY00PacbaseAndKernelVisitor.class, "com.ibm.pdp.pac", 1, message);
            }
        }
        return len;
    }

    public void formatCElineFieldIndicator(PacCELineField aPacCElineField) {
        String narue = String.valueOf(aPacCElineField.getFieldNature()).substring(1, 2);
        int cptInd = 0;
        int numer = 101;
        if (narue.equals("V") || narue.equals("F") || narue.equals(P_PRESENCECHECK)) {
            Iterator it2 = aPacCElineField.getIndicators().iterator();
            StringBuilder sb = new StringBuilder();
            boolean isNewCELine = true;
            EY1I CELinetoWrite = null;
            while (it2.hasNext()) {
                PacCELineFieldIndicator indicator = (PacCELineFieldIndicator)it2.next();
                if (isNewCELine) {
                    EY1I CELine = new EY1I(this.varCELine.CELine.getCompleteContentForSegment());
                    PacbaseSegment.GRCLEEY cleEY1I = CELine.get_GRCLEEY_Groupe_Value();
                    cleEY1I.set_G1_Value("M");
                    cleEY1I.set_COCA_Value("H8");
                    cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_GRG5A6_Groupe_Value().set_G6BIS_Value("");
                    cleEY1I.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GB_Value(Integer.toString(++numer));
                    CELine.set_VAREC_Value("Y");
                    CELine.set_GRIND38X_Value(" ");
                    isNewCELine = false;
                    CELinetoWrite = CELine;
                }
                if (cptInd == 3) {
                    this.writeIM_WH8(CELinetoWrite, sb.toString());
                    isNewCELine = true;
                    cptInd = 0;
                    sb = new StringBuilder();
                }
                sb.append(String.valueOf(indicator.getIndicatorNumber()).substring(0));
                sb.append(String.valueOf(indicator.getSwitchIndicator()).substring(1));
                sb.append(String.valueOf(indicator.getAttributeType()).substring(1));
                sb.append(String.valueOf(indicator.getFieldAttribute()).substring(1));
                sb.append(String.valueOf(indicator.getDataAttribute()).substring(1));
                sb.append(" ");
                ++cptInd;
            }
            if (cptInd != 0) {
                this.writeIM_WH8(CELinetoWrite, sb.toString());
            }
        }
    }

    public void formatCElineFieldSpecificStandartScreen(PacCELineField aPacCElineField) {
        PacScreenUpdateOptionValues updateOptionValue1;
        PacCELineFieldComplement pCELineComplement;
        Iterator complementCELines1;
        PacbaseSegment.GRCLEEY cleEY1I;
        String corum;
        EY1I CELine = new EY1I(this.varCELine.CELine.getCompleteContentForSegment());
        String narue = String.valueOf(aPacCElineField.getFieldNature()).substring(1, 2);
        String opep = CELine.get_OPEP_Value();
        String coruba = String.valueOf(CELine.get_GRZSOURA_Groupe_Value().get_CORUBA_Value());
        if (!(coruba.trim().length() >= 1 || CELine.get_TYSOUR_Value().equals("*") || opep.equals(INTERNAL_FORMAT) || opep.equals(O_PRESENCECHECK))) {
            CELine.get_GRZSOURA_Groupe_Value().set_CORUBA_Value(CELine.get_CORUB_Value());
        }
        if ((corum = String.valueOf(CELine.get_CORUM_Value())).trim().length() < 1 && !opep.equals(INTERNAL_FORMAT) && !opep.equals(O_PRESENCECHECK)) {
            CELine.set_CORUM_Value(CELine.get_CORUB_Value());
        }
        if (!this.varCELine.IMSPASWD && (aPacCElineField.getVerticalRepetition() <= 1 && aPacCElineField.getHorizontalRepetition() <= 1 || this.varCELine.dialogComplement.get_GROPTION_Groupe_Value().get_XNOREP_Value().equals("0")) && (narue.equals("F") || narue.equals("V") || narue.equals(P_PRESENCECHECK))) {
            CELine = new EY1I(CELine.getCompleteContentForSegment());
            cleEY1I = CELine.get_GRCLEEY_Groupe_Value();
            cleEY1I.get_GRG3BIS_Groupe_Value().set_G3_Value("D");
            cleEY1I.set_COCA_Value("H4");
            cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_G4_Value(this.varCELine.currentCategory);
            cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_GRG5A6_Groupe_Value().set_G6BIS_Value("");
            boolean H4WDCEline1Write = false;
            complementCELines1 = aPacCElineField.getComplements().iterator();
            if (complementCELines1 != null) {
                pCELineComplement = (PacCELineFieldComplement)complementCELines1.next();
                updateOptionValue1 = pCELineComplement.getUpdateOption();
                if (String.valueOf(pCELineComplement.getUpdateOption()).equals("_G") && !String.valueOf(pCELineComplement.getActionCode()).equals("_O")) {
                    CELine.set_CORUM_Value("");
                    String displaySegCod = pCELineComplement.getDisplaySegmentCode();
                    String delim = this.varCELine.delimGenerateBib;
                    if (!displaySegCod.startsWith(delim) && !displaySegCod.endsWith(delim)) {
                        CELine.get_GRZSOURA_Groupe_Value().set_CORUBA_Value("");
                    } else if (displaySegCod.trim().length() < 5) {
                        CELine.get_GRZSOURA_Groupe_Value().set_CORUBA_Value("");
                    }
                }
                cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_GRG5A6_Value("");
                if (!(updateOptionValue1.equals(PacScreenUpdateOptionValues._S_LITERAL) || updateOptionValue1.equals(PacScreenUpdateOptionValues._G_LITERAL) || updateOptionValue1.equals(PacScreenUpdateOptionValues._V_LITERAL))) {
                    if (!(H4WDCEline1Write || updateOptionValue1.equals(PacScreenUpdateOptionValues._P_LITERAL) || String.valueOf(pCELineComplement.getSourceType()).equals("_STAR") || String.valueOf(pCELineComplement.getSourceType()).equals(S_PRESENCECHECK))) {
                        String cosega = String.valueOf(CELine.get_GRZSOURA_Groupe_Value().get_GRCOSEGA_Groupe_Value());
                        cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_GRG5A6_Value(cosega);
                    }
                    if (!String.valueOf(pCELineComplement.getUpdateOption()).equals("_None")) {
                        CELine.set_OPMAJ_Value(this.getUpdateOption(String.valueOf(pCELineComplement.getUpdateOption())));
                        String corumZ = String.valueOf(CELine.get_CORUM_Value());
                        if (corumZ.trim().length() < 1 && pCELineComplement.getUpdateSegmentCode().trim().length() > 3) {
                            CELine.set_FIENR_Value(pCELineComplement.getUpdateSegmentCode().substring(0, 4));
                            CELine.set_CORUM_Value(pCELineComplement.getUpdateSegmentCode().substring(4));
                        }
                    } else {
                        CELine.set_OPMAJ_Value("");
                    }
                    CELine.set_VAREC_Value("");
                    PacLabelPresentationValues labelPresentation = this.determineLabelPresentation(aPacCElineField.getLabelPresentation(), (PacScreen)aPacCElineField.getOwner());
                    if (aPacCElineField.getInitialValue() != null && aPacCElineField.getInitialValue().length() > 0 || !labelPresentation.equals(PacLabelPresentationValues._F_LITERAL) && !labelPresentation.equals(PacLabelPresentationValues._NONE_LITERAL) && aPacCElineField.getInitialValue().trim().length() > 0) {
                        CELine.set_VAREC_Value(INTERNAL_FORMAT);
                    } else if (aPacCElineField.getSimulationValue() != null && aPacCElineField.getSimulationValue().trim().length() > 0) {
                        CELine.set_VAREC_Value(P_PRESENCECHECK);
                    } else if (aPacCElineField.getIndAttributePosition() != null && aPacCElineField.getIndAttributePosition().trim().length() > 0) {
                        CELine.set_VAREC_Value("Y");
                        CELine.get_GRIND38X_Groupe_Value().set_IND38_Value(aPacCElineField.getIndAttributePosition().trim().substring(1));
                    }
                }
                if (!(H4WDCEline1Write || updateOptionValue1.equals(PacScreenUpdateOptionValues._S_LITERAL) || updateOptionValue1.equals(PacScreenUpdateOptionValues._G_LITERAL) || updateOptionValue1.equals(PacScreenUpdateOptionValues._V_LITERAL))) {
                    this.varCELine.screenLines.add((PacbaseSegment)CELine);
                    H4WDCEline1Write = true;
                    this.initializeListForWBH5LineForStandartScreen(CELine);
                }
            } else {
                this.varCELine.screenLines.add((PacbaseSegment)CELine);
                this.initializeListForWBH5LineForStandartScreen(CELine);
            }
        }
        if ((narue.equals("F") || narue.equals("V")) && !String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") && !this.varCELine.IMSPASWD) {
            CELine = new EY1I(CELine.getCompleteContentForSegment());
            cleEY1I = CELine.get_GRCLEEY_Groupe_Value();
            cleEY1I.get_GRG3BIS_Groupe_Value().set_G3_Value("D");
            cleEY1I.set_COCA_Value("H6");
            cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_G4_Value(this.varCELine.currentCategory);
            cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_GRG5A6_Groupe_Value().set_G5_Value("   ");
            cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_GRG5A6_Groupe_Value().set_G6BIS_Value(this.varCELine.EY1IICAT);
            CELine.set_VAREC_Value("");
            PacLabelPresentationValues labelPresentation = this.determineLabelPresentation(aPacCElineField.getLabelPresentation(), (PacScreen)aPacCElineField.getOwner());
            if (aPacCElineField.getInitialValue() != null && aPacCElineField.getInitialValue().length() > 0 || !labelPresentation.equals(PacLabelPresentationValues._F_LITERAL) && !labelPresentation.equals(PacLabelPresentationValues._NONE_LITERAL) && aPacCElineField.getInitialValue().trim().length() > 0) {
                CELine.set_VAREC_Value(INTERNAL_FORMAT);
            } else if (aPacCElineField.getSimulationValue() != null && aPacCElineField.getSimulationValue().trim().length() > 0) {
                CELine.set_VAREC_Value(P_PRESENCECHECK);
            } else if (aPacCElineField.getIndAttributePosition() != null && aPacCElineField.getIndAttributePosition().trim().length() > 0) {
                CELine.set_VAREC_Value("Y");
                CELine.get_GRIND38X_Groupe_Value().set_IND38_Value(aPacCElineField.getIndAttributePosition().trim().substring(1));
            }
            complementCELines1 = aPacCElineField.getComplements().iterator();
            if (complementCELines1 != null) {
                pCELineComplement = (PacCELineFieldComplement)complementCELines1.next();
                updateOptionValue1 = pCELineComplement.getUpdateOption();
                if (!String.valueOf(updateOptionValue1).equals("_None")) {
                    CELine.set_OPMAJ_Value(this.getUpdateOption(String.valueOf(updateOptionValue1)));
                } else {
                    CELine.set_OPMAJ_Value("");
                }
                CELine.set_TYSOUR_Value("");
                if (!String.valueOf(pCELineComplement.getSourceType()).equals("_None")) {
                    if (String.valueOf(pCELineComplement.getSourceType()).equals("_STAR")) {
                        CELine.set_TYSOUR_Value("*");
                    } else {
                        CELine.set_TYSOUR_Value(String.valueOf(pCELineComplement.getSourceType()).substring(1));
                    }
                }
            }
            this.varCELine.screenLines.add((PacbaseSegment)CELine);
        }
        if (!this.varCELine.IMSPASWD && (aPacCElineField.getVerticalRepetition() <= 1 && aPacCElineField.getHorizontalRepetition() <= 1 || this.varCELine.dialogComplement.get_GROPTION_Groupe_Value().get_XNOREP_Value().equals("0")) && narue.equals("V")) {
            boolean H4WBCEline1Write = false;
            boolean updateOptionDifferentG = false;
            CELine = new EY1I(CELine.getCompleteContentForSegment());
            PacbaseSegment.GRCLEEY cleEY1I2 = CELine.get_GRCLEEY_Groupe_Value();
            cleEY1I2.get_GRG3BIS_Groupe_Value().set_G3_Value("B");
            cleEY1I2.set_COCA_Value("H4");
            cleEY1I2.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_G4_Value("  ");
            if (opep.equals(INTERNAL_FORMAT) || opep.equals(O_PRESENCECHECK)) {
                cleEY1I2.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_G4_Value("  ");
                cleEY1I2.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_GRG5A6_Groupe_Value().set_G5_Value("   ");
                cleEY1I2.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_GRG5A6_Groupe_Value().set_G6BIS_Value(this.varCELine.EY1IICAT);
            }
            if (String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey")) {
                CELine.set_CORUB_Value("PFKEY");
                CELine.set_LOLIB_Value("002");
                CELine.set_TLIB_Value(" ");
                CELine.set_TIPE1_Value("X");
                cleEY1I2.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_G4_Value("  ");
                cleEY1I2.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_GRG5A6_Groupe_Value().set_G5_Value("   ");
                cleEY1I2.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_GRG5A6_Groupe_Value().set_G6BIS_Value(this.varCELine.currentCategory + "  ");
            }
            Iterator complementCELines = aPacCElineField.getComplements().iterator();
            this.varCELine.useDDataEltForControl = true;
            if (complementCELines == null && !String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") || complementCELines == null && String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") && !this.varCELine.H4WBForPFKEY) {
                this.varCELine.screenLines.add((PacbaseSegment)CELine);
                H4WBCEline1Write = true;
                if (String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey")) {
                    this.varCELine.H4WBForPFKEY = true;
                }
            }
            int numGB = 0;
            if (complementCELines != null) {
                String actionCodeSave = "";
                boolean firstCELineRub = true;
                boolean firstCELineRubI = true;
                boolean firstCELineRubO = true;
                boolean firstCELineRubV = true;
                EY22 CELineRub1I = null;
                EY22 CELineRub1O = null;
                EY22 CELineRub1V = null;
                EY22 CELineRub = null;
                EY1I CELineG = null;
                Object updateOptionValuePrior = null;
                PacCELineFieldComplement pCELineComplement1 = null;
                boolean firstComplCElineForWBH4 = true;
                boolean suitePFPKEY = false;
                while (complementCELines.hasNext()) {
                    String strNumGB;
                    String actionCde;
                    PacScreenUpdateOptionValues updateOptionValue;
                    PacCELineFieldComplement pCELineComplement2 = (PacCELineFieldComplement)complementCELines.next();
                    if (firstComplCElineForWBH4) {
                        pCELineComplement1 = pCELineComplement2;
                    }
                    PacScreenPresenceCheckValues presenceCheck = pCELineComplement2.getPresenceCheck();
                    if (firstComplCElineForWBH4 && this.varCELine.useDDataEltForControl && (presenceCheck.equals(PacScreenPresenceCheckValues._F_LITERAL) || presenceCheck.equals(PacScreenPresenceCheckValues._S_LITERAL) || presenceCheck.equals(PacScreenPresenceCheckValues._N_LITERAL))) {
                        this.varCELine.useDDataEltForControl = false;
                    }
                    if (!(updateOptionValue = pCELineComplement2.getUpdateOption()).equals(PacScreenUpdateOptionValues._G_LITERAL)) {
                        updateOptionDifferentG = true;
                    }
                    if (!(updateOptionValue.equals(PacScreenUpdateOptionValues._G_LITERAL) || H4WBCEline1Write || String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") && (!String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") || this.varCELine.H4WBForPFKEY))) {
                        if (updateOptionValuePrior != null && !updateOptionValuePrior.equals(updateOptionValue)) {
                            if (!String.valueOf(updateOptionValuePrior).equals("_None")) {
                                CELine.set_OPMAJ_Value(this.getUpdateOption(String.valueOf(updateOptionValuePrior)));
                            } else {
                                CELine.set_OPMAJ_Value("");
                            }
                        }
                        int specifNuligForPFKEYWB_H4 = this.varCELine.currentNulig;
                        if (String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") && this.varCELine.currentCategory.equals("R")) {
                            String strNulig = "000" + ++specifNuligForPFKEYWB_H4;
                            String Nulig3 = strNulig.substring(strNulig.length() - 3);
                            cleEY1I2.get_GRG9AB_Groupe_Value().set_GRG9_Value(Nulig3);
                        }
                        this.varCELine.screenLines.add((PacbaseSegment)CELine);
                        H4WBCEline1Write = true;
                        if (String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey")) {
                            this.varCELine.H4WBForPFKEY = true;
                        }
                    }
                    if (updateOptionValue.equals(PacScreenUpdateOptionValues._G_LITERAL) && !H4WBCEline1Write && aPacCElineField.getFieldType().equals(PacScreenFieldTypeValues._PF_KEY_LITERAL) && !this.varCELine.H4WBForPFKEY && this.varCELine.isOptionSWAP) {
                        if (updateOptionValuePrior != null && !updateOptionValuePrior.equals(updateOptionValue)) {
                            if (!String.valueOf(updateOptionValuePrior).equals("_None")) {
                                CELine.set_OPMAJ_Value(this.getUpdateOption(String.valueOf(updateOptionValuePrior)));
                            } else {
                                CELine.set_OPMAJ_Value("");
                            }
                        }
                        EY1I CELinePF = new EY1I(CELine.getCompleteContentForSegment());
                        CELinePF.set_NIVST_Value("00");
                        CELinePF.set_ATTRCL_Value(" ");
                        CELinePF.set_ATTRCR_Value(" ");
                        CELinePF.set_ATTRIL_Value(" ");
                        CELinePF.set_ATTRIR_Value(" ");
                        CELinePF.set_ATTRPL_Value(" ");
                        CELinePF.set_ATTRPR_Value(" ");
                        CELinePF.set_ATTRZR_Value(" ");
                        CELinePF.set_GRFORMAT_Value("     ");
                        CELinePF.set_LIRUE_Value("                                    ");
                        CELinePF.set_REPET9_Value(" ");
                        this.varCELine.screenLines.add(this.instantiateFirstWM_H4_ForDebranchScreen(CELinePF));
                    }
                    if (!(actionCde = String.valueOf(pCELineComplement2.getActionCode()).substring(1)).equals("None")) {
                        actionCodeSave = actionCde;
                    }
                    if (String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") && H4WBCEline1Write && updateOptionValue.equals(PacScreenUpdateOptionValues._NONE_LITERAL) && this.varCELine.H4WBForPFKEY && !firstComplCElineForWBH4 && pCELineComplement2.getUpdateSegmentCode() != null && pCELineComplement2.getUpdateSegmentCode().trim().length() > 0) {
                        suitePFPKEY = true;
                    }
                    if (updateOptionValue.equals(PacScreenUpdateOptionValues._V_LITERAL) || suitePFPKEY && !firstCELineRubO) {
                        CELineRub = new EY22();
                        CELineRub.set_GRCLEEY_Value(String.valueOf(CELine.get_GRCLEEY_Groupe_Value()));
                        PacbaseSegment.GRCLEEY cleEY22 = CELineRub.get_GRCLEEY_Groupe_Value();
                        cleEY22.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GA_Value(INPUT_FORMAT);
                        strNumGB = String.valueOf(100 + ++numGB);
                        String NumGBS = strNumGB.substring(strNumGB.length() - 3);
                        cleEY22.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GB_Value(NumGBS);
                        if (aPacCElineField.getDataElement() != null) {
                            CELineRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRI22_Groupe_Value().set_CORUB_Value(aPacCElineField.getDataElement().getName());
                        } else if (String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") && aPacCElineField.getDataElement() == null) {
                            CELineRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRI22_Groupe_Value().set_CORUB_Value("PFKEY");
                        }
                        CELineRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRI22_Groupe_Value().set_NULIG_Value(NumGBS);
                        CELineRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRCARTE6_Groupe_Value().set_TYCOD_Value(actionCodeSave);
                        if (pCELineComplement2.getUpdateSegmentCode().length() > 0) {
                            CELineRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRCARTE6_Groupe_Value().set_VALRU_Value(pCELineComplement2.getUpdateSegmentCode());
                        } else if (pCELineComplement2.getDisplaySegmentCode().length() > 0) {
                            CELineRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRCARTE6_Groupe_Value().set_VALRU_Value(pCELineComplement2.getDisplaySegmentCode());
                        } else {
                            CELineRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRCARTE6_Groupe_Value().set_VALRU_Value("");
                        }
                        if (actionCodeSave.equals(O_PRESENCECHECK) || actionCodeSave.equals(INTERNAL_FORMAT)) {
                            CELineRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRCARTE6_Groupe_Value().set_VALRU_Value(pCELineComplement2.getDisplaySegmentCode());
                            CELineRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRCARTE6_Groupe_Value().set_SAVED_Value(pCELineComplement2.getUpdateSegmentCode());
                        }
                        if (firstComplCElineForWBH4) {
                            if (actionCodeSave.equals(INTERNAL_FORMAT)) {
                                CELineRub1I = new EY22(CELineRub.getCompleteContentForSegment());
                                firstCELineRubI = false;
                            } else if (actionCodeSave.equals(O_PRESENCECHECK)) {
                                CELineRub1O = new EY22(CELineRub.getCompleteContentForSegment());
                                firstCELineRubO = false;
                            } else if (firstComplCElineForWBH4 && updateOptionValue.equals(PacScreenUpdateOptionValues._V_LITERAL)) {
                                CELineRub1V = new EY22(CELineRub.getCompleteContentForSegment());
                                firstCELineRubV = false;
                            } else {
                                this.varCELine.screenLines.add((PacbaseSegment)CELineRub);
                            }
                            firstCELineRub = false;
                        } else {
                            this.varCELine.screenLines.add((PacbaseSegment)CELineRub);
                        }
                    }
                    if (updateOptionValue.equals(PacScreenUpdateOptionValues._G_LITERAL) && (!actionCde.equals(O_PRESENCECHECK) || !firstComplCElineForWBH4 && pCELineComplement1.getActionCode().equals(PacScreenActionCodeValues._O_LITERAL))) {
                        PacScreen screenForDebranch;
                        if (!H4WBCEline1Write) {
                            cleEY1I2.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GA_Value(" ");
                            cleEY1I2.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GB_Value("   ");
                            String displaySegCod = pCELineComplement2.getDisplaySegmentCode();
                            String delim = this.varCELine.delimGenerateBib;
                            if (!(CELine.get_GRZSOURA_Groupe_Value().getCompleteContentForSegment().trim().equals("SPACE") || displaySegCod.startsWith(delim) || displaySegCod.endsWith(delim))) {
                                CELine.get_GRZSOURA_Groupe_Value().set_CORUBA_Value("      ");
                            } else if (!CELine.get_GRZSOURA_Groupe_Value().getCompleteContentForSegment().trim().equals("SPACE") && displaySegCod.trim().length() < 5) {
                                CELine.get_GRZSOURA_Groupe_Value().set_CORUBA_Value("");
                            }
                            CELine.set_OPMAJ_Value(this.getUpdateOption(String.valueOf(pCELineComplement2.getUpdateOption())));
                            if (!String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") || String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") && !this.varCELine.H4WBForPFKEY) {
                                PacScreen screenForDebranch2;
                                if (pCELineComplement1.getScreen() != null && (screenForDebranch2 = pCELineComplement1.getScreen()).getName().length() > 4) {
                                    String extName = screenForDebranch2.getName();
                                    if (screenForDebranch2.getProgramExternalName() != null && screenForDebranch2.getProgramExternalName().trim().length() > 0) {
                                        extName = screenForDebranch2.getProgramExternalName();
                                    }
                                    CELine.set_FIENR_Value(extName.substring(0, 4));
                                    CELine.set_CORUM_Value(extName.substring(4));
                                }
                                int specifNuligForPFKEYWB_H4 = this.varCELine.currentNulig;
                                if (String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") && this.varCELine.currentCategory.equals("R")) {
                                    String strNulig = "000" + ++specifNuligForPFKEYWB_H4;
                                    String Nulig3 = strNulig.substring(strNulig.length() - 3);
                                    cleEY1I2.get_GRG9AB_Groupe_Value().set_GRG9_Value(Nulig3);
                                }
                                this.varCELine.screenLines.add((PacbaseSegment)CELine);
                                H4WBCEline1Write = true;
                                if (String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey")) {
                                    this.varCELine.H4WBForPFKEY = true;
                                    if (this.varCELine.isOptionSWAP) {
                                        EY1I CELinePF = new EY1I(CELine.getCompleteContentForSegment());
                                        CELinePF.set_NIVST_Value("00");
                                        CELinePF.set_ATTRCL_Value(" ");
                                        CELinePF.set_ATTRCR_Value(" ");
                                        CELinePF.set_ATTRIL_Value(" ");
                                        CELinePF.set_ATTRIR_Value(" ");
                                        CELinePF.set_ATTRPL_Value(" ");
                                        CELinePF.set_ATTRPR_Value(" ");
                                        CELinePF.set_ATTRZR_Value(" ");
                                        CELinePF.set_GRFORMAT_Value("     ");
                                        CELinePF.set_LIRUE_Value("                                    ");
                                        CELinePF.set_REPET9_Value(" ");
                                        this.varCELine.screenLines.add(this.instantiateFirstWM_H4_ForDebranchScreen(CELinePF));
                                    }
                                }
                            }
                        }
                        CELine = new EY1I(CELine.getCompleteContentForSegment());
                        CELineG = new EY1I();
                        cleEY1I2 = CELine.get_GRCLEEY_Groupe_Value();
                        cleEY1I2.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GA_Value(INTERNAL_FORMAT);
                        strNumGB = String.valueOf(100 + ++numGB);
                        String NumGBS = strNumGB.substring(strNumGB.length() - 3);
                        cleEY1I2.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GB_Value(NumGBS);
                        CELineG.set_GRCLEEY_Value(String.valueOf(cleEY1I2));
                        CELineG = this.instantiateFirstWB_H4_ForDebranchScreen(aPacCElineField, CELineG, pCELineComplement2, H4WBCEline1Write, firstComplCElineForWBH4);
                        if (pCELineComplement2.getScreen() != null && (screenForDebranch = pCELineComplement2.getScreen()).getTransactionCode() != null && screenForDebranch.getTransactionCode().trim().length() > 0) {
                            CELine.set_FIENR_Value(screenForDebranch.getTransactionCode());
                        }
                        if (!H4WBCEline1Write) {
                            cleEY1I2.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GA_Value(" ");
                            cleEY1I2.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GB_Value("   ");
                            CELine.get_GRZSOURA_Groupe_Value().set_CORUBA_Value("      ");
                            if (!String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") || String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") && !this.varCELine.H4WBForPFKEY) {
                                this.varCELine.screenLines.add((PacbaseSegment)CELine);
                                H4WBCEline1Write = true;
                                if (String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey")) {
                                    this.varCELine.H4WBForPFKEY = true;
                                }
                            }
                        }
                    }
                    updateOptionValuePrior = updateOptionValue;
                    firstComplCElineForWBH4 = false;
                }
                int numGBV = 0;
                if (!firstCELineRub) {
                    int numGB1 = Integer.parseInt(CELineRub.get_GRCLEEY_Groupe_Value().get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().get_GB_Value());
                    String strNumGB1 = "000" + ++numGB1;
                    String NumGBS1 = strNumGB1.substring(strNumGB1.length() - 3);
                    firstCELineRub = true;
                    numGBV = numGB1;
                    if (!firstCELineRubI) {
                        CELineRub1I.get_GRCLEEY_Groupe_Value().get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GB_Value(NumGBS1);
                        CELineRub1I.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRI22_Groupe_Value().set_NULIG_Value(NumGBS1);
                        this.varCELine.screenLines.add((PacbaseSegment)CELineRub1I);
                        firstCELineRubI = true;
                    }
                    if (!firstCELineRubO) {
                        int numGBO = Integer.parseInt(NumGBS1);
                        if (CELineG != null && (numGBO = Integer.parseInt(CELineG.get_GRCLEEY_Groupe_Value().get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().get_GB_Value())) <= numGB1) {
                            numGBO = ++numGB1;
                        }
                        String strNumGBO = "000" + ++numGBO;
                        String NumGBSO = strNumGBO.substring(strNumGBO.length() - 3);
                        numGBV = numGBO;
                        CELineRub1O.get_GRCLEEY_Groupe_Value().get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GB_Value(NumGBSO);
                        CELineRub1O.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRI22_Groupe_Value().set_NULIG_Value(NumGBSO);
                        this.varCELine.screenLines.add((PacbaseSegment)CELineRub1O);
                        firstCELineRubO = true;
                    }
                }
                if (!firstComplCElineForWBH4 && !firstCELineRubV && CELineRub1V != null) {
                    String strNumGBV = "000" + ++numGBV;
                    String NumGBSV = strNumGBV.substring(strNumGBV.length() - 3);
                    CELineRub1V.get_GRCLEEY_Groupe_Value().get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GB_Value(NumGBSV);
                    CELineRub1V.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRI22_Groupe_Value().set_NULIG_Value(NumGBSV);
                    this.varCELine.screenLines.add((PacbaseSegment)CELineRub1V);
                    firstCELineRubV = true;
                }
            }
            if (!H4WBCEline1Write && (!String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") || String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") && !this.varCELine.H4WBForPFKEY)) {
                int specifNuligForPFKEYWB_H4 = this.varCELine.currentNulig;
                if (String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") && this.varCELine.currentCategory.equals("R")) {
                    String strNulig = "000" + ++specifNuligForPFKEYWB_H4;
                    String Nulig3 = strNulig.substring(strNulig.length() - 3);
                    cleEY1I2.get_GRG9AB_Groupe_Value().set_GRG9_Value(Nulig3);
                }
                this.varCELine.screenLines.add((PacbaseSegment)CELine);
                H4WBCEline1Write = true;
                if (String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey")) {
                    this.varCELine.H4WBForPFKEY = true;
                }
            }
            if (this.varCELine.useDDataEltForControl && aPacCElineField.getDataElement() != null) {
                PacDataElement pdelt = null;
                PacDataElementDescription pacded = null;
                DataElement DataElementForCELine = aPacCElineField.getDataElement();
                if (DataElementForCELine instanceof DataElement) {
                    Iterator extensionsElt = DataElementForCELine.getExtensions().iterator();
                    while (extensionsElt.hasNext()) {
                        try {
                            pdelt = (PacDataElement)extensionsElt.next();
                        }
                        catch (Exception exception) {}
                    }
                    Iterator DLines = pdelt.getDLines().iterator();
                    pacded = null;
                    Iterator extensions = DataElementForCELine.getDataDescription().getExtensions().iterator();
                    while (extensions.hasNext()) {
                        try {
                            pacded = (PacDataElementDescription)extensions.next();
                        }
                        catch (Exception exception) {}
                    }
                    if (pacded.getParent() != null) {
                        DataElement parentDataElement = pacded.getParent();
                        numGB = this.searchForControlValue(parentDataElement, CELine, numGB, aPacCElineField);
                    }
                    if (!DLines.equals(null)) {
                        while (DLines.hasNext()) {
                            PacDLine pPacDLine = (PacDLine)DLines.next();
                            boolean rubFille = false;
                            if (pPacDLine.getLineType().trim().length() >= 1 && !pPacDLine.getLineType().trim().equals(INTERNAL_FORMAT) && !pPacDLine.getLineType().trim().equals(O_PRESENCECHECK)) continue;
                            EY22 CELineDRub = this.instantiateWB_H4_E(CELine, numGB, aPacCElineField, pPacDLine, rubFille, null);
                            String numGBSt = CELineDRub.get_GRCLEEY_Groupe_Value().get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().get_GB_Value();
                            numGB = Integer.parseInt(numGBSt);
                        }
                    }
                }
            }
            if (String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") && this.varCELine.currentCategory.equals("R") && updateOptionDifferentG) {
                ++this.varCELine.currentNulig;
                this.varCELine.incrementNuligForPFKEY = true;
            }
        }
        int numGB = 0;
        if (!this.varCELine.IMSPASWD && (aPacCElineField.getVerticalRepetition() < 1 && aPacCElineField.getHorizontalRepetition() <= 1 || this.varCELine.dialogComplement.get_GROPTION_Groupe_Value().get_XNOREP_Value().equals("0")) && (narue.equals("V") || narue.equals("F") || narue.equals(P_PRESENCECHECK))) {
            CELine = new EY1I(CELine.getCompleteContentForSegment());
            PacbaseSegment.GRCLEEY cleEY1I3 = CELine.get_GRCLEEY_Groupe_Value();
            if (String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") && this.varCELine.currentCategory.equals("R")) {
                String strNulig = "000" + this.varCELine.currentNulig;
                String Nulig3 = strNulig.substring(strNulig.length() - 3);
                cleEY1I3.get_GRG9AB_Groupe_Value().set_GRG9_Value(Nulig3);
            }
            if (aPacCElineField.getSimulationValue() != null && aPacCElineField.getSimulationValue().length() > 0 && aPacCElineField.getIndAttributePosition() != null && aPacCElineField.getIndAttributePosition().trim().length() > 0) {
                boolean opmajaV = false;
                for (PacCELineFieldComplement pCELineComplement3 : aPacCElineField.getComplements()) {
                    pCELineComplement3.getUpdateOption();
                    if (!String.valueOf(pCELineComplement3.getUpdateOption()).equals("_V")) continue;
                    opmajaV = true;
                    return;
                }
                if (!opmajaV) {
                    EY1I CELineYP = new EY1I(CELine.getCompleteContentForSegment());
                    PacbaseSegment.GRCLEEY cleEY1IYP = CELineYP.get_GRCLEEY_Groupe_Value();
                    cleEY1IYP.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GA_Value(INTERNAL_FORMAT);
                    String strNumGB = String.valueOf(100 + ++numGB);
                    String NumGBS = strNumGB.substring(strNumGB.length() - 3);
                    cleEY1IYP.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GB_Value(NumGBS);
                    cleEY1IYP.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_GRG5A6_Value("");
                    cleEY1IYP.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_G4_Value(this.varCELine.currentCategory);
                    cleEY1IYP.get_GRG3BIS_Groupe_Value().set_G3_Value("D");
                    cleEY1IYP.set_COCA_Value("H4");
                    CELineYP.set_NARUE_Value("");
                    CELineYP.set_TLIB_Value("");
                    CELineYP.set_OPMAJ_Value("");
                    CELineYP.set_LOLIB_Value("   ");
                    CELineYP.set_STRCE_Value("");
                    CELineYP.set_FIENR_Value("");
                    CELineYP.set_TIPE1_Value("");
                    CELineYP.set_PICTU_Value("");
                    CELineYP.get_GRFORMAT_Groupe_Value().set_NBCHA_Value("");
                    CELineYP.get_GRFORMAT_Groupe_Value().set_NBCHP_Value("");
                    String _2BLANCS = new String("  ");
                    CELineYP.set_NULIM_Value(_2BLANCS);
                    CELineYP.set_ATTRIL_Value("");
                    CELineYP.set_ATTRIR_Value("");
                    CELineYP.set_ATTRPL_Value("");
                    CELineYP.set_ATTRPR_Value("");
                    CELineYP.set_ATTRCL_Value("");
                    CELineYP.set_ATTRCR_Value("");
                    CELineYP.set_SUPIC_Value("");
                    CELineYP.set_VAREC_Value("");
                    CELineYP.set_CORUM_Value("");
                    CELineYP.set_ICAT_Value("");
                    String _3BLANCS = new String("   ");
                    CELineYP.set_NULIG_Value(_3BLANCS);
                    CELineYP.set_GRZSOURA_Value("");
                    CELineYP.set_GRIND38X_Value("");
                    this.varCELine.screenLines.add((PacbaseSegment)CELineYP);
                }
            }
            Iterator complementCELines = aPacCElineField.getComplements().iterator();
            String actionCde = "None";
            String actionCdeSave = "None";
            if (complementCELines != null) {
                boolean firstComplCELine = true;
                boolean ComplCELine = false;
                numGB = 0;
                while (complementCELines.hasNext()) {
                    PacCELineFieldComplement pCELineComplement4 = (PacCELineFieldComplement)complementCELines.next();
                    pCELineComplement4.getUpdateOption();
                    String updateOption = String.valueOf(pCELineComplement4.getUpdateOption()).substring(1);
                    String presenceCheck = String.valueOf(pCELineComplement4.getPresenceCheck()).substring(1);
                    if (!pCELineComplement4.getActionCode().equals(PacScreenActionCodeValues._NONE_LITERAL)) {
                        actionCdeSave = actionCde = String.valueOf(pCELineComplement4.getActionCode()).substring(1);
                    } else if (actionCdeSave.equals("None")) {
                        actionCde = "None";
                    }
                    if (narue.equals("V")) {
                        this.instanciateWB_H6(CELine, cleEY1I3, pCELineComplement4, updateOption, ComplCELine, presenceCheck, actionCde, firstComplCELine);
                        cleEY1I3 = CELine.get_GRCLEEY_Groupe_Value();
                    }
                    ComplCELine = false;
                    if (!presenceCheck.equals("None") || !pCELineComplement4.getActionCode().equals(PacScreenActionCodeValues._NONE_LITERAL) || !updateOption.equals("None") || pCELineComplement4.getUpdateSegmentCode() != null && pCELineComplement4.getUpdateSegmentCode().trim().length() > 0 || pCELineComplement4.getDisplaySegmentCode() != null && pCELineComplement4.getDisplaySegmentCode().trim().length() > 0) {
                        ComplCELine = true;
                    }
                    cleEY1I3.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_GRG5A6_Groupe_Value().set_G6BIS_Value("   ");
                    if (ComplCELine && !firstComplCELine) {
                        cleEY1I3.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GA_Value(INTERNAL_FORMAT);
                        String strNumGB = String.valueOf(100 + ++numGB);
                        String NumGBS = strNumGB.substring(strNumGB.length() - 3);
                        cleEY1I3.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GB_Value(NumGBS);
                    } else {
                        cleEY1I3.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GA_Value("");
                        cleEY1I3.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GB_Value("");
                    }
                    CELine.set_NARUE_Value(" ");
                    CELine.set_TLIB_Value(" ");
                    if (pCELineComplement4.getUpdateSegmentCode() != null) {
                        if (pCELineComplement4.getUpdateSegmentCode().trim().length() > 3) {
                            CELine.set_FIENR_Value(pCELineComplement4.getUpdateSegmentCode().substring(0, 4));
                        }
                        CELine.set_LIRUE_Value("                                      ");
                        CELine.set_REPET9_Value("      ");
                        CELine.set_GRZSOURA_Value(pCELineComplement4.getDisplaySegmentCode());
                        CELine.set_NIVST_Value("  ");
                        CELine.set_NULIG_Value("  ");
                        EY1I CELineH4WD = new EY1I(CELine.getCompleteContentForSegment());
                        PacbaseSegment.GRCLEEY cleEY1IH4WD = CELineH4WD.get_GRCLEEY_Groupe_Value();
                        cleEY1IH4WD.get_GRG3BIS_Groupe_Value().set_G3_Value("D");
                        cleEY1IH4WD.set_COCA_Value("H4");
                        CELineH4WD.set_OPMAJ_Value("");
                        CELineH4WD.get_GRCLEEY_Groupe_Value().get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_GRG5A6_Groupe_Value().set_G6BIS_Value("");
                        if (pCELineComplement4.getUpdateSegmentCode() != null && pCELineComplement4.getUpdateSegmentCode().trim().length() > 3) {
                            cleEY1IH4WD.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_GRG5A6_Value(pCELineComplement4.getUpdateSegmentCode().substring(0, 4));
                        }
                        if (pCELineComplement4.getSourceType() != null && !String.valueOf(pCELineComplement4.getSourceType()).equals("_None")) {
                            if (String.valueOf(pCELineComplement4.getSourceType()).equals("_STAR")) {
                                CELineH4WD.set_TYSOUR_Value("*");
                                CELineH4WD.set_GRZSOURA_Value(pCELineComplement4.getDisplaySegmentCode());
                            } else {
                                CELineH4WD.set_TYSOUR_Value(String.valueOf(pCELineComplement4.getSourceType()).substring(1));
                            }
                        }
                        if ((narue.equals("V") || narue.equals("F")) && !String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") && updateOption.equals("None") && pCELineComplement4.getUpdateSegmentCode().trim().length() > 0) {
                            updateOption = "M";
                        }
                        if (String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") && updateOption.equals("None") && pCELineComplement4.getUpdateSegmentCode().trim().length() > 0) {
                            updateOption = "V";
                        }
                        if (!(updateOption.equals(P_PRESENCECHECK) || updateOption.equals("G") || updateOption.equals(OUTPUT_FORMAT) || updateOption.equals("V") || cleEY1I3.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().get_GB_Value().trim().length() <= 0 && !String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") || !ComplCELine || firstComplCELine)) {
                            this.instanciateWD_H4_I(cleEY1IH4WD, pCELineComplement4, ComplCELine, firstComplCELine, CELineH4WD, CELine);
                        }
                        if ((narue.equals("V") || narue.equals("F")) && (updateOption.equals(P_PRESENCECHECK) || updateOption.equals("G")) && ComplCELine && !firstComplCELine) {
                            this.instanciateWB_H4_I(CELine, updateOption, pCELineComplement4, ComplCELine, firstComplCELine);
                        }
                    }
                    CELine.set_OPMAJ_Value("M");
                    if (!(!narue.equals("V") && !narue.equals("F") || updateOption.equals(OUTPUT_FORMAT) || updateOption.equals("G") || updateOption.equals("V") || updateOption.equals(P_PRESENCECHECK) || pCELineComplement4.getUpdateSegmentCode().trim().length() <= 3 || !ComplCELine || firstComplCELine)) {
                        this.instanciateWB_H6_I(CELine, ComplCELine, firstComplCELine, pCELineComplement4, presenceCheck, actionCde, updateOption);
                    }
                    firstComplCELine = false;
                }
            }
        }
        if (this.varCELine.modifyValue) {
            this.varCELine.modifyValue = false;
            this.varCELine.endRepeatCateg = this.varCELine.endRepeatCategS;
            this.varCELine.maxNumberOfVerticalLineForRepetCateg = this.varCELine.maxNumberOfVerticalLineForRepetCategS;
            this.varCELine.maxNumberOfVerticalLine = this.varCELine.maxNumberOfVerticalLineS;
            this.varCELine.repetHorizontalCateg = this.varCELine.repetHorizontalCategS;
            this.varCELine.currentCategory = this.varCELine.currentCategoryS;
            this.varCELine.numLabel = this.varCELine.numLabelS;
            this.varCELine.currentLabelPresentationField = this.varCELine.currentLabelPresentationFieldS;
        }
        if (String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") && Integer.parseInt(this.varCELine.linePositionASave) <= 1) {
            this.varCELine.linePositionASave = "000";
            this.varCELine.columnPositionASave = "00";
        }
        if (this.varCELine.changeValueColumn) {
            aPacCElineField.setColumnPosition(this.varCELine.valueColumn);
        }
        this.varCELine.firstCELineFieldOrLabelForCategZ = 2;
        this.varCELine.firstCElineForScreen = false;
    }

    public void formatCElineFieldSpecificClientScreen(PacCELineField aPacCElineField, String currentOrganisation) {
        Iterator complementCELines;
        String corum = String.valueOf(this.varCELine.CELine.get_CORUM_Value());
        if (corum.trim().length() < 1 && !this.varCELine.CELine.get_OPEP_Value().equals(INTERNAL_FORMAT) && !this.varCELine.CELine.get_OPEP_Value().equals(O_PRESENCECHECK)) {
            this.varCELine.CELine.set_CORUM_Value(this.varCELine.CELine.get_CORUB_Value());
        }
        if (aPacCElineField.getFieldNature().equals(PacScreenFieldNatureValues._V_LITERAL)) {
            boolean H4WDCEline1Write = false;
            boolean H4WBCEline1Write = false;
            this.varCELine.CELine = new EY1I(this.varCELine.CELine.getCompleteContentForSegment());
            PacbaseSegment.GRCLEEY cleEY1I = this.varCELine.CELine.get_GRCLEEY_Groupe_Value();
            cleEY1I.get_GRG3BIS_Groupe_Value().set_G3_Value("D");
            cleEY1I.set_COCA_Value("H4");
            cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_G4_Value("  ");
            if (this.varCELine.CELine.get_OPEP_Value().equals(INTERNAL_FORMAT) || this.varCELine.CELine.get_OPEP_Value().equals(O_PRESENCECHECK)) {
                cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_G4_Value("  ");
                cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_GRG5A6_Groupe_Value().set_G5_Value("   ");
                cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_GRG5A6_Groupe_Value().set_G6BIS_Value(this.varCELine.EY1IICAT);
            }
            if (String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey")) {
                this.varCELine.CELine.set_CORUB_Value("PFKEY");
                this.varCELine.CELine.set_LOLIB_Value("002");
                this.varCELine.CELine.set_TLIB_Value(" ");
                this.varCELine.CELine.set_TIPE1_Value("X");
                cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_G4_Value("  ");
                cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_GRG5A6_Groupe_Value().set_G5_Value("   ");
                int specifNuligForPFKEYWB_H4 = this.varCELine.currentNulig;
                if (this.varCELine.currentCategory.equals("R")) {
                    String strNulig = "000" + ++specifNuligForPFKEYWB_H4;
                    String Nulig3 = strNulig.substring(strNulig.length() - 3);
                    cleEY1I.get_GRG9AB_Groupe_Value().set_GRG9_Value(Nulig3);
                }
            }
            Iterator complementCELines2 = aPacCElineField.getComplements().iterator();
            this.varCELine.useDDataEltForControl = true;
            if (complementCELines2 == null) {
                this.varCELine.screenLines.add((PacbaseSegment)this.varCELine.CELine);
                if (!aPacCElineField.getFieldType().equals(PacScreenFieldTypeValues._PF_KEY_LITERAL)) {
                    this.varCELine.screenLines.add((PacbaseSegment)this.instanciateWEH8FormWDH4(this.varCELine.CELine));
                }
                H4WDCEline1Write = true;
                if (String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey")) {
                    this.varCELine.H4WBForPFKEY = true;
                }
            }
            int numGB = 0;
            if (complementCELines2 != null) {
                String actionCodeSave = "";
                boolean firstCELineRub = true;
                boolean firstCELineRubI = true;
                boolean firstCELineRubO = true;
                boolean firstCELineRubV = true;
                boolean firstComplementLine = true;
                EY22 CELineRub1I = null;
                EY22 CELineRub1O = null;
                EY22 CELineRub1V = null;
                EY22 CELineRub = null;
                EY1I CELineG = null;
                Object updateOptionValuePrior = null;
                PacCELineFieldComplement pCELineComplement1 = null;
                boolean firstComplCElineForWBH4 = true;
                boolean suitePFPKEY = false;
                while (complementCELines2.hasNext()) {
                    String strNumGB;
                    String actionCde;
                    PacScreenUpdateOptionValues updateOptionValue;
                    PacCELineFieldComplement pCELineComplement = (PacCELineFieldComplement)complementCELines2.next();
                    if (firstComplCElineForWBH4) {
                        pCELineComplement1 = pCELineComplement;
                    }
                    PacScreenPresenceCheckValues presenceCheck = pCELineComplement.getPresenceCheck();
                    if (firstComplCElineForWBH4 && this.varCELine.useDDataEltForControl && (presenceCheck.equals(PacScreenPresenceCheckValues._F_LITERAL) || presenceCheck.equals(PacScreenPresenceCheckValues._S_LITERAL) || presenceCheck.equals(PacScreenPresenceCheckValues._N_LITERAL))) {
                        this.varCELine.useDDataEltForControl = false;
                    }
                    if (!H4WDCEline1Write && !aPacCElineField.getFieldType().equals(PacScreenFieldTypeValues._PF_KEY_LITERAL)) {
                        this.varCELine.screenLines.add((PacbaseSegment)this.instanciateWEH8FormWDH4(this.varCELine.CELine));
                        H4WDCEline1Write = true;
                    }
                    if (!(updateOptionValue = pCELineComplement.getUpdateOption()).equals(PacScreenUpdateOptionValues._G_LITERAL)) {
                        // empty if block
                    }
                    if (!(updateOptionValue.equals(PacScreenUpdateOptionValues._G_LITERAL) || H4WBCEline1Write || String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") && (!String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") || this.varCELine.H4WBForPFKEY))) {
                        if (updateOptionValuePrior != null && !updateOptionValuePrior.equals(updateOptionValue)) {
                            if (!String.valueOf(updateOptionValuePrior).equals("_None")) {
                                this.varCELine.CELine.set_OPMAJ_Value(this.getUpdateOption(String.valueOf(updateOptionValuePrior)));
                            } else {
                                this.varCELine.CELine.set_OPMAJ_Value("");
                            }
                        }
                        int specifNuligForPFKEYWB_H4 = this.varCELine.currentNulig;
                        if (String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") && this.varCELine.currentCategory.equals("R")) {
                            String strNulig = "000" + ++specifNuligForPFKEYWB_H4;
                            String Nulig3 = strNulig.substring(strNulig.length() - 3);
                            cleEY1I.get_GRG9AB_Groupe_Value().set_GRG9_Value(Nulig3);
                        }
                        this.varCELine.screenLines.add((PacbaseSegment)this.varCELine.CELine);
                        H4WBCEline1Write = true;
                        if (String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey")) {
                            this.varCELine.H4WBForPFKEY = true;
                        }
                    }
                    if (updateOptionValue.equals(PacScreenUpdateOptionValues._G_LITERAL) && !H4WBCEline1Write && aPacCElineField.getFieldType().equals(PacScreenFieldTypeValues._PF_KEY_LITERAL) && !this.varCELine.H4WBForPFKEY && this.varCELine.isOptionSWAP) {
                        if (updateOptionValuePrior != null && !updateOptionValuePrior.equals(updateOptionValue)) {
                            if (!String.valueOf(updateOptionValuePrior).equals("_None")) {
                                this.varCELine.CELine.set_OPMAJ_Value(this.getUpdateOption(String.valueOf(updateOptionValuePrior)));
                            } else {
                                this.varCELine.CELine.set_OPMAJ_Value("");
                            }
                        }
                        EY1I CELinePF = new EY1I(this.varCELine.CELine.getCompleteContentForSegment());
                        CELinePF.set_NIVST_Value("00");
                        CELinePF.set_ATTRCL_Value(" ");
                        CELinePF.set_ATTRCR_Value(" ");
                        CELinePF.set_ATTRIL_Value(" ");
                        CELinePF.set_ATTRIR_Value(" ");
                        CELinePF.set_ATTRPL_Value(" ");
                        CELinePF.set_ATTRPR_Value(" ");
                        CELinePF.set_ATTRZR_Value(" ");
                        CELinePF.set_GRFORMAT_Value("     ");
                        CELinePF.set_LIRUE_Value("                                    ");
                        CELinePF.set_REPET9_Value(" ");
                        this.varCELine.screenLines.add(this.instantiateFirstWM_H4_ForDebranchScreen(CELinePF));
                    }
                    if (!(actionCde = String.valueOf(pCELineComplement.getActionCode()).substring(1)).equals("None")) {
                        actionCodeSave = actionCde;
                    }
                    if (String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") && H4WBCEline1Write && updateOptionValue.equals(PacScreenUpdateOptionValues._NONE_LITERAL) && this.varCELine.H4WBForPFKEY && !firstComplCElineForWBH4 && pCELineComplement.getUpdateSegmentCode() != null && pCELineComplement.getUpdateSegmentCode().trim().length() > 0) {
                        suitePFPKEY = true;
                    }
                    if (updateOptionValue.equals(PacScreenUpdateOptionValues._V_LITERAL) || suitePFPKEY && !firstCELineRubO) {
                        CELineRub = new EY22();
                        CELineRub.set_GRCLEEY_Value(String.valueOf(this.varCELine.CELine.get_GRCLEEY_Groupe_Value()));
                        PacbaseSegment.GRCLEEY cleEY22 = CELineRub.get_GRCLEEY_Groupe_Value();
                        cleEY22.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GA_Value(INPUT_FORMAT);
                        strNumGB = String.valueOf(100 + ++numGB);
                        String NumGBS = strNumGB.substring(strNumGB.length() - 3);
                        cleEY22.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GB_Value(NumGBS);
                        if (aPacCElineField.getDataElement() != null) {
                            CELineRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRI22_Groupe_Value().set_CORUB_Value(aPacCElineField.getDataElement().getName());
                        } else if (String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") && aPacCElineField.getDataElement() == null) {
                            CELineRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRI22_Groupe_Value().set_CORUB_Value("PFKEY");
                        }
                        CELineRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRI22_Groupe_Value().set_NULIG_Value(NumGBS);
                        CELineRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRCARTE6_Groupe_Value().set_TYCOD_Value(actionCodeSave);
                        if (pCELineComplement.getUpdateSegmentCode().length() > 0) {
                            CELineRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRCARTE6_Groupe_Value().set_VALRU_Value(pCELineComplement.getUpdateSegmentCode());
                        } else if (pCELineComplement.getDisplaySegmentCode().length() > 0) {
                            CELineRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRCARTE6_Groupe_Value().set_VALRU_Value(pCELineComplement.getDisplaySegmentCode());
                        } else {
                            CELineRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRCARTE6_Groupe_Value().set_VALRU_Value("");
                        }
                        if (actionCodeSave.equals(O_PRESENCECHECK) || actionCodeSave.equals(INTERNAL_FORMAT)) {
                            CELineRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRCARTE6_Groupe_Value().set_VALRU_Value(pCELineComplement.getDisplaySegmentCode());
                            CELineRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRCARTE6_Groupe_Value().set_SAVED_Value(pCELineComplement.getUpdateSegmentCode());
                        }
                        if (firstComplCElineForWBH4) {
                            if (actionCodeSave.equals(INTERNAL_FORMAT)) {
                                CELineRub1I = new EY22(CELineRub.getCompleteContentForSegment());
                                firstCELineRubI = false;
                            } else if (actionCodeSave.equals(O_PRESENCECHECK)) {
                                CELineRub1O = new EY22(CELineRub.getCompleteContentForSegment());
                                firstCELineRubO = false;
                            } else if (firstComplCElineForWBH4 && updateOptionValue.equals(PacScreenUpdateOptionValues._V_LITERAL)) {
                                CELineRub1V = new EY22(CELineRub.getCompleteContentForSegment());
                                firstCELineRubV = false;
                            } else {
                                this.varCELine.screenLines.add((PacbaseSegment)CELineRub);
                            }
                            firstCELineRub = false;
                        } else {
                            this.varCELine.screenLines.add((PacbaseSegment)CELineRub);
                        }
                    }
                    boolean firstComplCElineActionCdeO = false;
                    boolean complCElineActionCdeO = false;
                    if (!firstComplCElineForWBH4 && pCELineComplement1.getActionCode().equals(PacScreenActionCodeValues._O_LITERAL)) {
                        firstComplCElineActionCdeO = true;
                    }
                    if (!firstComplCElineForWBH4 && !pCELineComplement1.getActionCode().equals(PacScreenActionCodeValues._O_LITERAL) && actionCde.equals(O_PRESENCECHECK)) {
                        complCElineActionCdeO = true;
                    }
                    if (updateOptionValue.equals(PacScreenUpdateOptionValues._G_LITERAL) && (!actionCde.equals(O_PRESENCECHECK) || firstComplCElineActionCdeO || complCElineActionCdeO)) {
                        PacScreen screenForDebranch;
                        if (!H4WBCEline1Write) {
                            cleEY1I.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GA_Value(" ");
                            cleEY1I.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GB_Value("   ");
                            String displaySegCod = pCELineComplement.getDisplaySegmentCode();
                            String delim = this.varCELine.delimGenerateBib;
                            if (!(this.varCELine.CELine.get_GRZSOURA_Groupe_Value().getCompleteContentForSegment().trim().equals("SPACE") || displaySegCod.startsWith(delim) || displaySegCod.endsWith(delim))) {
                                this.varCELine.CELine.get_GRZSOURA_Groupe_Value().set_CORUBA_Value("      ");
                            } else if (!this.varCELine.CELine.get_GRZSOURA_Groupe_Value().getCompleteContentForSegment().trim().equals("SPACE") && displaySegCod.trim().length() < 5) {
                                this.varCELine.CELine.get_GRZSOURA_Groupe_Value().set_CORUBA_Value("");
                            }
                            this.varCELine.CELine.set_OPMAJ_Value(this.getUpdateOption(String.valueOf(pCELineComplement.getUpdateOption())));
                            if (!String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") || String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") && !this.varCELine.H4WBForPFKEY) {
                                PacScreen screenForDebranch2;
                                if (pCELineComplement1.getScreen() != null && (screenForDebranch2 = pCELineComplement1.getScreen()).getName().length() > 4) {
                                    String extName = screenForDebranch2.getName();
                                    if (screenForDebranch2.getProgramExternalName() != null && screenForDebranch2.getProgramExternalName().trim().length() > 0) {
                                        extName = screenForDebranch2.getProgramExternalName();
                                    }
                                    this.varCELine.CELine.set_FIENR_Value(extName.substring(0, 4));
                                    this.varCELine.CELine.set_CORUM_Value(extName.substring(4));
                                }
                                int specifNuligForPFKEYWB_H4 = this.varCELine.currentNulig;
                                if (String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") && this.varCELine.currentCategory.equals("R")) {
                                    String strNulig = "000" + ++specifNuligForPFKEYWB_H4;
                                    String Nulig3 = strNulig.substring(strNulig.length() - 3);
                                    cleEY1I.get_GRG9AB_Groupe_Value().set_GRG9_Value(Nulig3);
                                }
                                this.varCELine.screenLines.add((PacbaseSegment)this.varCELine.CELine);
                                H4WBCEline1Write = true;
                                if (String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey")) {
                                    this.varCELine.H4WBForPFKEY = true;
                                    if (this.varCELine.isOptionSWAP) {
                                        EY1I CELinePF = new EY1I(this.varCELine.CELine.getCompleteContentForSegment());
                                        CELinePF.set_NIVST_Value("00");
                                        CELinePF.set_ATTRCL_Value(" ");
                                        CELinePF.set_ATTRCR_Value(" ");
                                        CELinePF.set_ATTRIL_Value(" ");
                                        CELinePF.set_ATTRIR_Value(" ");
                                        CELinePF.set_ATTRPL_Value(" ");
                                        CELinePF.set_ATTRPR_Value(" ");
                                        CELinePF.set_ATTRZR_Value(" ");
                                        CELinePF.set_GRFORMAT_Value("     ");
                                        CELinePF.set_LIRUE_Value("                                    ");
                                        CELinePF.set_REPET9_Value(" ");
                                        this.varCELine.screenLines.add(this.instantiateFirstWM_H4_ForDebranchScreen(CELinePF));
                                    }
                                }
                            }
                        }
                        this.varCELine.CELine = new EY1I(this.varCELine.CELine.getCompleteContentForSegment());
                        CELineG = new EY1I();
                        cleEY1I = this.varCELine.CELine.get_GRCLEEY_Groupe_Value();
                        cleEY1I.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GA_Value(INTERNAL_FORMAT);
                        strNumGB = String.valueOf(100 + ++numGB);
                        String NumGBS = strNumGB.substring(strNumGB.length() - 3);
                        cleEY1I.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GB_Value(NumGBS);
                        if (!this.currentScreen.getDialogType().equals(PacDialogTypeValues._NONE_LITERAL)) {
                            CELineG.set_NARUE_Value("V");
                        }
                        CELineG.set_GRCLEEY_Value(String.valueOf(cleEY1I));
                        CELineG = this.instantiateFirstWB_H4_ForDebranchScreen(aPacCElineField, CELineG, pCELineComplement, H4WBCEline1Write, firstComplCElineForWBH4);
                        if (pCELineComplement.getScreen() != null && (screenForDebranch = pCELineComplement.getScreen()).getTransactionCode() != null && screenForDebranch.getTransactionCode().trim().length() > 0) {
                            this.varCELine.CELine.set_FIENR_Value(screenForDebranch.getTransactionCode());
                        }
                        if (!H4WBCEline1Write) {
                            cleEY1I.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GA_Value(" ");
                            cleEY1I.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GB_Value("   ");
                            this.varCELine.CELine.get_GRZSOURA_Groupe_Value().set_CORUBA_Value("      ");
                            if (!String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") || String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") && !this.varCELine.H4WBForPFKEY) {
                                this.varCELine.screenLines.add((PacbaseSegment)this.varCELine.CELine);
                                H4WBCEline1Write = true;
                                if (String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey")) {
                                    this.varCELine.H4WBForPFKEY = true;
                                }
                            }
                        }
                    }
                    if (pCELineComplement.getUpdateOption().equals(PacScreenUpdateOptionValues._P_LITERAL)) {
                        this.varCELine.CELine = new EY1I(this.varCELine.CELine.getCompleteContentForSegment());
                        EY1I CELineG_P = new EY1I();
                        cleEY1I = this.varCELine.CELine.get_GRCLEEY_Groupe_Value();
                        cleEY1I.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GA_Value(INTERNAL_FORMAT);
                        strNumGB = String.valueOf(100 + ++numGB);
                        String NumGBS = strNumGB.substring(strNumGB.length() - 3);
                        cleEY1I.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GB_Value(NumGBS);
                        CELineG_P.set_GRCLEEY_Value(String.valueOf(cleEY1I));
                        CELineG_P.set_NARUE_Value(aPacCElineField.getFieldNature().getLiteral().substring(1));
                        CELineG_P.set_LOLIB_Value("000");
                        if (aPacCElineField.getDataElement() != null) {
                            CELineG_P.set_CORUB_Value(aPacCElineField.getDataElement().getName());
                        } else if (String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") && aPacCElineField.getDataElement() == null) {
                            CELineG_P.set_CORUB_Value("PFKEY");
                        }
                        CELineG_P.set_REPETH_Value("01");
                        CELineG_P.set_REPETV_Value("01");
                        CELineG_P.set_FIENR_Value(pCELineComplement.getUpdateSegmentCode());
                        CELineG_P.set_GRZSOURA_Value(pCELineComplement.getDisplaySegmentCode());
                        CELineG_P.set_OPMAJ_Value(this.getUpdateOption(pCELineComplement.getUpdateOption().getLiteral()));
                        if (!pCELineComplement.getSourceType().equals(PacScreenSourceTypeValues._NONE_LITERAL)) {
                            if (pCELineComplement.getSourceType().equals(PacScreenSourceTypeValues._STAR_LITERAL)) {
                                CELineG_P.set_TYSOUR_Value("*");
                            } else {
                                CELineG_P.set_TYSOUR_Value(pCELineComplement.getSourceType().getLiteral().substring(1));
                            }
                        }
                        if (!firstComplementLine) {
                            this.varCELine.screenLines.add((PacbaseSegment)CELineG_P);
                        }
                    }
                    firstComplementLine = false;
                    updateOptionValuePrior = updateOptionValue;
                    firstComplCElineForWBH4 = false;
                }
                int numGBV = 0;
                if (!firstCELineRub) {
                    int numGB1 = Integer.parseInt(CELineRub.get_GRCLEEY_Groupe_Value().get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().get_GB_Value());
                    String strNumGB1 = "000" + ++numGB1;
                    String NumGBS1 = strNumGB1.substring(strNumGB1.length() - 3);
                    firstCELineRub = true;
                    numGBV = numGB1;
                    if (!firstCELineRubI) {
                        CELineRub1I.get_GRCLEEY_Groupe_Value().get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GB_Value(NumGBS1);
                        CELineRub1I.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRI22_Groupe_Value().set_NULIG_Value(NumGBS1);
                        this.varCELine.screenLines.add((PacbaseSegment)CELineRub1I);
                        firstCELineRubI = true;
                    }
                    if (!firstCELineRubO) {
                        int numGBO = Integer.parseInt(NumGBS1);
                        if (CELineG != null && (numGBO = Integer.parseInt(CELineG.get_GRCLEEY_Groupe_Value().get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().get_GB_Value())) <= numGB1) {
                            numGBO = ++numGB1;
                        }
                        String strNumGBO = "000" + ++numGBO;
                        String NumGBSO = strNumGBO.substring(strNumGBO.length() - 3);
                        numGBV = numGBO;
                        CELineRub1O.get_GRCLEEY_Groupe_Value().get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GB_Value(NumGBSO);
                        CELineRub1O.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRI22_Groupe_Value().set_NULIG_Value(NumGBSO);
                        this.varCELine.screenLines.add((PacbaseSegment)CELineRub1O);
                        firstCELineRubO = true;
                    }
                }
                if (!firstComplCElineForWBH4 && !firstCELineRubV && CELineRub1V != null) {
                    if (CELineRub1I != null && CELineRub1O != null || CELineG != null) {
                        String strNumGBV = "000" + ++numGBV;
                        String NumGBSV = strNumGBV.substring(strNumGBV.length() - 3);
                        CELineRub1V.get_GRCLEEY_Groupe_Value().get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GB_Value(NumGBSV);
                        CELineRub1V.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRI22_Groupe_Value().set_NULIG_Value(NumGBSV);
                    }
                    this.varCELine.screenLines.add((PacbaseSegment)CELineRub1V);
                    firstCELineRubV = true;
                }
            }
            if (!H4WBCEline1Write && (!String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") || String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") && !this.varCELine.H4WBForPFKEY)) {
                int specifNuligForPFKEYWB_H4 = this.varCELine.currentNulig;
                if (String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") && this.varCELine.currentCategory.equals("R")) {
                    String strNulig = "000" + ++specifNuligForPFKEYWB_H4;
                    String Nulig3 = strNulig.substring(strNulig.length() - 3);
                    cleEY1I.get_GRG9AB_Groupe_Value().set_GRG9_Value(Nulig3);
                }
                this.varCELine.screenLines.add((PacbaseSegment)this.varCELine.CELine);
                H4WBCEline1Write = true;
                if (String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey")) {
                    this.varCELine.H4WBForPFKEY = true;
                }
            }
            if (this.varCELine.useDDataEltForControl && aPacCElineField.getDataElement() != null) {
                PacDataElement pdelt = null;
                PacDataElementDescription pacded = null;
                DataElement DataElementForCELine = aPacCElineField.getDataElement();
                if (DataElementForCELine instanceof DataElement) {
                    for (Object extEltNext : DataElementForCELine.getExtensions()) {
                        if (!(extEltNext instanceof PacDataElement)) continue;
                        pdelt = (PacDataElement)extEltNext;
                    }
                    Iterator DLines = pdelt.getDLines().iterator();
                    pacded = null;
                    for (Object extNext : DataElementForCELine.getDataDescription().getExtensions()) {
                        if (!(extNext instanceof PacDataElementDescription)) continue;
                        pacded = (PacDataElementDescription)extNext;
                    }
                    if (pacded.getParent() != null) {
                        DataElement parentDataElement = pacded.getParent();
                        PacDataElement PParentDataElement = null;
                        if (parentDataElement instanceof DataElement) {
                            Iterator DLinesParent;
                            for (Object extEltPNext : parentDataElement.getExtensions()) {
                                if (!(extEltPNext instanceof PacDataElement)) continue;
                                PParentDataElement = (PacDataElement)extEltPNext;
                            }
                            if (PParentDataElement != null && !(DLinesParent = PParentDataElement.getDLines().iterator()).equals(null)) {
                                while (DLinesParent.hasNext()) {
                                    PacDLine pPacDLine = (PacDLine)DLinesParent.next();
                                    if (pPacDLine.getLineType().trim().length() >= 1 && !pPacDLine.getLineType().trim().equals(INTERNAL_FORMAT) && !pPacDLine.getLineType().trim().equals(O_PRESENCECHECK)) continue;
                                    EY22 CELineDRub = new EY22();
                                    CELineDRub.set_GRCLEEY_Value(String.valueOf(this.varCELine.CELine.get_GRCLEEY_Groupe_Value()));
                                    PacbaseSegment.GRCLEEY cleEY22 = CELineDRub.get_GRCLEEY_Groupe_Value();
                                    cleEY22.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GA_Value(INPUT_FORMAT);
                                    String strNumGB = "000" + ++numGB;
                                    String NumGBS = strNumGB.substring(strNumGB.length() - 3);
                                    cleEY22.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GB_Value(NumGBS);
                                    EY22.GRPR22.GRENREG ky22enreg = CELineDRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value();
                                    ky22enreg.get_GRI22_Groupe_Value().set_CORUB_Value(parentDataElement.getName());
                                    ky22enreg.get_GRI22_Groupe_Value().set_NULIG_Value(NumGBS);
                                    if (pPacDLine.getAllowedValues().trim().length() <= 0) continue;
                                    this.formatKY22(pPacDLine, ky22enreg);
                                    Iterator extensionsDE = aPacCElineField.getDataElement().getExtensions().iterator();
                                    PacDataElement pacdelt = null;
                                    while (extensionsDE.hasNext()) {
                                        try {
                                            pacdelt = (PacDataElement)extensionsDE.next();
                                        }
                                        catch (Exception exception) {}
                                    }
                                    String valru = CELineDRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRCARTE6_Groupe_Value().get_VALRU_Value();
                                    String bornei = CELineDRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRCARTE6_Groupe_Value().get_GRXDECOD_Groupe_Value().get_BORNEI_Value();
                                    String bornes = CELineDRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRCARTE6_Groupe_Value().get_GRXDECOD_Groupe_Value().get_BORNES_Value();
                                    if (pacdelt != null && (valru.trim().length() > 0 || bornei.trim().length() > 0 || bornes.trim().length() > 0)) {
                                        String delimForEntityPdelt = pacdelt.getGenerationParameter().getAlphanumericDelimiter();
                                        String variantForEntityPdelt = pacdelt.getGenerationParameter().getCobolType().getLiteral().substring(1);
                                        if (valru.trim().length() > 0) {
                                            String valru1 = this.convertDelimiter(delimForEntityPdelt, variantForEntityPdelt, valru);
                                            CELineDRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRCARTE6_Groupe_Value().set_VALRU_Value(valru1);
                                        }
                                        if (bornei.trim().length() > 0) {
                                            String bornei1 = this.convertDelimiter(delimForEntityPdelt, variantForEntityPdelt, bornei);
                                            CELineDRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRCARTE6_Groupe_Value().get_GRXDECOD_Groupe_Value().set_BORNEI_Value(bornei1);
                                        }
                                        if (bornes.trim().length() > 0) {
                                            String bornes1 = this.convertDelimiter(delimForEntityPdelt, variantForEntityPdelt, bornes);
                                            CELineDRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRCARTE6_Groupe_Value().get_GRXDECOD_Groupe_Value().set_BORNES_Value(bornes1);
                                        }
                                    }
                                    this.varCELine.screenLines.add((PacbaseSegment)CELineDRub);
                                }
                            }
                        }
                    }
                    if (!DLines.equals(null)) {
                        while (DLines.hasNext()) {
                            PacDLine pPacDLine = (PacDLine)DLines.next();
                            if (pPacDLine.getLineType().trim().length() >= 1 && !pPacDLine.getLineType().trim().equals(INTERNAL_FORMAT) && !pPacDLine.getLineType().trim().equals(O_PRESENCECHECK)) continue;
                            EY22 CELineDRub = new EY22();
                            CELineDRub.set_GRCLEEY_Value(String.valueOf(this.varCELine.CELine.get_GRCLEEY_Groupe_Value()));
                            PacbaseSegment.GRCLEEY cleEY22 = CELineDRub.get_GRCLEEY_Groupe_Value();
                            cleEY22.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GA_Value(INPUT_FORMAT);
                            String strNumGB = "000" + ++numGB;
                            String NumGBS = strNumGB.substring(strNumGB.length() - 3);
                            cleEY22.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GB_Value(NumGBS);
                            EY22.GRPR22.GRENREG ky22enreg = CELineDRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value();
                            ky22enreg.get_GRI22_Groupe_Value().set_CORUB_Value(aPacCElineField.getDataElement().getName());
                            ky22enreg.get_GRI22_Groupe_Value().set_NULIG_Value(NumGBS);
                            ky22enreg.get_GRCARTE6_Groupe_Value().set_TYCOD_Value(pPacDLine.getLineType());
                            ky22enreg.get_GRCARTE6_Groupe_Value().set_SAVED_Value(pPacDLine.getMore());
                            if (pPacDLine.getAllowedValues().trim().length() <= 0) continue;
                            this.formatKY22(pPacDLine, ky22enreg);
                            Iterator extensionsDE = aPacCElineField.getDataElement().getExtensions().iterator();
                            PacDataElement pacdelt = null;
                            while (extensionsDE.hasNext()) {
                                try {
                                    pacdelt = (PacDataElement)extensionsDE.next();
                                }
                                catch (Exception exception) {}
                            }
                            String valru = CELineDRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRCARTE6_Groupe_Value().get_VALRU_Value();
                            String bornei = CELineDRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRCARTE6_Groupe_Value().get_GRXDECOD_Groupe_Value().get_BORNEI_Value();
                            String bornes = CELineDRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRCARTE6_Groupe_Value().get_GRXDECOD_Groupe_Value().get_BORNES_Value();
                            if (pacdelt != null && (valru.trim().length() > 0 || bornei.trim().length() > 0 || bornes.trim().length() > 0)) {
                                String delimForEntityPdelt = pacdelt.getGenerationParameter().getAlphanumericDelimiter();
                                String variantForEntityPdelt = pacdelt.getGenerationParameter().getCobolType().getLiteral().substring(1);
                                if (valru.trim().length() > 0) {
                                    String valru1 = this.convertDelimiter(delimForEntityPdelt, variantForEntityPdelt, valru);
                                    CELineDRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRCARTE6_Groupe_Value().set_VALRU_Value(valru1);
                                }
                                if (bornei.trim().length() > 0) {
                                    String bornei1 = this.convertDelimiter(delimForEntityPdelt, variantForEntityPdelt, bornei);
                                    CELineDRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRCARTE6_Groupe_Value().get_GRXDECOD_Groupe_Value().set_BORNEI_Value(bornei1);
                                }
                                if (bornes.trim().length() > 0) {
                                    String bornes1 = this.convertDelimiter(delimForEntityPdelt, variantForEntityPdelt, bornes);
                                    CELineDRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRCARTE6_Groupe_Value().get_GRXDECOD_Groupe_Value().set_BORNES_Value(bornes1);
                                }
                            }
                            this.varCELine.screenLines.add((PacbaseSegment)CELineDRub);
                        }
                    }
                }
            }
        }
        if ((complementCELines = aPacCElineField.getComplements().iterator()) != null) {
            boolean firstComplCELine = true;
            int numGB = 0;
            int valueCent = 100;
            String currentActionCode = "";
            while (complementCELines.hasNext()) {
                PacCELineFieldComplement pCELineComplement = (PacCELineFieldComplement)complementCELines.next();
                if ((aPacCElineField.getFieldNature().equals(PacScreenFieldNatureValues._P_LITERAL) || aPacCElineField.getFieldNature().equals(PacScreenFieldNatureValues._V_LITERAL)) && currentOrganisation.equals("H") && (pCELineComplement.getUpdateSegmentCode().trim().length() >= 4 || pCELineComplement.getDisplaySegmentCode().trim().length() >= 4)) {
                    String segmentCode = "";
                    String rubCode = "";
                    if (pCELineComplement.getUpdateSegmentCode().trim().length() >= 4) {
                        segmentCode = pCELineComplement.getUpdateSegmentCode().trim().substring(0, 4);
                        rubCode = pCELineComplement.getUpdateSegmentCode().trim().substring(4);
                    } else if (pCELineComplement.getDisplaySegmentCode().trim().length() >= 4) {
                        segmentCode = pCELineComplement.getDisplaySegmentCode().trim().substring(0, 4);
                        rubCode = pCELineComplement.getDisplaySegmentCode().trim().substring(4);
                    }
                    RadicalEntity objbl = PacbaseModelService.SearchRadicalEntityDuringGeneration((RadicalEntity)this.varCELine.getGenerationEntryPoint(), (String)segmentCode, (String)"dataaggregate", (PacbaseLinksEntitiesService)this.ples);
                    if (objbl instanceof DataAggregate) {
                        DataAggregate dag = (DataAggregate)objbl;
                        this.getPacLinksEntitiesService().registerReference((RadicalEntity)dag);
                        SegmentCompositionPacbaseAndKernelVisitor v = new SegmentCompositionPacbaseAndKernelVisitor(this.getPacLinksEntitiesService(), this.varCELine.getGenerationEntryPoint());
                        v.setScreenCodeToGenerate(this.currentScreen.getName());
                        v.setIsServer(false);
                        if (this.currentScreen != null) {
                            v.setVariantGenerateBibForScreen(this.currentScreen.getGenerationParameter().getCobolType().getLiteral().substring(1));
                            v.setDelimGenerateBibForScreen(this.currentScreen.getGenerationParameter().getAlphanumericDelimiter());
                        }
                        v.setCurrentScreen(this.currentScreen);
                        v.setCurrentda(dag);
                        v.setSegmentCode(segmentCode);
                        if (dag != null) {
                            Iterator extensionsDA = dag.getExtensions().iterator();
                            while (extensionsDA.hasNext()) {
                                try {
                                    PacDataAggregate cfr_ignored_0 = (PacDataAggregate)extensionsDA.next();
                                }
                                catch (Exception exception) {}
                            }
                        }
                        String nameOfDataUnit = dag.getName().substring(0, 2);
                        RadicalEntity objRA = PacbaseModelService.SearchRadicalEntityDuringGeneration((RadicalEntity)this.varCELine.getGenerationEntryPoint(), (String)nameOfDataUnit, (String)"dataunit", (PacbaseLinksEntitiesService)this.ples);
                        DataUnit du = null;
                        PacLibrary lib = null;
                        PacDataUnit pdu2 = null;
                        if (objRA instanceof DataUnit) {
                            du = (DataUnit)objRA;
                        }
                        for (PacDataUnit pdu2 : du.getExtensions()) {
                            lib = pdu2.getGenerationParameter();
                        }
                        String delimForEntityPda = lib.getAlphanumericDelimiter();
                        String variantForEntityPda = lib.getCobolType().getLiteral().substring(1);
                        v.setDelimForEntity(delimForEntityPda);
                        v.setVariantForEntity(variantForEntityPda);
                        v.setVariant(variantForEntityPda.charAt(0));
                        v.doSwitch((EObject)dag);
                        for (PacbaseSegment ps : v.getSegmentCompositionLines()) {
                            if (!(ps instanceof EY13)) continue;
                            EY13 psH5WB = (EY13)ps;
                            String corubToTest = "";
                            corubToTest = rubCode.length() > 0 ? rubCode : aPacCElineField.getDataElement().getName();
                            if (!psH5WB.get_CORUB_Value().equals(corubToTest)) continue;
                            if (psH5WB.get_GRCOFIM3_Groupe_Value().getCompleteContentForSegment().length() > 0) {
                                String cosegt = psH5WB.get_GRCOFIM3_Groupe_Value().get_COFIM_Value() + psH5WB.get_GRCOFIM3_Groupe_Value().get_GRCOLRUB_Groupe_Value().get_NUENM_Value();
                                String corubt = psH5WB.get_GRCOFIM3_Groupe_Value().get_GRCOLRUB_Groupe_Value().get_CORUM_Value();
                                RadicalEntity objblt = PacbaseModelService.SearchRadicalEntityDuringGeneration((RadicalEntity)this.varCELine.getGenerationEntryPoint(), (String)cosegt, (String)"dataaggregate", (PacbaseLinksEntitiesService)this.ples);
                                if (objblt instanceof DataAggregate) {
                                    DataAggregate dagt = (DataAggregate)objblt;
                                    this.getPacLinksEntitiesService().registerReference((RadicalEntity)dagt);
                                    SegmentCompositionPacbaseAndKernelVisitor vt = new SegmentCompositionPacbaseAndKernelVisitor(this.getPacLinksEntitiesService(), this.varCELine.getGenerationEntryPoint());
                                    vt.setScreenCodeToGenerate(this.currentScreen.getName());
                                    if (this.currentScreen != null) {
                                        vt.setVariantGenerateBibForScreen(this.currentScreen.getGenerationParameter().getCobolType().getLiteral().substring(1));
                                        vt.setDelimGenerateBibForScreen(this.currentScreen.getGenerationParameter().getAlphanumericDelimiter());
                                    }
                                    vt.setCurrentScreen(this.currentScreen);
                                    vt.setCurrentda(dagt);
                                    vt.setSegmentCode(cosegt);
                                    vt.setIsServer(false);
                                    if (dagt != null) {
                                        Iterator extensionsDA = dagt.getExtensions().iterator();
                                        while (extensionsDA.hasNext()) {
                                            try {
                                                PacDataAggregate cfr_ignored_1 = (PacDataAggregate)extensionsDA.next();
                                            }
                                            catch (Exception exception) {}
                                        }
                                    }
                                    String nameOfDataUnit1 = dagt.getName().substring(0, 2);
                                    RadicalEntity objRA1 = PacbaseModelService.SearchRadicalEntityDuringGeneration((RadicalEntity)this.varCELine.getGenerationEntryPoint(), (String)nameOfDataUnit1, (String)"dataunit", (PacbaseLinksEntitiesService)this.ples);
                                    DataUnit du1 = null;
                                    PacDataUnit pdu12 = null;
                                    if (objRA1 instanceof DataUnit) {
                                        du1 = (DataUnit)objRA1;
                                    }
                                    for (PacDataUnit pdu12 : du1.getExtensions()) {
                                        pdu12.getGenerationParameter();
                                    }
                                    String delimForEntityPda1 = lib.getAlphanumericDelimiter();
                                    String variantForEntityPda1 = lib.getCobolType().getLiteral().substring(1);
                                    vt.setDelimForEntity(delimForEntityPda1);
                                    vt.setVariantForEntity(variantForEntityPda1);
                                    vt.setVariant(variantForEntityPda1.charAt(0));
                                    vt.doSwitch((EObject)dagt);
                                    for (PacbaseSegment pst : vt.getSegmentCompositionLines()) {
                                        if (!(pst instanceof EY13)) continue;
                                        EY13 psH5WBt = (EY13)pst;
                                        String corubToTestt = "";
                                        corubToTestt = corubt.length() > 0 ? corubt : aPacCElineField.getDataElement().getName();
                                        if (!psH5WBt.get_CORUB_Value().equals(corubToTestt) || !psH5WBt.get_STRCO1_Value().equals(O_PRESENCECHECK) && !psH5WBt.get_STRCO1_Value().equals(P_PRESENCECHECK)) continue;
                                        this.writeH5WB(this.varCELine.CELine.get_GRCLEEY_Groupe_Value().getCompleteContentForSegment(), segmentCode, corubToTestt);
                                    }
                                }
                            }
                            if (!psH5WB.get_STRCO1_Value().equals(O_PRESENCECHECK) && !psH5WB.get_STRCO1_Value().equals(P_PRESENCECHECK)) continue;
                            this.writeH5WB(this.varCELine.CELine.get_GRCLEEY_Groupe_Value().getCompleteContentForSegment(), segmentCode, corubToTest);
                        }
                    }
                }
                if (!pCELineComplement.getActionCode().equals(PacScreenActionCodeValues._NONE_LITERAL)) {
                    currentActionCode = pCELineComplement.getActionCode().getLiteral().substring(1);
                }
                if (!(pCELineComplement.getDisplaySegmentCode().trim().length() <= 0 || pCELineComplement.getUpdateOption().equals(PacScreenUpdateOptionValues._V_LITERAL) || pCELineComplement.getUpdateOption().equals(PacScreenUpdateOptionValues._P_LITERAL) || pCELineComplement.getUpdateOption().equals(PacScreenUpdateOptionValues._G_LITERAL) || pCELineComplement.getUpdateOption().equals(PacScreenUpdateOptionValues._S_LITERAL))) {
                    this.varCELine.CELine = new EY1I(this.varCELine.CELine.getCompleteContentForSegment());
                    PacbaseSegment.GRCLEEY cleEY1I = this.varCELine.CELine.get_GRCLEEY_Groupe_Value();
                    cleEY1I.get_GRG3BIS_Groupe_Value().set_G3_Value(INPUT_FORMAT);
                    cleEY1I.set_COCA_Value("H4");
                    cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_G4_Value(this.varCELine.currentCategory);
                    cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_GRG5A6_Value("      ");
                    if (!pCELineComplement.getSourceType().equals(PacScreenSourceTypeValues._S_LITERAL) && !pCELineComplement.getSourceType().equals(PacScreenSourceTypeValues._STAR_LITERAL)) {
                        String dispSegCode = "";
                        dispSegCode = pCELineComplement.getDisplaySegmentCode().trim().length() < 5 ? pCELineComplement.getDisplaySegmentCode().substring(0, pCELineComplement.getDisplaySegmentCode().trim().length()) : pCELineComplement.getDisplaySegmentCode().substring(0, 4);
                        cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_GRG5A6_Value(dispSegCode);
                    }
                    cleEY1I.get_GRG9AB_Groupe_Value().set_GRGAAB_Value("    ");
                    this.varCELine.screenLines.add((PacbaseSegment)this.varCELine.CELine);
                }
                if (!(pCELineComplement.getUpdateSegmentCode().trim().length() <= 0 || pCELineComplement.getUpdateOption().equals(PacScreenUpdateOptionValues._V_LITERAL) || pCELineComplement.getUpdateOption().equals(PacScreenUpdateOptionValues._P_LITERAL) || pCELineComplement.getUpdateOption().equals(PacScreenUpdateOptionValues._G_LITERAL) || pCELineComplement.getUpdateOption().equals(PacScreenUpdateOptionValues._S_LITERAL))) {
                    this.varCELine.CELine = new EY1I(this.varCELine.CELine.getCompleteContentForSegment());
                    PacbaseSegment.GRCLEEY cleEY1I = this.varCELine.CELine.get_GRCLEEY_Groupe_Value();
                    cleEY1I.get_GRG3BIS_Groupe_Value().set_G3_Value("D");
                    cleEY1I.set_COCA_Value("H6");
                    cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_G4_Value(this.varCELine.currentCategory);
                    if (!pCELineComplement.getSourceType().equals(PacScreenSourceTypeValues._S_LITERAL) && !pCELineComplement.getSourceType().equals(PacScreenSourceTypeValues._STAR_LITERAL)) {
                        cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_GRG5A6_Value("      ");
                    }
                    if (!pCELineComplement.getActionCode().equals(PacScreenActionCodeValues._NONE_LITERAL)) {
                        cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_GRG5A6_Groupe_Value().set_G5_Value(String.valueOf(pCELineComplement.getActionCode()).substring(1));
                    }
                    if (pCELineComplement.getPresenceCheck().equals(PacScreenPresenceCheckValues._P_LITERAL) || pCELineComplement.getPresenceCheck().equals(PacScreenPresenceCheckValues._F_LITERAL)) {
                        cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_GRG5A6_Groupe_Value().set_G5_Value("P  ");
                    }
                    cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_GRG5A6_Groupe_Value().set_G6BIS_Value("   ");
                    if (this.varCELine.CELine.get_OPMAJ_Value().trim().length() == 0) {
                        this.varCELine.CELine.set_OPMAJ_Value("M");
                    }
                    cleEY1I.get_GRG9AB_Groupe_Value().set_GRGAAB_Value("    ");
                    if (firstComplCELine) {
                        this.varCELine.screenLines.add((PacbaseSegment)this.varCELine.CELine);
                    }
                }
                if (!firstComplCELine && pCELineComplement.getUpdateSegmentCode().trim().length() > 0 && (aPacCElineField.getFieldNature().equals(PacScreenFieldNatureValues._V_LITERAL) || aPacCElineField.getFieldNature().equals(PacScreenFieldNatureValues._F_LITERAL)) && !currentActionCode.equals(INTERNAL_FORMAT) && (pCELineComplement.getUpdateOption().equals(PacScreenUpdateOptionValues._M_LITERAL) || pCELineComplement.getUpdateOption().equals(PacScreenUpdateOptionValues._PLUS_LITERAL) || pCELineComplement.getUpdateOption().equals(PacScreenUpdateOptionValues._MINUS_LITERAL) || pCELineComplement.getUpdateOption().equals(PacScreenUpdateOptionValues._NONE_LITERAL))) {
                    EY1I CELineH6Sup = new EY1I();
                    PacbaseSegment.GRCLEEY cleEY1IH6Sup = this.varCELine.CELine.get_GRCLEEY_Groupe_Value();
                    cleEY1IH6Sup.get_GRG3BIS_Groupe_Value().set_G3_Value("D");
                    cleEY1IH6Sup.set_COCA_Value("H6");
                    cleEY1IH6Sup.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_G4_Value(this.varCELine.currentCategory);
                    if (!pCELineComplement.getActionCode().equals(PacScreenActionCodeValues._NONE_LITERAL)) {
                        cleEY1IH6Sup.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_GRG5A6_Groupe_Value().set_G5_Value(String.valueOf(pCELineComplement.getActionCode()).substring(1));
                    } else {
                        cleEY1IH6Sup.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_GRG5A6_Groupe_Value().set_G5_Value(currentActionCode);
                    }
                    if (pCELineComplement.getPresenceCheck().equals(PacScreenPresenceCheckValues._P_LITERAL) || pCELineComplement.getPresenceCheck().equals(PacScreenPresenceCheckValues._F_LITERAL)) {
                        cleEY1IH6Sup.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_GRG5A6_Groupe_Value().set_G5_Value("P  ");
                    }
                    cleEY1IH6Sup.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_GRG5A6_Groupe_Value().set_G6BIS_Value("   ");
                    cleEY1IH6Sup.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GA_Value(INTERNAL_FORMAT);
                    String strNumGB = String.valueOf(valueCent + ++numGB);
                    String NumGBS = strNumGB.substring(strNumGB.length() - 3);
                    cleEY1IH6Sup.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GB_Value(NumGBS);
                    CELineH6Sup.set_GRCLEEY_Value(cleEY1IH6Sup.getCompleteContentForSegment());
                    CELineH6Sup.set_NARUE_Value(aPacCElineField.getFieldNature().getLiteral().substring(1));
                    CELineH6Sup.set_LOLIB_Value("000");
                    CELineH6Sup.set_CORUB_Value(aPacCElineField.getDataElement().getName());
                    CELineH6Sup.set_REPETH_Value("00");
                    CELineH6Sup.set_REPETV_Value("00");
                    if (pCELineComplement.getUpdateSegmentCode().trim().length() > 3) {
                        CELineH6Sup.set_FIENR_Value(pCELineComplement.getUpdateSegmentCode().substring(0, 4));
                        CELineH6Sup.set_CORUM_Value(pCELineComplement.getUpdateSegmentCode().substring(4));
                    }
                    CELineH6Sup.set_OPEP_Value(this.varCELine.CELine.get_OPEP_Value());
                    if (!pCELineComplement.getUpdateOption().equals(PacScreenUpdateOptionValues._NONE_LITERAL)) {
                        CELineH6Sup.set_OPMAJ_Value(this.getUpdateOption(pCELineComplement.getUpdateOption().getLiteral()));
                    } else {
                        CELineH6Sup.set_OPMAJ_Value(this.varCELine.CELine.get_OPMAJ_Value());
                    }
                    if (!pCELineComplement.getSourceType().equals(PacScreenSourceTypeValues._NONE_LITERAL)) {
                        if (pCELineComplement.getSourceType().equals(PacScreenSourceTypeValues._STAR_LITERAL)) {
                            CELineH6Sup.set_TYSOUR_Value("*");
                        } else {
                            CELineH6Sup.set_TYSOUR_Value(pCELineComplement.getSourceType().getLiteral().substring(1));
                        }
                    }
                    this.varCELine.screenLines.add((PacbaseSegment)CELineH6Sup);
                }
                firstComplCELine = false;
            }
        }
        if (aPacCElineField.getFieldNature().equals(PacScreenFieldNatureValues._P_LITERAL) || aPacCElineField.getFieldNature().equals(PacScreenFieldNatureValues._V_LITERAL) || aPacCElineField.getFieldNature().equals(PacScreenFieldNatureValues._F_LITERAL)) {
            this.initializeListForWBH5LineForClientScreen(this.varCELine.CELine);
        }
        if (this.varCELine.modifyValue) {
            this.varCELine.modifyValue = false;
            this.varCELine.endRepeatCateg = this.varCELine.endRepeatCategS;
            this.varCELine.maxNumberOfVerticalLineForRepetCateg = this.varCELine.maxNumberOfVerticalLineForRepetCategS;
            this.varCELine.maxNumberOfVerticalLine = this.varCELine.maxNumberOfVerticalLineS;
            this.varCELine.repetHorizontalCateg = this.varCELine.repetHorizontalCategS;
            this.varCELine.currentCategory = this.varCELine.currentCategoryS;
            this.varCELine.numLabel = this.varCELine.numLabelS;
            this.varCELine.currentLabelPresentationField = this.varCELine.currentLabelPresentationFieldS;
        }
        if (String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") && Integer.parseInt(this.varCELine.linePositionASave) <= 1) {
            this.varCELine.linePositionASave = "000";
            this.varCELine.columnPositionASave = "00";
        }
        if (aPacCElineField.getFieldType().equals(PacScreenFieldTypeValues._ERR_MSG_LITERAL) || aPacCElineField.getFieldType().equals(PacScreenFieldTypeValues._LI_ERR_LITERAL)) {
            if (aPacCElineField.getDataElement() != null) {
                this.varCELine.dialogComplement.set_CORUB_Value(aPacCElineField.getDataElement().getName());
            } else {
                if (aPacCElineField.getFieldType().equals(PacScreenFieldTypeValues._ERR_MSG_LITERAL)) {
                    this.varCELine.dialogComplement.set_CORUB_Value("ERMSG");
                }
                if (aPacCElineField.getFieldType().equals(PacScreenFieldTypeValues._LI_ERR_LITERAL)) {
                    this.varCELine.dialogComplement.set_CORUB_Value("LIERR");
                }
            }
        }
        if (this.varCELine.changeValueColumn) {
            aPacCElineField.setColumnPosition(this.varCELine.valueColumn);
        }
        this.varCELine.firstCELineFieldOrLabelForCategZ = 2;
        this.varCELine.firstCElineForScreen = false;
    }

    private PacLabelPresentationValues determineLabelPresentation(PacLabelPresentationValues labelPresentation, PacScreen screen) {
        if (!labelPresentation.equals(PacLabelPresentationValues._NONE_LITERAL)) {
            return labelPresentation;
        }
        if (!screen.getLabelPresentation().equals(PacLabelPresentationValues._NONE_LITERAL)) {
            return screen.getLabelPresentation();
        }
        if (!screen.getDialog().getLabelPresentation().equals(PacLabelPresentationValues._NONE_LITERAL)) {
            return screen.getDialog().getLabelPresentation();
        }
        return labelPresentation;
    }

    private void initializeListForWBH5LineForStandartScreen(EY1I CELine) {
        String keyWBH5 = null;
        if (CELine.get_GRCLEEY_Groupe_Value().get_COCA_Value().equals("H6")) {
            keyWBH5 = CELine.get_FIENR_Value().concat(CELine.get_CORUM_Value());
        }
        if (CELine.get_GRCLEEY_Groupe_Value().get_COCA_Value().equals("H4")) {
            String cosega = String.valueOf(CELine.get_GRZSOURA_Groupe_Value().get_GRCOSEGA_Groupe_Value());
            String coruba = String.valueOf(CELine.get_GRZSOURA_Groupe_Value().get_CORUBA_Value());
            keyWBH5 = cosega.concat(coruba);
        }
        if (keyWBH5 != null) {
            EY1I CELineWBH5 = new EY1I();
            PacbaseSegment.GRCLEEY cleEY1IForWBH5 = CELineWBH5.get_GRCLEEY_Groupe_Value();
            cleEY1IForWBH5.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_G4_Value(CELine.get_GRCLEEY_Groupe_Value().get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_G4_Value());
            cleEY1IForWBH5.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_GRG5A6_Value(CELine.get_GRCLEEY_Groupe_Value().get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_GRG5A6_Groupe_Value().toString().substring(0, 1));
            cleEY1IForWBH5.get_GRG9AB_Groupe_Value().set_GRG9_Value(CELine.get_GRCLEEY_Groupe_Value().get_GRG9AB_Groupe_Value().get_GRG9_Groupe_Value().toString());
            cleEY1IForWBH5.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GB_Value(CELine.get_GRCLEEY_Groupe_Value().get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().get_GB_Value().toString());
            this.varCELine.listCorubForWBH5.put(keyWBH5, CELineWBH5);
        }
    }

    private void initializeListForWBH5LineForClientScreen(EY1I CELine) {
        PacbaseSegment.GRCLEEY cleEY1IForWBH5;
        EY1I CELineWBH5;
        String target = CELine.get_FIENR_Value().concat(CELine.get_CORUM_Value());
        String source = CELine.get_GRZSOURA_Groupe_Value().getCompleteContentForSegment();
        if (target.length() > 0) {
            CELineWBH5 = new EY1I();
            cleEY1IForWBH5 = CELineWBH5.get_GRCLEEY_Groupe_Value();
            cleEY1IForWBH5.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_G4_Value(CELine.get_GRCLEEY_Groupe_Value().get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_G4_Value());
            cleEY1IForWBH5.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_GRG5A6_Value(CELine.get_GRCLEEY_Groupe_Value().get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_GRG5A6_Groupe_Value().toString().substring(0, 1));
            cleEY1IForWBH5.get_GRG9AB_Groupe_Value().set_GRG9_Value(CELine.get_GRCLEEY_Groupe_Value().get_GRG9AB_Groupe_Value().get_GRG9_Groupe_Value().toString());
            cleEY1IForWBH5.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GB_Value(CELine.get_GRCLEEY_Groupe_Value().get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().get_GB_Value().toString());
            this.varCELine.listCorubForWBH5.put(target, CELineWBH5);
        }
        if (source.length() > 0) {
            CELineWBH5 = new EY1I();
            cleEY1IForWBH5 = CELineWBH5.get_GRCLEEY_Groupe_Value();
            cleEY1IForWBH5.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_G4_Value(CELine.get_GRCLEEY_Groupe_Value().get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_G4_Value());
            cleEY1IForWBH5.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_GRG5A6_Value(CELine.get_GRCLEEY_Groupe_Value().get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_GRG5A6_Groupe_Value().toString().substring(0, 1));
            cleEY1IForWBH5.get_GRG9AB_Groupe_Value().set_GRG9_Value(CELine.get_GRCLEEY_Groupe_Value().get_GRG9AB_Groupe_Value().get_GRG9_Groupe_Value().toString());
            cleEY1IForWBH5.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GB_Value(CELine.get_GRCLEEY_Groupe_Value().get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().get_GB_Value().toString());
            this.varCELine.listCorubForWBH5.put(source, CELineWBH5);
        }
    }

    private PacbaseSegment instantiateFirstWM_H4_ForDebranchScreen(EY1I cELineG) {
        EY1I CELineWMH4 = new EY1I(cELineG.getCompleteContentForSegment());
        CELineWMH4.get_GRCLEEY_Groupe_Value().set_G1_Value("M");
        CELineWMH4.get_GRCLEEY_Groupe_Value().get_GRG3BIS_Groupe_Value().set_G3_Value(" ");
        return CELineWMH4;
    }

    private EY1I instantiateFirstWB_H4_ForDebranchScreen(PacCELineField aPacCElineField, EY1I CELineG, PacCELineFieldComplement pCELineComplement, Boolean H4WBCEline1Write, Boolean firstComplCElineForWBH4) {
        CELineG.set_LOLIB_Value("000");
        if (aPacCElineField.getDataElement() != null) {
            CELineG.set_CORUB_Value(aPacCElineField.getDataElement().getName());
        } else if (String.valueOf(aPacCElineField.getFieldType()).equals("_PFKey") && aPacCElineField.getDataElement() == null) {
            CELineG.set_CORUB_Value("PFKEY");
        }
        CELineG.set_REPETH_Value("01");
        CELineG.set_REPETV_Value("01");
        if (pCELineComplement.getScreen() != null) {
            PacScreen screenForDebranch = pCELineComplement.getScreen();
            this.getPacLinksEntitiesService().registerReference((RadicalEntity)screenForDebranch);
            String extName = screenForDebranch.getName();
            if (screenForDebranch.getProgramExternalName() != null && screenForDebranch.getProgramExternalName().trim().length() > 0) {
                extName = screenForDebranch.getProgramExternalName();
            }
            String varia = String.valueOf(this.currentDialog.getCobolType()).substring(1);
            if (!screenForDebranch.getCobolType().equals(PacCobolTypeValues._NONE_LITERAL)) {
                varia = String.valueOf(screenForDebranch.getCobolType()).substring(1);
            }
            String varib = String.valueOf(this.currentDialog.getMapType()).substring(1);
            if (!screenForDebranch.getMapType().equals(PacMapTypeValues._NONE_LITERAL)) {
                varib = String.valueOf(screenForDebranch.getMapType()).substring(1);
            }
            String vari = varia.concat(varib);
            if (screenForDebranch.getTransactionCode() != null && screenForDebranch.getTransactionCode().trim().length() > 0 && (this.varCELine.dialogComplement.get_GROPTION_Groupe_Value().get_NMONIT_Value().equals("1") || varia.equals("U") && this.varCELine.isOptionLOGMES || vari.equals("MO"))) {
                extName = screenForDebranch.getTransactionCode();
            }
            if (extName.length() > 4) {
                CELineG.set_FIENR_Value(extName.substring(0, 4));
                CELineG.set_CORUM_Value(extName.substring(4));
            } else {
                CELineG.set_FIENR_Value(extName);
            }
        }
        String dispSegCod = "";
        dispSegCod = pCELineComplement.getDisplaySegmentCode();
        if (dispSegCod.length() < 5) {
            CELineG.get_GRZSOURA_Groupe_Value().set_GRCOSEGA_Value(dispSegCod);
        } else {
            CELineG.set_GRZSOURA_Value(dispSegCod);
        }
        if (!String.valueOf(pCELineComplement.getUpdateOption()).equals("_None")) {
            CELineG.set_OPMAJ_Value(this.getUpdateOption(String.valueOf(pCELineComplement.getUpdateOption())));
        } else {
            CELineG.set_OPMAJ_Value("");
        }
        if (!String.valueOf(pCELineComplement.getSourceType()).equals("_None")) {
            if (String.valueOf(pCELineComplement.getSourceType()).equals("_STAR")) {
                CELineG.set_TYSOUR_Value("*");
            } else {
                CELineG.set_TYSOUR_Value(String.valueOf(pCELineComplement.getSourceType()).substring(1));
            }
        }
        if (H4WBCEline1Write.booleanValue() && !firstComplCElineForWBH4.booleanValue()) {
            if (!String.valueOf(pCELineComplement.getPresenceCheck()).equals("_None")) {
                CELineG.set_STRCE_Value(String.valueOf(pCELineComplement.getPresenceCheck()).substring(1));
            }
            this.varCELine.screenLines.add((PacbaseSegment)CELineG);
            if (aPacCElineField.getFieldType().equals(PacScreenFieldTypeValues._PF_KEY_LITERAL) && this.varCELine.isOptionSWAP) {
                this.varCELine.screenLines.add(this.instantiateFirstWM_H4_ForDebranchScreen(CELineG));
            }
        }
        return CELineG;
    }

    private EY22 instantiateWB_H4_E(EY1I CELine, int numGB, PacCELineField aPacCElineField, PacDLine pPacDLine, boolean rubFille, PacDataElement PParentDataElement) {
        EY22 CELineDRub = new EY22();
        CELineDRub.set_GRCLEEY_Value(String.valueOf(CELine.get_GRCLEEY_Groupe_Value()));
        PacbaseSegment.GRCLEEY cleEY22 = CELineDRub.get_GRCLEEY_Groupe_Value();
        cleEY22.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GA_Value(INPUT_FORMAT);
        String strNumGB = "000" + ++numGB;
        String NumGBS = strNumGB.substring(strNumGB.length() - 3);
        cleEY22.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GB_Value(NumGBS);
        EY22.GRPR22.GRENREG ky22enreg = CELineDRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value();
        ky22enreg.get_GRI22_Groupe_Value().set_CORUB_Value(aPacCElineField.getDataElement().getName());
        ky22enreg.get_GRI22_Groupe_Value().set_NULIG_Value(NumGBS);
        if (!rubFille) {
            ky22enreg.get_GRCARTE6_Groupe_Value().set_TYCOD_Value(pPacDLine.getLineType());
            ky22enreg.get_GRCARTE6_Groupe_Value().set_SAVED_Value(pPacDLine.getMore());
        }
        if (pPacDLine.getAllowedValues().trim().length() > 0) {
            this.formatKY22(pPacDLine, ky22enreg);
            PacDataElement pacdelt = null;
            if (!rubFille || PParentDataElement.equals(null)) {
                Iterator extensionsDE = aPacCElineField.getDataElement().getExtensions().iterator();
                while (extensionsDE.hasNext()) {
                    try {
                        pacdelt = (PacDataElement)extensionsDE.next();
                    }
                    catch (Exception exception) {}
                }
            } else {
                pacdelt = PParentDataElement;
            }
            String valru = CELineDRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRCARTE6_Groupe_Value().get_VALRU_Value();
            String bornei = CELineDRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRCARTE6_Groupe_Value().get_GRXDECOD_Groupe_Value().get_BORNEI_Value();
            String bornes = CELineDRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRCARTE6_Groupe_Value().get_GRXDECOD_Groupe_Value().get_BORNES_Value();
            if (pacdelt != null && (valru.trim().length() > 0 || bornei.trim().length() > 0 || bornes.trim().length() > 0)) {
                String delimForEntityPdelt = pacdelt.getGenerationParameter().getAlphanumericDelimiter();
                String variantForEntityPdelt = pacdelt.getGenerationParameter().getCobolType().getLiteral().substring(1);
                if (valru.trim().length() > 0) {
                    String valru1 = this.convertDelimiter(delimForEntityPdelt, variantForEntityPdelt, valru);
                    CELineDRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRCARTE6_Groupe_Value().set_VALRU_Value(valru1);
                }
                if (bornei.trim().length() > 0) {
                    String bornei1 = this.convertDelimiter(delimForEntityPdelt, variantForEntityPdelt, bornei);
                    CELineDRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRCARTE6_Groupe_Value().get_GRXDECOD_Groupe_Value().set_BORNEI_Value(bornei1);
                }
                if (bornes.trim().length() > 0) {
                    String bornes1 = this.convertDelimiter(delimForEntityPdelt, variantForEntityPdelt, bornes);
                    CELineDRub.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRCARTE6_Groupe_Value().get_GRXDECOD_Groupe_Value().set_BORNES_Value(bornes1);
                }
            }
            this.varCELine.screenLines.add((PacbaseSegment)CELineDRub);
        }
        return CELineDRub;
    }

    private int searchForControlValue(DataElement parentDataElement, EY1I CELine, int numGB, PacCELineField aPacCElineField) {
        if (parentDataElement instanceof DataElement) {
            Iterator DLinesParent;
            PacDataElement PParentDataElement = null;
            Iterator extensionsEltP = parentDataElement.getExtensions().iterator();
            while (extensionsEltP.hasNext()) {
                try {
                    PParentDataElement = (PacDataElement)extensionsEltP.next();
                }
                catch (Exception exception) {}
            }
            if (PParentDataElement != null && !(DLinesParent = PParentDataElement.getDLines().iterator()).equals(null)) {
                while (DLinesParent.hasNext()) {
                    PacDLine pPacDLine = (PacDLine)DLinesParent.next();
                    boolean rubFille = true;
                    if (pPacDLine.getLineType().trim().length() >= 1 && !pPacDLine.getLineType().trim().equals(INTERNAL_FORMAT) && !pPacDLine.getLineType().trim().equals(O_PRESENCECHECK)) continue;
                    EY22 CELineDRub = this.instantiateWB_H4_E(CELine, numGB, aPacCElineField, pPacDLine, rubFille, PParentDataElement);
                    String numGBSt = CELineDRub.get_GRCLEEY_Groupe_Value().get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().get_GB_Value();
                    numGB = Integer.parseInt(numGBSt);
                }
            }
        }
        return numGB;
    }

    private EY1I instanciateWB_H6_I(EY1I CELine, Boolean ComplCELine, Boolean firstComplCELine, PacCELineFieldComplement pCELineComplement, String presenceCheck, String actionCde, String updateOption) {
        CELine = new EY1I(CELine.getCompleteContentForSegment());
        PacbaseSegment.GRCLEEY cleEY1I = CELine.get_GRCLEEY_Groupe_Value();
        cleEY1I.get_GRG3BIS_Groupe_Value().set_G3_Value("B");
        cleEY1I.set_COCA_Value("H6");
        cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_G4_Value(this.varCELine.currentCategory);
        if (!actionCde.equals("None")) {
            cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_GRG5A6_Groupe_Value().set_G5_Value(actionCde);
        }
        PacScreenUpdateOptionValues updateOptionValue = pCELineComplement.getUpdateOption();
        if ((presenceCheck.equals(P_PRESENCECHECK) || presenceCheck.equals("F")) && (updateOptionValue.equals(PacScreenUpdateOptionValues._NONE_LITERAL) || updateOptionValue.equals(PacScreenUpdateOptionValues._PLUS_LITERAL) || updateOptionValue.equals(PacScreenUpdateOptionValues._MINUS_LITERAL) || updateOptionValue.equals(PacScreenUpdateOptionValues._M_LITERAL))) {
            cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_GRG5A6_Groupe_Value().set_G5_Value(P_PRESENCECHECK);
        }
        CELine.set_OPMAJ_Value("M");
        if (updateOptionValue.equals(PacScreenUpdateOptionValues._PLUS_LITERAL)) {
            CELine.set_OPMAJ_Value("+");
        }
        if (updateOptionValue.equals(PacScreenUpdateOptionValues._MINUS_LITERAL)) {
            CELine.set_OPMAJ_Value("-");
        }
        CELine.get_GRCLEEY_Groupe_Value().get_GRG3BIS_Groupe_Value().set_G3_Value("B");
        CELine.set_STRCE_Value("");
        CELine.set_TIPE1_Value("");
        CELine.set_PICTU_Value("");
        CELine.get_GRFORMAT_Groupe_Value().set_NBCHA_Value("");
        CELine.get_GRFORMAT_Groupe_Value().set_NBCHP_Value("");
        CELine.set_NULIG_Value("");
        CELine.set_ATTRIL_Value("");
        CELine.set_ATTRIR_Value("");
        CELine.set_ATTRPL_Value("");
        CELine.set_ATTRPR_Value("");
        CELine.set_ATTRCL_Value("");
        CELine.set_ATTRCR_Value("");
        CELine.set_SUPIC_Value("");
        CELine.set_ICAT_Value("");
        if (String.valueOf(CELine.get_GRZSOURA_Groupe_Value()).trim().length() <= 0) {
            CELine.set_TYSOUR_Value("");
        }
        String _3BLANCS = new String("   ");
        CELine.set_NULIG_Value(_3BLANCS);
        if (ComplCELine.booleanValue() && !firstComplCELine.booleanValue()) {
            if (pCELineComplement.getUpdateSegmentCode().trim().length() > 3) {
                CELine.set_CORUM_Value(pCELineComplement.getUpdateSegmentCode().substring(4));
            }
            this.varCELine.screenLines.add((PacbaseSegment)CELine);
            if (this.currentScreen.getDialogType().equals(PacDialogTypeValues._NONE_LITERAL)) {
                this.initializeListForWBH5LineForStandartScreen(CELine);
            } else {
                this.initializeListForWBH5LineForClientScreen(CELine);
            }
        }
        return CELine;
    }

    private EY1I instanciateWB_H6(EY1I CELine, PacbaseSegment.GRCLEEY cleEY1I, PacCELineFieldComplement pCELineComplement, String updateOption, Boolean ComplCELine, String presenceCheck, String actionCde, Boolean firstComplCELine) {
        CELine = new EY1I(CELine.getCompleteContentForSegment());
        cleEY1I = CELine.get_GRCLEEY_Groupe_Value();
        cleEY1I.get_GRG3BIS_Groupe_Value().set_G3_Value("B");
        cleEY1I.set_COCA_Value("H6");
        cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_G4_Value(this.varCELine.currentCategory);
        cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_GRG5A6_Groupe_Value().set_G6BIS_Value("");
        cleEY1I.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GA_Value("");
        cleEY1I.get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GB_Value("");
        CELine.set_OPMAJ_Value("M");
        if (updateOption.equals("PLUS")) {
            CELine.set_OPMAJ_Value("+");
        }
        if (updateOption.equals("MINUS")) {
            CELine.set_OPMAJ_Value("-");
        }
        if (!actionCde.equals("None")) {
            cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_GRG5A6_Groupe_Value().set_G5_Value(actionCde);
        }
        if ((presenceCheck.equals(P_PRESENCECHECK) || presenceCheck.equals("F")) && (updateOption.equals("None") || updateOption.equals("PLUS") || updateOption.equals("MINUS") || updateOption.equals("M"))) {
            cleEY1I.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_GRG5A6_Groupe_Value().set_G5_Value(P_PRESENCECHECK);
        }
        if (!(ComplCELine.booleanValue() || updateOption.equals(P_PRESENCECHECK) || updateOption.equals(OUTPUT_FORMAT) || updateOption.equals("G") || updateOption.equals("V") || pCELineComplement.getUpdateSegmentCode() == null || pCELineComplement.getUpdateSegmentCode().trim().length() <= 0)) {
            CELine.set_FIENR_Value(pCELineComplement.getUpdateSegmentCode());
            CELine.get_GRZSOURA_Groupe_Value().set_CORUBA_Value("");
            if (firstComplCELine.booleanValue()) {
                this.varCELine.screenLines.add((PacbaseSegment)CELine);
            }
            if (this.currentScreen.getDialogType().equals(PacDialogTypeValues._NONE_LITERAL)) {
                this.initializeListForWBH5LineForStandartScreen(CELine);
            } else {
                this.initializeListForWBH5LineForClientScreen(CELine);
            }
        }
        return CELine;
    }

    private EY1I instanciateWD_H4_I(PacbaseSegment.GRCLEEY cleEY1IH4WD, PacCELineFieldComplement pCELineComplement, Boolean ComplCELine, Boolean firstComplCELine, EY1I CELineH4WD, EY1I CELine) {
        cleEY1IH4WD.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_G4_Value(this.varCELine.currentCategory);
        cleEY1IH4WD.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_GRG5A6_Value("");
        if (pCELineComplement.getDisplaySegmentCode() != null && pCELineComplement.getDisplaySegmentCode().trim().length() > 3 && pCELineComplement.getSourceType() != null && !pCELineComplement.getSourceType().equals(PacScreenSourceTypeValues._STAR_LITERAL) && !pCELineComplement.getSourceType().equals(PacScreenSourceTypeValues._S_LITERAL)) {
            cleEY1IH4WD.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_GRG5A6_Value(pCELineComplement.getDisplaySegmentCode().substring(0, 4));
        }
        if (!pCELineComplement.getPresenceCheck().equals(PacScreenPresenceCheckValues._NONE_LITERAL)) {
            CELineH4WD.set_STRCE_Value(String.valueOf(pCELineComplement.getPresenceCheck()).substring(1));
        } else {
            CELineH4WD.set_STRCE_Value("");
        }
        PacScreenUpdateOptionValues updateOptionValue = pCELineComplement.getUpdateOption();
        if (updateOptionValue.equals(PacScreenUpdateOptionValues._PLUS_LITERAL)) {
            CELineH4WD.set_OPMAJ_Value("+");
        }
        if (updateOptionValue.equals(PacScreenUpdateOptionValues._MINUS_LITERAL)) {
            CELineH4WD.set_OPMAJ_Value("-");
        }
        CELineH4WD.set_TIPE1_Value("");
        CELineH4WD.set_PICTU_Value("");
        CELineH4WD.get_GRFORMAT_Groupe_Value().set_NBCHA_Value("");
        CELineH4WD.get_GRFORMAT_Groupe_Value().set_NBCHP_Value("");
        String _2BLANCS = new String("  ");
        CELineH4WD.set_NULIM_Value(_2BLANCS);
        CELineH4WD.set_ATTRIL_Value("");
        CELineH4WD.set_ATTRIR_Value("");
        CELineH4WD.set_ATTRPL_Value("");
        CELineH4WD.set_ATTRPR_Value("");
        CELineH4WD.set_ATTRCL_Value("");
        CELineH4WD.set_ATTRCR_Value("");
        CELineH4WD.set_SUPIC_Value("");
        CELineH4WD.set_VAREC_Value("");
        CELineH4WD.set_CORUM_Value("");
        CELineH4WD.set_ICAT_Value("");
        if (String.valueOf(CELineH4WD.get_GRZSOURA_Groupe_Value()).trim().length() <= 0) {
            CELineH4WD.set_TYSOUR_Value("");
        }
        String _3BLANCS = new String("   ");
        CELineH4WD.set_NULIG_Value(_3BLANCS);
        this.varCELine.screenLines.add((PacbaseSegment)CELineH4WD);
        if (this.currentScreen.getDialogType().equals(PacDialogTypeValues._NONE_LITERAL)) {
            this.initializeListForWBH5LineForStandartScreen(CELine);
        } else {
            this.initializeListForWBH5LineForClientScreen(CELine);
        }
        return CELine;
    }

    private EY1I instanciateWB_H4_I(EY1I CELine, String updateOption, PacCELineFieldComplement pCELineComplement, Boolean ComplCELine, Boolean firstComplCELine) {
        EY1I CELineH4WB = new EY1I(CELine.getCompleteContentForSegment());
        PacbaseSegment.GRCLEEY cleEY1IH4WB = CELineH4WB.get_GRCLEEY_Groupe_Value();
        cleEY1IH4WB.get_GRG3BIS_Groupe_Value().set_G3_Value("B");
        cleEY1IH4WB.set_COCA_Value("H4");
        CELineH4WB.set_OPMAJ_Value(updateOption);
        cleEY1IH4WB.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_G4_Value("");
        cleEY1IH4WB.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_GRG5A6_Groupe_Value().set_G5_Value("   ");
        cleEY1IH4WB.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().get_GRG5A6_Groupe_Value().set_G6BIS_Value(this.varCELine.currentCategory);
        if (pCELineComplement.getSourceType() != null && !String.valueOf(pCELineComplement.getSourceType()).equals("_None")) {
            if (String.valueOf(pCELineComplement.getSourceType()).equals("_STAR")) {
                CELineH4WB.set_TYSOUR_Value("*");
                CELineH4WB.set_GRZSOURA_Value(pCELineComplement.getDisplaySegmentCode());
            } else {
                CELineH4WB.set_TYSOUR_Value(String.valueOf(pCELineComplement.getSourceType()).substring(1));
            }
        }
        if (ComplCELine.booleanValue() && !firstComplCELine.booleanValue()) {
            PacScreen screenForDebranch;
            if (pCELineComplement.getScreen() != null && (screenForDebranch = pCELineComplement.getScreen()) == null) {
                this.varCELine.screenLines.add((PacbaseSegment)CELineH4WB);
            }
            if (updateOption.equals(P_PRESENCECHECK)) {
                this.varCELine.screenLines.add((PacbaseSegment)CELineH4WB);
            }
        }
        return CELine;
    }

    private void formatKY22(PacDLine pPacDLine, EY22.GRPR22.GRENREG ky22enreg) {
        String allowedVal = pPacDLine.getAllowedValues();
        ky22enreg.get_GRCARTE6_Groupe_Value().set_VALRU_Value(allowedVal);
        ky22enreg.get_GRCARTE6_Groupe_Value().set_TYCOD_Value(pPacDLine.getLineType());
        ky22enreg.get_GRCARTE6_Groupe_Value().set_SAVED_Value(pPacDLine.getMore());
        ky22enreg.get_GRCARTE6_Groupe_Value().set_GRSIGNI_Value(pPacDLine.getDescription());
        ky22enreg.get_GRCARTE6_Groupe_Value().get_GRXDECOD_Groupe_Value().set_TYVAL_Value("V");
        if (allowedVal.length() > 0 && allowedVal.substring(0, 1).equals("*")) {
            ky22enreg.get_GRCARTE6_Groupe_Value().get_GRXDECOD_Groupe_Value().set_TYVAL_Value(allowedVal);
            ky22enreg.get_GRCARTE6_Groupe_Value().get_GRXDECOD_Groupe_Value().set_BORNEI_Value(allowedVal.substring(1));
        }
        ky22enreg.get_GRCARTE6_Groupe_Value().set_GRTABTC_Value("000000000");
        if (allowedVal != null) {
            String firstAllowedVal = allowedVal.trim().substring(0, 1);
            String lastAllowedVal = " ";
            int lgValue = allowedVal.length();
            lastAllowedVal = allowedVal.length() > 9 ? allowedVal.substring(9, 10) : allowedVal.substring(lgValue - 1);
            if (firstAllowedVal.equals(")") || firstAllowedVal.equals("(")) {
                ky22enreg.get_GRCARTE6_Groupe_Value().get_GRXDECOD_Groupe_Value().set_TYBORI_Value(firstAllowedVal);
                if (!lastAllowedVal.equals(")") && !lastAllowedVal.equals("(")) {
                    String firstAllowedValue = allowedVal.trim().substring(1);
                    ky22enreg.get_GRCARTE6_Groupe_Value().get_GRXDECOD_Groupe_Value().set_BORNEI_Value(" " + firstAllowedValue);
                } else {
                    int blancCar = allowedVal.trim().indexOf(" ");
                    if (blancCar > 0) {
                        ky22enreg.get_GRCARTE6_Groupe_Value().get_GRXDECOD_Groupe_Value().set_BORNEI_Value(" " + allowedVal.trim().substring(1, blancCar));
                        String blank = " ";
                        String chainBlank = "";
                        int i = 0;
                        while (i < blancCar) {
                            chainBlank = chainBlank.concat(blank);
                            ++i;
                        }
                        int lgValuetrim = allowedVal.trim().length();
                        ky22enreg.get_GRCARTE6_Groupe_Value().get_GRXDECOD_Groupe_Value().set_BORNES_Value(chainBlank.concat(allowedVal.trim().substring(blancCar, --lgValuetrim)));
                    }
                }
            }
            if (firstAllowedVal.equals(")") || firstAllowedVal.equals("(") || lastAllowedVal.equals(")") || lastAllowedVal.equals("(")) {
                ky22enreg.get_GRCARTE6_Groupe_Value().get_GRXDECOD_Groupe_Value().set_TYVAL_Value("B");
            }
            if (lastAllowedVal.equals(")") || lastAllowedVal.equals("(")) {
                ky22enreg.get_GRCARTE6_Groupe_Value().get_GRXDECOD_Groupe_Value().set_TYBORS_Value(lastAllowedVal);
                if (!firstAllowedVal.equals(")") && !firstAllowedVal.equals("(")) {
                    ky22enreg.get_GRCARTE6_Groupe_Value().get_GRXDECOD_Groupe_Value().set_TYBORI_Value(" ");
                    ky22enreg.get_GRCARTE6_Groupe_Value().get_GRXDECOD_Groupe_Value().set_BORNEI_Value("          ");
                    ky22enreg.get_GRCARTE6_Groupe_Value().get_GRXDECOD_Groupe_Value().set_BORNES_Value(allowedVal.substring(0, --lgValue));
                }
            }
        }
    }

    private String convertDelimiter(String delimEntity, String variantEntity, String inputField) {
        return PacQuoteConverter.ConvertTextWithTargetDelimiter((String)inputField, (String)delimEntity, (String)variantEntity, (String)this.varCELine.delimGenerateBib, (String)this.varCELine.variantGenerateBib);
    }

    private EY1I instanciateWEH8FormWDH4(EY1I line) {
        EY1I aEY1I = new EY1I(line.getCompleteContentForSegment());
        PacbaseSegment.GRCLEEY cle = aEY1I.get_GRCLEEY_Groupe_Value();
        cle.set_GRNUTIL_Value("0101");
        cle.set_G2_Value(this.currentScreen.getName());
        cle.set_G1_Value("W");
        cle.set_GRG3BIS_Value("E   ");
        cle.set_COCA_Value("H8");
        cle.get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_G4_Value(this.varCELine.currentCategory);
        return aEY1I;
    }

    private void writeH5WB(String completeContentForSegment, String segmentCode, String corub) {
        EY1I pH5WBt = new EY1I();
        pH5WBt.set_GRCLEEY_Value(completeContentForSegment);
        pH5WBt.get_GRCLEEY_Groupe_Value().get_GRG3BIS_Groupe_Value().set_G3_Value("B");
        pH5WBt.get_GRCLEEY_Groupe_Value().set_COCA_Value("H5");
        pH5WBt.set_FIENR_Value(segmentCode);
        pH5WBt.set_CORUM_Value(corub);
        this.varCELine.screenLines.add((PacbaseSegment)pH5WBt);
    }

    private void writeIM_WH8(EY1I CELine, String value) {
        CELine.set_LIRUE_Value(value);
        CELine.set_NARUE_Value(" ");
        CELine.set_TLIB_Value(" ");
        CELine.set_LOLIB_Value("   ");
        CELine.set_STRCE_Value(" ");
        CELine.set_REPETH_Value("  ");
        CELine.set_REPETV_Value("  ");
        CELine.set_TIPE1_Value(" ");
        CELine.set_PICTU_Value(" ");
        CELine.get_GRFORMAT_Groupe_Value().set_NBCHA_Value("  ");
        CELine.get_GRFORMAT_Groupe_Value().set_NBCHP_Value("  ");
        CELine.set_ATTRIL_Value(" ");
        CELine.set_ATTRIR_Value(" ");
        CELine.set_ATTRPL_Value(" ");
        CELine.set_ATTRPR_Value(" ");
        CELine.set_ATTRCL_Value(" ");
        CELine.set_ATTRCR_Value(" ");
        CELine.set_FIENR_Value(" ");
        CELine.set_REPET9_Value("      ");
        CELine.set_OPEP_Value(" ");
        CELine.set_CORUM_Value(" ");
        CELine.set_NIVST_Value(" ");
        CELine.set_ICAT_Value(" ");
        CELine.set_NULIG_Value("   ");
        CELine.set_OPMAJ_Value(" ");
        CELine.set_TYSOUR_Value(" ");
        CELine.set_GRZSOURA_Value(" ");
        this.varCELine.screenLines.add((PacbaseSegment)CELine);
        EY1I CELineIndMH8 = new EY1I(CELine.getCompleteContentForSegment());
        CELineIndMH8.get_GRCLEEY_Groupe_Value().set_G1_Value("W");
        this.varCELine.screenLines.add((PacbaseSegment)CELineIndMH8);
        EY1I CELineWDH4 = new EY1I(CELineIndMH8.getCompleteContentForSegment());
        CELineWDH4.get_GRCLEEY_Groupe_Value().get_GRG3BIS_Groupe_Value().set_G3_Value("D");
        CELineWDH4.get_GRCLEEY_Groupe_Value().set_COCA_Value("H4");
        CELineWDH4.get_GRCLEEY_Groupe_Value().get_GRG4A7_Groupe_Value().get_GRG4A6_Groupe_Value().set_G4_Value(this.varCELine.currentCategory);
        CELineWDH4.get_GRCLEEY_Groupe_Value().get_GRG9AB_Groupe_Value().get_GRGAAB_Groupe_Value().set_GA_Value(INTERNAL_FORMAT);
        CELineWDH4.set_VAREC_Value("");
        CELineWDH4.set_LIRUE_Value("");
        this.varCELine.screenLines.add((PacbaseSegment)CELineWDH4);
    }

    public void setCurrentScreen(PacScreen ps) {
        this.currentScreen = ps;
    }

    public void setCurrentDialog(PacDialog dia) {
        this.currentDialog = dia;
    }

    private PacbaseLinksEntitiesService getPacLinksEntitiesService() {
        return this.ples;
    }

    public String getUpdateOption(String updtOpt) {
        String opmaj = updtOpt.substring(1);
        if (updtOpt.equals("_PLUS")) {
            opmaj = "+";
        }
        if (updtOpt.equals("_MINUS")) {
            opmaj = "-";
        }
        return opmaj;
    }
}

