/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.generate.dataBaseBlock.generate;

import com.ibm.pdp.dataBaseBlock.model.EL13;
import com.ibm.pdp.dataBaseBlock.model.EL22;
import com.ibm.pdp.dataBaseBlock.model.EL2L;
import com.ibm.pdp.dataBaseBlock.model.PacbaseSegment;
import com.ibm.pdp.dataBaseBlock.model.XB20;
import com.ibm.pdp.explorer.nature.PTNature;
import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.kernel.DataAggregateDescription;
import com.ibm.pdp.mdl.kernel.DataCall;
import com.ibm.pdp.mdl.kernel.DataComponent;
import com.ibm.pdp.mdl.kernel.DataElement;
import com.ibm.pdp.mdl.kernel.DataElementDescription;
import com.ibm.pdp.mdl.kernel.DataUnion;
import com.ibm.pdp.mdl.kernel.DataUnionDescription;
import com.ibm.pdp.mdl.kernel.Filler;
import com.ibm.pdp.mdl.kernel.KernelPackage;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.impl.DataElementImpl;
import com.ibm.pdp.mdl.pacbase.PacBlockBaseTypeValues;
import com.ibm.pdp.mdl.pacbase.PacDataCall;
import com.ibm.pdp.mdl.pacbase.PacDataCallMore;
import com.ibm.pdp.mdl.pacbase.PacDataElement;
import com.ibm.pdp.mdl.pacbase.PacFiller;
import com.ibm.pdp.mdl.pacbase.PacbasePackage;
import com.ibm.pdp.mdl.pacbase.converter.PacPictureParser;
import com.ibm.pdp.mdl.pacbase.impl.PacBlockBaseImpl;
import com.ibm.pdp.mdl.pacbase.impl.PacDLineImpl;
import com.ibm.pdp.mdl.pacbase.impl.PacDataElementDescriptionImpl;
import com.ibm.pdp.mdl.pacbase.impl.PacDataElementImpl;
import com.ibm.pdp.mdl.pacbase.lal.util.GenerationContext;
import com.ibm.pdp.mdl.pacbase.lal.util.LengthAndPositionVisitor;
import com.ibm.pdp.mdl.pacbase.lal.util.PacbaseLalDescription;
import com.ibm.pdp.mdl.pacbase.util.PacTransformationBlockBaseType;
import com.ibm.pdp.pacbase.generate.util.PacbaseLinksEntitiesService;
import com.ibm.pdp.pacbase.generate.util.PacbaseModelService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class SegmentCompositionPacbaseAndKernelVisitor {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final PacbasePackage modelPackagePB = PacbasePackage.eINSTANCE;
    protected static final KernelPackage modelPackageKernel = KernelPackage.eINSTANCE;
    protected String borne = "BORNE=DE ";
    protected String nbVal = "NBVAL=";
    private String redefines = "R*";
    private PacBlockBaseImpl baseCodeToGenerate;
    private String segmentCodeToUse;
    private int nuligToUse;
    private int numer;
    private ArrayList<PacbaseSegment> segmentCompositionLines = new ArrayList();
    private DataCall currentDataCall;
    private String nameOfProject;
    private int numberOfCorub = 0;
    private boolean firstTime = true;
    private boolean firstTimeForDataAggregate = true;
    private boolean writeLengthRecord = false;
    private char variant;
    private String fabloc;
    private String libName;
    private String subSchema;
    private ArrayList<PacbaseLalDescription> lalList = new ArrayList();
    private int maxLth = 0;
    private DataUnionDescription _currentDataUnionDescription = null;
    private boolean dataForRedefines = false;
    private DataElement dataElt;
    private PacbaseLinksEntitiesService ples;
    private boolean isRedefines = false;
    private int nbDERedefines = 0;
    private boolean isGroupOccurs = false;
    private int memoLevelGroupOccurs = 0;

    public SegmentCompositionPacbaseAndKernelVisitor(PacbaseLinksEntitiesService ples) {
        this.ples = ples;
    }

    public void doSwitch(EObject theEObject) {
        this.doSwitch(theEObject.eClass(), theEObject);
    }

    protected void doSwitch(EClass theEClass, EObject theEObject) {
        if (theEObject instanceof RadicalEntity) {
            this.getPacLinksEntitiesService().registerReference((RadicalEntity)theEObject);
        }
        if (theEClass.eContainer() == modelPackagePB) {
            this.doSwitchPB(theEClass.getClassifierID(), theEObject);
        } else if (theEClass.eContainer() == modelPackageKernel) {
            this.doSwitchKernel(theEClass.getClassifierID(), theEObject);
        }
    }

    protected void doSwitchKernel(int classifierID, EObject theEObject) {
        PacbaseLalDescription lal;
        if (this.isGroupOccurs && (lal = this.lalList.get(this.numberOfCorub)).getLevel() == this.memoLevelGroupOccurs) {
            this.isGroupOccurs = false;
        }
        switch (classifierID) {
            case 37: {
                DataCall kernelObject = (DataCall)theEObject;
                this.caseDataCall(kernelObject);
                break;
            }
            case 45: {
                DataCall kernelObject = (DataAggregate)theEObject;
                this.caseDataAggregate((DataAggregate)kernelObject);
                break;
            }
            case 18: {
                DataCall kernelObject = (DataAggregateDescription)theEObject;
                this.caseDataAggregateDescription((DataAggregateDescription)kernelObject);
                break;
            }
            case 44: {
                DataCall kernelObject = (DataElement)theEObject;
                this.caseDataElement((DataElement)kernelObject);
                break;
            }
            case 33: {
                DataCall kernelObject = (DataElementDescription)theEObject;
                this.caseDataElementDescription((DataElementDescription)kernelObject);
                break;
            }
            case 43: {
                DataCall kernelObject = (Filler)theEObject;
                this.caseFiller((Filler)kernelObject);
                break;
            }
            case 46: {
                DataCall kernelObject = (DataUnion)theEObject;
                this.caseDataUnion((DataUnion)kernelObject);
                break;
            }
            case 35: {
                DataCall kernelObject = (DataUnionDescription)theEObject;
                this.caseDataUnionDescription((DataUnionDescription)kernelObject);
                break;
            }
            default: {
                System.out.println("Kernel case not defined: " + theEObject.getClass().toString());
            }
        }
    }

    protected void doSwitchPB(int classifierID, EObject theEObject) {
        switch (classifierID) {
            case 59: {
                PacDataCall pacbaseObject = (PacDataCall)theEObject;
                this.casePacDataCall(pacbaseObject);
                break;
            }
            case 56: {
                PacDataElement pacbaseObject = (PacDataElement)theEObject;
                this.casePacDataElement(pacbaseObject);
                break;
            }
            default: {
                System.out.println("Pacbase case not defined: " + theEObject.getClass().toString());
            }
        }
    }

    public void caseDataCall(DataCall kDataCall) {
        this.currentDataCall = kDataCall;
        if (kDataCall.getDataDefinition() != null) {
            if (kDataCall.getDataDefinition() instanceof DataElement) {
                this.doSwitch((EObject)kDataCall.getDataDefinition());
            }
            if (kDataCall.getDataDefinition() instanceof DataAggregate) {
                this.doSwitch((EObject)kDataCall.getDataDefinition());
            }
            if (kDataCall.getDataDefinition() instanceof DataUnion) {
                this.doSwitch((EObject)kDataCall.getDataDefinition());
            }
        } else if (kDataCall.getDataDescription() != null) {
            this.doSwitch((EObject)kDataCall.getDataDescription());
        }
    }

    public void caseDataAggregate(DataAggregate kDataAggregate) {
        if (!this.firstTimeForDataAggregate) {
            if (this.lalList.size() == this.numberOfCorub) {
                return;
            }
            EL13 el13DataAggregateC = this.InstanciateEL13();
            if (this.currentDataCall != null) {
                EList extensions = this.currentDataCall.getExtensions();
                this.updateDataCall((List)extensions, el13DataAggregateC, kDataAggregate.getName());
            }
            this.initFromLalDescription(el13DataAggregateC);
            el13DataAggregateC.get_GRPR13_Groupe_Value().get_GRI13_Groupe_Value().get_GRNULI8_Groupe_Value().set_NULIG_Value(this.getNumberCorubDigit());
            el13DataAggregateC.get_GRPR13_Groupe_Value().get_GR3LORUS_Groupe_Value().set_LORUBS_Value(0);
            el13DataAggregateC.get_GRPR13_Groupe_Value().set_LORUBI_Value(0);
            el13DataAggregateC.get_GRPR13_Groupe_Value().set_LORUBE_Value(0);
            el13DataAggregateC.get_GRPR13_Groupe_Value().get_GRNRURE_Groupe_Value().set_NRUR9_Value("**");
            el13DataAggregateC.get_GRPR13_Groupe_Value().set_TYAPP_Value("A");
            if (this.getFabloc().equals("M") || this.getBasecodeToGenerate().getBlockType() == PacBlockBaseTypeValues._TD_LITERAL) {
                el13DataAggregateC = this.FormatEL13FromXB20(el13DataAggregateC, this.InstanciateXB20(el13DataAggregateC));
            } else if (this.getFabloc().equals("S")) {
                el13DataAggregateC = this.FormatEL13FromXB20(el13DataAggregateC, this.InstanciateXB20(el13DataAggregateC));
                this.prepLineForSocrateData(el13DataAggregateC);
            }
            if (this.isWritableDataCall(el13DataAggregateC, false)) {
                this.segmentCompositionLines.add(el13DataAggregateC);
            }
        } else {
            LengthAndPositionVisitor lpvisitor = new LengthAndPositionVisitor(this.getPaths(), new GenerationContext(this.getVariant()));
            lpvisitor.doSwitch((EObject)kDataAggregate);
            this.lalList = lpvisitor.defineMatchingArray(lpvisitor.getTopParentLal());
            this.maxLth = Integer.parseInt(lpvisitor.getTopParentLal().getTotalInternalLength());
            this.numberOfCorub = 0;
            this.firstTimeForDataAggregate = false;
            this.writeLengthRecord = true;
        }
        this.doSwitch((EObject)kDataAggregate.getDataDescription());
        this.isRedefines = false;
        if (this.writeLengthRecord && this.getFabloc().equals("H")) {
            EL2L el2lDataAggregate = this.InstanciateEL2L();
            this.segmentCompositionLines.add(el2lDataAggregate);
            this.writeLengthRecord = false;
        }
    }

    public void caseDataAggregateDescription(DataAggregateDescription kDataAggregateDescription) {
        if (this.firstTime) {
            this.firstTime = false;
            for (EObject da : kDataAggregateDescription.getComponents()) {
                this.doSwitch(da);
            }
            return;
        }
        EL13 detailForDataElt = null;
        if (kDataAggregateDescription.getName() != null && kDataAggregateDescription.getName().length() > 0) {
            detailForDataElt = this.InstanciateEL13();
            detailForDataElt = this.initFromLalDescription(detailForDataElt);
            detailForDataElt.get_GRPR13_Groupe_Value().get_GRI13_Groupe_Value().get_GRNULI8_Groupe_Value().set_NULIG_Value(this.getNumberCorubDigit());
            detailForDataElt.get_GRPR13_Groupe_Value().set_TYAPP_Value("C");
            EList extCDC = this.currentDataCall.getExtensions();
            this.updateDataCall((List)extCDC, detailForDataElt, kDataAggregateDescription.getName());
            RadicalEntity re = PacbaseModelService.SearchRadicalEntityDuringGeneration((RadicalEntity)this.getBasecodeToGenerate(), (String)kDataAggregateDescription.getName(), (String)"dataelement", (PacbaseLinksEntitiesService)this.ples);
            Boolean isValidData = true;
            if (this.getFabloc().equals("H") && (detailForDataElt.get_GRPR13_Groupe_Value().get_INDIC_Value().equals("U") || detailForDataElt.get_GRPR13_Groupe_Value().get_INDIC_Value().equals("M"))) {
                isValidData = false;
            }
            if (this.getFabloc().equals("M") || this.getBasecodeToGenerate().getBlockType() == PacBlockBaseTypeValues._TD_LITERAL) {
                detailForDataElt = this.FormatEL13FromXB20(detailForDataElt, this.InstanciateXB20(detailForDataElt));
            } else if (this.getFabloc().equals("S")) {
                detailForDataElt = this.FormatEL13FromXB20(detailForDataElt, this.InstanciateXB20(detailForDataElt));
                this.prepLineForSocrateData(detailForDataElt);
            }
            if (re == null && isValidData.booleanValue()) {
                detailForDataElt.get_GRPR13_Groupe_Value().set_PICTUI_Value("");
                detailForDataElt.get_GRPR13_Groupe_Value().set_USAGEI_Value("");
                detailForDataElt.get_GRPR13_Groupe_Value().get_GR3LORUS_Groupe_Value().set_LORUBS_Value(0);
                detailForDataElt.get_GRPR13_Groupe_Value().set_LORUBI_Value(0);
                detailForDataElt.get_GRPR13_Groupe_Value().set_LORUBE_Value(0);
            }
            if (detailForDataElt != null && kDataAggregateDescription.getName() != null && kDataAggregateDescription.getName().length() > 0 && this.isWritableDataCall(detailForDataElt, false)) {
                this.segmentCompositionLines.add(detailForDataElt);
            }
        }
        for (EObject da : kDataAggregateDescription.getComponents()) {
            DataCall dc;
            this.doSwitch(da);
            if (da instanceof DataCall && (dc = (DataCall)da).getDataDefinition() != null) {
                --this.nbDERedefines;
            }
            if (da instanceof Filler) {
                --this.nbDERedefines;
            }
            if (this.nbDERedefines != 0) continue;
            this.isRedefines = false;
        }
    }

    public void caseDataElement(DataElement kDataElement) {
        EL13 linesForDataElt = this.InstanciateEL13();
        linesForDataElt = this.prepLineDataElt(linesForDataElt, kDataElement);
        linesForDataElt.get_GRPR13_Groupe_Value().get_GRI13_Groupe_Value().get_GRNULI8_Groupe_Value().set_NULIG_Value(this.getNumberCorubDigit());
        if (this.getFabloc().equals("M") || this.getBasecodeToGenerate().getBlockType() == PacBlockBaseTypeValues._TD_LITERAL) {
            XB20 xb20 = this.InstanciateXB20(linesForDataElt);
            linesForDataElt = this.FormatEL13FromXB20(linesForDataElt, xb20);
            if (this.getFabloc().equals("M")) {
                String label = "";
                String corub = kDataElement.getName();
                List dLines = this.getDLines(kDataElement.getExtensions().iterator());
                label = this.searchForColumnLabel(dLines);
                if (label.trim().length() == 0 && xb20.get_GRXB36_Groupe_Value().get_CORUG_Value().trim().length() > 0) {
                    label = this.searchForColumnLabel(this.getDLines(this.getMotherData().getExtensions().iterator()));
                    corub = xb20.get_GRXB36_Groupe_Value().get_CORUG_Value();
                }
                if (label.trim().length() > 0) {
                    EL22 el22 = this.InstanciateEL22();
                    el22.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRI22_Groupe_Value().set_CORUB_Value(corub);
                    EL22.GRPR22.GRENREG.GRCARTE6 grCarte6 = el22.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRCARTE6_Groupe_Value();
                    grCarte6.set_TYCOD_Value("C");
                    grCarte6.set_GRSIGNI_Value(label);
                    if (this.isWritableDataCall(linesForDataElt, true)) {
                        this.segmentCompositionLines.add(el22);
                    }
                }
            }
        } else if (this.getFabloc().equals("S")) {
            XB20 xb20 = this.InstanciateXB20(linesForDataElt);
            linesForDataElt = this.FormatEL13FromXB20(linesForDataElt, xb20);
            this.prepLineForSocrateData(linesForDataElt);
            List dLines = this.getDLines(kDataElement.getExtensions().iterator());
            String corub = kDataElement.getName();
            if (dLines == null) {
                dLines = this.getDLines(this.getMotherData().getExtensions().iterator());
                corub = xb20.get_GRXB36_Groupe_Value().get_CORUG_Value();
            }
            int valuesNb = 0;
            if (dLines != null) {
                int numere = 0;
                EL22 el22 = new EL22();
                el22 = this.InstanciateEL22();
                EL22.GRCLEEL cleEL22 = el22.get_GRCLEEL_Groupe_Value();
                EL22.GRPR22.GRENREG.GRCARTE6 grCarte6 = el22.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRCARTE6_Groupe_Value();
                int i = 0;
                while (i < dLines.size()) {
                    PacDLineImpl pdli = (PacDLineImpl)dLines.get(i);
                    String value = pdli.getAllowedValues().trim();
                    if (value.length() <= 0 || !value.endsWith(")") || value.startsWith("(")) {
                        el22 = new EL22();
                        el22 = this.InstanciateEL22();
                        el22.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRI22_Groupe_Value().set_CORUB_Value(corub);
                        grCarte6 = el22.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRCARTE6_Groupe_Value();
                        grCarte6.set_VALRU_Value(value);
                        grCarte6.set_GRSIGNI_Value(pdli.getDescription());
                        grCarte6.set_TYCOD_Value(pdli.getLineType());
                    }
                    if (!(grCarte6.get_TYCOD_Value().trim().length() != 0 || value.length() <= 0 || value.equals("*B") || value.equals("*Z") || value.equals("*9") || value.startsWith("(") || value.endsWith(")"))) {
                        el22.set_NUENR_Value("LV");
                        cleEL22 = el22.get_GRCLEEL_Groupe_Value();
                        cleEL22.set_NUMERD_Value(340);
                        cleEL22.set_NUMERE_Value(numere);
                        linesForDataElt.set_NUENR_Value("LV");
                        this.segmentCompositionLines.add(el22);
                        ++numere;
                        ++valuesNb;
                    } else if (pdli.getDescription().startsWith(this.borne) || value.startsWith("(") || value.endsWith(")")) {
                        el22.set_NUENR_Value("RB");
                        el22.get_GRCLEEL_Groupe_Value().set_NUMERD_Value(320);
                        if (pdli.getDescription().startsWith(this.borne)) {
                            this.segmentCompositionLines.add(el22);
                            ++numere;
                        } else {
                            int start = 0;
                            int end = value.length();
                            if (value.startsWith("(")) {
                                start = 1;
                                if (value.endsWith(")")) {
                                    end = value.indexOf(" ");
                                }
                                grCarte6.set_GRSIGNI_Value(this.borne + value.substring(start, end));
                                start = end + 1;
                            }
                            if (value.endsWith(")")) {
                                end = value.length() - 1;
                                grCarte6.set_GRSIGNI_Value(grCarte6.get_GRSIGNI_Groupe_Value().toString().trim() + " A " + value.substring(start, end));
                                this.segmentCompositionLines.add(el22);
                                ++numere;
                            }
                        }
                    } else if (pdli.getDescription().startsWith(this.nbVal)) {
                        el22.set_NUENR_Value("LV");
                        el22.get_GRCLEEL_Groupe_Value().set_NUMERD_Value(330);
                        this.segmentCompositionLines.add(el22);
                        ++numere;
                        valuesNb = 0;
                    }
                    ++i;
                }
            }
            if (valuesNb > 0) {
                EL22 el22 = new EL22();
                el22 = this.InstanciateEL22();
                EL22.GRCLEEL cleEL22 = el22.get_GRCLEEL_Groupe_Value();
                cleEL22.set_NUMERA_Value(this.getNuligToUse());
                cleEL22.set_NUMERB_Value(200);
                cleEL22.set_NUMERC_Value(this.getNumberCorubDigit());
                cleEL22.set_NUMERD_Value(330);
                cleEL22.set_NUMERE_Value(0);
                cleEL22.set_NUMERE_Value(this.getNumer());
                el22.set_COCA_Value("10");
                el22.set_NUENR_Value("LV");
                EL22.GRPR22.GRENREG.GRCARTE6 grCarte6 = el22.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRCARTE6_Groupe_Value();
                grCarte6.set_GRSIGNI_Value(this.nbVal + valuesNb);
                this.segmentCompositionLines.add(el22);
            }
        }
        if (this.isWritableDataCall(linesForDataElt, true)) {
            this.segmentCompositionLines.add(linesForDataElt);
        }
    }

    public void caseDataElementDescription(DataElementDescription kDataElementDescription) {
        EL13 linesForDataElt = this.InstanciateEL13();
        linesForDataElt = this.prepLineDataEltNODefined(linesForDataElt, kDataElementDescription);
        linesForDataElt.get_GRPR13_Groupe_Value().get_GRI13_Groupe_Value().get_GRNULI8_Groupe_Value().set_NULIG_Value(this.getNumberCorubDigit());
        if (this.getFabloc().equals("M") || this.getBasecodeToGenerate().getBlockType() == PacBlockBaseTypeValues._TD_LITERAL) {
            linesForDataElt = this.FormatEL13FromXB20(linesForDataElt, this.InstanciateXB20(linesForDataElt));
        } else if (this.getFabloc().equals("S")) {
            linesForDataElt = this.FormatEL13FromXB20(linesForDataElt, this.InstanciateXB20(linesForDataElt));
            this.prepLineForSocrateData(linesForDataElt);
        }
        if (this.isWritableDataCall(linesForDataElt, true)) {
            this.segmentCompositionLines.add(linesForDataElt);
        }
    }

    public void caseDataUnion(DataUnion kDataUnion) {
        this.doSwitch((EObject)kDataUnion.getDataDescription());
    }

    public void caseDataUnionDescription(DataUnionDescription kDataUnionDescription) {
        Iterator dataComponents = kDataUnionDescription.getRedefines().iterator();
        this._currentDataUnionDescription = kDataUnionDescription;
        this.dataForRedefines = false;
        while (dataComponents.hasNext()) {
            DataComponent aDataComponent = (DataComponent)dataComponents.next();
            this.doSwitch((EObject)aDataComponent);
            this.dataForRedefines = true;
        }
        this._currentDataUnionDescription = null;
    }

    public void caseFiller(Filler kDataFiller) {
        if (this.getFabloc().equals("C") || this.getFabloc().equals("M") || this.getFabloc().equals("S") || this.getBasecodeToGenerate().getBlockType() == PacBlockBaseTypeValues._TD_LITERAL) {
            EL13 linesForDataElt = this.InstanciateEL13();
            linesForDataElt = this.prepLineFillerDataElt(linesForDataElt, kDataFiller);
            linesForDataElt.get_GRPR13_Groupe_Value().get_GRI13_Groupe_Value().get_GRNULI8_Groupe_Value().set_NULIG_Value(this.getNumberCorubDigit());
            if (this.getFabloc().equals("M") || this.getBasecodeToGenerate().getBlockType() == PacBlockBaseTypeValues._TD_LITERAL) {
                linesForDataElt = this.FormatEL13FromXB20(linesForDataElt, this.InstanciateXB20(linesForDataElt));
            } else if (this.getFabloc().equals("S")) {
                linesForDataElt = this.FormatEL13FromXB20(linesForDataElt, this.InstanciateXB20(linesForDataElt));
                this.prepLineForSocrateData(linesForDataElt);
            }
            if (kDataFiller.eContainer() instanceof DataAggregateDescription) {
                DataCall dc;
                DataAggregateDescription dad = (DataAggregateDescription)kDataFiller.eContainer();
                if (dad.eContainer() instanceof DataAggregate) {
                    this.currentDataCall = null;
                }
                if (dad.eContainer() instanceof DataCall && (dc = (DataCall)dad.eContainer()).getMaximumCardinality() == 0) {
                    this.currentDataCall = null;
                }
            }
            if (this.isWritableDataCall(linesForDataElt, true)) {
                this.segmentCompositionLines.add(linesForDataElt);
            }
        } else {
            ++this.numberOfCorub;
        }
    }

    public void casePacDataCall(PacDataCall pPacDataCall) {
        Iterator moreLines = pPacDataCall.getMoreLines().iterator();
        if (moreLines != null) {
            while (moreLines.hasNext()) {
                try {
                    this.doSwitch((EObject)moreLines.next());
                }
                catch (Exception exception) {}
            }
        }
    }

    public void casePacDataElement(PacDataElement pPacDataElement) {
    }

    private EL13 InstanciateEL13() {
        EL13 aEL13 = new EL13();
        EL13.GRCLEEL cleEL13 = aEL13.get_GRCLEEL_Groupe_Value();
        cleEL13.set_NUBIB_Value(1);
        cleEL13.set_COBLOC_Value(this.baseCodeToGenerate.getName());
        cleEL13.set_NUMERA_Value(700);
        cleEL13.set_NUMERB_Value(0);
        cleEL13.set_NUMERC_Value(this.getNuligToUse());
        cleEL13.set_NUMERD_Value(700);
        cleEL13.set_NUMERE_Value(0);
        cleEL13.set_NUMERF_Value(0);
        aEL13.set_COCA_Value("3 ");
        aEL13.set_NUENR_Value("20");
        ++this.numberOfCorub;
        String nulig = this.getNumberCorubDigit();
        cleEL13.set_NUMERF_Value(nulig);
        if (this.getFabloc().equals("C")) {
            aEL13.set_NUENR_Value("21");
            cleEL13.set_NUMERA_Value(750);
            if (this.baseCodeToGenerate.getBlockType().getValue() != 9) {
                cleEL13.set_NUMERA_Value(650);
            }
            if (this.baseCodeToGenerate.getBlockType().getValue() == 18) {
                cleEL13.set_NUMERB_Value(100);
            }
        }
        aEL13.set_XOPEUR_Value("1");
        aEL13.set_GRTYBLOC_Value(PacTransformationBlockBaseType.transformBlockBaseType((PacBlockBaseTypeValues)this.getBasecodeToGenerate().getBlockType()));
        aEL13.set_FABLOC_Value(this.getFabloc());
        aEL13.get_GRPR13_Groupe_Value().get_GRI13_Groupe_Value().get_GRNOMSEG_Groupe_Value().get_GRFIENR_Groupe_Value().set_COFIC_Value(this.segmentCodeToUse.substring(0, 2));
        aEL13.get_GRPR13_Groupe_Value().get_GRI13_Groupe_Value().get_GRNOMSEG_Groupe_Value().get_GRFIENR_Groupe_Value().set_NUENR_Value(this.segmentCodeToUse.substring(2));
        return aEL13;
    }

    private EL22 InstanciateEL22() {
        EL22 aEL22 = null;
        aEL22 = new EL22();
        EL22.GRCLEEL cleEL22 = aEL22.get_GRCLEEL_Groupe_Value();
        cleEL22.set_NUBIB_Value(1);
        cleEL22.set_COBLOC_Value(this.baseCodeToGenerate.getName());
        aEL22.set_XOPEUR_Value("1");
        aEL22.get_GRTYBLOC_Groupe_Value().set_TYBLO1_Value(this.getBasecodeToGenerate().getBlockType().toString().substring(1, 2));
        aEL22.get_GRTYBLOC_Groupe_Value().set_TYBLO2_Value(this.getBasecodeToGenerate().getBlockType().toString().substring(2));
        aEL22.set_FABLOC_Value(this.getFabloc());
        aEL22.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRI22_Groupe_Value().set_NULIG_Value(100);
        if (this.getFabloc().equals("M")) {
            aEL22.set_COCA_Value("E");
            aEL22.set_NUENR_Value("RB");
            cleEL22.set_NUMERA_Value(100);
            cleEL22.set_NUMERB_Value(this.getNuligToUse());
            cleEL22.set_NUMERC_Value(200);
            cleEL22.set_NUMERD_Value(this.getNumberCorubDigit());
            cleEL22.set_NUMERE_Value(200);
            cleEL22.set_NUMERF_Value(300);
        } else {
            aEL22.set_COCA_Value("10");
            cleEL22.set_NUMERA_Value(this.getNuligToUse());
            cleEL22.set_NUMERB_Value(200);
            cleEL22.set_NUMERC_Value(this.getNumberCorubDigit());
            cleEL22.set_NUMERD_Value(200);
            cleEL22.set_NUMERE_Value(0);
            cleEL22.set_NUMERF_Value(this.getNumer());
        }
        return aEL22;
    }

    private EL2L InstanciateEL2L() {
        EL2L aEL2L = new EL2L();
        EL2L.GRCLEEL cleEL2L = aEL2L.get_GRCLEEL_Groupe_Value();
        cleEL2L.set_NUBIB_Value(1);
        cleEL2L.set_COBLOC_Value(this.baseCodeToGenerate.getName());
        cleEL2L.set_NUMERA_Value(700);
        cleEL2L.set_NUMERB_Value(0);
        cleEL2L.set_NUMERC_Value(this.getNuligToUse());
        cleEL2L.set_NUMERD_Value(140);
        cleEL2L.set_NUMERE_Value(0);
        cleEL2L.set_NUMERF_Value(0);
        aEL2L.set_COCA_Value("L2");
        aEL2L.set_NUENR_Value("13");
        aEL2L.set_XOPEUR_Value("0");
        aEL2L.get_GRTYBLOC_Groupe_Value().set_TYBLO1_Value(this.getBasecodeToGenerate().getBlockType().toString().substring(1, 2));
        aEL2L.get_GRTYBLOC_Groupe_Value().set_TYBLO2_Value(this.getBasecodeToGenerate().getBlockType().toString().substring(2));
        aEL2L.set_FABLOC_Value(this.getFabloc());
        if (this.numberOfCorub != 0) {
            aEL2L.set_LOENR_Value(this.maxLth);
        }
        return aEL2L;
    }

    private XB20 InstanciateXB20(EL13 el13) {
        if (el13.get_GRPR13_Groupe_Value().get_USAGEI_Value().trim().length() == 0) {
            el13.get_GRPR13_Groupe_Value().set_USAGEI_Value("D");
        }
        if (el13.get_GRPR13_Groupe_Value().get_PICTUI_Value().trim().length() == 0) {
            el13.get_GRPR13_Groupe_Value().set_PICTUI_Value("X");
        }
        XB20 aXB20 = new XB20();
        aXB20.set_GRPR13_Value(el13.get_GRPR13_Groupe_Value().toString());
        aXB20.get_GRXB36_Groupe_Value().set_NIVRU_Value(el13.get_NIVRU_Value());
        aXB20.get_GRXB36_Groupe_Value().set_GRNUMERX_Value(this.getNumberCorubDigit());
        this.initXB20FromLalDescription(aXB20);
        return aXB20;
    }

    private EL13 FormatEL13FromXB20(EL13 el13, XB20 aXB20) {
        EL13 newEL13 = new EL13();
        EL13 el13Key = new EL13();
        String s = el13.get_GRCLEEL_Groupe_Value().toString() + el13.get_NUENR_Value() + el13.get_COCA_Value() + String.valueOf((Object)el13.get_GRTYBLOC_Groupe_Value()) + el13.get_FABLOC_Value() + el13.get_XOPEUR_Value() + aXB20.getCompleteContentForSegment();
        newEL13.setIntContentFor(1, s.length(), s, s.length());
        el13Key.setIntContentFor(1, s.length(), s, s.length());
        EL13.GRCLEEL cleEL13 = newEL13.get_GRCLEEL_Groupe_Value();
        if (this.getBasecodeToGenerate().getBlockType() == PacBlockBaseTypeValues._TD_LITERAL) {
            EL13.GRCLEEL cleEL13K = el13Key.get_GRCLEEL_Groupe_Value();
            cleEL13K.set_NUMERA_Value(this.nuligToUse);
            cleEL13K.set_NUMERD_Value(0);
            cleEL13K.set_NUMERE_Value(0);
            cleEL13K.set_NUMERF_Value(0);
            el13Key.set_COCA_Value("");
            if (el13Key.get_GRPR13_Groupe_Value().get_INDIC_Value().equals("U")) {
                cleEL13K.set_NUMERB_Value(700);
                cleEL13K.set_NUMERC_Value(0);
                el13Key.set_NUENR_Value("VA");
                if (this.isWritableDataCall(newEL13, false)) {
                    this.segmentCompositionLines.add(el13Key);
                }
            }
            cleEL13.set_NUMERA_Value(this.nuligToUse);
            cleEL13.set_NUMERB_Value(400);
            cleEL13.set_NUMERC_Value(this.getNumberCorubDigit());
            cleEL13.set_NUMERD_Value(0);
            cleEL13.set_NUMERE_Value(0);
            cleEL13.set_NUMERF_Value(0);
            newEL13.set_COCA_Value("");
        } else if (this.getFabloc().equals("S")) {
            cleEL13.set_NUMERA_Value(this.nuligToUse);
            cleEL13.set_NUMERB_Value(200);
            cleEL13.set_NUMERC_Value(this.getNumberCorubDigit());
            cleEL13.set_NUMERD_Value(200);
            cleEL13.set_NUMERE_Value(0);
            cleEL13.set_NUMERF_Value(0);
            newEL13.set_COCA_Value("10");
        } else {
            cleEL13.set_NUMERA_Value(100);
            cleEL13.set_NUMERB_Value(this.nuligToUse);
            cleEL13.set_NUMERC_Value(200);
            cleEL13.set_NUMERD_Value(this.getNumberCorubDigit());
            cleEL13.set_NUMERE_Value(100);
            cleEL13.set_NUMERF_Value(0);
        }
        newEL13.set_NUENR_Value("RB");
        return newEL13;
    }

    private EL13 initFromLalDescription(EL13 outputLine) {
        if (this.numberOfCorub != 0) {
            PacbaseLalDescription lal = this.lalList.get(this.numberOfCorub - 1);
            int nivru = lal.getLevel();
            if (this.getFabloc().equals("C")) {
                nivru -= 8;
            }
            outputLine.set_NIVRU_Value(nivru);
            lal.calculateNumbers();
            outputLine.set_ADRUBI_Value(lal.getInternalAddress());
            outputLine.get_GRPR13_Groupe_Value().get_GRI13_Groupe_Value().set_CORUB_Value(lal.getName());
            outputLine.get_GRPR13_Groupe_Value().set_REPET_Value(lal.getOccurs());
            outputLine.get_GRPR13_Groupe_Value().get_GRNRURE_Groupe_Value().set_NRUR9_Value(lal.getNbDataElementsInGroup());
            String[] labels = SegmentCompositionPacbaseAndKernelVisitor.getLabelsFromDataLabel(lal.getLabel());
            outputLine.get_GRPR13_Groupe_Value().set_GRLIRUB_Value(labels[0]);
            outputLine.get_GRPR13_Groupe_Value().set_LIRUBC_Value(labels[1]);
            outputLine.get_GRPR13_Groupe_Value().set_PICTUI_Value(SegmentCompositionPacbaseAndKernelVisitor.GetCobolPicture(lal.getInternalFormat(), lal.getInternalLength()));
            outputLine.get_GRPR13_Groupe_Value().get_GR3LORUS_Groupe_Value().set_LORUBS_Value(lal.getOutputLength());
            outputLine.get_GRPR13_Groupe_Value().set_USAGEI_Value(lal.getUsage());
            outputLine.get_GRPR13_Groupe_Value().set_LORUBI_Value(lal.getInternalLength());
            outputLine.get_GRPR13_Groupe_Value().set_LORUBE_Value(lal.getInputLength());
            outputLine.set_TYRUB_Value(lal.getTyrub());
            if (lal.getRedefines() && this._currentDataUnionDescription != null && this._currentDataUnionDescription.getRedefines().get(0) instanceof DataCall) {
                DataCall dc = (DataCall)this._currentDataUnionDescription.getRedefines().get(0);
                String name = "";
                if (dc.getDataDefinition() != null) {
                    name = dc.getDataDefinition().getName();
                } else if (dc.getDataDescription() != null) {
                    name = dc.getDataDescription().getName();
                }
                outputLine.get_GRPR13_Groupe_Value().get_GRCOFIM3_Groupe_Value().set_CORUM_Value(name);
            }
        }
        return outputLine;
    }

    private XB20 initXB20FromLalDescription(XB20 outputLine) {
        if (this.numberOfCorub != 0) {
            PacbaseLalDescription lal = this.lalList.get(this.numberOfCorub - 1);
            XB20.GRXB36 grxb36 = outputLine.get_GRXB36_Groupe_Value();
            grxb36.set_PICTUE_Value(lal.getInputFormat());
            grxb36.get_GRPICTU_Groupe_Value().set_GRPICTUA_Value(lal.getOutputFormat());
            grxb36.set_NIVAN_Value(0);
            grxb36.set_APPLI_Value(this.getLibName());
            grxb36.get_GRSESSI_Groupe_Value().set_NUSES_Value(9999);
            grxb36.get_GRSESSI_Groupe_Value().set_NSVER_Value(0);
            grxb36.get_GRSESSI_Groupe_Value().set_ETSES_Value("Z");
            grxb36.set_CORUG_Value("");
            this.setMotherData(null);
            if (lal.getEntity() instanceof DataElementImpl) {
                Iterator extensionsElt = ((DataElementImpl)lal.getEntity()).getDataDescription().getExtensions().iterator();
                PacDataElementDescriptionImpl pdedi = null;
                while (extensionsElt.hasNext()) {
                    try {
                        pdedi = (PacDataElementDescriptionImpl)extensionsElt.next();
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    if (pdedi.getParent() == null) continue;
                    this.setMotherData(pdedi.getParent());
                    grxb36.set_CORUG_Value(pdedi.getParent().getName());
                }
            }
            grxb36.set_NIVRUR_Value(lal.getLevel());
            grxb36.set_TYRUB_Value(lal.getTyrub());
            grxb36.set_TREDEF_Value("0");
            if (lal.getRedefines()) {
                grxb36.set_TREDEF_Value("1");
            }
        }
        return outputLine;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isWritableDataCall(EL13 detailForDataCall, boolean forDataElement) {
        DataAggregateDescription dad;
        if (this.getFabloc().equals("M")) {
            if (this.isRedefines || this.isGroupOccurs) {
                return false;
            }
            if (detailForDataCall.get_GRPR13_Groupe_Value().get_GRCOFIM3_Groupe_Value().get_COFIM_Value().equals(this.redefines)) {
                if (forDataElement) return false;
                this.isRedefines = true;
                if ("**".equals(detailForDataCall.get_GRPR13_Groupe_Value().get_GRNRURE_Groupe_Value().get_NRUR9_Value())) return false;
                this.nbDERedefines = detailForDataCall.get_GRPR13_Groupe_Value().get_GRNRURE_Groupe_Value().get_NRUR9_Int_Value();
                return false;
            }
            if (detailForDataCall.get_GRPR13_Groupe_Value().get_GRNRURE_Groupe_Value().get_NRUR9_Value().equals("**")) {
                if (detailForDataCall.get_GRPR13_Groupe_Value().get_REPET_Int_Value() <= 0) return false;
                this.isGroupOccurs = true;
                PacbaseLalDescription lal = this.lalList.get(this.numberOfCorub - 1);
                this.memoLevelGroupOccurs = lal.getLevel();
                detailForDataCall.get_GRPR13_Groupe_Value().set_GRLIRUB_Value("");
                detailForDataCall.get_GRPR13_Groupe_Value().set_LIRUBC_Value("");
                detailForDataCall.get_GRPR13_Groupe_Value().set_PICTUI_Value(" ");
                detailForDataCall.get_GRPR13_Groupe_Value().set_USAGEI_Value(" ");
                return true;
            }
            if (detailForDataCall.get_GRPR13_Groupe_Value().get_GRNRURE_Groupe_Value().get_NRUR9_Int_Value() > 0 && detailForDataCall.get_GRPR13_Groupe_Value().get_REPET_Int_Value() == 0) {
                return false;
            }
        }
        if (!this.getFabloc().equals("C") && !this.getFabloc().equals("M") && this.currentDataCall.getMaximumCardinality() > 0) {
            return false;
        }
        if (this.currentDataCall != null && this.currentDataCall.eContainer() instanceof DataAggregateDescription && (dad = (DataAggregateDescription)this.currentDataCall.eContainer()).eContainer() instanceof DataCall && ((DataCall)dad.eContainer()).getMaximumCardinality() > 0) {
            return false;
        }
        if (this.getBasecodeToGenerate().getBlockType().getValue() == 1 && detailForDataCall.get_GRPR13_Groupe_Value().get_INDIC_Value().trim().length() == 0) {
            return false;
        }
        if (this.getBasecodeToGenerate().getBlockType().getValue() != 18 && this.getBasecodeToGenerate().getBlockType().getValue() != 16 || this.getSubSchema() == null || detailForDataCall.get_GRPR13_Groupe_Value().get_INDIC_Value().equals("U")) return true;
        int subSchema = 0;
        if (!detailForDataCall.get_GRPR13_Groupe_Value().get_GRCONT_Groupe_Value().get_GRCONTR_Groupe_Value().get_SCONT_Value().equals("S")) return false;
        try {
            subSchema = Integer.parseInt(this.getSubSchema());
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        if (subSchema <= 0) return false;
        String vcont = detailForDataCall.get_GRPR13_Groupe_Value().get_GRCONT_Groupe_Value().get_VCONT_Value();
        if (vcont.substring(subSchema - 1, 1).equals("O")) return true;
        return false;
    }

    private PacBlockBaseImpl getBasecodeToGenerate() {
        return this.baseCodeToGenerate;
    }

    public static String GetCobolPicture(String format, int length) {
        String realFormat = format;
        PacPictureParser pictureparser = new PacPictureParser(format);
        if (pictureparser.isDate()) {
            return "X(" + length + ")";
        }
        return realFormat;
    }

    private String getFabloc() {
        return this.fabloc;
    }

    private String getLibName() {
        return this.libName;
    }

    private DataElement getMotherData() {
        return this.dataElt;
    }

    private static String[] getLabelsFromDataLabel(String label) {
        String[] labels = new String[]{"", ""};
        if (label.trim() != null && label.trim().length() > 0) {
            int end = label.length() < 19 ? label.length() : 18;
            labels[0] = label.substring(0, end);
            if (label.length() > 18) {
                labels[1] = label.substring(18, label.length());
            }
        }
        return labels;
    }

    private String getNameOfProject() {
        return this.nameOfProject;
    }

    private int getNuligToUse() {
        return this.nuligToUse;
    }

    private String getNumberCorubDigit() {
        String nbCorubValue = String.valueOf(this.numberOfCorub);
        String str = "000" + nbCorubValue;
        return str.substring(str.length() - 3);
    }

    private int getNumer() {
        return this.numer;
    }

    private PacbaseLinksEntitiesService getPacLinksEntitiesService() {
        return this.ples;
    }

    public String getSubSchema() {
        return this.subSchema;
    }

    private List<String> getPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        if (this.getNameOfProject() != null) {
            paths.addAll(PTNature.getPaths((String)this.getNameOfProject()));
        }
        return paths;
    }

    private char getVariant() {
        return this.variant;
    }

    public List<PacbaseSegment> getSegmentCompositionLines() {
        return this.segmentCompositionLines;
    }

    void setBasecodeToGenerate(PacBlockBaseImpl baseCode) {
        this.baseCodeToGenerate = baseCode;
    }

    void setFabloc(String fabloc) {
        this.fabloc = fabloc;
    }

    void setLibName(String libName) {
        this.libName = libName;
    }

    private void setMotherData(DataElement dataElt) {
        this.dataElt = dataElt;
    }

    void setNameOfProject(String projectName) {
        this.nameOfProject = projectName;
    }

    public void setNuligToUse(int nuligToUse) {
        this.nuligToUse = nuligToUse;
    }

    public void setNumer(int numer) {
        this.numer = numer;
    }

    public void setSubSchema(String subSchema) {
        this.subSchema = subSchema;
    }

    void setSegmentCode(String segmentCode) {
        this.segmentCodeToUse = segmentCode;
    }

    public void setVariant(char variant) {
        this.variant = variant;
    }

    private EL13 prepLineForSocrateData(EL13 lineForData) {
        EL13.GRCLEEL cleEL13 = lineForData.get_GRCLEEL_Groupe_Value();
        EL13.GRPR13 grPr13 = lineForData.get_GRPR13_Groupe_Value();
        cleEL13.set_NUMERA_Value(this.getNuligToUse());
        cleEL13.set_NUMERB_Value(200);
        cleEL13.set_NUMERC_Value(this.getNumberCorubDigit());
        cleEL13.set_NUMERD_Value(200);
        cleEL13.set_NUMERF_Value(this.getNumer());
        lineForData.set_NUENR_Value("RB");
        lineForData.set_COCA_Value("10");
        if (grPr13.get_GRNRURE_Groupe_Value().get_NRUR9_Int_Value() != 0) {
            lineForData.set_NUENR_Value("BL");
        }
        if (grPr13.get_INDIC_Value().equals("R")) {
            if (grPr13.get_GRCOFIM3_Groupe_Value().get_CORUM_Value().trim().length() > 0) {
                lineForData.set_NUENR_Value("RA");
            } else if (grPr13.get_GRCOFIM3_Groupe_Value().get_COFIM_Value().trim().length() > 0) {
                lineForData.set_NUENR_Value("");
            }
        } else if (grPr13.get_INDIC_Value().equals("I")) {
            lineForData.set_NUENR_Value("IN");
        } else if (grPr13.get_INDIC_Value().equals("A")) {
            lineForData.set_NUENR_Value("AN");
        } else if (grPr13.get_INDIC_Value().equals("L")) {
            if (grPr13.get_GRNRURE_Groupe_Value().get_NRUR9_Int_Value() == 0) {
                lineForData.set_NUENR_Value("RL");
            } else {
                lineForData.set_NUENR_Value("RM");
            }
        } else if (grPr13.get_GRNRURE_Groupe_Value().get_NRUR9_Int_Value() == 0 && grPr13.get_REPET_Int_Value() != 0) {
            lineForData.set_NUENR_Value("TX");
        }
        return lineForData;
    }

    private EL13 prepLineDataElt(EL13 lineForDataElt, DataElement kDataElement) {
        EL13 detailForDataElt = this.initFromLalDescription(lineForDataElt);
        detailForDataElt.get_GRPR13_Groupe_Value().set_TYAPP_Value("C");
        if (this.currentDataCall != null) {
            EList extensions = this.currentDataCall.getExtensions();
            this.updateDataCall((List)extensions, detailForDataElt, kDataElement.getName());
        }
        return detailForDataElt;
    }

    private EL13 prepLineDataEltNODefined(EL13 lineForDataElt, DataElementDescription DEDescription) {
        EL13 detailForDataElt = this.initFromLalDescription(lineForDataElt);
        detailForDataElt.get_GRPR13_Groupe_Value().get_GRI13_Groupe_Value().set_CORUB_Value(DEDescription.getName());
        detailForDataElt.get_GRPR13_Groupe_Value().get_GRNRURE_Groupe_Value().set_NRUR9_Value("00");
        detailForDataElt.get_GRPR13_Groupe_Value().set_TYAPP_Value("C");
        if (this.currentDataCall != null) {
            EList extensions = this.currentDataCall.getExtensions();
            this.updateDataCall((List)extensions, detailForDataElt, DEDescription.getName());
        }
        return detailForDataElt;
    }

    private EL13 prepLineFillerDataElt(EL13 lineForDataElt, Filler kDataFiller) {
        EL13 detailForDataElt = this.initFromLalDescription(lineForDataElt);
        detailForDataElt.get_GRPR13_Groupe_Value().get_GRI13_Groupe_Value().set_CORUB_Value("FILLER");
        detailForDataElt.get_GRPR13_Groupe_Value().get_GRNRURE_Groupe_Value().set_NRUR9_Value("00");
        detailForDataElt.get_GRPR13_Groupe_Value().set_TYAPP_Value("F");
        PacFiller pacFiller = null;
        EList extensions = kDataFiller.getExtensions();
        int i = 0;
        while (i < extensions.size()) {
            Object object = extensions.get(i);
            if (object instanceof PacFiller) {
                pacFiller = (PacFiller)object;
            }
            ++i;
        }
        this.updateValues((List)pacFiller.getMoreLines(), detailForDataElt, "FILLER");
        return detailForDataElt;
    }

    private List getDLines(Iterator extensionsElt) {
        while (extensionsElt.hasNext()) {
            Object obj = extensionsElt.next();
            if (!(obj instanceof PacDataElementImpl)) continue;
            return ((PacDataElementImpl)obj).getDLines();
        }
        return null;
    }

    private String searchForColumnLabel(List dLines) {
        String label = "";
        if (dLines != null) {
            int i = 0;
            while (i < dLines.size()) {
                if (((PacDLineImpl)dLines.get(i)).getLineType().equals("C")) {
                    label = ((PacDLineImpl)dLines.get(i)).getDescription();
                }
                ++i;
            }
        }
        return label;
    }

    private void updateDataCall(List extensions, EL13 detailForDataElt, String kDataElementName) {
        PacDataCall pacDataCall = null;
        int i = 0;
        while (i < extensions.size()) {
            Object object = extensions.get(i);
            if (object instanceof PacDataCall) {
                pacDataCall = (PacDataCall)object;
                break;
            }
            ++i;
        }
        if (pacDataCall != null) {
            if (pacDataCall.getSortKey() != null) {
                detailForDataElt.get_GRPR13_Groupe_Value().set_INDIC_Value(pacDataCall.getSortKey());
                if (this.getFabloc().equals("H") && (pacDataCall.getSortKey().equals("U") || pacDataCall.getSortKey().equals("M"))) {
                    detailForDataElt.get_GRCLEEL_Groupe_Value().set_NUMERF_Value(0);
                }
            }
            if (pacDataCall.getClassControl() != null && pacDataCall.getClassControl().getValue() > 0) {
                detailForDataElt.get_GRPR13_Groupe_Value().get_GRCONT_Groupe_Value().get_GRCONTR_Groupe_Value().get_GRCONTC_Groupe_Value().set_CLASC_Value(pacDataCall.getClassControl().getLiteral().substring(1));
            }
            if (pacDataCall.getPresenceCheck() != null) {
                String ctlCreat = pacDataCall.getPresenceCheck().getInCreation().toString().substring(1);
                String ctlModi = pacDataCall.getPresenceCheck().getInModification().toString().substring(1);
                String ctlDele = pacDataCall.getPresenceCheck().getInDeletion().toString().substring(1);
                String ctlTyp4 = pacDataCall.getPresenceCheck().getInType4().toString().substring(1);
                String ctlTyp5 = pacDataCall.getPresenceCheck().getInType5().toString().substring(1);
                String ctlTyp6 = pacDataCall.getPresenceCheck().getInType6().toString().substring(1);
                if (String.valueOf(ctlCreat).equals("F")) {
                    ctlCreat = " ";
                }
                if (String.valueOf(ctlModi).equals("F")) {
                    ctlModi = " ";
                }
                if (String.valueOf(ctlDele).equals("F")) {
                    ctlDele = " ";
                }
                if (String.valueOf(ctlTyp4).equals("F")) {
                    ctlTyp4 = " ";
                }
                if (String.valueOf(ctlTyp5).equals("F")) {
                    ctlTyp5 = " ";
                }
                if (String.valueOf(ctlTyp6).equals("F")) {
                    ctlTyp6 = " ";
                }
                detailForDataElt.get_GRPR13_Groupe_Value().get_GRCONT_Groupe_Value().get_GRSTRCO_Groupe_Value().set_STRCO1_Value(ctlCreat);
                detailForDataElt.get_GRPR13_Groupe_Value().get_GRCONT_Groupe_Value().get_GRSTRCO_Groupe_Value().set_STRCO2_Value(ctlModi);
                detailForDataElt.get_GRPR13_Groupe_Value().get_GRCONT_Groupe_Value().get_GRSTRCO_Groupe_Value().set_STRCO3_Value(ctlDele);
                detailForDataElt.get_GRPR13_Groupe_Value().get_GRCONT_Groupe_Value().get_GRSTRCO_Groupe_Value().set_STRCO4_Value(ctlTyp4);
                detailForDataElt.get_GRPR13_Groupe_Value().get_GRCONT_Groupe_Value().get_GRSTRCO_Groupe_Value().set_STRCO5_Value(ctlTyp5);
                detailForDataElt.get_GRPR13_Groupe_Value().get_GRCONT_Groupe_Value().get_GRSTRCO_Groupe_Value().set_STRCO6_Value(ctlTyp6);
            }
            this.updateValues((List)pacDataCall.getMoreLines(), detailForDataElt, kDataElementName);
        }
    }

    private void updateValues(List extensMoreLine, EL13 detailForDataElt, String name) {
        PacDataCallMore pacDataCallMor = null;
        if (extensMoreLine != null) {
            Iterator it;
            if (extensMoreLine.isEmpty() && this._currentDataUnionDescription != null && this.dataForRedefines) {
                String uptTarget = this.redefines;
                this.dataForRedefines = false;
                detailForDataElt.get_GRPR13_Groupe_Value().get_GRCOFIM3_Groupe_Value().set_COFIM_Value(uptTarget.substring(0, 2));
            }
            if ((it = extensMoreLine.iterator()).hasNext()) {
                pacDataCallMor = (PacDataCallMore)it.next();
                detailForDataElt.get_GRPR13_Groupe_Value().get_GRCONT_Groupe_Value().get_GRCONTR_Groupe_Value().set_SCONT_Value(pacDataCallMor.getControlType().toString());
                detailForDataElt.get_GRPR13_Groupe_Value().get_GRCONT_Groupe_Value().set_VCONT_Value(pacDataCallMor.getControlValue().toString());
                if (pacDataCallMor.getUpdateTarget().trim().length() > 0) {
                    String uptTarget = pacDataCallMor.getUpdateTarget().trim();
                    if (this._currentDataUnionDescription != null && !this.dataForRedefines && uptTarget.trim().length() == 0) {
                        uptTarget = this.redefines;
                    }
                    this.dataForRedefines = false;
                    detailForDataElt.get_GRPR13_Groupe_Value().get_GRCOFIM3_Groupe_Value().set_COFIM_Value(uptTarget.substring(0, 2));
                    if (pacDataCallMor.getUpdateTarget().trim().length() > 3) {
                        detailForDataElt.get_GRPR13_Groupe_Value().get_GRCOFIM3_Groupe_Value().set_NUENM_Value(uptTarget.substring(2, 4));
                        if (pacDataCallMor.getUpdateTarget().trim().length() > 4) {
                            detailForDataElt.get_GRPR13_Groupe_Value().get_GRCOFIM3_Groupe_Value().set_CORUM_Value(uptTarget.substring(4, uptTarget.length()));
                        } else if (name != null) {
                            detailForDataElt.get_GRPR13_Groupe_Value().get_GRCOFIM3_Groupe_Value().set_CORUM_Value(name);
                        }
                    }
                }
            }
        }
    }
}

