/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.generate.dataBaseBlock.generate;

import com.ibm.pdp.dataBaseBlock.model.PacbaseSegment;
import com.ibm.pdp.mdl.pacbase.PacBlockBase;
import com.ibm.pdp.mdl.pacbase.PacDCLine;
import com.ibm.pdp.mdl.pacbase.PacDHLine;
import com.ibm.pdp.mdl.pacbase.PacDRLine;
import com.ibm.pdp.mdl.pacbase.PacGLine;
import com.ibm.pdp.pacbase.generate.dataBaseBlock.generate.EL00PacbaseAndKernelVisitor;
import com.ibm.pdp.pacbase.generate.util.PacbaseLinksEntitiesService;
import com.ibm.pdp.pacbase.generate.util.PacbaseModelService;
import com.ibm.pdp.pacbase.util.EBCDICCompare;
import com.ibm.pdp.util.Util;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

public class PacToW1ModelDataBaseBlock {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private PacBlockBase blockBase;
    private String project;
    private File w1ResultFile;
    private EL00PacbaseAndKernelVisitor w1pkvisitor;
    private PacbaseLinksEntitiesService ples;
    private String patternName;
    final Comparator<PacbaseSegment> ebcdicCmp = new Comparator<PacbaseSegment>(){

        @Override
        public int compare(PacbaseSegment object1, PacbaseSegment object2) {
            int i = EBCDICCompare.stringCompare((String)object1.toString().substring(0, 27), (String)object2.toString().substring(0, 27));
            return i;
        }
    };

    public PacToW1ModelDataBaseBlock(String proj, PacBlockBase bb, String patternName) {
        this.project = proj;
        this.blockBase = bb;
        this.patternName = patternName;
        this.transformToW1Model();
    }

    public PacbaseLinksEntitiesService getPacLinksEntitiesService() {
        if (this.ples == null) {
            this.ples = new PacbaseLinksEntitiesService(this.patternName);
        }
        return this.ples;
    }

    protected File getW1ResultFile() {
        return this.w1ResultFile;
    }

    protected void setW1ResultFile(File resultFile) {
        this.w1ResultFile = resultFile;
    }

    private void handleException(Exception exc) {
        System.out.println("*** ERROR ***");
        exc.printStackTrace();
        System.out.println("*** ***** ***");
    }

    private void scanPacbaseModel() {
        this.w1pkvisitor = new EL00PacbaseAndKernelVisitor(this.getPacLinksEntitiesService());
        this.w1pkvisitor.setNameOfProject(this.project);
        this.w1pkvisitor.doSwitch((EObject)this.blockBase.getGenerationParameter());
        this.w1pkvisitor.doSwitch((EObject)this.blockBase);
        for (Object obj : this.blockBase.getGGLines()) {
            if (!(obj instanceof PacGLine)) continue;
            this.w1pkvisitor.doSwitch((EObject)((PacGLine)obj));
        }
        for (PacDHLine pdhl : this.blockBase.getDHLines()) {
            this.w1pkvisitor.doSwitch((EObject)pdhl);
            for (Object obj : pdhl.getGGLines()) {
                if (!(obj instanceof PacGLine)) continue;
                this.w1pkvisitor.doSwitch((EObject)((PacGLine)obj));
            }
        }
        for (PacDCLine pdcl : this.blockBase.getDCLines()) {
            this.w1pkvisitor.doSwitch((EObject)pdcl);
            for (Object obj : pdcl.getGGLines()) {
                if (!(obj instanceof PacGLine)) continue;
                this.w1pkvisitor.setLastGG(false);
                if (pdcl.getGGLines().indexOf(obj) == pdcl.getGGLines().size() - 1) {
                    this.w1pkvisitor.setLastGG(true);
                }
                this.w1pkvisitor.doSwitch((EObject)((PacGLine)obj));
            }
        }
        Iterator drLinesIterator = this.blockBase.getDRLines().iterator();
        while (drLinesIterator.hasNext()) {
            PacDRLine cfr_ignored_0 = (PacDRLine)drLinesIterator.next();
        }
    }

    private void transformToW1Model() {
        try {
            this.scanPacbaseModel();
            this.writeTempFile();
        }
        catch (Exception e) {
            this.handleException(e);
            Util.rethrow((Throwable)e);
        }
    }

    private void writeTempFile() {
        this.w1ResultFile = PacbaseModelService.getInstance().createTmpFileForGeneration("dbd", true);
        try {
            FileWriter fileOutStream1 = new FileWriter(this.w1ResultFile);
            PrintWriter w1OutStream = new PrintWriter(fileOutStream1);
            List<PacbaseSegment> l = this.w1pkvisitor.getDataBlockBaseLines();
            Collections.sort(l, this.ebcdicCmp);
            for (PacbaseSegment lineX : l) {
                String lineS = lineX.getCompleteContentForSegment().trim();
                w1OutStream.write(lineS + System.getProperty("line.separator"));
            }
            w1OutStream.close();
        }
        catch (Exception e) {
            System.out.println("Erreur write DBD");
            e.printStackTrace();
            Util.rethrow((Throwable)e);
        }
    }
}

