/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.generate.dataBaseBlock.generate;

import com.ibm.pdp.dataBaseBlock.model.EL01;
import com.ibm.pdp.dataBaseBlock.model.EL13;
import com.ibm.pdp.dataBaseBlock.model.EL1L;
import com.ibm.pdp.dataBaseBlock.model.EL2L;
import com.ibm.pdp.dataBaseBlock.model.EL3L;
import com.ibm.pdp.dataBaseBlock.model.EL3V;
import com.ibm.pdp.dataBaseBlock.model.PacbaseSegment;
import com.ibm.pdp.mdl.kernel.DataCall;
import com.ibm.pdp.mdl.kernel.KernelPackage;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.impl.DataAggregateImpl;
import com.ibm.pdp.mdl.pacbase.PacBlockBase;
import com.ibm.pdp.mdl.pacbase.PacBlockBaseGenerationElement;
import com.ibm.pdp.mdl.pacbase.PacBlockBaseTypeValues;
import com.ibm.pdp.mdl.pacbase.PacCodasylRecordTypeValues;
import com.ibm.pdp.mdl.pacbase.PacDCLine;
import com.ibm.pdp.mdl.pacbase.PacDHLine;
import com.ibm.pdp.mdl.pacbase.PacDataAggregate;
import com.ibm.pdp.mdl.pacbase.PacGLine;
import com.ibm.pdp.mdl.pacbase.PacGenElemFromGuideInputAid;
import com.ibm.pdp.mdl.pacbase.PacGenElemFromVirtualInputAid;
import com.ibm.pdp.mdl.pacbase.PacInputAidGLine;
import com.ibm.pdp.mdl.pacbase.PacLibrary;
import com.ibm.pdp.mdl.pacbase.PacbasePackage;
import com.ibm.pdp.mdl.pacbase.impl.PacBlockBaseImpl;
import com.ibm.pdp.mdl.pacbase.impl.PacDataCallImpl;
import com.ibm.pdp.mdl.pacbase.lal.util.GenerationContext;
import com.ibm.pdp.mdl.pacbase.lal.util.LengthAndPositionVisitor;
import com.ibm.pdp.mdl.pacbase.lal.util.PacbaseLalDescription;
import com.ibm.pdp.mdl.pacbase.util.PacInputAidCompletedDetailManager;
import com.ibm.pdp.mdl.pacbase.util.PacTransformationCodasylRecordType;
import com.ibm.pdp.pacbase.generate.dataBaseBlock.generate.SegmentCompositionPacbaseAndKernelVisitor;
import com.ibm.pdp.pacbase.generate.dataBaseBlock.internal.SortKeySwitch;
import com.ibm.pdp.pacbase.generate.util.PacbaseLinksEntitiesService;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class EL00PacbaseAndKernelVisitor {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static PacInputAidCompletedDetailManager detailManager = new PacInputAidCompletedDetailManager();
    protected static final PacbasePackage modelPackagePB = PacbasePackage.eINSTANCE;
    protected static final KernelPackage modelPackageKernel = KernelPackage.eINSTANCE;
    protected String keyLength = "CC=";
    protected String procoptOption = "PR=";
    protected String occOption = "OCC=";
    private ArrayList<PacbaseSegment> dataBlockBaseLines = new ArrayList();
    private String nameOfProject;
    private String libName;
    private char variant;
    int nuliDH = -1;
    int nuliDH2 = -1;
    int nuliDHForSocrate = -1;
    int nuliGG = -1;
    int subNuliGG = -1;
    private static final char SINGLE_QUOTE = '\'';
    private String fabloc = null;
    SegmentCompositionPacbaseAndKernelVisitor scvisitor;
    private Hashtable<String, String> wkTable = new Hashtable();
    String overrideObject = "";
    int indice = 0;
    int indiceInBlockLines = 0;
    int indiceDHLine = 0;
    Boolean override = false;
    EL3V overrideGline;
    Boolean isLastGG = false;
    int numer = 0;
    String keySort = "";
    HashMap<String, SegmentDatas> segmentsTree = null;
    EL2L tempDhLine = null;
    Hashtable<String, Integer> nivruTable = new Hashtable();
    private PacbaseLinksEntitiesService ples;
    private static String[] nuoptTable = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};

    public EL00PacbaseAndKernelVisitor(PacbaseLinksEntitiesService ples) {
        this.ples = ples;
    }

    private void casePacBlockBase(PacBlockBase aPacBlockBase) {
        this.getPacLinksEntitiesService().checkValidityType((RadicalEntity)aPacBlockBase);
        this.setParentFabloc(this.getFabloc(aPacBlockBase.getBlockType().toString().substring(1, 3)));
        EL1L dataBaseBlockDefinition = this.prepCommonDataForBlockBase(aPacBlockBase);
        dataBaseBlockDefinition.set_NUENR_Value("AX");
        dataBaseBlockDefinition.set_XOPEUR_Value("1");
        dataBaseBlockDefinition.set_NUPRG_Value(1);
        dataBaseBlockDefinition = this.prepLineForBlockBase(dataBaseBlockDefinition, aPacBlockBase);
        this.dataBlockBaseLines.add(dataBaseBlockDefinition);
        switch (aPacBlockBase.getBlockType().getValue()) {
            case 3: {
                this.writeEnregEL1L(aPacBlockBase, "03");
                break;
            }
            case 4: {
                this.writeEnregEL1L(aPacBlockBase, "03");
                break;
            }
            case 2: {
                this.writeEnregEL1L(aPacBlockBase, "03");
                this.writeEnregEL1L(aPacBlockBase, "04");
                break;
            }
            case 14: {
                this.writeEnregEL1L(aPacBlockBase, "23");
                this.writeEnregEL1L(aPacBlockBase, "26");
                this.writeEnregEL1L(aPacBlockBase, "27");
                this.writeEnregEL1L(aPacBlockBase, "28");
                this.writeEnregEL1L(aPacBlockBase, "29");
                break;
            }
            case 15: {
                this.writeEnregEL1L(aPacBlockBase, "23");
                this.writeEnregEL1L(aPacBlockBase, "24");
                this.writeEnregEL1L(aPacBlockBase, "27");
                break;
            }
            case 16: {
                this.writeEnregEL1L(aPacBlockBase, "23");
                this.writeEnregEL1L(aPacBlockBase, "27");
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                this.writeEnregEL1L(aPacBlockBase, "07");
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                this.writeEnregEL1L(aPacBlockBase, "07");
                break;
            }
            case 9: {
                this.writeEnregEL1L(aPacBlockBase, "07");
                this.writeEnregEL1L(aPacBlockBase, "23");
                this.writeEnregEL1L(aPacBlockBase, "24");
                this.writeEnregEL1L(aPacBlockBase, "25");
                this.writeEnregEL1L(aPacBlockBase, "27");
                this.writeEnregEL1L(aPacBlockBase, "28");
                this.writeEnregEL1L(aPacBlockBase, "29");
                break;
            }
            case 17: {
                this.writeEnregEL1L(aPacBlockBase, "23");
                this.writeEnregEL1L(aPacBlockBase, "25");
                this.writeEnregEL1L(aPacBlockBase, "27");
                this.writeEnregEL1L(aPacBlockBase, "28");
                this.writeEnregEL1L(aPacBlockBase, "29");
                break;
            }
            case 18: {
                this.writeEnregEL1L(aPacBlockBase, "23");
                this.writeEnregEL1L(aPacBlockBase, "25");
                this.writeEnregEL1L(aPacBlockBase, "27");
                this.writeEnregEL1L(aPacBlockBase, "28");
                this.writeEnregEL1L(aPacBlockBase, "29");
                this.writeEnregEL1L(aPacBlockBase, "30");
                this.writeEnregEL1L(aPacBlockBase, "34");
                this.writeEnregEL1L(aPacBlockBase, "35");
                this.writeEnregEL1L(aPacBlockBase, "36");
                this.writeEnregEL1L(aPacBlockBase, "40");
                break;
            }
            case 23: 
            case 24: {
                this.writeEnregEL1L(aPacBlockBase, "BZ");
                break;
            }
            case 37: {
                this.writeEnregEL1L(aPacBlockBase, "BZ");
                this.writeEnregEL1L(aPacBlockBase, "BC");
                break;
            }
        }
        switch (this.getParentFabloc().charAt(0)) {
            case 'H': {
                this.writeEnregEL1L(aPacBlockBase, "01");
                this.writeEnregEL1L(aPacBlockBase, "05");
                this.writeEnregEL1L(aPacBlockBase, "32");
                break;
            }
            case 'P': {
                this.writeEnregEL1L(aPacBlockBase, "06");
                this.writeEnregEL1L(aPacBlockBase, "08");
                this.writeEnregEL1L(aPacBlockBase, "32");
                break;
            }
            case 'C': {
                this.writeEnregEL1L(aPacBlockBase, "02");
                break;
            }
            case 'S': {
                this.writeEnregEL1L(aPacBlockBase, "01");
            }
        }
    }

    private void casePacBlockBaseFromDHLine(EL2L DHLine, PacBlockBase aPacBlockBase) {
        EL1L dataBaseBlockDefinition = this.prepCommonDataForBlockBase(aPacBlockBase);
        dataBaseBlockDefinition.set_NUENR_Value("09");
        EL1L.GRCLEEL cleEL1L = dataBaseBlockDefinition.get_GRCLEEL_Groupe_Value();
        cleEL1L.set_COBLOC_Value(DHLine.get_GRCLEEL_Groupe_Value().get_COBLOC_Value());
        cleEL1L.set_NUMERA_Value(700);
        cleEL1L.set_NUMERC_Value(DHLine.get_GRCLEEL_Groupe_Value().get_NUMERC_Int_Value());
        cleEL1L.set_NUMERD_Value(120);
        dataBaseBlockDefinition.get_GRTYBLOC_Groupe_Value().set_TYBLO1_Value(DHLine.get_GRTYBLOC_Groupe_Value().get_TYBLO1_Value());
        dataBaseBlockDefinition.get_GRTYBLOC_Groupe_Value().set_TYBLO2_Value(DHLine.get_GRTYBLOC_Groupe_Value().get_TYBLO2_Value());
        dataBaseBlockDefinition.set_FABLOC_Value(DHLine.get_FABLOC_Value());
        dataBaseBlockDefinition.set_XOPEUR_Value("0");
        dataBaseBlockDefinition = this.prepLineForBlockBase(dataBaseBlockDefinition, aPacBlockBase);
        this.dataBlockBaseLines.add(dataBaseBlockDefinition);
    }

    private void casePacDCLine(PacDCLine aPacDCLine) {
        this.nuliDH = this.nuliDH == -1 ? 100 : (this.nuliDH += 2);
        this.nuliGG = -1;
        this.subNuliGG = -1;
        PacBlockBaseTypeValues blockType = ((PacBlockBaseImpl)aPacDCLine.getOwner()).getBlockType();
        switch (aPacDCLine.getNetworkRecordType().getValue()) {
            case 2: {
                this.writeEnregEL3L(aPacDCLine, "33");
                break;
            }
            case 3: {
                DataAggregateImpl daSegment;
                if (blockType.equals(PacBlockBaseTypeValues._TD_LITERAL)) {
                    this.writeEnregEL3L(aPacDCLine, "EB");
                    this.writeEnregEL3L(aPacDCLine, "FB");
                    this.writeEnregEL3L(aPacDCLine, "FI");
                    this.writeEnregEL3L(aPacDCLine, "ZZ");
                } else {
                    this.writeEnregEL3L(aPacDCLine, "17");
                    if (this.isASchemaBlockType(blockType) || blockType.getValue() == 13 && !aPacDCLine.getCommentOrName().equals("INCLUSION")) {
                        this.writeEnregEL3L(aPacDCLine, "31");
                    }
                    if (blockType.getValue() == 16) {
                        this.writeEnregEL3L(aPacDCLine, "18");
                    }
                    if (blockType.getValue() == 18) {
                        this.writeEnregEL3L(aPacDCLine, "38");
                        this.writeEnregEL3L(aPacDCLine, "41");
                    }
                }
                boolean dataGen = true;
                if (blockType.getValue() == 8 || blockType.getValue() == 15 || blockType.getValue() == 12) {
                    dataGen = false;
                }
                if (blockType.getValue() == 18 && !aPacDCLine.getMethodCode().startsWith("=") && !aPacDCLine.getCommentOrName().startsWith("SS=")) {
                    dataGen = false;
                }
                if (!dataGen || (daSegment = (DataAggregateImpl)aPacDCLine.getSegment()) == null) break;
                this.scvisitor = new SegmentCompositionPacbaseAndKernelVisitor(this.getPacLinksEntitiesService());
                this.scvisitor.setBasecodeToGenerate((PacBlockBaseImpl)aPacDCLine.getOwner());
                this.scvisitor.setNameOfProject(this.nameOfProject);
                this.scvisitor.setSegmentCode(daSegment.getName());
                this.scvisitor.setNuligToUse(this.nuliDH);
                this.scvisitor.setVariant(this.getVariant());
                this.scvisitor.setFabloc(this.getParentFabloc());
                this.scvisitor.setLibName(this.getLibName());
                if ((blockType.getValue() == 18 || blockType.getValue() == 16) && aPacDCLine.getCommentOrName().startsWith("SS=")) {
                    this.scvisitor.setSubSchema(aPacDCLine.getCommentOrName().substring(3));
                }
                if (aPacDCLine.getFromSegment() != null) {
                    daSegment = (DataAggregateImpl)aPacDCLine.getFromSegment();
                }
                this.scvisitor.doSwitch((EObject)daSegment);
                for (PacbaseSegment ps : this.scvisitor.getSegmentCompositionLines()) {
                    this.dataBlockBaseLines.add(ps);
                }
                break;
            }
            case 1: {
                this.writeEnregEL3L(aPacDCLine, "16");
                if (this.isASchemaBlockType(blockType)) {
                    this.writeEnregEL3L(aPacDCLine, "18");
                }
                if (!this.isASchemaBlockType(blockType) && (blockType.getValue() != 13 || aPacDCLine.getCommentOrName().equals("INCLUSION"))) break;
                this.writeEnregEL3L(aPacDCLine, "19");
                break;
            }
            case 0: {
                if (!this.isASchemaBlockType(blockType) && (blockType.getValue() != 13 || aPacDCLine.getCommentOrName().equals("INCLUSION"))) break;
                this.writeEnregEL3L(aPacDCLine, "19");
            }
        }
    }

    private void casePacDHLine(PacDHLine aPacDHLine) {
        this.nuliDHForSocrate = this.nuliDHForSocrate == -1 ? 502 : (this.nuliDHForSocrate += 2);
        this.nuliDH = this.nuliDH == -1 ? 100 : (this.nuliDH += 2);
        this.wkTable = new Hashtable();
        this.indice = 0;
        this.indiceInBlockLines = 0;
        this.indiceDHLine = 0;
        this.nuliGG = -1;
        this.subNuliGG = -1;
        this.nuliDH2 = -1;
        EL2L DHLine = this.prepCommonDataForDHLine(aPacDHLine);
        switch (this.fabloc.charAt(0)) {
            case 'H': {
                this.writeEnregEL2L(aPacDHLine, "10");
                if (aPacDHLine.getParent() == null) break;
                this.writeEnregEL2L(aPacDHLine, "12");
                break;
            }
            case 'M': {
                this.writeEnregEL2L(aPacDHLine, "EB");
                break;
            }
            case 'P': {
                if (aPacDHLine.getKeyIndicatorOrOption().equals("A")) break;
                this.writeEnregEL2L(aPacDHLine, "11");
                DHLine = this.prepCommonDataForDHLine(aPacDHLine);
                EL2L.GRCLEEL cleEL2L = DHLine.get_GRCLEEL_Groupe_Value();
                cleEL2L.set_NUMERD_Value(140);
                DHLine.set_NUENR_Value("14");
                DHLine.set_XOPEUR_Value("0");
                DHLine = this.prepLineForDHLine(DHLine, aPacDHLine);
                DHLine.set_PROCOP_Value(this.searchOptionInComment(aPacDHLine.getCommentRelatKeyLength(), this.procoptOption));
                if (DHLine.get_PROCOP_Value().trim().length() == 0) {
                    DHLine.set_PROCOP_Value(aPacDHLine.getKeyIndicatorOrOption());
                    if (DHLine.get_PROCOP_Value().trim().length() == 0) {
                        DHLine.set_PROCOP_Value("A");
                    }
                }
                this.dataBlockBaseLines.add(DHLine);
                if (aPacDHLine.getPsbOrPcb() == null || !(aPacDHLine.getPsbOrPcb() instanceof PacBlockBase)) break;
                this.keySort = "";
                this.segmentsTree = new HashMap();
                this.tempDhLine = null;
                PacBlockBase base = aPacDHLine.getPsbOrPcb();
                this.casePacBlockBaseFromDHLine(DHLine, base);
                for (PacDHLine pdhl : base.getDHLines()) {
                    this.casePacDHLineFromDHBlockBase(DHLine, pdhl);
                }
                if (this.tempDhLine == null) break;
                String val = this.searchOptionInComment(this.tempDhLine.get_GRPR2L_Groupe_Value().get_GRENREG_Groupe_Value().get_COMME_Value(), this.keyLength);
                if (val.trim().length() == 0) {
                    int lthMax = 0;
                    Iterator<String> currentSegments = this.segmentsTree.keySet().iterator();
                    while (currentSegments.hasNext()) {
                        int lth = 0;
                        String current = currentSegments.next();
                        SegmentDatas datas = this.segmentsTree.get(current);
                        if (datas != null) {
                            lth = datas.lth;
                            while (datas != null && datas.parent != null) {
                                datas = this.segmentsTree.get(datas.parent);
                                if (datas == null) continue;
                                lth += datas.lth;
                            }
                        }
                        if (lth <= lthMax) continue;
                        lthMax = lth;
                    }
                    String internalLength = String.valueOf(lthMax);
                    Object str = "0000" + internalLength;
                    str = ((String)str).substring(((String)str).length() - 4);
                    this.tempDhLine.set_GRCLECC_Value((String)str);
                }
                this.dataBlockBaseLines.add(this.tempDhLine);
                break;
            }
            case 'S': {
                this.writeEnregEL2L(aPacDHLine, "");
                DHLine = this.prepCommonDataForDHLine(aPacDHLine);
                DHLine.set_NUENR_Value("EN");
                DHLine.set_COCA_Value("");
                if (aPacDHLine.getKeyIndicatorOrOption().equals("L")) {
                    DHLine.set_NUENR_Value("LI");
                } else if (aPacDHLine.getKeyIndicatorOrOption().equals("S")) {
                    DHLine.set_NUENR_Value("SG");
                } else if (aPacDHLine.getKeyIndicatorOrOption().equals("I")) {
                    DHLine.set_NUENR_Value("FS");
                }
                DHLine = this.prepLineForDHLine(DHLine, aPacDHLine);
                EL2L.GRCLEEL cleEL2L = DHLine.get_GRCLEEL_Groupe_Value();
                cleEL2L.set_NUMERA_Value(this.nuliDHForSocrate);
                cleEL2L.set_NUMERB_Value(100);
                cleEL2L.set_NUMERC_Value(0);
                cleEL2L.set_NUMERD_Value(0);
                int numerf = 0;
                String cosegp = DHLine.get_GRPR2L_Groupe_Value().get_GRENREG_Groupe_Value().get_COSEGP_Value().trim();
                if (cosegp.length() > 0 && this.nivruTable.containsKey(cosegp)) {
                    numerf = this.nivruTable.get(cosegp);
                }
                if (cosegp.length() == 0) {
                    cosegp = DHLine.get_GRPR2L_Groupe_Value().get_GRENREG_Groupe_Value().get_COSEGF_Value().trim();
                }
                this.nivruTable.put(cosegp, ++numerf);
                cleEL2L.set_NUMERF_Value(numerf);
                this.setNumer(numerf);
                this.dataBlockBaseLines.add(DHLine);
                this.indiceDHLine = this.dataBlockBaseLines.indexOf((Object)DHLine);
            }
        }
        switch (((PacBlockBaseImpl)aPacDHLine.getOwner()).getBlockType().getValue()) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 23: 
            case 24: 
            case 36: {
                DataAggregateImpl daSegment = (DataAggregateImpl)aPacDHLine.getSegment();
                if (daSegment == null) break;
                this.scvisitor = new SegmentCompositionPacbaseAndKernelVisitor(this.getPacLinksEntitiesService());
                this.scvisitor.setBasecodeToGenerate((PacBlockBaseImpl)aPacDHLine.getOwner());
                this.scvisitor.setNameOfProject(this.nameOfProject);
                this.scvisitor.setSegmentCode(daSegment.getName());
                this.scvisitor.setNuligToUse(this.nuliDH);
                if (this.getParentFabloc().equals("S")) {
                    this.scvisitor.setNuligToUse(this.nuliDHForSocrate);
                    this.scvisitor.setNumer(this.getNumer());
                }
                this.scvisitor.setVariant(this.getVariant());
                this.scvisitor.setFabloc(this.getParentFabloc());
                this.scvisitor.setLibName(this.getLibName());
                this.scvisitor.doSwitch((EObject)daSegment);
                for (PacbaseSegment ps : this.scvisitor.getSegmentCompositionLines()) {
                    this.dataBlockBaseLines.add(ps);
                    if (!this.getParentFabloc().equals("M") || !(ps instanceof EL13)) continue;
                    EL13 el13 = (EL13)ps;
                    try {
                        Integer.parseInt(el13.get_GRPR13_Groupe_Value().get_INDIC_Value());
                    }
                    catch (NumberFormatException numberFormatException) {
                        continue;
                    }
                    EL13 aEL13 = new EL13();
                    aEL13.setIntContentFor(0, el13.toString().length(), el13.getCompleteContentForSegment(), el13.toString().length());
                    EL13.GRCLEEL cleEL13 = aEL13.get_GRCLEEL_Groupe_Value();
                    EL13.GRPR13 grpr13 = aEL13.get_GRPR13_Groupe_Value();
                    cleEL13.set_NUMERD_Value(String.valueOf((Object)grpr13.get_GRNRURE_Groupe_Value()) + grpr13.get_INDIC_Value());
                    aEL13.set_NUENR_Value("KY");
                    aEL13.get_GRCLEEL_Groupe_Value().set_NUMERC_Value(600);
                    this.dataBlockBaseLines.add(aEL13);
                }
                break;
            }
        }
    }

    private void casePacDHLineFromDHBlockBase(EL2L DHParentLine, PacDHLine aPacDHLine) {
        this.nuliDH2 = this.nuliDH2 == -1 ? 100 : (this.nuliDH2 += 20);
        if (DHParentLine.get_GRTYBLOC_Groupe_Value().get_TYBLO1_Value().concat(DHParentLine.get_GRTYBLOC_Groupe_Value().get_TYBLO2_Value()).equals("PS")) {
            EL2L DHLine = this.prepCommonDataForDHLine(aPacDHLine);
            EL2L.GRCLEEL cleEL2L = DHLine.get_GRCLEEL_Groupe_Value();
            cleEL2L.set_COBLOC_Value(DHParentLine.get_GRCLEEL_Groupe_Value().get_COBLOC_Value());
            cleEL2L.set_NUMERA_Value(700);
            cleEL2L.set_NUMERD_Value(700);
            cleEL2L.set_NUMERF_Value(this.nuliDH2);
            DHLine.set_NUENR_Value("15");
            DHLine.get_GRTYBLOC_Groupe_Value().set_TYBLO1_Value(DHParentLine.get_GRTYBLOC_Groupe_Value().get_TYBLO1_Value());
            DHLine.get_GRTYBLOC_Groupe_Value().set_TYBLO2_Value(DHParentLine.get_GRTYBLOC_Groupe_Value().get_TYBLO2_Value());
            DHLine.set_FABLOC_Value(DHParentLine.get_FABLOC_Value());
            DHLine = this.prepLineForDHLine(DHLine, aPacDHLine);
            DHLine.set_PROCOP_Value(this.searchOptionInComment(aPacDHLine.getCommentRelatKeyLength(), this.procoptOption));
            this.dataBlockBaseLines.add(DHLine);
            if (DHLine.get_GRPR2L_Groupe_Value().get_GRENREG_Groupe_Value().get_COSEGF_Value().trim().length() > 0 && !this.wkTable.containsKey(DHLine.get_GRPR2L_Groupe_Value().get_GRENREG_Groupe_Value().get_COSEGF_Value())) {
                this.wkTable.put(DHLine.get_GRPR2L_Groupe_Value().get_GRENREG_Groupe_Value().get_COSEGF_Value(), Integer.toString(this.nuliDH2));
            }
            this.keySort = "U";
            if (aPacDHLine.getKeyIndicatorOrOption().trim().length() > 0) {
                this.keySort = aPacDHLine.getKeyIndicatorOrOption().trim();
            }
            if (aPacDHLine.getParent() == null) {
                DHLine = this.prepCommonDataForDHLine(aPacDHLine);
                cleEL2L = DHLine.get_GRCLEEL_Groupe_Value();
                cleEL2L.set_COBLOC_Value(DHParentLine.get_GRCLEEL_Groupe_Value().get_COBLOC_Value());
                cleEL2L.set_NUMERA_Value(700);
                cleEL2L.set_NUMERD_Value(160);
                DHLine.set_NUENR_Value("30");
                DHLine.set_XOPEUR_Value("0");
                DHLine.get_GRTYBLOC_Groupe_Value().set_TYBLO1_Value(DHParentLine.get_GRTYBLOC_Groupe_Value().get_TYBLO1_Value());
                DHLine.get_GRTYBLOC_Groupe_Value().set_TYBLO2_Value(DHParentLine.get_GRTYBLOC_Groupe_Value().get_TYBLO2_Value());
                DHLine.set_FABLOC_Value(DHParentLine.get_FABLOC_Value());
                DHLine = this.prepLineForDHLine(DHLine, aPacDHLine);
                String lgCC = this.searchOptionInComment(aPacDHLine.getCommentRelatKeyLength(), this.keyLength);
                int lth = 0;
                if (lgCC.trim().length() == 0) {
                    lgCC = "0000";
                    lth = this.getKeyLength((DataAggregateImpl)aPacDHLine.getSegment(), this.keySort);
                    String internalLength = String.valueOf(lth);
                    String str = "0000" + internalLength;
                    lgCC = str.substring(str.length() - 4);
                } else {
                    try {
                        lth = Integer.parseInt(lgCC);
                    }
                    catch (NumberFormatException numberFormatException) {
                        lth = 0;
                    }
                }
                DHLine.set_GRCLECC_Value(lgCC);
                this.tempDhLine = DHLine;
                this.segmentsTree.put(DHLine.get_GRPR2L_Groupe_Value().get_GRENREG_Groupe_Value().get_COSEGF_Value(), new SegmentDatas(null, lth));
            } else {
                EL2L.GRPR2L el2lPR2L = DHLine.get_GRPR2L_Groupe_Value();
                EL2L.GRPR2L.GRENREG el2lENREG = el2lPR2L.get_GRENREG_Groupe_Value();
                int lth = this.getKeyLength((DataAggregateImpl)aPacDHLine.getSegment(), this.keySort);
                this.segmentsTree.put(DHLine.get_GRPR2L_Groupe_Value().get_GRENREG_Groupe_Value().get_COSEGF_Value(), new SegmentDatas(el2lENREG.get_COSEGP_Value(), lth));
            }
        }
    }

    private int getKeyLength(DataAggregateImpl daSegment, String sortKey) {
        SortKeySwitch sk = new SortKeySwitch(sortKey);
        Object obj = sk.doSwitch((EObject)daSegment);
        if (obj != null && obj instanceof PacDataCallImpl) {
            DataCall da = (DataCall)((PacDataCallImpl)obj).eContainer();
            String name = "";
            if (da.getDataDefinition() != null) {
                name = da.getDataDefinition().getName();
            } else if (da.getDataDescription() != null) {
                name = da.getDataDescription().getName();
            }
            LengthAndPositionVisitor lpv = new LengthAndPositionVisitor(null, new GenerationContext());
            lpv.doSwitch((EObject)daSegment);
            return this.getCorubLength(name, lpv.getTopParentLal().getChildren().iterator());
        }
        return 0;
    }

    private int getCorubLength(String name, Iterator<PacbaseLalDescription> pldIt) {
        while (pldIt.hasNext()) {
            int lth;
            PacbaseLalDescription pld = pldIt.next();
            if (pld.getName().equals(name)) {
                return pld.getInternalLength();
            }
            if (pld.getChildren().isEmpty() || (lth = this.getCorubLength(name, pld.getChildren().iterator())) <= 0) continue;
            return lth;
        }
        return 0;
    }

    private void casePacInputAidGLine(List<PacInputAidCompletedDetailManager.AsGLine> list, PacGLine theEObject) {
        if (theEObject instanceof PacBlockBaseGenerationElement) {
            this.nuliGG = ((PacBlockBaseGenerationElement)theEObject).getLineNumber();
            this.subNuliGG = -1;
        } else if (this.nuliGG == -1) {
            this.nuliGG = 10;
            this.subNuliGG = 0;
        } else {
            ++this.subNuliGG;
        }
        int i = 0;
        while (i < list.size()) {
            PacInputAidCompletedDetailManager.AsGLine asGline = list.get(i);
            ++this.subNuliGG;
            this.casePacAsGLine(asGline, theEObject);
            ++i;
        }
    }

    private void casePacAsGLine(PacInputAidCompletedDetailManager.AsGLine asGLine, PacGLine piagLine) {
        if (piagLine.getLineType().trim().length() > 0 && piagLine.getLineType().equals("I")) {
            DbdGLine dbdGLine = new DbdGLine();
            dbdGLine.setBb((PacBlockBaseImpl)piagLine.getOwner());
            dbdGLine.setDescription(asGLine.getDescription());
            dbdGLine.setLineType(asGLine.getType());
            dbdGLine.setLineNb(this.nuliGG);
            dbdGLine.setSubLineNb(this.subNuliGG);
            dbdGLine.seteContainer(piagLine.eContainer());
            if (this.getParentFabloc().equals("C") || this.getParentFabloc().equals("H") || this.getParentFabloc().equals("P")) {
                this.caseGLineForHierachicalAndCodasylDataBases(dbdGLine);
            }
        }
    }

    private void casePacGLine(PacGLine pacGLine) {
        if (pacGLine.getLineType().trim().length() > 0) {
            this.nuliGG = pacGLine instanceof PacBlockBaseGenerationElement ? ((PacBlockBaseGenerationElement)pacGLine).getLineNumber() : (this.nuliGG == -1 ? 10 : ++this.nuliGG);
            if (pacGLine.getLineType().equals("G")) {
                DbdGLine dbdGLine = this.initNewDbdGLine(pacGLine);
                if (this.getParentFabloc().equals("C") || this.getParentFabloc().equals("H") || this.getParentFabloc().equals("P")) {
                    this.caseGLineForHierachicalAndCodasylDataBases(dbdGLine);
                } else if (this.getParentFabloc().equals("M")) {
                    this.caseGLineForAs400DataBases(dbdGLine);
                } else if (((PacBlockBaseImpl)pacGLine.getOwner()).getBlockType() == PacBlockBaseTypeValues._TD_LITERAL) {
                    this.caseGLineForTandemDataBases(dbdGLine);
                }
            } else if (this.getParentFabloc().equals("S")) {
                this.caseGLineForSocrateDataBases(this.initNewDbdGLine(pacGLine));
            }
        }
    }

    private DbdGLine initNewDbdGLine(PacGLine pacGLine) {
        DbdGLine dbdGLine = new DbdGLine();
        dbdGLine.setBb((PacBlockBaseImpl)pacGLine.getOwner());
        dbdGLine.setDescription(pacGLine.getDescription());
        dbdGLine.setLineType(pacGLine.getLineType());
        dbdGLine.setLineNb(this.nuliGG);
        dbdGLine.setSubLineNb(0);
        dbdGLine.seteContainer(pacGLine.eContainer());
        return dbdGLine;
    }

    private void caseGLineForAs400DataBases(DbdGLine dbdGLine) {
        EL3V GLine = this.prepCommonDataForGLine(dbdGLine);
        int lineNumber = this.getInternalLineNb(this.nuliGG, this.subNuliGG);
        boolean isStandardLine = true;
        if (this.override.booleanValue()) {
            boolean remove = false;
            if (lineNumber > 200000 && lineNumber < 400000 || lineNumber > 600000 && lineNumber < 800000) {
                if (dbdGLine.getDescription().startsWith("<") && dbdGLine.getDescription().endsWith(">") && dbdGLine.getDescription().length() > 2) {
                    remove = true;
                }
            } else {
                remove = true;
            }
            if (remove) {
                this.override = false;
                this.dataBlockBaseLines.add(this.overrideGline);
                isStandardLine = false;
                this.dataBlockBaseLines.remove(this.indiceInBlockLines);
            }
        }
        if (lineNumber > 200000 && lineNumber < 400000 || lineNumber > 600000 && lineNumber < 800000) {
            if (dbdGLine.getDescription().length() > 2 && dbdGLine.getDescription().startsWith("<") && dbdGLine.getDescription().endsWith(">")) {
                this.overrideObject = dbdGLine.getDescription().substring(1, dbdGLine.getDescription().trim().length() - 1);
                for (PacbaseSegment ps : this.scvisitor.getSegmentCompositionLines()) {
                    EL13 el13;
                    if (!(ps instanceof EL13) || !this.dataBlockBaseLines.contains((Object)ps) || !(el13 = (EL13)this.dataBlockBaseLines.get(this.dataBlockBaseLines.indexOf((Object)ps))).get_GRPR13_Groupe_Value().get_GRI13_Groupe_Value().get_CORUB_Value().equals(this.overrideObject)) continue;
                    this.override = true;
                    isStandardLine = false;
                    this.indice = this.scvisitor.getSegmentCompositionLines().indexOf((Object)el13);
                    this.indiceInBlockLines = this.dataBlockBaseLines.indexOf((Object)el13);
                    this.overrideGline = this.prepLineForGLine(GLine, dbdGLine, false, false, true);
                    this.overrideGline.set_COCA_Value("V3");
                    this.overrideGline.set_NUENR_Value("V3");
                    this.overrideGline.get_GRCLEEL_Groupe_Value().set_NUMERC_Value(200);
                    this.overrideGline.get_GRCLEEL_Groupe_Value().set_NUMERE_Value(200);
                    this.overrideGline.get_GRCLEEL_Groupe_Value().set_NUMERD_Value(el13.get_GRCLEEL_Groupe_Value().get_NUMERD_Value());
                    this.overrideGline.set_GRSYNPA_Value("");
                    this.overrideGline.set_DOCAP_Value("");
                    if (this.isLastGG.booleanValue()) {
                        this.dataBlockBaseLines.add(this.overrideGline);
                        this.dataBlockBaseLines.remove(this.indiceInBlockLines);
                        this.override = false;
                    }
                    break;
                }
            } else {
                GLine = this.prepLineForGLine(GLine, dbdGLine, false, false, true);
                if (this.override.booleanValue()) {
                    this.override = false;
                    if (dbdGLine.getDescription().startsWith("FUNCTIONS:")) {
                        EL13 el13 = (EL13)this.scvisitor.getSegmentCompositionLines().get(this.indice);
                        try {
                            Integer.parseInt(el13.get_GRPR13_Groupe_Value().get_INDIC_Value());
                        }
                        catch (NumberFormatException numberFormatException) {
                            GLine.set_NUENR_Value("RB");
                            GLine.get_GRCLEEL_Groupe_Value().set_NUMERC_Value(200);
                        }
                        if (!GLine.get_NUENR_Value().equals("RB")) {
                            GLine.set_NUENR_Value("KY");
                            GLine.get_GRCLEEL_Groupe_Value().set_NUMERC_Value(600);
                        }
                        GLine.set_COCA_Value("V3");
                        GLine.get_GRCLEEL_Groupe_Value().set_NUMERD_Value(el13.get_GRCLEEL_Groupe_Value().get_NUMERD_Value());
                        GLine.get_GRCLEEL_Groupe_Value().set_NUMERE_Value(200);
                        GLine.get_GRSYNPA_Groupe_Value().set_LITAC_Value(dbdGLine.getDescription().toUpperCase().substring(10, dbdGLine.getDescription().length()));
                        this.dataBlockBaseLines.add(GLine);
                        isStandardLine = false;
                    }
                }
            }
        }
        if (isStandardLine) {
            GLine = this.prepLineForGLine(GLine, dbdGLine, false, false, true);
            GLine.set_NUENR_Value("V3");
            GLine.get_GRCLEEL_Groupe_Value().set_NUOPT_Value("");
            GLine.get_GRCLEEL_Groupe_Value().set_NUMERF_Value(GLine.get_GRCLEEL_Groupe_Value().get_NUMERE_Int_Value());
            GLine.get_GRCLEEL_Groupe_Value().set_NUMERE_Value(0);
            this.dataBlockBaseLines.add(GLine);
        }
    }

    private void caseGLineForHierachicalAndCodasylDataBases(DbdGLine dbdGLine) {
        String descr;
        boolean isStandardLine = true;
        EL3V GLine = this.prepCommonDataForGLine(dbdGLine);
        PacBlockBaseImpl bb = dbdGLine.getBb();
        int lineNumber = this.getInternalLineNb(this.nuliGG, this.subNuliGG);
        if (!dbdGLine.getLineType().equals("G") || lineNumber == 9999 && dbdGLine.getDescription().length() > 0 && dbdGLine.getDescription().charAt(0) == ' ') {
            return;
        }
        if (lineNumber >= 700000 && lineNumber < 800000) {
            if (bb.getBlockType().getValue() == 6) {
                if (dbdGLine.geteContainer() instanceof PacDHLine && !((PacDHLine)dbdGLine.geteContainer()).getKeyIndicatorOrOption().equals("A")) {
                    if (dbdGLine.getDescription().length() > 2 && dbdGLine.getDescription().startsWith("<") && dbdGLine.getDescription().endsWith(">")) {
                        this.overrideObject = dbdGLine.getDescription().substring(1, dbdGLine.getDescription().trim().length() - 1);
                        this.override = false;
                        if (this.wkTable.containsKey(this.overrideObject)) {
                            this.override = true;
                            this.indice = 0;
                            cleEL3V = GLine.get_GRCLEEL_Groupe_Value();
                            GLine.set_NUENR_Value("00");
                            cleEL3V.set_NUOPT_Value("=");
                            GLine = this.prepLineForGLine(GLine, dbdGLine, false, false, true);
                            cleEL3V.set_NUMERD_Value(700);
                            cleEL3V.set_NUMERE_Value(0);
                            cleEL3V.set_NUMERF_Value(this.wkTable.get(this.overrideObject));
                            isStandardLine = false;
                            this.dataBlockBaseLines.add(GLine);
                        }
                    } else {
                        GLine = this.prepLineForGLine(GLine, dbdGLine, false, false, true);
                        if (this.override.booleanValue()) {
                            cleEL3V = GLine.get_GRCLEEL_Groupe_Value();
                            cleEL3V.set_NUOPT_Value(nuoptTable[this.indice]);
                            if (this.indice < nuoptTable.length - 1) {
                                ++this.indice;
                            }
                            cleEL3V.set_NUMERD_Value(700);
                            cleEL3V.set_NUMERE_Value(0);
                            if (this.wkTable.size() > 0) {
                                cleEL3V.set_NUMERF_Value(this.wkTable.get(this.overrideObject));
                            } else {
                                cleEL3V.set_NUMERF_Value(0);
                            }
                        }
                        if ((descr = dbdGLine.getDescription()).trim().length() > 0 && descr.substring(0, 1).trim().length() == 0 || descr.trim().length() == 0) {
                            GLine.set_XOPEUR_Value("0");
                        }
                        isStandardLine = false;
                        this.dataBlockBaseLines.add(GLine);
                    }
                }
            } else if (bb.getBlockType().getValue() != 6 && bb.getBlockType().getValue() != 2 && (dbdGLine.geteContainer() instanceof PacDCLine && ((PacDCLine)dbdGLine.geteContainer()).getNetworkRecordType().equals(PacCodasylRecordTypeValues._R_LITERAL) || dbdGLine.geteContainer() instanceof PacDHLine)) {
                if (dbdGLine.getDescription().length() > 2 && dbdGLine.getDescription().startsWith("<") && dbdGLine.getDescription().endsWith(">")) {
                    this.overrideObject = dbdGLine.getDescription().substring(1, dbdGLine.getDescription().trim().length() - 1);
                    for (PacbaseSegment ps : this.scvisitor.getSegmentCompositionLines()) {
                        if (!(ps instanceof EL13) || !((EL13)ps).get_GRPR13_Groupe_Value().get_GRI13_Groupe_Value().get_CORUB_Value().equals(this.overrideObject)) continue;
                        this.override = true;
                        this.indice = 0;
                        EL3V.GRCLEEL cleEL3V = GLine.get_GRCLEEL_Groupe_Value();
                        GLine.set_NUENR_Value("00");
                        cleEL3V.set_NUOPT_Value("=");
                        GLine = this.prepLineForGLine(GLine, dbdGLine, false, false, true);
                        cleEL3V.set_NUMERD_Value(700);
                        this.setNumer(((EL13)ps).get_GRCLEEL_Groupe_Value().get_NUMERF_Int_Value());
                        cleEL3V.set_NUMERE_Value(0);
                        cleEL3V.set_NUMERF_Value(this.getNumer());
                        if (bb.getBlockType().getValue() == 17 || bb.getBlockType().getValue() == 18) {
                            GLine.set_XOPEUR_Value("0");
                        }
                        isStandardLine = false;
                        this.dataBlockBaseLines.add(GLine);
                        break;
                    }
                } else {
                    GLine = this.prepLineForGLine(GLine, dbdGLine, false, false, true);
                    if (this.override.booleanValue()) {
                        cleEL3V = GLine.get_GRCLEEL_Groupe_Value();
                        cleEL3V.set_NUOPT_Value(nuoptTable[this.indice]);
                        if (this.indice < nuoptTable.length - 1) {
                            ++this.indice;
                        }
                        cleEL3V.set_NUMERD_Value(700);
                        cleEL3V.set_NUMERE_Value(0);
                        cleEL3V.set_NUMERF_Value(this.getNumer());
                    }
                    descr = dbdGLine.getDescription();
                    if (bb.getBlockType().getValue() == 17 || bb.getBlockType().getValue() == 18 || descr.trim().length() > 0 && descr.substring(0, 1).trim().length() == 0 || descr.trim().length() == 0) {
                        GLine.set_XOPEUR_Value("0");
                    }
                    isStandardLine = false;
                    this.dataBlockBaseLines.add(GLine);
                }
            }
        }
        if (isStandardLine) {
            GLine = this.prepLineForGLine(GLine, dbdGLine, false, false, true);
            descr = dbdGLine.getDescription();
            if (bb.getBlockType().getValue() == 17 || bb.getBlockType().getValue() == 18 || descr.trim().length() > 0 && descr.substring(0, 1).trim().length() == 0 || descr.trim().length() == 0) {
                GLine.set_XOPEUR_Value("0");
            }
            this.dataBlockBaseLines.add(GLine);
        }
    }

    private void caseGLineForSocrateDataBases(DbdGLine dbdGLine) {
        this.nuliGG = this.nuliGG == -1 ? 100 : (this.nuliGG += 10);
        EL3V GLine = this.prepCommonDataForGLine(dbdGLine);
        GLine = this.prepLineForGLine(GLine, dbdGLine, false, false, true);
        boolean isStandardLine = true;
        if (dbdGLine.getDescription().startsWith("<") && dbdGLine.getDescription().endsWith(">") && dbdGLine.getDescription().length() > 2) {
            this.override = false;
            this.overrideObject = dbdGLine.getDescription().substring(1, dbdGLine.getDescription().trim().length() - 1);
            for (PacbaseSegment ps : this.scvisitor.getSegmentCompositionLines()) {
                EL13 el13;
                if (!(ps instanceof EL13) || !this.dataBlockBaseLines.contains((Object)ps) || !(el13 = (EL13)this.dataBlockBaseLines.get(this.dataBlockBaseLines.indexOf((Object)ps))).get_GRPR13_Groupe_Value().get_GRI13_Groupe_Value().get_CORUB_Value().equals(this.overrideObject)) continue;
                isStandardLine = false;
                this.override = true;
                this.indice = this.scvisitor.getSegmentCompositionLines().indexOf((Object)el13);
                break;
            }
        } else if (this.override.booleanValue()) {
            EL13 el13 = (EL13)this.scvisitor.getSegmentCompositionLines().get(this.indice);
            GLine.set_GRCLEEL_Value(el13.get_GRCLEEL_Groupe_Value().toString());
            GLine.set_NUENR_Value(el13.get_NUENR_Value());
            GLine.set_COCA_Value("");
            if (GLine.get_DOCAP_Value().equals("G")) {
                GLine.get_GRCLEEL_Groupe_Value().set_NUMERD_Value(250);
            } else if (GLine.get_DOCAP_Value().equals("V")) {
                GLine.get_GRCLEEL_Groupe_Value().set_NUMERD_Value(100);
            } else if (GLine.get_DOCAP_Value().equals("P")) {
                GLine.get_GRCLEEL_Groupe_Value().set_NUMERD_Value(500);
            }
            this.dataBlockBaseLines.add(GLine);
            isStandardLine = false;
        }
        if (isStandardLine) {
            EL2L dhLine = (EL2L)this.dataBlockBaseLines.get(this.indiceDHLine);
            GLine.set_NUENR_Value(dhLine.get_NUENR_Value());
            GLine.set_COCA_Value("");
            GLine.get_GRCLEEL_Groupe_Value().set_NUOPT_Value("");
            GLine.get_GRSYNPA_Groupe_Value().set_LITAC_Value(dbdGLine.getDescription());
            GLine.set_DOCAP_Value(dbdGLine.getLineType());
            EL3V.GRCLEEL cleEL3V = GLine.get_GRCLEEL_Groupe_Value();
            cleEL3V.set_NUMERA_Value(dhLine.get_GRCLEEL_Groupe_Value().get_NUMERA_Value());
            cleEL3V.set_NUMERE_Value(this.nuliGG);
            cleEL3V.set_NUMERF_Value(this.getNumer());
            if (dbdGLine.getLineType().equals("F") || dbdGLine.getLineType().equals("I")) {
                GLine.set_XOPEUR_Value("F");
            }
            if (GLine.get_DOCAP_Value().equals("G")) {
                cleEL3V.set_NUMERD_Value(700);
            } else if (GLine.get_DOCAP_Value().equals("V")) {
                cleEL3V.set_NUMERB_Value(50);
            } else if (GLine.get_DOCAP_Value().equals("P")) {
                cleEL3V.set_NUMERB_Value(150);
            } else if (GLine.get_DOCAP_Value().equals("Z")) {
                cleEL3V.set_NUMERA_Value(dhLine.get_GRCLEEL_Groupe_Value().get_NUMERA_Int_Value() + 1);
                cleEL3V.set_NUMERB_Value(0);
                cleEL3V.set_NUMERC_Value(0);
                cleEL3V.set_NUMERD_Value(0);
                GLine.set_NUENR_Value("CO");
            }
            this.dataBlockBaseLines.add(GLine);
        }
    }

    private void caseGLineForTandemDataBases(DbdGLine dbdGLine) {
        EL3V GLine = this.prepCommonDataForGLine(dbdGLine);
        int lineNumber = this.getInternalLineNb(this.nuliGG, this.subNuliGG);
        boolean isStandardLine = true;
        if (this.override.booleanValue()) {
            boolean remove = false;
            if (lineNumber >= 400000 && lineNumber < 600000) {
                if (dbdGLine.getDescription().startsWith("<") && dbdGLine.getDescription().endsWith(">") && dbdGLine.getDescription().length() > 2) {
                    remove = true;
                }
            } else {
                remove = true;
            }
            if (remove) {
                this.override = false;
                this.dataBlockBaseLines.add(this.overrideGline);
                isStandardLine = false;
                this.dataBlockBaseLines.remove(this.indiceInBlockLines);
            }
        }
        GLine = this.prepLineForGLine(GLine, dbdGLine, false, false, true);
        GLine.set_COCA_Value("");
        GLine.set_NUENR_Value("V3");
        if (lineNumber >= 400000 && lineNumber < 600000) {
            if (dbdGLine.getDescription().startsWith("<") && dbdGLine.getDescription().endsWith(">") && dbdGLine.getDescription().length() > 2) {
                this.overrideObject = dbdGLine.getDescription().substring(1, dbdGLine.getDescription().trim().length() - 1);
                for (PacbaseSegment ps : this.scvisitor.getSegmentCompositionLines()) {
                    EL13 el13;
                    if (!(ps instanceof EL13) || !this.dataBlockBaseLines.contains((Object)ps) || !(el13 = (EL13)this.dataBlockBaseLines.get(this.dataBlockBaseLines.indexOf((Object)ps))).get_GRPR13_Groupe_Value().get_GRI13_Groupe_Value().get_CORUB_Value().equals(this.overrideObject)) continue;
                    isStandardLine = false;
                    this.override = true;
                    this.indice = this.scvisitor.getSegmentCompositionLines().indexOf((Object)el13);
                    this.indiceInBlockLines = this.dataBlockBaseLines.indexOf((Object)el13);
                    this.overrideGline = this.prepLineForGLine(GLine, dbdGLine, false, false, true);
                    this.overrideGline.set_COCA_Value("");
                    this.overrideGline.set_NUENR_Value("V3");
                    this.overrideGline.get_GRCLEEL_Groupe_Value().set_NUMERB_Value(400);
                    this.overrideGline.get_GRCLEEL_Groupe_Value().set_NUMERC_Value(el13.get_GRCLEEL_Groupe_Value().get_NUMERC_Value());
                    this.overrideGline.set_GRSYNPA_Value("");
                    this.overrideGline.set_DOCAP_Value("");
                    if (this.isLastGG.booleanValue()) {
                        this.dataBlockBaseLines.add(this.overrideGline);
                        this.dataBlockBaseLines.remove(this.indiceInBlockLines);
                        this.override = false;
                    }
                    break;
                }
            } else if (this.override.booleanValue()) {
                this.override = false;
                EL13 el13 = (EL13)this.scvisitor.getSegmentCompositionLines().get(this.indice);
                GLine.get_GRCLEEL_Groupe_Value().set_NUMERB_Value(400);
                GLine.get_GRCLEEL_Groupe_Value().set_NUMERC_Value(el13.get_GRCLEEL_Groupe_Value().get_NUMERC_Value());
                this.dataBlockBaseLines.add(GLine);
                this.dataBlockBaseLines.remove(this.indiceInBlockLines);
                isStandardLine = false;
            }
        }
        if (isStandardLine) {
            this.dataBlockBaseLines.add(GLine);
        }
    }

    private void casePacLibrary(PacLibrary aPacLibrary) {
        EL01 dataBaseBlockLibrary = new EL01();
        EL01.GRCLEEL cleEL01 = dataBaseBlockLibrary.get_GRCLEEL_Groupe_Value();
        cleEL01.set_NUBIB_Value(1);
        cleEL01.set_NUMERA_Value(0);
        cleEL01.set_NUMERB_Value(0);
        cleEL01.set_NUMERC_Value(0);
        cleEL01.set_NUMERD_Value(0);
        cleEL01.set_NUMERE_Value(0);
        cleEL01.set_NUMERF_Value(100);
        cleEL01.set_NUOPT_Value(" ");
        dataBaseBlockLibrary.set_NUENR_Value("AB");
        dataBaseBlockLibrary.set_COCA_Value("* ");
        dataBaseBlockLibrary.get_GRTYBLOC_Groupe_Value().set_TYBLO1_Value(" ");
        dataBaseBlockLibrary.get_GRTYBLOC_Groupe_Value().set_TYBLO2_Value(" ");
        dataBaseBlockLibrary.set_FABLOC_Value(" ");
        dataBaseBlockLibrary.set_XOPEUR_Value("1");
        dataBaseBlockLibrary = this.prepLineForLibrary(dataBaseBlockLibrary, aPacLibrary);
        this.dataBlockBaseLines.add(dataBaseBlockLibrary);
    }

    public void doSwitch(EObject theEObject) {
        this.doSwitch(theEObject.eClass(), theEObject);
    }

    protected void doSwitch(EClass theEClass, EObject theEObject) {
        if (theEObject instanceof RadicalEntity && !(theEObject instanceof PacBlockBase)) {
            this.getPacLinksEntitiesService().registerReference((RadicalEntity)theEObject);
        }
        if (theEClass.eContainer() == modelPackagePB) {
            this.doSwitchPB(theEClass.getClassifierID(), theEObject);
        } else if (theEClass.eContainer() == modelPackageKernel) {
            this.doSwitchKernel(theEClass.getClassifierID(), theEObject);
        }
    }

    protected void doSwitchKernel(int classifierID, EObject theEObject) {
        System.out.println("Kernel case not defined: " + theEObject.getClass().toString());
    }

    protected void doSwitchPB(int classifierID, EObject theEObject) {
        switch (classifierID) {
            case 31: {
                PacLibrary pacbaseObject = (PacLibrary)theEObject;
                this.casePacLibrary(pacbaseObject);
                break;
            }
            case 42: {
                PacBlockBase pacbaseObject = (PacBlockBase)theEObject;
                this.casePacBlockBase(pacbaseObject);
                break;
            }
            case 111: {
                List list = detailManager.getAsGLineList((PacGenElemFromGuideInputAid)theEObject, true);
                this.casePacInputAidGLine(list, (PacGLine)theEObject);
                break;
            }
            case 112: {
                List list = detailManager.getAsGLineList((PacGenElemFromVirtualInputAid)theEObject, true);
                this.casePacInputAidGLine(list, (PacGLine)theEObject);
                break;
            }
            case 110: {
                List list = detailManager.getAsGLineList((PacInputAidGLine)theEObject, true);
                this.casePacInputAidGLine(list, (PacGLine)theEObject);
                break;
            }
            case 94: {
                if (!(theEObject instanceof PacBlockBaseGenerationElement)) break;
                this.nuliGG = ((PacBlockBaseGenerationElement)theEObject).getLineNumber();
                this.subNuliGG = ((PacBlockBaseGenerationElement)theEObject).getSubLineNumber();
                break;
            }
            case 12: 
            case 92: 
            case 95: 
            case 96: {
                PacGLine pacbaseObject = (PacGLine)theEObject;
                this.casePacGLine(pacbaseObject);
                break;
            }
            case 43: {
                PacDHLine pacbaseObject = (PacDHLine)theEObject;
                if (pacbaseObject.getPsbOrPcb() != null && pacbaseObject.getPsbOrPcb() instanceof PacBlockBase) {
                    this.getPacLinksEntitiesService().registerReference((RadicalEntity)pacbaseObject.getPsbOrPcb());
                }
                this.casePacDHLine(pacbaseObject);
                break;
            }
            case 44: {
                PacDCLine pacbaseObject = (PacDCLine)theEObject;
                this.casePacDCLine(pacbaseObject);
                break;
            }
            default: {
                System.out.println("Pacbase case not defined: " + theEObject.getClass().toString());
            }
        }
    }

    private String getParentFabloc() {
        return this.fabloc;
    }

    private void setParentFabloc(String fabloc) {
        this.fabloc = fabloc;
    }

    private String getFabloc(String type) {
        if (type.startsWith("Q")) {
            return "Q";
        }
        if (type.equals("20")) {
            return "2";
        }
        if (type.equals("DP") || type.equals("DR") || type.equals("DL") || type.equals("PC") || type.equals("IP") || type.equals("IS")) {
            return "H";
        }
        if (type.equals("PS")) {
            return "P";
        }
        if ((type.startsWith("M") || type.startsWith("I") || type.startsWith("S") || type.startsWith("D")) && (type.endsWith("0") || type.endsWith("1") || type.endsWith("2") || type.endsWith("3") || type.endsWith("4"))) {
            return "C";
        }
        if (type.equals("PF") || type.equals("LF")) {
            return "M";
        }
        if (type.equals("SO") || type.equals("SS") || type.equals("SA")) {
            return "S";
        }
        if (type.equals("DB") || type.equals("TD")) {
            return "D";
        }
        return "I";
    }

    public List<PacbaseSegment> getDataBlockBaseLines() {
        return this.dataBlockBaseLines;
    }

    private String getLibName() {
        return this.libName;
    }

    private int getLineNbForCodasylBlock(PacDCLine aPacDCLine) {
        PacBlockBaseImpl bb = (PacBlockBaseImpl)aPacDCLine.getOwner();
        int lineNumber = 750;
        if (bb.getBlockType().getValue() != 9 && aPacDCLine.getNetworkRecordType().getValue() == 3 || bb.getBlockType().getValue() == 9 && aPacDCLine.getNetworkRecordType().getValue() == 1) {
            lineNumber = 650;
        }
        if (aPacDCLine.getNetworkRecordType().getValue() == 2) {
            lineNumber = 550;
        }
        return lineNumber;
    }

    private PacbaseLinksEntitiesService getPacLinksEntitiesService() {
        return this.ples;
    }

    private EL1L prepCommonDataForBlockBase(PacBlockBase aPacBlockBase) {
        EL1L dataBaseBlockDefinition = new EL1L();
        EL1L.GRCLEEL cleEL1L = dataBaseBlockDefinition.get_GRCLEEL_Groupe_Value();
        cleEL1L.set_NUBIB_Value(1);
        cleEL1L.set_COBLOC_Value(aPacBlockBase.getName());
        cleEL1L.set_NUMERA_Value(0);
        cleEL1L.set_NUMERB_Value(0);
        cleEL1L.set_NUMERC_Value(0);
        cleEL1L.set_NUMERD_Value(0);
        cleEL1L.set_NUMERE_Value(0);
        cleEL1L.set_NUMERF_Value(0);
        dataBaseBlockDefinition.set_COCA_Value("L1");
        dataBaseBlockDefinition.set_XOPEUR_Value("1");
        dataBaseBlockDefinition.get_GRTYBLOC_Groupe_Value().set_TYBLO1_Value(aPacBlockBase.getBlockType().toString().substring(1, 2));
        dataBaseBlockDefinition.get_GRTYBLOC_Groupe_Value().set_TYBLO2_Value(aPacBlockBase.getBlockType().toString().substring(2));
        dataBaseBlockDefinition.set_FABLOC_Value(this.getParentFabloc());
        return dataBaseBlockDefinition;
    }

    private EL3L prepCommonDataForDCLine(PacDCLine aPacDCLine) {
        PacBlockBaseImpl bb = (PacBlockBaseImpl)aPacDCLine.getOwner();
        EL3L DCLine = new EL3L();
        EL3L.GRCLEEL cleEL3L = DCLine.get_GRCLEEL_Groupe_Value();
        cleEL3L.set_NUBIB_Value(1);
        cleEL3L.set_COBLOC_Value(bb.getName());
        cleEL3L.set_NUMERA_Value(0);
        cleEL3L.set_NUMERB_Value(0);
        cleEL3L.set_NUMERC_Value(0);
        cleEL3L.set_NUMERD_Value(0);
        cleEL3L.set_NUMERE_Value(0);
        cleEL3L.set_NUMERF_Value(0);
        if (!this.getParentFabloc().equals("D")) {
            cleEL3L.set_NUMERA_Value(this.getLineNbForCodasylBlock(aPacDCLine));
            cleEL3L.set_NUMERC_Value(this.nuliDH);
            cleEL3L.set_NUMERD_Value(100);
        }
        DCLine.set_COCA_Value("L3");
        DCLine.get_GRTYBLOC_Groupe_Value().set_TYBLO1_Value(bb.getBlockType().toString().substring(1, 2));
        DCLine.get_GRTYBLOC_Groupe_Value().set_TYBLO2_Value(bb.getBlockType().toString().substring(2));
        DCLine.set_FABLOC_Value(this.getParentFabloc());
        DCLine.set_XOPEUR_Value("1");
        return DCLine;
    }

    private EL2L prepCommonDataForDHLine(PacDHLine aPacDHLine) {
        PacBlockBaseImpl bb = (PacBlockBaseImpl)aPacDHLine.getOwner();
        EL2L DHLine = new EL2L();
        EL2L.GRCLEEL cleEL2L = DHLine.get_GRCLEEL_Groupe_Value();
        cleEL2L.set_NUBIB_Value(1);
        cleEL2L.set_COBLOC_Value(bb.getName());
        cleEL2L.set_NUMERA_Value(700);
        cleEL2L.set_NUMERB_Value(0);
        cleEL2L.set_NUMERC_Value(this.nuliDH);
        cleEL2L.set_NUMERD_Value(100);
        cleEL2L.set_NUMERE_Value(0);
        cleEL2L.set_NUMERF_Value(0);
        DHLine.set_COCA_Value("L2");
        DHLine.get_GRTYBLOC_Groupe_Value().set_TYBLO1_Value(bb.getBlockType().toString().substring(1, 2));
        DHLine.get_GRTYBLOC_Groupe_Value().set_TYBLO2_Value(bb.getBlockType().toString().substring(2));
        DHLine.set_FABLOC_Value(this.getParentFabloc());
        DHLine.set_XOPEUR_Value("1");
        return DHLine;
    }

    private EL3V prepCommonDataForGLine(DbdGLine dbdGLine) {
        PacBlockBaseImpl bb = dbdGLine.getBb();
        EL3V GLine = new EL3V();
        EL3V.GRCLEEL cleEL3V = GLine.get_GRCLEEL_Groupe_Value();
        cleEL3V.set_NUBIB_Value(1);
        cleEL3V.set_COBLOC_Value(bb.getName());
        cleEL3V.set_NUMERA_Value(0);
        cleEL3V.set_NUMERB_Value(0);
        cleEL3V.set_NUMERC_Value(0);
        cleEL3V.set_NUMERD_Value(0);
        cleEL3V.set_NUMERE_Value(0);
        cleEL3V.set_NUMERF_Value(0);
        cleEL3V.set_NUOPT_Value("0");
        GLine.set_NUENR_Value("22");
        GLine.set_COCA_Value("V3");
        GLine.get_GRTYBLOC_Groupe_Value().set_TYBLO1_Value(bb.getBlockType().toString().substring(1, 2));
        GLine.get_GRTYBLOC_Groupe_Value().set_TYBLO2_Value(bb.getBlockType().toString().substring(2));
        GLine.set_FABLOC_Value(this.getParentFabloc());
        GLine.set_XOPEUR_Value("1");
        return GLine;
    }

    private EL1L prepLineForBlockBase(EL1L dataBaseBlockDefinition, PacBlockBase aPacBlockBase) {
        dataBaseBlockDefinition.get_GRPR1L_Groupe_Value().set_COBLOC_Value(aPacBlockBase.getName());
        dataBaseBlockDefinition.get_GRPR1L_Groupe_Value().set_LIBLOC_Value(aPacBlockBase.getLabel());
        dataBaseBlockDefinition.get_GRPR1L_Groupe_Value().set_NOMEXT_Value(aPacBlockBase.getExternalName());
        dataBaseBlockDefinition.get_GRPR1L_Groupe_Value().get_GRTYBLOC_Groupe_Value().set_TYBLO1_Value(aPacBlockBase.getBlockType().toString().substring(1, 2));
        dataBaseBlockDefinition.get_GRPR1L_Groupe_Value().get_GRTYBLOC_Groupe_Value().set_TYBLO2_Value(aPacBlockBase.getBlockType().toString().substring(2));
        dataBaseBlockDefinition.get_GRPR1L_Groupe_Value().set_NULIG_Value(0);
        dataBaseBlockDefinition.get_GRPR1L_Groupe_Value().set_FABLOC_Value(this.getParentFabloc());
        dataBaseBlockDefinition.get_GRPR1L_Groupe_Value().set_NOMEXS_Value(aPacBlockBase.getSchemaName());
        dataBaseBlockDefinition.get_GRPR1L_Groupe_Value().get_GRNUVERB_Groupe_Value().set_NUVERS_Value(0);
        return dataBaseBlockDefinition;
    }

    private EL3L prepLineForDCLine(EL3L DCLine, PacDCLine pacDCLine) {
        PacBlockBaseImpl bb = (PacBlockBaseImpl)pacDCLine.getOwner();
        DataAggregateImpl daSegment = (DataAggregateImpl)pacDCLine.getSegment();
        EL3L.GRPR3L el3lPR3l = DCLine.get_GRPR3L_Groupe_Value();
        EL3L.GRPR3L.GRIL3 el3lIL3 = el3lPR3l.get_GRIL3_Groupe_Value();
        el3lIL3.set_COBLOC_Value(bb.getName());
        el3lIL3.set_NULIG_Value(DCLine.get_GRCLEEL_Groupe_Value().get_NUMERC_Int_Value());
        el3lPR3l.set_TYSRC_Value(PacTransformationCodasylRecordType.transformCodasylRecordType((PacCodasylRecordTypeValues)pacDCLine.getNetworkRecordType()));
        el3lPR3l.set_COMME_Value(pacDCLine.getCommentOrName());
        el3lPR3l.set_RECSET_Value(pacDCLine.getDataBaseObjectName());
        if (daSegment != null) {
            el3lPR3l.set_COSEGP_Value(daSegment.getName());
        }
        el3lPR3l.set_GRCOMER_Value(pacDCLine.getMethodCode());
        if (pacDCLine.getChild() != null) {
            DataAggregateImpl daChild = (DataAggregateImpl)pacDCLine.getChild();
            el3lPR3l.set_COSEGF_Value(daChild.getName());
        }
        if (pacDCLine.getNumberOccurrencesSet() == -1) {
            el3lPR3l.set_NBCAZ_Value(0);
        } else {
            el3lPR3l.set_NBCAZ_Value(pacDCLine.getNumberOccurrencesSet());
        }
        return DCLine;
    }

    private EL2L prepLineForDHLine(EL2L DHLine, PacDHLine pacDHLine) {
        PacBlockBaseImpl bb = (PacBlockBaseImpl)pacDHLine.getOwner();
        DataAggregateImpl daSegment = (DataAggregateImpl)pacDHLine.getSegment();
        DataAggregateImpl daParent = (DataAggregateImpl)pacDHLine.getParent();
        EL2L.GRPR2L el2lPR2L = DHLine.get_GRPR2L_Groupe_Value();
        EL2L.GRPR2L.GRENREG el2lENREG = el2lPR2L.get_GRENREG_Groupe_Value();
        el2lENREG.get_GRIL2_Groupe_Value().set_COBLOC_Value(bb.getName());
        el2lENREG.get_GRIL2_Groupe_Value().set_NULIG_Value(DHLine.get_GRCLEEL_Groupe_Value().get_NUMERC_Value());
        if (daSegment != null) {
            el2lENREG.set_COSEGF_Value(daSegment.getName());
        }
        if (daParent != null) {
            el2lENREG.set_COSEGP_Value(daParent.getName());
        }
        if (pacDHLine.getPsbOrPcb() != null) {
            el2lENREG.set_COPCB_Value(pacDHLine.getPsbOrPcb().getName());
        } else {
            el2lENREG.set_COPCB_Value(pacDHLine.getRelationCode());
        }
        if (pacDHLine.getEstimatedNumberOfLinks() == -1) {
            el2lENREG.set_NBCAZ_Value(0);
        } else {
            el2lENREG.set_NBCAZ_Value(pacDHLine.getEstimatedNumberOfLinks());
        }
        el2lENREG.set_COMME_Value(pacDHLine.getCommentRelatKeyLength());
        el2lENREG.set_FABLOC_Value(this.getParentFabloc());
        if (DHLine.get_NUENR_Value().equals("15") || DHLine.get_NUENR_Value().equals("30")) {
            el2lENREG.set_FABLOC_Value(this.getFabloc(((PacBlockBaseImpl)pacDHLine.getOwner()).getBlockType().getLiteral().substring(1)));
        }
        el2lENREG.set_INDCLE_Value(pacDHLine.getKeyIndicatorOrOption());
        if (daSegment != null) {
            PacDataAggregate pacDag = this.searchPacExtension(daSegment);
            if (DHLine.get_NUENR_Value().equals("10") || DHLine.get_NUENR_Value().equals("15")) {
                DHLine.set_SEIMSF_Value(this.getStructureCode(pacDag));
                if (DHLine.get_NUENR_Value().equals("15")) {
                    el2lENREG.get_GRIL2_Groupe_Value().set_NULIG_Value(DHLine.get_GRCLEEL_Groupe_Value().get_NUMERF_Value());
                }
            } else if (DHLine.get_NUENR_Value().equals("EB")) {
                el2lENREG.set_COMME_Value(this.getStructureCode(pacDag));
            } else if (DHLine.get_NUENR_Value().equals("EN")) {
                el2lENREG.set_NBCAZ_Value(0);
                if (pacDag != null && pacDag.getOccurencesNumber() != -1) {
                    el2lENREG.set_NBCAZ_Value(pacDag.getOccurencesNumber());
                } else {
                    String occValue = this.searchOptionInComment(pacDHLine.getCommentRelatKeyLength(), this.occOption);
                    if (occValue.trim().length() > 0) {
                        el2lENREG.set_NBCAZ_Value(occValue);
                    }
                }
            }
        }
        if (daParent != null && (DHLine.get_NUENR_Value().equals("12") || DHLine.get_NUENR_Value().equals("15"))) {
            DHLine.set_SEIMSP_Value(this.getStructureCode(this.searchPacExtension(daParent)));
        }
        return DHLine;
    }

    private EL3V prepLineForGLine(EL3V GLine, DbdGLine dbdGLine, boolean isGCLine, boolean isGOLine, boolean isGGLine) {
        if (isGGLine) {
            GLine.get_GRSYNPA_Groupe_Value().set_LITAC_Value(dbdGLine.getDescription());
            if (this.getParentFabloc().equals("M")) {
                GLine.get_GRSYNPA_Groupe_Value().set_LITAC_Value(dbdGLine.getDescription().toUpperCase());
            }
            GLine.set_DOCAP_Value(dbdGLine.getLineType());
            GLine.get_GRCLEEL_Groupe_Value().set_NUMERA_Value(dbdGLine.getLineNb());
            GLine.get_GRCLEEL_Groupe_Value().set_NUMERB_Value(dbdGLine.getSubLineNb());
            if (dbdGLine.geteContainer() != null && (dbdGLine.geteContainer() instanceof PacDHLine || dbdGLine.geteContainer() instanceof PacDCLine)) {
                GLine.get_GRCLEEL_Groupe_Value().set_NUMERB_Value(0);
                GLine.get_GRCLEEL_Groupe_Value().set_NUMERC_Value(this.nuliDH);
                GLine.get_GRCLEEL_Groupe_Value().set_NUMERD_Value(dbdGLine.getLineNb());
                GLine.get_GRCLEEL_Groupe_Value().set_NUMERE_Value(dbdGLine.getSubLineNb());
                GLine.get_GRCLEEL_Groupe_Value().set_NUMERF_Value(0);
                if (dbdGLine.geteContainer() instanceof PacDHLine) {
                    if (this.getParentFabloc().equals("H") || this.getParentFabloc().equals("P")) {
                        GLine.get_GRCLEEL_Groupe_Value().set_NUMERA_Value(700);
                    } else if (this.getParentFabloc().equals("M")) {
                        GLine.get_GRCLEEL_Groupe_Value().set_NUMERA_Value(100);
                        GLine.get_GRCLEEL_Groupe_Value().set_NUMERB_Value(this.nuliDH);
                        GLine.get_GRCLEEL_Groupe_Value().set_NUMERC_Value(dbdGLine.getLineNb());
                        GLine.get_GRCLEEL_Groupe_Value().set_NUMERD_Value(0);
                        GLine.get_GRCLEEL_Groupe_Value().set_NUOPT_Value("");
                        GLine.set_DOCAP_Value("");
                    } else {
                        GLine.get_GRCLEEL_Groupe_Value().set_NUMERA_Value(100);
                        GLine.get_GRCLEEL_Groupe_Value().set_NUMERB_Value(this.nuliDH);
                        GLine.get_GRCLEEL_Groupe_Value().set_NUMERC_Value(dbdGLine.getLineNb());
                        GLine.get_GRCLEEL_Groupe_Value().set_NUMERD_Value(0);
                    }
                } else if (this.getParentFabloc().equals("D")) {
                    GLine.get_GRCLEEL_Groupe_Value().set_NUMERA_Value(this.nuliDH);
                    GLine.get_GRCLEEL_Groupe_Value().set_NUMERB_Value(dbdGLine.getLineNb());
                    GLine.get_GRCLEEL_Groupe_Value().set_NUMERC_Value(0);
                    GLine.get_GRCLEEL_Groupe_Value().set_NUMERD_Value(dbdGLine.getSubLineNb());
                    GLine.get_GRCLEEL_Groupe_Value().set_NUMERE_Value(0);
                    GLine.get_GRCLEEL_Groupe_Value().set_NUMERF_Value(0);
                    GLine.get_GRCLEEL_Groupe_Value().set_NUOPT_Value("");
                } else {
                    GLine.get_GRCLEEL_Groupe_Value().set_NUMERA_Value(this.getLineNbForCodasylBlock((PacDCLine)dbdGLine.geteContainer()));
                }
            }
        }
        return GLine;
    }

    private EL01 prepLineForLibrary(EL01 dataBaseBlockLibrary, PacLibrary lib) {
        EL01.GRPR01 el01PR01 = dataBaseBlockLibrary.get_GRPR01_Groupe_Value();
        EL01.GRPR01.GRNOBIB7 el01NOBIB7 = el01PR01.get_GRNOBIB7_Groupe_Value();
        this.setLibName(lib.getName());
        el01NOBIB7.set_APPLI_Value(lib.getName());
        el01NOBIB7.set_LIBIB_Value(lib.getLabel());
        el01NOBIB7.set_INVDA_Value("I");
        el01NOBIB7.set_CARVE_Value(lib.getCobolType().getName().substring(1));
        el01NOBIB7.set_NLPAG_Value("60");
        el01NOBIB7.set_SUPSA_Value("O");
        el01NOBIB7.set_SUPCO_Value("O");
        el01NOBIB7.set_R7_Value("A");
        el01NOBIB7.set_LANGA_Value(String.valueOf(lib.getGeneratedLanguage()).substring(1));
        this.setVariant(lib.getCobolType().getName().charAt(1));
        el01NOBIB7.set_VARIA_Value(String.valueOf(this.getVariant()));
        el01NOBIB7.set_TYPRO_Value("P");
        el01NOBIB7.set_APPLIC_Value(lib.getName());
        el01NOBIB7.set_R8_Value("A");
        el01NOBIB7.set_NIVEAU_Value("4");
        el01NOBIB7.set_ETABI_Value("1");
        el01NOBIB7.set_CVEXT_Value("1");
        el01NOBIB7.set_QUOTE_Value(String.valueOf(lib.getAlphanumericDelimiter()));
        el01NOBIB7.set_FORDA_Value(String.valueOf(lib.getGeneratedDateFormat()).substring(1));
        el01NOBIB7.set_DECPO_Value(String.valueOf(lib.getDecimalPointDelimiter()));
        el01NOBIB7.set_VARIB_Value(String.valueOf(lib.getMapType()).substring(1));
        el01NOBIB7.set_COFOR_Value(" ");
        el01NOBIB7.set_DACTYR_Value(String.valueOf(lib.getCenturySystemDate()));
        el01NOBIB7.set_DACTYV_Value(String.valueOf(lib.getCenturyReferenceYear()));
        EL01.GRSESSI ke01SESSI = dataBaseBlockLibrary.get_GRSESSI_Groupe_Value();
        ke01SESSI.set_NUSES_Value(9999);
        ke01SESSI.set_NSVER_Value(0);
        String day = "00" + String.valueOf(GregorianCalendar.getInstance().get(5));
        String month = "00" + String.valueOf(GregorianCalendar.getInstance().get(2) + 1);
        Object year = "00" + String.valueOf(GregorianCalendar.getInstance().get(1));
        year = ((String)year).substring(((String)year).length() - 2);
        String squelLang = lib.getSkeletonLanguage().getLiteral().substring(1);
        String todayDate = squelLang.equals("EN") ? month.substring(month.length() - 2) + "/" + day.substring(day.length() - 2) + "/" + ((String)year).substring(((String)year).length() - 2) : day.substring(day.length() - 2) + "/" + month.substring(month.length() - 2) + "/" + ((String)year).substring(((String)year).length() - 2);
        dataBaseBlockLibrary.set_DATE_Value(todayDate);
        dataBaseBlockLibrary.set_CTRAN_Value(lib.getLocation());
        return dataBaseBlockLibrary;
    }

    private String searchOptionInComment(String comment, String option) {
        String newComment;
        String val = "";
        if (comment.length() > 0 && (newComment = comment.toUpperCase()).contains(option) && (val = newComment.substring(newComment.indexOf(option) + 3, newComment.length())).contains(" ")) {
            val = val.substring(0, val.indexOf(" "));
        }
        return val;
    }

    private PacDataAggregate searchPacExtension(DataAggregateImpl daSegment) {
        PacDataAggregate pacDag = null;
        EList extensions = daSegment.getExtensions();
        int i = 0;
        while (i < extensions.size()) {
            Object obj = extensions.get(i);
            if (obj instanceof PacDataAggregate) {
                pacDag = (PacDataAggregate)obj;
                break;
            }
            ++i;
        }
        return pacDag;
    }

    private String getStructureCode(PacDataAggregate pacDag) {
        String structureCode = "";
        if (pacDag != null) {
            structureCode = pacDag.getStructureCode().trim().length() > 0 ? pacDag.getStructureCode().substring(1) : (pacDag.getStructureCodeValue().trim().length() > 0 ? pacDag.getStructureCodeValue().substring(1) : pacDag.getOwner().getName());
            int start = 0;
            int end = structureCode.length();
            if (structureCode.startsWith(String.valueOf('\''))) {
                start = 1;
            }
            if (structureCode.endsWith(String.valueOf('\''))) {
                --end;
            }
            structureCode = structureCode.substring(start, end);
        }
        return structureCode;
    }

    public void setLibName(String libName) {
        this.libName = libName;
    }

    public void setNameOfProject(String projectName) {
        this.nameOfProject = projectName;
    }

    private void setNumer(int numer) {
        this.numer = numer;
    }

    public void setLastGG(Boolean isLastGG) {
        this.isLastGG = isLastGG;
    }

    private int getNumer() {
        return this.numer;
    }

    public char getVariant() {
        return this.variant;
    }

    private boolean isASchemaBlockType(PacBlockBaseTypeValues blockType) {
        return blockType.getLiteral().endsWith("1") || blockType.getValue() == 10 || blockType.getValue() == 14;
    }

    private boolean isLastGG() {
        return this.isLastGG;
    }

    public void setVariant(char variant) {
        this.variant = variant;
    }

    private void writeEnregEL1L(PacBlockBase aPacBlockBase, String nuenr) {
        EL1L dataBaseBlockDefinition = this.prepCommonDataForBlockBase(aPacBlockBase);
        dataBaseBlockDefinition.set_NUENR_Value(nuenr);
        dataBaseBlockDefinition = this.prepLineForBlockBase(dataBaseBlockDefinition, aPacBlockBase);
        int numera = 100;
        String xopeur = "1";
        if (nuenr.equals("BZ")) {
            numera = 50;
        } else if (nuenr.equals("BC")) {
            numera = 100;
            dataBaseBlockDefinition.get_GRCLEEL_Groupe_Value().set_NUMERC_Value(100);
        } else {
            switch (Integer.parseInt(nuenr)) {
                case 3: {
                    numera = 120;
                    xopeur = "0";
                    break;
                }
                case 4: {
                    numera = 300;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    numera = 900;
                    break;
                }
                case 8: {
                    numera = 920;
                    xopeur = "0";
                    break;
                }
                case 23: {
                    numera = 80;
                    break;
                }
                case 24: {
                    numera = 200;
                    break;
                }
                case 25: {
                    numera = 300;
                    break;
                }
                case 26: {
                    numera = 400;
                    break;
                }
                case 27: {
                    numera = 500;
                    break;
                }
                case 28: {
                    numera = 600;
                    if (!aPacBlockBase.getBlockType().equals(PacBlockBaseTypeValues._M3_LITERAL)) break;
                    numera = 700;
                    break;
                }
                case 29: {
                    numera = 700;
                    if (!aPacBlockBase.getBlockType().equals(PacBlockBaseTypeValues._M3_LITERAL)) break;
                    numera = 600;
                    break;
                }
                case 30: {
                    numera = 140;
                    xopeur = "0";
                    break;
                }
                case 32: {
                    numera = 980;
                    break;
                }
                case 34: {
                    numera = 550;
                    break;
                }
                case 35: {
                    numera = 650;
                    break;
                }
                case 36: {
                    numera = 750;
                    break;
                }
                case 40: {
                    numera = 120;
                    xopeur = "0";
                }
            }
        }
        if (aPacBlockBase.getBlockType().equals(PacBlockBaseTypeValues._S1_LITERAL) || aPacBlockBase.getBlockType().equals(PacBlockBaseTypeValues._S3_LITERAL)) {
            xopeur = "0";
        }
        if (aPacBlockBase.getBlockType().equals(PacBlockBaseTypeValues._TD_LITERAL)) {
            dataBaseBlockDefinition.set_COCA_Value("");
        }
        dataBaseBlockDefinition.get_GRCLEEL_Groupe_Value().set_NUMERA_Value(numera);
        dataBaseBlockDefinition.set_XOPEUR_Value(xopeur);
        this.dataBlockBaseLines.add(dataBaseBlockDefinition);
    }

    private void writeEnregEL2L(PacDHLine aPacDHLine, String nuenr) {
        EL2L DHLine = this.prepCommonDataForDHLine(aPacDHLine);
        DHLine.set_NUENR_Value(nuenr);
        DHLine = this.prepLineForDHLine(DHLine, aPacDHLine);
        String xopeur = "1";
        int numera = DHLine.get_GRCLEEL_Groupe_Value().get_NUMERA_Int_Value();
        int numerd = DHLine.get_GRCLEEL_Groupe_Value().get_NUMERD_Int_Value();
        if (nuenr.trim().length() == 0) {
            numera = 300;
            numerd = 0;
            DHLine.get_GRCLEEL_Groupe_Value().set_NUMERE_Value(DHLine.get_GRCLEEL_Groupe_Value().get_NUMERC_Int_Value());
            DHLine.get_GRCLEEL_Groupe_Value().set_NUMERC_Value(0);
            DHLine.set_COCA_Value("");
        } else if (nuenr.equals("EB")) {
            numera = 100;
            DHLine.get_GRCLEEL_Groupe_Value().set_NUMERB_Value(100);
            numerd = 0;
        } else {
            switch (Integer.parseInt(nuenr)) {
                case 12: {
                    numerd = 120;
                    xopeur = "0";
                }
            }
        }
        DHLine.set_XOPEUR_Value(xopeur);
        DHLine.get_GRCLEEL_Groupe_Value().set_NUMERA_Value(numera);
        DHLine.get_GRCLEEL_Groupe_Value().set_NUMERD_Value(numerd);
        this.dataBlockBaseLines.add(DHLine);
    }

    private void writeEnregEL3L(PacDCLine aPacDCLine, String nuenr) {
        PacBlockBaseTypeValues blockType = ((PacBlockBaseImpl)aPacDCLine.getOwner()).getBlockType();
        EL3L DCLine = this.prepCommonDataForDCLine(aPacDCLine);
        DCLine.set_NUENR_Value(nuenr);
        DCLine = this.prepLineForDCLine(DCLine, aPacDCLine);
        int numerd = 100;
        String xopeur = "1";
        if (blockType == PacBlockBaseTypeValues._TD_LITERAL) {
            DCLine.set_COCA_Value("");
            DCLine.get_GRCLEEL_Groupe_Value().set_NUMERA_Value(this.nuliDH);
            DCLine.get_GRPR3L_Groupe_Value().get_GRIL3_Groupe_Value().set_NULIG_Value(this.nuliDH);
            if (DCLine.get_NUENR_Value().equals("EB")) {
                DCLine.get_GRCLEEL_Groupe_Value().set_NUMERB_Value(100);
            } else if (DCLine.get_NUENR_Value().equals("FB")) {
                DCLine.get_GRCLEEL_Groupe_Value().set_NUMERB_Value(200);
            } else if (DCLine.get_NUENR_Value().equals("FI")) {
                DCLine.get_GRCLEEL_Groupe_Value().set_NUMERB_Value(300);
            } else if (DCLine.get_NUENR_Value().equals("ZZ")) {
                DCLine.get_GRCLEEL_Groupe_Value().set_NUMERB_Value(999);
                DCLine.set_GRPR3L_Value("");
            }
        } else {
            switch (Integer.parseInt(nuenr)) {
                case 18: {
                    if (aPacDCLine.getNetworkRecordType().getValue() == 3) {
                        numerd = 500;
                        xopeur = "0";
                        break;
                    }
                    numerd = 400;
                    if (blockType.getValue() != 11 && blockType.getValue() != 7 && blockType.getValue() != 10 && blockType.getValue() != 17 && blockType.getValue() != 14) break;
                    xopeur = "0";
                    break;
                }
                case 19: {
                    numerd = 700;
                    if (blockType.getValue() != 17 && blockType.getValue() != 14) break;
                    xopeur = "0";
                    break;
                }
                case 31: {
                    numerd = 300;
                    if (blockType.getValue() != 11 && blockType.getValue() != 13 && blockType.getValue() != 7 && blockType.getValue() != 10 && blockType.getValue() != 17 && blockType.getValue() != 14) break;
                    xopeur = "0";
                    break;
                }
                case 38: {
                    numerd = 80;
                    xopeur = "0";
                    break;
                }
                case 41: {
                    numerd = 500;
                    xopeur = "0";
                }
            }
            if (blockType.equals(PacBlockBaseTypeValues._S1_LITERAL) || blockType.equals(PacBlockBaseTypeValues._S3_LITERAL)) {
                xopeur = "0";
            }
            if (Integer.parseInt(nuenr) != 38 && blockType.equals(PacBlockBaseTypeValues._S3_LITERAL) && aPacDCLine.getNetworkRecordType().getValue() == 3) {
                DCLine.get_GRCLEEL_Groupe_Value().set_NUMERB_Value(100);
            }
            DCLine.set_XOPEUR_Value(xopeur);
            DCLine.get_GRCLEEL_Groupe_Value().set_NUMERD_Value(numerd);
        }
        this.dataBlockBaseLines.add(DCLine);
    }

    private int getInternalLineNb(int nulig, int subLineNb) {
        return nulig * 1000 + subLineNb;
    }

    private class DbdGLine {
        PacBlockBaseImpl bb;
        String description;
        int lineNb;
        int subLineNb;
        String lineType;
        EObject eContainer;

        private DbdGLine() {
        }

        private PacBlockBaseImpl getBb() {
            return this.bb;
        }

        private EObject geteContainer() {
            return this.eContainer;
        }

        private int getLineNb() {
            return this.lineNb;
        }

        private String getDescription() {
            return this.description;
        }

        private String getLineType() {
            return this.lineType;
        }

        private void seteContainer(EObject eContainer) {
            this.eContainer = eContainer;
        }

        private int getSubLineNb() {
            return this.subLineNb;
        }

        private void setBb(PacBlockBaseImpl bb) {
            this.bb = bb;
        }

        private void setDescription(String description) {
            this.description = description;
        }

        private void setLineNb(int lineNb) {
            this.lineNb = lineNb;
        }

        private void setLineType(String lineType) {
            this.lineType = lineType;
        }

        private void setSubLineNb(int subLineNb) {
            this.subLineNb = subLineNb;
        }
    }

    private class SegmentDatas {
        String parent = "";
        int lth = 0;

        private SegmentDatas(String parent, int lth) {
            this.parent = parent;
            this.lth = lth;
        }
    }
}

