/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.generate.dataBaseBlock.generate;

import com.ibm.pdp.engine.IEngineFactory;
import com.ibm.pdp.engine.IGeneratedInfoFactory;
import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.framework.util.PdpUtil;
import com.ibm.pdp.mdl.pacbase.PacBlockBase;
import com.ibm.pdp.pacbase.generate.DefaultPacbaseGenerationImplementation;
import com.ibm.pdp.pacbase.generate.dataBaseBlock.generate.PacToW1ModelDataBaseBlock;
import com.ibm.pdp.pacbase.generate.util.PacbaseLinksEntitiesService;
import com.ibm.pdp.pacbase.generate.util.PacbaseModelService;
import com.ibm.pdp.util.Util;
import java.io.File;

public class DataBlockBaseGenerationNew
extends DefaultPacbaseGenerationImplementation {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private PacBlockBase blockBase;
    private String projet;
    private PacToW1ModelDataBaseBlock w1Model = null;
    private static String w3CmdFile = isUnix ? "/../../script_linux/GCB35.sh" : "/GCB35.cmd";
    private String dbFileName = "";

    public DataBlockBaseGenerationNew(PacBlockBase bb, String dest, String patternName) {
        this.blockBase = bb;
        this.patternName = patternName;
        this.projet = bb.getProject();
        int resolMode = PTEditorService.getResolvingMode();
        PTEditorService.setResolvingMode((int)3);
        this.initNonSQL();
        PTEditorService.setResolvingMode((int)resolMode);
    }

    public PacbaseLinksEntitiesService getReferencedEntities() {
        return this.w1Model.getPacLinksEntitiesService();
    }

    private void initNonSQL() {
        try {
            File f = File.createTempFile("dbd", ".tmp", new File(System.getProperty("java.io.tmpdir")));
            f.deleteOnExit();
            this.dbFileName = f.getAbsolutePath();
            this.findAndGetW1File();
            this.vapCobolGeneration();
            this.transformToGeneratedInfo();
        }
        catch (Exception e) {
            e.printStackTrace();
            Util.rethrow((Throwable)e);
        }
    }

    private void findAndGetW1File() {
        this.w1Model = new PacToW1ModelDataBaseBlock(this.getProject(), this.getBlockBase(), this.patternName);
    }

    private String getProject() {
        return this.projet;
    }

    public PacBlockBase getBlockBase() {
        return this.blockBase;
    }

    protected String[] getCommandLineForgenerator() {
        String[] cmd = new String[]{"", "", "", "", "", "", "", "", "", ""};
        String userdir1 = PacbaseModelService.getInstance().getCommandFileForGeneration("/data/generator").getAbsolutePath();
        cmd[0] = userdir1 + File.separator + w3CmdFile;
        cmd[1] = userdir1;
        cmd[2] = Util.GetRandomString((int)6);
        String tempdir = System.getProperty("java.io.tmpdir");
        int end = tempdir.length();
        cmd[3] = isUnix ? tempdir : tempdir.substring(0, --end);
        cmd[4] = this.dbFileName;
        cmd[5] = this.w1Model.getW1ResultFile().getAbsolutePath();
        String squelLang = "EN";
        if (this.blockBase != null) {
            squelLang = this.blockBase.getSkeletonLanguage().getLiteral().substring(1);
        }
        cmd[6] = squelLang;
        cmd[7] = userdir1.substring(0, 2);
        return cmd;
    }

    private void transformToGeneratedInfo() {
        try {
            String generated = DataBlockBaseGenerationNew.ReadFileContents((String)this.dbFileName);
            IEngineFactory engineFactory = PdpUtil.newEngineFactory();
            IGeneratedInfoFactory genInfoFactory = engineFactory.newGeneratedInfoFactory();
            genInfoFactory.beginTag(this.blockBase.getName());
            genInfoFactory.appendText((CharSequence)generated);
            genInfoFactory.endTag();
            this.generatedInfo = genInfoFactory.createGeneratedInfo();
            this.generatedInfo.setProperty("pattern", "com.ibm.pdp.pacbase.databaseblock");
            this.generatedInfo.setProperty("ReconcileMode", "NoReconcile");
        }
        catch (Exception e) {
            e.printStackTrace();
            Util.rethrow((Throwable)e);
        }
    }
}

