/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.folderview.pattern;

import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.framework.interfaces.IGeneratorLauncher;
import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.kernel.DataAggregateDescription;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.impl.FillerImpl;
import com.ibm.pdp.mdl.pacbase.PacAbstractNode;
import com.ibm.pdp.mdl.pacbase.PacChildNode;
import com.ibm.pdp.mdl.pacbase.PacDialogFolderView;
import com.ibm.pdp.mdl.pacbase.PacFolder;
import com.ibm.pdp.mdl.pacbase.PacFolderView;
import com.ibm.pdp.mdl.pacbase.PacRootNode;
import com.ibm.pdp.pacbase.folderview.generator.FolderViewGeneratorLauncher;
import com.ibm.pdp.pacbase.folderview.pattern.Messages;
import com.ibm.pdp.pacbase.generator.AbstractPacbasePattern;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class FolderViewPattern
extends AbstractPacbasePattern {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String PAC_EXTENSION = ".pacfolderview";
    Map<String, PacAbstractNode> allFolderNodesMap = new HashMap<String, PacAbstractNode>();

    public String getName() {
        return "com.ibm.pdp.pacbase.folderview.proxy";
    }

    public boolean canGenerate(String entryPoint) {
        if (!this.isOsSupported() || !entryPoint.endsWith(PAC_EXTENSION)) {
            return false;
        }
        RadicalEntity re = PTEditorService.getSharedResource((IPath)new Path(entryPoint));
        if (re instanceof PacFolderView) {
            PacFolderView generationFolderView = (PacFolderView)re;
            this.setListNodeForFolder(generationFolderView);
            for (String selectedNodeForFolderView : generationFolderView.getComposition()) {
                PacRootNode rootNode;
                PacAbstractNode node = this.allFolderNodesMap.get(selectedNodeForFolderView);
                if (!(node instanceof PacRootNode) || (rootNode = (PacRootNode)node).getLogicalView() == null) continue;
                DataAggregate da = rootNode.getLogicalView();
                DataAggregateDescription kDataAggregateDescription = (DataAggregateDescription)da.getDataDescription();
                for (Object objDCImpl : kDataAggregateDescription.getComponents()) {
                    if (!(objDCImpl instanceof FillerImpl)) continue;
                    return false;
                }
            }
            for (String selectedNodeForFolderView : generationFolderView.getComposition()) {
                PacAbstractNode node = this.allFolderNodesMap.get(selectedNodeForFolderView);
                if (!(node instanceof PacChildNode)) continue;
                PacChildNode nodeC = (PacChildNode)node;
                if (nodeC.getLogicalView() != null) {
                    DataAggregate da = nodeC.getLogicalView();
                    DataAggregateDescription kDataAggregateDescription = (DataAggregateDescription)da.getDataDescription();
                    for (Object objDCImpl : kDataAggregateDescription.getComponents()) {
                        if (!(objDCImpl instanceof FillerImpl)) continue;
                        return false;
                    }
                }
                for (PacChildNode nodeC_Level2 : nodeC.getChildNodes()) {
                    if (!(nodeC_Level2 instanceof PacChildNode) || nodeC_Level2.getLogicalView() == null) continue;
                    DataAggregate daC_Level2 = nodeC_Level2.getLogicalView();
                    DataAggregateDescription kDataAggregateDescriptionC_Level2 = (DataAggregateDescription)daC_Level2.getDataDescription();
                    for (Object objDCImplC_Level2 : kDataAggregateDescriptionC_Level2.getComponents()) {
                        if (!(objDCImplC_Level2 instanceof FillerImpl)) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public String getGenerationMenuName() {
        return Messages.Pattern_GENERATION;
    }

    public IGeneratorLauncher getGeneratorLauncher() {
        return new FolderViewGeneratorLauncher(this.getName());
    }

    protected void setListNodeForFolder(PacFolderView generationFolderView) {
        PacFolder folder = null;
        if (generationFolderView.getFolder() != null) {
            folder = generationFolderView.getFolder();
        } else {
            PacDialogFolderView pdfv = generationFolderView.getPacDialogFolderView();
            folder = pdfv.getFolder();
        }
        PacRootNode root = folder.getPacRootNode();
        this.allFolderNodesMap.put(root.getNodeCode(), (PacAbstractNode)root);
        for (PacAbstractNode child : root.getChildNodes()) {
            this.allFolderNodesMap.put(child.getNodeCode(), child);
        }
    }
}

