/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.csclient.pattern;

import com.ibm.pdp.engine.IBuilderTag;
import com.ibm.pdp.engine.IGenInfoBuilder;
import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.extension.ITextProcessorExtension;
import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.interfaces.IDesignLink;
import com.ibm.pdp.framework.interfaces.IDesignModelManager;
import com.ibm.pdp.framework.interfaces.IEditorContextualMenuBuilder;
import com.ibm.pdp.framework.interfaces.IGSVContextualMenuBuilder;
import com.ibm.pdp.framework.interfaces.IGeneratorLauncher;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacDialog;
import com.ibm.pdp.mdl.pacbase.PacDialogTypeValues;
import com.ibm.pdp.mdl.pacbase.PacGenerationHeader;
import com.ibm.pdp.mdl.pacbase.PacLibrarySubstitutionGenerationHeader;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.mdl.pacbase.PacSourceInheritanceGenerationHeader;
import com.ibm.pdp.pacbase.csclient.designview.contentprovider.CSClientDesignModelMgr;
import com.ibm.pdp.pacbase.csclient.editors.CSClientPatternEditorContextualMenuBuilder;
import com.ibm.pdp.pacbase.csclient.pattern.Messages;
import com.ibm.pdp.pacbase.csclient.pattern.PacDialogCSClientTextProcessorExtension;
import com.ibm.pdp.pacbase.dialogcommon.generator.ScreenGeneratorLauncher;
import com.ibm.pdp.pacbase.extension.nodesview.CommonGSVContextualMenuBuilder;
import com.ibm.pdp.pacbase.generator.CobolCompare;
import com.ibm.pdp.pacbase.generator.CobolPacbasePattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class PacbaseCSClientPattern
extends CobolPacbasePattern {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2022.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final String SCREEN_GENERATION = Messages.PacbaseCSClientPattern_CLIENT_SCREEN_GENERATION;
    public static final String PAC_CLIENT_EXTENSION = ".pacscreen";

    public ITextProcessorExtension getTextProcessorExtension() {
        return new PacDialogCSClientTextProcessorExtension();
    }

    public IGeneratorLauncher getGeneratorLauncher() {
        return new ScreenGeneratorLauncher(this.getName());
    }

    public String getName() {
        return "com.ibm.pdp.pacbase.csclient";
    }

    public String getVersion() {
        return "1.0.0";
    }

    public IDesignModelManager getDesignModelManager(IDesignLink designLink, String designFileId) {
        return new CSClientDesignModelMgr(designLink, designFileId);
    }

    public IGSVContextualMenuBuilder getGSVContextualMenuBuilder() {
        return new CommonGSVContextualMenuBuilder();
    }

    public IEditorContextualMenuBuilder getEditorContextualMenuBuilder() {
        return new CSClientPatternEditorContextualMenuBuilder();
    }

    public boolean canGenerate(String entryPoint) {
        if (!this.isOsSupported() || !entryPoint.endsWith(PAC_CLIENT_EXTENSION)) {
            return false;
        }
        RadicalEntity re = PTEditorService.getSharedResource((IPath)new Path(entryPoint));
        if (re instanceof PacScreen) {
            PacScreen screen = (PacScreen)re;
            PacDialogTypeValues typeValue = screen.getDialogType();
            if (screen.getDialogType().equals(PacDialogTypeValues._INHERITED_LITERAL)) {
                PacDialog dialog = screen.getDialog();
                if (dialog == null) {
                    PacGenerationHeader header = screen.getGenerationHeader();
                    if (header instanceof PacLibrarySubstitutionGenerationHeader) {
                        PacScreen referencedScreen = (PacScreen)((PacLibrarySubstitutionGenerationHeader)header).getGeneratedRadicalEntity();
                        dialog = referencedScreen.getDialog();
                    } else if (header instanceof PacSourceInheritanceGenerationHeader) {
                        PacScreen referencedScreen = (PacScreen)((PacSourceInheritanceGenerationHeader)header).getGeneratedRadicalEntity();
                        dialog = referencedScreen.getDialog();
                    }
                }
                typeValue = dialog.getDialogType();
            }
            if (typeValue.equals(PacDialogTypeValues._C_LITERAL) || typeValue.equals(PacDialogTypeValues._SC_LITERAL) || typeValue.equals(PacDialogTypeValues._MC_LITERAL)) {
                return true;
            }
        }
        return false;
    }

    public String getGenerationMenuName() {
        return SCREEN_GENERATION;
    }

    public IGeneratedInfo getNewGeneratedInfoForSpecialEquality(IGeneratedInfo genInfoAfterGeneration, String contentBeforeGeneration, String contentAfterGeneration) {
        boolean equivalentCobols = CobolCompare.compare((String)contentBeforeGeneration, (String)contentAfterGeneration);
        if (!equivalentCobols) {
            return null;
        }
        IGeneratedInfo result = PacbaseCSClientPattern.allignConstantsAndDateForClient(genInfoAfterGeneration, contentBeforeGeneration, " PACBASE-CONSTANTS.      ");
        return result;
    }

    public static IGeneratedInfo allignConstantsAndDateForClient(IGeneratedInfo refGenInfo, String specificCobolFile, String constants) {
        int indexOfLastLine;
        String text;
        int indexOfValue;
        String NEW_LINE = PdpTool.determineDelimiterOfV2((CharSequence)specificCobolFile);
        String NEW_LINE_MIA = PdpTool.determineDelimiterOfV2((CharSequence)refGenInfo.getText());
        IGenInfoBuilder gibuild = refGenInfo.toGeneratedInfoBuilder();
        IBuilderTag tag = gibuild.tagFromName("CONSTANTS");
        String lastBeginingLineOfConstantsTag = "";
        if (tag != null && (indexOfValue = (lastBeginingLineOfConstantsTag = (text = tag.getText().toString()).substring((indexOfLastLine = text.lastIndexOf(NEW_LINE_MIA, text.length() - NEW_LINE_MIA.length() - 1)) + NEW_LINE_MIA.length())).indexOf("VALUE")) > 0) {
            lastBeginingLineOfConstantsTag = lastBeginingLineOfConstantsTag.substring(0, indexOfValue + "VALUE".length());
        }
        if (lastBeginingLineOfConstantsTag.trim().length() == 0) {
            return refGenInfo;
        }
        StringBuilder constantBloc = new StringBuilder();
        int const_pac_index = specificCobolFile.indexOf(constants);
        if (const_pac_index != -1) {
            String line;
            int startOfLineIndex = specificCobolFile.lastIndexOf(NEW_LINE, const_pac_index);
            if (startOfLineIndex < 0) {
                return refGenInfo;
            }
            int previousStartOfLine = startOfLineIndex += NEW_LINE.length();
            boolean firstLine = true;
            do {
                int nextLineIndex;
                if ((nextLineIndex = specificCobolFile.indexOf(NEW_LINE, previousStartOfLine)) < 0) {
                    return refGenInfo;
                }
                line = specificCobolFile.substring(previousStartOfLine, nextLineIndex);
                if (line.substring(7, 9).equals("01")) {
                    if (firstLine) {
                        firstLine = false;
                    } else {
                        return refGenInfo;
                    }
                }
                constantBloc.append(line);
                constantBloc.append(NEW_LINE_MIA);
                previousStartOfLine = nextLineIndex + NEW_LINE.length();
            } while (!line.startsWith(lastBeginingLineOfConstantsTag));
        }
        if (constantBloc.length() == 0) {
            return refGenInfo;
        }
        int date_CompiledIndex = specificCobolFile.indexOf("DATE-COMPILED");
        if (date_CompiledIndex < 0) {
            return refGenInfo;
        }
        int startOfLineIndex = specificCobolFile.lastIndexOf(NEW_LINE, date_CompiledIndex);
        if (startOfLineIndex < 0) {
            return refGenInfo;
        }
        int nextLineIndex = specificCobolFile.indexOf(NEW_LINE, startOfLineIndex += NEW_LINE.length());
        String date = String.valueOf(specificCobolFile.substring(startOfLineIndex, nextLineIndex)) + NEW_LINE_MIA;
        if (tag != null) {
            tag.setText((CharSequence)constantBloc);
        }
        if ((tag = gibuild.tagFromName("DATE-COMPILED")) != null) {
            tag.setText((CharSequence)date);
        }
        return gibuild.toGeneratedInfo();
    }
}

