/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.csclient.extension.nodesview;

import com.ibm.pdp.framework.interfaces.IGeneratedCodeStructureTreeView;
import com.ibm.pdp.framework.views.GeneratedCodeStructureTreeView;
import com.ibm.pdp.pacbase.csclient.extension.nodesview.CSClientNodesViewMessages;
import com.ibm.pdp.pacbase.dialogs.FunctionDialog;
import com.ibm.pdp.pacbase.extension.ProcedureLineConstants;
import org.eclipse.jface.action.Action;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ShowFunction
extends Action
implements ProcedureLineConstants {
    GeneratedCodeStructureTreeView _view;
    private String selectedFunctionCode = "";
    private String selectedSubFunctionCode = "";
    private int position;
    private int textNodeBeginIndex;
    private int textNodeEndIndex;
    private int offset;
    private int levelToDisplay;
    private String visibleTag;
    private String detailText;
    private boolean subAtFirstLevel;
    private boolean forgetSubFunction;
    private boolean activateIndexes;
    private boolean useDetailForDialogTitle;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2011.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public ShowFunction(IGeneratedCodeStructureTreeView view, int pos) {
        this._view = (GeneratedCodeStructureTreeView)view;
        this.position = pos;
        this.textNodeBeginIndex = -1;
        this.textNodeEndIndex = -1;
        this.offset = -1;
        this.levelToDisplay = 5;
        this.visibleTag = "";
        this.detailText = "";
        this.subAtFirstLevel = false;
        this.forgetSubFunction = false;
        this.activateIndexes = false;
        this.useDetailForDialogTitle = false;
    }

    public void setDetailedText(String txt) {
        this.detailText = txt;
    }

    public void setVisibleTag(String txt) {
        this.visibleTag = txt;
    }

    public void setLevel(int l) {
        this.levelToDisplay = l;
    }

    public void setCodes(String code, String subCode) {
        this.selectedFunctionCode = code;
        this.selectedSubFunctionCode = subCode;
    }

    public void setTextNodeIndexes(int bi, int ei) {
        this.textNodeBeginIndex = bi;
        this.textNodeEndIndex = ei;
    }

    public void setOffset(int off) {
        this.offset = off;
    }

    public void setSubAtFirstLevel() {
        this.subAtFirstLevel = true;
    }

    public void forgetSubFunction() {
        this.forgetSubFunction = true;
    }

    public void activateIndexes() {
        this.activateIndexes = true;
    }

    public String getText() {
        if (this.position == 3) {
            return CSClientNodesViewMessages.ADD_FUNCTION_BEGIN;
        }
        String ret = this.getNotBeginText();
        Object[] args = new Object[]{this.visibleTag};
        return NLS.bind((String)ret, (Object[])args);
    }

    public void useDetailForDialogTitle() {
        this.useDetailForDialogTitle = true;
    }

    private String getNotBeginText() {
        if (this.position == 0 && (this.selectedSubFunctionCode.length() == 0 || this.subAtFirstLevel)) {
            return CSClientNodesViewMessages.ADD_FUNCTION_BEFORE;
        }
        if (this.position == 0 && this.selectedSubFunctionCode.length() > 0) {
            return CSClientNodesViewMessages.ADD_SUB_FUNCTION_BEFORE;
        }
        if (this.position == 1 && (this.selectedSubFunctionCode.length() == 0 || this.subAtFirstLevel)) {
            return CSClientNodesViewMessages.MODIFY_FUNCTION;
        }
        if (this.position == 1 && this.selectedSubFunctionCode.length() > 0) {
            return CSClientNodesViewMessages.MODIFY_SUB_FUNCTION;
        }
        if (this.position == 2 && (this.selectedSubFunctionCode.length() == 0 || this.subAtFirstLevel)) {
            return CSClientNodesViewMessages.ADD_FUNCTION_AFTER;
        }
        if (this.position == 2 && this.selectedSubFunctionCode.length() > 0) {
            return CSClientNodesViewMessages.ADD_SUB_FUNCTION_AFTER;
        }
        if (this.position == 5) {
            return CSClientNodesViewMessages.ADD_FUNCTION;
        }
        if (this.position == 6) {
            return CSClientNodesViewMessages.ADD_SUB_FUNCTION;
        }
        if (this.position == 7) {
            return CSClientNodesViewMessages.INSERT_SUB_FUNCTION_INSIDE;
        }
        return "";
    }

    public void run() {
        IWorkbenchWindow wbWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage wbPage = wbWindow.getActivePage();
        if (wbPage == null) {
            return;
        }
        FunctionDialog dialog = new FunctionDialog(this._view, this.position == 7);
        if (this.position == 0 || this.position == 1 || this.position == 2) {
            dialog.setRelativePosition(this.position);
        } else {
            dialog.setAbsoluteInsertionMode();
        }
        dialog.setLevel(this.levelToDisplay);
        if (this.position == 3) {
            dialog.setAtBeginning();
        }
        if (this.position == 5 && this.selectedSubFunctionCode.length() == 2) {
            dialog.setSubAtFirstLevel();
        }
        if (this.subAtFirstLevel) {
            dialog.setSubAtFirstLevel();
        }
        if (this.forgetSubFunction) {
            dialog.forgetSubFunction();
        }
        if (this.activateIndexes) {
            dialog.activateIndexes();
        }
        dialog.setTextNodeIndexes(this.textNodeBeginIndex, this.textNodeEndIndex);
        if (this.offset != -1) {
            dialog.setOffsets(this.offset, this.offset);
        }
        dialog.findBestNextCodes(this.selectedFunctionCode, this.selectedSubFunctionCode);
        dialog.setDetailedTitle(this.detailText);
        if (this.useDetailForDialogTitle) {
            dialog.useDetailedTitle();
        }
        dialog.open();
        if (dialog.isInsertionPositionFound() && dialog.getReturnCode() == 0) {
            dialog.insertFunction();
        }
    }
}

