/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.csclient.extension.micropattern;

import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.pacbase.lal.util.GenerationContext;
import com.ibm.pdp.mdl.pacbase.lal.util.PacbaseLalDescription;
import com.ibm.pdp.pacbase.csclient.extension.micropattern.WFCSscreenMicroPatternHandler;
import com.ibm.pdp.pacbase.dialogcommon.extension.micropattern.WFScreenMicroPatternHandler;
import com.ibm.pdp.pacbase.dialogcommon.extension.micropattern.WFScreenSegmentGenerator;
import com.ibm.pdp.pacbase.extension.micropattern.WFGenerationContext;
import com.ibm.pdp.pacbase.extension.micropattern.WFMicroPatternHandler;
import java.util.HashSet;
import java.util.Set;

public class WFCSscreenSegmentGenerator
extends WFScreenSegmentGenerator {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Set<String> valuesToGenerateSign = null;

    protected WFCSscreenSegmentGenerator(DataAggregate aDataAggregate, GenerationContext ctx, WFGenerationContext wfCtx, WFCSscreenMicroPatternHandler handler) {
        super(aDataAggregate, ctx, wfCtx, (WFScreenMicroPatternHandler)handler);
    }

    protected void generateBeforeSegment(StringBuilder result) {
        if (this.wfCtx.getParam_ORG().equals("G")) {
            return;
        }
        if (this.wfCtx.getParam_DES() == 3 && this.wfCtx.getParam_LEV() != 4 && this.wfCtx.getParam_LEV() != 5 && !this.segmentCode.endsWith("00")) {
            result.append("            02            ");
            result.append(this.segmentCode);
            result.append("T.").append(this.newLine);
        }
        if (this.wfCtx.getParam_ORG().equals("Q") || this.wfCtx.getParam_ORG().equals("N")) {
            result.append("       01               ");
            result.append(this.segmentCode).append(".").append(this.newLine);
        }
        if (this.wfCtx.getParam_ORG().equals("P")) {
            result.append(WFMicroPatternHandler.generateExecBeginSql()).append(this.newLine);
        }
        super.generateBeforeSegment(result);
    }

    protected void generateAfterSegment(StringBuilder result, boolean first) {
        super.generateAfterSegment(result, first);
        if (this.wfCtx.getParam_ORG().equals("P")) {
            result.append(WFMicroPatternHandler.generateExecEndSql()).append(this.newLine);
        }
    }

    protected StringBuilder generate(boolean first) {
        if (this.wfCtx.getParam_ORG().equals("G")) {
            return new StringBuilder();
        }
        return super.generate(first);
    }

    public StringBuilder generateSpecificDesc() {
        return super.generateSpecificDesc();
    }

    protected StringBuilder generateSQLVariables(PacbaseLalDescription pld) {
        return new StringBuilder();
    }

    public StringBuilder generateVariablesInPFkeyTag() {
        return new StringBuilder();
    }

    public StringBuilder generateVariablesInWSSContinuationTag() {
        StringBuilder result = new StringBuilder();
        this.firstTime = true;
        if (this.wfCtx.getParam_ORG().equals("2") || this.wfCtx.getParam_ORG().equals("P")) {
            result.append((CharSequence)this.generateSpecificDesc());
        }
        return result;
    }

    protected String getComments(PacbaseLalDescription pld) {
        String comments = super.getComments(pld);
        if (this.wfCtx.getParam_ORG().equals("P") && comments.equals("BINARY")) {
            comments = "COMPUTATIONAL";
        }
        return comments;
    }

    protected String getSQLComplement() {
        if (this.wfCtx.getParam_ORG().equals("2") || this.wfCtx.getParam_ORG().equals("9") || this.wfCtx.getParam_ORG().equals("H")) {
            return "BINARY";
        }
        return super.getSQLComplement();
    }

    protected Set<String> getValuesToGenerateSign() {
        if (this.valuesToGenerateSign == null) {
            String[] valuesTab = new String[]{"2C", "23", "SC", "S3", "BC", "B3", "BG", "PC", "PJ", "PP", "P5", "P6", "PT", "PQ", "P3", "P8", "P9", "PW", "YC", "YD", "Y1", "YX", "YG", "Y3", "AC", "A3", "UJ", "U0", "UW", "UF", "U1", "4C", "43", "4W", "4F"};
            this.valuesToGenerateSign = new HashSet<String>();
            String[] stringArray = valuesTab;
            int n = valuesTab.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                this.valuesToGenerateSign.add(value);
                ++n2;
            }
        }
        return this.valuesToGenerateSign;
    }

    protected boolean isDataToGenerate(PacbaseLalDescription pld) {
        if (this.wfCtx.getParam_ORG().equals("P") || this.wfCtx.getParam_ORG().equals("2")) {
            if (!this.firstTime && !pld.getChildren().isEmpty()) {
                return false;
            }
            if (this.wfCtx.getParam_ORG().equals("P") && pld.getRedefines()) {
                return false;
            }
        }
        if (this.wfCtx.getParam_ORG().equals("2") && !this.wfCtx.isDescrAllOption() && (!this.firstTime && !pld.getChildren().isEmpty() || pld.getRedefines() || this.isDataInRedefines(pld))) {
            return false;
        }
        return !this.wfCtx.isGlobalContrib() || this.wfCtx.getParam_ORG().trim().length() != 0;
    }

    protected boolean isDataWithVariableLength(PacbaseLalDescription pld) {
        if (this.wfCtx.getParam_ORG().equals("Q") || this.wfCtx.getParam_ORG().equals("N") || this.wfCtx.getParam_ORG().equals("H")) {
            return false;
        }
        return super.isDataWithVariableLength(pld);
    }

    protected boolean isValueToGenerate(PacbaseLalDescription pld) {
        if (this.isAnOccursData(pld) && this.generationContext.getPatternVariant() != '3' && this.generationContext.getPatternVariant() != 'Q') {
            return false;
        }
        return super.isValueToGenerate(pld);
    }

    protected StringBuilder generateDLISegmentSSA(String segmentCode, boolean isSegment, String level) {
        return new StringBuilder();
    }
}

