/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.csclient.extension.micropattern;

import com.ibm.pdp.engine.IMicroPattern;
import com.ibm.pdp.engine.IMicroPatternProcessingContext;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacColorAttributeValues;
import com.ibm.pdp.mdl.pacbase.PacDialog;
import com.ibm.pdp.mdl.pacbase.PacGeneratedSkeletonLanguageValues;
import com.ibm.pdp.mdl.pacbase.PacIntensityAttributeValues;
import com.ibm.pdp.mdl.pacbase.PacPresentationAttributeValues;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.pacbase.extension.micropattern.AbstractSimpleMicroPatternHandler;
import com.ibm.pdp.pacbase.extension.micropattern.DescriptionContentAssistMP;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.emf.ecore.EObject;

public class ERUMicroPatternHandler
extends AbstractSimpleMicroPatternHandler {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2019.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String MPERU_IDENTIFIER = "ERU";
    private static final String ERU11 = "MOVE       ";
    private static final String ERU12 = "              U";
    private static final String ERU13 = "   TO   ";
    private static final String ERU2 = "PERFORM     F81UT THRU F81UT-FN";
    private static final String MOVE_BEFORE_DELIM = "MOVE    ";
    private static final String TO_A_AFTER_DELIM = "    TO A-";
    private static final String OCCURS_4 = " (4)";
    private static final String OCCURS_1 = " (1)";
    private static final String OCCURS_2 = " (2)";
    private static final String OCCURS_3 = " (3)";

    public String getId() {
        return MPERU_IDENTIFIER;
    }

    public boolean isAnnotationsNeededInMacro() {
        return true;
    }

    public String getDescription() {
        return DescriptionContentAssistMP.ERUMicroPattern_DESCRIPTION;
    }

    protected void handleLocal(IMicroPattern microPattern, StringBuilder contribution) {
        EObject obj;
        IMicroPatternProcessingContext context = microPattern.getProcessingContext();
        if (this.checkStatus(context) && (obj = this.searchReference(microPattern)) instanceof PacScreen) {
            PacScreen screenProgram = (PacScreen)obj;
            PacDialog dialogProgram = (PacDialog)this.searchRadicalEntity(screenProgram.getProject(), screenProgram.getPackage(), screenProgram.getName().substring(0, 2), "pacdialog", microPattern.getProcessingContext());
            String screenCode = screenProgram.getName();
            String endScreenCode = screenCode.substring(2, 6);
            String dialogCode = screenCode.substring(0, 2);
            PacIntensityAttributeValues intensityAtt = screenProgram.getErrFieldIntensityAtt();
            if (intensityAtt.equals(PacIntensityAttributeValues._NONE_LITERAL)) {
                intensityAtt = dialogProgram.getErrFieldIntensityAtt();
            }
            String intensityA = intensityAtt.getLiteral().substring(1, 2);
            PacPresentationAttributeValues presentationAtt = screenProgram.getErrFieldPresentationAtt();
            if (presentationAtt.equals(PacPresentationAttributeValues._NONE_LITERAL)) {
                presentationAtt = dialogProgram.getErrFieldPresentationAtt();
            }
            String presentationA = presentationAtt.getLiteral().substring(1, 2);
            PacColorAttributeValues colorAtt = screenProgram.getErrFieldColorAtt();
            if (colorAtt.equals(PacColorAttributeValues._NONE_LITERAL)) {
                colorAtt = dialogProgram.getErrFieldColorAtt();
            }
            String colorA = colorAtt.getLiteral().substring(1, 2);
            String lib = screenProgram.getGenerationParameter().getName();
            String operandes = this.operandes(microPattern);
            String errorCode = "    ";
            String dataElementCode = " ";
            StringTokenizer st = new StringTokenizer(operandes);
            if (st.hasMoreTokens()) {
                String firstTocken = String.valueOf(st.nextToken()) + "    ";
                errorCode = firstTocken.substring(0, 4);
                if (st.hasMoreTokens() && (dataElementCode = st.nextToken()).length() > 6) {
                    dataElementCode = dataElementCode.substring(0, 6);
                }
            }
            String alphanumeric_Delimiter = ERUMicroPatternHandler.GetProperty_ALPHA_NUMERIC_DELIMITER((IMicroPatternProcessingContext)context);
            contribution.append("           ");
            contribution.append(ERU11);
            contribution.append(alphanumeric_Delimiter);
            contribution.append(dialogCode);
            contribution.append(ERU12);
            contribution.append(errorCode);
            contribution.append(lib);
            contribution.append(alphanumeric_Delimiter);
            contribution.append(ERU13);
            PacGeneratedSkeletonLanguageValues languageCode = ERUMicroPatternHandler.SearchGeneratedSkeletonLanguageFor((RadicalEntity)screenProgram, (IMicroPattern)microPattern);
            if (languageCode == PacGeneratedSkeletonLanguageValues._FR_LITERAL) {
                contribution.append("XCLEF");
            } else {
                contribution.append("XEMKY");
            }
            contribution.append(ERUMicroPatternHandler.GetProperty_NEW_LINE((IMicroPatternProcessingContext)context));
            contribution.append("           ");
            contribution.append(ERU2);
            if (!dataElementCode.equals(" ")) {
                contribution.append(ERUMicroPatternHandler.GetProperty_NEW_LINE((IMicroPatternProcessingContext)context));
                contribution.append("           ");
                contribution.append(MOVE_BEFORE_DELIM);
                contribution.append(alphanumeric_Delimiter);
                contribution.append("Z");
                contribution.append(alphanumeric_Delimiter);
                contribution.append(TO_A_AFTER_DELIM);
                contribution.append(endScreenCode);
                contribution.append("-");
                contribution.append(dataElementCode);
                contribution.append(OCCURS_4);
                contribution.append(ERUMicroPatternHandler.GetProperty_NEW_LINE((IMicroPatternProcessingContext)context));
                contribution.append("           ");
                contribution.append(MOVE_BEFORE_DELIM);
                contribution.append(alphanumeric_Delimiter);
                contribution.append(intensityA);
                contribution.append(alphanumeric_Delimiter);
                contribution.append(TO_A_AFTER_DELIM);
                contribution.append(endScreenCode);
                contribution.append("-");
                contribution.append(dataElementCode);
                contribution.append(OCCURS_1);
                contribution.append(ERUMicroPatternHandler.GetProperty_NEW_LINE((IMicroPatternProcessingContext)context));
                contribution.append("           ");
                contribution.append(MOVE_BEFORE_DELIM);
                contribution.append(alphanumeric_Delimiter);
                contribution.append(presentationA);
                contribution.append(alphanumeric_Delimiter);
                contribution.append(TO_A_AFTER_DELIM);
                contribution.append(endScreenCode);
                contribution.append("-");
                contribution.append(dataElementCode);
                contribution.append(OCCURS_2);
                contribution.append(ERUMicroPatternHandler.GetProperty_NEW_LINE((IMicroPatternProcessingContext)context));
                contribution.append("           ");
                contribution.append(MOVE_BEFORE_DELIM);
                contribution.append(alphanumeric_Delimiter);
                contribution.append(colorA);
                contribution.append(alphanumeric_Delimiter);
                contribution.append(TO_A_AFTER_DELIM);
                contribution.append(endScreenCode);
                contribution.append("-");
                contribution.append(dataElementCode);
                contribution.append(OCCURS_3);
            }
            contribution.append(ERUMicroPatternHandler.GetProperty_NEW_LINE((IMicroPatternProcessingContext)context));
        }
    }

    protected void convertToAttributes(IMicroPattern microPattern, Map<String, Object> parameters) {
        this.convertERUFAmilyToAttributes(microPattern, parameters);
    }

    protected LinkedHashMap<String, String> convertToParameters(IMicroPattern microPattern, String operandes) {
        LinkedHashMap result = this.convertERUFamilyToParameters(microPattern, operandes);
        if (result == null) {
            return result;
        }
        result.putAll(super.convertToParameters(microPattern, operandes));
        return result;
    }
}

