/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.csclient.editors;

import com.ibm.pdp.framework.interfaces.IEditor;
import com.ibm.pdp.pacbase.csclient.editors.CSClientNodesEditorMessages;
import com.ibm.pdp.pacbase.dialogs.FunctionDialog;
import com.ibm.pdp.pacbase.extension.ProcedureLineConstants;
import org.eclipse.jface.action.Action;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ShowFunction
extends Action
implements ProcedureLineConstants {
    private IEditor iEditor;
    private String selectedFunctionCode = "";
    private String selectedSubFunctionCode = "";
    private int startOffset;
    private int endOffset;
    private int position;
    private int detailBeginIndex;
    private int detailEndIndex;
    private int levelToDisplay;
    private String detailText;
    private boolean subAtFirstLevel;
    private int cursorInsert;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2011.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public ShowFunction(IEditor editor, int pos) {
        this.iEditor = editor;
        this.position = pos;
        this.startOffset = -1;
        this.endOffset = -1;
        this.detailBeginIndex = -1;
        this.detailEndIndex = -1;
        this.levelToDisplay = 5;
        this.detailText = "";
        this.subAtFirstLevel = false;
        this.cursorInsert = -1;
    }

    public void setDetailedText(String txt) {
        this.detailText = txt;
    }

    public void setLevel(int l) {
        this.levelToDisplay = l;
    }

    public void setCodes(String code, String subCode) {
        this.selectedFunctionCode = code;
        this.selectedSubFunctionCode = subCode;
    }

    public void setOffsets(int start, int end) {
        this.startOffset = start;
        this.endOffset = end;
    }

    public void setIndexes(int start, int end) {
        this.detailBeginIndex = start;
        this.detailEndIndex = end;
    }

    public void setSubAtFirstLevel() {
        this.subAtFirstLevel = true;
    }

    public void setCursorInsert(int insert) {
        this.cursorInsert = insert;
    }

    public String getText() {
        Object[] objs = new Object[]{this.detailText.length() > 0 ? this.detailText : "F" + this.selectedFunctionCode + this.selectedSubFunctionCode};
        if (this.position == 3) {
            if (this.detailText.length() > 0) {
                objs[0] = this.detailText;
                return NLS.bind((String)CSClientNodesEditorMessages.ADD_FUNCTION, (Object[])objs);
            }
            return CSClientNodesEditorMessages.ADD_FUNCTION_BEGIN;
        }
        if (this.position == 4) {
            return CSClientNodesEditorMessages.ADD_AFTER_COMMENT;
        }
        if (this.position == 0) {
            return this.selectedSubFunctionCode.length() == 0 || this.subAtFirstLevel ? NLS.bind((String)CSClientNodesEditorMessages.ADD_FUNCTION_BEFORE, (Object[])objs) : NLS.bind((String)CSClientNodesEditorMessages.ADD_SUB_FUNCTION_BEFORE, (Object[])objs);
        }
        if (this.position == 1) {
            return this.selectedSubFunctionCode.length() == 0 || this.subAtFirstLevel ? NLS.bind((String)CSClientNodesEditorMessages.MODIFY_FUNCTION, (Object[])objs) : NLS.bind((String)CSClientNodesEditorMessages.MODIFY_SUB_FUNCTION, (Object[])objs);
        }
        if (this.position == 2) {
            return this.selectedSubFunctionCode.length() == 0 || this.subAtFirstLevel ? NLS.bind((String)CSClientNodesEditorMessages.ADD_FUNCTION_AFTER, (Object[])objs) : NLS.bind((String)CSClientNodesEditorMessages.ADD_SUB_FUNCTION_AFTER, (Object[])objs);
        }
        if (this.position == 5) {
            return NLS.bind((String)CSClientNodesEditorMessages.ADD_FUNCTION, (Object[])objs);
        }
        if (this.position == 6) {
            return NLS.bind((String)CSClientNodesEditorMessages.ADD_SUB_FUNCTION, (Object[])objs);
        }
        if (this.position == 8) {
            return NLS.bind((String)CSClientNodesEditorMessages.INSERT_SUB_FUNCTION_AFTER_LINE, (Object[])objs);
        }
        if (this.position == 9) {
            return NLS.bind((String)CSClientNodesEditorMessages.INSERT_SUB_FUNCTION_AFTER_POINT, (Object[])objs);
        }
        if (this.position == 10) {
            return NLS.bind((String)CSClientNodesEditorMessages.INSERT_SUB_FUNCTION_AFTER_COMMENT, (Object[])objs);
        }
        if (this.position == 11) {
            return NLS.bind((String)CSClientNodesEditorMessages.INSERT_SUB_FUNCTION_AFTER_CURSOR, (Object[])objs);
        }
        if (this.position == 12) {
            return NLS.bind((String)CSClientNodesEditorMessages.ENCAPSULATE_LINES_INSIDE, (Object[])objs);
        }
        return "";
    }

    public void run() {
        IWorkbenchWindow wbWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage wbPage = wbWindow.getActivePage();
        if (wbPage == null) {
            return;
        }
        IEditorPart editor = wbPage.getActiveEditor();
        if (editor != null && editor.equals(this.iEditor)) {
            boolean insert = this.position == 8 || this.position == 9 || this.position == 10 || this.position == 11;
            FunctionDialog dialog = new FunctionDialog(this.iEditor, insert);
            if (this.position == 0 || this.position == 1 || this.position == 2) {
                dialog.setRelativePosition(this.position);
            } else {
                dialog.setAbsoluteInsertionMode();
            }
            if (this.position == 3 || this.position == 4 && this.selectedFunctionCode.length() == 0) {
                dialog.setAtBeginning();
            }
            if (this.subAtFirstLevel) {
                dialog.setSubAtFirstLevel();
            }
            if (this.position == 12) {
                dialog.setForEncapsulation();
            }
            dialog.setLevel(this.levelToDisplay);
            dialog.setOffsets(this.startOffset, this.endOffset);
            if (this.cursorInsert != -1) {
                dialog.setCursorInsert(this.cursorInsert);
            }
            dialog.setTextNodeIndexes(this.detailBeginIndex, this.detailEndIndex);
            dialog.setDetailedTitle(this.detailText);
            dialog.findBestNextCodes(this.selectedFunctionCode, this.selectedSubFunctionCode);
            dialog.open();
            if (dialog.isInsertionPositionFound() && dialog.getReturnCode() == 0) {
                dialog.insertFunction();
            }
        }
    }
}

