/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.copybook.dataUnit;

import com.ibm.icu.util.GregorianCalendar;
import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.explorer.model.service.IPTElement;
import com.ibm.pdp.explorer.model.service.IPTLocation;
import com.ibm.pdp.explorer.model.service.IPTReference;
import com.ibm.pdp.explorer.model.service.PTModelService;
import com.ibm.pdp.explorer.nature.PTNature;
import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.kernel.DataAggregateDescription;
import com.ibm.pdp.mdl.kernel.DataCall;
import com.ibm.pdp.mdl.kernel.DataComponent;
import com.ibm.pdp.mdl.kernel.DataComponentExtension;
import com.ibm.pdp.mdl.kernel.DataElement;
import com.ibm.pdp.mdl.kernel.DataElementDescription;
import com.ibm.pdp.mdl.kernel.DataUnion;
import com.ibm.pdp.mdl.kernel.DataUnionDescription;
import com.ibm.pdp.mdl.kernel.DataUnit;
import com.ibm.pdp.mdl.kernel.Filler;
import com.ibm.pdp.mdl.kernel.KernelPackage;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.impl.DataCallImpl;
import com.ibm.pdp.mdl.pacbase.PacBlockBase;
import com.ibm.pdp.mdl.pacbase.PacCopybook;
import com.ibm.pdp.mdl.pacbase.PacCopybookDSCodeTypeValues;
import com.ibm.pdp.mdl.pacbase.PacCopybookEntitiesSelected;
import com.ibm.pdp.mdl.pacbase.PacCopybookGenerationTypeValues;
import com.ibm.pdp.mdl.pacbase.PacDLine;
import com.ibm.pdp.mdl.pacbase.PacDataAggregate;
import com.ibm.pdp.mdl.pacbase.PacDataCall;
import com.ibm.pdp.mdl.pacbase.PacDataCallMore;
import com.ibm.pdp.mdl.pacbase.PacDataElement;
import com.ibm.pdp.mdl.pacbase.PacDataElementDescription;
import com.ibm.pdp.mdl.pacbase.PacDataElementTypeValues;
import com.ibm.pdp.mdl.pacbase.PacFiller;
import com.ibm.pdp.mdl.pacbase.PacGLine;
import com.ibm.pdp.mdl.pacbase.PacGeneratedDescriptionTypeValues;
import com.ibm.pdp.mdl.pacbase.PacGeneratedSkeletonLanguageValues;
import com.ibm.pdp.mdl.pacbase.PacLibrary;
import com.ibm.pdp.mdl.pacbase.PacProgramVariantValues;
import com.ibm.pdp.mdl.pacbase.PacbasePackage;
import com.ibm.pdp.mdl.pacbase.lal.util.GenerationContext;
import com.ibm.pdp.mdl.pacbase.lal.util.LengthAndPositionVisitor;
import com.ibm.pdp.mdl.pacbase.lal.util.PacbaseLalDescription;
import com.ibm.pdp.mdl.pacbase.util.PacTransformationDataElementType;
import com.ibm.pdp.mdl.pacbase.util.PacbasePattern;
import com.ibm.pdp.pacbase.coopybook.model.KE19;
import com.ibm.pdp.pacbase.coopybook.model.KE22;
import com.ibm.pdp.pacbase.coopybook.model.KE3V;
import com.ibm.pdp.pacbase.coopybook.model.KY01;
import com.ibm.pdp.pacbase.coopybook.model.KY12;
import com.ibm.pdp.pacbase.coopybook.model.KY13;
import com.ibm.pdp.pacbase.coopybook.model.KY1A;
import com.ibm.pdp.pacbase.coopybook.model.KY1C;
import com.ibm.pdp.pacbase.coopybook.model.KY22;
import com.ibm.pdp.pacbase.coopybook.model.PacbaseSegment;
import com.ibm.pdp.pacbase.copybook.dataUnit.IncrementString;
import com.ibm.pdp.pacbase.generate.util.PacbaseLinksEntitiesService;
import com.ibm.pdp.pacbase.generate.util.PacbaseModelService;
import com.ibm.pdp.pacbase.util.PacCopyBookUtilities;
import com.ibm.pdp.trace.PTTraceManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class KY00PacbaseAndKernelVisitor {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010,2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final PacbasePackage modelPackagePB = PacbasePackage.eINSTANCE;
    protected static final KernelPackage modelPackageKernel = KernelPackage.eINSTANCE;
    private ArrayList<PacbaseSegment> copyBookLines = new ArrayList();
    private ArrayList<PacbaseSegment> aliasCopyBookLines = new ArrayList();
    private String piaTyp;
    private String dsCode;
    private String extNam;
    private String desLoc;
    private String cobTyp;
    private String forTyp;
    private String recTyp;
    private String levNum;
    private PacBlockBase codBloc;
    private String indPresence;
    private boolean isInputAidParameter = false;
    private List<String> listOfSelectedSeg = new ArrayList<String>();
    private String dataAggregateName;
    private DataCall currentDataCall;
    private DataElement currentDataElement;
    private String nameOfProject;
    private int numberOfCorub = 0;
    private IncrementString numberOfCorubS;
    private int numberOfDLine = 0;
    private int numberOfDLineAlias = 0;
    private int numberOfGCLine = 0;
    private boolean firstTime = true;
    private boolean lineFormatG = false;
    private boolean lineFormatD = false;
    private boolean lineFormatL = false;
    private String libCDLine;
    private KY1C copyBookDEDLineC;
    private PacbaseLinksEntitiesService ples;
    private RadicalEntity generationEntryPoint;
    private boolean firstTimeForDataAggregate = true;
    private ArrayList<PacbaseLalDescription> lalList = new ArrayList();

    public KY00PacbaseAndKernelVisitor(PacbaseLinksEntitiesService ples) {
        this.ples = ples;
    }

    public void doSwitch(EObject theEObject) {
        this.doSwitch(theEObject.eClass(), theEObject);
    }

    protected void doSwitch(EClass theEClass, EObject theEObject) {
        if (theEObject instanceof RadicalEntity) {
            this.getPacLinksEntitiesService().registerReference((RadicalEntity)theEObject);
        }
        if (theEClass.eContainer() == modelPackagePB) {
            this.doSwitchPB(theEClass.getClassifierID(), theEObject);
        } else if (theEClass.eContainer() == modelPackageKernel) {
            this.doSwitchKernel(theEClass.getClassifierID(), theEObject);
        }
    }

    protected void doSwitchKernel(int classifierID, EObject theEObject) {
        switch (classifierID) {
            case 2: {
                DataUnit kernelObject = (DataUnit)theEObject;
                this.caseDataUnit(kernelObject);
                break;
            }
            case 36: {
                DataUnit kernelObject = (DataUnit)theEObject;
                this.caseDataUnit(kernelObject);
                break;
            }
            case 37: {
                DataCall kernelObject = (DataCall)theEObject;
                this.caseDataCall(kernelObject);
                break;
            }
            case 45: {
                DataAggregate kernelObject = (DataAggregate)theEObject;
                this.caseDataAggregate(kernelObject);
                break;
            }
            case 18: {
                DataAggregateDescription kernelObject = (DataAggregateDescription)theEObject;
                this.caseDataAggregateDescription(kernelObject);
                break;
            }
            case 44: {
                DataElement kernelObject = (DataElement)theEObject;
                this.caseDataElement(kernelObject);
                break;
            }
            case 33: {
                DataElementDescription kernelObject = (DataElementDescription)theEObject;
                this.caseDataElementDescription(kernelObject);
                break;
            }
            case 43: {
                Filler kernelObject = (Filler)theEObject;
                this.caseFiller(kernelObject);
                break;
            }
            case 46: {
                DataUnion kernelObject = (DataUnion)theEObject;
                this.caseDataUnion(kernelObject);
                break;
            }
            case 35: {
                DataUnionDescription kernelObject = (DataUnionDescription)theEObject;
                this.caseDataUnionDescription(kernelObject);
                break;
            }
            default: {
                PTTraceManager traceManager = PTTraceManager.getInstance();
                int engineTraceLevel = traceManager.getTraceLevel("com.ibm.pdp.pac");
                if (engineTraceLevel <= 0) break;
                String message = "Kernel case not defined: " + theEObject.getClass().toString() + " " + new Date();
                traceManager.trace(KY00PacbaseAndKernelVisitor.class, "com.ibm.pdp.pac", 1, message);
            }
        }
    }

    public void casePacCopybook(PacCopybook copyBook) {
        this.isInputAidParameter = copyBook.isInputAidParameter();
        this.generationEntryPoint = copyBook;
        this.setPiaTyp(copyBook.getGenerationType().getLiteral().substring(1));
        if (copyBook.getDSCodeType().equals(PacCopybookDSCodeTypeValues._ASTAR_LITERAL)) {
            this.setDsCode("A*");
        } else if (copyBook.getDSCodeType().equals(PacCopybookDSCodeTypeValues._AQUOTE_LITERAL)) {
            this.setDsCode("A'");
        } else {
            this.setDsCode(copyBook.getDatastructureCode());
            if (!copyBook.getCobolType().equals(PacProgramVariantValues._N_LITERAL)) {
                this.setCobTyp(copyBook.getCobolType().getLiteral().substring(1));
            }
        }
        this.doSwitch((EObject)copyBook.getGenerationParameter());
        if (this.isInputAidParameter) {
            this.setExtnam(copyBook.getExternalName());
            this.doSwitch((EObject)copyBook.getDataStructure());
        } else if (copyBook.getGenerationType().equals(PacCopybookGenerationTypeValues._DC1_LITERAL) || copyBook.getGenerationType().equals(PacCopybookGenerationTypeValues._DC3_LITERAL)) {
            this.initFromCopybookInputsDCn(copyBook);
        } else if (copyBook.getGenerationType().equals(PacCopybookGenerationTypeValues._DSQC1_LITERAL)) {
            this.initFromCopybookInputsDSQC1(copyBook);
        }
    }

    private boolean initFromInputAid(DataUnit du) {
        String[] params = PacCopyBookUtilities.getParamsForInputAid((String)this.getExtnam().trim(), (DataUnit)du);
        if (params != null) {
            this.setExtnam(params[1].toString().trim());
            this.setCobTyp(params[3]);
            if (params[0].trim().length() > 0) {
                this.setDsCode(params[0]);
            }
            String segmentCodes = "";
            if ("DC1".equals(this.getPiaTyp()) || "DC3".equals(this.getPiaTyp())) {
                this.setDesLoc(params[2]);
                this.setForTyp(params[4]);
                this.setRecTyp(params[5]);
                this.setLevNum(params[6]);
                segmentCodes = params[8];
            } else if ("DSQC1".equals(this.getPiaTyp())) {
                PacBlockBase CodBloc = null;
                String codBlocName = params[2];
                RadicalEntity obj = PacbaseModelService.SearchRadicalEntityDuringGeneration((RadicalEntity)this.generationEntryPoint, (String)codBlocName, (String)"pacblockbase", (PacbaseLinksEntitiesService)this.ples);
                if (obj instanceof PacBlockBase) {
                    CodBloc = (PacBlockBase)obj;
                }
                this.setCodBloc(CodBloc);
                this.setIndicPresence(params[4]);
                segmentCodes = params[6];
            }
            int i = 0;
            while (i < segmentCodes.length()) {
                String segmentCode = null;
                try {
                    segmentCode = segmentCodes.substring(i, i + 2);
                }
                catch (Exception exception) {
                    i += 2;
                    continue;
                }
                i += 2;
                this.setSegSel(segmentCode);
            }
        }
        return params != null;
    }

    private void initFromCopybookInputsDCn(PacCopybook copyBook) {
        this.setExtnam(copyBook.getExternalName());
        this.setDesLoc(copyBook.getCobolLocationCode().getLiteral().substring(1));
        this.setCobTyp(copyBook.getCobolType().getLiteral().substring(1));
        this.setForTyp(copyBook.getFormatType().getLiteral().substring(1));
        if (!copyBook.getRecordType().equals(PacGeneratedDescriptionTypeValues._NONE_LITERAL)) {
            this.setRecTyp(copyBook.getRecordType().getLiteral().substring(1));
        } else {
            this.setRecTyp("");
        }
        this.setLevNum(copyBook.getRecordLevel().getLiteral().substring(1));
        if (!copyBook.getEntitiesSelected().equals(null) && !copyBook.getEntitiesSelected().isEmpty()) {
            for (PacCopybookEntitiesSelected obj : copyBook.getEntitiesSelected()) {
                DataAggregate da = obj.getDataAggregate();
                this.setSegSel(da.getName().substring(2));
            }
        }
        this.doSwitch((EObject)copyBook.getDataStructure());
    }

    private void initFromCopybookInputsDSQC1(PacCopybook copyBook) {
        this.setExtnam(copyBook.getExternalName());
        this.setCobTyp(copyBook.getCobolType().getLiteral().substring(1));
        this.setCodBloc(copyBook.getPacBlockBase());
        this.setIndicPresence(copyBook.getPresIndicator().getLiteral().substring(1));
        if (!copyBook.getEntitiesSelected().equals(null) && !copyBook.getEntitiesSelected().isEmpty()) {
            for (PacCopybookEntitiesSelected obj : copyBook.getEntitiesSelected()) {
                DataAggregate da = obj.getDataAggregate();
                this.setSegSel(da.getName().substring(2));
            }
        }
        this.doSwitch((EObject)copyBook.getDataStructure());
    }

    public void caseDataUnit(DataUnit kDataUnit) {
        boolean found;
        PTTraceManager traceManager = PTTraceManager.getInstance();
        int engineTraceLevel = traceManager.getTraceLevel("com.ibm.pdp.pac");
        if (engineTraceLevel > 0) {
            String message = "caseDataUnit: " + kDataUnit.getName() + " - " + kDataUnit.getLabel() + " " + new Date();
            traceManager.trace(KY00PacbaseAndKernelVisitor.class, "com.ibm.pdp.pac", 1, message);
        }
        if (this.isInputAidParameter && !(found = this.initFromInputAid(kDataUnit))) {
            return;
        }
        KY1A copyBookLinesForDataStruct = this.instanciateKY1A(kDataUnit.getName());
        copyBookLinesForDataStruct.get_GRCLEKY_Groupe_Value().set_B7_Value("1  ");
        copyBookLinesForDataStruct.set_LIBEDS_Value(this.formatParametersLine1());
        this.copyBookLines.add(copyBookLinesForDataStruct);
        copyBookLinesForDataStruct = this.instanciateKY1A(kDataUnit.getName());
        copyBookLinesForDataStruct.get_GRCLEKY_Groupe_Value().set_B7_Value("2  ");
        copyBookLinesForDataStruct.set_LIBEDS_Value(this.formatParametersLine2());
        this.copyBookLines.add(copyBookLinesForDataStruct);
        copyBookLinesForDataStruct = this.instanciateKY1A(kDataUnit.getName());
        copyBookLinesForDataStruct.get_GRCLEKY_Groupe_Value().set_B7_Value("3  ");
        copyBookLinesForDataStruct.set_LIBEDS_Value(this.formatParametersLine3());
        this.copyBookLines.add(copyBookLinesForDataStruct);
        copyBookLinesForDataStruct = this.instanciateKY1A(kDataUnit.getName());
        KY1A.GRCLEKY cleKY = copyBookLinesForDataStruct.get_GRCLEKY_Groupe_Value();
        cleKY.set_GRD3_Value("100");
        cleKY.set_B2_Value(this.getDsCode());
        copyBookLinesForDataStruct.set_COFCB_Value(this.getDsCode());
        copyBookLinesForDataStruct.set_GRNOEXT_Value(this.getExtnam());
        copyBookLinesForDataStruct.set_VARIA_Value(this.getCobTyp());
        if ("DC1".equals(this.getPiaTyp()) || "DC3".equals(this.getPiaTyp())) {
            copyBookLinesForDataStruct.set_GREMPLA_Value(this.getDesLoc());
            copyBookLinesForDataStruct.set_TYPIC_Value(this.getForTyp());
            copyBookLinesForDataStruct.set_TYDES_Value(this.getRecTyp());
            copyBookLinesForDataStruct.set_NIVEN_Value(this.getLevNum());
            copyBookLinesForDataStruct.set_GRGROUP_Value(this.getSegSel());
            if ("DC1".equals(this.getPiaTyp())) {
                copyBookLinesForDataStruct.set_OPTION_Value("1");
            } else if ("DC3".equals(this.getPiaTyp())) {
                copyBookLinesForDataStruct.set_OPTION_Value("3");
            }
        } else if ("DSQC1".equals(this.getPiaTyp())) {
            copyBookLinesForDataStruct.set_GREMPLA_Value("H");
            if (this.getCodBloc() != null) {
                copyBookLinesForDataStruct.set_TYPIC_Value(this.getCodBloc().getBlockType().getLiteral().substring(2));
                copyBookLinesForDataStruct.set_COBLOC_Value(this.getCodBloc().getName());
            }
            copyBookLinesForDataStruct.set_TYDES_Value(this.getIndicPresence());
            copyBookLinesForDataStruct.set_NIVEN_Value("");
        }
        copyBookLinesForDataStruct.set_GRWSGENE_Value(String.valueOf(cleKY.get_GRD3_Groupe_Value().get_NULIG_Value()) + cleKY.get_COFIC_Value());
        this.copyBookLines.add(copyBookLinesForDataStruct);
        for (DataCallImpl aDataCall : kDataUnit.getComponents()) {
            this.firstTimeForDataAggregate = true;
            this.doSwitch((EObject)aDataCall);
        }
    }

    public void caseDataCall(DataCall kDataCall) {
        this.currentDataCall = kDataCall;
        if (kDataCall.getDataDefinition() != null) {
            if (kDataCall.getDataDefinition() instanceof DataElement) {
                this.doSwitch((EObject)kDataCall.getDataDefinition());
            }
            if (kDataCall.getDataDefinition() instanceof DataAggregate) {
                boolean doSwitch = true;
                if (this.firstTimeForDataAggregate && !this.isSelectedSegment((DataAggregate)kDataCall.getDataDefinition())) {
                    doSwitch = false;
                }
                if (doSwitch) {
                    this.doSwitch((EObject)kDataCall.getDataDefinition());
                }
            }
            if (kDataCall.getDataDefinition() instanceof DataUnion) {
                this.doSwitch((EObject)kDataCall.getDataDefinition());
            }
        } else if (kDataCall.getDataDescription() != null) {
            if (kDataCall.getDataDescription() instanceof DataElementDescription) {
                this.doSwitch((EObject)kDataCall.getDataDescription());
            } else {
                this.doSwitch((EObject)kDataCall.getDataDescription());
            }
        }
    }

    private List<String> getPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        if (this.getNameOfProject() != null) {
            paths.addAll(PTNature.getPaths((String)this.getNameOfProject()));
        }
        return paths;
    }

    private boolean isSelectedSegment(DataAggregate kDataAggregate) {
        int i = 0;
        while (i < this.listOfSelectedSeg.size()) {
            String codSeg = this.listOfSelectedSeg.get(i);
            if (codSeg.equals(kDataAggregate.getName().substring(2))) {
                return true;
            }
            ++i;
        }
        return this.listOfSelectedSeg.isEmpty();
    }

    public void caseDataAggregate(DataAggregate kDataAggregate) {
        PTTraceManager traceManager = PTTraceManager.getInstance();
        int engineTraceLevel = traceManager.getTraceLevel("com.ibm.pdp.pac");
        if (engineTraceLevel > 0) {
            String message = "caseDataAggregate " + kDataAggregate.getName() + " - " + kDataAggregate.getLabel() + new Date();
            traceManager.trace(KY00PacbaseAndKernelVisitor.class, "com.ibm.pdp.pac", 1, message);
        }
        if (this.firstTimeForDataAggregate) {
            LengthAndPositionVisitor lpvisitor = new LengthAndPositionVisitor(this.getPaths(), new GenerationContext(this.getCobTyp().charAt(0)));
            lpvisitor.doSwitch((EObject)kDataAggregate);
            this.lalList = lpvisitor.defineMatchingArray(lpvisitor.getTopParentLal());
            if (this.lalList.size() > 0 || kDataAggregate.getName().substring(2, 4).equals("00")) {
                this.numberOfCorub = 0;
                this.firstTimeForDataAggregate = false;
                this.numberOfCorubS = new IncrementString("AAA");
                this.dataAggregateName = kDataAggregate.getName();
                this.writeEnregKY12("2", kDataAggregate);
                this.writeEnregKY12("3", kDataAggregate);
                this.doSwitch((EObject)kDataAggregate.getDataDescription());
            }
        } else {
            KY13 copyBookLinesForDataAggregateC = this.instanciateKY13();
            KY13.GREY13 EY13 = copyBookLinesForDataAggregateC.get_GREY13_Groupe_Value();
            EY13.set_CORUB_Value(kDataAggregate.getName());
            EY13.get_GRNRURE_Groupe_Value().set_NRUR9_Value("**");
            EY13.set_LORUBI_Value("00000");
            EY13.set_LORUBE_Value("00000");
            if (this.numberOfCorub > 0) {
                PacbaseLalDescription lal = this.lalList.get(this.numberOfCorub - 1);
                EY13.set_ADRUBI_Value(lal.getInternalAddress());
                EY13.set_ADRUBE_Value(lal.getInputAddress());
                EY13.set_NIVRU_Value(lal.getLevel());
                if (lal.getRedefines()) {
                    EY13.get_GRCOFIM3_Groupe_Value().get_GRCOLRUB_Groupe_Value().set_CORUM_Value(this.searchRedefines(lal));
                    EY13.get_GRCOFIM3_Groupe_Value().set_COFIM_Value("R*");
                }
            }
            this.copyBookLines.add(copyBookLinesForDataAggregateC);
            if (this.getIndicPresence() != null && this.getIndicPresence().equals("Y")) {
                KY13 copyBookLinesForDataAggregateC7 = new KY13(copyBookLinesForDataAggregateC.getCompleteContentForSegment());
                KY13.GRCLEKY cleKYdeC7 = copyBookLinesForDataAggregateC7.get_GRCLEKY_Groupe_Value();
                cleKYdeC7.set_B3_Value("7");
                this.copyBookLines.add(copyBookLinesForDataAggregateC7);
            }
            this.doSwitch((EObject)kDataAggregate.getDataDescription());
        }
    }

    private void writeEnregKY12(String typeEnreg, DataAggregate kDataAggregate) {
        KY12 copyBookLinesForDataAggregate = new KY12();
        KY12.GRCLEKY cleKY12 = copyBookLinesForDataAggregate.get_GRCLEKY_Groupe_Value();
        cleKY12.set_GRD1_Value("01");
        cleKY12.set_COFIC_Value(this.dataAggregateName.substring(0, 2));
        cleKY12.set_GRD3_Value("100");
        cleKY12.set_B2_Value(this.getDsCode());
        cleKY12.set_B3_Value(typeEnreg);
        cleKY12.set_B4_Value(this.dataAggregateName.substring(2));
        if (kDataAggregate != null && kDataAggregate.getLabel() != null) {
            copyBookLinesForDataAggregate.get_GREY12_Groupe_Value().set_LIBSEG_Value(kDataAggregate.getLabel());
        }
        for (Object object : kDataAggregate.getExtensions()) {
            if (!(object instanceof PacDataAggregate)) continue;
            PacDataAggregate pacDag = (PacDataAggregate)object;
            copyBookLinesForDataAggregate.get_GREY12_Groupe_Value().set_NBENR_Value(pacDag.getTableSize());
            copyBookLinesForDataAggregate.get_GREY12_Groupe_Value().set_VALST_Value(pacDag.getStructureCodeValue());
            if (!"3".equals(typeEnreg)) continue;
            Iterator gcLinesIterator = pacDag.getGCLines().iterator();
            this.numberOfGCLine = 0;
            while (gcLinesIterator.hasNext()) {
                Object obj = gcLinesIterator.next();
                if (!(obj instanceof PacGLine)) continue;
                this.doSwitch((EObject)((PacGLine)obj));
            }
        }
        copyBookLinesForDataAggregate.get_GREY12_Groupe_Value().set_NBRUB1_Value("000");
        copyBookLinesForDataAggregate.get_GREY12_Groupe_Value().set_LOENR_Value("00000000000000000000");
        this.copyBookLines.add(copyBookLinesForDataAggregate);
    }

    public void caseDataAggregateDescription(DataAggregateDescription kDataAggregateDescription) {
        String message;
        PTTraceManager traceManager = PTTraceManager.getInstance();
        int engineTraceLevel = traceManager.getTraceLevel("com.ibm.pdp.pac");
        if (engineTraceLevel > 0) {
            message = "caseDataAggregateDescription Entree : " + new Date();
            traceManager.trace(KY00PacbaseAndKernelVisitor.class, "com.ibm.pdp.pac", 1, message);
        }
        if (this.firstTime) {
            this.firstTime = false;
            for (EObject da : kDataAggregateDescription.getComponents()) {
                this.doSwitch(da);
            }
            return;
        }
        if (kDataAggregateDescription.getName() != null && kDataAggregateDescription.getName().length() > 0) {
            if (engineTraceLevel > 0) {
                message = "caseDataAggregateDescription Debut : " + kDataAggregateDescription.getName() + new Date();
                traceManager.trace(KY00PacbaseAndKernelVisitor.class, "com.ibm.pdp.pac", 1, message);
            }
            KY13 copyBookLinesForDataEltGroup = this.instanciateKY13();
            this.prepLineDataAgregateCpBook(copyBookLinesForDataEltGroup, kDataAggregateDescription);
            this.copyBookLines.add(copyBookLinesForDataEltGroup);
            if (this.getIndicPresence() != null && this.getIndicPresence().equals("Y")) {
                KY13 copyBookLinesForDataEltGroup7 = new KY13(copyBookLinesForDataEltGroup.getCompleteContentForSegment());
                KY13.GRCLEKY cleKYdeC7 = copyBookLinesForDataEltGroup7.get_GRCLEKY_Groupe_Value();
                cleKYdeC7.set_B3_Value("7");
                this.copyBookLines.add(copyBookLinesForDataEltGroup7);
            }
        }
        for (EObject da : kDataAggregateDescription.getComponents()) {
            if (engineTraceLevel > 0) {
                String message2 = "caseDataAggregateDescription traitement Dataelement : " + new Date();
                traceManager.trace(KY00PacbaseAndKernelVisitor.class, "com.ibm.pdp.pac", 1, message2);
            }
            this.doSwitch(da);
        }
    }

    public void caseDataElement(DataElement kDataElement) {
        PTTraceManager traceManager = PTTraceManager.getInstance();
        int engineTraceLevel = traceManager.getTraceLevel("com.ibm.pdp.pac");
        if (engineTraceLevel > 0) {
            String message = "caseDataElement: " + kDataElement.getName() + new Date();
            traceManager.trace(KY00PacbaseAndKernelVisitor.class, "com.ibm.pdp.pac", 1, message);
        }
        this.currentDataElement = kDataElement;
        KY13 copyBookLinesForDataElt = this.instanciateKY13();
        KY13.GRCLEKY cleKYde = copyBookLinesForDataElt.get_GRCLEKY_Groupe_Value();
        copyBookLinesForDataElt.set_GRCLEKY_Value(cleKYde.getCompleteContentForSegment().substring(0, 30));
        this.prepLineDataEltCpBook(copyBookLinesForDataElt, kDataElement);
        String libDataEltL = "";
        String libDataEltS = "";
        if (kDataElement.getLabel() != null) {
            libDataEltS = libDataEltL = kDataElement.getLabel();
            if (kDataElement.getLabel().length() > 18) {
                libDataEltS = kDataElement.getLabel().substring(0, 18);
            }
            copyBookLinesForDataElt.get_GREY13_Groupe_Value().set_LIRUBC_Value(libDataEltS);
        }
        this.libCDLine = "";
        this.lineFormatG = false;
        this.lineFormatD = false;
        this.lineFormatL = false;
        if ("A".equals(this.getDsCode())) {
            boolean isSelectedDaughter = false;
            String nbCorubValue6 = String.valueOf(this.numberOfCorub);
            String str6 = "000000" + nbCorubValue6;
            String nbCorubDigit6 = str6.substring(str6.length() - 6);
            IPTElement objS = PTModelService.getLocation((String)this.currentDataElement.getLocation()).getElement(this.currentDataElement.getDesignId(this.currentDataElement.getProject()));
            if (objS instanceof IPTElement) {
                String designId = this.currentDataElement.getDesignId(this.currentDataElement.getProject());
                IPTLocation location = PTModelService.getLocation((String)this.currentDataElement.getLocation());
                List superReferences = PTModelService.getReferences((String)designId, (int)1);
                for (IPTReference reference : superReferences) {
                    if (!reference.getRelations().containsKey("parent")) continue;
                    IPTElement superElement = location.getElement(reference.getSourceId());
                    DataElement refDE = (DataElement)PTEditorService.getSharedResource((IPath)superElement.getPath());
                    Iterator extensionsDE = refDE.getExtensions().iterator();
                    PacDataElement PDE = null;
                    while (extensionsDE.hasNext()) {
                        try {
                            PDE = (PacDataElement)extensionsDE.next();
                        }
                        catch (ClassCastException classCastException) {}
                    }
                    Iterator DLines = PDE.getDLines().iterator();
                    this.numberOfDLineAlias = 0;
                    String nbDLineValue = "";
                    if (DLines == null) continue;
                    while (DLines.hasNext()) {
                        PacDLine pPacDLine = (PacDLine)DLines.next();
                        nbDLineValue = String.valueOf(++this.numberOfDLineAlias);
                        if (pPacDLine.getLineType().equals("A") && pPacDLine.getDescription().equals(this.dataAggregateName)) {
                            isSelectedDaughter = true;
                            KE19 aliasCLine = new KE19();
                            aliasCLine.set_COCA_Value("C ");
                            aliasCLine.get_GRCLESY_Groupe_Value().set_GRCLEKE_Value(this.dataAggregateName);
                            aliasCLine.get_GRCLESY_Groupe_Value().get_GRB09_Groupe_Value().set_GRB2_Value(nbCorubDigit6);
                            aliasCLine.get_GRCLESY_Groupe_Value().get_GRB09_Groupe_Value().set_B4_Value(this.currentDataElement.getName());
                            aliasCLine.get_GRPR19_Groupe_Value().set_CORUB_Value(refDE.getName());
                            aliasCLine.get_GRPR19_Groupe_Value().get_GRLIRUB9_Groupe_Value().set_GRLIRU_Value(refDE.getLabel());
                            aliasCLine.get_GRPR19_Groupe_Value().set_CORUG_Value(this.currentDataElement.getName());
                            PacDataElementDescription pacdedDE = null;
                            Iterator extensionsPar = refDE.getDataDescription().getExtensions().iterator();
                            while (extensionsPar.hasNext()) {
                                try {
                                    pacdedDE = (PacDataElementDescription)extensionsPar.next();
                                }
                                catch (ClassCastException classCastException) {}
                            }
                            String type = PacTransformationDataElementType.transformDataElementType((PacDataElementTypeValues)pacdedDE.getType());
                            aliasCLine.get_GRPR19_Groupe_Value().set_TYRUB_Value(type);
                            this.aliasCopyBookLines.add(aliasCLine);
                        }
                        if (!pPacDLine.getLineType().equals("8") || !DLines.hasNext()) continue;
                        pPacDLine = (PacDLine)DLines.next();
                        nbDLineValue = String.valueOf(++this.numberOfDLineAlias);
                        if (!pPacDLine.getLineType().equals(" ") || pPacDLine.getAllowedValues().trim().length() <= 0 || pPacDLine.getDescription().trim().length() <= 0) continue;
                        KE22 aliasELine = new KE22();
                        aliasELine.set_COCA_Value("E ");
                        aliasELine.get_GRCLESY_Groupe_Value().set_GRCLEKE_Value(this.dataAggregateName);
                        aliasELine.get_GRCLESY_Groupe_Value().get_GRB09_Groupe_Value().set_GRB2_Value(nbCorubDigit6);
                        aliasELine.get_GRCLESY_Groupe_Value().get_GRB09_Groupe_Value().set_B4_Value(this.currentDataElement.getName());
                        aliasELine.get_GRCLESY_Groupe_Value().get_GRB09_Groupe_Value().get_GRB67_Groupe_Value().set_GRB6_Value("E");
                        aliasELine.get_GRCLESY_Groupe_Value().get_GRB09_Groupe_Value().set_GRB8_Value(refDE.getName());
                        String strD = "000" + nbDLineValue;
                        String nbDLineDigit = strD.substring(strD.length() - 3);
                        aliasELine.get_GRCLESY_Groupe_Value().get_GRB09_Groupe_Value().set_GRB9_Value(String.valueOf(nbDLineDigit));
                        aliasELine.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRCARTE6_Groupe_Value().set_TYCOD_Value("8");
                        aliasELine.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRCARTE6_Groupe_Value().set_VALRU_Value(pPacDLine.getAllowedValues());
                        aliasELine.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value().get_GRCARTE6_Groupe_Value().set_GRSIGNI_Value(pPacDLine.getDescription());
                        this.aliasCopyBookLines.add(aliasELine);
                    }
                }
            }
            if (!isSelectedDaughter) {
                KE19 aliasCLine = new KE19();
                aliasCLine.set_COCA_Value("C ");
                aliasCLine.get_GRCLESY_Groupe_Value().set_GRCLEKE_Value(this.dataAggregateName);
                aliasCLine.get_GRCLESY_Groupe_Value().get_GRB09_Groupe_Value().set_GRB2_Value(nbCorubDigit6);
                aliasCLine.get_GRCLESY_Groupe_Value().get_GRB09_Groupe_Value().set_B4_Value(this.currentDataElement.getName());
                aliasCLine.get_GRPR19_Groupe_Value().set_CORUB_Value(this.currentDataElement.getName());
                aliasCLine.get_GRPR19_Groupe_Value().get_GRLIRUB9_Groupe_Value().set_GRLIRU_Value(this.currentDataElement.getLabel());
                PacDataElementDescription pacdedDElt = null;
                Iterator extensionsPar = this.currentDataElement.getDataDescription().getExtensions().iterator();
                while (extensionsPar.hasNext()) {
                    try {
                        pacdedDElt = (PacDataElementDescription)extensionsPar.next();
                    }
                    catch (ClassCastException classCastException) {}
                }
                String type = PacTransformationDataElementType.transformDataElementType((PacDataElementTypeValues)pacdedDElt.getType());
                aliasCLine.get_GRPR19_Groupe_Value().set_TYRUB_Value(type);
                this.aliasCopyBookLines.add(aliasCLine);
            }
        }
        if ("DC3".equals(this.getPiaTyp())) {
            Iterator extensionsPar = null;
            PacDataElementDescription pacded = null;
            Iterator extensionsD = kDataElement.getDataDescription().getExtensions().iterator();
            while (extensionsD.hasNext()) {
                try {
                    pacded = (PacDataElementDescription)extensionsD.next();
                }
                catch (ClassCastException classCastException) {}
            }
            if (pacded.getParent() != null) {
                DataElement parentDataElement = pacded.getParent();
                if (libDataEltL.trim().length() < 1 && parentDataElement.getLabel() != null) {
                    libDataEltS = libDataEltL = parentDataElement.getLabel();
                    if (kDataElement.getLabel().length() > 18) {
                        libDataEltS = kDataElement.getLabel().substring(0, 18);
                    }
                    copyBookLinesForDataElt.get_GREY13_Groupe_Value().set_LIRUBC_Value(libDataEltS);
                }
            }
            this.copyBookDEDLineC = new KY1C();
            KY1C.GRCLEKY cleKYdeC = this.copyBookDEDLineC.get_GRCLEKY_Groupe_Value();
            cleKYdeC.set_GRD1_Value("01");
            cleKYdeC.set_COFIC_Value(this.dataAggregateName.substring(0, 2));
            cleKYdeC.set_GRD3_Value("100");
            cleKYdeC.set_B2_Value(this.getDsCode());
            cleKYdeC.set_B3_Value("3");
            cleKYdeC.set_B4_Value(this.dataAggregateName.substring(2));
            cleKYdeC.set_B7_Value(this.numberOfCorubS.currentString);
            cleKYdeC.set_TYLIG_Value("C");
            this.copyBookDEDLineC.set_GRCLEKY_Value(cleKYdeC.getCompleteContentForSegment().substring(0, 30));
            this.copyBookDEDLineC.set_GRLIRU_Value(libDataEltL);
            for (PacDataElement pacdedPDE : kDataElement.getExtensions()) {
                this.doSwitch((EObject)pacdedPDE);
            }
            if (!(pacded.getParent() == null || this.lineFormatD && this.lineFormatG && this.lineFormatL)) {
                DataElement parentDataElement = pacded.getParent();
                for (PacDataElement pacdedPDE : parentDataElement.getExtensions()) {
                    this.doSwitch((EObject)pacdedPDE);
                }
            }
            this.copyBookLines.add(this.copyBookDEDLineC);
            if (this.getIndicPresence() != null && this.getIndicPresence().equals("Y")) {
                KY1C copyBookDEDLineC7 = new KY1C(this.copyBookDEDLineC.getCompleteContentForSegment());
                KY1C.GRCLEKY cleKYdeC7 = copyBookDEDLineC7.get_GRCLEKY_Groupe_Value();
                cleKYdeC7.set_B3_Value("7");
                this.copyBookLines.add(copyBookDEDLineC7);
            }
        }
        if (this.libCDLine.trim().length() > 0) {
            copyBookLinesForDataElt.get_GREY13_Groupe_Value().set_LIRUBC_Value(this.libCDLine);
        }
        this.copyBookLines.add(copyBookLinesForDataElt);
        if (this.getIndicPresence() != null && this.getIndicPresence().equals("Y")) {
            KY13 copyBookLinesForDataElt7 = new KY13(copyBookLinesForDataElt.getCompleteContentForSegment());
            KY13.GRCLEKY cleKYdeC7 = copyBookLinesForDataElt7.get_GRCLEKY_Groupe_Value();
            cleKYdeC7.set_B3_Value("7");
            this.copyBookLines.add(copyBookLinesForDataElt7);
        }
    }

    private KY13.GREY13 initFromLalDescription(KY13.GREY13 copyBookDetailForDataElt) {
        if (this.numberOfCorub > 0) {
            String label;
            PacbaseLalDescription lal = this.lalList.get(this.numberOfCorub - 1);
            copyBookDetailForDataElt.set_NIVRU_Value(lal.getLevel());
            copyBookDetailForDataElt.set_NIVRUR_Value(lal.getLevel());
            copyBookDetailForDataElt.set_REPET_Value(lal.getOccurs());
            copyBookDetailForDataElt.get_GRNRURE_Groupe_Value().set_NRUR9_Value(String.valueOf(lal.getChildren().size()));
            lal.calculateNumbers();
            copyBookDetailForDataElt.set_PICTUI_Value(lal.getInternalFormat());
            copyBookDetailForDataElt.set_PICTUE_Value(lal.getInputFormat());
            KY13.GREY13.GRPICTU grPictu = copyBookDetailForDataElt.get_GRPICTU_Groupe_Value();
            KY13.GREY13.GRPICTU.GRPICTUA grPictuA = grPictu.get_GRPICTUA_Groupe_Value();
            if (lal.getOutputFormat().length() > 0) {
                grPictuA.set_PICTUS_Value(lal.getOutputFormat());
                if (lal.getOutputFormat().length() > 14) {
                    grPictuA.set_PICTUC_Value(lal.getOutputFormat().substring(14));
                }
                GenerationContext gc = new GenerationContext(this.getCobTyp().charAt(0));
                gc.setPattern(PacbasePattern.BATCH);
                if (lal.isBlankWhenZero(gc)) {
                    grPictu.set_SUPIC_Value("Z");
                }
            }
            if ((label = lal.getLabel()).trim() != null && label.trim().length() > 0) {
                copyBookDetailForDataElt.get_GRLIRUB_Groupe_Value().set_GRCORTOT_Value(label.length() > 4 ? label.substring(0, 4) : label);
            }
            copyBookDetailForDataElt.set_USAGEI_Value(lal.getUsage());
            copyBookDetailForDataElt.set_LORUBI_Value(lal.getInternalLength());
            copyBookDetailForDataElt.set_LORUBE_Value(lal.getInputLength());
            copyBookDetailForDataElt.set_LORUBS_Value(lal.getOutputLength());
            copyBookDetailForDataElt.set_TYRUB_Value(lal.getTyrub());
            String LORUBI = KY00PacbaseAndKernelVisitor.trimLeft(copyBookDetailForDataElt.get_LORUBI_Value().trim());
            String LORUBE = KY00PacbaseAndKernelVisitor.trimLeft(copyBookDetailForDataElt.get_LORUBE_Value().trim());
            String LORUBS = KY00PacbaseAndKernelVisitor.trimLeft(copyBookDetailForDataElt.get_LORUBS_Value().trim());
            if (copyBookDetailForDataElt.get_PICTUI_Value().trim().equals("TS") && lal.getInternalLength() != 26) {
                copyBookDetailForDataElt.set_PICTUI_Value("X(" + LORUBI + ")");
            }
            if (copyBookDetailForDataElt.get_PICTUE_Value().trim().equals("TS") && lal.getInputLength() != 26) {
                copyBookDetailForDataElt.set_PICTUE_Value("X(" + LORUBE + ")");
            }
            if (copyBookDetailForDataElt.get_GRPICTU_Groupe_Value().get_GRPICTUA_Groupe_Value().get_PICTUS_Value().trim().equals("TS") && lal.getOutputLength() != 26) {
                copyBookDetailForDataElt.get_GRPICTU_Groupe_Value().get_GRPICTUA_Groupe_Value().set_PICTUS_Value("X(" + LORUBS + ")");
            }
            copyBookDetailForDataElt.set_ADRUBI_Value(lal.getInternalAddress());
            copyBookDetailForDataElt.set_ADRUBE_Value(lal.getInputAddress());
            copyBookDetailForDataElt.set_ADRUBS_Value(lal.getOutputAddress());
            if (lal.getRedefines()) {
                copyBookDetailForDataElt.get_GRCOFIM3_Groupe_Value().get_GRCOLRUB_Groupe_Value().set_CORUM_Value(this.searchRedefines(lal));
                copyBookDetailForDataElt.get_GRCOFIM3_Groupe_Value().set_COFIM_Value("R*");
            }
        }
        return copyBookDetailForDataElt;
    }

    public static String trimLeft(String s) {
        int i = 0;
        while (i < s.length() && s.charAt(i) == '0') {
            ++i;
        }
        return s.substring(i);
    }

    private String searchRedefines(PacbaseLalDescription lal) {
        int i = this.numberOfCorub - 2;
        while (i >= 0) {
            if (!this.lalList.get(i).getRedefines() && lal.getLevel() == this.lalList.get(i).getLevel()) {
                return this.lalList.get(i).getName();
            }
            --i;
        }
        return "";
    }

    public void caseDataElementDescription(DataElementDescription kDataElementDescription) {
        PTTraceManager traceManager = PTTraceManager.getInstance();
        int engineTraceLevel = traceManager.getTraceLevel("com.ibm.pdp.pac");
        if (engineTraceLevel > 0) {
            String message = "caseDataElementDescription: " + kDataElementDescription.getName() + new Date();
            traceManager.trace(KY00PacbaseAndKernelVisitor.class, "com.ibm.pdp.pac", 1, message);
        }
        KY13 copyBookLinesForDataElt = this.instanciateKY13();
        KY13.GRCLEKY cleKYde = copyBookLinesForDataElt.get_GRCLEKY_Groupe_Value();
        copyBookLinesForDataElt.set_GRCLEKY_Value(cleKYde.getCompleteContentForSegment().substring(0, 30));
        KY13.GREY13 detailForDataElt = this.prepLineDataEltNODefinedCpBook(copyBookLinesForDataElt, kDataElementDescription);
        this.initFromLalDescription(detailForDataElt);
        String labelDEL = null;
        String labelDES = null;
        if (kDataElementDescription.getOwner().getLabel() != null) {
            labelDES = labelDEL = kDataElementDescription.getOwner().getLabel();
            if (kDataElementDescription.getOwner().getLabel().length() > 18) {
                labelDES = kDataElementDescription.getOwner().getLabel().substring(0, 18);
            }
            copyBookLinesForDataElt.get_GREY13_Groupe_Value().set_LIRUBC_Value(labelDES);
        }
        this.copyBookLines.add(copyBookLinesForDataElt);
        if (this.getIndicPresence() != null && this.getIndicPresence().equals("Y")) {
            KY13 copyBookLinesForDataElt7 = new KY13(copyBookLinesForDataElt.getCompleteContentForSegment());
            KY13.GRCLEKY cleKYdeC7 = copyBookLinesForDataElt7.get_GRCLEKY_Groupe_Value();
            cleKYdeC7.set_B3_Value("7");
            this.copyBookLines.add(copyBookLinesForDataElt7);
        }
        this.copyBookDEDLineC = new KY1C();
        KY1C.GRCLEKY cleKYdeC = this.copyBookDEDLineC.get_GRCLEKY_Groupe_Value();
        cleKYdeC.set_GRD1_Value("01");
        cleKYdeC.set_COFIC_Value(this.dataAggregateName.substring(0, 2));
        cleKYdeC.set_GRD3_Value("100");
        cleKYdeC.set_B2_Value(this.getDsCode());
        cleKYdeC.set_B3_Value("3");
        cleKYdeC.set_B4_Value(this.dataAggregateName.substring(2));
        cleKYdeC.set_B7_Value(this.numberOfCorubS.currentString);
        cleKYdeC.set_TYLIG_Value("C");
        this.copyBookDEDLineC.set_GRCLEKY_Value(cleKYdeC.getCompleteContentForSegment().substring(0, 30));
        if (labelDEL != null) {
            this.copyBookDEDLineC.set_GRLIRU_Value(labelDEL);
        }
        this.copyBookLines.add(this.copyBookDEDLineC);
        if (this.getIndicPresence() != null && this.getIndicPresence().equals("Y")) {
            KY1C copyBookDEDLineC7 = new KY1C(this.copyBookDEDLineC.getCompleteContentForSegment());
            KY1C.GRCLEKY cleKYdeC7 = copyBookDEDLineC7.get_GRCLEKY_Groupe_Value();
            cleKYdeC7.set_B3_Value("7");
            this.copyBookLines.add(copyBookDEDLineC7);
        }
    }

    public void caseFiller(Filler kDataFiller) {
        PTTraceManager traceManager = PTTraceManager.getInstance();
        int engineTraceLevel = traceManager.getTraceLevel("com.ibm.pdp.pac");
        if (engineTraceLevel > 0) {
            String message = "caseDataElement: kDataFiller" + new Date();
            traceManager.trace(KY00PacbaseAndKernelVisitor.class, "com.ibm.pdp.pac", 1, message);
        }
        KY13 copyBookLinesForDataElt = this.instanciateKY13();
        KY13.GRCLEKY cleKYde = copyBookLinesForDataElt.get_GRCLEKY_Groupe_Value();
        copyBookLinesForDataElt.set_GRCLEKY_Value(cleKYde.getCompleteContentForSegment().substring(0, 30));
        this.prepLineFillerCpBook(copyBookLinesForDataElt, kDataFiller);
        this.copyBookLines.add(copyBookLinesForDataElt);
        if (this.getIndicPresence() != null && this.getIndicPresence().equals("Y")) {
            KY13 copyBookLinesForDataElt7 = new KY13(copyBookLinesForDataElt.getCompleteContentForSegment());
            KY13.GRCLEKY cleKYdeC7 = copyBookLinesForDataElt7.get_GRCLEKY_Groupe_Value();
            cleKYdeC7.set_B3_Value("7");
            this.copyBookLines.add(copyBookLinesForDataElt7);
        }
    }

    public void caseDataUnion(DataUnion kDataUnion) {
        PTTraceManager traceManager = PTTraceManager.getInstance();
        int engineTraceLevel = traceManager.getTraceLevel("com.ibm.pdp.pac");
        if (engineTraceLevel > 0) {
            String message = "caseDataUnion: " + kDataUnion.getName() + " - " + kDataUnion.getLabel() + " " + new Date();
            traceManager.trace(KY00PacbaseAndKernelVisitor.class, "com.ibm.pdp.pac", 1, message);
        }
        this.doSwitch((EObject)kDataUnion.getDataDescription());
    }

    public void caseDataUnionDescription(DataUnionDescription kDataUnionDescription) {
        PTTraceManager traceManager = PTTraceManager.getInstance();
        int engineTraceLevel = traceManager.getTraceLevel("com.ibm.pdp.pac");
        if (engineTraceLevel > 0) {
            String message = "caseDataUnionDescription: " + kDataUnionDescription.getName() + " - " + kDataUnionDescription.getLabel() + " " + new Date();
            traceManager.trace(KY00PacbaseAndKernelVisitor.class, "com.ibm.pdp.pac", 1, message);
        }
        for (DataComponent aDataComponent : kDataUnionDescription.getRedefines()) {
            this.doSwitch((EObject)aDataComponent);
        }
    }

    protected void doSwitchPB(int classifierID, EObject theEObject) {
        switch (classifierID) {
            case 31: {
                PacLibrary pacbaseObject = (PacLibrary)theEObject;
                this.casePacLibrary(pacbaseObject);
                break;
            }
            case 59: {
                PacDataCall pacbaseObject = (PacDataCall)theEObject;
                this.casePacDataCall(pacbaseObject);
                break;
            }
            case 61: {
                break;
            }
            case 3: {
                break;
            }
            case 56: {
                PacDataElement pacbaseObject = (PacDataElement)theEObject;
                this.casePacDataElement(pacbaseObject);
                break;
            }
            case 57: {
                PacDLine pacbaseObject = (PacDLine)theEObject;
                this.casePacDataElementDLine(pacbaseObject);
                break;
            }
            case 12: {
                PacGLine pacbaseObject = (PacGLine)theEObject;
                this.casePacGLine(pacbaseObject);
                break;
            }
            case 115: {
                PacCopybook pacbaseObject = (PacCopybook)theEObject;
                this.casePacCopybook(pacbaseObject);
                break;
            }
            default: {
                PTTraceManager traceManager = PTTraceManager.getInstance();
                int engineTraceLevel = traceManager.getTraceLevel("com.ibm.pdp.pac");
                if (engineTraceLevel <= 0) break;
                String message = "Pacbase case not defined: " + theEObject.getClass().toString() + " " + new Date();
                traceManager.trace(KY00PacbaseAndKernelVisitor.class, "com.ibm.pdp.pac", 1, message);
            }
        }
    }

    private void casePacLibrary(PacLibrary aPacLibrary) {
        KY01 copyBookLibrary = new KY01();
        copyBookLibrary = this.prepLineForLibrary(copyBookLibrary, aPacLibrary);
        KY01.GRCLEKY cleKY = copyBookLibrary.get_GRCLEKY_Groupe_Value();
        cleKY.set_GRD1_Value("01");
        KY01.GRPR01 ky01PR01 = copyBookLibrary.get_GRPR01_Groupe_Value();
        KY01.GRPR01.GRNOBIB7 ky01NOBIB7 = ky01PR01.get_GRNOBIB7_Groupe_Value();
        ky01NOBIB7.set_APPLI_Value(aPacLibrary.getName());
        ky01NOBIB7.set_LIBIB_Value(aPacLibrary.getLabel());
        this.copyBookLines.add(copyBookLibrary);
    }

    public void casePacDataCall(PacDataCall pPacDataCall) {
        Iterator moreLines = pPacDataCall.getMoreLines().iterator();
        if (moreLines != null) {
            while (moreLines.hasNext()) {
                this.doSwitch((EObject)moreLines.next());
            }
        }
    }

    public void casePacDataElement(PacDataElement pPacDataElement) {
        Iterator DLines = pPacDataElement.getDLines().iterator();
        this.numberOfDLine = 0;
        if (DLines != null) {
            while (DLines.hasNext()) {
                this.doSwitch((EObject)DLines.next());
            }
        }
    }

    private void casePacGLine(PacGLine pPacGLine) {
        if (pPacGLine.getLineType().equals("A")) {
            KE3V aliasGCLine = new KE3V();
            aliasGCLine.set_COCA_Value("V3");
            aliasGCLine.get_GRCLESY_Groupe_Value().set_GRCLEKE_Value(this.dataAggregateName);
            String nbDLineValue = String.valueOf(++this.numberOfGCLine);
            String str = "000" + nbDLineValue;
            String nbDLineDigit = str.substring(str.length() - 3);
            aliasGCLine.get_GRCLESY_Groupe_Value().get_GRB09_Groupe_Value().set_GRB9_Value(nbDLineDigit);
            aliasGCLine.get_GRPR3V_Groupe_Value().get_GRLIB1PR_Groupe_Value().set_DOCAP_Value(pPacGLine.getLineType());
            aliasGCLine.get_GRPR3V_Groupe_Value().get_GRLIB1PR_Groupe_Value().get_GRDEBLIB_Groupe_Value().set_GRSYNGR_Value(pPacGLine.getDescription());
            this.aliasCopyBookLines.add(aliasGCLine);
        }
    }

    private void casePacDataElementDLine(PacDLine pPacDLine) {
        if (!this.lineFormatL && pPacDLine.getLineType().equals("L")) {
            this.libCDLine = pPacDLine.getDescription();
            this.lineFormatL = true;
        }
        if (!this.lineFormatG && pPacDLine.getLineType().equals("G")) {
            this.copyBookDEDLineC.set_TYOBJG_Value(pPacDLine.getDescription());
            this.lineFormatG = true;
        }
        if (!this.lineFormatD && pPacDLine.getLineType().equals("D")) {
            this.copyBookDEDLineC.set_VALRU_Value(pPacDLine.getAllowedValues());
            this.lineFormatD = true;
        }
        if (pPacDLine.getLineType().trim().length() < 1) {
            KY22 copyBookDEDLine = new KY22();
            KY22.GRCLEKY cleKYde = copyBookDEDLine.get_GRCLEKY_Groupe_Value();
            cleKYde.set_GRD1_Value("01");
            cleKYde.set_COFIC_Value(this.dataAggregateName.substring(0, 2));
            cleKYde.set_GRD3_Value("100");
            cleKYde.set_B2_Value(this.getDsCode());
            cleKYde.set_B3_Value("3");
            cleKYde.set_B4_Value(this.dataAggregateName.substring(2));
            cleKYde.set_B7_Value(this.numberOfCorubS.currentString);
            cleKYde.set_TYLIG_Value("E");
            String nbDLineValue = String.valueOf(++this.numberOfDLine);
            String str = "000" + nbDLineValue;
            String nbDLineDigit = str.substring(str.length() - 3);
            cleKYde.set_B9_Value(String.valueOf(nbDLineDigit));
            copyBookDEDLine.set_GRCLEKY_Value(cleKYde.getCompleteContentForSegment().substring(0, 30));
            KY22.GRPR22.GRENREG ky22enreg = copyBookDEDLine.get_GRPR22_Groupe_Value().get_GRENREG_Groupe_Value();
            ky22enreg.get_GRI22_Groupe_Value().set_CORUB_Value(this.currentDataElement.getName());
            ky22enreg.get_GRI22_Groupe_Value().set_NULIG_Value(nbDLineDigit);
            this.formatKY22(pPacDLine, ky22enreg);
            this.copyBookLines.add(copyBookDEDLine);
            if (this.getIndicPresence() != null && this.getIndicPresence().equals("Y")) {
                KY1C copyBookDEDLine7 = new KY1C(copyBookDEDLine.getCompleteContentForSegment());
                KY1C.GRCLEKY cleKYde7 = copyBookDEDLine7.get_GRCLEKY_Groupe_Value();
                cleKYde7.set_B3_Value("7");
                this.copyBookLines.add(copyBookDEDLine7);
            }
        }
    }

    public List<PacbaseSegment> getCopyBookLines() {
        return this.copyBookLines;
    }

    public List<PacbaseSegment> getAliasCopyBookLines() {
        return this.aliasCopyBookLines;
    }

    void setPiaTyp(String piaTyp) {
        this.piaTyp = piaTyp;
    }

    String getPiaTyp() {
        return this.piaTyp;
    }

    void setDsCode(String dsCode) {
        this.dsCode = dsCode;
    }

    String getDsCode() {
        return this.dsCode;
    }

    void setExtnam(String extNam) {
        this.extNam = extNam != null ? extNam : "";
    }

    String getExtnam() {
        return this.extNam;
    }

    void setDesLoc(String desLoc) {
        this.desLoc = desLoc;
    }

    String getDesLoc() {
        return this.desLoc;
    }

    void setCobTyp(String cobTyp) {
        this.cobTyp = cobTyp;
    }

    String getCobTyp() {
        return this.cobTyp;
    }

    void setForTyp(String forTyp) {
        this.forTyp = forTyp;
    }

    String getForTyp() {
        return this.forTyp;
    }

    void setRecTyp(String recTyp) {
        this.recTyp = recTyp;
    }

    String getRecTyp() {
        return this.recTyp;
    }

    void setLevNum(String levNum) {
        this.levNum = levNum;
        if (levNum == null || levNum.trim().length() == 0) {
            this.levNum = "1";
        }
    }

    String getLevNum() {
        return this.levNum;
    }

    void setCodBloc(PacBlockBase CodBl) {
        this.codBloc = CodBl;
    }

    PacBlockBase getCodBloc() {
        return this.codBloc;
    }

    void setIndicPresence(String IndicPresence) {
        this.indPresence = IndicPresence;
    }

    String getIndicPresence() {
        return this.indPresence;
    }

    void setSegSel(String segSel) {
        if (segSel != null) {
            this.listOfSelectedSeg.add(segSel);
        }
    }

    private String getSegSel() {
        StringBuilder selection = new StringBuilder();
        int i = 0;
        while (i < this.listOfSelectedSeg.size()) {
            selection.append(this.listOfSelectedSeg.get(i));
            ++i;
        }
        return selection.toString();
    }

    private String getStringFromInt(int value) {
        String nbCorubValue = String.valueOf(value);
        String str = "000" + nbCorubValue;
        return str.substring(str.length() - 3);
    }

    private String formatParametersLine1() {
        StringBuilder param = new StringBuilder();
        if (this.getPiaTyp() != null) {
            param.append("PIATYP=").append(this.getPiaTyp());
        }
        if (this.getDsCode() != null) {
            param.append(",DSCODE=").append(this.getDsCode());
        }
        if (this.getExtnam() != null) {
            param.append(",EXTNAM=").append(this.getExtnam());
        }
        if (this.getDesLoc() != null) {
            param.append(",DESLOC=").append(this.getDesLoc());
        }
        return param.toString();
    }

    private String formatParametersLine2() {
        StringBuilder param = new StringBuilder();
        if (this.getCobTyp() != null) {
            param.append("COBTYP=").append(this.getCobTyp());
        }
        if (this.getForTyp() != null) {
            param.append(",FORTYP=").append(this.getForTyp());
        }
        if (this.getRecTyp() != null) {
            param.append(",RECTYP=").append(this.getRecTyp());
        }
        if (this.getCodBloc() != null) {
            param.append(",SQLBLO=").append(this.getCodBloc().getName());
        }
        if (this.getIndicPresence() != null) {
            param.append(",PREIND=").append(this.getIndicPresence());
        }
        return param.toString();
    }

    private String formatParametersLine3() {
        StringBuilder param = new StringBuilder();
        if (this.getLevNum() != null) {
            param.append("LEVNUM=").append(this.getLevNum());
        }
        if (this.getSegSel() != null) {
            param.append(",SEGSEL=").append(this.getSegSel());
        }
        return param.toString();
    }

    private KY13.GREY13 prepLineDataEltCpBook(KY13 copyBookLineForDataElt, DataElement kDataElement) {
        KY13.GREY13 copyBookDetailForDataElt = copyBookLineForDataElt.get_GREY13_Groupe_Value();
        this.initFromLalDescription(copyBookDetailForDataElt);
        copyBookDetailForDataElt.set_CORUB_Value(kDataElement.getName());
        copyBookDetailForDataElt.get_GRNRURE_Groupe_Value().set_NRUR9_Value("00");
        if (this.currentDataCall != null) {
            EList extensions = this.currentDataCall.getExtensions();
            this.updateDataCall((List<DataComponentExtension>)extensions, copyBookDetailForDataElt, kDataElement.getName());
        }
        Iterator extensionsA = kDataElement.getExtensions().iterator();
        while (extensionsA.hasNext()) {
            try {
                PacDataElement pde = (PacDataElement)extensionsA.next();
                String variant = pde.getGenerationParameter().getCobolType().getName().substring(1);
                copyBookLineForDataElt.set_VARIA_Value(variant);
            }
            catch (ClassCastException classCastException) {}
        }
        return copyBookDetailForDataElt;
    }

    private KY13.GREY13 prepLineDataEltNODefinedCpBook(KY13 copyBookLineForDataElt, DataElementDescription DEDescription) {
        KY13.GREY13 copyBookDetailForDataElt = copyBookLineForDataElt.get_GREY13_Groupe_Value();
        this.initFromLalDescription(copyBookDetailForDataElt);
        copyBookDetailForDataElt.set_CORUB_Value(DEDescription.getName());
        copyBookDetailForDataElt.get_GRNRURE_Groupe_Value().set_NRUR9_Value("00");
        if (this.currentDataCall != null) {
            EList extensions = this.currentDataCall.getExtensions();
            this.updateDataCall((List<DataComponentExtension>)extensions, copyBookDetailForDataElt, DEDescription.getOwner().getName());
        }
        return copyBookDetailForDataElt;
    }

    private KY13.GREY13 prepLineDataAgregateCpBook(KY13 copyBookLineForDataAgr, DataAggregateDescription DADescription) {
        KY13.GREY13 copyBookDetailForDataAgg = copyBookLineForDataAgr.get_GREY13_Groupe_Value();
        this.initFromLalDescription(copyBookDetailForDataAgg);
        copyBookDetailForDataAgg.set_CORUB_Value(DADescription.getName());
        copyBookDetailForDataAgg.set_USAGEI_Value("D");
        if (this.currentDataCall != null) {
            EList extensions = this.currentDataCall.getExtensions();
            this.updateDataCall((List<DataComponentExtension>)extensions, copyBookDetailForDataAgg, DADescription.getOwner().getName());
        }
        return copyBookDetailForDataAgg;
    }

    private KY13.GREY13 prepLineFillerCpBook(KY13 copyBookLineForDataElt, Filler kFiller) {
        KY13.GREY13 copyBookDetailForFiller = copyBookLineForDataElt.get_GREY13_Groupe_Value();
        this.initFromLalDescription(copyBookDetailForFiller);
        copyBookDetailForFiller.set_CORUB_Value("FILLER");
        copyBookDetailForFiller.get_GRNRURE_Groupe_Value().set_NRUR9_Value("00");
        PacFiller pacFiller = null;
        EList extensions = kFiller.getExtensions();
        int i = 0;
        while (i < extensions.size()) {
            Object object = extensions.get(i);
            if (object instanceof PacFiller) {
                pacFiller = (PacFiller)object;
            }
            ++i;
        }
        this.updateValues((List<?>)pacFiller.getMoreLines(), copyBookDetailForFiller, "FILLER");
        return copyBookDetailForFiller;
    }

    private void updateDataCall(List<DataComponentExtension> extensions, KY13.GREY13 copyBookDetailForDataElt, String kDataElementName) {
        PacDataCall pacDataCall = null;
        int i = 0;
        while (i < extensions.size()) {
            DataComponentExtension object = extensions.get(i);
            if (object instanceof PacDataCall) {
                pacDataCall = (PacDataCall)object;
                break;
            }
            ++i;
        }
        if (pacDataCall != null && pacDataCall.getSortKey() != null) {
            copyBookDetailForDataElt.set_INDIC_Value(pacDataCall.getSortKey());
        }
        if (pacDataCall != null && pacDataCall.getPresenceCheck() != null) {
            String ctlCreat = pacDataCall.getPresenceCheck().getInCreation().toString().substring(1);
            String ctlModi = pacDataCall.getPresenceCheck().getInModification().toString().substring(1);
            String ctlDele = pacDataCall.getPresenceCheck().getInDeletion().toString().substring(1);
            String ctlTyp4 = pacDataCall.getPresenceCheck().getInType4().toString().substring(1);
            String ctlTyp5 = pacDataCall.getPresenceCheck().getInType5().toString().substring(1);
            String ctlTyp6 = pacDataCall.getPresenceCheck().getInType6().toString().substring(1);
            if (String.valueOf(ctlCreat).equals("None")) {
                ctlCreat = " ";
            }
            if (String.valueOf(ctlModi).equals("None")) {
                ctlModi = " ";
            }
            if (String.valueOf(ctlDele).equals("None")) {
                ctlDele = " ";
            }
            if (String.valueOf(ctlTyp4).equals("None")) {
                ctlTyp4 = " ";
            }
            if (String.valueOf(ctlTyp5).equals("None")) {
                ctlTyp5 = " ";
            }
            if (String.valueOf(ctlTyp6).equals("None")) {
                ctlTyp6 = " ";
            }
            copyBookDetailForDataElt.set_STRCO1_Value(ctlCreat);
            copyBookDetailForDataElt.set_STRCO2_Value(ctlModi);
        }
        if (pacDataCall != null) {
            this.updateValues((List<?>)pacDataCall.getMoreLines(), copyBookDetailForDataElt, kDataElementName);
        }
    }

    private void updateValues(List<?> extensMoreLine, KY13.GREY13 copyBookDetailForDataElt, String name) {
        PacDataCallMore pacDataCallMor = null;
        if (extensMoreLine != null && extensMoreLine.size() > 0 && (pacDataCallMor = (PacDataCallMore)extensMoreLine.get(0)) != null) {
            copyBookDetailForDataElt.set_SCONT_Value(pacDataCallMor.getControlType().toString());
            copyBookDetailForDataElt.get_GRVCONT_Groupe_Value().set_CA_Value(pacDataCallMor.getControlValue().toString());
            if (pacDataCallMor.getUpdateTarget().length() > 0) {
                copyBookDetailForDataElt.set_GRCOFIM3_Value(pacDataCallMor.getUpdateTarget());
            }
        }
    }

    private KY01 prepLineForLibrary(KY01 copyBookLibrary, PacLibrary lib) {
        KY01.GRCLEKY cleKY = copyBookLibrary.get_GRCLEKY_Groupe_Value();
        cleKY.set_GRD1_Value("01");
        KY01.GRPR01 ky01PR01 = copyBookLibrary.get_GRPR01_Groupe_Value();
        KY01.GRPR01.GRNOBIB7 ky01NOBIB7 = ky01PR01.get_GRNOBIB7_Groupe_Value();
        ky01NOBIB7.set_APPLI_Value(lib.getName());
        ky01NOBIB7.set_LIBIB_Value(lib.getLabel());
        ky01NOBIB7.set_INVDA_Value(" ");
        ky01NOBIB7.set_CARVE_Value(lib.getCobolType().getName().substring(1));
        ky01NOBIB7.set_OPTET_Value("*");
        ky01NOBIB7.set_OPTET_Value(" ");
        ky01NOBIB7.set_NLPAG_Value("60");
        ky01NOBIB7.set_SUPSA_Value("O");
        ky01NOBIB7.set_SUPCO_Value("O");
        ky01NOBIB7.set_R7_Value("N");
        ky01NOBIB7.set_OPAVP_Value(" ");
        ky01NOBIB7.set_OPAPR_Value(" ");
        ky01NOBIB7.set_LANGA_Value(String.valueOf(lib.getGeneratedLanguage()).substring(1));
        ky01NOBIB7.set_VARIA_Value(String.valueOf(lib.getCobolType().getName().substring(1)));
        ky01NOBIB7.set_TYPRO_Value("P");
        ky01NOBIB7.set_APPLIC_Value(lib.getName());
        ky01NOBIB7.set_R8_Value("N");
        ky01NOBIB7.set_NIVEAU_Value("3");
        ky01NOBIB7.set_ETABI_Value("1");
        ky01NOBIB7.set_BIPOR_Value("A0A1");
        ky01NOBIB7.set_CVEXT_Value("1");
        ky01NOBIB7.set_QUOTE_Value(String.valueOf(lib.getAlphanumericDelimiter()));
        ky01NOBIB7.set_FORDA_Value(String.valueOf(lib.getGeneratedDateFormat()).substring(1));
        ky01NOBIB7.set_DECPO_Value(String.valueOf(lib.getDecimalPointDelimiter()));
        ky01NOBIB7.set_VARIB_Value(String.valueOf(lib.getMapType()).substring(1));
        ky01NOBIB7.set_COFOR_Value(" ");
        ky01NOBIB7.set_SECUR_Value(" ");
        ky01NOBIB7.set_CARHO_Value(" ");
        ky01NOBIB7.set_FILLER0_Value(" ");
        ky01NOBIB7.set_DACTYR_Value("N");
        ky01NOBIB7.set_DACTYV_Value(String.valueOf(lib.getCenturyReferenceYear()));
        String day = "00" + String.valueOf(GregorianCalendar.getInstance().get(5));
        String month = "00" + String.valueOf(GregorianCalendar.getInstance().get(2) + 1);
        String year = "0000" + String.valueOf(GregorianCalendar.getInstance().get(1));
        String todayDate = String.valueOf(day.substring(day.length() - 2)) + "/" + month.substring(month.length() - 2) + "/" + year.substring(year.length() - 4);
        KY01.GRSESSI ky01SESSI = copyBookLibrary.get_GRSESSI_Groupe_Value();
        ky01SESSI.set_NUSES_Value("9999");
        ky01SESSI.set_NSVER_Value("000");
        ky01SESSI.set_ETSES_Value(" ");
        PacGeneratedSkeletonLanguageValues generationLang = lib.getSkeletonLanguage();
        copyBookLibrary.set_XLANG_Value(generationLang == PacGeneratedSkeletonLanguageValues._EN_LITERAL ? "E" : "F");
        copyBookLibrary.set_CODUTI_Value("ADMIN   ");
        copyBookLibrary.set_DATEC_Value(todayDate);
        copyBookLibrary.set_PASUTI_Value("ADMIN   ");
        copyBookLibrary.set_CTRAN_Value("BVAP");
        if (System.getProperty("CopyBookGeneration.W1.junit.process") != null) {
            copyBookLibrary.set_DATEC_Value("JUNIT ");
            copyBookLibrary.set_XLANG_Value("E");
        }
        return copyBookLibrary;
    }

    private KY1A instanciateKY1A(String name) {
        KY1A copyBookLinesForDataStruct = new KY1A();
        KY1A.GRCLEKY cleKY = copyBookLinesForDataStruct.get_GRCLEKY_Groupe_Value();
        cleKY.set_GRD1_Value("01");
        cleKY.set_COFIC_Value(name);
        cleKY.set_B3_Value("A ");
        return copyBookLinesForDataStruct;
    }

    private KY13 instanciateKY13() {
        ++this.numberOfCorub;
        KY13 copyBookLinesForDataAggregateC = new KY13();
        KY13.GRCLEKY cleKY13C = copyBookLinesForDataAggregateC.get_GRCLEKY_Groupe_Value();
        cleKY13C.set_GRD1_Value("01");
        cleKY13C.set_COFIC_Value(this.dataAggregateName.substring(0, 2));
        cleKY13C.set_GRD3_Value("100");
        cleKY13C.set_B2_Value(this.getDsCode());
        cleKY13C.set_B3_Value("3 ");
        cleKY13C.set_B4_Value(this.dataAggregateName.substring(2));
        cleKY13C.set_B7_Value(this.numberOfCorubS.nextString());
        KY13.GREY13 EY13 = copyBookLinesForDataAggregateC.get_GREY13_Groupe_Value();
        EY13.set_REPET_Value(this.getStringFromInt(this.currentDataCall.getMaximumCardinality()));
        EY13.set_NUMER_Value(this.numberOfCorub);
        return copyBookLinesForDataAggregateC;
    }

    void setNameOfProject(String projectName) {
        this.nameOfProject = projectName;
    }

    String getNameOfProject() {
        return this.nameOfProject;
    }

    private PacbaseLinksEntitiesService getPacLinksEntitiesService() {
        return this.ples;
    }

    private void formatKY22(PacDLine pPacDLine, KY22.GRPR22.GRENREG ky22enreg) {
        String allowedVal = pPacDLine.getAllowedValues();
        ky22enreg.get_GRCARTE6_Groupe_Value().set_VALRU_Value(allowedVal);
        ky22enreg.get_GRCARTE6_Groupe_Value().set_TYCOD_Value(pPacDLine.getLineType());
        ky22enreg.get_GRCARTE6_Groupe_Value().set_SAVED_Value(pPacDLine.getMore());
        ky22enreg.get_GRCARTE6_Groupe_Value().set_GRSIGNI_Value(pPacDLine.getDescription());
        ky22enreg.get_GRCARTE6_Groupe_Value().get_GRXDECOD_Groupe_Value().set_TYVAL_Value("V");
        ky22enreg.get_GRCARTE6_Groupe_Value().set_GRTABTC_Value("000000000");
        if (allowedVal != null && allowedVal.length() > 0) {
            if (allowedVal.contains("(") || allowedVal.contains(")")) {
                ky22enreg.get_GRCARTE6_Groupe_Value().get_GRXDECOD_Groupe_Value().set_TYVAL_Value("B");
            }
            String firstAllowedVal = allowedVal.substring(0, 1);
            String lastAllowedVal = " ";
            int lgValue = allowedVal.length();
            lastAllowedVal = allowedVal.length() > 9 ? allowedVal.substring(9, 10) : allowedVal.substring(lgValue - 1);
            if (firstAllowedVal.equals(")") || firstAllowedVal.equals("(")) {
                ky22enreg.get_GRCARTE6_Groupe_Value().get_GRXDECOD_Groupe_Value().set_TYBORI_Value(firstAllowedVal);
                if (!lastAllowedVal.equals(")") && !lastAllowedVal.equals("(")) {
                    ky22enreg.get_GRCARTE6_Groupe_Value().get_GRXDECOD_Groupe_Value().set_BORNEI_Value(" " + allowedVal.substring(1));
                } else {
                    int blancCar = allowedVal.indexOf(" ");
                    ky22enreg.get_GRCARTE6_Groupe_Value().get_GRXDECOD_Groupe_Value().set_BORNEI_Value(allowedVal.substring(1, blancCar));
                    ky22enreg.get_GRCARTE6_Groupe_Value().get_GRXDECOD_Groupe_Value().set_BORNES_Value(allowedVal.substring(++blancCar, --lgValue));
                }
            }
            if (lastAllowedVal.equals(")") || lastAllowedVal.equals("(")) {
                ky22enreg.get_GRCARTE6_Groupe_Value().get_GRXDECOD_Groupe_Value().set_TYBORS_Value(lastAllowedVal);
                if (!firstAllowedVal.equals(")") && !firstAllowedVal.equals("(")) {
                    ky22enreg.get_GRCARTE6_Groupe_Value().get_GRXDECOD_Groupe_Value().set_BORNES_Value(allowedVal.substring(0, --lgValue));
                }
            }
        }
    }
}

