/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.copybook.dataUnit;

import com.ibm.pdp.engine.IEngineFactory;
import com.ibm.pdp.engine.IGeneratedInfoFactory;
import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.framework.util.PdpUtil;
import com.ibm.pdp.mdl.pacbase.PacCopybook;
import com.ibm.pdp.mdl.pacbase.util.PacCopybookWrapper;
import com.ibm.pdp.pacbase.copybook.dataUnit.CopyBookGenerationDU;
import com.ibm.pdp.pacbase.generate.DefaultPacbaseGenerationImplementation;
import com.ibm.pdp.pacbase.generate.util.PacbaseLinksEntitiesService;
import com.ibm.pdp.pacbase.generate.util.PacbaseModelService;
import com.ibm.pdp.util.Util;
import java.io.File;

public class CopyBookGenerationDataUnit
extends DefaultPacbaseGenerationImplementation {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014,2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String project;
    private PacCopybook copyBook;
    private CopyBookGenerationDU w1Model = null;
    private String dbFileName = "";
    private static String w3CmdFile = isUnix ? "/../../script_linux/GCD35.sh" : "/GCD35.cmd";

    public PacbaseLinksEntitiesService getReferencedEntities() {
        return this.w1Model.getPacLinksEntitiesService();
    }

    public CopyBookGenerationDataUnit(PacCopybook bb, String patternName) {
        this.patternName = patternName;
        this.copyBook = new PacCopybookWrapper(bb);
        this.project = bb.getProject();
        int resolMode = PTEditorService.getResolvingMode();
        PTEditorService.setResolvingMode((int)3);
        this.initCopyBook();
        PTEditorService.setResolvingMode((int)resolMode);
    }

    private void initCopyBook() {
        try {
            File f = File.createTempFile("copybook", ".tmp", new File(System.getProperty("java.io.tmpdir")));
            f.deleteOnExit();
            this.dbFileName = f.getAbsolutePath();
            this.findAndGetW1File();
            this.vapCobolGeneration();
            this.transformToGeneratedInfo();
        }
        catch (Exception e) {
            e.printStackTrace();
            Util.rethrow((Throwable)e);
        }
    }

    private void findAndGetW1File() {
        this.w1Model = new CopyBookGenerationDU(this.getProject(), this.getCopyBook(), this.patternName);
    }

    private String getProject() {
        return this.project;
    }

    public PacCopybook getCopyBook() {
        return this.copyBook;
    }

    protected String[] getCommandLineForgenerator() {
        String[] cmd = new String[]{"", "", "", "", "", "", "", "", ""};
        String userdir1 = PacbaseModelService.getInstance().getCommandFileForGeneration("/data/generator").getAbsolutePath();
        cmd[0] = String.valueOf(userdir1) + File.separator + w3CmdFile;
        cmd[1] = userdir1;
        cmd[2] = Util.GetRandomString((int)6);
        String tempdir = System.getProperty("java.io.tmpdir");
        int end = tempdir.length();
        cmd[3] = isUnix ? tempdir : tempdir.substring(0, --end);
        cmd[4] = this.dbFileName;
        cmd[5] = this.getResultTmpFile().getAbsolutePath();
        cmd[6] = this.copyBook.getGenerationParameter().getSkeletonLanguage().getLiteral().substring(1);
        cmd[7] = userdir1.substring(0, 2);
        cmd[8] = this.getResultTmpFileForAlias().getAbsolutePath();
        return cmd;
    }

    private void transformToGeneratedInfo() {
        try {
            String generated = CopyBookGenerationDataUnit.ReadFileContents((String)this.dbFileName);
            IEngineFactory engineFactory = PdpUtil.newEngineFactory();
            IGeneratedInfoFactory genInfoFactory = engineFactory.newGeneratedInfoFactory();
            genInfoFactory.beginTag(this.copyBook.getName());
            genInfoFactory.appendText((CharSequence)generated);
            genInfoFactory.endTag();
            this.generatedInfo = genInfoFactory.createGeneratedInfo();
            this.generatedInfo.setProperty("pattern", "com.ibm.pdp.pacbase.copybook");
            this.generatedInfo.setProperty("ReconcileMode", "NoReconcile");
        }
        catch (Exception e) {
            e.printStackTrace();
            Util.rethrow((Throwable)e);
        }
    }

    protected File getResultTmpFile() {
        return this.w1Model.getResultTmpFile();
    }

    protected File getResultTmpFileForAlias() {
        return this.w1Model.getResultTmpFileForAlias();
    }
}

