/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pacbase.copybook.dataUnit;

import com.ibm.pdp.mdl.pacbase.PacCopybook;
import com.ibm.pdp.pacbase.coopybook.model.PacbaseSegment;
import com.ibm.pdp.pacbase.copybook.dataUnit.KY00PacbaseAndKernelVisitor;
import com.ibm.pdp.pacbase.generate.util.PacbaseLinksEntitiesService;
import com.ibm.pdp.pacbase.generate.util.PacbaseModelService;
import com.ibm.pdp.pacbase.util.EBCDICCompare;
import com.ibm.pdp.util.Util;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

public class CopyBookGenerationDU {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    ArrayList<Object> list = new ArrayList();
    private KY00PacbaseAndKernelVisitor ky00pkvisitor;
    private String project;
    private PacbaseLinksEntitiesService ples;
    private PacCopybook copyBook;
    private File resultTmpFile;
    private File resultTmpFileForAlias;
    private String patternName;
    final Comparator<PacbaseSegment> ebcdicCmp = new Comparator<PacbaseSegment>(){

        @Override
        public int compare(PacbaseSegment object1, PacbaseSegment object2) {
            return EBCDICCompare.stringCompare((String)object1.toString().substring(0, 41), (String)object2.toString().substring(0, 41));
        }
    };

    public CopyBookGenerationDU(String project, PacCopybook copyB, String patternName) {
        this.patternName = patternName;
        this.project = project;
        this.copyBook = copyB;
        this.transformToW1Model();
    }

    private void transformToW1Model() {
        this.scanPacbaseModel();
        try {
            this.writeCopyBook();
            this.writeAliasCopyBook();
        }
        catch (Exception e) {
            this.handleException(e);
            Util.rethrow((Throwable)e);
        }
    }

    private void scanPacbaseModel() {
        this.ky00pkvisitor = new KY00PacbaseAndKernelVisitor(this.getPacLinksEntitiesService());
        this.ky00pkvisitor.setNameOfProject(this.project);
        this.ky00pkvisitor.doSwitch((EObject)this.copyBook);
    }

    private void writeCopyBook() {
        this.resultTmpFile = PacbaseModelService.getInstance().createTmpFileForGeneration("gcd", true);
        if (System.getProperty("CopyBookGeneration.W1.junit.process") != null) {
            System.setProperty("CopyBookGeneration.W1.junit.process", this.resultTmpFile.getAbsolutePath());
        }
        try {
            FileWriter fileOutStream1 = new FileWriter(this.resultTmpFile);
            PrintWriter w1OutStream = new PrintWriter(fileOutStream1);
            List<PacbaseSegment> l = this.ky00pkvisitor.getCopyBookLines();
            Collections.sort(l, this.ebcdicCmp);
            for (PacbaseSegment lineX : l) {
                String lineS = lineX.getCompleteContentForSegment();
                w1OutStream.write(String.valueOf(lineS) + System.getProperty("line.separator"));
            }
            w1OutStream.close();
        }
        catch (Exception e) {
            Util.rethrow((Throwable)e);
        }
    }

    private void writeAliasCopyBook() {
        this.resultTmpFileForAlias = PacbaseModelService.getInstance().createTmpFileForGeneration("gcd", true);
        if (System.getProperty("CopyBookGeneration.W2.junit.process") != null) {
            System.setProperty("CopyBookGeneration.W2.junit.process", this.resultTmpFileForAlias.getAbsolutePath());
        }
        try {
            FileWriter fileOutStream1 = new FileWriter(this.resultTmpFileForAlias);
            PrintWriter w1OutStream = new PrintWriter(fileOutStream1);
            List<PacbaseSegment> l = this.ky00pkvisitor.getAliasCopyBookLines();
            Collections.sort(l, this.ebcdicCmp);
            for (PacbaseSegment lineX : l) {
                String lineS = lineX.getCompleteContentForSegment();
                w1OutStream.write(String.valueOf(lineS) + System.getProperty("line.separator"));
            }
            w1OutStream.close();
        }
        catch (Exception e) {
            Util.rethrow((Throwable)e);
        }
    }

    private void handleException(Exception exc) {
        System.out.println("*** ERROR ***");
        exc.printStackTrace();
        System.out.println("*** ***** ***");
    }

    public PacbaseLinksEntitiesService getPacLinksEntitiesService() {
        if (this.ples == null) {
            this.ples = new PacbaseLinksEntitiesService(this.patternName);
        }
        return this.ples;
    }

    protected File getResultTmpFile() {
        return this.resultTmpFile;
    }

    protected void setResultTmpFile(File resultFile) {
        this.resultTmpFile = resultFile;
    }

    protected File getResultTmpFileForAlias() {
        return this.resultTmpFileForAlias;
    }

    protected void setResultTmpFileForAlias(File resultFileForAlias) {
        this.resultTmpFileForAlias = resultFileForAlias;
    }
}

