/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.server.view;

import com.ibm.pdp.explorer.model.PTLocation;
import com.ibm.pdp.explorer.plugin.IPTPreferences;
import com.ibm.pdp.explorer.plugin.PTExplorerPlugin;
import com.ibm.pdp.explorer.view.IPTSerializableView;
import com.ibm.pdp.explorer.view.PTView;
import com.ibm.pdp.explorer.view.action.PTCancelResultAction;
import com.ibm.pdp.explorer.view.action.PTExportQueryAction;
import com.ibm.pdp.explorer.view.actiongroup.PTRemoveMatchesActionGroup;
import com.ibm.pdp.explorer.view.actiongroup.PTSearchRefActionGroup;
import com.ibm.pdp.explorer.view.service.IPTView;
import com.ibm.pdp.explorer.view.service.PTWidgetTool;
import com.ibm.pdp.explorer.view.tool.PTAttributeItem;
import com.ibm.pdp.explorer.view.tool.PTSerializerConfiguration;
import com.ibm.pdp.pac.explorer.action.PacHistoryDropdownAction;
import com.ibm.pdp.pac.explorer.action.PacRemoveMatchesAction;
import com.ibm.pdp.pac.explorer.action.PacSearchInReplayAction;
import com.ibm.pdp.pac.explorer.action.PacTreeViewerAction;
import com.ibm.pdp.pac.explorer.actiongroup.PacRemoveMatchesActionGroup;
import com.ibm.pdp.pac.explorer.model.PacSearchInDetail;
import com.ibm.pdp.pac.explorer.model.PacSearchInFile;
import com.ibm.pdp.pac.explorer.model.PacSearchInItem;
import com.ibm.pdp.pac.explorer.view.PacViewLabel;
import com.ibm.pdp.pac.explorer.view.provider.PacDetailContentProvider;
import com.ibm.pdp.pac.explorer.view.provider.PacDetailLabelProvider;
import com.ibm.pdp.pac.explorer.view.tool.PacUsageSerializableItem;
import com.ibm.pdp.pac.explorer.view.tool.PacUsageSerializer;
import com.ibm.pdp.pac.server.action.PacServerSearchDetailsTask;
import com.ibm.pdp.pac.server.action.PacServerShowDetailsAction;
import com.ibm.pdp.pac.server.action.PacServerShowMatchesAction;
import com.ibm.pdp.pac.server.action.PacServerTreeViewerAction;
import com.ibm.pdp.pac.server.actiongroup.PacServerShowMatchesActionGroup;
import com.ibm.pdp.pac.server.model.PacServerSearchInFile;
import com.ibm.pdp.pac.server.model.PacServerSearchInFolder;
import com.ibm.pdp.pac.server.model.PacServerSearchInProject;
import com.ibm.pdp.pac.server.plugin.PacServerPlugin;
import com.ibm.pdp.pac.server.result.PacServerSearchInResult;
import com.ibm.pdp.server.view.action.PTSparseLoadAction;
import com.ibm.pdp.server.view.actiongroup.PTServerOpenActionGroup;
import com.ibm.pdp.util.Util;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;

public class PacServerSearchInView
extends PTView
implements IPTSerializableView,
IPTPreferences {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String _VIEW_ID = String.valueOf(PacServerSearchInView.class.getName()) + "_ID";
    private PacServerSearchInResult _inputResult = null;
    private Label _lblHeader;
    private PacServerShowMatchesAction _showNextAction;
    private PacServerShowMatchesAction _showPreviousAction;
    private PacRemoveMatchesAction _removeSelectedAction;
    private PacRemoveMatchesAction _removeAllAction;
    private PacServerTreeViewerAction _expandAction;
    private PacServerTreeViewerAction _collapseAction;
    private PacSearchInReplayAction _replayAction;
    private PTCancelResultAction _cancelAction;
    private PacHistoryDropdownAction _historyAction;
    private PTExportQueryAction _exportQueryAction;
    private PTServerOpenActionGroup _openActionGroup;
    private PTSparseLoadAction _sparseLoadAction;
    private PacServerShowMatchesActionGroup _showActionGroup;
    private PacRemoveMatchesActionGroup _removeActionGroup;
    private PTSearchRefActionGroup _searchRefActionGroup;
    private PacServerShowDetailsAction _showDetailsAction;

    public static PacServerSearchInView getFromActivePerspective() {
        IViewPart view = PTExplorerPlugin.getActivePage().findView(_VIEW_ID);
        if (view instanceof PacServerSearchInView) {
            return (PacServerSearchInView)view;
        }
        return null;
    }

    public static PacServerSearchInView openInActivePerspective() {
        try {
            return (PacServerSearchInView)PTExplorerPlugin.getActivePage().showView(_VIEW_ID);
        }
        catch (PartInitException e) {
            throw Util.rethrow((Throwable)e);
        }
    }

    public Object getInput() {
        return this._inputResult;
    }

    public List<?> getHistoryEntries() {
        return PacServerPlugin.getSearchInResults();
    }

    protected String getContextId() {
        return "com.ibm.pdp.server.doc.cshelp.use_server";
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 1;
        gridLayout.marginHeight = 1;
        gridLayout.verticalSpacing = 1;
        gridLayout.horizontalSpacing = 1;
        parent.setLayout((Layout)gridLayout);
        this._lblHeader = PTWidgetTool.createLabel((Composite)parent, (String)"");
        this._trvViewer = PTWidgetTool.createTreeViewer((Composite)parent, (boolean)true);
        this._trvViewer.setUseHashlookup(true);
        this._trvViewer.setContentProvider((IContentProvider)new PacDetailContentProvider());
        this._trvViewer.setLabelProvider((IBaseLabelProvider)new PacDetailLabelProvider());
        this._trvViewer.setInput(new ArrayList());
        this._trvViewer.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                Object object = event.getElement();
                if (object instanceof PacServerSearchInFile) {
                    final PacServerSearchInFile file = (PacServerSearchInFile)((Object)object);
                    if (!file.isParsed()) {
                        PacServerSearchDetailsTask task = new PacServerSearchDetailsTask(PacServerSearchInView.this._trvViewer, PacServerSearchInView.this._inputResult, file);
                        task.syncExec();
                    }
                    PacServerSearchInView.this.getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            PacServerSearchInView.this._trvViewer.expandToLevel((Object)file, 1);
                        }
                    });
                }
            }

            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        this._trvViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object object = selection.getFirstElement();
                if (object instanceof PacServerSearchInProject || object instanceof PacServerSearchInFolder) {
                    PacTreeViewerAction action = new PacTreeViewerAction((IPTView)PacServerSearchInView.this);
                    action.switchState(object);
                } else if (object instanceof PacSearchInDetail || object instanceof PacServerSearchInFile) {
                    PacServerSearchInView.this._showDetailsAction.run();
                }
            }
        });
        this._trvViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.stateMask == 262144) {
                    if (event.character == '.') {
                        PacServerSearchInView.this._showNextAction.run();
                    } else if (event.character == ',') {
                        PacServerSearchInView.this._showPreviousAction.run();
                    }
                } else if (event.stateMask == 393216) {
                    if (event.character == '.') {
                        PacServerSearchInView.this._showNextAction.run();
                    }
                } else if (event.keyCode == 127) {
                    PacServerSearchInView.this._removeSelectedAction.run();
                } else if (event.keyCode == 0x100000C) {
                    System.out.println("openAction.run();");
                }
            }
        });
        this._trvViewer.addSelectionChangedListener((ISelectionChangedListener)this._statusBarManager);
        this._showNextAction = new PacServerShowMatchesAction((IPTView)this, 0);
        this._showPreviousAction = new PacServerShowMatchesAction((IPTView)this, 1);
        this._removeSelectedAction = new PacRemoveMatchesAction((IPTView)this, 0);
        this._removeAllAction = new PacRemoveMatchesAction((IPTView)this, 1);
        this._expandAction = new PacServerTreeViewerAction((IPTView)this, 4);
        this._collapseAction = new PacServerTreeViewerAction((IPTView)this, 2);
        this._replayAction = new PacSearchInReplayAction((IPTView)this);
        this._cancelAction = new PTCancelResultAction((IPTView)this);
        this._historyAction = new PacHistoryDropdownAction((IPTView)this);
        this._exportQueryAction = new PTExportQueryAction((IPTSerializableView)this);
        this._openActionGroup = new PTServerOpenActionGroup((IPTView)this);
        this._sparseLoadAction = new PTSparseLoadAction((IPTView)this);
        this._showActionGroup = new PacServerShowMatchesActionGroup((IPTView)this);
        this._removeActionGroup = new PacRemoveMatchesActionGroup((IPTView)this);
        this._searchRefActionGroup = new PTSearchRefActionGroup((IPTView)this);
        this._showDetailsAction = new PacServerShowDetailsAction((IPTView)this);
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        this.fillToolBarMenu(toolBarManager);
        IMenuManager barMenuMgr = this.getViewSite().getActionBars().getMenuManager();
        barMenuMgr.setRemoveAllWhenShown(true);
        this.fillActionBarMenu(barMenuMgr);
        barMenuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                PacServerSearchInView.this.fillActionBarMenu(menu);
            }
        });
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                PacServerSearchInView.this.fillContextMenu(menu);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this._trvViewer.getTree());
        this._trvViewer.getTree().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this._trvViewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this._trvViewer);
        this.setupData();
    }

    private void setupData() {
        this.refresh();
    }

    public void setInput(Object inputObject) {
        AbstractMap inputMap = new HashMap();
        if (inputObject instanceof PacServerSearchInResult) {
            this._inputResult = (PacServerSearchInResult)((Object)inputObject);
            inputMap = this._inputResult.getProjects();
        } else {
            this._inputResult = null;
        }
        this._trvViewer.setInput(inputMap);
        this.expandFirst();
        this.refresh();
    }

    private void expandFirst() {
        if (this._inputResult == null) {
            return;
        }
        Object matchObject = this._inputResult.getMatchObject(null, true);
        if (matchObject instanceof PacServerSearchInFile) {
            PacServerSearchInFile matchFile = (PacServerSearchInFile)((Object)matchObject);
            PacServerSearchDetailsTask task = new PacServerSearchDetailsTask(this._trvViewer, this._inputResult, matchFile);
            task.syncExec();
            this.getTreeViewer().expandToLevel((Object)matchFile, 1);
            this.setStructuredSelection((IStructuredSelection)new StructuredSelection((Object)matchFile));
        }
    }

    public void refresh() {
        if (this._inputResult != null) {
            this._trvViewer.refresh();
            this._lblHeader.setText(this._inputResult.getLabel());
        } else {
            this._lblHeader.setText("");
        }
        this.setTitleToolTip(this.getToolTip());
    }

    private String getToolTip() {
        StringBuilder buffer = new StringBuilder(this.getPartName());
        if (this._inputResult != null) {
            buffer.append(": ").append(this._inputResult.getSearchPattern().getName());
        }
        return buffer.toString();
    }

    private void fillToolBarMenu(IToolBarManager toolBarManager) {
        toolBarManager.add((IAction)this._showNextAction);
        toolBarManager.add((IAction)this._showPreviousAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this._removeSelectedAction);
        toolBarManager.add((IAction)this._removeAllAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this._expandAction);
        toolBarManager.add((IAction)this._collapseAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this._replayAction);
        toolBarManager.add((IAction)this._cancelAction);
        toolBarManager.add((IAction)this._historyAction);
        toolBarManager.add((IAction)this._exportQueryAction);
    }

    private void fillActionBarMenu(IMenuManager menu) {
    }

    private void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = this.getStructuredSelection();
        if (selection.size() > 0) {
            Object firstSelected = selection.getFirstElement();
            if (firstSelected instanceof PacServerSearchInFile) {
                menu.add((IContributionItem)new Separator(PTServerOpenActionGroup._SEPARATOR));
                this._openActionGroup.activateOpenWith();
                this._openActionGroup.fillContextMenu(menu);
                menu.add((IContributionItem)new Separator());
                this._sparseLoadAction.setEnabled(this._sparseLoadAction.isEnabled());
                menu.add((IAction)this._sparseLoadAction);
            }
            menu.add((IContributionItem)new Separator(PacServerShowMatchesActionGroup._SEPARATOR));
            this._showActionGroup.fillContextMenu(menu);
            menu.add((IContributionItem)new Separator(PTRemoveMatchesActionGroup._SEPARATOR));
            this._removeActionGroup.fillContextMenu(menu);
            menu.add((IContributionItem)new Separator(PTSearchRefActionGroup._SEPARATOR));
            this._searchRefActionGroup.fillContextMenu(menu);
        }
        menu.add((IContributionItem)new Separator("additions"));
    }

    public void locationSelected(PTLocation location) {
    }

    public void resourceChanged(IResourceDelta delta) {
    }

    public PTSerializerConfiguration getSerializerConfiguration() {
        PTAttributeItem[] allAttributes = new PTAttributeItem[]{new PTAttributeItem("Project"), new PTAttributeItem("Package"), new PTAttributeItem("Name"), new PTAttributeItem("Class"), new PTAttributeItem("LineNumber", PacViewLabel.getString((String)PacViewLabel._LINE_NUMBER)), new PTAttributeItem("Line", PacViewLabel.getString((String)PacViewLabel._LINE))};
        String[] defAttributeIds = new String[]{"Project", "Package", "Class", "Name", "LineNumber"};
        String prefKey = _VIEW_ID;
        return new PTSerializerConfiguration(allAttributes, defAttributeIds, prefKey);
    }

    public void serialize(final List<PTAttributeItem> preferredAttributes, final String outputFile) {
        if (this._inputResult == null) {
            return;
        }
        boolean serializeDetails = false;
        for (PTAttributeItem attributeItem : preferredAttributes) {
            if (!attributeItem.getId().equals("LineNumber") && !attributeItem.getId().equals("Line")) continue;
            serializeDetails = true;
            break;
        }
        final ArrayList<PacUsageSerializableItem> serializables = new ArrayList<PacUsageSerializableItem>();
        if (!serializeDetails) {
            for (PacSearchInFile searchInFile : this._inputResult.getFiles()) {
                PacUsageSerializableItem serializable = new PacUsageSerializableItem(searchInFile.getDocument());
                serializables.add(serializable);
            }
            PacUsageSerializer.processSerialization(serializables, preferredAttributes, (String)outputFile);
        } else {
            PacServerSearchDetailsTask task = new PacServerSearchDetailsTask(null, this._inputResult, null);
            task.asyncExec(new IJobChangeListener(){

                public void aboutToRun(IJobChangeEvent event) {
                }

                public void awake(IJobChangeEvent event) {
                }

                public void done(IJobChangeEvent event) {
                    for (PacSearchInFile searchInFile : PacServerSearchInView.this._inputResult.getFiles()) {
                        PacUsageSerializableItem serializable = new PacUsageSerializableItem(searchInFile.getDocument());
                        for (PacSearchInItem childItem : searchInFile.getChildren().values()) {
                            if (!(childItem instanceof PacSearchInDetail)) continue;
                            PacSearchInDetail searchInDetail = (PacSearchInDetail)childItem;
                            serializable.getDetails().put(new Integer(searchInDetail.getLineNumber()), searchInDetail.getLineContext());
                        }
                        serializables.add(serializable);
                    }
                    PacUsageSerializer.processSerialization((List)serializables, (List)preferredAttributes, (String)outputFile);
                }

                public void running(IJobChangeEvent event) {
                }

                public void scheduled(IJobChangeEvent event) {
                }

                public void sleeping(IJobChangeEvent event) {
                }
            });
        }
    }

    public void dispose() {
        super.dispose();
    }

    public String getContributorId() {
        return this.getSite().getId();
    }
}

