/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.server.result;

import com.ibm.pdp.explorer.model.PTModelManager;
import com.ibm.pdp.explorer.model.pattern.IPTInternalSearchPattern;
import com.ibm.pdp.explorer.model.service.IPTElement;
import com.ibm.pdp.explorer.model.tool.PTProjectScope;
import com.ibm.pdp.explorer.plugin.PTExplorerPlugin;
import com.ibm.pdp.mdl.meta.path.PTPath;
import com.ibm.pdp.pac.server.query.PacServerDesignAdvancedSearchQuery;
import com.ibm.pdp.server.model.PTServerElement;
import com.ibm.pdp.server.model.PTServerElementRow;
import com.ibm.pdp.server.model.PTServerFolder;
import com.ibm.pdp.server.model.PTServerLocation;
import com.ibm.pdp.server.model.PTServerPackage;
import com.ibm.pdp.server.model.PTServerProject;
import com.ibm.pdp.server.pattern.PTServerSearchPatternLabel;
import com.ibm.pdp.server.result.IPTServerDesignSearchResult;
import com.ibm.team.scm.common.IWorkspace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.search.ui.text.MatchEvent;

public class PacServerDesignAdvancedSearchResult
implements IPTServerDesignSearchResult {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2018, 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Set<ISearchResultListener> _listeners = new HashSet<ISearchResultListener>();
    private PacServerDesignAdvancedSearchQuery _advancedSearchQuery;
    private Map<String, PTServerLocation> _locations;
    private Map<String, PTServerLocation> _filteredLocations = null;
    private List<Object> _flatList = null;
    private int _topLevelMode;
    private Comparator<Object> _comparator = null;
    private Map<String, Map<String, Map<String, PTPath>>> _byStreamPaths = null;
    private List<PTServerElementRow> _elementRows = null;
    private List<PTServerElementRow> _filteredElementRows = null;

    public PacServerDesignAdvancedSearchResult(PacServerDesignAdvancedSearchQuery advancedSearchQuery) {
        this._advancedSearchQuery = advancedSearchQuery;
    }

    public void addListener(ISearchResultListener listener) {
        this._listeners.add(listener);
    }

    public void removeListener(ISearchResultListener listener) {
        this._listeners.remove(listener);
    }

    public String getLabel() {
        String searchLabel = "";
        if (this.getSearchPattern() != null) {
            searchLabel = this.getSearchPattern().getLabel();
        }
        String matchesNumber = Integer.toString(Math.max(0, this._advancedSearchQuery.getMatches()));
        Object[] array = new String[]{searchLabel, matchesNumber};
        return PTServerSearchPatternLabel.getString((String)PTServerSearchPatternLabel._SERVER_SEARCH_LABEL, (Object[])array);
    }

    public String getTooltip() {
        return this.getLabel();
    }

    public ImageDescriptor getImageDescriptor() {
        return PTExplorerPlugin.getDefault().getImageDescriptor("search_result");
    }

    public ISearchQuery getQuery() {
        return this._advancedSearchQuery;
    }

    public IPTInternalSearchPattern getSearchPattern() {
        return this._advancedSearchQuery.getSearchPattern();
    }

    public Object[] getMatchPath(int topLevelMode, Comparator<Object> comparator, Object current, boolean next) {
        if (this.getLocations().isEmpty()) {
            return null;
        }
        if (this._flatList == null || this._topLevelMode != topLevelMode || this._comparator != comparator) {
            this._flatList = new ArrayList<Object>();
            this._topLevelMode = topLevelMode;
            this._comparator = comparator;
            this.buildFlatList(this.getFilteredLocations().values().toArray());
        }
        int index = Math.max(this._flatList.indexOf(current), 0);
        int matchIndex = next ? this.getNextIndex(index) : this.getPreviousIndex(index);
        int folderIndex = this.getFolderIndex(matchIndex);
        return new Object[]{this._flatList.get(folderIndex), this._flatList.get(matchIndex)};
    }

    public void removeMatches(IStructuredSelection selection, boolean allMatches) {
        if (!allMatches) {
            this.removeSelection(selection.toList());
        } else {
            this.getFilteredLocations().clear();
            this.getFilteredElementRows().clear();
        }
        this._flatList = null;
    }

    public Map<String, Map<String, Map<String, PTPath>>> getByStreamPaths() {
        if (this._byStreamPaths == null) {
            this._byStreamPaths = new HashMap<String, Map<String, Map<String, PTPath>>>();
        }
        return this._byStreamPaths;
    }

    public Map<String, PTServerLocation> getLocations() {
        if (this._locations == null) {
            this._locations = new HashMap<String, PTServerLocation>();
        }
        return this._locations;
    }

    public Map<String, PTServerLocation> getFilteredLocations() {
        if (this._filteredLocations == null) {
            this._filteredLocations = new HashMap<String, PTServerLocation>();
        }
        return this._filteredLocations;
    }

    public void filterLocations(PTProjectScope projectScope) {
        Map<String, PTServerLocation> locations = this.getLocations();
        List<PTServerElementRow> elementRows = this.getElementRows();
        if (projectScope.getContext().trim().length() > 0) {
            this._filteredLocations = new HashMap<String, PTServerLocation>();
            for (Map.Entry<String, PTServerLocation> entry : locations.entrySet()) {
                String locationKey = entry.getKey();
                PTServerLocation location = entry.getValue();
                String locationName = location.getName();
                IWorkspace workspace = location.getWorkspace();
                String streamID = workspace.getItemId().getUuidValue();
                PTServerLocation filteredLocation = new PTServerLocation(locationName, workspace);
                Set retainedProjects = projectScope.getRetainedProjects(streamID, locationName);
                for (String projectName : retainedProjects) {
                    for (IPTElement element : location.getByProject(projectName)) {
                        if (!(element instanceof PTServerElement)) continue;
                        filteredLocation.addElement((PTServerElement)element);
                        this.getFilteredElementRows().add(new PTServerElementRow(location.getWorkspace(), (PTServerElement)element));
                    }
                }
                if (filteredLocation.getProjects().size() <= 0) continue;
                this._filteredLocations.put(locationKey, filteredLocation);
            }
        } else {
            this._filteredLocations = locations;
            this._filteredElementRows = elementRows;
        }
    }

    public List<PTServerElementRow> getElementRows() {
        if (this._elementRows == null) {
            this._elementRows = new ArrayList<PTServerElementRow>();
            for (PTServerLocation location : this.getLocations().values()) {
                for (IPTElement element : location.getElements().values()) {
                    if (!(element instanceof PTServerElement)) continue;
                    this._elementRows.add(new PTServerElementRow(location.getWorkspace(), (PTServerElement)element));
                }
            }
        }
        return this._elementRows;
    }

    public List<PTServerElementRow> getFilteredElementRows() {
        if (this._filteredElementRows == null) {
            this._filteredElementRows = new ArrayList<PTServerElementRow>();
        }
        return this._filteredElementRows;
    }

    public void searchResultChanged() {
        this._flatList = null;
        for (ISearchResultListener listener : this._listeners) {
            listener.searchResultChanged((SearchResultEvent)new MatchEvent((ISearchResult)this));
        }
    }

    public void reset() {
        this._locations = null;
        this._filteredLocations = null;
        this._elementRows = null;
        this._filteredElementRows = null;
        this._flatList = null;
    }

    private void buildFlatList(Object[] array) {
        int i = 0;
        while (i < array.length) {
            Map folders;
            Object object = array[i];
            this._flatList.add(object);
            Object[] sortedArray = new Object[]{};
            if (object instanceof PTServerLocation) {
                PTServerLocation location = (PTServerLocation)object;
                sortedArray = this._topLevelMode == 1 ? location.getFolders(PTModelManager.getPreferredFacet()).values().toArray() : (this._topLevelMode == 2 ? location.getPackages().values().toArray() : location.getProjects().values().toArray());
            } else if (object instanceof PTServerFolder) {
                PTServerFolder folder = (PTServerFolder)object;
                sortedArray = folder.getElements().toArray();
            } else if (object instanceof PTServerPackage) {
                PTServerPackage pkg = (PTServerPackage)object;
                folders = pkg.getFolders(PTModelManager.getPreferredFacet());
                sortedArray = folders.values().toArray();
            } else if (object instanceof PTServerProject) {
                PTServerProject project = (PTServerProject)object;
                folders = project.getFolders(PTModelManager.getPreferredFacet());
                sortedArray = folders.values().toArray();
            }
            Arrays.sort(sortedArray, this._comparator);
            this.buildFlatList(sortedArray);
            ++i;
        }
    }

    private int getNextIndex(int index) {
        int i = index = index >= this._flatList.size() ? 0 : index + 1;
        while (i < this._flatList.size()) {
            Object next = this._flatList.get(i);
            if (next instanceof PTServerElement) {
                return i;
            }
            ++i;
        }
        return this.getNextIndex(0);
    }

    private int getPreviousIndex(int index) {
        int i = index = index == 0 ? this._flatList.size() - 1 : index - 1;
        while (i >= 0) {
            Object previous = this._flatList.get(i);
            if (previous instanceof PTServerElement) {
                return i;
            }
            --i;
        }
        return this.getPreviousIndex(this._flatList.size());
    }

    private int getFolderIndex(int index) {
        int i = index;
        while (i >= 0) {
            Object previous = this._flatList.get(i);
            if (previous instanceof PTServerFolder) {
                return i;
            }
            --i;
        }
        return 0;
    }

    private void removeSelection(List<?> selection) {
        for (Object object : selection) {
            int i;
            Object[] elements;
            PTServerLocation location;
            if (object instanceof PTServerLocation) {
                PTServerLocation location2 = (PTServerLocation)object;
                this.getFilteredLocations().remove(location2);
                continue;
            }
            if (object instanceof PTServerFolder) {
                PTServerFolder folder = (PTServerFolder)object;
                location = folder.getLocation();
                elements = location.getByFolder(folder.getName()).toArray();
                i = 0;
                while (i < elements.length) {
                    location.removeElement((PTServerElement)elements[i]);
                    ++i;
                }
                continue;
            }
            if (object instanceof PTServerPackage) {
                PTServerPackage pkg = (PTServerPackage)object;
                location = pkg.getLocation();
                elements = location.getByPackage(pkg.getName()).toArray();
                i = 0;
                while (i < elements.length) {
                    location.removeElement((PTServerElement)elements[i]);
                    ++i;
                }
                continue;
            }
            if (object instanceof PTServerProject) {
                PTServerProject project = (PTServerProject)object;
                location = project.getLocation();
                elements = location.getByProject(project.getName()).toArray();
                i = 0;
                while (i < elements.length) {
                    location.removeElement((PTServerElement)elements[i]);
                    ++i;
                }
                continue;
            }
            if (object instanceof PTServerElement) {
                PTServerElement element = (PTServerElement)object;
                location = element.getLocation();
                if (location == null) continue;
                location.removeElement(element);
                continue;
            }
            if (!(object instanceof PTServerElementRow)) continue;
            PTServerElementRow elementRow = (PTServerElementRow)object;
            this.getFilteredElementRows().remove(elementRow);
            location = elementRow.getElement().getLocation();
            location.removeElement(elementRow.getElement());
        }
    }

    public void addPath(PTPath path) {
        Map<String, PTPath> paths;
        Map<String, Map<String, Map<String, PTPath>>> byStreamPaths = this.getByStreamPaths();
        Map<String, Map<String, PTPath>> byLocationPaths = byStreamPaths.get(path.getStreamID());
        if (byLocationPaths == null) {
            byLocationPaths = new HashMap<String, Map<String, PTPath>>();
            byStreamPaths.put(path.getStreamID(), byLocationPaths);
        }
        if ((paths = byLocationPaths.get(path.getLocationName())) == null) {
            paths = new HashMap<String, PTPath>();
            byLocationPaths.put(path.getLocationName(), paths);
        }
        paths.put(path.getProjectName(), path);
    }
}

