/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.server.query;

import com.ibm.pdp.explorer.model.PTModelManager;
import com.ibm.pdp.explorer.model.query.PTQueryStatus;
import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.pac.explorer.model.PacSearchInItem;
import com.ibm.pdp.pac.explorer.model.PacSearchInProject;
import com.ibm.pdp.pac.server.model.PacServerSearchInFile;
import com.ibm.pdp.pac.server.model.PacServerSearchInFolder;
import com.ibm.pdp.pac.server.model.PacServerSearchInProject;
import com.ibm.pdp.pac.server.pattern.PacServerSearchInPattern;
import com.ibm.pdp.pac.server.result.PacServerSearchInResult;
import com.ibm.pdp.server.model.reference.PTServerReferenceItem;
import com.ibm.pdp.server.page.PTServerPageLabel;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;

public class PacServerSearchInQuery
implements ISearchQuery {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private PacServerSearchInPattern _searchInPattern = null;
    private PacServerSearchInResult _searchInResult = null;

    public PacServerSearchInQuery(PacServerSearchInPattern searchInPattern) {
        this._searchInPattern = searchInPattern;
        this._searchInResult = new PacServerSearchInResult(this);
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return false;
    }

    public String getLabel() {
        return "SearchIn query label";
    }

    public PacServerSearchInPattern getSearchPattern() {
        return this._searchInPattern;
    }

    public ISearchResult getSearchResult() {
        return this._searchInResult;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        monitor.beginTask(PTServerPageLabel.getString((String)PTServerPageLabel._SEARCH_TASK), -1);
        this._searchInResult.reset();
        int matches = 0;
        String streamID = this.getSearchPattern().getStreamID();
        String componentID = this.getSearchPattern().getComponentID();
        Document metaDocument = this.getSearchPattern().getDocument();
        PTServerReferenceItem anchorItem = new PTServerReferenceItem(streamID, componentID, metaDocument);
        try {
            anchorItem.searchByRelationReferences("usage", monitor);
        }
        catch (TeamRepositoryException e) {
            throw new OperationCanceledException(String.valueOf(e.getMessage()) + "\n");
        }
        Pattern pattern = Pattern.compile(this.getSearchPattern().getRegexExpression(), this.getSearchPattern().getRegexFlags());
        for (PTServerReferenceItem referenceItem : anchorItem.getReferences()) {
            String itemFilePath;
            String itemComponentID;
            PacServerSearchInFile file;
            Document metaTarget = referenceItem.getDocument();
            StringBuilder buffer = new StringBuilder(metaTarget.getName());
            if (metaTarget.getMetaType().length() > 0) {
                buffer.append(".").append(metaTarget.getMetaType());
            }
            buffer.append(".").append(metaTarget.getType());
            String fullName = buffer.toString();
            if (!pattern.matcher(fullName).matches() || (file = this.addResult(streamID, itemComponentID = referenceItem.getComponentID(), itemFilePath = referenceItem.getFilePath(), referenceItem)) == null) continue;
            matches += file.getMatches();
        }
        this._searchInResult.setMatches(matches);
        this._searchInResult.searchResultChanged();
        return new PTQueryStatus();
    }

    private PacServerSearchInFile addResult(String streamID, String componentID, String fileName, PTServerReferenceItem referenceItem) {
        Path toParseFilePath;
        Document metaDocument = referenceItem.getDocument();
        int matches = (Integer)referenceItem.getRelations().get("usage");
        Path filePath = toParseFilePath = new Path(fileName);
        if (!PTModelManager.accept((String)metaDocument.getType())) {
            filePath = new Path(metaDocument.getId());
        }
        if (filePath.segmentCount() >= 2) {
            PacSearchInProject project = (PacSearchInProject)this._searchInResult.getProjects().get(filePath.segment(0));
            if (project == null) {
                project = new PacServerSearchInProject(filePath.segment(0), streamID, componentID);
                this._searchInResult.getProjects().put(project.getName(), project);
            }
            PacServerSearchInFolder folder = null;
            int i = 1;
            while (i < filePath.segmentCount() - 1) {
                PacSearchInProject parentItem = project;
                if (i > 1) {
                    parentItem = folder;
                }
                if ((folder = (PacServerSearchInFolder)((Object)parentItem.getChildren().get(filePath.segment(i)))) == null) {
                    folder = new PacServerSearchInFolder((PacSearchInItem)parentItem, filePath.segment(i));
                }
                ++i;
            }
            String name = filePath.segment(filePath.segmentCount() - 1);
            PacServerSearchInFile file = (PacServerSearchInFile)((Object)folder.getChildren().get(name));
            if (file == null) {
                file = new PacServerSearchInFile(folder, (IPath)toParseFilePath, metaDocument, matches);
                return file;
            }
        }
        return null;
    }
}

