/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.server.query;

import com.ibm.pdp.explorer.model.PTFacet;
import com.ibm.pdp.explorer.model.PTModelLabel;
import com.ibm.pdp.explorer.model.PTModelManager;
import com.ibm.pdp.explorer.model.PTPredefinedFolder;
import com.ibm.pdp.explorer.model.pattern.PTAdvancedSearchPatternColumn;
import com.ibm.pdp.explorer.model.service.PTModelService;
import com.ibm.pdp.explorer.plugin.IPTAdvancedSearchPattern;
import com.ibm.pdp.explorer.view.PTViewLabel;
import com.ibm.pdp.maf.rpp.kernel.RadicalElement;
import com.ibm.pdp.maf.rpp.pac.dataelement.DataElement;
import com.ibm.pdp.maf.rpp.service.impl.MAFModelManager;
import com.ibm.pdp.maf.rpp.util.impl.MAFResolver;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.UserEntity;
import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.mdl.meta.MetaFactory;
import com.ibm.pdp.mdl.meta.Property;
import com.ibm.pdp.mdl.meta.path.PTPath;
import com.ibm.pdp.mdl.meta.service.MetadataService;
import com.ibm.pdp.pac.explorer.model.PacModelManager;
import com.ibm.pdp.pac.explorer.page.PacPageLabel;
import com.ibm.pdp.pac.server.pattern.PacServerDesignAdvancedSearchPattern;
import com.ibm.pdp.pac.server.result.PacServerDesignAdvancedSearchResult;
import com.ibm.pdp.pac.server.view.PacServerViewLabel;
import com.ibm.pdp.server.common.IPTServerConstants;
import com.ibm.pdp.server.core.adapter.PTServerDesignAdvancedSearchQueryAdapter;
import com.ibm.pdp.server.core.adapter.PTServerDesignSearchQueryAdapter;
import com.ibm.pdp.server.core.pattern.PTServerDesignSearchPattern;
import com.ibm.pdp.server.model.PTServerElement;
import com.ibm.pdp.server.model.PTServerLocation;
import com.ibm.pdp.server.repository.PTRepositoryManager;
import com.ibm.pdp.server.response.PTDocumentResponse;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;

public class PacServerDesignAdvancedSearchQuery
implements ISearchQuery,
IPTServerConstants {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2018, 2023.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final int _PAGE_SIZE = 512;
    private PacServerDesignAdvancedSearchPattern _advancedSearchPattern = null;
    private PacServerDesignAdvancedSearchResult _advancedSearchResult = null;
    private int _matches = -1;
    private Map<String, IWorkspace> _streams;
    private Set<IWorkspace> _fetchedStreams;
    private IWorkspaceConnection _connection = null;
    private Map<String, IComponentHandle> _hComponents = new HashMap<String, IComponentHandle>();

    public PacServerDesignAdvancedSearchQuery(PacServerDesignAdvancedSearchPattern advancedSearchPattern, Map<String, IWorkspace> streams) {
        this._advancedSearchPattern = advancedSearchPattern;
        this._streams = streams;
        this._fetchedStreams = new HashSet<IWorkspace>();
        this._advancedSearchResult = new PacServerDesignAdvancedSearchResult(this);
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return false;
    }

    public String getLabel() {
        return PacServerViewLabel._SERVER_ADVANCED_DESIGN_SEARCH_TITLE;
    }

    public PacServerDesignAdvancedSearchPattern getSearchPattern() {
        return this._advancedSearchPattern;
    }

    public ISearchResult getSearchResult() {
        return this._advancedSearchResult;
    }

    public int getMatches() {
        return this._matches;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        if (!PTModelManager.getAcceptedTypes((String)PTModelManager.getPreferredFacet()).contains(this.getSearchPattern()._designType) && !this.getSearchPattern()._designType.equals("*")) {
            return new Status(0, "org.eclipse.ui", 0, "", null);
        }
        IPTAdvancedSearchPattern searchPattern = (IPTAdvancedSearchPattern)PacModelManager.getAdvancedSearchPatterns().get(this.getSearchPattern().getSearchPatternId());
        if (searchPattern == null) {
            return new Status(0, "org.eclipse.ui", 0, "", null);
        }
        this._matches = 0;
        this._advancedSearchResult.reset();
        Map patternParameters = this.getSearchPattern().getAcceptParameters();
        StringBuilder errorMessage = new StringBuilder();
        if (!searchPattern.checkParameters(patternParameters, errorMessage)) {
            if (errorMessage.length() > 0) {
                return new Status(4, "org.eclipse.ui", 0, errorMessage.toString(), null);
            }
            return new Status(0, "org.eclipse.ui", 0, "", null);
        }
        String message = PTViewLabel.getString((String)PTViewLabel._SEARCH_ERROR_LABEL, (Object[])new String[]{searchPattern.getDescription()});
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 4, message, null);
        Map<String, String> streamIDs = this.getRetainedStreamIDs();
        for (String streamID : streamIDs.keySet()) {
            String streamDisplayName = streamIDs.get(streamID);
            this._connection = null;
            monitor.beginTask(PacServerViewLabel.getString(PacServerViewLabel._SERVER_ADVANCED_DESIGN_SEARCH_TITLE), -1);
            String folderDisplayName = "";
            folderDisplayName = this.getSearchPattern()._designType.equals("*") ? PacPageLabel.getString((String)PacPageLabel._ALL_ENTITIES) : this.getFolderDisplayName(this.getSearchPattern()._designType);
            Object[] array = new String[]{folderDisplayName, streamDisplayName};
            monitor.setTaskName(PacServerViewLabel.getString(PacServerViewLabel._SERVER_ADVANCED_DESIGN_SEARCH_JOB1, array));
            Map<String, PTPath> allPaths = this.queryPaths(streamID, monitor);
            HashSet<String> projectNames = new HashSet<String>(this.getSearchPattern()._checkedProjects);
            if (this.getSearchPattern()._projectScope == 1) {
                for (String checkedProject : this.getSearchPattern()._checkedProjects) {
                    PTPath path = allPaths.get(checkedProject);
                    if (path == null) continue;
                    projectNames.addAll(path.getRequires());
                }
            }
            Map<String, List<PTDocumentResponse>> allDocResponses = this.queryFileProperties(streamID, this.getSearchPattern()._checkedProjects, monitor);
            Map<String, List<PTDocumentResponse>> allParentDocResponses = this.queryParentFileProperties(streamID, projectNames, allDocResponses, monitor);
            monitor.beginTask(PacServerViewLabel.getString(PacServerViewLabel._SERVER_ADVANCED_DESIGN_SEARCH_JOB1, array), allDocResponses.size());
            for (Map.Entry<String, List<PTDocumentResponse>> entry : allDocResponses.entrySet()) {
                String projectName = entry.getKey();
                List<PTDocumentResponse> docResponses = entry.getValue();
                ArrayList<String> requires = new ArrayList<String>();
                requires.add(projectName);
                PTPath path = allPaths.get(projectName);
                if (path != null) {
                    requires.addAll(path.getRequires());
                }
                if (this.getSearchPattern()._projectScope == 1 && !this.getSearchPattern()._checkedProjects.contains(projectName)) continue;
                array = new String[]{folderDisplayName, streamDisplayName, projectName};
                monitor.setTaskName(PacServerViewLabel.getString(PacServerViewLabel._SERVER_ADVANCED_DESIGN_SEARCH_JOB2, array));
                monitor.subTask("");
                int nbDesign = 0;
                HashMap<String, PTDocumentResponse> pageResponses = new HashMap<String, PTDocumentResponse>();
                int i = 0;
                while (i < docResponses.size()) {
                    PTDocumentResponse docResponse = docResponses.get(i);
                    pageResponses.put(docResponse.getFileItemID(), docResponse);
                    if (pageResponses.size() == 512 || i == docResponses.size() - 1) {
                        Map<Object, Object> pageContents = new HashMap();
                        try {
                            pageContents = this.retrieveDesignFileContents(streamID, docResponse.getComponentID(), pageResponses.keySet(), monitor);
                        }
                        catch (TeamRepositoryException teamRepositoryException) {}
                        for (String fileItemID : pageResponses.keySet()) {
                            PTDocumentResponse response = (PTDocumentResponse)pageResponses.get(fileItemID);
                            byte[] designContent = (byte[])pageContents.get(fileItemID);
                            RadicalEntity radicalObject = this.getRadicalEntity(designContent);
                            String metaType = "";
                            if (radicalObject instanceof UserEntity) {
                                URI uri = radicalObject.getMetaEntity().getDesignURI();
                                int j = 0;
                                while (j < uri.segmentCount()) {
                                    String segment = uri.segment(j);
                                    if (j >= uri.segmentCount() - 1) {
                                        metaType = segment.substring(0, segment.lastIndexOf("."));
                                    }
                                    ++j;
                                }
                            }
                            if (this.getSearchPattern()._designType.equals("*")) {
                                radicalObject = PTModelService.resolveResource((String)response.getDocument().getProject(), null, (String)radicalObject.getName(), (String)metaType, (String)response.getFilePath().substring(response.getFilePath().lastIndexOf(".") + 1));
                            }
                            RadicalElement radicalElement = null;
                            if (radicalObject != null) {
                                radicalElement = MAFModelManager.getInstance().getRadicalElement(radicalObject);
                            }
                            if (radicalElement != null) {
                                RadicalEntity proxyObject = MAFResolver.getInstance().getParent(radicalObject);
                                if (proxyObject != null && !this.getSearchPattern()._designType.equals("*")) {
                                    this.populateRegistry(requires, allParentDocResponses, proxyObject);
                                }
                                this.analyzeElement(searchPattern, response, radicalElement);
                            } else {
                                String msg = PacPageLabel.getString((String)PacPageLabel._LOAD_ARTIFACT, (Object[])new String[]{response.getFilePath()});
                                multiStatus.add((IStatus)new Status(0, "org.eclipse.ui", 0, msg, null));
                            }
                            array = new String[]{Integer.toString(++nbDesign), Integer.toString(docResponses.size())};
                            monitor.subTask(PTModelLabel.getString((String)PTModelLabel._SUB_TASK, (Object[])array));
                            if (monitor.isCanceled()) break;
                        }
                        pageResponses = new HashMap();
                        if (monitor.isCanceled()) break;
                    }
                    ++i;
                }
                if (monitor.isCanceled()) break;
                monitor.worked(1);
            }
            if (monitor.isCanceled()) break;
        }
        return multiStatus;
    }

    private void analyzeElement(IPTAdvancedSearchPattern searchPattern, PTDocumentResponse docResponse, RadicalElement radicalElement) {
        StringBuilder decoration = new StringBuilder("");
        boolean accept = searchPattern.accept((Object)radicalElement, this.getSearchPattern().getAcceptParameters(), decoration);
        if ("BOOLEAN".equals(this.getSearchPattern()._searchPatternKind) && this.getSearchPattern()._flip) {
            boolean bl = accept = !accept;
        }
        if (accept) {
            IWorkspace workspace;
            HashMap<String, String> columnValues = new HashMap<String, String>();
            for (PTAdvancedSearchPatternColumn advancedSearchColumn : searchPattern.getColumns()) {
                String columnValue = searchPattern.getColumnText((Object)radicalElement, advancedSearchColumn.getId());
                columnValues.put(advancedSearchColumn.getId(), columnValue);
            }
            PTServerElement element = new PTServerElement(docResponse);
            String locationID = String.valueOf(element.getLocationName()) + "/" + element.getStreamID();
            PTServerLocation location = this._advancedSearchResult.getLocations().get(locationID);
            if (location == null && (workspace = this._streams.get(element.getStreamID())) != null) {
                if (!this._fetchedStreams.contains(workspace)) {
                    PTRepositoryManager.fetchComponentNames((IWorkspace)workspace);
                }
                location = new PTServerLocation(element.getLocationName(), workspace);
                this._advancedSearchResult.getLocations().put(locationID, location);
            }
            Document metaDocument = docResponse.getDocument();
            metaDocument.setPackage(radicalElement.getPackage());
            metaDocument.setName(radicalElement.getName());
            if (this.getSearchPattern()._designType.equals("*")) {
                metaDocument.setType(docResponse.getFilePath().substring(docResponse.getFilePath().lastIndexOf(".") + 1));
            } else {
                metaDocument.setType(this.getSearchPattern()._designType);
            }
            if (radicalElement instanceof com.ibm.pdp.maf.rpp.kernel.impl.UserEntity) {
                metaDocument.setMetaType(((com.ibm.pdp.maf.rpp.kernel.impl.UserEntity)radicalElement).getMetaEntity().getName());
            }
            metaDocument.setLabel(radicalElement.getLabel());
            if (decoration.length() > 0) {
                Property metaProperty = MetaFactory.eINSTANCE.createProperty();
                metaProperty.setName("decoration");
                metaProperty.setValue(decoration.toString());
                metaDocument.getProperties().add(metaProperty);
            }
            for (Map.Entry entry : columnValues.entrySet()) {
                Property metaProperty = MetaFactory.eINSTANCE.createProperty();
                metaProperty.setName((String)entry.getKey());
                metaProperty.setValue((String)entry.getValue());
                metaDocument.getProperties().add(metaProperty);
            }
            if (location != null) {
                location.addElement(element);
                ++this._matches;
            }
        }
    }

    private String getFolderDisplayName(String designType) {
        PTFacet facet = PTModelManager.getFacet((String)PTModelManager.getPreferredFacet());
        for (PTPredefinedFolder predefinedFolder : facet.getFolders()) {
            if (!predefinedFolder.getName().equals(designType)) continue;
            return predefinedFolder.getDisplayName();
        }
        return "?";
    }

    private Map<String, String> getRetainedStreamIDs() {
        HashMap<String, String> streamIDs = new HashMap<String, String>();
        if (this.getSearchPattern()._streamScope == 1) {
            String streamID = this.getSearchPattern()._streamID;
            streamIDs.put(streamID, this.getSearchPattern()._streamIDs.get(streamID));
        } else if (this.getSearchPattern()._streamScope == 0) {
            streamIDs.putAll(this.getSearchPattern()._streamIDs);
        }
        return streamIDs;
    }

    private Map<String, PTPath> queryPaths(String streamID, IProgressMonitor monitor) {
        HashMap<String, PTPath> allPaths = new HashMap<String, PTPath>();
        try {
            List paths = Collections.emptyList();
            if (this.getSearchPattern() != null) {
                Set<String> emptySet = Collections.emptySet();
                PTServerDesignSearchPattern basicSearchPattern = this.getSearchPattern().getBasicSearchPattern(streamID, emptySet);
                paths = PTServerDesignSearchQueryAdapter.retrievePaths((String)streamID, (PTServerDesignSearchPattern)basicSearchPattern, (IProgressMonitor)monitor);
            }
            for (PTPath path : paths) {
                path.setStreamID(streamID);
                this._advancedSearchResult.addPath(path);
                allPaths.put(path.getProjectName(), path);
            }
        }
        catch (TeamRepositoryException e) {
            throw new OperationCanceledException(String.valueOf(e.getMessage()) + "\n");
        }
        return allPaths;
    }

    private Map<String, List<PTDocumentResponse>> queryFileProperties(String streamID, Set<String> projectNames, IProgressMonitor monitor) {
        List allDocResponses = Collections.emptyList();
        try {
            if (this.getSearchPattern() != null) {
                PTServerDesignSearchPattern basicSearchPattern = this.getSearchPattern().getBasicSearchPattern(streamID, projectNames);
                allDocResponses = PTServerDesignAdvancedSearchQueryAdapter.retrieveFileProperties((String)streamID, (PTServerDesignSearchPattern)basicSearchPattern, (IProgressMonitor)monitor);
            }
        }
        catch (TeamRepositoryException e) {
            throw new OperationCanceledException(String.valueOf(e.getMessage()) + "\n");
        }
        Map<String, PTPath> retainedPaths = this.getRetainedPaths(streamID);
        HashMap<String, List<PTDocumentResponse>> byProjectDocResponses = new HashMap<String, List<PTDocumentResponse>>();
        for (PTDocumentResponse docResponse : allDocResponses) {
            Document metaDocument = docResponse.getDocument();
            PTPath path = retainedPaths.get(metaDocument.getProject());
            if (path == null) continue;
            docResponse.setStreamID(streamID);
            docResponse.setLocation(path.getLocationName());
            ArrayList<PTDocumentResponse> docResponses = (ArrayList<PTDocumentResponse>)byProjectDocResponses.get(metaDocument.getProject());
            if (docResponses == null) {
                docResponses = new ArrayList<PTDocumentResponse>();
                byProjectDocResponses.put(metaDocument.getProject(), docResponses);
            }
            docResponses.add(docResponse);
        }
        return byProjectDocResponses;
    }

    private Map<String, List<PTDocumentResponse>> queryParentFileProperties(String streamID, Set<String> projectNames, Map<String, List<PTDocumentResponse>> allDocResponses, IProgressMonitor monitor) {
        HashMap<String, List<PTDocumentResponse>> byProjectParentDocResponses = new HashMap<String, List<PTDocumentResponse>>();
        if (DataElement.class.getSimpleName().equalsIgnoreCase(this.getSearchPattern()._designType)) {
            byProjectParentDocResponses.putAll(allDocResponses);
            projectNames.removeAll(this.getSearchPattern()._checkedProjects);
            if (projectNames.size() == 0) {
                return byProjectParentDocResponses;
            }
        }
        List allParentDocResponses = Collections.emptyList();
        try {
            PTServerDesignSearchPattern parentBasicSearchPattern;
            if (this.getSearchPattern() != null && (parentBasicSearchPattern = this.getSearchPattern().getParentBasicSearchPattern(streamID, projectNames)) != null) {
                allParentDocResponses = PTServerDesignAdvancedSearchQueryAdapter.retrieveFileProperties((String)streamID, (PTServerDesignSearchPattern)parentBasicSearchPattern, (IProgressMonitor)monitor);
            }
        }
        catch (TeamRepositoryException e) {
            throw new OperationCanceledException(String.valueOf(e.getMessage()) + "\n");
        }
        for (PTDocumentResponse parentDocResponse : allParentDocResponses) {
            Document metaDocument = parentDocResponse.getDocument();
            parentDocResponse.setStreamID(streamID);
            ArrayList<PTDocumentResponse> parentDocResponses = (ArrayList<PTDocumentResponse>)byProjectParentDocResponses.get(metaDocument.getProject());
            if (parentDocResponses == null) {
                parentDocResponses = new ArrayList<PTDocumentResponse>();
                byProjectParentDocResponses.put(metaDocument.getProject(), parentDocResponses);
            }
            parentDocResponses.add(parentDocResponse);
        }
        return byProjectParentDocResponses;
    }

    private byte[] retrieveDesignFileContent(String streamID, String componentID, String fileItemID, String filePath, IProgressMonitor monitor) throws TeamRepositoryException {
        byte[] contents = null;
        ITeamRepository teamRepository = PTRepositoryManager.getTeamRepository((String)streamID, (IProgressMonitor)monitor);
        if (teamRepository != null && this._connection == null) {
            this._connection = PTRepositoryManager.getConnection((ITeamRepository)teamRepository, (String)streamID, (IProgressMonitor)monitor);
        }
        if (this._connection == null) {
            return null;
        }
        IComponentHandle hComponent = this.getComponent(this._connection, componentID);
        IConfiguration configuration = this._connection.configuration(hComponent);
        if (configuration != null) {
            IFileItemHandle hFile = (IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)fileItemID), null);
            contents = PTRepositoryManager.getFileContent((ITeamRepository)teamRepository, (IConfiguration)configuration, (IFileItemHandle)hFile);
        }
        return contents;
    }

    private Map<String, byte[]> retrieveDesignFileContents(String streamID, String componentID, Collection<String> fileItemIDs, IProgressMonitor monitor) throws TeamRepositoryException {
        Map allContents = Collections.emptyMap();
        ITeamRepository teamRepository = PTRepositoryManager.getTeamRepository((String)streamID, (IProgressMonitor)monitor);
        if (teamRepository != null && this._connection == null) {
            this._connection = PTRepositoryManager.getConnection((ITeamRepository)teamRepository, (String)streamID, (IProgressMonitor)monitor);
        }
        if (this._connection == null) {
            return allContents;
        }
        IComponentHandle hComponent = this.getComponent(this._connection, componentID);
        IConfiguration configuration = this._connection.configuration(hComponent);
        if (configuration != null) {
            ArrayList<IFileItemHandle> hFiles = new ArrayList<IFileItemHandle>(fileItemIDs.size());
            for (String fileItemID : fileItemIDs) {
                IFileItemHandle hFile = (IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)fileItemID), null);
                hFiles.add(hFile);
            }
            allContents = PTRepositoryManager.getFileContents((ITeamRepository)teamRepository, (IConfiguration)configuration, hFiles);
        }
        return allContents;
    }

    private IComponentHandle getComponent(IWorkspaceConnection connection, String componentID) throws TeamRepositoryException {
        IComponentHandle hComponent = this._hComponents.get(componentID);
        if (hComponent == null) {
            for (Object object : connection.getComponents()) {
                IComponentHandle handle;
                if (!(object instanceof IComponentHandle) || !(handle = (IComponentHandle)object).getItemId().equals((Object)UUID.valueOf((String)componentID))) continue;
                hComponent = handle;
                this._hComponents.put(componentID, hComponent);
                break;
            }
        }
        return hComponent;
    }

    private RadicalEntity getRadicalEntity(byte[] designFileContent) {
        if (designFileContent != null) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(designFileContent);
            return PTModelService.getResource((InputStream)inputStream);
        }
        return null;
    }

    private void populateRegistry(List<String> paths, Map<String, List<PTDocumentResponse>> allParentDocResponses, RadicalEntity proxyObject) {
        String proxyURI = proxyObject.getProxyURI().lastSegment();
        MAFResolver.getInstance().getMAFPaths().clear();
        MAFResolver.getInstance().getMAFPaths().addAll(paths);
        for (String path : paths) {
            List<PTDocumentResponse> parentDocResponses = allParentDocResponses.get(path);
            if (parentDocResponses == null) continue;
            for (PTDocumentResponse docResponse : parentDocResponses) {
                if (!docResponse.getFilePath().endsWith(String.valueOf('/') + proxyURI)) continue;
                try {
                    byte[] designContent = this.retrieveDesignFileContent(docResponse.getStreamID(), docResponse.getComponentID(), docResponse.getFileItemID(), docResponse.getFilePath(), (IProgressMonitor)new NullProgressMonitor());
                    RadicalEntity parentObject = this.getRadicalEntity(designContent);
                    if (parentObject == null) continue;
                    String designId = MetadataService.getId((String)path, (String)"", (String)proxyObject.getProxyName(), (String)"", (String)proxyObject.eClass().getName().toLowerCase());
                    MAFResolver.getInstance().getMAFRegistry().put(designId, parentObject);
                    return;
                }
                catch (TeamRepositoryException teamRepositoryException) {}
            }
        }
    }

    private Map<String, PTPath> getRetainedPaths(String streamID) {
        HashMap<String, PTPath> retainedPaths = new HashMap<String, PTPath>();
        Map<String, Map<String, PTPath>> byLocationPaths = this._advancedSearchResult.getByStreamPaths().get(streamID);
        if (byLocationPaths != null) {
            for (Map<String, PTPath> paths : byLocationPaths.values()) {
                for (PTPath path : paths.values()) {
                    if (!this.isPathRetained(path)) continue;
                    retainedPaths.put(path.getProjectName(), path);
                }
            }
        }
        return retainedPaths;
    }

    private boolean isPathRetained(PTPath path) {
        boolean retain = false;
        if (this.getSearchPattern()._domain.length() > 0 && !path.getDomainCriterion().contains(this.getSearchPattern()._domain)) {
            return false;
        }
        int level = path.getLevel();
        if (level < this.getSearchPattern()._level) {
            if (this.getSearchPattern()._levelOperand.equals("<") || this.getSearchPattern()._levelOperand.equals("<=")) {
                retain = true;
            }
        } else if (level == this.getSearchPattern()._level) {
            if (this.getSearchPattern()._levelOperand.equals("<=") || this.getSearchPattern()._levelOperand.equals("=") || this.getSearchPattern()._levelOperand.equals(">=")) {
                retain = true;
            }
        } else if (level > this.getSearchPattern()._level && (this.getSearchPattern()._levelOperand.equals(">") || this.getSearchPattern()._levelOperand.equals(">="))) {
            retain = true;
        }
        return retain;
    }
}

