/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.server.plugin;

import com.ibm.pdp.util.Util;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class PacServerPlugin
extends AbstractUIPlugin {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String _ID = "com.ibm.pdp.pac.server";
    private static PacServerPlugin _plugin;
    private static URL _iconsFolderURL;
    private Map<String, Image> _images = new HashMap<String, Image>();
    private Map<String, ImageDescriptor> _descriptors = new HashMap<String, ImageDescriptor>();
    private List<ISearchResult> _serverSearchInResults = new ArrayList<ISearchResult>();

    public PacServerPlugin() {
        _plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static PacServerPlugin getDefault() {
        return _plugin;
    }

    public static URL getIconsFolderURL() {
        if (_iconsFolderURL == null) {
            _iconsFolderURL = PacServerPlugin.getDefault().getBundle().getEntry("/");
        }
        return _iconsFolderURL;
    }

    public Image getImage(String key) {
        Image image = this._images.get(key);
        if (image == null) {
            ImageDescriptor descriptor = this.getImageDescriptor(key);
            image = descriptor.createImage();
            this._images.put(key, image);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor imgDescriptor = this._descriptors.get(key);
        if (imgDescriptor == null) {
            try {
                URL gifImageURL = new URL(PacServerPlugin.getIconsFolderURL(), "icons/" + key + ".gif");
                imgDescriptor = ImageDescriptor.createFromURL((URL)gifImageURL);
                this._descriptors.put(key, imgDescriptor);
            }
            catch (MalformedURLException e) {
                throw Util.rethrow((Throwable)e);
            }
        }
        return imgDescriptor;
    }

    public static List<ISearchResult> getSearchInResults() {
        return PacServerPlugin.getDefault()._serverSearchInResults;
    }
}

