/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.server.page;

import com.ibm.pdp.explorer.model.PTMessageManager;
import com.ibm.pdp.explorer.model.PTModelManager;
import com.ibm.pdp.explorer.model.pattern.IPTInternalSearchPattern;
import com.ibm.pdp.explorer.model.result.IPTInternalSearchResult;
import com.ibm.pdp.explorer.model.tool.PTProjectCriterion;
import com.ibm.pdp.explorer.page.PTAsyncJob;
import com.ibm.pdp.explorer.plugin.IPTAdvancedSearchPattern;
import com.ibm.pdp.explorer.view.PTViewLabel;
import com.ibm.pdp.explorer.view.service.PTWidgetTool;
import com.ibm.pdp.maf.rpp.util.impl.MAFResolver;
import com.ibm.pdp.mdl.meta.path.PTPath;
import com.ibm.pdp.pac.explorer.model.PacModelManager;
import com.ibm.pdp.pac.explorer.page.PacAbstractDesignAdvancedSearchPage;
import com.ibm.pdp.pac.explorer.page.PacPageLabel;
import com.ibm.pdp.pac.server.pattern.PacServerDesignAdvancedSearchPattern;
import com.ibm.pdp.pac.server.query.PacServerDesignAdvancedSearchQuery;
import com.ibm.pdp.pac.server.result.PacServerDesignAdvancedSearchResult;
import com.ibm.pdp.server.core.IPTServerPreferences;
import com.ibm.pdp.server.core.PTServerCoreLabel;
import com.ibm.pdp.server.core.adapter.PTServerDesignSearchPageAdapter;
import com.ibm.pdp.server.page.PTServerPageLabel;
import com.ibm.pdp.server.page.PTServerPreferencePage;
import com.ibm.pdp.server.repository.PTRepositoryManager;
import com.ibm.pdp.server.view.PTServerDesignSearchView;
import com.ibm.pdp.util.Util;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IWorkspace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class PacServerDesignAdvancedSearchPage
extends PacAbstractDesignAdvancedSearchPage
implements IPTServerPreferences {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String _PAGE_ID = String.valueOf(PacServerDesignAdvancedSearchPage.class.getName()) + "_ID";
    private Button _rdbAllStreams;
    private Button _rdbStream;
    private Combo _cbbStream;
    private Map<String, IWorkspace> _streams;
    private Map<String, String> _streamDisplayNames;
    private Map<String, Set<PTProjectCriterion>> _byStreamProjects = null;
    private Map<String, SortedSet<String>> _byStreamLocations = null;

    protected String getContextId() {
        return "com.ibm.pdp.doc.cshelp.server_advanced_search";
    }

    protected void createAllGroup(Composite composite) {
        super.createAllGroup(composite);
        this.createServerScopeGroup(composite);
        this.createMessageComposite(composite);
    }

    private void createServerScopeGroup(Composite parent) {
        String groupLabel = PTServerPageLabel.getString((String)PTServerPageLabel._SERVER_SCOPE);
        Group group = PTWidgetTool.createGroup((Composite)parent, (int)2, (int)2, (String)groupLabel);
        String rdbLabel = PTServerPageLabel.getString((String)PTServerPageLabel._ALL_STREAMS);
        this._rdbAllStreams = PTWidgetTool.createRadioButton((Composite)group, (String)rdbLabel, (boolean)false, (int)2);
        rdbLabel = PTServerPageLabel.getString((String)PTServerPageLabel._STREAM);
        this._rdbStream = PTWidgetTool.createRadioButton((Composite)group, (String)rdbLabel, (boolean)false);
        this._rdbStream.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PacServerDesignAdvancedSearchPage.this._cbbStream.setEnabled(PacServerDesignAdvancedSearchPage.this._rdbStream.getSelection());
                Set<Object> projectRoots = new HashSet<PTProjectCriterion>();
                if (PacServerDesignAdvancedSearchPage.this._rdbStream.getSelection()) {
                    projectRoots = PacServerDesignAdvancedSearchPage.this.getProjectRoots(PacServerDesignAdvancedSearchPage.this.getStreamID());
                } else {
                    projectRoots.add(new PTProjectCriterion(PTServerPageLabel.getString((String)PTServerPageLabel._ALL_PROJECTS), "", ""));
                }
                PacServerDesignAdvancedSearchPage.this._cbtrvProjects.setInput(projectRoots);
                PacServerDesignAdvancedSearchPage.this._cbtrvProjects.expandAll();
                PacServerDesignAdvancedSearchPage.this.setProjectsCheckState(true);
                if (PacServerDesignAdvancedSearchPage.this._rdbStream.getSelection()) {
                    PacServerDesignAdvancedSearchPage.this.refreshLocation(PacServerDesignAdvancedSearchPage.this._cbbLocation.getText(), PacServerDesignAdvancedSearchPage.this.getLocations(PacServerDesignAdvancedSearchPage.this.getStreamID()));
                } else {
                    PacServerDesignAdvancedSearchPage.this.refreshLocation(PacServerDesignAdvancedSearchPage.this._cbbLocation.getText(), PacServerDesignAdvancedSearchPage.this.getLocations(null));
                }
                PacServerDesignAdvancedSearchPage.this._container.setPerformActionEnabled(PacServerDesignAdvancedSearchPage.this.isPageComplete());
            }
        });
        this._cbbStream = PTWidgetTool.createCombo((Composite)group);
        this._cbbStream.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String streamID = PacServerDesignAdvancedSearchPage.this.getStreamID();
                Set projectRoots = PacServerDesignAdvancedSearchPage.this.getProjectRoots(streamID);
                PacServerDesignAdvancedSearchPage.this._cbtrvProjects.setInput((Object)projectRoots);
                PacServerDesignAdvancedSearchPage.this._cbtrvProjects.expandAll();
                PacServerDesignAdvancedSearchPage.this.setProjectsCheckState(true);
                PacServerDesignAdvancedSearchPage.this.refreshLocation(PacServerDesignAdvancedSearchPage.this._cbbLocation.getText(), PacServerDesignAdvancedSearchPage.this.getLocations(PacServerDesignAdvancedSearchPage.this.getStreamID()));
                PacServerDesignAdvancedSearchPage.this._container.setPerformActionEnabled(PacServerDesignAdvancedSearchPage.this.isPageComplete());
            }
        });
    }

    protected List<IPTInternalSearchResult> getAdvancedSearchResults() {
        ArrayList<IPTInternalSearchResult> advancedSearchResults = new ArrayList<IPTInternalSearchResult>();
        for (IPTInternalSearchResult searchResult : PTModelManager.getServerDesignSearchResults()) {
            if (!(searchResult instanceof PacServerDesignAdvancedSearchResult)) continue;
            advancedSearchResults.add(searchResult);
        }
        return advancedSearchResults;
    }

    protected void setupData() {
        super.setupData();
        List<IPTInternalSearchResult> advancedSearchResults = this.getAdvancedSearchResults();
        if (advancedSearchResults.isEmpty()) {
            this._cbbDisplayName.select(0);
            List list = PacModelManager.getAdvancedSearchPatterns((String)this.getDesignType());
            this._tblSearchPatterns.setInput((Object)list);
            this._tblSearchPatterns.getTable().select(0);
            Object searchPattern = (IPTAdvancedSearchPattern)list.get(0);
            this.showPage((IPTAdvancedSearchPattern)searchPattern);
            PacServerDesignAdvancedSearchPattern advancedSearchPattern = new PacServerDesignAdvancedSearchPattern(this.getLocation());
            advancedSearchPattern._designType = this.getDesignType();
            advancedSearchPattern.setSearchPatternId(this.getSearchPatternId());
            advancedSearchPattern._searchPatternKind = this.getSearchPatternKind();
            advancedSearchPattern._expression = this._prefs.get("_PREF_SERVER_ADVANCED_SEARCH_EXPRESSION", advancedSearchPattern._expression);
            advancedSearchPattern._caseSensitive = this._prefs.getBoolean("_PREF_SERVER_ADVANCED_SEARCH_CASE_SENSITIVE", advancedSearchPattern._caseSensitive);
            advancedSearchPattern._value = this._prefs.getInt("_PREF_SERVER_ADVANCED_SEARCH_VALUE", advancedSearchPattern._value);
            advancedSearchPattern._operand = this._prefs.get("_PREF_SERVER_ADVANCED_SEARCH_OPERAND", advancedSearchPattern._operand);
            advancedSearchPattern._flip = this._prefs.getBoolean("_PREF_SERVER_ADVANCED_SEARCH_FLIP", advancedSearchPattern._flip);
            advancedSearchPattern._locationScope = this._prefs.getInt("_PREF_SERVER_ADVANCED_SEARCH_LOCATION_SCOPE", advancedSearchPattern._locationScope);
            advancedSearchPattern._locationName = this._prefs.get("_PREF_SERVER_ADVANCED_SEARCH_LOCATION", "");
            advancedSearchPattern._domain = this._prefs.get("_PREF_SERVER_ADVANCED_SEARCH_DOMAIN", "");
            advancedSearchPattern._levelOperand = this._prefs.get("_PREF_SERVER_ADVANCED_SEARCH_LEVEL_OPERAND", ">=");
            advancedSearchPattern._level = this._prefs.getInt("_PREF_SERVER_ADVANCED_SEARCH_LEVEL", 0);
            advancedSearchPattern._streamScope = this._prefs.getInt("_PREF_SERVER_ADVANCED_SEARCH_STREAM_SCOPE", advancedSearchPattern._streamScope);
            advancedSearchPattern._streamID = this._prefs.get("_PREF_SERVER_ADVANCED_SEARCH_STREAM", advancedSearchPattern._streamID);
            this._advancedSearchPattern = advancedSearchPattern;
        } else {
            for (IPTInternalSearchResult iPTInternalSearchResult : advancedSearchResults) {
                PacServerDesignAdvancedSearchPattern advancedSearchPattern = (PacServerDesignAdvancedSearchPattern)iPTInternalSearchResult.getSearchPattern();
                if ("STRING".equals(advancedSearchPattern._searchPatternKind)) {
                    this._cbbExpression.add(advancedSearchPattern._expression);
                    continue;
                }
                if (!"INTEGER".equals(advancedSearchPattern._searchPatternKind)) continue;
                this._cbbValue.add(Integer.toString(advancedSearchPattern._value));
            }
            this._advancedSearchPattern = new PacServerDesignAdvancedSearchPattern((PacServerDesignAdvancedSearchPattern)advancedSearchResults.get(0).getSearchPattern());
            for (Map.Entry entry : this.getByDisplayNameFolders().entrySet()) {
                if (!((String)entry.getValue()).equals(this._advancedSearchPattern._designType)) continue;
                int index = this._cbbDisplayName.indexOf((String)entry.getKey());
                this._cbbDisplayName.select(index);
                break;
            }
            List list = PacModelManager.getAdvancedSearchPatterns((String)this.getDesignType());
            this._tblSearchPatterns.setInput((Object)list);
            for (Object searchPattern : list) {
                if (!searchPattern.getId().equals(this._advancedSearchPattern.getSearchPatternId())) continue;
                this._tblSearchPatterns.setSelection((ISelection)new StructuredSelection(searchPattern));
                break;
            }
        }
        this._ckbCaseSensitive.setSelection(this._advancedSearchPattern._caseSensitive);
        this._cbbOperand.setText(this._advancedSearchPattern._levelOperand);
        if (this._advancedSearchPattern._flip) {
            this._cbbFlip.setText(PacPageLabel._IS_NOT);
        } else {
            this._cbbFlip.setText(PacPageLabel._IS);
        }
        this._checkingMode = this._prefs.getInt("_PREF_SERVER_ADVANCED_SEARCH_CHECKING_MODE", 0);
        String string = this._prefs.get("_PREF_SERVER_ADVANCED_SEARCH_CHECKED_PROJECTS", "");
        String[] stringArray = string.split(";");
        int n = stringArray.length;
        int index = 0;
        while (index < n) {
            String checkedProject = stringArray[index];
            if (checkedProject.length() > 0) {
                this._advancedSearchPattern._checkedProjects.add(checkedProject);
            }
            ++index;
        }
        this._cbbLocation.setText(this._advancedSearchPattern._locationName);
        TreeSet<String> displayNames = new TreeSet<String>();
        for (IWorkspace workspace : this.getDesignStreams().values()) {
            displayNames.add(PTRepositoryManager.getStreamDisplayName((IWorkspace)workspace));
        }
        for (String displayName : displayNames) {
            this._cbbStream.add(displayName);
        }
    }

    private Map<String, IWorkspace> getDesignStreams() {
        if (this._streams == null) {
            this._streams = PTRepositoryManager.getWorkspaces((ITeamRepository)this.getTeamRepository());
            Job internJob = new Job("PTServerDesignSearchPage#getDesignStreams Job..."){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        PacServerDesignAdvancedSearchPage.this._streams = PTServerDesignSearchPageAdapter.retrieveDesignStreams((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (TeamRepositoryException teamRepositoryException) {}
                    return Status.OK_STATUS;
                }
            };
            internJob.setUser(false);
            internJob.schedule();
            try {
                internJob.join();
            }
            catch (InterruptedException e) {
                throw Util.rethrow((Throwable)e);
            }
        }
        return this._streams;
    }

    private Set<PTProjectCriterion> getProjectRoots(final String streamID) {
        Set projectRoots;
        if (streamID == null || streamID.length() == 0) {
            return Collections.emptySet();
        }
        ITeamRepository teamRepository = PTRepositoryManager.getTeamRepository();
        if (teamRepository == null) {
            return Collections.emptySet();
        }
        if (this._byStreamProjects == null) {
            this._byStreamProjects = new HashMap<String, Set<PTProjectCriterion>>();
        }
        if ((projectRoots = this._byStreamProjects.get(streamID)) == null) {
            final ArrayList paths = new ArrayList();
            Job internJob = new Job("PTServerDesignSearchPage#getProjectRoots Job..."){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        paths.addAll(PTServerDesignSearchPageAdapter.retrieveProjectRoots((String)streamID, (IProgressMonitor)monitor));
                    }
                    catch (TeamRepositoryException teamRepositoryException) {}
                    return Status.OK_STATUS;
                }
            };
            internJob.setUser(false);
            internJob.schedule();
            try {
                internJob.join();
            }
            catch (InterruptedException e) {
                throw Util.rethrow((Throwable)e);
            }
            HashMap<String, PTProjectCriterion> allProjects = new HashMap<String, PTProjectCriterion>();
            HashMap<String, List> allRequires = new HashMap<String, List>();
            for (PTPath path : paths) {
                allProjects.put(path.getProjectName(), new PTProjectCriterion(path.getProjectName(), path.getLocationName(), path.getOrganization()));
                allRequires.put(path.getProjectName(), path.getRequires());
            }
            projectRoots = this.organizeRoots(allProjects, allRequires);
            this._byStreamProjects.put(streamID, projectRoots);
        }
        return projectRoots;
    }

    private Set<String> getLocations(final String streamID) {
        Set<PTProjectCriterion> projects;
        String streamKey;
        SortedSet<String> locations;
        ITeamRepository teamRepository = PTRepositoryManager.getTeamRepository();
        if (teamRepository == null) {
            return Collections.emptySet();
        }
        if (this._byStreamLocations == null) {
            this._byStreamLocations = new HashMap<String, SortedSet<String>>();
        }
        if ((locations = this._byStreamLocations.get(streamKey = streamID == null ? "" : streamID)) != null) {
            return locations;
        }
        if (this._byStreamProjects != null && (projects = this._byStreamProjects.get(streamID)) != null) {
            locations = new TreeSet<String>();
            for (PTProjectCriterion project : projects) {
                locations.add(project.getLocation());
            }
            this._byStreamLocations.put(streamID, locations);
            return locations;
        }
        final ArrayList paths = new ArrayList();
        Job internJob = new Job("PTServerDesignSearchPage#getLocations Job..."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    paths.addAll(PTServerDesignSearchPageAdapter.retrieveLocations((String)streamID, (IProgressMonitor)monitor));
                }
                catch (TeamRepositoryException teamRepositoryException) {}
                return Status.OK_STATUS;
            }
        };
        internJob.setUser(false);
        internJob.schedule();
        try {
            internJob.join();
        }
        catch (InterruptedException e) {
            throw Util.rethrow((Throwable)e);
        }
        TreeSet<String> allLocations = new TreeSet<String>();
        for (PTPath path : paths) {
            locations = this._byStreamLocations.get(path.getStreamID());
            if (locations == null) {
                locations = new TreeSet<String>();
                this._byStreamLocations.put(path.getStreamID(), locations);
            }
            allLocations.add(path.getLocationName());
            locations.add(path.getLocationName());
        }
        this._byStreamLocations.put("", allLocations);
        locations = this._byStreamLocations.get(streamKey);
        if (locations == null) {
            locations = new TreeSet<String>();
        }
        return locations;
    }

    protected void refresh() {
        super.refresh();
        PacServerDesignAdvancedSearchPattern advancedSearchPattern = (PacServerDesignAdvancedSearchPattern)this._advancedSearchPattern;
        boolean all = advancedSearchPattern._streamScope == 0;
        this._rdbAllStreams.setSelection(all);
        this._rdbStream.setSelection(!all);
        this._cbbStream.setEnabled(!all);
        IWorkspace workspace = this.getDesignStreams().get(advancedSearchPattern._streamID);
        int index = this._cbbStream.indexOf(PTRepositoryManager.getStreamDisplayName((IWorkspace)workspace));
        if (index < 0 && this._cbbStream.getItemCount() > 0) {
            index = 0;
        }
        this._cbbStream.select(index);
        Set<PTProjectCriterion> projectRoots = new HashSet<PTProjectCriterion>();
        if (this._rdbStream.getSelection()) {
            projectRoots = this.getProjectRoots(this.getStreamID());
        } else {
            projectRoots.add(new PTProjectCriterion(PTServerPageLabel.getString((String)PTServerPageLabel._ALL_PROJECTS), "", ""));
        }
        this._cbtrvProjects.setInput(projectRoots);
        this._cbtrvProjects.expandAll();
        this.setProjectsCheckState(true);
        if (this._rdbStream.getSelection()) {
            this.refreshLocation(this._cbbLocation.getText(), this.getLocations(this.getStreamID()));
        } else {
            this.refreshLocation(this._cbbLocation.getText(), this.getLocations(null));
        }
        this._container.setPerformActionEnabled(this.isPageComplete());
    }

    protected boolean isPageComplete() {
        if (!super.isPageComplete()) {
            return false;
        }
        return !this._rdbStream.getSelection() || this._cbbStream.getText() != null && this._cbbStream.getText().length() != 0;
    }

    public boolean performAction() {
        if (!PTModelManager.checkLicense()) {
            return true;
        }
        ITeamRepository teamRepository = PTRepositoryManager.getTeamRepository();
        if (teamRepository != null) {
            if (!PTRepositoryManager.checkQueryCompatibility((ITeamRepository)teamRepository, (boolean)true)) {
                return true;
            }
            Job[] jobs = Job.getJobManager().find((Object)"RPP_FAMILY");
            if (jobs.length > 0) {
                PTMessageManager.handleWarning((String)PTServerPageLabel.getString((String)PTServerPageLabel._SERVER_TASK_IN_PROGRESS));
                return true;
            }
            final PacServerDesignAdvancedSearchQuery advancedSearchQuery = this.newQuery();
            PTAsyncJob searchJob = new PTAsyncJob(advancedSearchQuery.getLabel()){

                protected IStatus run(IProgressMonitor monitor) {
                    Status[] status;
                    block7: {
                        status = new Status[]{new Status(0, "org.eclipse.ui", 0, "", null)};
                        try {
                            try {
                                MAFResolver.getInstance().setMAFResolvingMode(1);
                                MAFResolver.getInstance().getMAFPaths().clear();
                                MAFResolver.getInstance().getMAFRegistry().clear();
                                status[0] = advancedSearchQuery.run(monitor);
                            }
                            catch (OperationCanceledException e) {
                                PTMessageManager.asyncHandleError((String)e.getMessage());
                                MAFResolver.getInstance().setMAFResolvingMode(0);
                                MAFResolver.getInstance().getMAFPaths().clear();
                                MAFResolver.getInstance().getMAFRegistry().clear();
                                break block7;
                            }
                        }
                        catch (Throwable throwable) {
                            MAFResolver.getInstance().setMAFResolvingMode(0);
                            MAFResolver.getInstance().getMAFPaths().clear();
                            MAFResolver.getInstance().getMAFRegistry().clear();
                            throw throwable;
                        }
                        MAFResolver.getInstance().setMAFResolvingMode(0);
                        MAFResolver.getInstance().getMAFPaths().clear();
                        MAFResolver.getInstance().getMAFRegistry().clear();
                    }
                    List searchResults = PTModelManager.getServerDesignSearchResults();
                    int i = 0;
                    while (i < searchResults.size()) {
                        IPTInternalSearchPattern searchPattern = ((IPTInternalSearchResult)searchResults.get(i)).getSearchPattern();
                        if (searchPattern != null && searchPattern.getName().equals(PacServerDesignAdvancedSearchPage.this._advancedSearchPattern.getName())) {
                            PTModelManager.getServerDesignSearchResults().remove(i);
                            break;
                        }
                        ++i;
                    }
                    searchResults.add(0, (IPTInternalSearchResult)advancedSearchQuery.getSearchResult());
                    PacServerDesignAdvancedSearchPage.this.updatePreferences();
                    Display.getDefault().asyncExec(new Runnable((IStatus[])status){
                        private final /* synthetic */ IStatus[] val$status;
                        {
                            this.val$status = iStatusArray;
                        }

                        @Override
                        public void run() {
                            PTServerDesignSearchView searchView = PTServerDesignSearchView.openInActivePerspective();
                            searchView.setInput((Object)advancedSearchQuery.getSearchResult());
                            String dialogTitle = PTViewLabel.getString((String)PTViewLabel._SEARCH_ERROR_TITLE);
                            if (this.val$status[0] instanceof MultiStatus) {
                                if (((MultiStatus)this.val$status[0]).getChildren().length > 0) {
                                    PTMessageManager.handleErrors((String)dialogTitle, (MultiStatus)((MultiStatus)this.val$status[0]));
                                }
                            } else if (!this.val$status[0].isOK() && this.val$status[0].getMessage().length() > 0) {
                                PTMessageManager.handleWarning((String)dialogTitle, (String)this.val$status[0].getMessage());
                            }
                        }
                    });
                    monitor.done();
                    return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
                }
            };
            searchJob.setPriority(10);
            searchJob.setUser(true);
            searchJob.schedule();
        }
        return true;
    }

    private ITeamRepository getTeamRepository() {
        ITeamRepository teamRepository = PTRepositoryManager.getTeamRepository();
        if (teamRepository == null) {
            if (PTRepositoryManager.getLoggedRepositories().size() > 0) {
                String preferencePageId = PTServerPreferencePage._ID;
                String[] displayedIds = new String[]{preferencePageId};
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)preferencePageId, (String[])displayedIds, null);
                dialog.open();
                teamRepository = PTRepositoryManager.getTeamRepository();
            } else {
                String message = PTServerCoreLabel.getString((String)PTServerCoreLabel._NO_LOGGED_REPOSITORY_MORE);
                PTMessageManager.handleWarning((String)message);
            }
        }
        return teamRepository;
    }

    private PacServerDesignAdvancedSearchQuery newQuery() {
        PacServerDesignAdvancedSearchPattern advancedSearchPattern = new PacServerDesignAdvancedSearchPattern(this.getLocation());
        this.updateAdvancedSearchPattern(advancedSearchPattern);
        advancedSearchPattern._streamScope = this.getStreamScope();
        advancedSearchPattern._streamID = this.getStreamID();
        advancedSearchPattern._streamIDs = this.getStreamDisplayNames();
        return new PacServerDesignAdvancedSearchQuery((PacServerDesignAdvancedSearchPattern)this._advancedSearchPattern, this.getDesignStreams());
    }

    private int getStreamScope() {
        int streamScope = 1;
        if (this._rdbAllStreams.getSelection()) {
            return 0;
        }
        return streamScope;
    }

    private String getStreamID() {
        String displayName = this._cbbStream.getText();
        for (String streamID : this.getDesignStreams().keySet()) {
            IWorkspace workspace = this.getDesignStreams().get(streamID);
            if (!PTRepositoryManager.getStreamDisplayName((IWorkspace)workspace).equals(displayName)) continue;
            return streamID;
        }
        return "";
    }

    private Map<String, String> getStreamDisplayNames() {
        if (this._streamDisplayNames == null) {
            this._streamDisplayNames = new HashMap<String, String>();
            for (String streamID : this.getDesignStreams().keySet()) {
                IWorkspace workspace = this.getDesignStreams().get(streamID);
                this._streamDisplayNames.put(streamID, PTRepositoryManager.getStreamDisplayName((IWorkspace)workspace));
            }
        }
        return this._streamDisplayNames;
    }

    private void updatePreferences() {
        this._prefs.put("_PREF_SERVER_ADVANCED_SEARCH_EXPRESSION", this._advancedSearchPattern._expression);
        this._prefs.putBoolean("_PREF_SERVER_ADVANCED_SEARCH_CASE_SENSITIVE", this._advancedSearchPattern._caseSensitive);
        this._prefs.putInt("_PREF_SERVER_ADVANCED_SEARCH_VALUE", this._advancedSearchPattern._value);
        this._prefs.put("_PREF_SERVER_ADVANCED_SEARCH_OPERAND", this._advancedSearchPattern._operand);
        this._prefs.putBoolean("_PREF_SERVER_ADVANCED_SEARCH_FLIP", this._advancedSearchPattern._flip);
        this._prefs.putInt("_PREF_SERVER_ADVANCED_SEARCH_CHECKING_MODE", this.getCheckingMode());
        StringBuilder encodedCheckedProjects = new StringBuilder();
        for (String checkedProject : this._advancedSearchPattern._checkedProjects) {
            encodedCheckedProjects.append(checkedProject).append(";");
        }
        this._prefs.put("_PREF_SERVER_ADVANCED_SEARCH_CHECKED_PROJECTS", encodedCheckedProjects.toString());
        this._prefs.putInt("_PREF_SERVER_ADVANCED_SEARCH_LOCATION_SCOPE", this._advancedSearchPattern._locationScope);
        this._prefs.put("_PREF_SERVER_ADVANCED_SEARCH_LOCATION", this._advancedSearchPattern._locationName);
        this._prefs.put("_PREF_SERVER_ADVANCED_SEARCH_DOMAIN", this._advancedSearchPattern._domain);
        this._prefs.put("_PREF_SERVER_ADVANCED_SEARCH_LEVEL_OPERAND", this._advancedSearchPattern._levelOperand);
        this._prefs.putInt("_PREF_SERVER_ADVANCED_SEARCH_LEVEL", this._advancedSearchPattern._level);
        this._prefs.putInt("_PREF_SERVER_ADVANCED_SEARCH_STREAM_SCOPE", ((PacServerDesignAdvancedSearchPattern)this._advancedSearchPattern)._streamScope);
        this._prefs.put("_PREF_SERVER_ADVANCED_SEARCH_STREAM", ((PacServerDesignAdvancedSearchPattern)this._advancedSearchPattern)._streamID);
    }
}

