/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.server.action;

import com.ibm.pdp.explorer.view.service.IPTView;
import com.ibm.pdp.pac.explorer.action.PacShowMatchesAction;
import com.ibm.pdp.pac.explorer.model.PacSearchInDetail;
import com.ibm.pdp.pac.server.action.PacServerSearchDetailsTask;
import com.ibm.pdp.pac.server.action.PacServerShowDetailsAction;
import com.ibm.pdp.pac.server.model.PacServerSearchInFile;
import com.ibm.pdp.pac.server.result.PacServerSearchInResult;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Shell;

public class PacServerShowMatchesAction
extends PacShowMatchesAction {
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2013.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String _ID = String.valueOf(PacServerShowMatchesAction.class.getName()) + "_ID";
    private PacServerSearchInResult _searchResult;

    public PacServerShowMatchesAction(IPTView view, int direction) {
        super(view, direction);
    }

    public void run() {
        Object input;
        Shell shell = this._view.getShell();
        shell.setCursor(new Cursor((Device)shell.getDisplay(), 1));
        Object current = null;
        IStructuredSelection selection = this._view.getStructuredSelection();
        if (!selection.isEmpty()) {
            current = selection.getFirstElement();
        }
        if ((input = this._view.getInput()) instanceof PacServerSearchInResult) {
            this._searchResult = (PacServerSearchInResult)((Object)input);
            boolean next = this._direction == 0;
            Object matchObject = this._searchResult.getMatchObject(current, next);
            PacSearchInDetail matchDetail = null;
            if (matchObject instanceof PacServerSearchInFile) {
                PacServerSearchInFile matchFile = (PacServerSearchInFile)((Object)matchObject);
                PacServerSearchDetailsTask task = new PacServerSearchDetailsTask(this._view.getTreeViewer(), this._searchResult, matchFile);
                task.syncExec();
                if (next) {
                    if (matchFile.getChildren().size() > 0) {
                        matchDetail = (PacSearchInDetail)matchFile.getChildren().firstEntry().getValue();
                        this._searchResult.setMatchDetail(matchDetail);
                        this._searchResult.setMatchOffset((Integer)matchDetail.getOffsets().firstKey());
                    }
                } else if (matchFile.getChildren().size() > 0) {
                    matchDetail = (PacSearchInDetail)matchFile.getChildren().lastEntry().getValue();
                    this._searchResult.setMatchDetail(matchDetail);
                    this._searchResult.setMatchOffset((Integer)matchDetail.getOffsets().lastKey());
                }
            } else if (matchObject instanceof PacSearchInDetail) {
                matchDetail = (PacSearchInDetail)matchObject;
            }
            if (matchDetail != null) {
                this._view.getTreeViewer().expandToLevel((Object)matchDetail.getParent(), 1);
                this._view.setStructuredSelection((IStructuredSelection)new StructuredSelection((Object)matchDetail));
                PacServerShowDetailsAction showDetailsAction = new PacServerShowDetailsAction(this._view);
                showDetailsAction.run(matchDetail, this._searchResult.getMatchOffset());
            }
        }
        shell.setCursor(null);
    }
}

