/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.server.action;

import com.ibm.pdp.explorer.editor.IPTStorageEditorInput;
import com.ibm.pdp.explorer.model.PTMessageManager;
import com.ibm.pdp.explorer.plugin.PTExplorerPlugin;
import com.ibm.pdp.explorer.view.PTViewLabel;
import com.ibm.pdp.explorer.view.action.PTViewAction;
import com.ibm.pdp.explorer.view.service.IPTView;
import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.pac.explorer.model.PacSearchInDetail;
import com.ibm.pdp.pac.server.model.PacServerSearchInFile;
import com.ibm.pdp.pac.server.result.PacServerSearchInResult;
import com.ibm.pdp.server.common.IPTServerConstants;
import com.ibm.pdp.server.editor.PTRemoteInputFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;

public class PacServerShowDetailsAction
extends PTViewAction
implements IPTServerConstants {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String _ID = String.valueOf(PacServerShowDetailsAction.class.getName()) + "_ID";
    private PacServerSearchInFile _file;
    private PacSearchInDetail _detail;
    private int _offset = -1;
    private IPTStorageEditorInput _editorInput;

    public PacServerShowDetailsAction(IPTView view) {
        super(view);
        this.setText(PTViewLabel.getString((String)PTViewLabel._OPEN));
        this.setToolTipText(this.getText());
    }

    public void run() {
        Shell shell = this._view.getShell();
        shell.setCursor(new Cursor((Device)shell.getDisplay(), 1));
        IStructuredSelection selection = this._view.getStructuredSelection();
        if (selection.size() == 1) {
            Object selectedObject = selection.getFirstElement();
            if (selectedObject instanceof PacServerSearchInFile) {
                if (this.getFile() != selectedObject) {
                    this.reset();
                    this._file = (PacServerSearchInFile)((Object)selectedObject);
                }
                if (this.getFile() != null) {
                    this.showDetails();
                }
                this._view.getTreeViewer().getControl().setFocus();
            } else if (selectedObject instanceof PacSearchInDetail) {
                PacSearchInDetail matchDetail = (PacSearchInDetail)selectedObject;
                int offset = (Integer)matchDetail.getOffsets().firstKey();
                if (this._view.getInput() instanceof PacServerSearchInResult) {
                    PacServerSearchInResult searchResult = (PacServerSearchInResult)((Object)this._view.getInput());
                    searchResult.setMatchDetail(matchDetail);
                    searchResult.setMatchOffset((Integer)matchDetail.getOffsets().firstKey());
                }
                this.run(matchDetail, offset);
            }
        }
        shell.setCursor(null);
    }

    public void run(PacSearchInDetail detail, int offset) {
        Shell shell = this._view.getShell();
        shell.setCursor(new Cursor((Device)shell.getDisplay(), 1));
        if (this.getFile() != detail.getParent()) {
            this.reset();
            this._file = (PacServerSearchInFile)detail.getParent();
        }
        this._detail = detail;
        this._offset = offset;
        if (this.getFile() != null) {
            this.showDetails();
        }
        this._view.getTreeViewer().getControl().setFocus();
        shell.setCursor(null);
    }

    private void showDetails() {
        Document metaDocument = this.getFile().getDocument();
        String streamID = this.getFile().getProject().getStreamID();
        String componentID = this.getFile().getProject().getComponentID();
        IWorkbenchWindow workbench = PTExplorerPlugin.getActiveWorkbenchWindow();
        String editorID = PTExplorerPlugin.getDefault().getEditorID(metaDocument.getType());
        if (this._editorInput == null) {
            PTRemoteInputFactory inputFactory = new PTRemoteInputFactory(streamID, componentID, metaDocument);
            this._editorInput = inputFactory.getEditorInput(null, (IProgressMonitor)new NullProgressMonitor());
            if (this._editorInput == null) {
                return;
            }
        }
        IWorkbenchPage page = workbench.getActivePage();
        IEditorPart editor = null;
        try {
            int matchFlags = 3;
            editor = page.openEditor((IEditorInput)this._editorInput, editorID, true, matchFlags);
            if (editor instanceof ITextEditor) {
                ITextEditor textEditor = (ITextEditor)editor;
                if (this.getDetail() != null && this.getDetail().getOffsets().containsKey(this.getOffset())) {
                    int beginOffset = this.getOffset();
                    int endOffset = (Integer)this.getDetail().getOffsets().get(beginOffset);
                    textEditor.selectAndReveal(beginOffset, endOffset - beginOffset);
                } else {
                    textEditor.setHighlightRange(0, 0, true);
                }
            }
        }
        catch (Throwable e) {
            PTMessageManager.handleError(editor, (Throwable)e, (boolean)true);
        }
    }

    private PacServerSearchInFile getFile() {
        return this._file;
    }

    private PacSearchInDetail getDetail() {
        return this._detail;
    }

    private int getOffset() {
        return this._offset;
    }

    private void reset() {
        this._file = null;
        this._detail = null;
        this._offset = -1;
        this._editorInput = null;
    }
}

