/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.server.action;

import com.ibm.pdp.explorer.model.PTMessageManager;
import com.ibm.pdp.explorer.model.PTModelManager;
import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.mdl.pacbase.PacMacro;
import com.ibm.pdp.pac.explorer.dialog.PacSearchInDialog;
import com.ibm.pdp.pac.explorer.view.PacViewLabel;
import com.ibm.pdp.pac.server.pattern.PacServerSearchInPattern;
import com.ibm.pdp.pac.server.plugin.PacServerPlugin;
import com.ibm.pdp.pac.server.query.PacServerSearchInQuery;
import com.ibm.pdp.pac.server.result.PacServerSearchInResult;
import com.ibm.pdp.pac.server.view.PacServerSearchInView;
import com.ibm.pdp.pac.server.view.PacServerViewLabel;
import com.ibm.pdp.server.model.reference.PTServerReferenceItem;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.swt.widgets.Shell;

public class PacServerSearchInAction
extends Action {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String _ID = String.valueOf(PacServerSearchInAction.class.getName()) + "_ID";
    private Viewer _viewer;
    private Document _metaDocument;
    private String _streamID;
    private String _componentID;
    private String _searchInExpression;
    private PacServerSearchInQuery _searchInQuery;

    public PacServerSearchInAction(Viewer viewer, String streamID, String componentID, Document metaDocument) {
        this._viewer = viewer;
        this._metaDocument = metaDocument;
        this._streamID = streamID;
        this._componentID = componentID;
        this.setText(PacServerViewLabel.getString(PacServerViewLabel._SERVER_SEARCH_IN));
        this.setToolTipText(this.getText());
        this.setImageDescriptor(PacServerPlugin.getDefault().getImageDescriptor("serverSearchIn"));
    }

    public void run() {
        PTServerReferenceItem parentReference;
        Object selectedObject;
        Shell shell = this._viewer.getControl().getShell();
        String searchIn = null;
        IStructuredSelection selection = (IStructuredSelection)this._viewer.getSelection();
        if (selection.size() > 0 && (selectedObject = selection.getFirstElement()) instanceof PTServerReferenceItem && (parentReference = ((PTServerReferenceItem)selectedObject).getParent()) != null) {
            Document metaDocument = parentReference.getDocument();
            if (PTModelManager.accept((String)metaDocument.getType())) {
                if (metaDocument.getType().equals(PacMacro.class.getSimpleName().toLowerCase())) {
                    searchIn = String.valueOf(metaDocument.getName()) + "." + metaDocument.getType();
                }
            } else {
                searchIn = String.valueOf(metaDocument.getName()) + "." + metaDocument.getType();
            }
        }
        PacSearchInDialog dialog = new PacSearchInDialog(searchIn, shell);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            this._searchInExpression = dialog.getSearchIn();
            IRunnableWithProgress operation = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Object[] array = new String[]{PacServerSearchInAction.this._metaDocument.getName(), PacServerSearchInAction.this._searchInExpression};
                    monitor.beginTask(PacViewLabel.getString((String)PacViewLabel._SEARCH_IN_JOB, (Object[])array), -1);
                    PacServerSearchInAction.this._searchInQuery = PacServerSearchInAction.this.newQuery();
                    PacServerSearchInAction.this._searchInQuery.run(monitor);
                }
            };
            try {
                ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(shell);
                progressDialog.run(true, false, operation);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() != null) {
                    PTMessageManager.handleStackTrace((Throwable)e.getCause());
                } else {
                    PTMessageManager.handleStackTrace((Throwable)e);
                }
            }
            catch (InterruptedException e) {
                if (e.getCause() != null) {
                    PTMessageManager.handleStackTrace((Throwable)e.getCause());
                }
                PTMessageManager.handleStackTrace((Throwable)e);
            }
            List<ISearchResult> searchResults = PacServerPlugin.getSearchInResults();
            int i = 0;
            while (i < searchResults.size()) {
                PacServerSearchInResult searchResult = (PacServerSearchInResult)searchResults.get(i);
                PacServerSearchInPattern searchPattern = searchResult.getSearchPattern();
                if (searchPattern.getDocument().getId().equals(this._metaDocument.getId()) && searchPattern._expression.equals(this._searchInExpression)) {
                    searchResults.remove(i);
                    break;
                }
                ++i;
            }
            searchResults.add(0, this._searchInQuery.getSearchResult());
            PacServerSearchInView searchInView = PacServerSearchInView.openInActivePerspective();
            searchInView.setInput(this._searchInQuery.getSearchResult());
        }
    }

    private PacServerSearchInQuery newQuery() {
        PacServerSearchInPattern searchInPattern = new PacServerSearchInPattern(this._streamID, this._componentID, this._metaDocument);
        searchInPattern._expression = this._searchInExpression;
        searchInPattern._caseSensitive = false;
        return new PacServerSearchInQuery(searchInPattern);
    }
}

